/*
 * Decompiled with CFR 0.152.
 */
package datagraph.graph.explore;

import ghidra.graph.viewer.vertex.AbstractVisualVertex;
import java.awt.geom.Point2D;

public abstract class EgVertex
extends AbstractVisualVertex {
    protected EgVertex source;
    private boolean userChangedLocation = false;

    public EgVertex(EgVertex source) {
        this.source = source;
    }

    public EgVertex getSourceVertex() {
        return this.source;
    }

    public void dispose() {
    }

    public void setLocation(Point2D location) {
        if (this.userChangedLocation) {
            return;
        }
        super.setLocation(location);
    }

    public void setUserChangedLocation(Point2D location) {
        this.userChangedLocation = true;
        super.setLocation(location);
    }

    public void clearUserChangedLocation() {
        this.userChangedLocation = false;
    }

    public boolean hasUserChangedLocation() {
        return this.userChangedLocation;
    }

    public boolean isRoot() {
        return this.source == null;
    }

    protected void setSource(EgVertex source) {
        this.source = source;
    }

    protected abstract Point2D getStartingEdgePoint(EgVertex var1);

    protected abstract Point2D getEndingEdgePoint(EgVertex var1);

    protected int getOutgoingEdgeOffsetFromCenter(EgVertex end) {
        return 0;
    }

    protected int getIncomingEdgeOffsetFromCenter(EgVertex start) {
        return 0;
    }
}

