/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableUtils;
import ghidra.util.table.column.GColumnRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.table.TableColumnModel;

public class DefaultRowFilterTransformer<ROW_OBJECT>
implements RowFilterTransformer<ROW_OBJECT> {
    private List<String> columnData = new ArrayList<String>();
    private TableColumnModel columnModel;
    private final RowObjectTableModel<ROW_OBJECT> model;

    public DefaultRowFilterTransformer(RowObjectTableModel<ROW_OBJECT> tableModel, TableColumnModel columnModel) {
        this.model = tableModel;
        this.columnModel = columnModel;
    }

    @Override
    public List<String> transform(ROW_OBJECT rowObject) {
        this.columnData.clear();
        int columnCount = this.model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            String value = this.getStringValue(rowObject, col);
            if (value == null) continue;
            this.columnData.add(value);
        }
        return this.columnData;
    }

    protected String getStringValue(ROW_OBJECT rowObject, int column) {
        if (this.columnModel instanceof GTableColumnModel && !((GTableColumnModel)this.columnModel).isVisible(column)) {
            return null;
        }
        if (this.columnUsesConstraintFilteringOnly(column)) {
            return null;
        }
        return TableUtils.getTableCellStringValue(this.model, rowObject, column);
    }

    private boolean columnUsesConstraintFilteringOnly(int column) {
        if (!(this.model instanceof DynamicColumnTableModel)) {
            return false;
        }
        DynamicColumnTableModel columnBasedModel = (DynamicColumnTableModel)this.model;
        GColumnRenderer<Object> renderer = this.getColumnRenderer(columnBasedModel, column);
        if (renderer == null) {
            return false;
        }
        GColumnRenderer.ColumnConstraintFilterMode mode = renderer.getColumnConstraintFilterMode();
        return mode == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY;
    }

    private GColumnRenderer<Object> getColumnRenderer(DynamicColumnTableModel<ROW_OBJECT> columnBasedModel, int columnIndex) {
        DynamicTableColumn<ROW_OBJECT, ?, ?> column = columnBasedModel.getColumn(columnIndex);
        GColumnRenderer<Object> columnRenderer = column.getColumnRenderer();
        return columnRenderer;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRowFilterTransformer other = (DefaultRowFilterTransformer)obj;
        if (!Objects.equals(this.columnData, other.columnData)) {
            return false;
        }
        if (!Objects.equals(this.columnModel, other.columnModel)) {
            return false;
        }
        return this.model == other.model;
    }
}

