/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import generic.theme.GThemeDefaults;
import ghidra.graph.viewer.renderer.PaintableShape;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class MouseDraggedLinePaintableShape
extends PaintableShape {
    private List<Point> points = new ArrayList<Point>();
    private List<Point> controls = new ArrayList<Point>();

    public MouseDraggedLinePaintableShape(Point start, Point end, double tx, double ty) {
        super(tx, ty);
        this.color = GThemeDefaults.Colors.Palette.GREEN.withAlpha(127);
        this.stroke = new BasicStroke(20.0f);
        this.points.add(start);
        this.points.add(end);
        this.buildShape();
    }

    public void addPoint(Point p) {
        this.points.add(p);
        this.buildShape();
    }

    private void buildShape() {
        int i;
        Point start;
        this.controls.clear();
        Point p1 = start = this.points.get(0);
        Point p2 = this.points.get(1);
        GeneralPath path = new GeneralPath();
        path.moveTo(p1.x, p1.y);
        if (this.points.size() == 2) {
            path.lineTo(p2.x, p2.y);
            path.closePath();
            this.shape = path;
            return;
        }
        boolean useControl = true;
        for (i = 2; i < this.points.size(); ++i) {
            Point p3 = this.points.get(i);
            if (useControl) {
                path.quadTo(p2.x, p2.y, p3.x, p3.y);
            } else {
                path.lineTo(p3.x, p3.y);
            }
            useControl = !useControl;
            p1 = p2;
            p2 = p3;
        }
        for (i = this.points.size() - 1; i >= 0; --i) {
            Point p = this.points.get(i);
            path.moveTo(p.x, p.y);
        }
        path.closePath();
        this.shape = path;
    }

    @Override
    public void paint(Graphics2D g) {
        g.setColor(this.color);
        g.draw(this.shape);
    }
}

