/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.SymbolScope;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class SymbolTable {
    private VectorSTL<SleighSymbol> symbollist = new VectorSTL();
    private VectorSTL<SymbolScope> table = new VectorSTL();
    private SymbolScope curscope = null;
    private static final String NEWLINE = System.getProperty("line.separator");

    public SymbolScope getCurrentScope() {
        return this.curscope;
    }

    public SymbolScope getGlobalScope() {
        return (SymbolScope)this.table.get(0);
    }

    public void setCurrentScope(SymbolScope scope) {
        this.curscope = scope;
    }

    public VectorSTL<SleighSymbol> getUnsoughtSymbols() {
        VectorSTL result = new VectorSTL();
        IteratorSTL siter = this.symbollist.begin();
        while (!siter.isEnd()) {
            SleighSymbol sleighSymbol = (SleighSymbol)siter.get();
            if (!sleighSymbol.wasSought()) {
                result.push_back((Object)sleighSymbol);
            }
            siter.increment();
        }
        return result;
    }

    public SleighSymbol findSymbol(String nm) {
        return this.findSymbolInternal(this.curscope, nm);
    }

    public SleighSymbol findSymbol(String nm, int skip) {
        return this.findSymbolInternal(this.skipScope(skip), nm);
    }

    public SleighSymbol findGlobalSymbol(String nm) {
        return this.findSymbolInternal((SymbolScope)this.table.get(0), nm);
    }

    public SleighSymbol findSymbol(int id) {
        SleighSymbol sleighSymbol = (SleighSymbol)this.symbollist.get(id);
        sleighSymbol.setWasSought(true);
        return sleighSymbol;
    }

    public void dispose() {
        IteratorSTL iter = this.table.begin();
        while (!iter.isEnd()) {
            ((SymbolScope)iter.get()).dispose();
            iter.increment();
        }
        IteratorSTL siter = this.symbollist.begin();
        while (!siter.isEnd()) {
            ((SleighSymbol)siter.get()).dispose();
            siter.increment();
        }
    }

    public void addScope() {
        this.curscope = new SymbolScope(this.curscope, this.table.size());
        this.table.push_back((Object)this.curscope);
    }

    public void popScope() {
        if (this.curscope != null) {
            this.curscope = this.curscope.getParent();
        }
    }

    private SymbolScope skipScope(int i) {
        SymbolScope res = this.curscope;
        while (i > 0) {
            if (res.parent == null) {
                return res;
            }
            res = res.parent;
            --i;
        }
        return res;
    }

    public void addGlobalSymbol(SleighSymbol a) {
        a.id = this.symbollist.size();
        this.symbollist.push_back((Object)a);
        SymbolScope scope = this.getGlobalScope();
        a.scopeid = scope.getId();
        SleighSymbol res = scope.addSymbol(a);
        if (res != a) {
            throw new SleighError("Duplicate symbol name: " + a.getName() + " (previously defined at " + String.valueOf(res.location) + ")", a.getLocation());
        }
    }

    public int addSymbol(SleighSymbol a) {
        a.id = this.symbollist.size();
        this.symbollist.push_back((Object)a);
        a.scopeid = this.curscope.getId();
        SleighSymbol res = this.curscope.addSymbol(a);
        if (res != a) {
            throw new SleighError("Duplicate symbol name: " + a.getName() + " (previously defined at " + String.valueOf(res.location) + ")", a.getLocation());
        }
        return a.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SymbolScope scope = this.curscope; scope != null; scope = scope.getParent()) {
            sb.append(scope);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private SleighSymbol findSymbolInternal(SymbolScope scope, String nm) {
        while (scope != null) {
            SleighSymbol res = scope.findSymbol(nm);
            if (res != null) {
                res.setWasSought(true);
                return res;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public void replaceSymbol(SleighSymbol a, SleighSymbol b) {
        for (int i = this.table.size() - 1; i >= 0; --i) {
            SleighSymbol sym = ((SymbolScope)this.table.get(i)).findSymbol(a.getName());
            if (sym != a) continue;
            ((SymbolScope)this.table.get(i)).removeSymbol(a);
            b.id = a.id;
            b.scopeid = a.scopeid;
            this.symbollist.set(b.id, (Object)b);
            ((SymbolScope)this.table.get(i)).addSymbol(b);
            a.dispose();
            return;
        }
    }

    public void encode(Encoder encoder) throws IOException {
        int i;
        encoder.openElement(SlaFormat.ELEM_SYMBOL_TABLE);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SCOPESIZE, this.table.size());
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SYMBOLSIZE, this.symbollist.size());
        for (i = 0; i < this.table.size(); ++i) {
            encoder.openElement(SlaFormat.ELEM_SCOPE);
            encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, ((SymbolScope)this.table.get(i)).getId());
            if (((SymbolScope)this.table.get((int)i)).parent == null) {
                encoder.writeUnsignedInteger(SlaFormat.ATTRIB_PARENT, 0L);
            } else {
                encoder.writeUnsignedInteger(SlaFormat.ATTRIB_PARENT, ((SymbolScope)this.table.get((int)i)).parent.getId());
            }
            encoder.closeElement(SlaFormat.ELEM_SCOPE);
        }
        for (i = 0; i < this.symbollist.size(); ++i) {
            ((SleighSymbol)this.symbollist.get(i)).encodeHeader(encoder);
        }
        for (i = 0; i < this.symbollist.size(); ++i) {
            ((SleighSymbol)this.symbollist.get(i)).encode(encoder);
        }
        encoder.closeElement(SlaFormat.ELEM_SYMBOL_TABLE);
    }

    public void purge() {
        block5: for (int symbolIndex = 0; symbolIndex < this.symbollist.size(); ++symbolIndex) {
            SleighSymbol sym = (SleighSymbol)this.symbollist.get(symbolIndex);
            if (sym == null) continue;
            if (sym.scopeid != 0) {
                if (sym.getType() == symbol_type.operand_symbol) {
                    continue;
                }
            } else {
                switch (sym.getType()) {
                    case space_symbol: 
                    case token_symbol: 
                    case epsilon_symbol: 
                    case section_symbol: 
                    case bitrange_symbol: {
                        break;
                    }
                    case macro_symbol: {
                        MacroSymbol macro = (MacroSymbol)sym;
                        for (int macroIndex = 0; macroIndex < macro.getNumOperands(); ++macroIndex) {
                            OperandSymbol opersym = macro.getOperand(macroIndex);
                            ((SymbolScope)this.table.get(opersym.scopeid)).removeSymbol(opersym);
                            this.symbollist.set(opersym.id, null);
                            ((SleighSymbol)opersym).dispose();
                        }
                        break;
                    }
                    case subtable_symbol: {
                        SubtableSymbol subsym = (SubtableSymbol)sym;
                        if (subsym.getPattern() != null) continue block5;
                        for (int subtableIndex = 0; subtableIndex < subsym.getNumConstructors(); ++subtableIndex) {
                            Constructor con = subsym.getConstructor(subtableIndex);
                            for (int operandIndex = 0; operandIndex < con.getNumOperands(); ++operandIndex) {
                                OperandSymbol oper = con.getOperand(operandIndex);
                                ((SymbolScope)this.table.get(oper.scopeid)).removeSymbol(oper);
                                this.symbollist.set(oper.id, null);
                                oper.dispose();
                            }
                        }
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            ((SymbolScope)this.table.get(sym.scopeid)).removeSymbol(sym);
            this.symbollist.set(symbolIndex, null);
            sym.dispose();
        }
        for (int tableIndex = 1; tableIndex < this.table.size(); ++tableIndex) {
            if (!((SymbolScope)this.table.get((int)tableIndex)).tree.isEmpty()) continue;
            ((SymbolScope)this.table.get(tableIndex)).dispose();
            this.table.set(tableIndex, null);
        }
        this.renumber();
    }

    private void renumber() {
        VectorSTL newtable = new VectorSTL();
        VectorSTL newsymbol = new VectorSTL();
        SymbolScope scope = null;
        for (int i = 0; i < this.table.size(); ++i) {
            scope = (SymbolScope)this.table.get(i);
            if (scope == null) continue;
            scope.id = newtable.size();
            newtable.push_back((Object)scope);
        }
        SleighSymbol sym = null;
        for (int i = 0; i < this.symbollist.size(); ++i) {
            sym = (SleighSymbol)this.symbollist.get(i);
            if (sym == null) continue;
            sym.scopeid = ((SymbolScope)this.table.get((int)sym.scopeid)).id;
            sym.id = newsymbol.size();
            newsymbol.push_back((Object)sym);
        }
        this.table = newtable;
        this.symbollist = newsymbol;
    }
}

