/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.cdex.CDexCodeItem;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.analyzer.DexHeaderFormatAnalyzer;
import ghidra.file.formats.android.dex.analyzer.DexHeaderFragmentManager;
import ghidra.file.formats.android.dex.format.AccessFlags;
import ghidra.file.formats.android.dex.format.AnnotationItem;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.AnnotationSetReferenceItem;
import ghidra.file.formats.android.dex.format.AnnotationSetReferenceList;
import ghidra.file.formats.android.dex.format.AnnotationsDirectoryItem;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DebugInfoItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedArrayItem;
import ghidra.file.formats.android.dex.format.EncodedCatchHandler;
import ghidra.file.formats.android.dex.format.EncodedCatchHandlerList;
import ghidra.file.formats.android.dex.format.EncodedField;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.FieldAnnotationsItem;
import ghidra.file.formats.android.dex.format.FieldIDItem;
import ghidra.file.formats.android.dex.format.MapItem;
import ghidra.file.formats.android.dex.format.MapItemTypeCodes;
import ghidra.file.formats.android.dex.format.MapList;
import ghidra.file.formats.android.dex.format.MethodAnnotationsItem;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.format.ParameterAnnotationsItem;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.StringDataItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TryItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.ProgramCompilerSpec;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DexHeaderFormatMarkup {
    private DexHeaderFormatAnalyzer analyzer;
    private Program program;
    private Address baseAddress;
    private FlatProgramAPI api;
    private DexHeaderFragmentManager fragmentManager;

    public DexHeaderFormatMarkup(DexHeaderFormatAnalyzer analyzer, Program program, Address baseAddress) {
        this.analyzer = analyzer;
        this.program = program;
        this.baseAddress = baseAddress;
        this.api = new FlatProgramAPI(program);
        this.fragmentManager = new DexHeaderFragmentManager(program, baseAddress, this.api, analyzer.isCreateFragments());
    }

    public boolean markup(TaskMonitor monitor, MessageLog log) throws Exception {
        if (this.api.getDataAt(this.baseAddress) != null) {
            log.appendMsg("data already exists.");
            return true;
        }
        Memory memory = this.program.getMemory();
        MemoryBlock block = memory.getBlock(this.baseAddress);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
        DexAnalysisState analysisState = DexAnalysisState.getState(this.program, this.baseAddress);
        DexHeader header = analysisState.getHeader();
        this.processHeader(header);
        this.fragmentManager.createInitialFragments(header, monitor);
        ProgramCompilerSpec.enableJavaLanguageDecompilation((Program)this.program);
        this.createNamespaces(header, monitor, log);
        this.processMap(header, monitor, log);
        this.processStrings(header, monitor, log);
        this.processTypes(header, monitor, log);
        this.processPrototypes(header, monitor, log);
        this.processFields(header, monitor, log);
        this.processMethods(header, monitor, log);
        this.processClassDefs(header, monitor, log);
        this.createProgramDataTypes(header, monitor, log);
        this.createMethods(header, monitor, log);
        this.fragmentManager.createFragments(monitor, log);
        monitor.setMessage("DEX: cleaning up tree");
        this.analyzer.removeEmptyFragments(this.program);
        return true;
    }

    private void createNamespaces(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: creating namespaces");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
            Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(this.program, className);
            if (classNameSpace != null) continue;
            log.appendMsg("Failed to create namespace: " + className);
        }
    }

    private void createMethods(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: creating methods");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            ClassDataItem classDataItem = item.getClassDataItem();
            if (classDataItem == null) continue;
            this.createMethods(header, item, classDataItem.getDirectMethods(), monitor, log);
            this.createMethods(header, item, classDataItem.getVirtualMethods(), monitor, log);
        }
    }

    private void createMethods(DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor, MessageLog log) throws Exception {
        String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
        Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(this.program, className);
        if (classNameSpace == null) {
            log.appendMsg("No namespace: Skipping methods for " + className);
            return;
        }
        for (int i = 0; i < methods.size(); ++i) {
            CodeItem codeItem;
            monitor.checkCancelled();
            EncodedMethod encodedMethod = methods.get(i);
            MethodIDItem methodID = header.getMethods().get(encodedMethod.getMethodIndex());
            String methodName = DexUtil.convertToString(header, methodID.getNameIndex());
            if ((0x10000 & encodedMethod.getAccessFlags()) != 0) {
                methodName = classNameSpace.getName();
            }
            if ((codeItem = encodedMethod.getCodeItem()) == null) continue;
            Address methodAddress = this.baseAddress.add(0x50000000L + (long)encodedMethod.getCodeOffset());
            this.createMethodSymbol(methodAddress, methodName, classNameSpace, log);
            this.createMethodComment(methodAddress, header, item, methodID, encodedMethod, codeItem, monitor);
            this.disassembleMethod(header, className, encodedMethod.isStatic(), methodAddress, methodID, codeItem, monitor, log);
        }
    }

    private Symbol createMethodSymbol(Address methodAddress, String methodName, Namespace classNameSpace, MessageLog log) {
        this.program.getSymbolTable().addExternalEntryPoint(methodAddress);
        try {
            return this.program.getSymbolTable().createLabel(methodAddress, methodName, classNameSpace, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
            return null;
        }
    }

    private void createMethodComment(Address methodAddress, DexHeader header, ClassDefItem item, MethodIDItem methodID, EncodedMethod encodedMethod, CodeItem codeItem, TaskMonitor monitor) throws CancelledException {
        String methodSignature = DexUtil.convertPrototypeIndexToString(header, methodID.getProtoIndex());
        StringBuilder commentBuilder = new StringBuilder();
        commentBuilder.append(item.toString(header, -1, monitor) + "\n");
        commentBuilder.append("Method Signature: " + methodSignature + "\n");
        commentBuilder.append("Method Access Flags:\n");
        commentBuilder.append(AccessFlags.toString(encodedMethod.getAccessFlags()) + "\n");
        if (codeItem != null) {
            commentBuilder.append("Method Register Size: " + codeItem.getRegistersSize() + "\n");
            commentBuilder.append("Method Incoming Size: " + codeItem.getIncomingSize() + "\n");
            commentBuilder.append("Method Outgoing Size: " + codeItem.getOutgoingSize() + "\n");
            commentBuilder.append("Method Debug Info Offset: 0x" + Integer.toHexString(codeItem.getDebugInfoOffset()) + "\n");
        }
        commentBuilder.append("Method ID Offset: 0x" + Long.toHexString(methodID.getFileOffset()) + "\n");
        this.api.setPlateComment(methodAddress, commentBuilder.toString());
    }

    private void disassembleMethod(DexHeader header, String className, boolean isStatic, Address methodAddress, MethodIDItem methodID, CodeItem codeItem, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Language language = this.program.getLanguage();
        DisassembleCommand dCommand = new DisassembleCommand(methodAddress, null, true);
        dCommand.applyTo((DomainObject)this.program);
        Function method = this.api.createFunction(methodAddress, null);
        if (method == null && this.api.getFunctionAt(methodAddress) != null) {
            log.appendMsg("Duplicate method at " + String.valueOf(methodAddress));
            return;
        }
        if (method == null) {
            log.appendMsg("Failed to create method at " + String.valueOf(methodAddress));
            return;
        }
        int registerIndex = codeItem.getRegistersSize() - codeItem.getIncomingSize();
        for (int i = 0; i < registerIndex; ++i) {
            DataType localDataType = null;
            Register localRegister = language.getRegister("v" + i);
            try {
                LocalVariableImpl local = new LocalVariableImpl("local_" + i, 0, localDataType, localRegister, this.program);
                method.addLocalVariable((Variable)local, SourceType.ANALYSIS);
                continue;
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
        }
        ReturnParameterImpl returnVar = null;
        ArrayList<ParameterImpl> paramList = new ArrayList<ParameterImpl>();
        int prototypeIndex = Short.toUnsignedInt(methodID.getProtoIndex());
        PrototypesIDItem prototype = header.getPrototypes().get(prototypeIndex);
        try {
            TypeList parameters;
            String returnTypeString = DexUtil.convertTypeIndexToString(header, prototype.getReturnTypeIndex());
            DataType returnDataType = DexUtil.toDataType((DataTypeManager)this.program.getDataTypeManager(), returnTypeString);
            returnVar = new ReturnParameterImpl(returnDataType, this.program);
            if (!isStatic) {
                String classString = DexUtil.convertTypeIndexToString(header, methodID.getClassIndex());
                DataType thisDataType = DexUtil.toDataType((DataTypeManager)this.program.getDataTypeManager(), classString);
                String parameterName = "this";
                ParameterImpl param = new ParameterImpl(parameterName, thisDataType, this.program);
                paramList.add(param);
            }
            if ((parameters = prototype.getParameters()) != null) {
                for (TypeItem parameterTypeItem : parameters.getItems()) {
                    monitor.checkCancelled();
                    String parameterTypeString = DexUtil.convertTypeIndexToString(header, parameterTypeItem.getType());
                    DataType parameterDataType = DexUtil.toDataType((DataTypeManager)this.program.getDataTypeManager(), parameterTypeString);
                    Object parameterName = this.getParameterName(header, codeItem, paramList.size() - (isStatic ? 0 : 1));
                    if (parameterName == null) {
                        parameterName = "p" + paramList.size();
                    }
                    ParameterImpl param = new ParameterImpl((String)parameterName, parameterDataType, this.program);
                    paramList.add(param);
                }
            }
            method.updateFunction("__stdcall", (Variable)returnVar, paramList, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
        }
        catch (InvalidInputException ex) {
            log.appendException((Throwable)ex);
        }
        catch (DuplicateNameException ex) {
            log.appendException((Throwable)ex);
        }
    }

    private String getParameterName(DexHeader header, CodeItem codeItem, int parameterOrdinal) {
        try {
            DebugInfoItem debugInfo = codeItem.getDebugInfo();
            int[] debugParameterNames = debugInfo.getParameterNames();
            List<StringIDItem> strings = header.getStrings();
            StringIDItem stringIDItem = strings.get(debugParameterNames[parameterOrdinal]);
            StringDataItem stringDataItem = stringIDItem.getStringDataItem();
            return stringDataItem.getString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void processHeader(DexHeader header) throws Exception {
        Address headerAddress = this.baseAddress.add(0L);
        DataType headerDataType = header.toDataType();
        this.api.createData(headerAddress, headerDataType);
        this.fragmentManager.createHeaderFragment(headerAddress, headerDataType);
    }

    private void processClassDefs(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing class definitions");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getClassDefsIdsOffset());
        int index = 0;
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.api.createData(address, dataType);
            this.fragmentManager.classesAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            this.createClassDefSymbol(header, item, address);
            this.processClassInterfaces(header, item, monitor);
            this.processClassAnnotations(header, item, monitor, log);
            this.processClassDataItem(header, item, monitor, log);
            this.processClassStaticValues(header, item, monitor);
            this.api.setPlateComment(address, item.toString(header, index, monitor));
            address = address.add((long)dataType.getLength());
            ++index;
        }
    }

    private void createProgramDataTypes(DexHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("DEX: creating program datatypes");
        monitor.setMaximum((long)header.getTypeIdsSize());
        monitor.setProgress(0L);
        ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
        int curGroup = -1;
        CategoryPath handlePath = null;
        List<TypeIDItem> types = header.getTypes();
        for (int typeID = 0; typeID < header.getTypeIdsSize(); ++typeID) {
            if (typeID > types.size() - 1) continue;
            TypeIDItem item = types.get(typeID);
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            String name = DexUtil.convertToString(header, item.getDescriptorIndex());
            String[] path = DexUtil.convertClassStringToPathArray("classes/", name);
            if (path == null) continue;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < path.length - 1; ++i) {
                builder.append('/');
                builder.append(path[i]);
            }
            CategoryPath catPath = new CategoryPath(builder.toString());
            TypedefDataType dataType = new TypedefDataType(catPath, path[path.length - 1], (DataType)DWordDataType.dataType);
            dataType = dtm.resolve((DataType)dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
            if (typeID / 100 != curGroup) {
                curGroup = typeID / 100;
                builder = new StringBuilder();
                builder.append("/handles/");
                builder.append("group").append(curGroup);
                handlePath = new CategoryPath(builder.toString());
            }
            TypedefDataType handleType = new TypedefDataType(handlePath, "type" + typeID, (DataType)dataType);
            dtm.resolve((DataType)handleType, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    private void createClassDefSymbol(DexHeader header, ClassDefItem item, Address address) {
        String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
        SymbolTable symbolTable = this.program.getSymbolTable();
        try {
            Namespace nameSpace = DexUtil.createNameSpaceFromMangledClassName(this.program, className);
            if (nameSpace != null) {
                symbolTable.createLabel(address, "__classdef__", nameSpace, SourceType.ANALYSIS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processClassStaticValues(DexHeader header, ClassDefItem item, TaskMonitor monitor) throws DuplicateNameException, IOException, Exception {
        if (item.getStaticValuesOffset() > 0) {
            EncodedArrayItem staticValues = item.getStaticValues();
            if (staticValues == null) {
                return;
            }
            Address staticAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getStaticValuesOffset(), header));
            DataType staticDataType = staticValues.toDataType();
            this.api.createData(staticAddress, staticDataType);
            this.fragmentManager.classStaticValuesAddressSet.add(staticAddress, staticAddress.add((long)(staticDataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Static Values:\n");
            builder.append(NumericUtilities.convertBytesToString((byte[])staticValues.getArray().getValues(), (String)" "));
            this.api.setPlateComment(staticAddress, builder.toString());
        }
    }

    private void processClassDataItem(DexHeader header, ClassDefItem item, TaskMonitor monitor, MessageLog log) throws DuplicateNameException, IOException, Exception {
        if (item.getClassDataOffset() > 0) {
            ClassDataItem classDataItem = item.getClassDataItem();
            if (classDataItem == null) {
                return;
            }
            Address classDataAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getClassDataOffset(), header));
            DataType classDataDataType = classDataItem.toDataType();
            try {
                this.api.createData(classDataAddress, classDataDataType);
            }
            catch (Exception e) {
                log.appendMsg("Unable to create class data item at " + String.valueOf(classDataAddress));
                return;
            }
            this.fragmentManager.classDataAddressSet.add(classDataAddress, classDataAddress.add((long)(classDataDataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Static Fields:   " + classDataItem.getStaticFieldsSize() + "\n");
            builder.append("Instance Fields: " + classDataItem.getInstanceFieldsSize() + "\n");
            builder.append("Direct Methods:  " + classDataItem.getDirectMethodsSize() + "\n");
            builder.append("Virtual Methods: " + classDataItem.getVirtualMethodsSize() + "\n");
            this.processEncodedFields(header, classDataItem.getStaticFields(), monitor);
            this.processEncodedFields(header, classDataItem.getInstancesFields(), monitor);
            this.processEncodedMethods(header, item, classDataItem.getDirectMethods(), monitor);
            this.processEncodedMethods(header, item, classDataItem.getVirtualMethods(), monitor);
            this.api.setPlateComment(classDataAddress, builder.toString());
        }
    }

    private void processEncodedFields(DexHeader header, List<EncodedField> instanceFields, TaskMonitor monitor) throws Exception {
        int index = 0;
        for (int i = 0; i < instanceFields.size(); ++i) {
            monitor.checkCancelled();
            EncodedField field = instanceFields.get(i);
            int diff = field.getFieldIndexDifference();
            index = i == 0 ? diff : (index += diff);
            FieldIDItem fieldID = header.getFields().get(index);
            StringBuilder builder = new StringBuilder();
            builder.append(DexUtil.convertToString(header, fieldID.getNameIndex()) + "\n");
            builder.append(AccessFlags.toString(field.getAccessFlags()) + "\n");
            builder.append("\n");
            Address address = this.baseAddress.add(field.getFileOffset());
            DataType dataType = field.toDataType();
            this.api.createData(address, dataType);
            this.api.setPlateComment(address, builder.toString());
            this.fragmentManager.encodedFieldsAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
        }
    }

    private void processEncodedMethods(DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor) throws Exception {
        for (int i = 0; i < methods.size(); ++i) {
            monitor.checkCancelled();
            EncodedMethod method = methods.get(i);
            MethodIDItem methodID = header.getMethods().get(method.getMethodIndex());
            StringBuilder builder = new StringBuilder();
            builder.append("Method Name: " + DexUtil.convertToString(header, methodID.getNameIndex()) + "\n");
            builder.append("Method Offset: 0x" + Long.toHexString(methodID.getFileOffset()) + "\n");
            builder.append("Method Flags:\n");
            builder.append(AccessFlags.toString(method.getAccessFlags()) + "\n");
            builder.append("Code Offset: 0x" + Integer.toHexString(method.getCodeOffset()) + "\n");
            builder.append("\n");
            Address address = this.baseAddress.add(method.getFileOffset());
            DataType dataType = method.toDataType();
            this.api.createData(address, dataType);
            this.api.setPlateComment(address, builder.toString());
            this.fragmentManager.encodedMethodsAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            this.processCodeItem(header, item, method, methodID);
        }
    }

    private void processCodeItem(DexHeader header, ClassDefItem item, EncodedMethod method, MethodIDItem methodID) throws DuplicateNameException, IOException, Exception {
        if (method.getCodeOffset() > 0) {
            Address codeAddress = this.baseAddress.add((long)DexUtil.adjustOffset(method.getCodeOffset(), header));
            CodeItem codeItem = method.getCodeItem();
            StringBuilder builder = new StringBuilder();
            builder.append(DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + " " + DexUtil.convertToString(header, methodID.getNameIndex()) + "\n");
            if (codeItem != null) {
                builder.append("\n");
                builder.append("Instruction Bytes: 0x" + Integer.toHexString(codeItem.getInstructionBytes().length) + "\n");
                builder.append("Registers Size: 0x" + Integer.toHexString(codeItem.getRegistersSize()) + "\n");
                builder.append("Incoming Size: 0x" + Integer.toHexString(codeItem.getIncomingSize()) + "\n");
                builder.append("Outgoing Size: 0x" + Integer.toHexString(codeItem.getOutgoingSize()) + "\n");
                builder.append("Tries Size: 0x" + Integer.toHexString(codeItem.getTriesSize()) + "\n");
            }
            if (codeItem instanceof CDexCodeItem) {
                CDexCodeItem cdexCodeItem = (CDexCodeItem)codeItem;
                builder.append("\n" + (cdexCodeItem.hasPreHeader() ? "PREHEADER" : ""));
            }
            this.api.setPlateComment(codeAddress, builder.toString());
            if (codeItem != null) {
                DataType codeItemDataType = codeItem.toDataType();
                try {
                    this.api.createData(codeAddress, codeItemDataType);
                    int codeItemDataTypeLength = codeItemDataType.getLength();
                    this.fragmentManager.codeItemAddressSet.add(codeAddress, codeAddress.add((long)(codeItemDataTypeLength - 1)));
                    Address tempAddress = codeAddress.add((long)codeItemDataTypeLength);
                    tempAddress = this.processCodeItemTrys(tempAddress, codeItem);
                    this.processCodeItemHandlers(codeItem, tempAddress);
                }
                catch (Exception codeItemDataTypeLength) {
                    // empty catch block
                }
                if (codeItem.getDebugInfoOffset() > 0) {
                    Address debugAddress = this.baseAddress.add((long)codeItem.getDebugInfoOffset());
                    DebugInfoItem debug = codeItem.getDebugInfo();
                    DataType debugDataType = debug.toDataType();
                    this.api.createData(debugAddress, debugDataType);
                    this.fragmentManager.debugInfoAddressSet.add(debugAddress, debugAddress.add((long)(debugDataType.getLength() - 1)));
                }
            }
        }
    }

    private void processCodeItemHandlers(CodeItem codeItem, Address tempAddress) throws DuplicateNameException, IOException, Exception {
        EncodedCatchHandlerList handlerList = codeItem.getHandlerList();
        if (handlerList == null) {
            return;
        }
        DataType handlerDataType = handlerList.toDataType();
        this.api.createData(tempAddress, handlerDataType);
        this.fragmentManager.handlersAddressSet.add(tempAddress, tempAddress.add((long)(handlerDataType.getLength() - 1)));
        tempAddress = tempAddress.add((long)handlerDataType.getLength());
        for (EncodedCatchHandler handler : handlerList.getHandlers()) {
            DataType dataType = handler.toDataType();
            this.api.createData(tempAddress, dataType);
            this.fragmentManager.handlersAddressSet.add(tempAddress, tempAddress.add((long)(dataType.getLength() - 1)));
            tempAddress = tempAddress.add((long)dataType.getLength());
        }
    }

    private Address processCodeItemTrys(Address codeAddress, CodeItem codeItem) throws DuplicateNameException, IOException, Exception {
        Address tempAddress = codeAddress;
        for (TryItem tryItem : codeItem.getTries()) {
            DataType dataType = tryItem.toDataType();
            this.api.createData(tempAddress, dataType);
            this.fragmentManager.tryAddressSet.add(tempAddress, tempAddress.add((long)(dataType.getLength() - 1)));
            tempAddress = tempAddress.add((long)dataType.getLength());
        }
        return tempAddress;
    }

    private void processClassAnnotations(DexHeader header, ClassDefItem item, TaskMonitor monitor, MessageLog log) throws DuplicateNameException, IOException, Exception, CancelledException {
        if (item.getAnnotationsOffset() > 0) {
            DataType setItemDataType;
            AnnotationSetItem setItem;
            AnnotationsDirectoryItem annotationsDirectoryItem = item.getAnnotationsDirectoryItem();
            if (annotationsDirectoryItem == null) {
                return;
            }
            Address annotationsAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getAnnotationsOffset(), header));
            DataType annotationsDataType = annotationsDirectoryItem.toDataType();
            this.api.createData(annotationsAddress, annotationsDataType);
            this.fragmentManager.annotationsAddressSet.add(annotationsAddress, annotationsAddress.add((long)(annotationsDataType.getLength() - 1)));
            if (annotationsDirectoryItem.getClassAnnotationsOffset() > 0) {
                Address classAddress = this.baseAddress.add((long)DexUtil.adjustOffset(annotationsDirectoryItem.getClassAnnotationsOffset(), header));
                AnnotationSetItem setItem2 = annotationsDirectoryItem.getClassAnnotations();
                DataType setItemDataType2 = setItem2.toDataType();
                this.api.createData(classAddress, setItemDataType2);
                this.fragmentManager.classAnnotationsAddressSet.add(classAddress, classAddress.add((long)(setItemDataType2.getLength() - 1)));
                this.processAnnotationSetItem(setItem2, monitor, log);
            }
            for (FieldAnnotationsItem field : annotationsDirectoryItem.getFieldAnnotations()) {
                monitor.checkCancelled();
                Address fieldAddress = this.baseAddress.add((long)DexUtil.adjustOffset(field.getAnnotationsOffset(), header));
                setItem = field.getAnnotationSetItem();
                setItemDataType = setItem.toDataType();
                this.api.createData(fieldAddress, setItemDataType);
                this.fragmentManager.annotationFieldsAddressSet.add(fieldAddress, fieldAddress.add((long)(setItemDataType.getLength() - 1)));
                this.processAnnotationSetItem(setItem, monitor, log);
            }
            for (MethodAnnotationsItem method : annotationsDirectoryItem.getMethodAnnotations()) {
                monitor.checkCancelled();
                Address methodAddress = this.baseAddress.add((long)DexUtil.adjustOffset(method.getAnnotationsOffset(), header));
                setItem = method.getAnnotationSetItem();
                setItemDataType = setItem.toDataType();
                this.api.createData(methodAddress, setItemDataType);
                this.fragmentManager.annotationMethodsAddressSet.add(methodAddress, methodAddress.add((long)(setItemDataType.getLength() - 1)));
                this.processAnnotationSetItem(setItem, monitor, log);
            }
            for (ParameterAnnotationsItem parameter : annotationsDirectoryItem.getParameterAnnotations()) {
                monitor.checkCancelled();
                Address parameterAddress = this.baseAddress.add((long)DexUtil.adjustOffset(parameter.getAnnotationsOffset(), header));
                AnnotationSetReferenceList annotationSetReferenceList = parameter.getAnnotationSetReferenceList();
                DataType listDataType = annotationSetReferenceList.toDataType();
                this.api.createData(parameterAddress, listDataType);
                this.fragmentManager.annotationParametersAddressSet.add(parameterAddress, parameterAddress.add((long)(listDataType.getLength() - 1)));
                for (AnnotationSetReferenceItem refItem : annotationSetReferenceList.getItems()) {
                    AnnotationItem annotationItem = refItem.getItem();
                    if (annotationItem == null) continue;
                    int annotationsItemOffset = refItem.getAnnotationsOffset();
                    Address annotationItemAddress = this.baseAddress.add((long)DexUtil.adjustOffset(annotationsItemOffset, header));
                    DataType annotationItemDataType = annotationItem.toDataType();
                    this.api.createData(annotationItemAddress, annotationItemDataType);
                    this.fragmentManager.annotationItemAddressSet.add(annotationItemAddress, annotationItemAddress.add((long)(annotationItemDataType.getLength() - 1)));
                }
            }
        }
    }

    private void processClassInterfaces(DexHeader header, ClassDefItem item, TaskMonitor monitor) throws Exception {
        if (item.getInterfacesOffset() > 0) {
            TypeList interfaces = item.getInterfaces();
            if (interfaces == null) {
                return;
            }
            Address interfaceAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getInterfacesOffset(), header));
            DataType interfaceDataType = interfaces.toDataType();
            this.api.createData(interfaceAddress, interfaceDataType);
            this.fragmentManager.interfacesAddressSet.add(interfaceAddress, interfaceAddress.add((long)(interfaceDataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Implements:\n");
            for (TypeItem interfaceItem : interfaces.getItems()) {
                monitor.checkCancelled();
                builder.append("\t" + DexUtil.convertTypeIndexToString(header, interfaceItem.getType()) + "\n");
            }
            this.api.setPlateComment(interfaceAddress, builder.toString());
        }
    }

    private void processAnnotationSetItem(AnnotationSetItem setItem, TaskMonitor monitor, MessageLog log) {
    }

    private void processMethods(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing methods");
        monitor.setMaximum((long)header.getMethodIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getMethodIdsOffset());
        int methodIndex = 0;
        for (MethodIDItem item : header.getMethods()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.api.createData(address, dataType);
            this.fragmentManager.methodsAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Method Index: 0x" + Integer.toHexString(methodIndex) + "\n");
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n");
            builder.append("Prototype: " + DexUtil.convertPrototypeIndexToString(header, item.getProtoIndex()) + "\n");
            builder.append("Name: " + DexUtil.convertToString(header, item.getNameIndex()) + "\n");
            this.api.setPlateComment(address, builder.toString());
            ++methodIndex;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processFields(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing fields");
        monitor.setMaximum((long)header.getFieldIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getFieldIdsOffset());
        int index = 0;
        for (FieldIDItem item : header.getFields()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.api.createData(address, dataType);
            this.fragmentManager.fieldsAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Field Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n");
            builder.append("Type: " + DexUtil.convertTypeIndexToString(header, item.getTypeIndex()) + "\n");
            builder.append("Name: " + DexUtil.convertToString(header, item.getNameIndex()) + "\n");
            this.api.setPlateComment(address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processPrototypes(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing prototypes");
        monitor.setMaximum((long)header.getProtoIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getProtoIdsOffset());
        int index = 0;
        for (PrototypesIDItem item : header.getPrototypes()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            Data data = this.api.createData(address, dataType);
            this.fragmentManager.prototypesAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Prototype Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("Shorty: " + DexUtil.convertToString(header, item.getShortyIndex()) + "\n");
            builder.append("Return Type: " + DexUtil.convertTypeIndexToString(header, item.getReturnTypeIndex()) + "\n");
            if (item.getParametersOffset() > 0) {
                builder.append("Parameters: \n");
                TypeList parameters = item.getParameters();
                if (parameters != null) {
                    for (TypeItem parameter : parameters.getItems()) {
                        monitor.checkCancelled();
                        builder.append(DexUtil.convertTypeIndexToString(header, parameter.getType()) + " ");
                    }
                    DataType parametersDT = parameters.toDataType();
                    Address parametersAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getParametersOffset(), header));
                    this.api.createData(parametersAddress, parametersDT);
                    builder.append("\nParameters Address: " + String.valueOf(parametersAddress));
                    builder.append("\n");
                    this.api.createMemoryReference(data.getComponent(2), parametersAddress, RefType.DATA);
                }
            }
            this.api.setPlateComment(address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processTypes(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing types");
        monitor.setMaximum((long)header.getTypeIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getTypeIdsOffset());
        int index = 0;
        for (TypeIDItem item : header.getTypes()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.api.createData(address, dataType);
            this.fragmentManager.typesAddressSet.add(address, address.add((long)(dataType.getLength() - 1)));
            StringBuilder builder = new StringBuilder();
            builder.append("Type Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("\t->" + DexUtil.convertToString(header, item.getDescriptorIndex()));
            this.api.setPlateComment(address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processMap(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        MapList mapList = header.getMapList();
        if (mapList == null) {
            return;
        }
        monitor.setMessage("DEX: processing map");
        monitor.setMaximum((long)mapList.getSize());
        monitor.setProgress(0L);
        Address mapListAddress = this.baseAddress.add((long)DexUtil.adjustOffset(header.getMapOffset(), header));
        DataType mapListDataType = mapList.toDataType();
        this.api.createData(mapListAddress, mapListDataType);
        this.fragmentManager.mapAddressSet.add(mapListAddress, mapListAddress.add((long)(mapListDataType.getLength() - 1)));
        StringBuilder builder = new StringBuilder();
        for (MapItem item : header.getMapList().getItems()) {
            monitor.checkCancelled();
            builder.append(MapItemTypeCodes.toString(item.getType()) + "\n");
        }
        this.api.setPlateComment(mapListAddress, builder.toString());
    }

    private void processStrings(DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing strings");
        monitor.setMaximum((long)header.getStringIdsSize());
        monitor.setProgress(0L);
        Address address = this.baseAddress.add((long)header.getStringIdsOffset());
        int index = 0;
        for (StringIDItem item : header.getStrings()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            Address stringDataAddress = this.baseAddress.add((long)DexUtil.adjustOffset(item.getStringDataOffset(), header));
            if (!this.program.getMemory().contains(stringDataAddress)) continue;
            StringDataItem stringDataItem = item.getStringDataItem();
            if (stringDataItem == null) {
                log.appendMsg("Invalid string detected at " + String.valueOf(stringDataAddress));
                continue;
            }
            String string = stringDataItem.getString();
            DataType stringDataType = stringDataItem.toDataType();
            this.api.createData(stringDataAddress, stringDataType);
            this.api.setPlateComment(stringDataAddress, Integer.toHexString(index) + "\n" + string.trim());
            this.fragmentManager.stringDataAddressSet.add(stringDataAddress, stringDataAddress.add((long)(stringDataType.getLength() - 1)));
            this.createStringSymbol(stringDataAddress, string, "strings");
            DataType dataType = item.toDataType();
            Data data = this.api.createData(address, dataType);
            this.fragmentManager.stringsDataSet.add(address, address.add((long)(dataType.getLength() - 1)));
            this.api.setPlateComment(address, "String Index: 0x" + Integer.toHexString(index) + "\nString: " + string.trim() + "\nString Data Address: " + String.valueOf(stringDataAddress));
            this.createStringSymbol(address, string, "string_data");
            this.api.createMemoryReference(data, stringDataAddress, RefType.DATA);
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void createStringSymbol(Address address, String string, String namespace) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        if (string.length() > 0) {
            Namespace nameSpace = DexUtil.getOrCreateNameSpace(this.program, namespace);
            String symbolName = SymbolUtilities.replaceInvalidChars((String)string, (boolean)true);
            if (symbolName.length() > 2000) {
                symbolName = symbolName.substring(0, 1980);
            }
            try {
                symbolTable.createLabel(address, symbolName, nameSpace, SourceType.ANALYSIS);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }
}

