/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.MemoryRange;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MemoryListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_MEMORY_RANGE_LIST";
    private int numberOfMemoryRanges;
    private MemoryRange[] memoryRanges;
    private DumpFileReader reader;
    private long index;

    MemoryListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNumberOfMemoryRanges(this.reader.readNextInt());
        this.memoryRanges = new MemoryRange[this.numberOfMemoryRanges];
        for (int i = 0; i < this.numberOfMemoryRanges; ++i) {
            this.setMemoryRange(new MemoryRange(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "NumberOfMemoryRanges", null);
        DataType t = this.memoryRanges[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfMemoryRanges, t.getLength());
        struct.add((DataType)a, a.getLength(), "MemoryRanges", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getNumberOfMemoryRanges() {
        return this.numberOfMemoryRanges;
    }

    public void setNumberOfMemoryRanges(int numberOfMemoryRanges) {
        this.numberOfMemoryRanges = numberOfMemoryRanges;
    }

    public MemoryRange getMemoryRange(int idx) {
        return this.memoryRanges[idx];
    }

    public void setMemoryRange(MemoryRange memoryRange, int index) {
        this.memoryRanges[index] = memoryRange;
    }
}

