---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: yes
title: サインアップの制限
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

サインアップに対して、次の制限を適用できます:

- 新規サインアップを無効にします。
- 新規サインアップに管理者の承認を必須にします。
- ユーザーメールの確認を要求します。
- 特定のメールドメインを使用したサインアップを許可または拒否します。

## 新規サインアップを無効にします {#disable-new-sign-ups}

デフォルトでは、GitLabドメインにアクセスするすべてのユーザーがアカウントにサインアップできます。公開されているGitLabインスタンスを運用しているお客様は、一般ユーザーがアカウントにサインアップすることを想定していない場合は、新規サインアップを無効にすることを強くお勧めします。GitLab Dedicatedの場合、インスタンスのプロビジョニング時に、新しいサインアップはデフォルトで無効になっています。

サインアップを無効にするには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **サインアップは有効です**チェックボックスをオフにして、**変更を保存**を選択します。

次のコマンドを実行して、[Railsコンソール](../operations/rails_console.md)で新しいサインアップを無効にすることもできます:

```ruby
::Gitlab::CurrentSettings.update!(signup_enabled: false)
```

## 新規サインアップに管理者の承認を必須にします {#require-administrator-approval-for-new-sign-ups}

この設定は、新しいGitLabインスタンスではデフォルトで有効になっています。この設定が有効になっている場合、GitLabドメインにアクセスし、登録フォームを使用して新しいアカウントにサインアップするユーザーは、アカウントの使用を開始する前に、管理者による明示的な[承認](../moderate_users.md#approve-or-reject-a-user-sign-up)を受ける必要があります。サインアップが有効になっている場合にのみ適用されます。

新規サインアップに管理者の承認を必須にするには、次のようにします:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **新しいサインアップには管理者の承認が必要**チェックボックスを選択し、**変更を保存**を選択します。

管理者がこの設定を無効にすると、承認待ち状態のユーザーはバックグラウンドジョブで自動的に承認されます。

{{< alert type="note" >}}

この設定は、LDAPまたはOmniAuthユーザーには適用されません。OmniAuthまたはLDAPを使用してサインアップする新しいユーザーの承認を適用するには、[OmniAuth設定](../../integration/omniauth.md#configure-common-settings)または[LDAP設定](../auth/ldap/_index.md#basic-configuration-settings)で、`block_auto_created_users`を`true`にリセットします。[ユーザー上限](#user-cap)を使用して、新しいユーザーの承認を適用することもできます。

{{< /alert >}}

## メールアドレスの確認 {#confirm-user-email}

{{< history >}}

- ソフトメール確認が、機能フラグからGitLab 15.9のアプリケーション設定に[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107302/diffs)。

{{< /history >}}

サインアップ中に確認メールを送信し、ユーザーがサインインする前にメールアドレスを確認することを要求できます。

新しいサインアップに使用されるメールアドレスの確認を適用するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **メールの確認設定**確認設定]で、**ハード**を選択します。

次の設定を使用できます:

- **ハード** \- サインアップ中に確認メールを送信します。新しいユーザーは、サインインする前にメールアドレスを確認する必要があります。
- **ソフト** \- サインアップ中に確認メールを送信します。新しいユーザーはすぐにサインインできますが、3日以内にメールを確認する必要があります。3日後、ユーザーはメールを確認するまでサインインできません。
- **オフ** \- 新しいユーザーは、メールアドレスを確認しなくてもサインアップできます。

## 制限付きアクセスをオンにする {#turn-on-restricted-access}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/501717)されました。
- GitLab 18.0[で一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/523464)になりました。

{{< /history >}}

制限付きアクセスを使用すると、超過料金を防げます。超過料金は、サブスクリプションのライセンスが付与された請求対象ユーザー数を超えた場合に発生し、次回の[四半期ごとの調整](../../subscriptions/quarterly_reconciliation.md)で支払う必要があります。

制限付きアクセスをオンにすると、インスタンスでは、サブスクリプションに残りのライセンスされたシートがない場合、新しい請求対象ユーザーを追加できません。

前提要件: 

- 管理者である必要があります。

制限付きアクセスをオンにするには、次の手順に従います: 

1. 左側のサイドバーで、**設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **シートの管理**で、**制限されたアクセス**を選択します。

### 既知のイシュー {#known-issues}

制限付きアクセスをオンにすると、次の既知のイシューが発生し、超過が発生する可能性があります: 

- 請求対象ユーザー数が超過する可能性はまだあります:
  - SAML、SCIM、またはLDAPを使用して新しいメンバーを追加し、サブスクリプションのシート数を超えた場合。
  - 管理者アクセス権を持つ複数のユーザーが、同時にメンバーを追加する。
  - 新しい請求対象ユーザーが招待の承諾を遅らせている場合。
- 現在のサブスクリプションよりも少ないユーザー数でGitLabセールスチームを通じてサブスクリプションを更新すると、超過料金が発生します。この料金を回避するには、更新が開始される前に追加のユーザーを削除してください。たとえば、20人のユーザーがいて、15人のユーザーに対してサブスクリプションを更新する場合、5人の追加ユーザーに対して超過料金が請求されます。

## ユーザー上限 {#user-cap}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ユーザー上限は、管理者による承認なしにサブスクリプションにサインアップまたは追加できる請求対象ユーザーの最大数です。ユーザー上限に達すると、サインアップまたは追加されたユーザーは、管理者による[承認](../moderate_users.md#approve-or-reject-a-user-sign-up)を受ける必要があります。ユーザーがアカウントを使用できるのは、管理者によって承認された後のみです。

管理者がユーザー上限を引き上げるか削除すると、承認待ちのユーザーは自動的に承認されます。

[個々のグループの[ユーザー上限](../../user/group/manage.md#user-cap-for-groups)を設定]することもできます。

{{< alert type="note" >}}

インスタンスがLDAPまたはOmniAuthを使用している場合、[新しいサインアップに対する管理者の承認](#require-administrator-approval-for-new-sign-ups)が有効または無効になっていると、Railsの設定の変更により、ダウンタイムが発生する可能性があります。ユーザー上限を設定して、新しいユーザーの承認を適用できます。

{{< /alert >}}

### ユーザー上限を設定する {#set-a-user-cap}

ユーザー上限を設定して、管理者の承認なしでサインアップできるユーザー数を制限します。

[請求対象ユーザー](../../subscriptions/manage_users_and_seats.md#billable-users)の数は1日に1回更新されます。ユーザー上限は、上限を超えた後に遡ってのみ適用される場合があります。上限が現在の請求対象ユーザー数よりも低い値(`1`など)に設定されている場合、上限はすぐに有効になります。

前提要件: 

- 管理者である必要があります。

ユーザー上限を設定するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **User cap**（ユーザー上限）フィールドに数値を入力するか、無制限にする場合は空白のままにします。
1. **変更を保存**を選択します。

### ユーザー上限を削除する {#remove-the-user-cap}

管理者の承認なしにサインアップできる新しいユーザーの数が制限されないように、ユーザー上限を削除します。

ユーザー上限を削除すると、承認待ちのユーザーは自動的に承認されます。

前提要件: 

- 管理者である必要があります。

ユーザーキャパシティを削除するには、次の手順に従います: 

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **User cap**（ユーザー上限）から数値を削除します。
1. **変更を保存**を選択します。

## パスワードの最小文字数制限 {#minimum-password-length-limit}

GitLab UIを使用して、ユーザーがパスワードに含める必要のある最小文字数を[変更](../../security/password_length_limits.md#modify-minimum-password-length)できます。

### パスワードの複雑さの要件 {#password-complexity-requirements}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/354965)されました。

{{< /history >}}

デフォルトでは、ユーザーパスワードの唯一の要件は[パスワードの[最小文字数](#minimum-password-length-limit)(#minimum-password-length-limit)です。追加の複雑さの要件を追加できます。パスワードの複雑さの要件の変更は、新しいパスワードに適用されます:

- サインアップする新しいユーザーの場合。
- パスワードをリセットする既存のユーザーの場合。

既存のパスワードは影響を受けません。パスワードの複雑さの要件を変更するには、次のようにします:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **パスワードの最小文字数**で、追加のパスワードの複雑さの要件を選択します。数値、大文字、小文字、および記号を要求できます。
1. **変更を保存**を選択します。

## 特定のメールドメインを使用したサインアップの許可または拒否 {#allow-or-deny-sign-ups-using-specific-email-domains}

ユーザーのサインアップに使用できるメールドメインの包括的または排他的なリストを指定できます。

これらの制限は、外部ユーザーからのサインアップ中にのみ適用されます。管理者は、許可されていないドメインを使用して、管理者パネルからユーザーを追加できます。ユーザーは、サインアップ後にメールアドレスを許可されていないドメインに変更することもできます。

### 許可リストメールドメイン {#allowlist-email-domains}

特定のドメインリストに一致するメールアドレスを使用してサインアップする場合にのみ、ユーザーを制限できます。

### 拒否リストメールドメイン {#denylist-email-domains}

特定のドメインのメールアドレスを使用する場合、ユーザーがサインアップするのをブロックできます。これにより、悪意のあるユーザーが使い捨てのメールアドレスでスパムアカウントを作成するリスクを軽減できます。

### メールドメイン許可リストまたは拒否リストを作成する {#create-email-domain-allowlist-or-denylist}

メールドメイン許可リストまたは拒否リストを作成するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. 許可リストの場合、リストを手動で入力する必要があります。拒否リストの場合、リストを手動で入力するか、リストエントリを含む`.txt`ファイルをアップロードできます。

   許可リストと拒否リストはどちらもワイルドカードを受け入れます。たとえば、`*.company.com`を使用してすべての`company.com`サブドメインを受け入れるか、`*.io`を使用して`.io`で終わるすべてのドメインをブロックできます。ドメインは、空白、セミコロン、カンマ、または改行で区切る必要があります。

   ![ファイルをアップロードするか、拒否リストを手動で入力するオプションを含むドメイン拒否リスト設定。](img/domain_denylist_v14_1.png)

## LDAPユーザーフィルターを設定する {#set-up-ldap-user-filter}

LDAPサーバー上のLDAPユーザーのサブセットに対して、GitLabアクセスを制限できます。

詳細については、[LDAPユーザーフィルターの設定](../auth/ldap/_index.md#set-up-ldap-user-filter)に関するドキュメントを参照してください。

## ロールプロモーションの管理者承認を有効にする {#turn-on-administrator-approval-for-role-promotions}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.9で`member_promotion_management`[フラグ](../feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/433166)されました。
- 機能フラグ`member_promotion_management`が`wip`から`beta`に[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167757/)、GitLab 17.5でデフォルトで有効になりました。
- 機能フラグ`member_promotion_management`は[削除されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187888)GitLab 18.0で。

{{< /history >}}

既存のユーザーがプロジェクトまたはグループ内で請求対象ロールにプロモートされるのを防ぐには、ロールプロモーションに対する管理者承認を有効にします。次に、[管理者の承認を保留しています]のプロモーションリクエストを[承認](../moderate_users.md#view-users-pending-role-promotion)または拒否できます。

- 管理者がグループまたはプロジェクトにユーザーを追加する場合:
  - 新しいユーザーロールが[請求対象](../../subscriptions/manage_users_and_seats.md#billable-users)の場合、そのユーザーに対する他のすべてのメンバーシップリクエストが自動的に承認されます。
  - 新しいユーザーロールが請求対象でない場合、そのユーザーに対する他のリクエストは、管理者の承認まで保留のままになります。

- 管理者でないユーザーがグループまたはプロジェクトにユーザーを追加する場合:
  - ユーザーがどのグループまたはプロジェクトにも請求対象ロールを持っておらず、請求対象ロールに追加またはプロモートされた場合、そのリクエストは[管理者の承認まで[保留](../moderate_users.md#view-users-pending-role-promotion)になります]。
  - ユーザーが既に請求対象ロールを持っている場合、管理者の承認は必要ありません。

前提要件: 

- 管理者である必要があります。

ロールプロモーションの承認を有効にするには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **新規登録の制限**を展開します。
1. **シートの管理**セクションで、**ロールの昇格を承認する**を選択します。
