---
stage: Software Supply Chain Security
group: Authorization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 認証と認可のベストプラクティス
description: 認証、認可、アクセス制御に関するセキュリティの推奨事項とベストプラクティス。
---

GitLabインスタンスを保護し、適切なアクセス制御を維持するために、これらのセキュリティのベストプラクティスに従ってください。これらの推奨事項は、組織全体の生産性を制限することなく、安全なアクセスを維持するのに役立ちます。

## セキュリティの原則 {#security-principles}

アクセス制御戦略の基盤となる基本的なセキュリティ原則を確立します。

### 最小特権の原則 {#principle-of-least-privilege}

作業を完了するために必要な最小限のユーザー権限をユーザーに付与します。この原則により、侵害されたアカウントまたはインサイダーの脅威による潜在的な損害を制限することで、セキュリティリスクが軽減されます。

- 作業を完了するために必要な最小限のユーザー権限をユーザーに付与します。
- トップレベルグループで最小限のデフォルトロール（最小アクセスまたはゲスト）を割り当て、必要に応じて特定のサブグループおよびプロジェクトでのみより高い権限を付与します。
- 機密性の高い設定へのアクセスを制限するカスタムロールを実装することにより、オーナーとメンテナーの数を最小限に抑える。
- トークンを作成するときは、可能な限り最も制限されたスコープを使用するか、特定の目的のために異なるスコープを持つ複数のトークンを作成します。

### 階層的な権限管理 {#hierarchical-permission-management}

組織構造に合わせて権限を整理し、管理上のオーバーヘッドを削減します。

- 可能な場合は、プロジェクトのメンバーシップ権限ではなく、グループメンバーシップ権限を適用して、管理上のオーバーヘッドを削減します。
- 組織用に単一のトップレベルグループを作成して、一元化されたアクセス制御とレポートを有効にします。
- 明確な所有権の境界を持つ組織構造に合わせて、グループ階層を編成します。

### 多層防御 {#defense-in-depth}

さまざまな種類の攻撃や失敗から保護するために、複数のセキュリティレイヤーを重ねます。1つの制御が失敗した場合、他の制御がバックアップ保護を提供します。

- 許可されていない変更を防ぐために、重要なアプリケーション用に[保護されたブランチ](../user/project/repository/branches/protected.md)をデプロイします。
- 特定のロールまたはユーザーへのデプロイを制限するために、[保護された環境](../ci/environments/protected_environments.md)を設定します。
- 機密性の高いアーティファクトのために、追加のセキュリティを追加するには、[保護されたコンテナ](../user/packages/container_registry/container_repository_protection_rules.md)を使用します。

## 認証と認証情報 {#authentication-and-credentials}

GitLabインスタンスへの不正アクセスを防ぐために、強力な認証方法を実装します。

### パスワードセキュリティ {#password-security}

パスワードは、その制限にもかかわらず、主要な認証方法のままです。強力なパスワードポリシーにより、認証情報ベースの攻撃のリスクが軽減されます。組織のセキュリティ標準を満たす強力なパスワードを要求します。

- セキュリティ要件に適切な[パスワードの長さ制限](../security/password_length_limits.md)を設定します。
- 既知の侵害されたパスワードの使用を防ぐために、[侵害されたパスワード検出](../security/compromised_password_detection.md)を有効にします。

### 2要素認証 {#two-factor-authentication}

2要素認証（2FA）は、2番目の検証形式を要求することにより、セキュリティを大幅に向上させます。パスワードが侵害された場合でも、2FAにより不正アクセスが防止されます。

- すべてのユーザー、特に高い権限を持つユーザーに対して[2要素認証](../user/profile/account/two_factor_authentication.md)を要求します。
- ユーザーの採用を確実にするために、2FA設定に関する明確なドキュメントとサポートを提供します。
- アカウントのロックアウトを防ぐために、バックアップリカバリー方法を実装します。

### トークンベースの認証 {#token-based-authentication}

トークンは、GitLabリソースへの安全なプログラムによるアクセスを提供します。トークンの種類が異なると、目的が異なり、セキュリティへの影響も異なります。

- [パーソナルアクセストークン](../user/profile/personal_access_tokens.md)を定期的、および有効期限が切れる前にローテーションします。
- 自動化されたプロセスには、パーソナルトークンの代わりに[グループアクセストークン](../user/group/settings/group_access_tokens.md)と[プロジェクトアクセストークン](../user/project/settings/project_access_tokens.md)を使用します。
- トークンを安全に保管し、リポジトリにコミットしないでください。

### SSHキー認証 {#ssh-key-authentication}

SSHキーは、Gitリポジトリへの安全なパスワードなしのアクセスを提供します。セキュリティを維持するには、適切なキー管理が不可欠です。

- 強力なSSHキーアルゴリズム（最低でもRSA 2048ビットまたはEd25519）を使用します。
- セキュリティ標準を適用するには、[SSHキー制限](../security/ssh_keys_restrictions.md)を設定します。
- 特にサービスアカウントの場合は、SSHキーを定期的に監査し、ローテーションします。

## アクセス制御の管理 {#access-management}

誰がどのリソースにアクセスできるかを制御し、それらの権限を長期的にモニタリングします。効果的なアクセス制御管理は、セキュリティ要件と運用効率性のバランスを取ります。

### ユーザータイプの管理 {#user-type-management}

ユーザータイプが異なると、組織との関係とセキュリティ要件に基づいて、異なるアクセスレベルが必要になります。ユーザーを適切に分類すると、適切なアクセス境界を適用するのに役立ちます。

- [外部ユーザー](../administration/external_users.md)として請負業者とサードパーティを指定して、内部プロジェクトへの表示レベルを自動的に制限します。
- リポジトリとのやり取りが制限されている外部コラボレーターにゲストロールを割り当てます。
- インスタンス全体の読み取り専用アクセスを必要とするコンプライアンスおよびセキュリティ担当者には、[監査担当者ユーザー](../administration/auditor_users.md)を使用します。

### 定期的なアクセスレビュー {#regular-access-reviews}

定期的なアクセスレビューにより、役割と責任が時間とともに変化するため、ユーザー権限が適切であることが保証されます。定期的なレビューは、セキュリティリスクになる前に、不適切なアクセスを特定し、修正するのに役立ちます。

- 定期的なアクセスレビューを実施して、ユーザー権限を検証し、不一致をすぐに解決します。
- [ユーザーエクスポート](../administration/admin_area.md#user-permission-export)および[グループエクスポート](../user/group/manage.md#export-members-as-csv)機能を使用して、包括的なアクセスレポートを生成します。
- ユーザーが組織を離れるか役割を変更した場合は、すぐにアクセスを削除します。

### アクセスのモニタリングと監査 {#access-monitoring-and-auditing}

アクセスパターンと権限の変更を継続的にモニタリングすることで、セキュリティインシデントを検出し、コンプライアンスを維持できます。監査証跡は、誰がいつ何にアクセスしたかの表示レベルを提供します。

- リアルタイムのセキュリティモニタリングのために、SIEMツールへの[監査イベントストリーミング](../administration/compliance/audit_event_streaming.md)を設定します。
- 未使用または過剰な特権を持つトークンを特定するために、[認証情報インベントリ](../user/group/credentials_inventory.md)を定期的に確認します。
- 不正なアクセスの変更または特権のエスカレーションがないかモニタリングします。

## 組織のスケーリング {#organizational-scaling}

組織の規模と構造が異なると、権限管理へのアプローチも異なります。成長に合わせて、アクセス制御プラクティスを適合させて、安全を確保してください。

### 基礎レベル（1〜50人のユーザー） {#foundation-level-1-50-users}

生産性を妨げる可能性のある複雑なプロセスなしに、優れた基盤を確立することに焦点を当てます。

- プロジェクトごとではなく、グループレベルでデフォルトロールから開始し、権限を割り当てます。
- 将来の参照のために、権限の決定と理論的根拠をドキュメント化します。
- コアチームにGitLab権限モデルとセキュリティプラクティスに関するトレーニングを実施します。
- 一貫したセキュリティプラクティスを適用するために、グループレベルのCI/CD設定を確立します。

### 成長レベル（50〜200人のユーザー） {#growth-level-50-200-users}

セキュリティ要件とスケーラブルなプロセスの必要性のバランスを取ります。

- ユーザーグループと[LDAP](../user/group/access_and_permissions.md#manage-group-memberships-with-ldap)または[SAML](../user/group/saml_sso/group_sync.md)を統合して、管理を簡素化します。
- 共有リソースと機密リソース用に個別のサブグループを作成して、アクセスを制御します。
- チームメンバー向けの正式なオンボーディングおよびオフボーディングプロセスを開発します。
- 深くネストされたグループ構造を最小限に抑える（ほとんどの組織で4〜5レベルに制限）。

### エンタープライズレベル（200人以上のユーザー） {#enterprise-level-200-users}

エンタープライズグレードの制御およびガバナンスプロセスを実装します。

- 特権ユーザーの数を減らしながら、独自のアクセスニーズに合わせて[カスタムロール](../user/custom_roles/_index.md)を開発します。
- GitLab APIを使用して大量のアクセス操作を自動化し、手動によるプロビジョニングのオーバーヘッドを削減します。
- ビジネスの中断を防ぐために、権限変更のためのガバナンスプロセスを確立します。
- 特権ロールと職務分離のためのコンプライアンスフレームワークへの時間制限付きアクセスを実装します。

## リポジトリとCI/CDのセキュリティ {#repository-and-cicd-security}

コード、デプロイ、および自動化されたプロセスを、不正な変更やアクセスから保護します。これらの制御により、ソフトウェア開発と配信パイプラインの整合性が確保されます。

### パイプラインセキュリティ {#pipeline-security}

CI/CDパイプラインは、アプリケーションをデプロイし、機密リソースにアクセスするための特権を持っていることがよくあります。パイプラインの実行を保護することで、不正なアクションを防ぎ、デプロイプロセスを保護します。

- パイプラインの実行中にアクセス可能なリソースを制御するには、[ジョブ権限](../ci/jobs/fine_grained_permissions.md)を使用します。
- 重要なデプロイステージの[承認ゲート](../ci/environments/deployment_approvals.md)を設定します。
- 環境固有のRunnerまたはRunnerタグを使用して、デプロイを分離し、機密性の高い本番リソースへのアクセスを制限します。

### リポジトリの保護 {#repository-protection}

ソースコードリポジトリには、組織の知的財産が含まれており、不正な変更から保護する必要があります。リポジトリのセキュリティ制御により、コードの整合性が確保され、悪意のある変更が防止されます。

- コミット標準を適用し、機密データの漏洩を防ぐために、[プッシュルール](../user/project/repository/push_rules.md)を実装します。
- 保護ブランチへの変更をマージする前に、承認ルールを介して[コードレビュー](../user/project/merge_requests/approvals/rules.md)を要求します。
- コミットの信頼性を暗号学的に検証するために、[署名されたコミット](../user/project/repository/signed_commits/_index.md)を使用します。

### APIと自動化のセキュリティ {#api-and-automation-security}

自動化されたプロセスとAPIインテグレーションでは、広範なアクセス権を持つ長期的な認証情報が使用されることがよくあります。これらの非ヒューマンアクセスパターンでは、認証情報の悪用を防ぐために、特別なセキュリティ上の考慮事項が必要です。

- パーソナルトークンではなく、自動化されたプロセスには、制限された権限を持つサービスアカウントを使用します。
- 自動化およびCI/CDパイプラインで使用される認証情報を定期的にローテーションします。
- 異常な動作または特権エスカレーションの試みについて、自動化されたアクセスパターンをモニタリングします。
- APIアクセス用のトークンを作成するときは、可能な限り最も具体的なスコープを使用します。
- APIインテグレーションのエラー処理とロギングを実装します。
- 悪用を防ぎ、システムの安定性を確保するために、APIリクエストのレート制限を行います。
