---
stage: none
group: unassigned
info: For help with this Community Programs page, see https://handbook.gitlab.com/handbook/marketing/developer-relations/community-programs/
description: Use GitLab for Education, Open Source, and Startups.
title: Community programs
---

GitLab provides the following community program subscriptions.

## GitLab for Education

For qualifying non-profit educational institutions, the [GitLab for Education Program](https://about.gitlab.com/solutions/education/) provides GitLab Ultimate, plus 50,000 compute minutes per month. The subscription granted under GitLab for Education can only be used for instructional use or non-commercial academic research. For more information, including instructions for applying to the program and renewing program membership, see the [GitLab for Education Program page](https://about.gitlab.com/solutions/education/) and the GitLab handbook.

## GitLab for Open Source

For qualifying open source projects, the [GitLab for Open Source Program](https://about.gitlab.com/solutions/open-source/) provides GitLab Ultimate, plus 50,000 compute minutes per month. For more information, including instructions for applying to the program and renewing program membership, see the [GitLab for Open Source Program page](https://about.gitlab.com/solutions/open-source/) and the GitLab handbook.

### Meeting GitLab for Open Source Program requirements

To meet GitLab for Open Source Program requirements, first add an OSI-approved open source license to all projects in your namespace.

To add a license to a project:

1. On the top bar, select **Search or go to** and find your project.
1. On the overview page, select **Add LICENSE**. If the license you want is not available as a license template, manually copy the entire, unaltered [text of your chosen license](https://opensource.org/license) into the `LICENSE` file. GitLab defaults to **All rights reserved** if users do not perform this action.

![Add license](img/add-license_v15_7.png)

Applicants must add the correct license to each project in their respective groups or namespaces. When you're sure you're using OSI-approved licenses for your projects, you can take your screenshots.

> [!note]
> GitLab for Open Source Program benefits apply to an entire GitLab namespace. To qualify for the GitLab for Open Source Program, all projects in your namespace must meet program requirements.

### Verification for Open Source Program

The verification process depends on where your projects are hosted:

- For projects on GitLab.com, verification is automatic.
- For projects on GitLab Self-Managed, when you submit your request, you must provide a link to the publicly accessible namespace that contains the projects.

GitLab verifies three aspects of your namespace:

- The namespace must be publicly accessible.
- Each project in the namespace must use an [OSI-approved license](https://opensource.org/licenses).
- Projects in the namespace must be publicly visible, except one private project is allowed for security purposes.

> [!note]
> Benefits of the GitLab Open Source Program apply to all projects in a GitLab namespace. All projects in an eligible namespace must meet program requirements.

## GitLab for Startups

For qualifying startups, the [GitLab for Startups](https://about.gitlab.com/solutions/startups/) program provides GitLab Ultimate, plus 50,000 compute minutes per month for 12 months. For more information, including instructions for applying to the program and renewing program membership, see the [GitLab for Startups Program page](https://about.gitlab.com/solutions/startups/) and the GitLab handbook.
