/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.c14n.helper.AttrCompare;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLSignatureInputDebugger {
    private Set<Node> xpathNodeSet;
    private Set<String> inclusiveNamespaces;
    private Writer writer;
    static final String HTMLPrefix = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n";
    static final String HTMLSuffix = "</pre></body></html>";
    static final String HTMLExcludePrefix = "<span class=\"EXCLUDED\">";
    static final String HTMLIncludePrefix = "<span class=\"INCLUDED\">";
    static final String HTMLIncludeOrExcludeSuffix = "</span>";
    static final String HTMLIncludedInclusiveNamespacePrefix = "<span class=\"INCLUDEDINCLUSIVENAMESPACE\">";
    static final String HTMLExcludedInclusiveNamespacePrefix = "<span class=\"EXCLUDEDINCLUSIVENAMESPACE\">";
    private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    static final AttrCompare ATTR_COMPARE = new AttrCompare();

    public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput) {
        this.xpathNodeSet = !xMLSignatureInput.isNodeSet() ? null : xMLSignatureInput.getInputNodeSet();
    }

    public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput, Set<String> set) {
        this(xMLSignatureInput);
        this.inclusiveNamespaces = set;
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        if (this.xpathNodeSet == null || this.xpathNodeSet.isEmpty()) {
            return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n<blink>no node set, sorry</blink></pre></body></html>";
        }
        Node node = this.xpathNodeSet.iterator().next();
        Document document = XMLUtils.getOwnerDocument(node);
        try {
            this.writer = new StringWriter();
            this.canonicalizeXPathNodeSet(document);
            this.writer.close();
            String string = this.writer.toString();
            return string;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
        finally {
            this.xpathNodeSet = null;
            this.writer = null;
        }
    }

    private void canonicalizeXPathNodeSet(Node node) throws XMLSignatureException, IOException {
        short s = node.getNodeType();
        switch (s) {
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new XMLSignatureException("empty", new Object[]{"An incorrect node was provided for c14n: " + s});
            }
            case 9: {
                this.writer.write(HTMLPrefix);
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node2);
                }
                this.writer.write(HTMLSuffix);
                break;
            }
            case 8: {
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                int n = this.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this.writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n == -1) {
                    this.writer.write("\n");
                }
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                break;
            }
            case 7: {
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                int n = this.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this.writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n == -1) {
                    this.writer.write("\n");
                }
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                break;
            }
            case 3: 
            case 4: {
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                this.outputTextToWriter(node.getNodeValue());
                for (Node node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4); node3 = node3.getNextSibling()) {
                    this.outputTextToWriter(node3.getNodeValue());
                }
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                this.writer.write("&lt;");
                this.writer.write(element.getTagName());
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                Attr[] attrArray = new Attr[n];
                for (int i = 0; i < n; ++i) {
                    attrArray[i] = (Attr)namedNodeMap.item(i);
                }
                Arrays.sort(attrArray, ATTR_COMPARE);
                Attr[] attrArray2 = attrArray;
                for (int i = 0; i < n; ++i) {
                    Attr attr = attrArray2[i];
                    boolean bl = this.xpathNodeSet.contains(attr);
                    boolean bl2 = this.inclusiveNamespaces.contains(attr.getName());
                    if (bl) {
                        if (bl2) {
                            this.writer.write(HTMLIncludedInclusiveNamespacePrefix);
                        } else {
                            this.writer.write(HTMLIncludePrefix);
                        }
                    } else if (bl2) {
                        this.writer.write(HTMLExcludedInclusiveNamespacePrefix);
                    } else {
                        this.writer.write(HTMLExcludePrefix);
                    }
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                    this.writer.write(HTMLIncludeOrExcludeSuffix);
                }
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                this.writer.write("&gt;");
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node4);
                }
                if (this.xpathNodeSet.contains(node)) {
                    this.writer.write(HTMLIncludePrefix);
                } else {
                    this.writer.write(HTMLExcludePrefix);
                }
                this.writer.write("&lt;/");
                this.writer.write(element.getTagName());
                this.writer.write("&gt;");
                this.writer.write(HTMLIncludeOrExcludeSuffix);
                break;
            }
        }
    }

    private int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != element) continue;
            return -1;
        }
        return 1;
    }

    private void outputAttrToWriter(String string, String string2) throws IOException {
        this.writer.write(" ");
        this.writer.write(string);
        this.writer.write("=\"");
        int n = string2.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    this.writer.write("&amp;amp;");
                    continue block8;
                }
                case '<': {
                    this.writer.write("&amp;lt;");
                    continue block8;
                }
                case '\"': {
                    this.writer.write("&amp;quot;");
                    continue block8;
                }
                case '\t': {
                    this.writer.write("&amp;#x9;");
                    continue block8;
                }
                case '\n': {
                    this.writer.write("&amp;#xA;");
                    continue block8;
                }
                case '\r': {
                    this.writer.write("&amp;#xD;");
                    continue block8;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
        this.writer.write("\"");
    }

    private void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        int n;
        if (processingInstruction == null) {
            return;
        }
        this.writer.write("&lt;?");
        String string = processingInstruction.getTarget();
        int n2 = string.length();
        block8: for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            switch (n) {
                case 13: {
                    this.writer.write("&amp;#xD;");
                    continue block8;
                }
                case 32: {
                    this.writer.write("&middot;");
                    continue block8;
                }
                case 10: {
                    this.writer.write("&para;\n");
                    continue block8;
                }
                default: {
                    this.writer.write(n);
                }
            }
        }
        String string2 = processingInstruction.getData();
        n2 = string2.length();
        if (n2 > 0) {
            this.writer.write(" ");
            block9: for (n = 0; n < n2; ++n) {
                char c = string2.charAt(n);
                switch (c) {
                    case '\r': {
                        this.writer.write("&amp;#xD;");
                        continue block9;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
        }
        this.writer.write("?&gt;");
    }

    private void outputCommentToWriter(Comment comment) throws IOException {
        if (comment == null) {
            return;
        }
        this.writer.write("&lt;!--");
        String string = comment.getData();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    this.writer.write("&amp;#xD;");
                    continue block5;
                }
                case ' ': {
                    this.writer.write("&middot;");
                    continue block5;
                }
                case '\n': {
                    this.writer.write("&para;\n");
                    continue block5;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
        this.writer.write("--&gt;");
    }

    private void outputTextToWriter(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    this.writer.write("&amp;amp;");
                    continue block8;
                }
                case '<': {
                    this.writer.write("&amp;lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.write("&amp;gt;");
                    continue block8;
                }
                case '\r': {
                    this.writer.write("&amp;#xD;");
                    continue block8;
                }
                case ' ': {
                    this.writer.write("&middot;");
                    continue block8;
                }
                case '\n': {
                    this.writer.write("&para;\n");
                    continue block8;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }
}

