/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sun.security.action.GetBooleanAction;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVAKeyword;
import sun.security.x509.X500Name;

public class AVA
implements DerEncoder {
    private static final Debug debug = Debug.getInstance("x509", "\t[AVA]");
    private static final boolean PRESERVE_OLD_DC_ENCODING = AccessController.doPrivileged(new GetBooleanAction("com.sun.security.preserveOldDCEncoding"));
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    final ObjectIdentifier oid;
    final DerValue value;
    private static final String specialChars1779 = ",=\n+<>#;\\\"";
    private static final String specialChars2253 = ",=+<>#;\\\"";
    private static final String specialCharsDefault = ",=\n+<>#;\\\" ";
    private static final String escapedDefault = ",+<>;\"";
    private static final String hexDigits = "0123456789ABCDEF";

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (objectIdentifier == null || derValue == null) {
            throw new NullPointerException();
        }
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    AVA(Reader reader, Map<String, String> map) throws IOException {
        this(reader, 1, map);
    }

    AVA(Reader reader, int n) throws IOException {
        this(reader, n, Collections.emptyMap());
    }

    AVA(Reader reader, int n, Map<String, String> map) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n2 = AVA.readChar(reader, "Incorrect AVA format")) != 61) {
            stringBuilder.append((char)n2);
        }
        this.oid = AVAKeyword.getOID(stringBuilder.toString(), n, map);
        stringBuilder.setLength(0);
        if (n == 3) {
            n2 = reader.read();
            if (n2 == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((n2 = reader.read()) == 32 || n2 == 10) {
            }
        }
        if (n2 == -1) {
            this.value = new DerValue("");
            return;
        }
        this.value = n2 == 35 ? AVA.parseHexString(reader, n) : (n2 == 34 && n != 3 ? this.parseQuotedString(reader, stringBuilder) : this.parseString(reader, n2, n, stringBuilder));
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    public DerValue getDerValue() {
        return this.value;
    }

    public String getValueString() {
        try {
            String string = this.value.getAsString();
            if (string == null) {
                throw new RuntimeException("AVA string is null");
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("AVA error: " + iOException, iOException);
        }
    }

    private static DerValue parseHexString(Reader reader, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        while (!AVA.isTerminator(n2 = reader.read(), n)) {
            int n5 = hexDigits.indexOf(Character.toUpperCase((char)n2));
            if (n5 == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)n2);
            }
            if (n4 % 2 == 1) {
                n3 = (byte)(n3 * 16 + (byte)n5);
                byteArrayOutputStream.write(n3);
            } else {
                n3 = (byte)n5;
            }
            ++n4;
        }
        if (n4 == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (n4 % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(byteArrayOutputStream.toByteArray());
    }

    private DerValue parseQuotedString(Reader reader, StringBuilder stringBuilder) throws IOException {
        Object object;
        int n = AVA.readChar(reader, "Quoted string did not end in quote");
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        boolean bl = true;
        while (n != 34) {
            if (n == 92) {
                n = AVA.readChar(reader, "Quoted string did not end in quote");
                object = null;
                object = AVA.getEmbeddedHexPair(n, reader);
                if (object != null) {
                    bl = false;
                    arrayList.add((Byte)object);
                    n = reader.read();
                    continue;
                }
                if (specialChars1779.indexOf((char)n) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)n);
                }
            }
            if (arrayList.size() > 0) {
                object = AVA.getEmbeddedHexString(arrayList);
                stringBuilder.append((String)object);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            stringBuilder.append((char)n);
            n = AVA.readChar(reader, "Quoted string did not end in quote");
        }
        if (arrayList.size() > 0) {
            object = AVA.getEmbeddedHexString(arrayList);
            stringBuilder.append((String)object);
            arrayList.clear();
        }
        while ((n = reader.read()) == 10 || n == 32) {
        }
        if (n != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals((Object)PKCS9Attribute.EMAIL_ADDRESS_OID) || this.oid.equals((Object)X500Name.DOMAIN_COMPONENT_OID) && !PRESERVE_OLD_DC_ENCODING) {
            return new DerValue(22, stringBuilder.toString().trim());
        }
        if (bl) {
            return new DerValue(stringBuilder.toString().trim());
        }
        return new DerValue(12, stringBuilder.toString().trim());
    }

    private DerValue parseString(Reader reader, int n, int n2, StringBuilder stringBuilder) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 0;
        do {
            bl2 = false;
            if (n == 92) {
                bl2 = true;
                n = AVA.readChar(reader, "Invalid trailing backslash");
                Byte by = null;
                by = AVA.getEmbeddedHexPair(n, reader);
                if (by != null) {
                    bl = false;
                    arrayList.add(by);
                    n = reader.read();
                    bl3 = false;
                    continue;
                }
                if (n2 == 1 && specialCharsDefault.indexOf((char)n) == -1) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                }
                if (n2 == 3) {
                    if (n == 32) {
                        if (!bl3 && !AVA.trailingSpace(reader)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (n == 35) {
                        if (!bl3) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)n) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                    }
                }
            } else if (n2 == 3 ? specialChars2253.indexOf((char)n) != -1 : escapedDefault.indexOf((char)n) != -1) {
                throw new IOException("Character '" + (char)n + "' in AVA appears without escape");
            }
            if (arrayList.size() > 0) {
                for (int i = 0; i < n3; ++i) {
                    stringBuilder.append(" ");
                }
                n3 = 0;
                String string = AVA.getEmbeddedHexString(arrayList);
                stringBuilder.append(string);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            if (n == 32 && !bl2) {
                ++n3;
            } else {
                for (int i = 0; i < n3; ++i) {
                    stringBuilder.append(" ");
                }
                n3 = 0;
                stringBuilder.append((char)n);
            }
            n = reader.read();
            bl3 = false;
        } while (!AVA.isTerminator(n, n2));
        if (n2 == 3 && n3 > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (arrayList.size() > 0) {
            String string = AVA.getEmbeddedHexString(arrayList);
            stringBuilder.append(string);
            arrayList.clear();
        }
        if (this.oid.equals((Object)PKCS9Attribute.EMAIL_ADDRESS_OID) || this.oid.equals((Object)X500Name.DOMAIN_COMPONENT_OID) && !PRESERVE_OLD_DC_ENCODING) {
            return new DerValue(22, stringBuilder.toString());
        }
        if (bl) {
            return new DerValue(stringBuilder.toString());
        }
        return new DerValue(12, stringBuilder.toString());
    }

    private static Byte getEmbeddedHexPair(int n, Reader reader) throws IOException {
        if (hexDigits.indexOf(Character.toUpperCase((char)n)) >= 0) {
            int n2 = AVA.readChar(reader, "unexpected EOF - escaped hex value must include two valid digits");
            if (hexDigits.indexOf(Character.toUpperCase((char)n2)) >= 0) {
                int n3 = Character.digit((char)n, 16);
                int n4 = Character.digit((char)n2, 16);
                return new Byte((byte)((n3 << 4) + n4));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static String getEmbeddedHexString(List<Byte> list) throws IOException {
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = list.get(i);
        }
        return new String(byArray, "UTF8");
    }

    private static boolean isTerminator(int n, int n2) {
        switch (n) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: {
                return n2 != 3;
            }
        }
        return false;
    }

    private static int readChar(Reader reader, String string) throws IOException {
        int n = reader.read();
        if (n == -1) {
            throw new IOException(string);
        }
        return n;
    }

    private static boolean trailingSpace(Reader reader) throws IOException {
        boolean bl;
        block3: {
            block4: {
                bl = false;
                if (!reader.markSupported()) {
                    return true;
                }
                reader.mark(9999);
                while (true) {
                    int n;
                    if ((n = reader.read()) == -1) {
                        bl = true;
                        break block3;
                    }
                    if (n == 32) continue;
                    if (n != 92) break block4;
                    int n2 = reader.read();
                    if (n2 != 32) break;
                }
                bl = false;
                break block3;
            }
            bl = false;
        }
        reader.reset();
        return bl;
    }

    AVA(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("AVA not a sequence");
        }
        this.oid = derValue.data.getOID();
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
        if (this.value.tag == 30) {
            this.value.validateBMPString();
        }
    }

    AVA(DerInputStream derInputStream) throws IOException {
        this(derInputStream.getDerValue());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    private String toKeyword(int n, Map<String, String> map) {
        return AVAKeyword.getKeyword(this.oid, n, map);
    }

    public String toString() {
        return this.toKeywordValueString(this.toKeyword(1, Collections.emptyMap()));
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.emptyMap());
    }

    public String toRFC1779String(Map<String, String> map) {
        return this.toKeywordValueString(this.toKeyword(2, map));
    }

    public String toRFC2253String() {
        return this.toRFC2253String(Collections.emptyMap());
    }

    public String toRFC2253String(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.toKeyword(3, map));
        stringBuilder.append('=');
        if (stringBuilder.charAt(0) >= '0' && stringBuilder.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] byArray = null;
            try {
                byArray = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuilder.append('#');
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuilder.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            int n;
            char c;
            int n2;
            char c2;
            String string = null;
            try {
                string = new String(this.value.getDataBytes(), AVA.getCharset(this.value, false));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                c2 = string.charAt(i);
                if (DerValue.isPrintableStringChar(c2) || ",=+<>#;\"\\".indexOf(c2) >= 0) {
                    if (",=+<>#;\"\\".indexOf(c2) >= 0) {
                        stringBuilder2.append('\\');
                    }
                    stringBuilder2.append(c2);
                    continue;
                }
                if (c2 == '\u0000') {
                    stringBuilder2.append("\\00");
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c2).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        stringBuilder2.append('\\');
                        c = Character.forDigit(0xF & byArray[n2] >>> 4, 16);
                        stringBuilder2.append(Character.toUpperCase(c));
                        c = Character.forDigit(0xF & byArray[n2], 16);
                        stringBuilder2.append(Character.toUpperCase(c));
                    }
                    continue;
                }
                stringBuilder2.append(c2);
            }
            char[] cArray = stringBuilder2.toString().toCharArray();
            stringBuilder2 = new StringBuilder();
            for (c2 = '\u0000'; c2 < cArray.length && (cArray[c2] == ' ' || cArray[c2] == '\r'); ++c2) {
            }
            for (n = cArray.length - 1; n >= 0 && (cArray[n] == ' ' || cArray[n] == '\r'); --n) {
            }
            for (n2 = 0; n2 < cArray.length; ++n2) {
                c = cArray[n2];
                if (n2 < c2 || n2 > n) {
                    stringBuilder2.append('\\');
                }
                stringBuilder2.append(c);
            }
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(this.toKeyword(3, Collections.emptyMap()));
        stringBuilder.append('=');
        if (stringBuilder.charAt(0) >= '0' && stringBuilder.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            object = null;
            try {
                object = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuilder.append('#');
            for (int i = 0; i < ((byte[])object).length; ++i) {
                byte by = object[i];
                stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuilder.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            object = null;
            try {
                object = new String(this.value.getDataBytes(), AVA.getCharset(this.value, true));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < ((String)object).length(); ++i) {
                char c = ((String)object).charAt(i);
                if (DerValue.isPrintableStringChar(c) || ",+<>;\"\\".indexOf(c) >= 0 || i == 0 && c == '#') {
                    if (i == 0 && c == '#' || ",+<>;\"\\".indexOf(c) >= 0) {
                        stringBuilder2.append('\\');
                    }
                    if (!Character.isWhitespace(c)) {
                        bl = false;
                        stringBuilder2.append(c);
                        continue;
                    }
                    if (bl) continue;
                    bl = true;
                    stringBuilder2.append(c);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    bl = false;
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (int j = 0; j < byArray.length; ++j) {
                        stringBuilder2.append('\\');
                        stringBuilder2.append(Character.forDigit(0xF & byArray[j] >>> 4, 16));
                        stringBuilder2.append(Character.forDigit(0xF & byArray[j], 16));
                    }
                    continue;
                }
                bl = false;
                stringBuilder2.append(c);
            }
            stringBuilder.append(stringBuilder2.toString().trim());
        }
        object = stringBuilder.toString();
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        return Normalizer.normalize((CharSequence)object, Normalizer.Form.NFKD);
    }

    private static boolean isDerString(DerValue derValue, boolean bl) {
        if (bl) {
            switch (derValue.tag) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (derValue.tag) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static Charset getCharset(DerValue derValue, boolean bl) {
        if (bl) {
            switch (derValue.tag) {
                case 19: {
                    return StandardCharsets.ISO_8859_1;
                }
                case 12: {
                    return StandardCharsets.UTF_8;
                }
            }
            throw new Error("unexpected tag: " + derValue.tag);
        }
        switch (derValue.tag) {
            case 19: 
            case 20: 
            case 22: 
            case 27: {
                return StandardCharsets.ISO_8859_1;
            }
            case 30: {
                return StandardCharsets.UTF_16BE;
            }
            case 12: {
                return StandardCharsets.UTF_8;
            }
        }
        throw new Error("unexpected tag: " + derValue.tag);
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    private String toKeywordValueString(String string) {
        StringBuilder stringBuilder;
        block17: {
            stringBuilder = new StringBuilder(40);
            stringBuilder.append(string);
            stringBuilder.append("=");
            try {
                int n;
                String string2 = this.value.getAsString();
                if (string2 == null) {
                    byte[] byArray = this.value.toByteArray();
                    stringBuilder.append('#');
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuilder.append(hexDigits.charAt(byArray[i] >> 4 & 0xF));
                        stringBuilder.append(hexDigits.charAt(byArray[i] & 0xF));
                    }
                    break block17;
                }
                boolean bl = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl2 = false;
                int n2 = string2.length();
                boolean bl3 = n2 > 1 && string2.charAt(0) == '\"' && string2.charAt(n2 - 1) == '\"';
                for (n = 0; n < n2; ++n) {
                    char c = string2.charAt(n);
                    if (bl3 && (n == 0 || n == n2 - 1)) {
                        stringBuilder2.append(c);
                        continue;
                    }
                    if (DerValue.isPrintableStringChar(c) || ",+=\n<>#;\\\"".indexOf(c) >= 0) {
                        if (!(bl || (n != 0 || c != ' ' && c != '\n') && ",+=\n<>#;\\\"".indexOf(c) < 0)) {
                            bl = true;
                        }
                        if (c != ' ' && c != '\n') {
                            if (c == '\"' || c == '\\') {
                                stringBuilder2.append('\\');
                            }
                            bl2 = false;
                        } else {
                            if (!bl && bl2) {
                                bl = true;
                            }
                            bl2 = true;
                        }
                        stringBuilder2.append(c);
                        continue;
                    }
                    if (debug != null && Debug.isOn("ava")) {
                        bl2 = false;
                        byte[] byArray = Character.toString(c).getBytes("UTF8");
                        for (int i = 0; i < byArray.length; ++i) {
                            stringBuilder2.append('\\');
                            char c2 = Character.forDigit(0xF & byArray[i] >>> 4, 16);
                            stringBuilder2.append(Character.toUpperCase(c2));
                            c2 = Character.forDigit(0xF & byArray[i], 16);
                            stringBuilder2.append(Character.toUpperCase(c2));
                        }
                        continue;
                    }
                    bl2 = false;
                    stringBuilder2.append(c);
                }
                if (stringBuilder2.length() > 0 && ((n = (int)stringBuilder2.charAt(stringBuilder2.length() - 1)) == 32 || n == 10)) {
                    bl = true;
                }
                if (!bl3 && bl) {
                    stringBuilder.append("\"" + stringBuilder2.toString() + "\"");
                } else {
                    stringBuilder.append(stringBuilder2.toString());
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
        }
        return stringBuilder.toString();
    }
}

