/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class TimestampRouter<R extends ConnectRecord<R>>
implements Transformation<R>,
AutoCloseable,
Versioned {
    private static final Pattern TOPIC = Pattern.compile("${topic}", 16);
    private static final Pattern TIMESTAMP = Pattern.compile("${timestamp}", 16);
    public static final String OVERVIEW_DOC = "Update the record's topic field as a function of the original topic value and the record timestamp.<p/>This is mainly useful for sink connectors, since the topic field is often used to determine the equivalent entity name in the destination system(e.g. database table or search index name).";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("topic.format", ConfigDef.Type.STRING, (Object)"${topic}-${timestamp}", ConfigDef.Importance.HIGH, "Format string which can contain <code>${topic}</code> and <code>${timestamp}</code> as placeholders for the topic and timestamp, respectively.").define("timestamp.format", ConfigDef.Type.STRING, (Object)"yyyyMMdd", ConfigDef.Importance.HIGH, "Format string for the timestamp that is compatible with <code>java.text.SimpleDateFormat</code>.");
    private String topicFormat;
    private ThreadLocal<SimpleDateFormat> timestampFormat;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.topicFormat = config.getString("topic.format");
        String timestampFormatStr = config.getString("timestamp.format");
        this.timestampFormat = ThreadLocal.withInitial(() -> {
            SimpleDateFormat fmt = new SimpleDateFormat(timestampFormatStr);
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            return fmt;
        });
    }

    public R apply(R record) {
        Long timestamp = record.timestamp();
        if (timestamp == null) {
            throw new DataException("Timestamp missing on record: " + String.valueOf(record));
        }
        String formattedTimestamp = this.timestampFormat.get().format(new Date(timestamp));
        String replace1 = TOPIC.matcher(this.topicFormat).replaceAll(Matcher.quoteReplacement(record.topic()));
        String updatedTopic = TIMESTAMP.matcher(replace1).replaceAll(Matcher.quoteReplacement(formattedTimestamp));
        return (R)record.newRecord(updatedTopic, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp());
    }

    @Override
    public void close() {
        this.timestampFormat.remove();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    private static interface ConfigName {
        public static final String TOPIC_FORMAT = "topic.format";
        public static final String TIMESTAMP_FORMAT = "timestamp.format";
    }
}

