<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Adapter\FileSystem;

use DateTime;
use OCA\News\Vendor\FeedIo\Adapter\ClientInterface;
use OCA\News\Vendor\FeedIo\Adapter\NotFoundException;
use OCA\News\Vendor\FeedIo\Adapter\ResponseInterface;
/**
 * Filesystem client
 */
class Client implements ClientInterface
{
    /**
     * @param  string                            $path
     * @param  \DateTime                         $modifiedSince
     * @return \FeedIo\Adapter\ResponseInterface
     *@throws \FeedIo\Adapter\NotFoundException
     */
    public function getResponse(string $path, ?DateTime $modifiedSince = null): ResponseInterface
    {
        if (file_exists($path)) {
            return new Response(file_get_contents($path), new DateTime('@' . filemtime($path)));
        }
        throw new NotFoundException();
    }
}
