"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _icon = require("../icon");
var _accessibility = require("../accessibility");
var _text = require("../text");
var _services = require("../../services");
var _inner_text = require("../inner_text");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiTreeViewContext = /*#__PURE__*/(0, _react.createContext)('');
function hasAriaLabel(x) {
  return x.hasOwnProperty('aria-label');
}
function getTreeId(propId, contextId, idGenerator) {
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
var displayToClassNameMap = {
  default: null,
  compressed: 'euiTreeView--compressed'
};
var EuiTreeView = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiTreeView, _Component);
  var _super = _createSuper(EuiTreeView);
  function EuiTreeView() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiTreeView);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "treeIdGenerator", (0, _services.htmlIdGenerator)('euiTreeView'));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isNested", !!_this.context);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, _this.context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "buttonRef", []);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat((0, _toConsumableArray2.default)(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyDown", function (event, node) {
      switch (event.key) {
        case _services.keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case _services.keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildrenKeydown", function (event, index) {
      if (event.key === _services.keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    return _this;
  }
  (0, _createClass2.default)(EuiTreeView, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows"]); // Computed classNames
      var classes = (0, _classnames.default)('euiTreeView', display ? displayToClassNameMap[display] : null, {
        'euiTreeView--withArrows': showExpansionArrows
      }, className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return /*#__PURE__*/_react.default.createElement(EuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, /*#__PURE__*/_react.default.createElement(_text.EuiText, {
        size: display === 'compressed' ? 's' : 'm',
        className: "euiTreeView__wrapper"
      }, !this.isNested && /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        return /*#__PURE__*/_react.default.createElement(_inner_text.EuiInnerText, {
          key: node.id + index,
          fallback: typeof node.label === 'string' ? node.label : ''
        }, function (ref, innerText) {
          return /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
            key: node.id + index,
            token: "euiTreeView.ariaLabel",
            default: "{nodeLabel} child of {ariaLabel}",
            values: {
              nodeLabel: innerText,
              ariaLabel: hasAriaLabel(rest) ? rest['aria-label'] : ''
            }
          }, function (ariaLabel) {
            var label = hasAriaLabel(rest) ? {
              'aria-label': ariaLabel
            } : {
              'aria-labelledby': "".concat(buttonId, " ").concat(rest['aria-labelledby'])
            };
            var nodeClasses = (0, _classnames.default)('euiTreeView__node', display ? displayToClassNameMap[display] : null, {
              'euiTreeView__node--expanded': _this2.isNodeOpen(node)
            });
            var nodeButtonClasses = (0, _classnames.default)('euiTreeView__nodeInner', showExpansionArrows && node.children ? 'euiTreeView__nodeInner--withArrows' : null, _this2.state.activeItem === node.id ? 'euiTreeView__node--active' : null, node.className ? node.className : null);
            return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("li", {
              className: nodeClasses
            }, /*#__PURE__*/_react.default.createElement("button", {
              id: buttonId,
              "aria-controls": wrappingId,
              "aria-expanded": _this2.isNodeOpen(node),
              ref: function ref(_ref3) {
                return _this2.setButtonRef(_ref3, index);
              },
              "data-test-subj": "euiTreeViewButton-".concat(_this2.state.treeID),
              onKeyDown: function onKeyDown(event) {
                return _this2.onKeyDown(event, node);
              },
              onClick: function onClick() {
                return _this2.handleNodeClick(node);
              },
              className: nodeButtonClasses
            }, showExpansionArrows && node.children ? /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
              className: "euiTreeView__expansionArrow",
              size: display === 'compressed' ? 's' : 'm',
              type: _this2.isNodeOpen(node) ? 'arrowDown' : 'arrowRight'
            }) : null, node.icon && !node.useEmptyIcon ? /*#__PURE__*/_react.default.createElement("span", {
              className: "euiTreeView__iconWrapper"
            }, _this2.isNodeOpen(node) && node.iconWhenExpanded ? node.iconWhenExpanded : node.icon) : null, node.useEmptyIcon && !node.icon ? /*#__PURE__*/_react.default.createElement("span", {
              className: "euiTreeView__iconPlaceholder"
            }) : null, /*#__PURE__*/_react.default.createElement("span", {
              ref: ref,
              className: "euiTreeView__nodeLabel"
            }, node.label)), /*#__PURE__*/_react.default.createElement("div", {
              id: wrappingId,
              onKeyDown: function onKeyDown(event) {
                return _this2.onChildrenKeydown(event, index);
              }
            }, node.children && _this2.isNodeOpen(node) ? /*#__PURE__*/_react.default.createElement(EuiTreeView, (0, _extends2.default)({
              items: node.children,
              display: display,
              showExpansionArrows: showExpansionArrows,
              expandByDefault: _this2.state.expandChildNodes
            }, label)) : null)));
          });
        });
      }))));
    }
  }]);
  return EuiTreeView;
}(_react.Component);
exports.EuiTreeView = EuiTreeView;
(0, _defineProperty2.default)(EuiTreeView, "contextType", EuiTreeViewContext);
EuiTreeView.propTypes = {
  className: _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /** An array of EuiTreeViewNodes
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /** An array of EuiTreeViewNodes to render as children
       */
    children: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /** The readable label for the item
       */
    label: _propTypes.default.node.isRequired,
    /** A unique ID
       */
    id: _propTypes.default.string.isRequired,
    /** An icon to use on the left of the label
       */
    icon: _propTypes.default.element,
    /** Display a different icon when the item is expanded.
      For instance, an open folder or a down arrow
      */
    iconWhenExpanded: _propTypes.default.element,
    /** Use an empty icon to keep items without an icon
      lined up with their siblings
      */
    useEmptyIcon: _propTypes.default.bool,
    /** Whether or not the item is expanded.
       */
    isExpanded: _propTypes.default.bool,
    /** Optional class to throw on the node
       */
    className: _propTypes.default.string,
    /** Function to call when the item is clicked.
       The open state of the item will always be toggled.
       */
    callback: _propTypes.default.func
  }).isRequired).isRequired,
  /** Optionally use a variation with smaller text and icon sizes
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  /** Set all items to open on initial load
       */
  expandByDefault: _propTypes.default.bool,
  /** Display expansion arrows next to all items
       * that contain children
       */
  showExpansionArrows: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "aria-labelledby": _propTypes.default.string
};