/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.patterns;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.sql.common.patterns.BrainLogParser;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.BufferPatternRowsWindowFrame;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.utils.ExpressionUtils;
import org.opensearch.sql.utils.FunctionUtils;

public class BufferPatternWindowFunction
extends FunctionExpression
implements WindowFunctionExpression {
    public BufferPatternWindowFunction(List<Expression> arguments) {
        super(BuiltinFunctionName.BRAIN.getName(), arguments);
    }

    @Override
    public WindowFrame createWindowFrame(WindowDefinition definition) {
        int variableCountThreshold = FunctionUtils.getNamedArgumentValue(this.getArguments(), "variable_count_threshold").map(ExprValue::integerValue).orElse(5);
        float thresholdPercentage = FunctionUtils.getNamedArgumentValue(this.getArguments(), "frequency_threshold_percentage").map(ExprValue::floatValue).orElse(Float.valueOf(0.3f)).floatValue();
        return new BufferPatternRowsWindowFrame(definition, new BrainLogParser(variableCountThreshold, thresholdPercentage), this.getArguments().get(0));
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        BufferPatternRowsWindowFrame frame = (BufferPatternRowsWindowFrame)valueEnv;
        List<String> preprocessedMessage = frame.currentPreprocessedMessage();
        frame.next();
        List logPattern = frame.getLogParser().parseLogPattern(preprocessedMessage);
        return new ExprStringValue(String.join((CharSequence)" ", logPattern));
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getFunctionName(), ExpressionUtils.format(this.getArguments()));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BufferPatternWindowFunction)) {
            return false;
        }
        BufferPatternWindowFunction other = (BufferPatternWindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BufferPatternWindowFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

