/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class FunctionSqlType
extends AbstractSqlType {
    private final RelDataType parameterTypes;
    private final RelDataType returnType;

    public FunctionSqlType(RelDataType parameterTypes, RelDataType returnType) {
        super(SqlTypeName.FUNCTION, true, null);
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes");
        if (!parameterTypes.isStruct()) {
            throw new IllegalArgumentException("ParameterType must be a struct");
        }
        this.returnType = Objects.requireNonNull(returnType, "returnType");
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("Function");
        sb.append("(");
        for (Ord ord : Ord.zip(this.parameterTypes.getFieldList())) {
            if (ord.i > 0) {
                sb.append(", ");
            }
            RelDataTypeField field = (RelDataTypeField)ord.e;
            sb.append(withDetail ? field.getType().getFullTypeString() : field.getType().toString());
        }
        sb.append(")");
        sb.append(" -> ");
        sb.append(withDetail ? this.returnType.getFullTypeString() : this.returnType.toString());
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    public RelDataType getParameterTypes() {
        return this.parameterTypes;
    }

    public RelDataType getReturnType() {
        return this.returnType;
    }
}

