/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPairwiseVisitor;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public abstract class OWLNaryClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLNaryClassAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLClassExpression> classExpressions;

    public OWLNaryClassAxiomImpl(@Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(classExpressions, "classExpressions cannot be null");
        this.classExpressions = CollectionFactory.sortOptionally(classExpressions);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.classExpressions);
    }

    @Override
    public List<OWLClassExpression> getClassExpressionsAsList() {
        return new ArrayList<OWLClassExpression>(this.classExpressions);
    }

    @Override
    public boolean contains(OWLClassExpression ce) {
        return this.classExpressions.contains(ce);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... desc) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>(this.classExpressions);
        for (OWLClassExpression d : desc) {
            result.remove(d);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLNaryClassAxiom)) {
            return false;
        }
        if (obj instanceof OWLNaryClassAxiomImpl) {
            return this.classExpressions.equals(((OWLNaryClassAxiomImpl)obj).classExpressions);
        }
        return this.compareObjectOfSameType((OWLNaryClassAxiom)obj) == 0;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLNaryClassAxiomImpl.compareLists(this.classExpressions, ((OWLNaryClassAxiom)object).getClassExpressionsAsList());
    }

    @Override
    public <T> Collection<T> walkPairwise(OWLPairwiseVisitor<T, OWLClassExpression> visitor) {
        ArrayList<T> l = new ArrayList<T>();
        for (int i = 0; i < this.classExpressions.size() - 1; ++i) {
            for (int j = i + 1; j < this.classExpressions.size(); ++j) {
                T t = visitor.visit(this.classExpressions.get(i), this.classExpressions.get(j));
                if (t == null) continue;
                l.add(t);
            }
        }
        return l;
    }
}

