/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGrayscaleMorphologicalOpeningImageFilter_h
#define sitkGrayscaleMorphologicalOpeningImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class GrayscaleMorphologicalOpeningImageFilter
\brief Grayscale opening of an image.

Open an image using grayscale morphology.

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel.

\see MorphologyImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
\sa itk::simple::GrayscaleMorphologicalOpening for the procedural interface
\sa itk::GrayscaleMorphologicalOpeningImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GrayscaleMorphologicalOpeningImageFilter : public ImageFilter {
    public:
      using Self = GrayscaleMorphologicalOpeningImageFilter;

      /** Destructor */
      virtual ~GrayscaleMorphologicalOpeningImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GrayscaleMorphologicalOpeningImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set the radius of the kernel structuring element.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius ( std::vector<unsigned int> KernelRadius ) { this->m_KernelRadius = std::move(KernelRadius); return *this; }

      /** Set the values of the KernelRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius( unsigned int value ) { this->m_KernelRadius = std::vector<unsigned int>(3, value); return *this; }

      /**
       * Get the radius of the kernel structuring element.
       */
      std::vector<unsigned int> GetKernelRadius() const { return this->m_KernelRadius; }\

      /**
       * Set the kernel or structuring element used for the morphology.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType ( KernelEnum KernelType ) { this->m_KernelType = KernelType; return *this; }

      /**
       * Get the kernel or structuring element used for the morphology.
       */
      KernelEnum GetKernelType() const { return this->m_KernelType; }\

      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSafeBorder ( bool SafeBorder ) { this->m_SafeBorder = SafeBorder; return *this; }

      /** Set the value of SafeBorder to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOn() { return this->SetSafeBorder(true); }
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOff() { return this->SetSafeBorder(false); }

      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
      bool GetSafeBorder() const { return this->m_SafeBorder; }

      /** Name of this class */
      std::string GetName() const { return std::string ("GrayscaleMorphologicalOpeningImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_KernelRadius{std::vector<uint32_t>(3, 1)};

      KernelEnum  m_KernelType{itk::simple::sitkBall};

      /*  */
      bool  m_SafeBorder{true};


    };

    /**\
     * \brief Grayscale opening of an image.
     *
     * This function directly calls the execute method of GrayscaleMorphologicalOpeningImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GrayscaleMorphologicalOpeningImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image GrayscaleMorphologicalOpening ( const Image& image1, std::vector<unsigned int> kernelRadius = std::vector<uint32_t>(3, 1), KernelEnum kernelType = itk::simple::sitkBall, bool safeBorder = true );

     /** @} */
}
#endif
