{
  lib,
  rustPlatform,
  fetchFromGitHub,
  nix-update-script,
}:
rustPlatform.buildRustPackage (finalAttrs: {
  pname = "tzf-rs";
  version = "1.0.0";

  src = fetchFromGitHub {
    owner = "ringsaturn";
    repo = "tzf-rs";
    tag = "v${finalAttrs.version}";
    hash = "sha256-cYi8FsB1aR0h1HxqkdFlLwCLzRwVM9Ak1LtjHezCSe0=";
  };

  cargoHash = "sha256-9bUQpEP+vc3xwWCicHpl+56OYz3huirSOA4yw1iaxaY=";

  passthru.updateScript = nix-update-script { };

  meta = {
    description = "A fast timezone finder for Rust";
    homepage = "https://github.com/ringsaturn/tzf-rs";
    changelog = "https://github.com/ringsaturn/tzf-rs/releases/tag/v${finalAttrs.version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ pcboy ];
    mainProgram = "tzf";
    platforms = lib.platforms.unix;
  };
})
