{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "go-exploitdb";
  version = "0.5.0";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    tag = "v${version}";
    hash = "sha256-7S6DuPCsT3mP4/W5Lsyg4RS7Km8dmYkrUhvSjlRhahc=";
  };

  vendorHash = "sha256-uqXNRfWWNvpDC3q+eDX3NOQIHz0di4/Vjh7r8OMsTr4=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${version}"
  ];

  meta = with lib; {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/v${version}";
    license = licenses.mit;
    maintainers = with maintainers; [ fab ];
  };
}
