{
  lib,
  buildGoModule,
  fetchFromGitHub,
  go,
  installShellFiles,
  makeWrapper,
}:

buildGoModule rec {
  pname = "go-licenses";
  version = "1.6.0";

  src = fetchFromGitHub {
    owner = "google";
    repo = "go-licenses";
    tag = "v${version}";
    hash = "sha256-GAlwTVoVA+n9+EfhybmpKm16FoY9kFzrxy1ZQxS6A8E=";
  };

  vendorHash = "sha256-ToRn2wj7Yi+UDJwvAhV0ACEhqlcQjt4bRpz7abNRt9A=";

  patches = [
    # Without this, we get error messages like:
    # vendor/golang.org/x/sys/unix/syscall.go:83:16: unsafe.Slice requires go1.17 or later (-lang was set to go1.16; check go.mod)
    # The patch was generated by changing "go 1.16" to "go 1.17" and executing `go mod tidy`.
    ./fix-go-version-error.patch
  ];

  nativeBuildInputs = [
    installShellFiles
    makeWrapper
  ];

  subPackages = [ "." ];

  allowGoReference = true;

  postInstall = ''
    installShellCompletion --cmd go-licenses \
      --bash <("$out/bin/go-licenses" completion bash) \
      --fish <("$out/bin/go-licenses" completion fish) \
      --zsh  <("$out/bin/go-licenses" completion zsh)

    # workaround empty output when GOROOT differs from built environment
    # see https://github.com/google/go-licenses/issues/149
    wrapProgram "$out/bin/go-licenses" \
      --set GOROOT '${go}/share/go'
  '';

  # Tests require internet connection
  doCheck = false;

  meta = with lib; {
    changelog = "https://github.com/google/go-licenses/releases/tag/v${version}";
    description = "Reports on the licenses used by a Go package and its dependencies";
    mainProgram = "go-licenses";
    homepage = "https://github.com/google/go-licenses";
    license = with licenses; [ asl20 ];
    maintainers = with maintainers; [ Luflosi ];
  };
}
