# User Sessions {#sec-user-sessions}

Systemd keeps track of all users who are logged into the system (e.g. on
a virtual console or remotely via SSH). The command `loginctl` allows
querying and manipulating user sessions. For instance, to list all user
sessions:

```ShellSession
$ loginctl
   SESSION        UID USER             SEAT
        c1        500 eelco            seat0
        c3          0 root             seat0
        c4        500 alice
```

This shows that two users are logged in locally, while another is logged
in remotely. ("Seats" are essentially the combinations of displays and
input devices attached to the system; usually, there is only one seat.)
To get information about a session:

```ShellSession
$ loginctl session-status c3
c3 - root (0)
           Since: Tue, 2013-01-08 01:17:56 CET; 4min 42s ago
          Leader: 2536 (login)
            Seat: seat0; vc3
             TTY: /dev/tty3
         Service: login; type tty; class user
           State: online
          CGroup: name=systemd:/user/root/c3
                  ├─ 2536 /nix/store/10mn4xip9n7y9bxqwnsx7xwx2v2g34xn-shadow-4.1.5.1/bin/login --
                  ├─10339 -bash
                  └─10355 w3m nixos.org
```

This shows that the user is logged in on virtual console 3. It also
lists the processes belonging to this session. Since systemd keeps track
of this, you can terminate a session in a way that ensures that all the
session's processes are gone:

```ShellSession
# loginctl terminate-session c3
```
