# Release 19.09 ("Loris", 2019/10/09) {#sec-release-19.09}

## Highlights {#sec-release-19.09-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- End of support is planned for end of April 2020, handing over to 20.03.

- Nix has been updated to 2.3; see its [release notes](https://nixos.org/nix/manual/#ssec-relnotes-2.3).

- Core version changes:

  systemd: 239 -\> 243

  gcc: 7 -\> 8

  glibc: 2.27 (unchanged)

  linux: 4.19 LTS (unchanged)

  openssl: 1.0 -\> 1.1

- Desktop version changes:

  plasma5: 5.14 -\> 5.16

  gnome3: 3.30 -\> 3.32

- PHP now defaults to PHP 7.3, updated from 7.2.

- PHP 7.1 is no longer supported due to upstream not supporting this version for the entire lifecycle of the 19.09 release.

- The binfmt module is now easier to use. Additional systems can be added through `boot.binfmt.emulatedSystems`. For instance, `boot.binfmt.emulatedSystems = [ "wasm32-wasi" "x86_64-windows" "aarch64-linux" ];` will set up binfmt interpreters for each of those listed systems.

- The installer now uses a less privileged `nixos` user whereas before we logged in as root. To gain root privileges use `sudo -i` without a password.

- We've updated to Xfce 4.14, which brings a new module `services.xserver.desktopManager.xfce4-14`. If you'd like to upgrade, please switch from the `services.xserver.desktopManager.xfce` module as it will be deprecated in a future release. They're incompatibilities with the current Xfce module; it doesn't support `thunarPlugins` and it isn't recommended to use `services.xserver.desktopManager.xfce` and `services.xserver.desktopManager.xfce4-14` simultaneously or to downgrade from Xfce 4.14 after upgrading.

- The GNOME 3 desktop manager module sports an interface to enable/disable core services, applications, and optional GNOME packages like games.

  - `services.gnome3.core-os-services.enable`

  - `services.gnome3.core-shell.enable`

  - `services.gnome3.core-utilities.enable`

  - `services.gnome3.games.enable`

  With these options we hope to give users finer grained control over their systems. Prior to this change you'd either have to manually disable options or use `environment.gnome3.excludePackages` which only excluded the optional applications. `environment.gnome3.excludePackages` is now unguarded, it can exclude any package installed with `environment.systemPackages` in the GNOME 3 module.

- Orthogonal to the previous changes to the GNOME 3 desktop manager module, we've updated all default services and applications to match as close as possible to a default reference GNOME 3 experience.

  **The following changes were enacted in `services.gnome3.core-utilities.enable`**

  - `accerciser`

  - `dconf-editor`

  - `evolution`

  - `gnome-documents`

  - `gnome-nettool`

  - `gnome-power-manager`

  - `gnome-todo`

  - `gnome-tweaks`

  - `gnome-usage`

  - `gucharmap`

  - `nautilus-sendto`

  - `vinagre`

  - `cheese`

  - `geary`

  **The following changes were enacted in `services.gnome3.core-shell.enable`**

  - `gnome-color-manager`

  - `orca`

  - `services.avahi.enable`

## New Services {#sec-release-19.09-new-services}

The following new services were added since the last release:

- `./programs/dwm-status.nix`

- The new `hardware.printers` module allows to declaratively configure CUPS printers via the `ensurePrinters` and `ensureDefaultPrinter` options. `ensurePrinters` will never delete existing printers, but will make sure that the given printers are configured as declared.

- There is a new [services.system-config-printer.enable](options.html#opt-services.system-config-printer.enable) and [programs.system-config-printer.enable](options.html#opt-programs.system-config-printer.enable) module for the program of the same name. If you previously had `system-config-printer` enabled through some other means you should migrate to using one of these modules.

  - `services.xserver.desktopManager.plasma5`

  - `services.xserver.desktopManager.gnome3`

  - `services.xserver.desktopManager.pantheon`

  - `services.xserver.desktopManager.mate` Note Mate uses `programs.system-config-printer` as it doesn't use it as a service, but its graphical interface directly.

- [services.blueman.enable](options.html#opt-services.blueman.enable) has been added. If you previously had blueman installed via `environment.systemPackages` please migrate to using the NixOS module, as this would result in an insufficiently configured blueman.

## Backward Incompatibilities {#sec-release-19.09-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- Buildbot no longer supports Python 2, as support was dropped upstream in version 2.0.0. Configurations may need to be modified to make them compatible with Python 3.

- PostgreSQL now uses `/run/postgresql` as its socket directory instead of `/tmp`. So if you run an application like eg. Nextcloud, where you need to use the Unix socket path as the database host name, you need to change it accordingly.

- PostgreSQL 9.4 is scheduled EOL during the 19.09 life cycle and has been removed.

- The options `services.prometheus.alertmanager.user` and `services.prometheus.alertmanager.group` have been removed because the alertmanager service is now using systemd's [ DynamicUser mechanism](http://0pointer.net/blog/dynamic-users-with-systemd.html) which obviates these options.

- The NetworkManager systemd unit was renamed back from network-manager.service to NetworkManager.service for better compatibility with other applications expecting this name. The same applies to ModemManager where modem-manager.service is now called ModemManager.service again.

- The `services.nzbget.configFile` and `services.nzbget.openFirewall` options were removed as they are managed internally by the nzbget. The `services.nzbget.dataDir` option hadn't actually been used by the module for some time and so was removed as cleanup.

- The `services.mysql.pidDir` option was removed, as it was only used by the wordpress apache-httpd service to wait for mysql to have started up. This can be accomplished by either describing a dependency on mysql.service (preferred) or waiting for the (hardcoded) `/run/mysqld/mysql.sock` file to appear.

- The `services.emby.enable` module has been removed, see `services.jellyfin.enable` instead for a free software fork of Emby. See the Jellyfin documentation: [ Migrating from Emby to Jellyfin ](https://jellyfin.readthedocs.io/en/latest/administrator-docs/migrate-from-emby/)

- IPv6 Privacy Extensions are now enabled by default for undeclared interfaces. The previous behaviour was quite misleading --- even though the default value for `networking.interfaces.*.preferTempAddress` was `true`, undeclared interfaces would not prefer temporary addresses. Now, interfaces not mentioned in the config will prefer temporary addresses. EUI64 addresses can still be set as preferred by explicitly setting the option to `false` for the interface in question.

- Since Bittorrent Sync was superseded by Resilio Sync in 2016, the `bittorrentSync`, `bittorrentSync14`, and `bittorrentSync16` packages have been removed in favor of `resilio-sync`.

  The corresponding module, `services.btsync` has been replaced by the `services.resilio` module.

- The httpd service no longer attempts to start the postgresql service. If you have come to depend on this behaviour then you can preserve the behavior with the following configuration: `systemd.services.httpd.after = [ "postgresql.service" ];`

  The option `services.httpd.extraSubservices` has been marked as deprecated. You may still use this feature, but it will be removed in a future release of NixOS. You are encouraged to convert any httpd subservices you may have written to a full NixOS module.

  Most of the httpd subservices packaged with NixOS have been replaced with full NixOS modules including LimeSurvey, WordPress, and Zabbix. These modules can be enabled using the `services.limesurvey.enable`, `services.mediawiki.enable`, `services.wordpress.enable`, and `services.zabbixWeb.enable` options.

- The option `systemd.network.networks.<name>.routes.*.routeConfig.GatewayOnlink` was renamed to `systemd.network.networks.<name>.routes.*.routeConfig.GatewayOnLink` (capital `L`). This follows [ upstreams renaming ](https://github.com/systemd/systemd/commit/9cb8c5593443d24c19e40bfd4fc06d672f8c554c) of the setting.

- As of this release the NixOps feature `autoLuks` is deprecated. It no longer works with our systemd version without manual intervention.

  Whenever the usage of the module is detected the evaluation will fail with a message explaining why and how to deal with the situation.

  A new knob named `nixops.enableDeprecatedAutoLuks` has been introduced to disable the eval failure and to acknowledge the notice was received and read. If you plan on using the feature please note that it might break with subsequent updates.

  Make sure you set the `_netdev` option for each of the file systems referring to block devices provided by the autoLuks module. Not doing this might render the system in a state where it doesn't boot anymore.

  If you are actively using the `autoLuks` module please let us know in [issue \#62211](https://github.com/NixOS/nixpkgs/issues/62211).

- The setopt declarations will be evaluated at the end of `/etc/zshrc`, so any code in [programs.zsh.interactiveShellInit](options.html#opt-programs.zsh.interactiveShellInit), [programs.zsh.loginShellInit](options.html#opt-programs.zsh.loginShellInit) and [programs.zsh.promptInit](options.html#opt-programs.zsh.promptInit) may break if it relies on those options being set.

- The `prometheus-nginx-exporter` package now uses the official exporter provided by NGINX Inc. Its metrics are differently structured and are incompatible to the old ones. For information about the metrics, have a look at the [official repo](https://github.com/nginxinc/nginx-prometheus-exporter).

- The `shibboleth-sp` package has been updated to version 3. It is largely backward compatible, for further information refer to the [release notes](https://wiki.shibboleth.net/confluence/display/SP3/ReleaseNotes) and [upgrade guide](https://wiki.shibboleth.net/confluence/display/SP3/UpgradingFromV2).

  Nodejs 8 is scheduled EOL under the lifetime of 19.09 and has been dropped.

- By default, prometheus exporters are now run with `DynamicUser` enabled. Exporters that need a real user, now run under a separate user and group which follow the pattern `<exporter-name>-exporter`, instead of the previous default `nobody` and `nogroup`. Only some exporters are affected by the latter, namely the exporters `dovecot`, `node`, `postfix` and `varnish`.

- The `ibus-qt` package is not installed by default anymore when [i18n.inputMethod.enabled](options.html#opt-i18n.inputMethod.enabled) is set to `ibus`. If IBus support in Qt 4.x applications is required, add the `ibus-qt` package to your [environment.systemPackages](options.html#opt-environment.systemPackages) manually.

- The CUPS Printing service now uses socket-based activation by default, only starting when needed. The previous behavior can be restored by setting `services.cups.startWhenNeeded` to `false`.

- The `services.systemhealth` module has been removed from nixpkgs due to lack of maintainer.

- The `services.mantisbt` module has been removed from nixpkgs due to lack of maintainer.

- Squid 3 has been removed and the `squid` derivation now refers to Squid 4.

- The `services.pdns-recursor.extraConfig` option has been replaced by `services.pdns-recursor.settings`. The new option allows setting extra configuration while being better type-checked and mergeable.

- No service depends on `keys.target` anymore which is a systemd target that indicates if all [NixOps keys](https://nixos.org/nixops/manual/#idm140737322342384) were successfully uploaded. Instead, `<key-name>-key.service` should be used to define a dependency of a key in a service. The full issue behind the `keys.target` dependency is described at [NixOS/nixpkgs\#67265](https://github.com/NixOS/nixpkgs/issues/67265).

  The following services are affected by this:

  - [`services.dovecot2`](options.html#opt-services.dovecot2.enable)

  - [`services.nsd`](options.html#opt-services.nsd.enable)

  - [`services.softether`](options.html#opt-services.softether.enable)

  - [`services.strongswan`](options.html#opt-services.strongswan.enable)

  - [`services.strongswan-swanctl`](options.html#opt-services.strongswan-swanctl.enable)

  - [`services.httpd`](options.html#opt-services.httpd.enable)

- The `security.acme.directory` option has been replaced by a read-only `security.acme.certs.<cert>.directory` option for each certificate you define. This will be a subdirectory of `/var/lib/acme`. You can use this read-only option to figure out where the certificates are stored for a specific certificate. For example, the `services.nginx.virtualhosts.<name>.enableACME` option will use this directory option to find the certs for the virtual host.

  `security.acme.preDelay` and `security.acme.activationDelay` options have been removed. To execute a service before certificates are provisioned or renewed add a `RequiredBy=acme-${cert}.service` to any service.

  Furthermore, the acme module will not automatically add a dependency on `lighttpd.service` anymore. If you are using certificates provided by letsencrypt for lighttpd, then you should depend on the certificate service `acme-${cert}.service>` manually.

  For nginx, the dependencies are still automatically managed when `services.nginx.virtualhosts.<name>.enableACME` is enabled just like before. What changed is that nginx now directly depends on the specific certificates that it needs, instead of depending on the catch-all `acme-certificates.target`. This target unit was also removed from the codebase. This will mean nginx will no longer depend on certificates it isn't explicitly managing and fixes a bug with certificate renewal ordering racing with nginx restarting which could lead to nginx getting in a broken state as described at [NixOS/nixpkgs\#60180](https://github.com/NixOS/nixpkgs/issues/60180).

- The old deprecated `emacs` package sets have been dropped. What used to be called `emacsPackagesNg` is now called `emacsPackages`.

- `services.xserver.desktopManager.xterm` is now disabled by default if `stateVersion` is 19.09 or higher. Previously the xterm desktopManager was enabled when xserver was enabled, but it isn't useful for all people so it didn't make sense to have any desktopManager enabled default.

- The WeeChat plugin `pkgs.weechatScripts.weechat-xmpp` has been removed as it doesn't receive any updates from upstream and depends on outdated Python2-based modules.

- Old unsupported versions (`logstash5`, `kibana5`, `filebeat5`, `heartbeat5`, `metricbeat5`, `packetbeat5`) of the ELK-stack and Elastic beats have been removed.

- For NixOS 19.03, both Prometheus 1 and 2 were available to allow for a seamless transition from version 1 to 2 with existing setups. Because Prometheus 1 is no longer developed, it was removed. Prometheus 2 is now configured with `services.prometheus`.

- Citrix Receiver (`citrix_receiver`) has been dropped in favor of Citrix Workspace (`citrix_workspace`).

- The `services.gitlab` module has had its literal secret options (`services.gitlab.smtp.password`, `services.gitlab.databasePassword`, `services.gitlab.initialRootPassword`, `services.gitlab.secrets.secret`, `services.gitlab.secrets.db`, `services.gitlab.secrets.otp` and `services.gitlab.secrets.jws`) replaced by file-based versions (`services.gitlab.smtp.passwordFile`, `services.gitlab.databasePasswordFile`, `services.gitlab.initialRootPasswordFile`, `services.gitlab.secrets.secretFile`, `services.gitlab.secrets.dbFile`, `services.gitlab.secrets.otpFile` and `services.gitlab.secrets.jwsFile`). This was done so that secrets aren't stored in the world-readable nix store, but means that for each option you'll have to create a file with the same exact string, add "File" to the end of the option name, and change the definition to a string pointing to the corresponding file; e.g. `services.gitlab.databasePassword = "supersecurepassword"` becomes `services.gitlab.databasePasswordFile = "/path/to/secret_file"` where the file `secret_file` contains the string `supersecurepassword`.

  The state path (`services.gitlab.statePath`) now has the following restriction: no parent directory can be owned by any other user than `root` or the user specified in `services.gitlab.user`; i.e. if `services.gitlab.statePath` is set to `/var/lib/gitlab/state`, `gitlab` and all parent directories must be owned by either `root` or the user specified in `services.gitlab.user`.

- The `networking.useDHCP` option is unsupported in combination with `networking.useNetworkd` in anticipation of defaulting to it. It has to be set to `false` and enabled per interface with `networking.interfaces.<name>.useDHCP = true;`

- The Twitter client `corebird` has been dropped as [it is discontinued and does not work against the new Twitter API](https://www.patreon.com/posts/corebirds-future-18921328). Please use the fork `cawbird` instead which has been adapted to the API changes and is still maintained.

- The `nodejs-11_x` package has been removed as it's EOLed by upstream.

- Because of the systemd upgrade, systemd-timesyncd will no longer work if `system.stateVersion` is not set correctly. When upgrading from NixOS 19.03, please make sure that `system.stateVersion` is set to `"19.03"`, or lower if the installation dates back to an earlier version of NixOS.

- Due to the short lifetime of non-LTS kernel releases package attributes like `linux_5_1`, `linux_5_2` and `linux_5_3` have been removed to discourage dependence on specific non-LTS kernel versions in stable NixOS releases. Going forward, versioned attributes like `linux_4_9` will exist for LTS versions only. Please use `linux_latest` or `linux_testing` if you depend on non-LTS releases. Keep in mind that `linux_latest` and `linux_testing` will change versions under the hood during the lifetime of a stable release and might include breaking changes.

- Because of the systemd upgrade, some network interfaces might change their name. For details see [ upstream docs](https://www.freedesktop.org/software/systemd/man/systemd.net-naming-scheme.html#History) or [ our ticket](https://github.com/NixOS/nixpkgs/issues/71086).

## Other Notable Changes {#sec-release-19.09-notable-changes}

- The `documentation` module gained an option named `documentation.nixos.includeAllModules` which makes the generated configuration.nix 5 manual page include all options from all NixOS modules included in a given `configuration.nix` configuration file. Currently, it is set to `false` by default as enabling it frequently prevents evaluation. But the plan is to eventually have it set to `true` by default. Please set it to `true` now in your `configuration.nix` and fix all the bugs it uncovers.

- The `vlc` package gained support for Chromecast streaming, enabled by default. TCP port 8010 must be open for it to work, so something like `networking.firewall.allowedTCPPorts = [ 8010 ];` may be required in your configuration. Also consider enabling [ Accelerated Video Playback](https://wiki.nixos.org/wiki/Accelerated_Video_Playback) for better transcoding performance.

- The following changes apply if the `stateVersion` is changed to 19.09 or higher. For `stateVersion = "19.03"` or lower the old behavior is preserved.

  - `solr.package` defaults to `pkgs.solr_8`.

- The `hunspellDicts.fr-any` dictionary now ships with `fr_FR.{aff,dic}` which is linked to `fr-toutesvariantes.{aff,dic}`.

- The `mysql` service now runs as `mysql` user. Previously, systemd did execute it as root, and mysql dropped privileges itself. This includes `ExecStartPre=` and `ExecStartPost=` phases. To accomplish that, runtime and data directory setup was delegated to RuntimeDirectory and tmpfiles.

- With the upgrade to systemd version 242 the `systemd-timesyncd` service is no longer using `DynamicUser=yes`. In order for the upgrade to work we rely on an activation script to move the state from the old to the new directory. The older directory (prior `19.09`) was `/var/lib/private/systemd/timesync`.

  As long as the `system.config.stateVersion` is below `19.09` the state folder will migrated to its proper location (`/var/lib/systemd/timesync`), if required.

- The package `avahi` is now built to look up service definitions from `/etc/avahi/services` instead of its output directory in the nix store. Accordingly the module `avahi` now supports custom service definitions via `services.avahi.extraServiceFiles`, which are then placed in the aforementioned directory. See avahi.service5 for more information on custom service definitions.

- Since version 0.1.19, `cargo-vendor` honors package includes that are specified in the `Cargo.toml` file of Rust crates. `rustPlatform.buildRustPackage` uses `cargo-vendor` to collect and build dependent crates. Since this change in `cargo-vendor` changes the set of vendored files for most Rust packages, the hash that use used to verify the dependencies, `cargoSha256`, also changes.

  The `cargoSha256` hashes of all in-tree derivations that use `buildRustPackage` have been updated to reflect this change. However, third-party derivations that use `buildRustPackage` may have to be updated as well.

- The `consul` package was upgraded past version `1.5`, so its deprecated legacy UI is no longer available.

- The default resample-method for PulseAudio has been changed from the upstream default `speex-float-1` to `speex-float-5`. Be aware that low-powered ARM-based and MIPS-based boards will struggle with this so you'll need to set `hardware.pulseaudio.daemon.config.resample-method` back to `speex-float-1`.

- The `phabricator` package and associated `httpd.extraSubservice`, as well as the `phd` service have been removed from nixpkgs due to lack of maintainer.

- The `mercurial` `httpd.extraSubservice` has been removed from nixpkgs due to lack of maintainer.

- The `trac` `httpd.extraSubservice` has been removed from nixpkgs because it was unmaintained.

- The `foswiki` package and associated `httpd.extraSubservice` have been removed from nixpkgs due to lack of maintainer.

- The `tomcat-connector` `httpd.extraSubservice` has been removed from nixpkgs.

- It's now possible to change configuration in [services.nextcloud](options.html#opt-services.nextcloud.enable) after the initial deploy since all config parameters are persisted in an additional config file generated by the module. Previously core configuration like database parameters were set using their imperative installer after creating `/var/lib/nextcloud`.

- There exists now `lib.forEach`, which is like `map`, but with arguments flipped. When mapping function body spans many lines (or has nested `map`s), it is often hard to follow which list is modified.

  Previous solution to this problem was either to use `lib.flip map` idiom or extract that anonymous mapping function to a named one. Both can still be used but `lib.forEach` is preferred over `lib.flip map`.

  The `/etc/sysctl.d/nixos.conf` file containing all the options set via [boot.kernel.sysctl](options.html#opt-boot.kernel.sysctl) was moved to `/etc/sysctl.d/60-nixos.conf`, as sysctl.d5 recommends prefixing all filenames in `/etc/sysctl.d` with a two-digit number and a dash to simplify the ordering of the files.

- We now install the sysctl snippets shipped with systemd.

  - Loose reverse path filtering

  - Source route filtering

  - `fq_codel` as a packet scheduler (this helps to fight bufferbloat)

  This also configures the kernel to pass core dumps to `systemd-coredump`, and restricts the SysRq key combinations to the sync command only. These sysctl snippets can be found in `/etc/sysctl.d/50-*.conf`, and overridden via [boot.kernel.sysctl](options.html#opt-boot.kernel.sysctl) (which will place the parameters in `/etc/sysctl.d/60-nixos.conf`).

- Core dumps are now processed by `systemd-coredump` by default. `systemd-coredump` behaviour can still be modified via `systemd.coredump.extraConfig`. To stick to the old behaviour (having the kernel dump to a file called `core` in the working directory), without piping it through `systemd-coredump`, set `systemd.coredump.enable` to `false`.

- `systemd.packages` option now also supports generators and shutdown scripts. Old `systemd.generator-packages` option has been removed.

- The `rmilter` package was removed with associated module and options due deprecation by upstream developer. Use `rspamd` in proxy mode instead.

- systemd cgroup accounting via the [systemd.enableCgroupAccounting](options.html#opt-systemd.enableCgroupAccounting) option is now enabled by default. It now also enables the more recent Block IO and IP accounting features.

- We no longer enable custom font rendering settings with `fonts.fontconfig.penultimate.enable` by default. The defaults from fontconfig are sufficient.

- The `crashplan` package and the `crashplan` service have been removed from nixpkgs due to crashplan shutting down the service, while the `crashplansb` package and `crashplan-small-business` service have been removed from nixpkgs due to lack of maintainer.

  The [redis module](options.html#opt-services.redis.enable) was hardcoded to use the `redis` user, `/run/redis` as runtime directory and `/var/lib/redis` as state directory. Note that the NixOS module for Redis now disables kernel support for Transparent Huge Pages (THP), because this features causes major performance problems for Redis, e.g. (https://redis.io/topics/latency).

- Using `fonts.enableDefaultFonts` adds a default emoji font `noto-fonts-emoji`.

  - `services.xserver.enable`

  - `programs.sway.enable`

  - `programs.way-cooler.enable`

  - `services.xrdp.enable`

- The `altcoins` categorization of packages has been removed. You now access these packages at the top level, ie. `nix-shell -p dogecoin` instead of `nix-shell -p altcoins.dogecoin`, etc.

- Ceph has been upgraded to v14.2.1. See the [release notes](https://ceph.com/releases/v14-2-0-nautilus-released/) for details. The mgr dashboard as well as osds backed by loop-devices is no longer explicitly supported by the package and module. Note: There's been some issues with python-cherrypy, which is used by the dashboard and prometheus mgr modules (and possibly others), hence 0000-dont-check-cherrypy-version.patch.

- `pkgs.weechat` is now compiled against `pkgs.python3`. Weechat also recommends [to use Python3 in their docs.](https://weechat.org/scripts/python3/)
