# To build, use:
# nix-build nixos -I nixos-config=nixos/modules/installer/sd-card/sd-image-riscv64-qemu.nix -A config.system.build.sdImage
{
  config,
  lib,
  pkgs,
  ...
}:

{
  imports = [
    ../../profiles/base.nix
    ./sd-image.nix
  ];

  boot.loader = {
    grub.enable = false;
    generic-extlinux-compatible = {
      enable = true;

      # Don't even specify FDTDIR - We do not have the correct DT
      # The DTB is generated by QEMU at runtime
      useGenerationDeviceTree = false;
    };
  };

  boot.consoleLogLevel = lib.mkDefault 7;
  boot.kernelParams = [
    "console=tty0"
    "console=ttyS0,115200n8"
  ];

  sdImage = {
    populateFirmwareCommands = "";
    populateRootCommands = ''
      mkdir -p ./files/boot
      ${config.boot.loader.generic-extlinux-compatible.populateCmd} -c ${config.system.build.toplevel} -d ./files/boot
    '';
  };
}
