# QGIS test script.
# This script will create vector memory layer containing Nix snowflake.

# Set QGIS_TEST_INTERACTIVE=True to run this script in interactive mode (and see
# Nix snowflake).

# Run script as following:
# QGIS_TEST_INTERACTIVE=True ./result/bin/qgis --code pkgs/applications/gis/qgis/test.py

import os

test_interactive = eval(os.getenv("QGIS_TEST_INTERACTIVE", "False"))

def test(test_interactive=False):

    import osgeo  # just to check if geo python modules are available
    from qgis.core import QgsVectorLayer, QgsFeature, QgsGeometry, QgsProject

    # Nix snowflake as WKT
    WKT = """
     MULTIPOLYGON (
         ((37.10819200000000251 45.01934500000000128, 41.42360200000000248 45.0228350000000006, 43.98593199999999825 46.39836900000000242, 51.11554000000000286 46.39135900000000134, 52.20562400000000025 46.98079299999999847, 51.13812500000000227 47.55708200000000119, 46.12925599999999804 47.56117799999999818, 48.65136199999999889 48.91279899999999969, 46.46644299999999816 50.06610299999999825, 37.10819200000000251 45.01934500000000128)),
         ((36.37806400000000195 49.06532800000000094, 34.21064499999999953 50.22733199999999698, 29.10392099999999971 50.23055699999999746, 25.55861099999999908 52.15672200000000203, 23.37426999999999921 52.15597100000000097, 22.30527299999999968 51.57995100000000122, 24.79831000000000074 50.22714599999999763, 19.77820099999999925 50.23147999999999769, 17.66315000000000168 49.06561399999999651, 36.37806400000000195 49.06532800000000094)),
         ((25.51021400000000128 46.84120599999999968, 23.36222199999999916 45.67570500000000067, 25.90661599999999964 44.29694800000000043, 22.32231799999999922 42.37779100000000199, 23.41657500000000169 41.78910799999999881, 25.55307200000000023 41.78884599999999949, 28.06890399999999985 43.13755299999999693, 30.56690599999999947 41.78159999999999741, 34.86687599999999776 41.79416100000000256, 25.51021400000000128 46.84120599999999968)),
         ((29.60533099999999962 44.88583400000000267, 31.77274900000000102 43.72382000000000346, 36.87947299999999728 43.7205939999999984, 40.42478299999999791 41.79442999999999842, 42.60912400000000133 41.7951929999999976, 43.67812200000000189 42.37121299999999735, 41.18508400000000336 43.72401599999999888, 46.20519399999999877 43.71968400000000088, 48.32024400000000242 44.885548, 29.60533099999999962 44.88583400000000267)),
         ((28.88739899999999849 48.92013800000000145, 24.57198899999999853 48.9166450000000026, 22.0096589999999992 47.54111400000000032, 14.88005199999999917 47.54812199999999933, 13.78996700000000075 46.95868999999999716, 14.85746600000000051 46.38240100000000155, 19.86633600000000044 46.37830199999999792, 17.34422899999999856 45.02668100000000351, 19.52914900000000031 43.87337800000000243, 28.88739899999999849 48.92013800000000145)),
         ((25.52133699999999905 46.84445300000000145, 23.37334500000000048 45.67894900000000291, 25.91773900000000097 44.30019200000000268, 22.33344200000000157 42.38103699999999918, 23.4276990000000005 41.79235400000000311, 25.56419500000000156 41.79209199999999669, 28.08002700000000118 43.14079900000000123, 30.57802999999999827 41.78484600000000171, 34.87800000000000011 41.79740699999999975, 25.52133699999999905 46.84445300000000145)),
         ((25.52133699999999905 46.84445300000000145, 23.37334500000000048 45.67895099999999786, 25.91773900000000097 44.30019200000000268, 22.33344200000000157 42.38103699999999918, 23.4276990000000005 41.79235400000000311, 25.56419500000000156 41.79209199999999669, 28.08002700000000118 43.14079900000000123, 30.57802999999999827 41.78484600000000171, 34.87800000000000011 41.79740699999999975, 25.52133699999999905 46.84445300000000145)),
         ((25.51021400000000128 46.84120599999999968, 23.36222199999999916 45.67570500000000067, 25.90661599999999964 44.29694800000000043, 22.32231799999999922 42.37779100000000199, 23.41657500000000169 41.78910799999999881, 25.55307200000000023 41.78884599999999949, 28.06890399999999985 43.13755299999999693, 30.56690599999999947 41.78159999999999741, 34.86687599999999776 41.79416100000000256, 25.51021400000000128 46.84120599999999968)),
         ((40.49807200000000051 47.09720099999999832, 42.64606299999999806 48.26270199999999733, 40.10166999999999859 49.64145899999999756, 43.685966999999998 51.56061600000000311, 42.59170999999999907 52.14929899999999918, 40.45521399999999801 52.1495609999999985, 37.93938099999999736 50.80085400000000107, 35.44137899999999775 52.15680700000000058, 31.14140899999999945 52.14424700000000001, 40.49807200000000051 47.09720099999999832)),
     )
    """

    layer = QgsVectorLayer('Polygon?crs=epsg:3857', 'QGIS-on-Nix', 'memory')
    provider = layer.dataProvider()

    polygon = QgsFeature()
    geom = QgsGeometry.fromWkt(WKT)
    polygon.setGeometry(geom)
    provider.addFeatures([polygon])

    layer.updateExtents()
    QgsProject.instance().addMapLayers([layer])

    # Make sure our test layer contains exactly one feature
    assert layer.featureCount() == 1

    if not test_interactive:
        QgsProject.instance().removeMapLayer(layer)
        QgsProject.instance().clear()

try:
    test(test_interactive=test_interactive)

    if not test_interactive:
        print("QGIS test script was successfully executed.")
        os._exit(0)  # iface.actionExit().trigger() doesn't work

except Exception as e:
    if not test_interactive:
        print("QGIS test script has failed.")
        print("Error message: {}".format(e))
        os._exit(1)

