lib: self: super:

with self;

let
  # Removing recurseForDerivation prevents derivations of aliased attribute
  # set to appear while listing all the packages available.
  removeRecurseForDerivations =
    alias:
    if alias.recurseForDerivations or false then
      lib.removeAttrs alias [ "recurseForDerivations" ]
    else
      alias;

  # Disabling distribution prevents top-level aliases for non-recursed package
  # sets from building on Hydra.
  removeDistribute = alias: if lib.isDerivation alias then lib.dontDistribute alias else alias;

  # Make sure that we are not shadowing something from
  # python-packages.nix.
  checkInPkgs =
    n: alias:
    if builtins.hasAttr n super then throw "Alias ${n} is still in python-packages.nix" else alias;

  mapAliases =
    aliases:
    lib.mapAttrs (
      n: alias: removeDistribute (removeRecurseForDerivations (checkInPkgs n alias))
    ) aliases;
in

### Deprecated aliases - for backward compatibility

mapAliases {
  # Prevent incorrect Python packaging attempts.
  # Note: `{ python3, python3Packages, ... }: with python3Packages; [ ... python3 ]` still works, since `with` has lower priority.
  pythonPackages = throw "do not use pythonPackages when building Python packages, specify each used package as a separate argument"; # do not remove
  python2Packages = throw "do not use python2Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python27Packages = throw "do not use python27Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python3Packages = throw "do not use python3Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python310Packages = throw "do not use python310Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python311Packages = throw "do not use python311Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python312Packages = throw "do not use python312Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python313Packages = throw "do not use python313Packages when building Python packages, specify each used package as a separate argument"; # do not remove
  python2 = throw "do not use python2 when building Python packages, use the generic python parameter instead"; # do not remove
  python3 = throw "do not use python3 when building Python packages, use the generic python parameter instead"; # do not remove
  python310 = throw "do not use python310 when building Python packages, use the generic python parameter instead"; # do not remove
  python311 = throw "do not use python311 when building Python packages, use the generic python parameter instead"; # do not remove
  python312 = throw "do not use python312 when building Python packages, use the generic python parameter instead"; # do not remove
  python313 = throw "do not use python313 when building Python packages, use the generic python parameter instead"; # do not remove
  pypy = throw "do not use pypy when building Python packages, use the generic python parameter instead"; # do not remove
  pypy2 = throw "do not use pypy2 when building Python packages, use the generic python parameter instead"; # do not remove
  pypy27 = throw "do not use pypy27 when building Python packages, use the generic python parameter instead"; # do not remove
  pypy3 = throw "do not use pypy3 when building Python packages, use the generic python parameter instead"; # do not remove
  pypy310 = throw "do not use pypy310 when building Python packages, use the generic python parameter instead"; # do not remove
  pypy311 = throw "do not use pypy311 when building Python packages, use the generic python parameter instead"; # do not remove

  aadict = throw "aadict was removed, it was introduced as a dependency for a package that never manifested and has been an unused leaf package ever since"; # added 2024-07-08
  abodepy = jaraco-abode; # added 2023-02-01
  acebinf = throw "acebinf has been removed because it is abandoned and broken."; # Added 2023-05-19
  acoustics = throw "acoustics has been removed because the upstream repository was archived in 2024"; # Added 2024-10-04
  adafruit-nrfutil = throw "adafruit-nrfutil has been promoted to a top-level attribute name: `pkgs.adafruit-nrfutil`."; # Added 2023-11-19
  aeppl = throw "aeppl was removed as it depends on aesara, which is unmaintained"; # added 2025-01-12
  aesara = throw "aesara was removed as the upstream repository is unmaintained"; # added 2025-01-12
  aioaladdinconnect = throw "aioaladdinconnect has been removed, as the API is supported was obsoleted on 2024-01-24."; # Added 2024-06-07
  aiohttp-isal = throw "aiohttp-isal has been removed, as it has been archived and replace by aiohttp-fast-zlib"; # Added 2024-08-11
  aiohttp-zlib-ng = throw "aiohttp-zlib-ng has been removed, as it has been archived and replaced by aiohttp-fast-zlib"; # Added 2024-11-14
  aiomysensors = throw "aiomysensors has been removed, as it was packaged for Home Assistant, which migrated to pymysensors."; # Added 2024-07-07
  aioh2 = throw "aioh2 has been removed because it is abandoned and broken."; # Added 2022-03-30
  aiolip = throw "aiolip has been removed because the upstream repository was archived in 2021"; # Added 2024-10-04
  aiolivisi = throw "aiolivisi was removed because Home Assistant switched to livisi"; # added 2025-01-09
  aionotify = throw "aionotify has been removed because is unmaintained and incompatible with python3.11."; # Added 2023-10-27
  aiosenseme = throw "aiosenseme has been removed, because it does no longer work with the latest firmware and has become unmaintained"; # Added 2023-07-05
  aioquic-mitmproxy = throw "aioquic-mitmproxy has been removed because mitmproxy no longer uses it"; # Added 2024-01-16
  amazon_kclpy = amazon-kclpy; # added 2023-08-08
  ambiclimate = throw "ambiclimate has been removed, because the service has been terminated after 2024-03-31."; # Added 2024-06-07
  ambee = throw "ambee has been removed because the upstream repository was archived in 2022"; # Added 2024-10-04
  amiibo-py = throw "amiibo-py has been removed because the upstream repository was removed"; # Added 2025-01-13
  ansible-base = throw "ansible-base has been removed, because it is end of life"; # added 2022-03-30
  ansible-doctor = throw "ansible-doctor has been promoted to a top-level attribute name: `pkgs.ansible-doctor`"; # Added 2023-05-16
  ansible-later = throw "ansible-later has been promoted to a top-level attribute name: `pkgs.ansible-later`"; # Added 2023-05-16
  ansible-lint = throw "ansible-lint has been promoted to a top-level attribute name: `pkgs.ansible-lint`"; # Added 2023-05-16
  ansible-navigator = throw "ansible-navigator has been promoted to a top-level attribute name: pkgs.ansible-navigator"; # Added 2024-08-07
  anyjson = throw "anyjson has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2022-01-18
  apache-airflow = throw "apache-airflow has been moved out of pythonPackages and is available as a standalone package"; # added 2023-06-05
  argon2_cffi = argon2-cffi; # added 2022-05-09
  arnparse = throw "arnparse has been removed because the upstream repository was archived in 2023"; # Added 2024-10-04
  APScheduler = apscheduler; # added 2023-02-19
  async_generator = async-generator; # added 2023-08-08
  async_stagger = async-stagger; # added 2023-08-08
  asyncio-mqtt = throw "asyncio-mqtt has been replaced by aiomqtt, which is not API compatible."; # added 2024-07-07
  asyncio-nats-client = nats-py; # added 2022-02-08
  atsim_potentials = atsim-potentials; # added 2023-10-08
  inherit (super.pkgs) autotrash; # added 2024-09-23
  awkward0 = throw "awkward0 has been removed, use awkward instead"; # added 2022-12-13
  azure-functions-devops-build = throw "azure-functions-devops-build has been removed, because it is abandoned"; # added 2024-10-04
  Babel = babel; # added 2022-05-06
  backports-cached-property = throw "backports-cached-property has been removed, since we no longer need to backport to python3.7"; # added 2024-11-12
  backports-shutil-get-terminal-size = throw "backports-shutil-get-terminal-size has been removed, since we no longer need to backport to python3.2"; # added 2024-11-12
  backports-shutil-which = throw "backports-shutil-which has been removed, since we no longer need to backport to python3.2"; # added 2024-11-12
  backports-zoneinfo = throw "backports-zoneinfo has been removed, since we no longer need to backport to python3.8"; # added 2024-11-12
  backports_csv = throw "backports_csv has been removed, since we no longer need to backport to python2"; # added 2023-07-28
  backports_functools_lru_cache = throw "backports_functools_lru_cache has been removed, since we no longer need to backport to python3.2"; # added 2023-07-28
  backports_shutil_get_terminal_size = backports-shutil-get-terminal-size; # added 2024-04-21
  backports_tempfile = throw "backports_tempfile has been removed, since we no longer need to backport to python3.3"; # added 2023-07-28
  backports_unittest-mock = throw "backports_unittest-mock has been removed, since we no longer need to backport to python3.2"; # added 2023-07-28
  backports_weakref = throw "backports_weakref has been removed, since we no longer need to backport to python3.3"; # added 2023-07-28
  bash_kernel = bash-kernel; # added 2023-11-10
  beancount_docverif = beancount-docverif; # added 2023-10-08
  bedup = throw "bedup was removed because it was broken and abandoned upstream"; # added 2023-02-04
  bip_utils = bip-utils; # 2023-10-08
  bitcoin-price-api = throw "bitcoin-price-api has been removed, it was using setuptools 2to3 translation feautre, which has been removed in setuptools 58"; # added 2022-02-15
  blessings = throw "blessings has been removed in favor of blessed, as it was unmaintained"; # added 2024-08-20
  BlinkStick = blinkstick; # added 2023-02-19
  blockdiagcontrib-cisco = throw "blockdiagcontrib-cisco is not compatible with blockdiag 2.0.0 and has been removed."; # added 2020-11-29
  boto = throw "boto was removed as it is deprecated upstream, had not been updated since 2018, and failed to build; please use boto3 and botocore"; # Added 2024-09-22
  boxx = throw "boxx was removed as it is no longer used by any packages in nixpkgs."; # added 2025-02-08
  bpycv = throw "bpycv was removed as it is incompatible with blender version 4 or later."; # added 2025-02-08
  bsblan = python-bsblan; # added 2022-11-04
  btchip = btchip-python; # added 2023-03-03
  bugz = throw "use pkgs.pybugz instead"; # added 2024-12-31
  bugzilla = python-bugzilla; # added 2024-10-17
  buildbot = throw "use pkgs.buildbot instead"; # added 2022-04-07
  buildbot-ui = throw "use pkgs.buildbot-ui instead"; # added 2022-04-07
  buildbot-full = throw "use pkgs.buildbot-full instead"; # added 2022-04-07
  buildbot-plugins = throw "use pkgs.buildbot-plugins instead"; # added 2022-04-07
  buildbot-worker = throw "use pkgs.buildbot-worker instead"; # added 2022-04-07
  buildbot-pkg = throw "buildbot-pkg has been removed, it's only internally used in buildbot"; # added 2022-04-07
  btsmarthub_devicelist = btsmarthub-devicelist; # added 2024-01-03
  bt_proximity = bt-proximity; # added 2021-07-02
  BTrees = btrees; # added 2023-02-19
  cacheyou = throw "cacheyou has been removed, as it was no longer used for the only consumer pdm"; # added 2023-12-21
  cadquery = throw "cadquery was removed, because it was disabled on all python version since 3.8 and marked as broken"; # added 2024-05-13
  caffeWithCuda = throw "caffeWithCuda has been removed, as it was broken and required CUDA 10"; # Added 2024-11-20
  can = python-can; # added 2024-08-12
  carrot = throw "carrot has been removed, as its development was discontinued in 2012"; # added 2022-01-18
  case = throw "case has been removed, since it is an unused leaf package with a dependency on the nose test framework"; # added 2024-07-08
  cchardet = faust-cchardet; # added 2023-03-02
  cepa = throw "cepa has been removed, as onionshare switched back to stem"; # added 2024-05-07
  chainer = throw "chainer has been removed, as it is abandoned and broken"; # added 2024-12-31
  chiabip158 = throw "chiabip158 has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  chiapos = throw "chiapos has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  chiavdf = throw "chiavdf has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  chia-rs = throw "chia-rs has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  class-registry = phx-class-registry; # added 2021-10-05
  cirq-ft = throw "cirq-ft is not longer provieded by cirq upstream"; # added 2024-08-31
  ciscoconfparse = throw "ciscoconfparse was archived by upstream, use ciscoconfparse2"; # added 2025-03-08
  cld2-cffi = throw "cld2-cffi has been removed, as the last release was in 2016"; # added 2024-05-20
  clvm = throw "clvm has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  clvm-rs = throw "clvm-rs has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  clvm-tools = throw "clvm-tools has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  clvm-tools-rs = throw "clvm-tools-rs has been removed. see https://github.com/NixOS/nixpkgs/pull/270254"; # added 2023-11-26
  cntk = throw "cntk has been removed from nixpkgs, as it was broken and unmaintained"; # Added 2023-10-09
  codecov = throw "python-codecov has been removed, as it was broken and archived by upstream."; # Added 2024-10-24
  codespell = throw "codespell has been promoted to a top-level attribute name: `pkgs.codespell`"; # Added 2022-10-02
  ColanderAlchemy = colanderalchemy; # added 2023-02-19
  command_runner = command-runner; # added 2024-03-06
  CommonMark = commonmark; # added 2023-02-1
  ConfigArgParse = configargparse; # added 2021-03-18
  configshell = configshell-fb; # added 2025-03-14
  coronavirus = throw "coronavirus was removed, because the source is not providing the data anymore."; # added 2023-05-04
  covCore = throw "covCore was renamed to cov-core and subsequently removed since it has ben unmaintained since 2014"; # added 2024-05-20
  cov-core = throw "cov-core has been removed, it was archived and unmaintained since 2014"; # added 2024-05-21
  cozy = throw "cozy was removed because it was not actually https://pypi.org/project/Cozy/."; # added 2022-01-14
  criticality-score = throw "use pkgs.criticality-score instead"; # added 2024-12-31
  cryptacular = throw "cryptacular was removed, because it was disabled on all python version since 3.6 and last updated in 2021"; # Added 2024-05-13
  cryptography_vectors = "cryptography_vectors is no longer exposed in python*Packages because it is used for testing cryptography only."; # Added 2022-03-23
  cufflinks = throw "cufflinks has removed, since it is abandoned and broken"; # added 2025-02-16
  curve25519-donna = throw "curve25519-donna was removed, since it is abandoned and unmaintained since 2015"; # added 2025-06-03
  cx_Freeze = cx-freeze; # added 2023-08-02
  cx_oracle = cx-oracle; # added 2024-01-03
  d2to1 = throw "d2to1 is archived and no longer works with setuptools v68"; # added 2023-07-30
  dask-expr = throw "dask-expr was removed because its features are available in dask"; # added 2025-02-07
  dask-xgboost = throw "dask-xgboost was removed because its features are available in xgboost"; # added 2022-05-24
  dash-renderer = throw "dash-renderer has been removed since it is abandoned"; # added 2025-01-01
  dateutil = python-dateutil; # added 2021-07-03
  debian = python-debian; # added 2024-12-10
  deep_merge = throw "deep_merge has been removed, since it is no longer maintained and may be broken."; # added 2023-10-09
  demjson = throw "demjson has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2022-01-18
  deprecat = throw "deprecat has been removed, it unmaintained and archived by upstream"; # added 2025-03-08
  descartes = throw "descartes has been removed, since it is abandoned and broken"; # added 2023-06-21
  detox = throw "detox is no longer maintained, and was broken since may 2019"; # added 2020-07-04
  dftfit = throw "dftfit dependency lammps-cython no longer builds"; # added 2021-07-04
  dictpath = pathable; # added 2023-01-28
  diff_cover = diff-cover; # added 2021-07-02
  discogs_client = discogs-client; # added 2021-07-02
  distutils_extra = distutils-extra; # added 2023-10-12
  digital-ocean = python-digitalocean; # addad 2024-04-12
  djangorestframework-jwt = drf-jwt; # added 2021-07-20
  django-allauth-2fa = throw "django-allauth-2fa was removed because it was unused and django-allauth now contains 2fa logic itself."; # added 2025-02-15
  django-sampledatahelper = throw "django-sampledatahelper was removed because it is no longer compatible to latest Django version"; # added 2022-07-18
  django_2 = throw "Django 2 has reached it's projected EOL in 2022/04 and has therefore been removed."; # added 2022-03-05
  django_appconf = django-appconf; # added 2022-03-03
  django_classytags = django-classy-tags; # added 2023-07-25
  django_colorful = django-colorful; # added 2023-07-25
  django_compat = django-compat; # added 2023-07-25
  django-compat = throw "django-compat has been removed. It provided forward/backport compat for django 1.x, which is long end of life."; # added 2023-07-26
  django_contrib_comments = django-contrib-comments; # added 2023-07-25
  django-crontab = throw "django-crontabe has been removed beacause it is unmaintained since 2018"; # added 2024-08-21
  django-discover-runner = throw "django-discover-runner was removed because it is no longer maintained."; # added 2022-11-21
  django_environ = django-environ; # added 2021-12-25
  django_extensions = django-extensions; # added 2022-01-09
  django_guardian = django-guardian; # added 2022-05-19
  django_hijack = django-hijack; # added 2023-05-16
  django_hijack_admin = django-hijack-admin; # added 2023-05-16
  django-hijack-admin = throw "django-hijack-admin has been removed, since it is no longer compatible to django-hijack"; # added 2023-06-21
  django_modelcluster = django-modelcluster; # added 2022-04-02
  django-mysql = throw "django-mysql has been removed, since it was an unused leaf package"; # added 2024-07-02
  django_nose = django-nose; # added 2023-07-25
  django-nose = throw "django-nose has been removed since it has not been maintained and there are no dependent packages"; # added 2024-05-21
  django-q = throw "django-q has been removed because it is unmaintained and was unused"; # added 2024-12-13
  django_reversion = django-reversion; # added 2022-06-18
  django_polymorphic = django-polymorphic; # added 2022-05-24
  django_redis = django-redis; # added 2021-10-11
  django_silk = django-silk; # added 2023-07-25
  django-sr = throw "django-sr has been removed since it has been unmaintained for 10 years"; # added 2024-05-26
  django_tagging = django-tagging; # added 2023-07-25
  django_taggit = django-taggit; # added 2021-10-11
  django_treebeard = django-treebeard; # added 2023-07-25
  dns = dnspython; # added 2017-12-10
  docker_pycreds = docker-pycreds; # added 2024-01-03
  docker-py = throw "docker-py was renamed to docker in version 2.0.0 back in 2016"; # added 2024-05-29
  doctest-ignore-unicode = throw "doctest-ignore-unicode has been removed since it has been unmaintained for 11 years"; # added 2024-05-20
  dogpile_cache = dogpile-cache; # added 2021-10-28
  dogpile-core = throw "dogpile-core is no longer maintained, use dogpile-cache instead"; # added 2021-11-20
  dugong = throw "dugong is unmaintained since 2022 and has therefore been removed"; # added 2024-12-12
  eebrightbox = throw "eebrightbox is unmaintained upstream and has therefore been removed"; # added 2022-02-03
  EasyProcess = easyprocess; # added 2023-02-19
  email_validator = email-validator; # added 2022-06-22
  enhancements = throw "enhancements is unmaintained upstream and has therefore been removed"; # added 2023-10-27
  enum-compat = throw "enum-compat is a virtual package providing enum34, which does not do anything since Python 3.4"; # added 2025-02-15
  enum34 = throw "enum34 is no longer needed since Python 3.4"; # added 2025-03-06
  et_xmlfile = et-xmlfile; # added 2023-10-16
  etebase-server = throw "pkgs.python3.etebase-server has been removed, use pkgs.etebase-server"; # added 2024-07-16
  ev3dev2 = python-ev3dev2; # added 2023-06-19
  evernote = throw "evernote is intended for use with Python 2.X";
  eyeD3 = eyed3; # added 2024-01-03
  Fabric = fabric; # addedd 2023-02-19
  face_recognition = face-recognition; # added 2022-10-15
  face_recognition_models = face-recognition-models; # added 2022-10-15
  factory_boy = factory-boy; # added 2023-10-08
  fake_factory = throw "fake_factory has been removed because it is unused and deprecated by upstream since 2016."; # added 2022-05-30
  farm-haystack = throw "farm-haystack was removed in favor of haystack-ai"; # added 2024-07-03
  faster-fifo = throw "faster-fifo has been removed since it was an unused leaf package"; # added 2024-07-02
  fastnlo_toolkit = fastnlo-toolkit; # added 2024-01-03
  fastpair = throw "fastpair is unmaintained upstream and has therefore been removed"; # added 2024-05-01
  faulthandler = throw "faulthandler is built into ${python.executable}"; # added 2021-07-12
  inherit (super.pkgs) fetchPypi; # added 2023-05-25
  filebrowser_safe = filebrowser-safe; # added 2024-01-03
  filemagic = throw "inactive since 2014, so use python-magic instead"; # added 2022-11-19
  flaskbabel = flask-babel; # added 2023-01-19
  flask-babelex = throw "flask-babelex package has been removed, use flask-babel instead"; # added 2024-10-07
  flask_assets = flask-assets; # added 2023-08-23
  flask_elastic = flask-elastic; # added 2023-08-23
  flask_login = flask-login; # added 2022-10-17
  flask_mail = flask-mail; # added 2023-08-23
  flask_marshmallow = flask-marshmallow; # added 2023-08-16
  flask_migrate = flask-migrate; # added 2023-08-23
  flask_principal = flask-principal; # added 2023-08-23
  flask-restplus = throw "flask-restplus is no longer maintained, use flask-restx instead"; # added 2023-02-21
  flask_script = flask-script; # added 2023-08-23
  flask-security-too = flask-security; # added 2024-08-26
  flask_sqlalchemy = flask-sqlalchemy; # added 2022-07-20
  flask_testing = flask-testing; # added 2022-04-25
  flask_wtf = flask-wtf; # added 2022-05-24
  flask-autoindex = throw "flask-autoindex was removed, as it is not compatible with flask 3.0 and unmaintained since 2020.";
  flask-common = throw "flask-common was removed, as it is not compatible with flask 3.0 and unmaintained since 2018."; # added 2025-01-11
  flask-basicauth = throw "flask-basicauth was removed, as it is not compatible with flask 3.0 and unmaintained since 2016.";
  flask-sessionstore = throw "flask-sessionstore was removed, as it is not compatible with flask 3.0 and unmaintained since 2017.";
  flask-sockets = throw "flask-sockets has been removed as the upstream repository was archived in 2022"; # Added 2025-01-01
  flowlogs_reader = flowlogs-reader; # added 2024-01-03
  flufl_bounce = flufl-bounce; # added 2023-11-03
  flufl_i18n = flufl-i18n; # added 2023-11-03
  flufl_lock = flufl-lock; # added 2023-11-03
  fn = throw "fn was removed as it is no longer used by any package in nixpkgs, it is not compatible with python 3.11 or newer and it was last updated in 2014."; # added 2025-02-08 # added 2024-07-08
  FormEncode = formencode; # added 2023-02-19
  foundationdb51 = throw "foundationdb51 is no longer maintained, use foundationdb71 instead"; # added 2023-06-06
  foundationdb52 = throw "foundationdb52 is no longer maintained, use foundationdb71 instead"; # added 2023-06-06
  foundationdb60 = throw "foundationdb60 is no longer maintained, use foundationdb71 instead"; # added 2023-06-06
  foundationdb61 = throw "foundationdb61 is no longer maintained, use foundationdb71 instead"; # added 2023-06-06
  foundationdb71 = throw "foundationdb71 has been removed, use foundationdb73 instead"; # added 2024-12-28
  functorch = throw "functorch is now part of the torch package and has therefore been removed. See https://github.com/pytorch/functorch/releases/tag/v1.13.0 for more info."; # added 2022-12-01
  functools32 = throw "functool32 was removed from nixpkgs, because python 2.7 has reach end of life in early 2020"; # added 2024-05-16
  fritzprofiles = throw "fritzprofiles was removed from nixpkgs, because it was removed as dependency of home-assistant for which it was pacakged."; # added 2024-01-05
  garages-amsterdam = throw "garages-amsterdam has been renamed odp-amsterdam."; # added 2023-01-04
  garminconnect-ha = garminconnect; # added 2022-02-05
  gbulb = throw "gbulb has been removed as it is unmaintained and no longer compatible with PyGObject 3.50."; # added 2024-10-14
  gcs-oauth2-boto-plugin = throw "gcs-oauth2-boto-plugin was removed as it depends on the removed boto package"; # Added 2024-09-22
  gdtoolkit = throw "gdtoolkit has been promoted to a top-level attribute name: `pkgs.gdtoolkit`"; # added 2023-02-15
  geeknote = throw "geeknote depends on the Python2-only library evernote"; # Added 2025-03-22
  GeoIP = geoip; # added 2023-02-19
  gigalixir = throw "gigalixir has been promoted to a top-level attribute name: `pkgs.gigalixir`"; # Added 2022-10-02
  gitdb2 = throw "gitdb2 has been deprecated, use gitdb instead."; # added 2020-03-14
  github3_py = github3-py; # added 2024-01-04
  GitPython = gitpython; # added 2022-10-28
  glances = throw "glances has moved to pkgs.glances"; # added 2020-20-28
  glasgow = throw "glasgow has been promoted to a top-level attribute name: `pkgs.glasgow`"; # added 2023-02-05
  globre = throw "globre was removed, because it was disabled on all python version since 3.7 and last updated in 2020."; # added 2024-05-13
  goobook = throw "goobook has been promoted to a top-level attribute name: `pkgs.goobook`"; # Added 2025-03-25
  google-reauth = throw "google-reauth has been removed because the upstream repository was archived in 2023"; # Added 2024-10-04
  google_api_python_client = google-api-python-client; # added 2021-03-19
  googleapis_common_protos = googleapis-common-protos; # added 2021-03-19
  google-apitools = throw "google-apitools was removed because it is deprecated and unsupported by upstream"; # added 2023-02-25
  gpyopt = throw "gpyopt was remove because it's been archived upstream"; # added 2023-06-07
  gradient_statsd = gradient-statsd; # added 2024-01-06
  graphite_api = throw "graphite_api was removed, because it is no longer maintained"; # added 2022-07-10
  graphite_beacon = throw "graphite_beacon was removed, because it is no longer maintained"; # added 2022-07-09
  grappelli_safe = grappelli-safe; # added 2023-10-08
  groestlcoin_hash = groestlcoin-hash; # added 2024-01-06
  grpc_google_iam_v1 = grpc-google-iam-v1; # added 2021-08-21
  inherit (pkgs) gtimelog;
  guzzle_sphinx_theme = guzzle-sphinx-theme; # added 2023-10-16
  ha-av = throw "ha-av was removed, because it is no longer maintained"; # added 2022-04-06
  HAP-python = hap-python; # added 2021-06-01
  hangups = throw "hangups was removed because Google Hangouts has been shut down"; # added 2023-02-13
  hbmqtt = throw "hbmqtt was removed because it is no longer maintained"; # added 2021-11-07
  hcs_utils = hcs-utils; # added 2024-01-06
  hdlparse = throw "hdlparse has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2022-01-18
  hglib = python-hglib; # added 2023-10-13
  hkdf = throw "hkdf has been removed, as it is no longer maintained upstream."; # added 2024-10-04
  homeassistant-bring-api = bring-api; # added 2024-04-11
  homeassistant-pyozw = throw "homeassistant-pyozw has been removed, as it was packaged for home-assistant which has removed it as a dependency."; # added 2024-01-05
  htmllaundry = throw "htmllaundry has been removed because it is abandoned"; # added 2024-06-04
  HTSeq = htseq; # added 2023-02-19
  hug = throw "hug was marked broken since 2021 and has not established compatibility with newer dependency versions. It has therefore been removed."; # added 2024-11-15
  huisbaasje-client = throw "huisbaasje-client has been removed because it was replaced with energyflip-client"; # added 2025-05-12
  hyperkitty = throw "Please use pkgs.mailmanPackages.hyperkitty"; # added 2022-04-29
  hydra-check = throw "The Python package hydra-check was removed in favor of the top-level rust based pkgs.hydra-check"; # added 2022-04-29
  ihatemoney = throw "ihatemoney was removed because it is no longer maintained downstream"; # added 2023-04-08
  IMAPClient = imapclient; # added 2021-10-28
  imdbpy = throw "imdbpy has been renamed to cinemagoer"; # added 2022-08-08
  image-match = throw "image-match has been removed because it is no longer maintained"; # added 2023-06-10
  imgaug = throw "imgaug has been removed as it is no longer maintained"; # added 2023-07-10
  imgtool = throw "imgtool has been promoted to a top-level attribute name: `mcuboot-imgtool`"; # added 2024-10-09
  intreehook = throw "intreehooks has been removed because it is obsolete as a backend-path key was added to PEP 517"; # added 2023-04-11
  ipaddress = throw "ipaddress has been removed because it is no longer required since python 2.7."; # added 2022-05-30
  ipdbplugin = throw "ipdbplugin has been removed because it has no longer maintained for 6 years"; # added 2024-05-21
  ipython_genutils = ipython-genutils; # added 2023-10-12
  influxgraph = throw "influxgraph has been removed because it is no longer maintained"; # added 2022-07-10
  itanium_demangler = itanium-demangler; # added 2022-10-17
  jaeger-client = throw "jaeger-client was removed because it is deprecated upstream. OpenTelemetry is recommended instead."; # Added 2024-12-09
  jaraco_classes = jaraco-classes; # added 2023-07-14
  jaraco_collections = jaraco-collections; # added 2023-07-14
  jaraco_functools = jaraco-functools; # added 2023-07-14
  jaraco_itertools = jaraco-itertools; # added 2023-07-14
  jaraco_logging = jaraco-logging; # added 2023-07-14
  jaraco_text = jaraco-text; # added 2023-07-14
  jaraco_stream = jaraco-stream; # added 2023-07-14
  JayDeBeApi = jaydebeapi; # added 2023-02-19
  jinja2_pluralize = jinja2-pluralize; # added 2023-11-01
  jinja2_time = jinja2-time; # added 2022-11-07
  JPype1 = jpype1; # added 2023-02-19
  js2py = throw "js2py has been removed, as it is unmaintained and insecure"; # added 2024-10-17
  jsonpath_rw = jsonpath-rw; # added 2024-01-06
  jsonschema_3 = throw "jsonschema 3 is neither the latest version nor needed inside nixpkgs anymore"; # added 2023-06-28
  jupyter_client = jupyter-client; # added 2021-10-15
  jupyter_console = jupyter-console; # added  2023-07-31
  jupyter-contrib-nbextensions = throw "jupyter-contrib-nbextensions has been removed, as it does not work with Jupyter Notebook 7"; # added 2024-09-22
  jupyter_core = jupyter-core; # added 2023-01-05
  jupyter_server = jupyter-server; # added 2023-01-05
  jupyter-server-ydoc = jupyter-collaboration; # added 2023-07-18
  jupyterlab_launcher = throw "jupyterlab_launcher has been removed as it's abandoned for over 5 years and broken"; # added 2023-11-11
  jupyterlab_server = jupyterlab-server; # added 2023-11-12
  kafka-python = kafka-python-ng; # added 2024-07-19
  Kajiki = kajiki; # added 2023-02-19
  keepkey_agent = keepkey-agent; # added 2024-01-06
  Keras = keras; # added 2021-11-25
  keras-applications = throw "keras-applications has been removed because it's abandoned since 2022"; # added 2025-01-12
  keras-preprocessing = throw "keras-preprocessing has been removed because it's abandoned since 2024"; # added 2025-01-12
  keyring_24 = throw "keyring_24 has been removed, use keyring instead"; # added 2025-01-01
  ldap = python-ldap; # added 2022-09-16
  lammps-cython = throw "lammps-cython no longer builds and is unmaintained"; # added 2021-07-04
  langchain-standard-tests = langchain-tests; # added 2025-01-22
  langchainplus-sdk = langsmith; # added 2023-08-01
  langgraph-checkpoint-duckdb = throw "langgraph-checkpoint-duckdb has been removed as of langgraph 0.2.63"; # added 2025-04-04
  lazr_config = lazr-config; # added 2023-11-03
  lazr_delegates = lazr-delegates; # added 2023-11-03
  lazy_import = lazy-import; # added 2024-01-07
  lazy-import = throw "lazy-import has been removed because it was unused."; # added 2024-05-20
  lazy_imports = lazy-imports; # added 2023-10-13
  ledger_agent = ledger-agent; # Added 2024-01-07
  lektor = throw "lektor has been promoted to a top-level attribute name: `pkgs.lektor`"; # added 2023-08-01
  libgpuarray = throw "libgpuarray has been removed, as it was unmaintained."; # added 2024-08-03
  line_profiler = line-profiler; # added 2023-11-04
  linear_operator = linear-operator; # added 2024-01-07
  livestreamer = throw "'livestreamer' has been removed, as it unmaintained. A currently maintained fork is 'streamlink'."; # added 2023-11-14
  livestreamer-curses = throw "'livestreamer-curses' has been removed as it, and livestreamer itself are unmaintained."; # added 2023-11-14
  lmcloud = pylamarzocco; # added 2024-11-26
  localstack = throw "localstack was promoted to a top-level attribute"; # added 2025-02-21
  logi-circle = throw "logi-circle has been removed because the logi_circle integration was removed from Home Assistant"; # added 2025-05-13
  logilab_astng = throw "logilab-astng has not been released since 2013 and is unmaintained"; # added 2022-11-29
  logilab_common = logilab-common; # added 2022-11-21
  loo-py = loopy; # added 2022-05-03
  ludios_wpull = throw "ludios_wpull has been removed because it's unmaintained and broken"; # added 2023-11-12
  luxor = throw "luxor has been removed because it is unmaintained and broken"; # added 2025-01-25
  lcov_cobertura = lcov-cobertura; # added 2024-01-07
  Mako = mako; # added 2023-02-19
  Markups = markups; # added 2022-02-14
  markdownsuperscript = throw "markdownsuperscript is unmaintained, use pymdown-extensions"; # added 2023-06-10
  mask-rcnn = throw "mask-rcnn has been removed as it is unmaintained and its dependency imgaug no longer builds"; # added 2023-07-10
  mac_alias = mac-alias; # added 2024-01-07
  MDP = mdp; # added 2023-02-19
  mdp = throw "mdp has been removed as it is unmaintained and broken"; # added 2024-11-23
  MechanicalSoup = mechanicalsoup; # added 2021-06-01
  memcached = python-memcached; # added 2022-05-06
  mailman = throw "Please use pkgs.mailman"; # added 2022-04-29
  mailman-hyperkitty = throw "Please use pkgs.mailmanPackages.mailman-hyperkitty"; # added 2022-04-29
  mailman-web = throw "Please use pkgs.mailman-web"; # added 2022-04-29
  manticore = throw "manticore has been removed because its dependency wasm no longer builds and is unmaintained"; # added 2023-05-20
  mapbox = throw "mapbox has been removed because the upstream repository was archived in 2022"; # Added 2024-10-04
  marshmallow-enum = throw "marshmallow-enum has been removed because it was archived in 2022 and had no maintainer"; # added 2024-05-10
  markerlib = throw "markerlib has been removed because it's abandoned since 2013"; # added 2023-05-19
  matrix-api-async = throw "matrix-api-async has been removed as it is an old wrapper and no longer in use"; # added 2025-01-01
  memory_profiler = memory-profiler; # added 2023-10-09
  mir_eval = mir-eval; # added 2024-01-07
  mistune_0_8 = throw "mistune_0_8 was removed because it was outdated and insecure"; # added 2022-08-12
  mistune_2_0 = mistune; # added 2022-08-12
  mitmproxy-wireguard = throw "mitmproxy-wireguard has been removed because it was replaced by upstream with mitmproxy-rs"; # added 2023-11-06
  mkdocs-awesome-pages-plugin = mkdocs-awesome-nav; # added 2025-03-10
  mkdocs-minify = mkdocs-minify-plugin; # added 2023-11-28
  mne-python = mne; # added 2025-05-02
  modestmaps = throw "modestmaps is unmaintained and was never enabled for anything except Python27"; # Added 2025-03-23
  mox = throw "mox was removed because it is unmaintained"; # added 2023-02-21
  mox3 = throw "mox3 was removed because it is unmaintained"; # added 2024-08-30
  mrkd = throw "mrkd has been promoted to a top-level attribute name: `pkgs.mrkd`"; # added 2023-08-01
  multi_key_dict = multi-key-dict; # added 2023-11-05
  mutmut = throw "mutmut has been promoted to a top-level attribute name: `pkgs.mutmut`"; # added 2022-10-02
  n3fit = throw "n3fit has been removed since it relies on a dependency that was removed"; # added 2024-08-24
  nbmerge = throw "nbmerge has moved to pkgs.nbmerge"; # added 2024-07-05
  mypy-boto3-alexaforbusiness = throw "mypy-boto3-alexaforbusiness was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-backupstorage = throw "mypy-boto3-backupstorage was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-gamesparks = throw "mypy-boto3-gamesparks was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-honeycode = throw "mypy-boto3-honeycode was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-iot-roborunner = throw "mypy-boto3-iot-roborunner was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-macie = throw "mypy-boto3-macie was removed because it is unmaintained"; # added 2024-09-04
  mypy-boto3-mobile = throw "mypy-boto3-mobile was removed because it is unmaintained"; # added 2024-09-04
  net2grid = gridnet; # add 2022-04-22
  nghttp2 = throw "in 1.52.0 removed deprecated python bindings."; # added 2023-06-08
  niko-home-control = throw "niko-home-control was removed because Home Assistant switched to nhc"; # added 2025-01-09
  ninja-python = ninja; # add 2022-08-03
  nose = throw "nose has been removed since it has been deprecated and unmaintained for almost a decade and does not work on Python 3.12; please switch to pytest or another test runner/framework"; # added 2024-07-28
  nose3 = throw "nose3 has been removed since it is unmaintained and does not work with Python 3.12"; # added 2024-07-28
  nosejs = throw "nosejs has been removed since it has not been maintained for 15 years and there are no dependent packages"; # added 2024-05-21
  nose-cov = throw "nose-cov has been removed, it was archived and unmaintained since 2012"; # added 2024-05-21
  nosexcover = throw "nosexcover has been removed since it has not been maintained and there are no dependent packages"; # added 2024-05-21
  nose-cover3 = throw "nose-cover3 has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2022-02-16
  nose-cprof = throw "nose-cprof has been removed since it has not been maintained for 7 years and there are no dependent packages"; # added 2024-05-21
  nose-exclude = throw "nose-exclude has been removed since it has not been maintained since 2016"; # added 2024-05-21
  nose-randomly = throw "nose-randomly has been removed, it was archived and unmaintained since 2019"; # added 2024-05-22
  nose-pattern-exclude = throw "nose-pattern-exclude has been removed as it has been unmaintained since 2014"; # added 2024-07-27
  nose_progressive = throw "nose_progressive has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2023-02-21
  nose-timer = throw "nose-timer has been removed as it depends on the abandoned nose test framework"; # added 2024-07-27
  nose-warnings-filters = throw "nose-warnings-filters has been removed as it has been unmaintained since 2016"; # added 2024-07-27
  nose_warnings_filters = nose-warnings-filters; # added 2024-01-07
  nose-xunitmp = throw "nose-xunitmp has been removed as it depends on the abandoned nose test framework"; # added 2024-07-29
  notifymuch = throw "notifymuch has been promoted to a top-level attribute name: `pkgs.notifymuch`"; # added 2022-10-02
  Nuitka = nuitka; # added 2023-02-19
  ntlm-auth = throw "ntlm-auth has been removed, because it relies on the md4 implementation provided by openssl. Use pyspnego instead.";
  openai-triton = triton; # added 2024-07-18
  openai-triton-bin = triton-bin; # added 2024-07-18
  openai-triton-cuda = triton-cuda; # added 2024-07-18
  openai-triton-no-cuda = triton-no-cuda; # added 2024-07-18
  openapi-schema-pydantic = throw "openapi-schema-pydantic has been removed, since it is no longer maintained"; # added 2023-10-30
  opencv3 = throw "opencv3 has been removed as it is obsolete"; # added 2023-10-12
  openllm = throw "openllm has moved to pkgs.openllm"; # added 2021-12-31
  openllm-client = throw "openllm-client has been removed, since it is abandoned due to a change in philosophy"; # added 2024-08-24
  openllm-core = throw "openllm-core has been removed, since it is abandoned due to a change in philosophy"; # added 2024-08-24
  opsdroid_get_image_size = opsdroid-get-image-size; # added 2023-10-16
  opentracing = throw "The opentracing Python module was removed due to being unmaintained upstream. Use OpenTelemetry instead."; # Added 2024-12-09
  ordereddict = throw "ordereddict has been removed because it is only useful on unsupported python versions."; # added 2022-05-28
  pafy = throw "pafy has been removed because it is unmaintained and only a dependency of mps-youtube, itself superseded by yewtube"; # Added 2023-01-19
  paho-mqtt_1 = throw "paho-mqtt_1 was removed because no package depends on it anymore"; # added 2025-03-05
  paho-mqtt_2 = paho-mqtt; # added 2025-03-05
  pam = python-pam; # added 2020-09-07.
  PasteDeploy = pastedeploy; # added 2021-10-07
  pathlib = throw "pathlib was removed as it has been integrated in python standard library in version 3.4"; # added 2024-05-13
  pathpy = path; # added 2022-04-12
  pcbnew-transition = pcbnewtransition; # added 2024-03-21
  pc-ble-driver-py = throw "pc-ble-driver-py has been removed because the upstream repository was archived in 2024"; # Added 2024-10-04
  pdfposter = throw "pdfposter was promoted to a top-level attribute"; # Added 2023-06-29
  pdfminer = pdfminer-six; # added 2022-05-25
  pdfx = throw "pdfx has been removed because the upstream repository was archived in 2023"; # Added 2024-10-04
  pep257 = pydocstyle; # added 2022-04-12
  pillow-simd = throw "pillow-simd has been removed for lagging behind pillow upstream, which exposes it to various security issues."; # Added 2024-10-24
  pipenv-poetry-migrate = throw "pipenv-poetry-migrate was promoted to a top-level attribute"; # added 2025-01-14
  pixelmatch = "pixelmatch has been removed as it was unmaintained"; # Added 2024-08-18
  pkutils = throw "pkutils was removed as it was unused and is not applicable to modern Python build tools"; # added 2024-07-28
  poetry = throw "poetry was promoted to a top-level attribute, use poetry-core to build Python packages"; # added 2023-01-09
  poetry2conda = throw "poetry2conda was promoted to a top-level attribute"; # Added 2022-10-02
  Polygon3 = polygon3; # Added 2023-08-08
  posix_ipc = posix-ipc; # added 2024-01-07
  poster3 = throw "poster3 is unmaintained and source is no longer available"; # added 2023-05-29
  postorius = throw "Please use pkgs.mailmanPackages.postorius"; # added 2022-04-29
  powerlineMemSegment = powerline-mem-segment; # added 2021-10-08
  prayer-times-calculator = prayer-times-calculator-offline; # added 2024-08-11
  premailer = throw "premailer was removed, as it is not compatible with lxml>4.9.4.";
  privacyidea-ldap-proxy = throw "privacyidea-ldap-proxy has been removed from nixpkgs"; # added 2023-10-31
  proboscis = throw "proboscis has been removed since it has not been maintained for 11 years"; # added 2024-05-20
  prometheus_client = prometheus-client; # added 2021-06-10
  prompt_toolkit = prompt-toolkit; # added 2021-07-22
  protonup = protonup-ng; # Added 2022-11-06
  proton-keyring-linux-secretservice = throw "proton-keyring-linux-secretservice functionality was integrated in the proton-keyring-linux module"; # added 2024-10-16
  proton-vpn-connection = throw "proton-vpn-connection functionality was integrated in the proton-vpn-api-core module"; # added 2024-10-16
  proton-vpn-killswitch = throw "proton-vpn-killswitch functionality was integrated in the proton-vpn-api-core module"; # added 2024-10-16
  proton-vpn-killswitch-network-manager = throw "proton-vpn-killswitch-network-manager functionality was integrated in the proton-vpn-network-manager module"; # added 2024-10-16
  proton-vpn-killswitch-network-manager-wireguard = throw "proton-vpn-killswitch-network-manager-wireguard functionality was integrated in the proton-vpn-network-manager module"; # added 2024-10-16
  proton-vpn-logger = throw "proton-vpn-logger functionality was integrated in the proton-vpn-api-core module"; # added 2024-10-16
  proton-vpn-network-manager-openvpn = throw "proton-vpn-network-manager-openvpn functionality was integrated in the proton-vpn-network-manager module"; # added 2024-10-16
  proton-vpn-network-manager-wireguard = throw "proton-vpn-network-manager-wireguard functionality was integrated in the proton-vpn-network-manager module"; # added 2024-10-16
  proton-vpn-session = throw "proton-vpn-session functionality was integrated in the proton-vpn-api-core module"; # added 2024-10-16
  proxy_tools = proxy-tools; # added 2023-11-05
  pur = throw "pur has been renamed to pkgs.pur"; # added 2021-11-08
  pushbullet = pushbullet-py; # Added 2022-10-15
  Pweave = pweave; # added 2023-02-19
  pwndbg = throw "'pwndbg' has been removed due to dependency version incompatibilities that are infeasible to maintain in nixpkgs. Use the downstream flake that pwndbg provides instead: https://github.com/pwndbg/pwndbg"; # Added 2025-02-09
  pxml = throw "pxml was removed, because it was disabled on all python version since 3.8 and last updated in 2020."; # added 2024-05-13
  py3to2 = throw "py3to2 is unmaintained and source is no longer available"; # added 2024-10-23
  pypcap = throw "pypcap has been removed because it is broken and unmaintained upstream."; # added 2025-06-18
  py-radix = throw "py-radix has been removed, since it abandoned"; # added 2023-07-07
  py_stringmatching = py-stringmatching; # added 2023-11-12
  py17track = throw "py17track was removed because Home Assistant switched to pyseventeentrack"; # added 2024-08-08
  pyalmond = throw "pyalmond has been removed, since its API endpoints have been shutdown"; # added 2023-02-02
  pyblake2 = throw "pyblake2 is deprecated in favor of hashlib"; # added 2023-04-23
  pyblock = throw "pyblock has been removed, since it is abandoned and broken"; # added 2023-06-20
  pychart = throw "pychart does not support Python3"; # added 2025-03-23
  pycontracts = throw "pycontracts has been removed, since upstream is no longer active and it is broken on modern Python versions."; # added 2024-08-09
  pydns = py3dns; # added 2024-10-25
  pydrive = throw "pydrive is broken and deprecated and has been replaced with pydrive2."; # added 2022-06-01
  pyephember = throw "pyephember was removed because Home Assistant switched to pyephember2"; # added 2025-05-07
  pyjet = throw "pyjet is deprecated, use fastjet instead"; # added 2023-05-10
  pygame_sdl2 = pygame-sdl2; # added 2024-01-07
  pygogo = throw "pygogo has been removed, since it is abandoned and had no maintainer"; # added 2024-07-27
  pygbm = throw "pygbm has been removed, since it is abandoned and broken"; # added 2023-06-20
  PyGithub = pygithub; # added 2023-02-19
  pyGtkGlade = throw "Glade support for pygtk has been removed"; # added 2022-01-15
  pycallgraph = throw "pycallgraph has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2022-01-18
  pychef = throw "pychef has been removed because it's been archived upstream and abandoned since 2017."; # added 2022-11-14
  PyChromecast = pychromecast; # added 2023-02-19
  pycryptodome-test-vectors = throw "pycryptodome-test-vectors has been removed because it is an internal package to pycryptodome"; # added 2022-05-28
  pyfftw = throw "pyfftw has been removed because it is unmaintained and broken."; # Added 2024-06-17
  pyflunearyou = pyoutbreaksnearme; # added 2023-02-11
  pyialarmxr = pyialarmxr-homeassistant; # added 2022-06-07
  pyialarmxr-homeassistant = throw "The package was removed together with the component support in home-assistant 2022.7.0"; # added 2022-07-07
  PyICU = pyicu; # Added 2022-12-22
  pyhiveapi = pyhive-integration; # Added 2025-02-22
  pyhs100 = throw "pyhs100 has been removed in favor of python-kasa."; # added 2024-01-05
  pylibgen = throw "pylibgen is unmaintained upstreamed, and removed from nixpkgs"; # added 2020-06-20
  pyliblo = throw "pyliblo is unmaintained upstream and was removed from nixpkgs. Please use pyliblo3 instead"; # added 2025-06-23
  PyLD = pyld; # added 2022-06-22
  pylti = throw "pylti has been removed because it is unmaintained since 2019"; # added 2024-05-21
  pymaging = throw "pymaging has been removed because it has not been maintained for 10 years and has been archived."; # added 2023-11-04
  pymaging_png = throw "pymaging_png has been removed because it has not been maintained for 10 years and has been archived."; # added 2023-11-04
  pymatgen-lammps = throw "pymatgen-lammps has been removed because it is unmaintained and broken"; # added 2023-06-20
  pymazda = throw "pymazda has been removed, because the upstream repo has been affected by a DCMA claim."; # added 2023-10-16
  pymc3 = pymc; # added 2022-06-05, module was rename starting with 4.0.0
  pymelcloud = python-melcloud; # added 2025-05-08
  pymssql = throw "pymssql has been abandoned upstream."; # added 2020-05-04
  PyMVGLive = pymvglive; # added 2023-02-19
  pymyq = python-myq; # added 2023-10-20
  pynose = throw "pynose was removed, because it violates the license of nose, by redistributing modified LGPL code under MIT.";
  python-ethtool = ethtool; # added 2024-07-23
  python-myq = throw "python-myq has been removed, as the service provider has decided to block its API requests"; # added 2023-12-07
  python-picnic-api = throw "python-picnic-api was removed because Home Assistant switched to python-picnic-api2"; # added 2025-03-05
  pytrends = throw "pytrends has been removed, as it no longer works and is abandoned upstream"; # added 2025-02-02
  pyqt4 = throw "pyqt4 has been removed, because it depended on the long EOL qt4"; # added 2022-06-09
  pyqt5_sip = pyqt5-sip; # added 2024-01-07
  pyqt5_with_qtmultimedia = pyqt5-multimedia; # added 2024-01-07
  pyqt5_with_qtwebkit = pyqt5-webkit; # added 2024-01-07
  pyramid_beaker = pyramid-beaker; # added 2023-08-23
  pyramid_chameleon = pyramid-chameleon; # added 2023-08-23
  pyramid_exclog = pyramid-exclog; # added 2023-08-24
  pyramid_hawkauth = throw "pyramid_hawkauth has been removed because it is no longer maintained"; # added 2023-02-2
  pyramid_jinja2 = pyramid-jinja2; # added 2023-06-06
  pyramid_mako = pyramid-mako; # added 2023-08-24
  pyramid_multiauth = pyramid-multiauth; # added 2023-08-24
  pyreadability = readability-lxml; # added 2022-05-24
  pyres = throw "pyres has been removed, since it is abandoned and broken"; # added 2023-06-20
  pygeoip = throw "pygeoip has been removed, since it wash archived in April 2018"; # added 2024-07-27
  pygeos = throw "pygeos has been removed, since it was merged with shapely 2.0"; # added 2024-05-26
  pyreqwest-impersonate = throw "pyreqwest has been renamed to primp"; # added 2024-10-22
  pyRFC3339 = pyrfc3339; # added 2024-01-07
  pyroute2-core = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-ethtool = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-ipdb = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-ipset = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-ndb = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-nftables = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-nslink = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  pyroute2-protocols = throw "pyroute2 migrated back to a single package scheme in version 0.7.1"; # added 2022-07-16
  Pyro4 = pyro4; # added 2023-02-19
  Pyro5 = pyro5; # added 2023-02-19
  PyRSS2Gen = pyrss2gen; # added 2023-02-19
  pyruckus = throw "pyruckus has been removed, it was deprecrated in favor of aioruckus."; # added 2023-09-07
  py_scrypt = py-scrypt; # added 2024-01-07
  pysha3 = throw "pysha3 has been removed, use safe-pysha3 instead"; # added 2023-05-20
  pysimplegui = throw "pysimplegui update to v5 broke the package, it now needs a license key to decrypt the source code"; # added 2024-09-16
  pysmart-smartx = pysmart; # added 2021-10-22
  pySmartDL = pysmartdl; # added 2023-10-11
  pysmi-lextudio = pysmi; # added 2024-07-18
  pysnmp-lextudio = pysnmp; # added 2024-07-18
  pysparse = throw "pysparse has been abandoned upstream."; # added 2023-02-28
  pyspotify = throw "pyspotify has been removed because Spotify stopped supporting libspotify"; # added 2022-05-29
  PyStemmer = pystemmer; # added 2023-02-19
  pysuez = pysuezv2; # added 2025-03-14
  pytado = python-tado; # added 2024-12-02
  pytest_6 = pytest; # added 2022-02-10
  pytestcov = pytest-cov; # added 2021-01-04
  pytest-ordering = throw "pytest-ordering has been removed, since it is no longer maintained and broken"; # added 2023-06-22
  pytest-openfiles = throw "pytest-openfiles has been removed, since it is unmaintained and archived"; # added 2024-06-19
  pytest-pep8 = pytestpep8; # added 2021-01-04
  pytest-pep257 = throw "pytest-pep257 was removed, as the pep257 package was migrated into pycodestyle"; # added 2022-04-12
  pytest-pythonpath = throw "pytest-pythonpath is obsolete as of pytest 7.0.0 and has been removed"; # added 2022-03-09
  pytest-runner = throw "pytest-runner has been removed as it uses deprecated features of setuptools and is deprecated by upstream"; # added 2024-09-15
  pytest-sanic = throw "pytest-sanic has been removed because it is unmaintained and broken"; # added 2023-06-22
  pytestpep8 = throw "pytestpep8 was removed because it is abandoned and no longer compatible with pytest v6.0"; # added 2020-12-10
  pytestquickcheck = pytest-quickcheck; # added 2021-07-20
  pytestrunner = pytest-runner; # added 2021-01-04
  python-forecastio = throw "python-forecastio has been removed, as the Dark Sky service was shut down."; # added 2023-04-05
  python-igraph = igraph; # added 2021-11-11
  python_openzwave = python-openzwave; # added 2024-01-07
  python-openzwave-mqtt = throw "python-openzwave was removed, as it was packaged as a dependency of home-assistant, which it is no longer."; # added 2024-01-05
  python_docs_theme = python-docs-theme; # added 2023-11-04
  python_fedora = python-fedora; # added 2023-11-15
  python_keyczar = throw "python_keyczar has been removed because it's been archived upstream and deprecated"; # added 2023-05-16
  python-lz4 = lz4; # added 2018-06-01
  python_magic = python-magic; # added 2022-05-07
  python_mimeparse = python-mimeparse; # added 2021-10-31
  python-language-server = throw "python-language-server is no longer maintained, use the python-lsp-server community fork instead."; # Added 2022-08-03
  python-Levenshtein = levenshtein;
  python-pushover = throw "python-pushover has been removed, since it is unmaintained and is broken"; # added 2023-07-03
  python-subunit = subunit; # added 2021-09-10
  python-wifi = throw "python-wifi does not support Python3";
  pytest_xdist = pytest-xdist; # added 2021-01-04
  python_simple_hipchat = python-simple-hipchat; # added 2021-07-21
  pytoml = throw "pytoml has been removed because it is unmaintained and is superseded by toml"; # Added 2023-04-11
  pytorch = torch; # added 2022-09-30
  pytorch-bin = torch-bin; # added 2022-09-30
  pytorchWithCuda = torchWithCuda; # added 2022-09-30
  pytorchWithoutCuda = torchWithoutCuda; # added 2022-09-30
  pytwitchapi = twitchapi; # added 2022-03-07
  pytzdata = throw "pytzdata has been removed, because iit is unmaintained upstream. Use pytz or tzdata instead."; # added 2025-03-03
  pyuavcan = throw "pyuavcan has been renamed to pycyphal and the old package deprecated, use pycyphal instead"; # added 2024-02-09
  pyunifiprotect = throw "pyunifiprotect has disappeared from GitHub and PyPI, use uiprotect instead"; # added 2024-09-17
  pyutilib = throw "pyutilib has been removed, since it is no longer maintained"; # added 2024-07-28
  pyvicare-neo = pyvicare; # Added 2024-11-06
  pyvcf = throw "pyvcf has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2023-05-19
  PyVirtualDisplay = pyvirtualdisplay; # added 2023-02-19
  pywick = throw "pywick has been removed, since it is no longer maintained"; # added 2023-07-01
  pyxb = throw "pyxb has been removed, its last release was in 2017 and it has finally been archived in April 2023."; # added 2024-01-05
  pyzufall = throw "pyzufall was removed, because it is no longer maintained"; # added 2024-05-14
  qasm2image = throw "qasm2image is no longer maintained (since November 2018), and is not compatible with the latest pythonPackages.qiskit versions."; # added 2020-12-09
  qds-sdk = throw "qds-sdk was removed as it is unmaintained upstream and depends on the removed boto package"; # Added 2024-09-22
  qds_sdk = qds-sdk; # added 2023-10-21
  qmk-dotty-dict = throw "qmk-dotty-dict has been removed. It is no longer needed since the fixes have been merged into dotty-dict."; # added 2025-01-01
  Quandl = quandl; # added 2023-02-19
  quamash = throw "'quamash' has been removed, since it is unmaintained and broken"; # added 2024-10-17
  querystring_parser = querystring-parser; # added 2024-01-07
  qcodes-loop = throw "qcodes-loop has been removed due to deprecation"; # added 2023-11-30
  qiskit-aqua = throw "qiskit-aqua has been removed due to deprecation, with its functionality moved to different qiskit packages";
  rabbitpy = throw "rabbitpy has been removed, since it is unmaintained and broken"; # added 2023-07-01
  radicale_infcloud = radicale-infcloud; # added 2024-01-07
  radio_beam = radio-beam; # added 2023-11-04
  ratelimiter = throw "ratelimiter has been removed, since it is unmaintained and broken"; # added 2023-10-21
  rauth = throw "rauth has beed removed, since it is unmaintained upstream"; # added 2024-07-27
  rdflib-jsonld = throw "rdflib-jsonld is not compatible with rdflib 6"; # added 2021-11-05
  readme_renderer = readme-renderer; # added 2024-01-07
  recaptcha_client = throw "recaptcha_client has been removed since it is no longer maintained"; # added 2023-10-20
  recursivePthLoader = recursive-pth-loader; # added 2024-01-07
  rednose = throw "rednose is no longer maintained (since February 2018)"; # added 2023-08-06
  repeated_test = repeated-test; # added 2022-11-15
  repocheck = throw "repocheck has been promoted to a top-level attribute name: `pkgs.repocheck`"; # Added 2024-11-03
  reportengine = throw "reportengine has been removed, since it is unmaintained and broken"; # added 2024-08-21
  repoze_lru = repoze-lru; # added 2023-11-11
  repoze_sphinx_autointerface = repoze-sphinx-autointerface; # added 2023-11-11
  repoze_who = repoze-who; # added 2023-11-11
  requests_download = requests-download; # added 2024-01-07
  requests_ntlm = requests-ntlm; # added 2024-01-07
  requests_oauthlib = requests-oauthlib; # added 2022-02-12
  requests_toolbelt = requests-toolbelt; # added 2017-09-26
  restructuredtext_lint = restructuredtext-lint; # added 2023-11-04
  retry_decorator = retry-decorator; # added 2024-01-07
  retworkx = rustworkx; # added 2023-05-14
  rig = throw "rig has been removed because it was pinned to python 2.7 and 3.5, failed to build and is otherwise unmaintained"; # added 2022-11-28
  rising = throw "rising has been removed because it was abandoned and archived by upstream"; # added 2024-11-15
  rl-coach = "rl-coach was removed because the project is discontinued and was archived by upstream"; # added 2023-05-03
  roboschool = throw "roboschool is deprecated in favor of PyBullet and has been removed"; # added 2022-01-15
  ronin = throw "ronin has been removed because it was unmaintained since 2018"; # added 2024-08-21
  ROPGadget = ropgadget; # added 2021-07-06
  rotate-backups = throw "rotate-backups was removed in favor of the top-level rotate-backups"; # added 2021-07-01
  rtslib = rtslib-fb; # added 2025-03-14
  ruamel_base = ruamel-base; # added 2021-11-01
  ruamel_yaml = ruamel-yaml; # added 2021-11-01
  ruamel_yaml_clib = ruamel-yaml-clib; # added 2021-11-01
  ruff-lsp = throw "ruff-lsp has been deprecated, use `ruff server` instead"; # added 2025-04-21
  runway-python = throw "SDK has been deprecated and was archived by upstream"; # added 2023-05-03
  safe = throw "safe has been removed, it was unmaintained sinced October 2019"; # added 2024-07-28
  sabyenc = throw "sabyenc has been removed, due to no updates since June 2019 and being superseded by sabyenc3"; # added 2025-05-03
  sampledata = throw "sampledata has been removed, it was unmaintained since 2017"; # added 2024-07-27
  sapi-python-client = kbcstorage; # added 2022-04-20
  scikitimage = scikit-image; # added 2023-05-14
  scikitlearn = scikit-learn; # added 2021-07-21
  scikit-optimize = throw "scikit-optimize has been removed because it is abandoned"; # added 2024-09-30
  scikits-samplerate = throw "scikits-samplerate has been removed, it was unsed and unmaintained since 2015"; # added 2024-05-23
  selectors2 = throw "selectors2 has been removed: archived by upstream."; # added 2024-07-27
  selectors34 = throw "selectors34 has been removed: functionality provided by Python itself; archived by upstream."; # added 2021-06-10
  sentry-sdk_2 = sentry-sdk; # added 2025-04-20
  sequoia = throw "python3Packages.sequoia was replaced by pysequoia - built from a dedicated repository, with a new API."; # added 2023-06-24
  setuptools_dso = setuptools-dso; # added 2024-03-03
  setuptools_scm = setuptools-scm; # added 2021-06-03
  setuptoolsCheckHook = throw "The setuptoolsCheckHook has been removed, since the test command has been removed in setuptools 72.0."; # added 2024-08-06
  setuptoolsTrial = setuptools-trial; # added 2023-11-11
  sharkiqpy = sharkiq; # added 2022-05-21
  shouldbe = throw "shouldbe was removed, because it was disabled on all python version since 3.8 and last updated in 2019."; # added 2024-05-12
  sip_4 = sip4; # added 2024-01-07
  slackclient = slack-sdk; # added 2024-06-27
  slimit = throw "slimit was removed, because it was an unused and broken leaf package last updated in 2018."; # added 2025-05-17
  ssh-mitm = throw "ssh-mitm was removed in favor of the top-level ssh-mitm"; # added 2023-05-09
  smart_open = smart-open; # added 2021-03-14
  smmap2 = throw "smmap2 has been deprecated, use smmap instead."; # added 2020-03-14
  smpp_pdu = smpp-pdu; # added 2024-03-05
  somecomfort = throw "somecomfort was removed because Home Assistant switched to aiosomecomfort"; # added 2023-02-01
  sonarr = throw "sonarr has been deprecated and removed"; # added 2025-01-13
  solaredge = throw "solaredge was removed because Home Assistant switched to aiosolaredge"; # added 2024-07-15
  sorl_thumbnail = sorl-thumbnail; # added 2023-11-12
  spacy_models = spacy-models; # added 2024-04-21
  SPARQLWrapper = sparqlwrapper;
  spark_parser = spark-parser; # added 2024-01-07
  sphinx-jquery = sphinxcontrib-jquery; # added 2023-02-24
  sphinx_pypi_upload = throw "sphinx_pypi_upload has been removed since it is abandoned."; # added 2023-10-11
  sphinx_rtd_theme = sphinx-rtd-theme; # added 2022-08-03
  sphinxcontrib-autoapi = sphinx-autoapi; # added 2023-02-28
  sphinxcontrib_httpdomain = sphinxcontrib-httpdomain; # added 2023-07-20
  sphinxcontrib_newsfeed = sphinxcontrib-newsfeed; # added 2023-07-20
  sphinxcontrib_plantuml = sphinxcontrib-plantuml; # added 2021-08-02
  sphinx-navtree = throw "sphinx-navtree has been removed since it is not compatible with sphinx 3.3 and unmaintained"; # added 2023-07-03
  sqlalchemy-migrate = throw "sqlalchemy-migrate has been removed because it is abandoned upstream and incompatible with SQLAlchemy 2"; # added 2024-07-29
  sqlalchemy_migrate = sqlalchemy-migrate; # added 2021-10-28
  SQLAlchemy-ImageAttach = throw "sqlalchemy-imageattach has been removed as it is incompatible with sqlalchemy 1.4 and unmaintained"; # added 2022-04-23
  sqlsoup = throw "sqlsoup has been removed as it is incompatible with modern SQLAlchemy and unmaintained"; # added 2024-05-13
  subdownloader = throw "subdownloader has been removed, because it depended on pyqt4"; # added 2022-06-09
  suds-jurko = throw "suds-jurko has been removed, it was using setuptools 2to3 translation feature, which has been removed in setuptools 58"; # added 2023-02-27
  supervise_api = supervise-api; # added 2023-10-11
  suseapi = throw "suseapi has been removed because it is no longer maintained"; # added 2023-02-27
  synologydsm-api = py-synologydsm-api; # added 2024-07-29
  sysv_ipc = sysv-ipc; # added 2024-01-07
  telegram = throw "telegram has been removed since it is abandoned"; # added 2024-11-06
  tempita = throw "tempita has been removed because it is unmaintained and the upstream repository is gone"; # added 2024-07-29
  tensorflow-bin_2 = tensorflow-bin; # added 2021-11-25
  tensorflow-build_2 = tensorflow-build; # added 2021-11-25
  tensorflow-estimator = tensorflow-estimator-bin; # added 2023-01-17
  tensorflow-estimator_2 = tensorflow-estimator; # added 2021-11-25
  tensorflow-tensorboard = tensorboard; # added 2022-03-06
  tensorflow-tensorboard_2 = tensorflow-tensorboard; # added 2021-11-25
  tilestache = throw "tilestache is unmaintained and Python3 compatibility is unknown"; # Added 2025-03-23
  Theano = theano; # added 2023-02-19
  TheanoWithCuda = theanoWithCuda; # added 2023-02-19
  TheanoWithoutCuda = theanoWithoutCuda; # added 2023-02-19
  theano = throw "theano has been removed because it is no longer maintained"; # added 2024-05-20
  theanoWithCuda = throw "theano has been removed because it is no longer maintained"; # added 2024-05-20
  theanoWithoutCuda = throw "theano has been removed because it is no longer maintained"; # added 2024-05-20
  theano-pymc = throw "theano-pymc has been removed because it is no longer maintained"; # added 2024-05-20
  thumborPexif = throw "thumborPexif has been removed, because it was unused."; # added 2024-01-07
  tissue = throw "tissue has been removed, because it is archived since October 2022"; # added 2024-07-27
  torchgpipe = throw "torchgpipe has been removed, because it appears unmaintained and Pytorch now includes pipeline parallelism support"; # added 2024-05-18
  tornado_4 = throw "tornado_4 has been removed, use tornado instead"; # added 2025-01-13
  tornado_5 = throw "tornado_5 has been removed, use tornado instead"; # added 2025-01-13
  torrent_parser = torrent-parser; # added 2023-11-04
  transip = throw "transip has been removed because it is no longer maintained. TransIP SOAP V5 API was marked as deprecated"; # added 2023-02-27
  py-tree-sitter = throw "Was merged with tree-sitter."; # added 2024-03-20
  transmissionrpc = throw "transmissionrpc has been removed because it no longer builds and is unmaintained"; # added 2024-10-12
  trezor_agent = trezor-agent; # Added 2024-01-07
  tumpa = throw "tumpa was promoted to a top-level attribute"; # added 2022-11-19
  tvdb_api = tvdb-api; # added 2023-10-20
  tvnamer = throw "tvnamer was moved to pkgs.tvnamer"; # added 2021-07-05
  twitter-common-collections = throw "twitter-common-collections has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  twitter-common-confluence = throw "twitter-common-confluence has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  twitter-common-dirutil = throw "twitter-common-dirutil has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  twitter-common-lang = throw "twitter-common-lang has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  twitter-common-log = throw "twitter-common-log has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  twitter-common-options = throw "twitter-common-options has been removed because it is abandoned and unmaintained"; # added 2024-07-14
  types-cryptography = throw "types-cryptography has been removed because it is obsolete since cryptography version 3.4.4."; # added 2022-05-30
  types-enum34 = throw "types-enum34 is obselete since Python 3.4"; # added 2025-02-15
  types-paramiko = throw "types-paramiko has been removed because it was unused."; # added 2022-05-30
  uamqp = throw "'uamqp' has been removed because it is broken and unmaintained."; # added 2025-06-11
  ufoLib2 = ufolib2; # added 2024-01-07
  ukrainealarm = throw "ukrainealarm has been removed, as it has been replaced as a home-assistant dependency by uasiren."; # added 2024-01-05
  unblob-native = throw "unblob-native has been removed because its functionality is merged into unblob 25.4.14."; # Added 2025-05-02
  unittest2 = throw "unittest2 has been removed as it's a backport of unittest that's unmaintained and not needed beyond Python 3.4."; # added 2022-12-01
  update_checker = update-checker; # added 2024-01-07
  uproot3 = throw "uproot3 has been removed, use uproot instead"; # added 2022-12-13
  uproot3-methods = throw "uproot3-methods has been removed"; # added 2022-12-13
  urwid-mitmproxy-mitmproxy = throw "urwid-mitmproxy has been removed because mitmproxy no longer uses it"; # Added 2024-07-26
  uuid = throw "uuid is a Python standard module"; # added 2024-04-18
  validictory = throw "validictory has been removed, since it abandoned"; # added 2023-07-07
  validphys2 = throw "validphys2 has been removed, since it had a broken dependency that was removed"; # added 2023-07-07
  vega_datasets = vega-datasets; # added 2023-11-04
  ViennaRNA = viennarna; # added 2023-08-23
  virtual-display = throw "virtual-display has been renamed to PyVirtualDisplay"; # added 2023-01-07
  Wand = wand; # added 2022-11-13
  wasm = throw "wasm has been removed because it no longer builds and is unmaintained"; # added 2023-05-20
  WazeRouteCalculator = wazeroutecalculator; # added 2021-09-29
  weakrefmethod = throw "weakrefmethod was removed since it's not needed in Python >= 3.4"; # added 2022-12-01
  webapp2 = throw "webapp2 is unmaintained since 2012"; # added 2022-05-29
  weboob = throw "weboob has been removed, please use woob instead"; # added 2024-07-27
  webhelpers = throw "webhelpers has been removed because it is unmaintained and upstream is gone"; # added 2024-07-27
  websocket_client = websocket-client; # added 2021-06-15
  word2vec = throw "word2vec has been removed because it is abandoned"; # added 2023-05-22
  wsnsimpy = throw "wsnsimpy has been removed, it was unmaintained and no more compatible with Python 3.12"; # added 2025-04-01
  wxPython_4_0 = throw "wxPython_4_0 has been removed, use wxpython instead"; # added 2023-03-19
  wxPython_4_1 = throw "wxPython_4_1 has been removed, use wxpython instead"; # added 2023-03-19
  wxPython_4_2 = wxpython; # added 2024-01-07
  WSME = wsme; # added 2023-02-19
  x11_hash = x11-hash; # added 2023-11-05
  xapp = python-xapp; # added 2024-07-19
  xarray-datatree = throw "Datatree has been merged upstream into pydata/xarray, and released as of xarray version 2024.10.0."; # added 2024-11-02
  xenomapper = throw "xenomapper was moved to pkgs.xenomapper"; # added 2021-12-31
  XlsxWriter = xlsxwriter; # added 2023-02-19
  yahooweather = throw "yahooweather has been removed because it is no longer maintained"; # added 2025-01-13
  xsser = "xsser has been removed because it was unmaintained and relies on a archived project"; # added 2024-07-27
  Yapsy = yapsy; # added 2023-02-19
  yanc = throw "yanc has been removed because it relies on nose"; # added 2024-07-27
  z3 = z3-solver; # added 2023-12-03
  zake = throw "zake has been removed because it is abandoned"; # added 2023-06-20
  zc_buildout_nix = throw "zc_buildout_nix was pinned to a version no longer compatible with other modules";
  zc-buildout221 = zc-buildout; # added 2021-07-21
  zc_lockfile = zc-lockfile; # added 2024-01-06
  zcs = throw "zcs was removed as it is no longer used by any packages in nixpkgs."; # added 2025-02-08
  zipstream = throw "zipstream has been removed, because it has been unmaintained for 6 years and there are no dependent packages"; # added 2024-05-26
  zipstream-new = throw "zipstream-new has been removed, because it  was packaged as a dependency for octoprint, which has switched to zipstream-ng since."; # added 2024-01-05
  zope_broken = throw "zope_broken has been removed because it is obsolete and not needed in zodb>=3.10"; # added 2023-07-26
  zope_component = zope-component; # added 2023-07-28
  zope_configuration = zope-configuration; # added 2023-11-12
  zope_contenttype = zope-contenttype; # added 2023-10-11
  zope_copy = zope-copy; # added 2024-01-06
  zope_deprecation = zope-deprecation; # added 2023-10-07
  zope_dottedname = zope-dottedname; # added 2023-11-12
  zope_event = zope-event; # added 2024-01-06
  zope_exceptions = zope-exceptions; # added 2023-10-11
  zope_filerepresentation = zope-filerepresentation; # added 2024-01-06
  zope_i18nmessageid = zope-i18nmessageid; # added 2023-07-29
  zope_interface = zope-interface; # added 2024-01-06
  zope_lifecycleevent = zope-lifecycleevent; # added 2023-10-11
  zope_location = zope-location; # added 2024-01-06
  zope_proxy = zope-proxy; # added 2023-10-07
  zope_schema = zope-schema; # added 2024-01-06
  zope_size = zope-size; # added 2024-01-06
  zope_testing = zope-testing; # added 2023-11-12
  zope_testrunner = zope-testrunner; # added 2024-01-06
  zxing_cpp = zxing-cpp; # added 2023-11-05
}
