{ lib, stdenv, rustPlatform, fetchFromGitHub, pkg-config
, openssl, libiconv, CoreServices, Security }:

rustPlatform.buildRustPackage rec {
  pname = "trunk-ng";
  version = "0.17.11";

  src = fetchFromGitHub {
    owner = "ctron";
    repo = "trunk";
    rev = "v${version}";
    hash = "sha256-ZaSWfuz0w9bkilpDv4EAt6gn6ZdKOLTYJlJMQqtZAwY=";
  };

  nativeBuildInputs = [ pkg-config ];
  buildInputs = if stdenv.isDarwin
    then [ libiconv CoreServices Security ]
    else [ openssl ];

  # requires network
  checkFlags = [ "--skip=tools::tests::download_and_install_binaries" ];

  cargoHash = "sha256-O3e8v0r76VeMYODah2RYTmwr9WNAX+HPhYVmDuP2gfg=";

  meta = with lib; {
    homepage = "https://github.com/ctron/trunk";
    description = "Build, bundle & ship your Rust WASM application to the web";
    mainProgram = "trunk-ng";
    maintainers = with maintainers; [ ctron ];
    license = with licenses; [ asl20 ];
  };
}
