
# This file was auto-generated by nix-quicklisp.lisp

{ runCommand, pkgs, lib, fetchzip, build-asdf-system, ... }:

let

 inherit (builtins) getAttr;

# Ensures that every non-slashy `system` exists in a unique .asd file.
# (Think cl-async-base being declared in cl-async.asd upstream)
#
# This is required because we're building and loading a system called
# `system`, not `asd`, so otherwise `system` would not be loadable
# without building and loading `asd` first.
#
 createAsd = { url, sha256, asd, system }:
   let
     src = fetchzip { inherit url sha256; };
   in
     if asd == system
     then src
     else runCommand "source" {} ''
       mkdir -pv $out
       cp -r ${src}/* $out
       find $out -name "${asd}.asd" | while read f; do mv -fv $f $(dirname $f)/${system}.asd || true; done
     '';
in lib.makeScope pkgs.newScope (self: {
  _1am = (build-asdf-system {
    pname = "1am";
    version = "20141106-git";
    asds = [ "1am" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/1am/2014-11-06/1am-20141106-git.tgz";
      sha256 = "05ss4nz1jb9kb796295482b62w5cj29msfj8zis33sp2rw2vmv2g";
      system = "1am";
      asd = "1am";
    });
    systems = [ "1am" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _2d-array = (build-asdf-system {
    pname = "2d-array";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "2d-array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "2d-array";
      asd = "2d-array";
    });
    systems = [ "2d-array" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _2d-array-test = (build-asdf-system {
    pname = "2d-array-test";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "2d-array-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "2d-array-test";
      asd = "2d-array-test";
    });
    systems = [ "2d-array-test" ];
    lispLibs = [ (getAttr "_2d-array" self) (getAttr "scrutiny" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3b-bmfont = (build-asdf-system {
    pname = "3b-bmfont";
    version = "20230214-git";
    asds = [ "3b-bmfont" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3b-bmfont/2023-02-14/3b-bmfont-20230214-git.tgz";
      sha256 = "11wnqa1wx9vji6cmxl5m5qnf12mqc6n7d5g8038r1wayq88bxia6";
      system = "3b-bmfont";
      asd = "3b-bmfont";
    });
    systems = [ "3b-bmfont" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "parse-number" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3b-hdr = (build-asdf-system {
    pname = "3b-hdr";
    version = "20200925-git";
    asds = [ "3b-hdr" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3b-hdr/2020-09-25/3b-hdr-20200925-git.tgz";
      sha256 = "0bvpdzz88xjwvqapjnkdr44ds3gh5xl3r6r1c2y7x9d6lnvc38jq";
      system = "3b-hdr";
      asd = "3b-hdr";
    });
    systems = [ "3b-hdr" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "parse-number" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3b-swf = (build-asdf-system {
    pname = "3b-swf";
    version = "20120107-git";
    asds = [ "3b-swf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3b-swf/2012-01-07/3b-swf-20120107-git.tgz";
      sha256 = "1d74045b6zfxjf0as8n5ji14j5cxsdi3qkqkzcdy3i83whbxkcbm";
      system = "3b-swf";
      asd = "3b-swf";
    });
    systems = [ "3b-swf" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "chipz" self) (getAttr "cl-jpeg" self) (getAttr "cxml" self) (getAttr "flexi-streams" self) (getAttr "ieee-floats" self) (getAttr "salza2" self) (getAttr "vecto" self) (getAttr "zpng" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3b-swf-swc = (build-asdf-system {
    pname = "3b-swf-swc";
    version = "20120107-git";
    asds = [ "3b-swf-swc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3b-swf/2012-01-07/3b-swf-20120107-git.tgz";
      sha256 = "1d74045b6zfxjf0as8n5ji14j5cxsdi3qkqkzcdy3i83whbxkcbm";
      system = "3b-swf-swc";
      asd = "3b-swf-swc";
    });
    systems = [ "3b-swf-swc" ];
    lispLibs = [ (getAttr "_3b-swf" self) (getAttr "cxml" self) (getAttr "zip" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bgl-shader = (build-asdf-system {
    pname = "3bgl-shader";
    version = "20200427-git";
    asds = [ "3bgl-shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bgl-shader/2020-04-27/3bgl-shader-20200427-git.tgz";
      sha256 = "0ykfylmmpcc1kh617c4zbq26r5nf1kgf7cb426fnffhp31pp2xkw";
      system = "3bgl-shader";
      asd = "3bgl-shader";
    });
    systems = [ "3bgl-shader" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bgl-shader-example = (build-asdf-system {
    pname = "3bgl-shader-example";
    version = "20200427-git";
    asds = [ "3bgl-shader-example" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bgl-shader/2020-04-27/3bgl-shader-20200427-git.tgz";
      sha256 = "0ykfylmmpcc1kh617c4zbq26r5nf1kgf7cb426fnffhp31pp2xkw";
      system = "3bgl-shader-example";
      asd = "3bgl-shader-example";
    });
    systems = [ "3bgl-shader-example" ];
    lispLibs = [ (getAttr "_3bgl-shader" self) (getAttr "cl-glu" self) (getAttr "cl-glut" self) (getAttr "mathkit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd = (build-asdf-system {
    pname = "3bmd";
    version = "20230618-git";
    asds = [ "3bmd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd";
      asd = "3bmd";
    });
    systems = [ "3bmd" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "esrap" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-ext-code-blocks = (build-asdf-system {
    pname = "3bmd-ext-code-blocks";
    version = "20230618-git";
    asds = [ "3bmd-ext-code-blocks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-ext-code-blocks";
      asd = "3bmd-ext-code-blocks";
    });
    systems = [ "3bmd-ext-code-blocks" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "alexandria" self) (getAttr "colorize" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-ext-definition-lists = (build-asdf-system {
    pname = "3bmd-ext-definition-lists";
    version = "20230618-git";
    asds = [ "3bmd-ext-definition-lists" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-ext-definition-lists";
      asd = "3bmd-ext-definition-lists";
    });
    systems = [ "3bmd-ext-definition-lists" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "alexandria" self) (getAttr "colorize" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-ext-math = (build-asdf-system {
    pname = "3bmd-ext-math";
    version = "20230618-git";
    asds = [ "3bmd-ext-math" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-ext-math";
      asd = "3bmd-ext-math";
    });
    systems = [ "3bmd-ext-math" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "esrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-ext-tables = (build-asdf-system {
    pname = "3bmd-ext-tables";
    version = "20230618-git";
    asds = [ "3bmd-ext-tables" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-ext-tables";
      asd = "3bmd-ext-tables";
    });
    systems = [ "3bmd-ext-tables" ];
    lispLibs = [ (getAttr "_3bmd" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-ext-wiki-links = (build-asdf-system {
    pname = "3bmd-ext-wiki-links";
    version = "20230618-git";
    asds = [ "3bmd-ext-wiki-links" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-ext-wiki-links";
      asd = "3bmd-ext-wiki-links";
    });
    systems = [ "3bmd-ext-wiki-links" ];
    lispLibs = [ (getAttr "_3bmd" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-tests = (build-asdf-system {
    pname = "3bmd-tests";
    version = "20230618-git";
    asds = [ "3bmd-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-tests";
      asd = "3bmd-tests";
    });
    systems = [ "3bmd-tests" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "_3bmd-ext-code-blocks" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-youtube = (build-asdf-system {
    pname = "3bmd-youtube";
    version = "20230618-git";
    asds = [ "3bmd-youtube" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-youtube";
      asd = "3bmd-youtube";
    });
    systems = [ "3bmd-youtube" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "esrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bmd-youtube-tests = (build-asdf-system {
    pname = "3bmd-youtube-tests";
    version = "20230618-git";
    asds = [ "3bmd-youtube-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bmd/2023-06-18/3bmd-20230618-git.tgz";
      sha256 = "1b5ssbahk7a257fllh0c6vfxzjrcmybav1hhcciarv69mpdhm2mj";
      system = "3bmd-youtube-tests";
      asd = "3bmd-youtube-tests";
    });
    systems = [ "3bmd-youtube-tests" ];
    lispLibs = [ (getAttr "_3bmd-youtube" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3bz = (build-asdf-system {
    pname = "3bz";
    version = "20230618-git";
    asds = [ "3bz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3bz/2023-06-18/3bz-20230618-git.tgz";
      sha256 = "0qdnxj2sn185l0jnp4zjlh5la14pxkgp1hmcyw4d2zwx30sc37p7";
      system = "3bz";
      asd = "3bz";
    });
    systems = [ "3bz" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cffi" self) (getAttr "mmap" self) (getAttr "nibbles" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-matrices = (build-asdf-system {
    pname = "3d-matrices";
    version = "20230618-git";
    asds = [ "3d-matrices" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-matrices/2023-06-18/3d-matrices-20230618-git.tgz";
      sha256 = "1sj7kpn1fnh6dp67x8cdb6p59raacvr3zc4jfp7kw3ffdwd8hq4y";
      system = "3d-matrices";
      asd = "3d-matrices";
    });
    systems = [ "3d-matrices" ];
    lispLibs = [ (getAttr "_3d-vectors" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-matrices-test = (build-asdf-system {
    pname = "3d-matrices-test";
    version = "20230618-git";
    asds = [ "3d-matrices-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-matrices/2023-06-18/3d-matrices-20230618-git.tgz";
      sha256 = "1sj7kpn1fnh6dp67x8cdb6p59raacvr3zc4jfp7kw3ffdwd8hq4y";
      system = "3d-matrices-test";
      asd = "3d-matrices-test";
    });
    systems = [ "3d-matrices-test" ];
    lispLibs = [ (getAttr "_3d-matrices" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-quaternions = (build-asdf-system {
    pname = "3d-quaternions";
    version = "20230618-git";
    asds = [ "3d-quaternions" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-quaternions/2023-06-18/3d-quaternions-20230618-git.tgz";
      sha256 = "16gzg5av8jx1bkbbvyqmxha9r1k4dfd4y2dkv6q0c66wrglyd46r";
      system = "3d-quaternions";
      asd = "3d-quaternions";
    });
    systems = [ "3d-quaternions" ];
    lispLibs = [ (getAttr "_3d-matrices" self) (getAttr "_3d-vectors" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-quaternions-test = (build-asdf-system {
    pname = "3d-quaternions-test";
    version = "20230618-git";
    asds = [ "3d-quaternions-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-quaternions/2023-06-18/3d-quaternions-20230618-git.tgz";
      sha256 = "16gzg5av8jx1bkbbvyqmxha9r1k4dfd4y2dkv6q0c66wrglyd46r";
      system = "3d-quaternions-test";
      asd = "3d-quaternions-test";
    });
    systems = [ "3d-quaternions-test" ];
    lispLibs = [ (getAttr "_3d-quaternions" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-spaces = (build-asdf-system {
    pname = "3d-spaces";
    version = "20230618-git";
    asds = [ "3d-spaces" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-spaces/2023-06-18/3d-spaces-20230618-git.tgz";
      sha256 = "1igi54c3n6jfqw893pv0py61vmqyslws67xh4wgvj2xfifwv6x0s";
      system = "3d-spaces";
      asd = "3d-spaces";
    });
    systems = [ "3d-spaces" ];
    lispLibs = [ (getAttr "_3d-matrices" self) (getAttr "_3d-vectors" self) (getAttr "documentation-utils" self) (getAttr "for" self) (getAttr "trivial-extensible-sequences" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-spaces-test = (build-asdf-system {
    pname = "3d-spaces-test";
    version = "20230618-git";
    asds = [ "3d-spaces-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-spaces/2023-06-18/3d-spaces-20230618-git.tgz";
      sha256 = "1igi54c3n6jfqw893pv0py61vmqyslws67xh4wgvj2xfifwv6x0s";
      system = "3d-spaces-test";
      asd = "3d-spaces-test";
    });
    systems = [ "3d-spaces-test" ];
    lispLibs = [ (getAttr "_3d-spaces" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-transforms = (build-asdf-system {
    pname = "3d-transforms";
    version = "20230618-git";
    asds = [ "3d-transforms" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-transforms/2023-06-18/3d-transforms-20230618-git.tgz";
      sha256 = "0p6nh77f1r24pv1mqsan20ji69pd0kxx9cqllhvgba9i59p9mgqv";
      system = "3d-transforms";
      asd = "3d-transforms";
    });
    systems = [ "3d-transforms" ];
    lispLibs = [ (getAttr "_3d-matrices" self) (getAttr "_3d-quaternions" self) (getAttr "_3d-vectors" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-transforms-test = (build-asdf-system {
    pname = "3d-transforms-test";
    version = "20230618-git";
    asds = [ "3d-transforms-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-transforms/2023-06-18/3d-transforms-20230618-git.tgz";
      sha256 = "0p6nh77f1r24pv1mqsan20ji69pd0kxx9cqllhvgba9i59p9mgqv";
      system = "3d-transforms-test";
      asd = "3d-transforms-test";
    });
    systems = [ "3d-transforms-test" ];
    lispLibs = [ (getAttr "_3d-transforms" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-vectors = (build-asdf-system {
    pname = "3d-vectors";
    version = "20230618-git";
    asds = [ "3d-vectors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-vectors/2023-06-18/3d-vectors-20230618-git.tgz";
      sha256 = "029rv4ip17in1w5piivk78z05z9c6r22hn9ax3badbgl1j9v51yn";
      system = "3d-vectors";
      asd = "3d-vectors";
    });
    systems = [ "3d-vectors" ];
    lispLibs = [ (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _3d-vectors-test = (build-asdf-system {
    pname = "3d-vectors-test";
    version = "20230618-git";
    asds = [ "3d-vectors-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/3d-vectors/2023-06-18/3d-vectors-20230618-git.tgz";
      sha256 = "029rv4ip17in1w5piivk78z05z9c6r22hn9ax3badbgl1j9v51yn";
      system = "3d-vectors-test";
      asd = "3d-vectors-test";
    });
    systems = [ "3d-vectors-test" ];
    lispLibs = [ (getAttr "_3d-vectors" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-asdf-system = (build-asdf-system {
    pname = "40ants-asdf-system";
    version = "20230214-git";
    asds = [ "40ants-asdf-system" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/40ants-asdf-system/2023-02-14/40ants-asdf-system-20230214-git.tgz";
      sha256 = "02r6frx4xcv7qfkmdks1zpv0b3qamywdcwd6zvznfcnmfa8jbfmy";
      system = "40ants-asdf-system";
      asd = "40ants-asdf-system";
    });
    systems = [ "40ants-asdf-system" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-asdf-system-tests = (build-asdf-system {
    pname = "40ants-asdf-system-tests";
    version = "20230214-git";
    asds = [ "40ants-asdf-system-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/40ants-asdf-system/2023-02-14/40ants-asdf-system-20230214-git.tgz";
      sha256 = "02r6frx4xcv7qfkmdks1zpv0b3qamywdcwd6zvznfcnmfa8jbfmy";
      system = "40ants-asdf-system-tests";
      asd = "40ants-asdf-system-tests";
    });
    systems = [ "40ants-asdf-system-tests" ];
    lispLibs = [ (getAttr "_40ants-asdf-system" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-ci = (build-asdf-system {
    pname = "40ants-ci";
    version = "20230618-git";
    asds = [ "40ants-ci" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ci/2023-06-18/ci-20230618-git.tgz";
      sha256 = "0i4glf28nn2nwxb64irv6wja7rdadh8378fdhl4lsvmqn5whi5sv";
      system = "40ants-ci";
      asd = "40ants-ci";
    });
    systems = [ "40ants-ci" ];
    lispLibs = [ (getAttr "_40ants-asdf-system" self) (getAttr "_40ants-doc" self) (getAttr "alexandria" self) (getAttr "docs-config" self) (getAttr "str" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-ci-tests = (build-asdf-system {
    pname = "40ants-ci-tests";
    version = "20230618-git";
    asds = [ "40ants-ci-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ci/2023-06-18/ci-20230618-git.tgz";
      sha256 = "0i4glf28nn2nwxb64irv6wja7rdadh8378fdhl4lsvmqn5whi5sv";
      system = "40ants-ci-tests";
      asd = "40ants-ci-tests";
    });
    systems = [ "40ants-ci-tests" ];
    lispLibs = [ (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-doc = (build-asdf-system {
    pname = "40ants-doc";
    version = "20230618-git";
    asds = [ "40ants-doc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/doc/2023-06-18/doc-20230618-git.tgz";
      sha256 = "0s8ji6gwrq3yz9n7k2hb5q14ab37i3f8pm5cg5h29bpxwvdmv0fx";
      system = "40ants-doc";
      asd = "40ants-doc";
    });
    systems = [ "40ants-doc" ];
    lispLibs = [ (getAttr "named-readtables" self) (getAttr "pythonic-string-reader" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-doc-full = (build-asdf-system {
    pname = "40ants-doc-full";
    version = "20230618-git";
    asds = [ "40ants-doc-full" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/doc/2023-06-18/doc-20230618-git.tgz";
      sha256 = "0s8ji6gwrq3yz9n7k2hb5q14ab37i3f8pm5cg5h29bpxwvdmv0fx";
      system = "40ants-doc-full";
      asd = "40ants-doc-full";
    });
    systems = [ "40ants-doc-full" ];
    lispLibs = [ (getAttr "_40ants-doc" self) (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-cookie" self) (getAttr "cl-fad" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "common-doc" self) (getAttr "common-html" self) (getAttr "commondoc-markdown" self) (getAttr "dexador" self) (getAttr "docs-config" self) (getAttr "fare-utils" self) (getAttr "jonathan" self) (getAttr "lass" self) (getAttr "local-time" self) (getAttr "log4cl" self) (getAttr "named-readtables" self) (getAttr "pythonic-string-reader" self) (getAttr "slynk" self) (getAttr "spinneret" self) (getAttr "stem" self) (getAttr "str" self) (getAttr "swank" self) (getAttr "tmpdir" self) (getAttr "trivial-extract" self) (getAttr "xml-emitter" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-doc-test = (build-asdf-system {
    pname = "40ants-doc-test";
    version = "20230618-git";
    asds = [ "40ants-doc-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/doc/2023-06-18/doc-20230618-git.tgz";
      sha256 = "0s8ji6gwrq3yz9n7k2hb5q14ab37i3f8pm5cg5h29bpxwvdmv0fx";
      system = "40ants-doc-test";
      asd = "40ants-doc-test";
    });
    systems = [ "40ants-doc-test" ];
    lispLibs = [ (getAttr "_40ants-doc" self) (getAttr "alexandria" self) (getAttr "common-doc" self) (getAttr "common-html" self) (getAttr "commondoc-markdown" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-logging = (build-asdf-system {
    pname = "40ants-logging";
    version = "20230618-git";
    asds = [ "40ants-logging" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/logging/2023-06-18/logging-20230618-git.tgz";
      sha256 = "1hd0cfqpxvvp0p3rs8q8mnf0h5dapiw3f5z22nyn6xybngdqgp8z";
      system = "40ants-logging";
      asd = "40ants-logging";
    });
    systems = [ "40ants-logging" ];
    lispLibs = [ (getAttr "_40ants-asdf-system" self) (getAttr "global-vars" self) (getAttr "log4cl-extras" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-logging-ci = (build-asdf-system {
    pname = "40ants-logging-ci";
    version = "20230618-git";
    asds = [ "40ants-logging-ci" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/logging/2023-06-18/logging-20230618-git.tgz";
      sha256 = "1hd0cfqpxvvp0p3rs8q8mnf0h5dapiw3f5z22nyn6xybngdqgp8z";
      system = "40ants-logging-ci";
      asd = "40ants-logging-ci";
    });
    systems = [ "40ants-logging-ci" ];
    lispLibs = [ (getAttr "_40ants-ci" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-logging-docs = (build-asdf-system {
    pname = "40ants-logging-docs";
    version = "20230618-git";
    asds = [ "40ants-logging-docs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/logging/2023-06-18/logging-20230618-git.tgz";
      sha256 = "1hd0cfqpxvvp0p3rs8q8mnf0h5dapiw3f5z22nyn6xybngdqgp8z";
      system = "40ants-logging-docs";
      asd = "40ants-logging-docs";
    });
    systems = [ "40ants-logging-docs" ];
    lispLibs = [ (getAttr "_40ants-doc" self) (getAttr "_40ants-logging" self) (getAttr "docs-config" self) (getAttr "named-readtables" self) (getAttr "pythonic-string-reader" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-logging-tests = (build-asdf-system {
    pname = "40ants-logging-tests";
    version = "20230618-git";
    asds = [ "40ants-logging-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/logging/2023-06-18/logging-20230618-git.tgz";
      sha256 = "1hd0cfqpxvvp0p3rs8q8mnf0h5dapiw3f5z22nyn6xybngdqgp8z";
      system = "40ants-logging-tests";
      asd = "40ants-logging-tests";
    });
    systems = [ "40ants-logging-tests" ];
    lispLibs = [ (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-slynk = (build-asdf-system {
    pname = "40ants-slynk";
    version = "20230618-git";
    asds = [ "40ants-slynk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/40ants-slynk/2023-06-18/40ants-slynk-20230618-git.tgz";
      sha256 = "00sm5l0mqxw7c5gvgsc4fhpnnx8zx31pysyfsrf68dba8rfjd88k";
      system = "40ants-slynk";
      asd = "40ants-slynk";
    });
    systems = [ "40ants-slynk" ];
    lispLibs = [ (getAttr "_40ants-asdf-system" self) (getAttr "_40ants-logging" self) (getAttr "global-vars" self) (getAttr "log4cl" self) (getAttr "slynk" self) (getAttr "slynk-macrostep" self) (getAttr "slynk-named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-slynk-ci = (build-asdf-system {
    pname = "40ants-slynk-ci";
    version = "20230618-git";
    asds = [ "40ants-slynk-ci" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/40ants-slynk/2023-06-18/40ants-slynk-20230618-git.tgz";
      sha256 = "00sm5l0mqxw7c5gvgsc4fhpnnx8zx31pysyfsrf68dba8rfjd88k";
      system = "40ants-slynk-ci";
      asd = "40ants-slynk-ci";
    });
    systems = [ "40ants-slynk-ci" ];
    lispLibs = [ (getAttr "_40ants-ci" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  _40ants-slynk-tests = (build-asdf-system {
    pname = "40ants-slynk-tests";
    version = "20230618-git";
    asds = [ "40ants-slynk-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/40ants-slynk/2023-06-18/40ants-slynk-20230618-git.tgz";
      sha256 = "00sm5l0mqxw7c5gvgsc4fhpnnx8zx31pysyfsrf68dba8rfjd88k";
      system = "40ants-slynk-tests";
      asd = "40ants-slynk-tests";
    });
    systems = [ "40ants-slynk-tests" ];
    lispLibs = [ (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  a-cl-cairo2-loader = (build-asdf-system {
    pname = "a-cl-cairo2-loader";
    version = "20211020-git";
    asds = [ "a-cl-cairo2-loader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cairo2/2021-10-20/cl-cairo2-20211020-git.tgz";
      sha256 = "0cpfgyxw6pz7y033dlya8c4vjmkpw127zdq3a9xclp9q8jbdlb7q";
      system = "a-cl-cairo2-loader";
      asd = "a-cl-cairo2-loader";
    });
    systems = [ "a-cl-cairo2-loader" ];
    lispLibs = [ (getAttr "cl-cairo2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  a-cl-logger = (build-asdf-system {
    pname = "a-cl-logger";
    version = "20220331-git";
    asds = [ "a-cl-logger" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/a-cl-logger/2022-03-31/a-cl-logger-20220331-git.tgz";
      sha256 = "0vhhbnh4akxh0ivqh8r0f2djv2nbf3l9hbbi0b5fdk9bdpziqkb4";
      system = "a-cl-logger";
      asd = "a-cl-logger";
    });
    systems = [ "a-cl-logger" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "cl-json" self) (getAttr "closer-mop" self) (getAttr "exit-hooks" self) (getAttr "iterate" self) (getAttr "local-time" self) (getAttr "osicat" self) (getAttr "symbol-munger" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  a-cl-logger-logstash = (build-asdf-system {
    pname = "a-cl-logger-logstash";
    version = "20220331-git";
    asds = [ "a-cl-logger-logstash" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/a-cl-logger/2022-03-31/a-cl-logger-20220331-git.tgz";
      sha256 = "0vhhbnh4akxh0ivqh8r0f2djv2nbf3l9hbbi0b5fdk9bdpziqkb4";
      system = "a-cl-logger-logstash";
      asd = "a-cl-logger-logstash";
    });
    systems = [ "a-cl-logger-logstash" ];
    lispLibs = [ (getAttr "a-cl-logger" self) (getAttr "cl-json" self) (getAttr "zmq" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  a-cl-logger-tests = (build-asdf-system {
    pname = "a-cl-logger-tests";
    version = "20220331-git";
    asds = [ "a-cl-logger-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/a-cl-logger/2022-03-31/a-cl-logger-20220331-git.tgz";
      sha256 = "0vhhbnh4akxh0ivqh8r0f2djv2nbf3l9hbbi0b5fdk9bdpziqkb4";
      system = "a-cl-logger-tests";
      asd = "a-cl-logger";
    });
    systems = [ "a-cl-logger-tests" ];
    lispLibs = [ (getAttr "a-cl-logger" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aabbcc = (build-asdf-system {
    pname = "aabbcc";
    version = "20200427-git";
    asds = [ "aabbcc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/sucle/2020-04-27/sucle-20200427-git.tgz";
      sha256 = "033akkn9zxc6qdgycgxgybx3v23638245xrx29x2cbwnvg3i1q34";
      system = "aabbcc";
      asd = "aabbcc";
    });
    systems = [ "aabbcc" ];
    lispLibs = [ (getAttr "quads" self) (getAttr "utility" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  able = (build-asdf-system {
    pname = "able";
    version = "20171227-git";
    asds = [ "able" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/able/2017-12-27/able-20171227-git.tgz";
      sha256 = "1fbcmr6hy7bwlnsnrml3j4b2jkkj8ddxw27l8hr2z6l3fi3qw4hh";
      system = "able";
      asd = "able";
    });
    systems = [ "able" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "ltk" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  abnf = (build-asdf-system {
    pname = "abnf";
    version = "20200325-git";
    asds = [ "abnf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-abnf/2020-03-25/cl-abnf-20200325-git.tgz";
      sha256 = "0f09nsndxa90acm71zd4qdnp40v705a4sqm04mnv9x76h6dlggmz";
      system = "abnf";
      asd = "abnf";
    });
    systems = [ "abnf" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "esrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  abstract-arrays = (build-asdf-system {
    pname = "abstract-arrays";
    version = "20230618-git";
    asds = [ "abstract-arrays" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/abstract-arrays/2023-06-18/abstract-arrays-20230618-git.tgz";
      sha256 = "13vxmq916jxjnvqmzjibyysvq15jdcdbb1hag21z1cik473a3bq4";
      system = "abstract-arrays";
      asd = "abstract-arrays";
    });
    systems = [ "abstract-arrays" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "extensible-compound-types" self) (getAttr "introspect-environment" self) (getAttr "polymorphic-functions" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  abstract-classes = (build-asdf-system {
    pname = "abstract-classes";
    version = "20190307-hg";
    asds = [ "abstract-classes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-abstract-classes/2019-03-07/cl-abstract-classes-20190307-hg.tgz";
      sha256 = "0q03j3ksgn56j9xvs3d3hhasplj3hvg488f4cx1z97nlyqxr5w1d";
      system = "abstract-classes";
      asd = "abstract-classes";
    });
    systems = [ "abstract-classes" ];
    lispLibs = [ (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  access = (build-asdf-system {
    pname = "access";
    version = "20220707-git";
    asds = [ "access" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/access/2022-07-07/access-20220707-git.tgz";
      sha256 = "0jgq4xz4pmi7wrgiqvvpkl9k89dhnhsaac68x6mw0w2v7h31vzph";
      system = "access";
      asd = "access";
    });
    systems = [ "access" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "iterate" self) ];
    meta = {};
  });
  acclimation = (build-asdf-system {
    pname = "acclimation";
    version = "20230618-git";
    asds = [ "acclimation" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/acclimation/2023-06-18/acclimation-20230618-git.tgz";
      sha256 = "028nakav74h9b1q45gsd5xp8m9068ssc3abgl6b3q7y2bfy9p78a";
      system = "acclimation";
      asd = "acclimation";
    });
    systems = [ "acclimation" ];
    lispLibs = [  ];
    meta = {};
  });
  acclimation-temperature = (build-asdf-system {
    pname = "acclimation-temperature";
    version = "20230618-git";
    asds = [ "acclimation-temperature" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/acclimation/2023-06-18/acclimation-20230618-git.tgz";
      sha256 = "028nakav74h9b1q45gsd5xp8m9068ssc3abgl6b3q7y2bfy9p78a";
      system = "acclimation-temperature";
      asd = "acclimation-temperature";
    });
    systems = [ "acclimation-temperature" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  acl-compat = (build-asdf-system {
    pname = "acl-compat";
    version = "20190813-git";
    asds = [ "acl-compat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/portableaserve/2019-08-13/portableaserve-20190813-git.tgz";
      sha256 = "0ak6mqp84sjr0a7h5svr16vra4bf4fcx6wpir0n88dc1vjwy5xqa";
      system = "acl-compat";
      asd = "acl-compat";
    });
    systems = [ "acl-compat" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "cl-ppcre" self) (getAttr "ironclad" self) (getAttr "puri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  acm-random = (build-asdf-system {
    pname = "acm-random";
    version = "20191007-git";
    asds = [ "acm-random" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/random/2019-10-07/random-20191007-git.tgz";
      sha256 = "1fb4mnp85jm9s667y4dgz07klhkr9pvi5xbxws28lbb8iip75y2p";
      system = "acm-random";
      asd = "acm-random";
    });
    systems = [ "acm-random" ];
    lispLibs = [ (getAttr "com_dot_google_dot_base" self) (getAttr "random" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  acm-random-test = (build-asdf-system {
    pname = "acm-random-test";
    version = "20191007-git";
    asds = [ "acm-random-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/random/2019-10-07/random-20191007-git.tgz";
      sha256 = "1fb4mnp85jm9s667y4dgz07klhkr9pvi5xbxws28lbb8iip75y2p";
      system = "acm-random-test";
      asd = "acm-random-test";
    });
    systems = [ "acm-random-test" ];
    lispLibs = [ (getAttr "acm-random" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  action-list = (build-asdf-system {
    pname = "action-list";
    version = "20221106-git";
    asds = [ "action-list" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/action-list/2022-11-06/action-list-20221106-git.tgz";
      sha256 = "0w42wsk077lcv9hw62s8303fj4rpmrrx1xwsv1jachzd9alwnfcl";
      system = "action-list";
      asd = "action-list";
    });
    systems = [ "action-list" ];
    lispLibs = [ (getAttr "documentation-utils" self) (getAttr "trivial-extensible-sequences" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adhoc = (build-asdf-system {
    pname = "adhoc";
    version = "20230618-git";
    asds = [ "adhoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adhoc/2023-06-18/adhoc-20230618-git.tgz";
      sha256 = "0ygxfzp10nzn2v599617frlz40lzrcdv2snwgmvm418v7wcamh1y";
      system = "adhoc";
      asd = "adhoc";
    });
    systems = [ "adhoc" ];
    lispLibs = [ (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adhoc-tests = (build-asdf-system {
    pname = "adhoc-tests";
    version = "20230618-git";
    asds = [ "adhoc-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adhoc/2023-06-18/adhoc-20230618-git.tgz";
      sha256 = "0ygxfzp10nzn2v599617frlz40lzrcdv2snwgmvm418v7wcamh1y";
      system = "adhoc-tests";
      asd = "adhoc-tests";
    });
    systems = [ "adhoc-tests" ];
    lispLibs = [ (getAttr "adhoc" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adjuvant = (build-asdf-system {
    pname = "adjuvant";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "adjuvant" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "adjuvant";
      asd = "adjuvant";
    });
    systems = [ "adjuvant" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adjuvant-test = (build-asdf-system {
    pname = "adjuvant-test";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "adjuvant-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "adjuvant-test";
      asd = "adjuvant-test";
    });
    systems = [ "adjuvant-test" ];
    lispLibs = [ (getAttr "adjuvant" self) (getAttr "scrutiny" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adopt = (build-asdf-system {
    pname = "adopt";
    version = "20220331-hg";
    asds = [ "adopt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adopt/2022-03-31/adopt-20220331-hg.tgz";
      sha256 = "0lfg12crl68nz0avdyx4j0x0p8vrysr2bl1817iaaa48jp6qp588";
      system = "adopt";
      asd = "adopt";
    });
    systems = [ "adopt" ];
    lispLibs = [ (getAttr "bobbin" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adopt-subcommands = (build-asdf-system {
    pname = "adopt-subcommands";
    version = "v0.2.2";
    asds = [ "adopt-subcommands" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adopt-subcommands/2021-05-31/adopt-subcommands-v0.2.2.tgz";
      sha256 = "0q35s3ihhlshakjalq5pgf14x502qnj8jimim8yf7bp1p9sn83h8";
      system = "adopt-subcommands";
      asd = "adopt-subcommands";
    });
    systems = [ "adopt-subcommands" ];
    lispLibs = [ (getAttr "adopt" self) (getAttr "bobbin" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adopt-subcommands-test = (build-asdf-system {
    pname = "adopt-subcommands-test";
    version = "v0.2.2";
    asds = [ "adopt-subcommands-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adopt-subcommands/2021-05-31/adopt-subcommands-v0.2.2.tgz";
      sha256 = "0q35s3ihhlshakjalq5pgf14x502qnj8jimim8yf7bp1p9sn83h8";
      system = "adopt-subcommands-test";
      asd = "adopt-subcommands-test";
    });
    systems = [ "adopt-subcommands-test" ];
    lispLibs = [ (getAttr "adopt-subcommands" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  adp = (build-asdf-system {
    pname = "adp";
    version = "20230214-git";
    asds = [ "adp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/adp/2023-02-14/adp-20230214-git.tgz";
      sha256 = "1k525gf2q9iyiv8fmk9lgzqz21k164s1asxcdsjxfdlmz6al0svx";
      system = "adp";
      asd = "adp";
    });
    systems = [ "adp" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "hyperspec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  advanced = (build-asdf-system {
    pname = "advanced";
    version = "version-1.0b26";
    asds = [ "advanced" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-clon/2023-06-18/cl-clon-version-1.0b26.tgz";
      sha256 = "1vg2r788vh86i2cnc4yy9w05y5rv6rk0ybxb91wqzjykn0wc4kx3";
      system = "advanced";
      asd = "advanced";
    });
    systems = [ "advanced" ];
    lispLibs = [ (getAttr "net_dot_didierverna_dot_clon" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  advanced-readtable = (build-asdf-system {
    pname = "advanced-readtable";
    version = "20130720-git";
    asds = [ "advanced-readtable" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/advanced-readtable/2013-07-20/advanced-readtable-20130720-git.tgz";
      sha256 = "0dgm3lp9s6792g22swcb085f67q68jsyqj71vicb1wdr9qslvgwm";
      system = "advanced-readtable";
      asd = "advanced-readtable";
    });
    systems = [ "advanced-readtable" ];
    lispLibs = [ (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aether = (build-asdf-system {
    pname = "aether";
    version = "v1.1.0";
    asds = [ "aether" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aether/2021-12-09/aether-v1.1.0.tgz";
      sha256 = "0q60gc4lsxpvv4g572mnhpzkziq1412k1q0xm4y2d1zigryg30bb";
      system = "aether";
      asd = "aether";
    });
    systems = [ "aether" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-heap" self) (getAttr "global-vars" self) (getAttr "policy-cond" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aether-tests = (build-asdf-system {
    pname = "aether-tests";
    version = "v1.1.0";
    asds = [ "aether-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aether/2021-12-09/aether-v1.1.0.tgz";
      sha256 = "0q60gc4lsxpvv4g572mnhpzkziq1412k1q0xm4y2d1zigryg30bb";
      system = "aether-tests";
      asd = "aether-tests";
    });
    systems = [ "aether-tests" ];
    lispLibs = [ (getAttr "aether" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  agnostic-lizard = (build-asdf-system {
    pname = "agnostic-lizard";
    version = "20221106-git";
    asds = [ "agnostic-lizard" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/agnostic-lizard/2022-11-06/agnostic-lizard-20221106-git.tgz";
      sha256 = "13r1pzxkhci0pd8grhvim09lgvaykjyspnj58xq1rp1c017xnpmf";
      system = "agnostic-lizard";
      asd = "agnostic-lizard";
    });
    systems = [ "agnostic-lizard" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  agnostic-lizard-debugger-prototype = (build-asdf-system {
    pname = "agnostic-lizard-debugger-prototype";
    version = "20221106-git";
    asds = [ "agnostic-lizard-debugger-prototype" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/agnostic-lizard/2022-11-06/agnostic-lizard-20221106-git.tgz";
      sha256 = "13r1pzxkhci0pd8grhvim09lgvaykjyspnj58xq1rp1c017xnpmf";
      system = "agnostic-lizard-debugger-prototype";
      asd = "agnostic-lizard-debugger-prototype";
    });
    systems = [ "agnostic-lizard-debugger-prototype" ];
    lispLibs = [ (getAttr "agnostic-lizard" self) (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  agutil = (build-asdf-system {
    pname = "agutil";
    version = "20210531-git";
    asds = [ "agutil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/agutil/2021-05-31/agutil-20210531-git.tgz";
      sha256 = "10lccrqkaqq0h1p79gjqsqk1nqa6c25n0w7pj39y2gs14s5qr5q9";
      system = "agutil";
      asd = "agutil";
    });
    systems = [ "agutil" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "optima" self) ];
    meta = {};
  });
  ahungry-fleece = (build-asdf-system {
    pname = "ahungry-fleece";
    version = "20230214-git";
    asds = [ "ahungry-fleece" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ahungry-fleece/2023-02-14/ahungry-fleece-20230214-git.tgz";
      sha256 = "1q0bd4fhfypfdvv338gf0gbc8fh65m0p662ik7c9rraijgddi9ry";
      system = "ahungry-fleece";
      asd = "ahungry-fleece";
    });
    systems = [ "ahungry-fleece" ];
    lispLibs = [ (getAttr "archive" self) (getAttr "chipz" self) (getAttr "cl-json" self) (getAttr "cl-yaml" self) (getAttr "md5" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  alexa = (build-asdf-system {
    pname = "alexa";
    version = "20180831-git";
    asds = [ "alexa" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/alexa/2018-08-31/alexa-20180831-git.tgz";
      sha256 = "1y9jyz9gfmd02h492kf7v3mmpbhc0yfh4ka2rzd1vczq6fl8qgqv";
      system = "alexa";
      asd = "alexa";
    });
    systems = [ "alexa" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  alexa-tests = (build-asdf-system {
    pname = "alexa-tests";
    version = "20180831-git";
    asds = [ "alexa-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/alexa/2018-08-31/alexa-20180831-git.tgz";
      sha256 = "1y9jyz9gfmd02h492kf7v3mmpbhc0yfh4ka2rzd1vczq6fl8qgqv";
      system = "alexa-tests";
      asd = "alexa-tests";
    });
    systems = [ "alexa-tests" ];
    lispLibs = [ (getAttr "alexa" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  alexandria = (build-asdf-system {
    pname = "alexandria";
    version = "20230618-git";
    asds = [ "alexandria" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/alexandria/2023-06-18/alexandria-20230618-git.tgz";
      sha256 = "077zrkb3gjgzfn515hahak30ppnql848f4sgiard9xfmh8b4bdmn";
      system = "alexandria";
      asd = "alexandria";
    });
    systems = [ "alexandria" ];
    lispLibs = [  ];
    meta = {};
  });
  alexandria_plus = (build-asdf-system {
    pname = "alexandria+";
    version = "20221106-git";
    asds = [ "alexandria+" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/alexandria-plus/2022-11-06/alexandria-plus-20221106-git.tgz";
      sha256 = "1w9r19610h599303gqlx2x5n8mmdynss2gyl7xilg5h6v8z3hkfl";
      system = "alexandria+";
      asd = "alexandria+";
    });
    systems = [ "alexandria+" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  algebraic-data-library = (build-asdf-system {
    pname = "algebraic-data-library";
    version = "20180831-git";
    asds = [ "algebraic-data-library" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/algebraic-data-library/2018-08-31/algebraic-data-library-20180831-git.tgz";
      sha256 = "0mmakfdwgfjl812ydzbbl81lkv41zfnqhw9ydjk1w63lq8c11cmn";
      system = "algebraic-data-library";
      asd = "algebraic-data-library";
    });
    systems = [ "algebraic-data-library" ];
    lispLibs = [ (getAttr "cl-algebraic-data-type" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  also-alsa = (build-asdf-system {
    pname = "also-alsa";
    version = "20220707-git";
    asds = [ "also-alsa" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/also-alsa/2022-07-07/also-alsa-20220707-git.tgz";
      sha256 = "1az5agb5gmjjsp3sbpqnw20k46yss1d7d5xymy2mi1al5ksxyqmc";
      system = "also-alsa";
      asd = "also-alsa";
    });
    systems = [ "also-alsa" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  amazon-ecs = (build-asdf-system {
    pname = "amazon-ecs";
    version = "20110418-git";
    asds = [ "amazon-ecs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/amazon-ecs/2011-04-18/amazon-ecs-20110418-git.tgz";
      sha256 = "1gi3ybfkdfqvgmwgf0l77xpp5xgmkbycdpz6kn79vm0iga3kd2mz";
      system = "amazon-ecs";
      asd = "amazon-ecs";
    });
    systems = [ "amazon-ecs" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "hunchentoot" self) (getAttr "ironclad" self) (getAttr "net-telent-date" self) (getAttr "parse-number" self) (getAttr "trivial-http" self) (getAttr "xml-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  amb = (build-asdf-system {
    pname = "amb";
    version = "20230214-git";
    asds = [ "amb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/amb/2023-02-14/amb-20230214-git.tgz";
      sha256 = "014vpsqxjnsr0x2zql6xpz0kh448p3lqw521amsf6700jqa2s1wp";
      system = "amb";
      asd = "amb";
    });
    systems = [ "amb" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  anaphora = (build-asdf-system {
    pname = "anaphora";
    version = "20220220-git";
    asds = [ "anaphora" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/anaphora/2022-02-20/anaphora-20220220-git.tgz";
      sha256 = "1ds5ab0rzkrhfl29xpvmvyxmkdyj9mi19p330pz603lx95njjc0b";
      system = "anaphora";
      asd = "anaphora";
    });
    systems = [ "anaphora" ];
    lispLibs = [  ];
    meta = {};
  });
  anaphoric-variants = (build-asdf-system {
    pname = "anaphoric-variants";
    version = "1.0.1";
    asds = [ "anaphoric-variants" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/anaphoric-variants/2012-10-13/anaphoric-variants-1.0.1.tgz";
      sha256 = "02ms01w09b9bzsdsr0icd3ggyl86kyxk164kf0759k2k9y6kjsp5";
      system = "anaphoric-variants";
      asd = "anaphoric-variants";
    });
    systems = [ "anaphoric-variants" ];
    lispLibs = [ (getAttr "map-bind" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  anatevka = (build-asdf-system {
    pname = "anatevka";
    version = "v1.0.0";
    asds = [ "anatevka" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/anatevka/2022-11-06/anatevka-v1.0.0.tgz";
      sha256 = "1c8y91nv1jln22j7b82qiad861zfjs9a8nxm18r1dxblszpyygsk";
      system = "anatevka";
      asd = "anatevka";
    });
    systems = [ "anatevka" ];
    lispLibs = [ (getAttr "aether" self) (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  anatevka-tests = (build-asdf-system {
    pname = "anatevka-tests";
    version = "v1.0.0";
    asds = [ "anatevka-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/anatevka/2022-11-06/anatevka-v1.0.0.tgz";
      sha256 = "1c8y91nv1jln22j7b82qiad861zfjs9a8nxm18r1dxblszpyygsk";
      system = "anatevka-tests";
      asd = "anatevka-tests";
    });
    systems = [ "anatevka-tests" ];
    lispLibs = [ (getAttr "anatevka" self) (getAttr "closer-mop" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ansi-escape = (build-asdf-system {
    pname = "ansi-escape";
    version = "20230618-git";
    asds = [ "ansi-escape" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/croatoan/2023-06-18/croatoan-20230618-git.tgz";
      sha256 = "1whbvwc4df7zz0002xy3aczrpf4s3vk6kmyh9wydgwl112h060pd";
      system = "ansi-escape";
      asd = "ansi-escape";
    });
    systems = [ "ansi-escape" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ansi-escape-test = (build-asdf-system {
    pname = "ansi-escape-test";
    version = "20230618-git";
    asds = [ "ansi-escape-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/croatoan/2023-06-18/croatoan-20230618-git.tgz";
      sha256 = "1whbvwc4df7zz0002xy3aczrpf4s3vk6kmyh9wydgwl112h060pd";
      system = "ansi-escape-test";
      asd = "ansi-escape-test";
    });
    systems = [ "ansi-escape-test" ];
    lispLibs = [ (getAttr "ansi-escape" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  antik = (build-asdf-system {
    pname = "antik";
    version = "master-df14cb8c-git";
    asds = [ "antik" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/antik/2019-10-08/antik-master-df14cb8c-git.tgz";
      sha256 = "1n08cx4n51z8v4bxyak166lp495xda3x7llfxcdpxndxqxcammr0";
      system = "antik";
      asd = "antik";
    });
    systems = [ "antik" ];
    lispLibs = [ (getAttr "gsll" self) (getAttr "physical-dimension" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  antik-base = (build-asdf-system {
    pname = "antik-base";
    version = "master-df14cb8c-git";
    asds = [ "antik-base" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/antik/2019-10-08/antik-master-df14cb8c-git.tgz";
      sha256 = "1n08cx4n51z8v4bxyak166lp495xda3x7llfxcdpxndxqxcammr0";
      system = "antik-base";
      asd = "antik-base";
    });
    systems = [ "antik-base" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "iterate" self) (getAttr "lisp-unit" self) (getAttr "metabang-bind" self) (getAttr "named-readtables" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  anypool = (build-asdf-system {
    pname = "anypool";
    version = "20210531-git";
    asds = [ "anypool" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/anypool/2021-05-31/anypool-20210531-git.tgz";
      sha256 = "0dr904m0qb0xf12x0rrhw0ipw3fdqyihwr59l87prqmkv23y7aig";
      system = "anypool";
      asd = "anypool";
    });
    systems = [ "anypool" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-speedy-queue" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aplesque = (build-asdf-system {
    pname = "aplesque";
    version = "20230618-git";
    asds = [ "aplesque" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "aplesque";
      asd = "aplesque";
    });
    systems = [ "aplesque" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "array-operations" self) (getAttr "cl-ppcre" self) (getAttr "lparallel" self) (getAttr "parse-number" self) (getAttr "symbol-munger" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  application = (build-asdf-system {
    pname = "application";
    version = "20200427-git";
    asds = [ "application" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/sucle/2020-04-27/sucle-20200427-git.tgz";
      sha256 = "033akkn9zxc6qdgycgxgybx3v23638245xrx29x2cbwnvg3i1q34";
      system = "application";
      asd = "application";
    });
    systems = [ "application" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-opengl" self) (getAttr "deflazy" self) (getAttr "glhelp" self) (getAttr "scratch-buffer" self) (getAttr "utility" self) (getAttr "window" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  apply-argv = (build-asdf-system {
    pname = "apply-argv";
    version = "20150608-git";
    asds = [ "apply-argv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/apply-argv/2015-06-08/apply-argv-20150608-git.tgz";
      sha256 = "19qj847vyawjgm5iwk96469c0plnxj37948ac1bcd86hgpbm75w0";
      system = "apply-argv";
      asd = "apply-argv";
    });
    systems = [ "apply-argv" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  apply-argv-tests = (build-asdf-system {
    pname = "apply-argv-tests";
    version = "20150608-git";
    asds = [ "apply-argv-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/apply-argv/2015-06-08/apply-argv-20150608-git.tgz";
      sha256 = "19qj847vyawjgm5iwk96469c0plnxj37948ac1bcd86hgpbm75w0";
      system = "apply-argv-tests";
      asd = "apply-argv";
    });
    systems = [ "apply-argv-tests" ];
    lispLibs = [ (getAttr "apply-argv" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april = (build-asdf-system {
    pname = "april";
    version = "20230618-git";
    asds = [ "april" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april";
      asd = "april";
    });
    systems = [ "april" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "aplesque" self) (getAttr "array-operations" self) (getAttr "cl-ppcre" self) (getAttr "cl-unicode" self) (getAttr "lparallel" self) (getAttr "parse-number" self) (getAttr "prove" self) (getAttr "random-state" self) (getAttr "simple-date-time" self) (getAttr "symbol-munger" self) (getAttr "trivia" self) (getAttr "varray" self) (getAttr "vex" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-demo_dot_cnn = (build-asdf-system {
    pname = "april-demo.cnn";
    version = "20230618-git";
    asds = [ "april-demo.cnn" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-demo.cnn";
      asd = "april-demo.cnn";
    });
    systems = [ "april-demo.cnn" ];
    lispLibs = [ (getAttr "april" self) (getAttr "lisp-binary" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-demo_dot_fnn = (build-asdf-system {
    pname = "april-demo.fnn";
    version = "20230618-git";
    asds = [ "april-demo.fnn" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-demo.fnn";
      asd = "april-demo.fnn";
    });
    systems = [ "april-demo.fnn" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_array" self) (getAttr "lisp-binary" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-demo_dot_ncurses = (build-asdf-system {
    pname = "april-demo.ncurses";
    version = "20230618-git";
    asds = [ "april-demo.ncurses" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-demo.ncurses";
      asd = "april-demo.ncurses";
    });
    systems = [ "april-demo.ncurses" ];
    lispLibs = [ (getAttr "april" self) (getAttr "croatoan" self) (getAttr "lparallel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_array = (build-asdf-system {
    pname = "april-lib.dfns.array";
    version = "20230618-git";
    asds = [ "april-lib.dfns.array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.array";
      asd = "april-lib.dfns.array";
    });
    systems = [ "april-lib.dfns.array" ];
    lispLibs = [ (getAttr "april" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_graph = (build-asdf-system {
    pname = "april-lib.dfns.graph";
    version = "20230618-git";
    asds = [ "april-lib.dfns.graph" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.graph";
      asd = "april-lib.dfns.graph";
    });
    systems = [ "april-lib.dfns.graph" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_array" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_numeric = (build-asdf-system {
    pname = "april-lib.dfns.numeric";
    version = "20230618-git";
    asds = [ "april-lib.dfns.numeric" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.numeric";
      asd = "april-lib.dfns.numeric";
    });
    systems = [ "april-lib.dfns.numeric" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_graph" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_power = (build-asdf-system {
    pname = "april-lib.dfns.power";
    version = "20230618-git";
    asds = [ "april-lib.dfns.power" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.power";
      asd = "april-lib.dfns.power";
    });
    systems = [ "april-lib.dfns.power" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_array" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_string = (build-asdf-system {
    pname = "april-lib.dfns.string";
    version = "20230618-git";
    asds = [ "april-lib.dfns.string" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.string";
      asd = "april-lib.dfns.string";
    });
    systems = [ "april-lib.dfns.string" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_array" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-lib_dot_dfns_dot_tree = (build-asdf-system {
    pname = "april-lib.dfns.tree";
    version = "20230618-git";
    asds = [ "april-lib.dfns.tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-lib.dfns.tree";
      asd = "april-lib.dfns.tree";
    });
    systems = [ "april-lib.dfns.tree" ];
    lispLibs = [ (getAttr "april" self) (getAttr "april-lib_dot_dfns_dot_array" self) (getAttr "april-lib_dot_dfns_dot_power" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  april-xt_dot_uzuki = (build-asdf-system {
    pname = "april-xt.uzuki";
    version = "20230618-git";
    asds = [ "april-xt.uzuki" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/april/2023-06-18/april-20230618-git.tgz";
      sha256 = "0p98kw46c3sd9mdi44mmdzb9zq7b9firxsinwn8f3wgqgdydlfsq";
      system = "april-xt.uzuki";
      asd = "april-xt.uzuki";
    });
    systems = [ "april-xt.uzuki" ];
    lispLibs = [ (getAttr "april" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arc-compat = (build-asdf-system {
    pname = "arc-compat";
    version = "20230618-git";
    asds = [ "arc-compat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arc-compat/2023-06-18/arc-compat-20230618-git.tgz";
      sha256 = "01pysyx5wq5hapg5v8ir3wmql3i4cx0saaf09zbf3cir6c77yjd1";
      system = "arc-compat";
      asd = "arc-compat";
    });
    systems = [ "arc-compat" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "bordeaux-threads" self) (getAttr "cl-fad" self) (getAttr "fiveam" self) (getAttr "ironclad" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol = (build-asdf-system {
    pname = "architecture.builder-protocol";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol";
      asd = "architecture.builder-protocol";
    });
    systems = [ "architecture.builder-protocol" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol_dot_inspection = (build-asdf-system {
    pname = "architecture.builder-protocol.inspection";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol.inspection" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol.inspection";
      asd = "architecture.builder-protocol.inspection";
    });
    systems = [ "architecture.builder-protocol.inspection" ];
    lispLibs = [ (getAttr "architecture_dot_builder-protocol" self) (getAttr "clouseau" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol_dot_json = (build-asdf-system {
    pname = "architecture.builder-protocol.json";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol.json" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol.json";
      asd = "architecture.builder-protocol.json";
    });
    systems = [ "architecture.builder-protocol.json" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "architecture_dot_builder-protocol" self) (getAttr "cl-json" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol_dot_print-tree = (build-asdf-system {
    pname = "architecture.builder-protocol.print-tree";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol.print-tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol.print-tree";
      asd = "architecture.builder-protocol.print-tree";
    });
    systems = [ "architecture.builder-protocol.print-tree" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "architecture_dot_builder-protocol" self) (getAttr "utilities_dot_print-tree" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol_dot_universal-builder = (build-asdf-system {
    pname = "architecture.builder-protocol.universal-builder";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol.universal-builder" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol.universal-builder";
      asd = "architecture.builder-protocol.universal-builder";
    });
    systems = [ "architecture.builder-protocol.universal-builder" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "architecture_dot_builder-protocol" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_builder-protocol_dot_xpath = (build-asdf-system {
    pname = "architecture.builder-protocol.xpath";
    version = "20230618-git";
    asds = [ "architecture.builder-protocol.xpath" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.builder-protocol/2023-06-18/architecture.builder-protocol-20230618-git.tgz";
      sha256 = "0aml33mh40cp1cv4an9v1rn4sdpmxqvbv9nqng0hz3hr3l3ah131";
      system = "architecture.builder-protocol.xpath";
      asd = "architecture.builder-protocol.xpath";
    });
    systems = [ "architecture.builder-protocol.xpath" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "architecture_dot_builder-protocol" self) (getAttr "xpath" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_service-provider = (build-asdf-system {
    pname = "architecture.service-provider";
    version = "20191007-git";
    asds = [ "architecture.service-provider" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.service-provider/2019-10-07/architecture.service-provider-20191007-git.tgz";
      sha256 = "0n4a299md5z0wvk6j3my4ii6cs198fqgizz1swic89p1qz5n2fjm";
      system = "architecture.service-provider";
      asd = "architecture.service-provider";
    });
    systems = [ "architecture.service-provider" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "let-plus" self) (getAttr "more-conditions" self) (getAttr "utilities_dot_print-items" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  architecture_dot_service-provider-and-hooks = (build-asdf-system {
    pname = "architecture.service-provider-and-hooks";
    version = "20191007-git";
    asds = [ "architecture.service-provider-and-hooks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.service-provider/2019-10-07/architecture.service-provider-20191007-git.tgz";
      sha256 = "0n4a299md5z0wvk6j3my4ii6cs198fqgizz1swic89p1qz5n2fjm";
      system = "architecture.service-provider-and-hooks";
      asd = "architecture.service-provider-and-hooks";
    });
    systems = [ "architecture.service-provider-and-hooks" ];
    lispLibs = [ (getAttr "architecture_dot_service-provider" self) (getAttr "cl-hooks" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  archive = (build-asdf-system {
    pname = "archive";
    version = "20160318-git";
    asds = [ "archive" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/archive/2016-03-18/archive-20160318-git.tgz";
      sha256 = "0pvsc9fmybx7rxd0kmzq4shi6hszdpwdc1sfy7jwyfxf8n3hnv4p";
      system = "archive";
      asd = "archive";
    });
    systems = [ "archive" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arith = (build-asdf-system {
    pname = "arith";
    version = "20170830-git";
    asds = [ "arith" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/paren-test/2017-08-30/paren-test-20170830-git.tgz";
      sha256 = "0b2d3kcv3n4b0dm67pzhxx8wxjsgnb32bw2dsprblc7149gaczdr";
      system = "arith";
      asd = "arith";
    });
    systems = [ "arith" ];
    lispLibs = [ (getAttr "paren-files" self) (getAttr "paren-test" self) (getAttr "parenscript" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arithmetic-operators-as-words = (build-asdf-system {
    pname = "arithmetic-operators-as-words";
    version = "20200610-git";
    asds = [ "arithmetic-operators-as-words" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arithmetic-operators-as-words/2020-06-10/arithmetic-operators-as-words-20200610-git.tgz";
      sha256 = "1bcfkbq3kqns2ng0cdmj81c72j63641pqlskg4xrzkgkh25bhkks";
      system = "arithmetic-operators-as-words";
      asd = "arithmetic-operators-as-words";
    });
    systems = [ "arithmetic-operators-as-words" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arnesi = (build-asdf-system {
    pname = "arnesi";
    version = "20170403-git";
    asds = [ "arnesi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arnesi/2017-04-03/arnesi-20170403-git.tgz";
      sha256 = "0jgj2xgd1gq6rf8ia43lkmbrbxnp8rgs053br9azfa25ygk3ikbh";
      system = "arnesi";
      asd = "arnesi";
    });
    systems = [ "arnesi" ];
    lispLibs = [ (getAttr "collectors" self) ];
    meta = {};
  });
  array-operations = (build-asdf-system {
    pname = "array-operations";
    version = "1.0.0";
    asds = [ "array-operations" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/array-operations/2022-07-07/array-operations-1.0.0.tgz";
      sha256 = "12rmijvz5gpri5f5vi5j49bngiy2c01f5755rl39kxpv1b886gvy";
      system = "array-operations";
      asd = "array-operations";
    });
    systems = [ "array-operations" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "let-plus" self) ];
    meta = {};
  });
  array-utils = (build-asdf-system {
    pname = "array-utils";
    version = "20230618-git";
    asds = [ "array-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/array-utils/2023-06-18/array-utils-20230618-git.tgz";
      sha256 = "1d66s2inb9hpw27hdb20x27dychmpn1mn35v0mlsib848qdz87az";
      system = "array-utils";
      asd = "array-utils";
    });
    systems = [ "array-utils" ];
    lispLibs = [  ];
    meta = {};
  });
  array-utils-test = (build-asdf-system {
    pname = "array-utils-test";
    version = "20230618-git";
    asds = [ "array-utils-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/array-utils/2023-06-18/array-utils-20230618-git.tgz";
      sha256 = "1d66s2inb9hpw27hdb20x27dychmpn1mn35v0mlsib848qdz87az";
      system = "array-utils-test";
      asd = "array-utils-test";
    });
    systems = [ "array-utils-test" ];
    lispLibs = [ (getAttr "array-utils" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arrival = (build-asdf-system {
    pname = "arrival";
    version = "20211209-git";
    asds = [ "arrival" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arrival/2021-12-09/arrival-20211209-git.tgz";
      sha256 = "1iwdk5fdismw91ln5wdnn8c8xv06fbgiwbvdj2gy2hpp8f3qk00b";
      system = "arrival";
      asd = "arrival";
    });
    systems = [ "arrival" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "iterate" self) (getAttr "log4cl" self) (getAttr "trivia" self) (getAttr "trivia_dot_quasiquote" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arrow-macros = (build-asdf-system {
    pname = "arrow-macros";
    version = "20201220-git";
    asds = [ "arrow-macros" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arrow-macros/2020-12-20/arrow-macros-20201220-git.tgz";
      sha256 = "1b7vldvhn8zx60h010573gmqv2igarpnb6h3pq8qydhwfza0xd4g";
      system = "arrow-macros";
      asd = "arrow-macros";
    });
    systems = [ "arrow-macros" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arrow-macros-test = (build-asdf-system {
    pname = "arrow-macros-test";
    version = "20201220-git";
    asds = [ "arrow-macros-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arrow-macros/2020-12-20/arrow-macros-20201220-git.tgz";
      sha256 = "1b7vldvhn8zx60h010573gmqv2igarpnb6h3pq8qydhwfza0xd4g";
      system = "arrow-macros-test";
      asd = "arrow-macros-test";
    });
    systems = [ "arrow-macros-test" ];
    lispLibs = [ (getAttr "arrow-macros" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  arrows = (build-asdf-system {
    pname = "arrows";
    version = "20181018-git";
    asds = [ "arrows" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/arrows/2018-10-18/arrows-20181018-git.tgz";
      sha256 = "042k9vkssrqx9nhp14wdzm942zgdxvp35mba0p2syz98i75im2yy";
      system = "arrows";
      asd = "arrows";
    });
    systems = [ "arrows" ];
    lispLibs = [  ];
    meta = {};
  });
  ascii-strings = (build-asdf-system {
    pname = "ascii-strings";
    version = "20211209-git";
    asds = [ "ascii-strings" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-string-match/2021-12-09/cl-string-match-20211209-git.tgz";
      sha256 = "0zndlkw3qy3vw4px4qv884z6232w8zfaliyc88irjwizdv35wcq9";
      system = "ascii-strings";
      asd = "ascii-strings";
    });
    systems = [ "ascii-strings" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asd-generator = (build-asdf-system {
    pname = "asd-generator";
    version = "20190107-git";
    asds = [ "asd-generator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asd-generator/2019-01-07/asd-generator-20190107-git.tgz";
      sha256 = "0yiybl7b9x1f85v0drj0yw9821y3yfhya4n6gycnv5vvx6jp9by4";
      system = "asd-generator";
      asd = "asd-generator";
    });
    systems = [ "asd-generator" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "iterate" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asd-generator-test = (build-asdf-system {
    pname = "asd-generator-test";
    version = "20190107-git";
    asds = [ "asd-generator-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asd-generator/2019-01-07/asd-generator-20190107-git.tgz";
      sha256 = "0yiybl7b9x1f85v0drj0yw9821y3yfhya4n6gycnv5vvx6jp9by4";
      system = "asd-generator-test";
      asd = "asd-generator-test";
    });
    systems = [ "asd-generator-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-dependency-graph = (build-asdf-system {
    pname = "asdf-dependency-graph";
    version = "20230618-git";
    asds = [ "asdf-dependency-graph" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-dependency-graph/2023-06-18/asdf-dependency-graph-20230618-git.tgz";
      sha256 = "1m3cgjmr5fzyas33gjnahcbjiiksr02h2lwdxxl35y2dbip8pygp";
      system = "asdf-dependency-graph";
      asd = "asdf-dependency-graph";
    });
    systems = [ "asdf-dependency-graph" ];
    lispLibs = [ (getAttr "optima" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-dependency-grovel = (build-asdf-system {
    pname = "asdf-dependency-grovel";
    version = "20170403-git";
    asds = [ "asdf-dependency-grovel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-dependency-grovel/2017-04-03/asdf-dependency-grovel-20170403-git.tgz";
      sha256 = "1y4kdqsda4ira4r9dws6kxzzv6mg45q3lkmb2c9mg9q7ksc5glif";
      system = "asdf-dependency-grovel";
      asd = "asdf-dependency-grovel";
    });
    systems = [ "asdf-dependency-grovel" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-driver = (build-asdf-system {
    pname = "asdf-driver";
    version = "3.3.6";
    asds = [ "asdf-driver" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/uiop/2023-06-18/uiop-3.3.6.tgz";
      sha256 = "080lcdw90j30gg2vv9bnwj21aq08mp1kk4nax3ffkjssnrnjwhmr";
      system = "asdf-driver";
      asd = "asdf-driver";
    });
    systems = [ "asdf-driver" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-encodings = (build-asdf-system {
    pname = "asdf-encodings";
    version = "20191007-git";
    asds = [ "asdf-encodings" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-encodings/2019-10-07/asdf-encodings-20191007-git.tgz";
      sha256 = "1yn77nhrz5w2s7nlafxjnk9j8fsrz7ivrm7nbj4r726bwc5knky6";
      system = "asdf-encodings";
      asd = "asdf-encodings";
    });
    systems = [ "asdf-encodings" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-finalizers = (build-asdf-system {
    pname = "asdf-finalizers";
    version = "20221106-git";
    asds = [ "asdf-finalizers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-finalizers/2022-11-06/asdf-finalizers-20221106-git.tgz";
      sha256 = "1w56c9yjjydjshsgqxz57qlp2v3r4ilbisnsgiqphvxnhvd41y0v";
      system = "asdf-finalizers";
      asd = "asdf-finalizers";
    });
    systems = [ "asdf-finalizers" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-linguist = (build-asdf-system {
    pname = "asdf-linguist";
    version = "20150923-git";
    asds = [ "asdf-linguist" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-linguist/2015-09-23/asdf-linguist-20150923-git.tgz";
      sha256 = "14jaqmxxh70f1jf58mxb117951iql2sjxymmbjyqniqwazznbd9a";
      system = "asdf-linguist";
      asd = "asdf-linguist";
    });
    systems = [ "asdf-linguist" ];
    lispLibs = [ (getAttr "inferior-shell" self) (getAttr "parenscript" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-manager = (build-asdf-system {
    pname = "asdf-manager";
    version = "20160208-git";
    asds = [ "asdf-manager" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-manager/2016-02-08/asdf-manager-20160208-git.tgz";
      sha256 = "0jw7d0vg13v1l1fwwhsw04n6w3c49vsbmq6vrlrkh95aayc5413w";
      system = "asdf-manager";
      asd = "asdf-manager";
    });
    systems = [ "asdf-manager" ];
    lispLibs = [ (getAttr "trivial-download" self) (getAttr "trivial-extract" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-manager-test = (build-asdf-system {
    pname = "asdf-manager-test";
    version = "20160208-git";
    asds = [ "asdf-manager-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-manager/2016-02-08/asdf-manager-20160208-git.tgz";
      sha256 = "0jw7d0vg13v1l1fwwhsw04n6w3c49vsbmq6vrlrkh95aayc5413w";
      system = "asdf-manager-test";
      asd = "asdf-manager-test";
    });
    systems = [ "asdf-manager-test" ];
    lispLibs = [ (getAttr "asdf-manager" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-nst = (build-asdf-system {
    pname = "asdf-nst";
    version = "20210807-git";
    asds = [ "asdf-nst" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-nst/2021-08-07/cl-nst-20210807-git.tgz";
      sha256 = "1hf3r6pqbnd9vsd1i24qmz928kia72hdgmiafiwb6jw1hmj3r6ga";
      system = "asdf-nst";
      asd = "asdf-nst";
    });
    systems = [ "asdf-nst" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asdf-package-system = (build-asdf-system {
    pname = "asdf-package-system";
    version = "20150608-git";
    asds = [ "asdf-package-system" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-package-system/2015-06-08/asdf-package-system-20150608-git.tgz";
      sha256 = "1q4qgvbl64c4zdbq91by1la8licdgam7ybnhvg2bixdhq4v693sj";
      system = "asdf-package-system";
      asd = "asdf-package-system";
    });
    systems = [ "asdf-package-system" ];
    lispLibs = [  ];
    meta = {};
  });
  asdf-system-connections = (build-asdf-system {
    pname = "asdf-system-connections";
    version = "20170124-git";
    asds = [ "asdf-system-connections" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-system-connections/2017-01-24/asdf-system-connections-20170124-git.tgz";
      sha256 = "06kg0m8bv383qq3r34x0f8hz6p6zxcw02qn7kj960vcnrp5a5b3y";
      system = "asdf-system-connections";
      asd = "asdf-system-connections";
    });
    systems = [ "asdf-system-connections" ];
    lispLibs = [  ];
    meta = {};
  });
  asdf-viz = (build-asdf-system {
    pname = "asdf-viz";
    version = "20200610-git";
    asds = [ "asdf-viz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asdf-viz/2020-06-10/asdf-viz-20200610-git.tgz";
      sha256 = "1hj9ac1m2kz8x65n62gd1s2k2x9pip9a85pnmib53qsks3a9sc4z";
      system = "asdf-viz";
      asd = "asdf-viz";
    });
    systems = [ "asdf-viz" ];
    lispLibs = [ (getAttr "cl-dot" self) (getAttr "closer-mop" self) (getAttr "iterate" self) (getAttr "swank" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aserve = (build-asdf-system {
    pname = "aserve";
    version = "20190813-git";
    asds = [ "aserve" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/portableaserve/2019-08-13/portableaserve-20190813-git.tgz";
      sha256 = "0ak6mqp84sjr0a7h5svr16vra4bf4fcx6wpir0n88dc1vjwy5xqa";
      system = "aserve";
      asd = "aserve";
    });
    systems = [ "aserve" ];
    lispLibs = [ (getAttr "acl-compat" self) (getAttr "htmlgen" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asn1 = (build-asdf-system {
    pname = "asn1";
    version = "20220331-git";
    asds = [ "asn1" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asn1/2022-03-31/asn1-20220331-git.tgz";
      sha256 = "16gs4xznmg19ii0cg7g2yxrk9ls5vah8ynjj80s99rv8wi3789z1";
      system = "asn1";
      asd = "asn1";
    });
    systems = [ "asn1" ];
    lispLibs = [ (getAttr "fast-io" self) (getAttr "ironclad" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  assert-p = (build-asdf-system {
    pname = "assert-p";
    version = "20200610-git";
    asds = [ "assert-p" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/assert-p/2020-06-10/assert-p-20200610-git.tgz";
      sha256 = "1x24rkqkqiw8zd26swi9rmhfplkmr5scz3bhjwccah9d2s36b1xs";
      system = "assert-p";
      asd = "assert-p";
    });
    systems = [ "assert-p" ];
    lispLibs = [ (getAttr "assertion-error" self) (getAttr "simplet-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  assertion-error = (build-asdf-system {
    pname = "assertion-error";
    version = "20191227-git";
    asds = [ "assertion-error" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/assertion-error/2019-12-27/assertion-error-20191227-git.tgz";
      sha256 = "0ix23kkakmf4nwx852zsssb831jvajr3qyppqfyks7y1ls617svn";
      system = "assertion-error";
      asd = "assertion-error";
    });
    systems = [ "assertion-error" ];
    lispLibs = [ (getAttr "dissect" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  assoc-utils = (build-asdf-system {
    pname = "assoc-utils";
    version = "20221106-git";
    asds = [ "assoc-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/assoc-utils/2022-11-06/assoc-utils-20221106-git.tgz";
      sha256 = "0mqb5iw4qwga66y7flifb1n0y5hp4gc3x8xfg4cild46x7mjqxws";
      system = "assoc-utils";
      asd = "assoc-utils";
    });
    systems = [ "assoc-utils" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  assoc-utils-test = (build-asdf-system {
    pname = "assoc-utils-test";
    version = "20221106-git";
    asds = [ "assoc-utils-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/assoc-utils/2022-11-06/assoc-utils-20221106-git.tgz";
      sha256 = "0mqb5iw4qwga66y7flifb1n0y5hp4gc3x8xfg4cild46x7mjqxws";
      system = "assoc-utils-test";
      asd = "assoc-utils-test";
    });
    systems = [ "assoc-utils-test" ];
    lispLibs = [ (getAttr "assoc-utils" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  asteroids = (build-asdf-system {
    pname = "asteroids";
    version = "20191007-git";
    asds = [ "asteroids" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/asteroids/2019-10-07/asteroids-20191007-git.tgz";
      sha256 = "1wdzwpizgy477ny6pxjshj3q25phdxsjfq8cvrbx0x7k5w8fkg50";
      system = "asteroids";
      asd = "asteroids";
    });
    systems = [ "asteroids" ];
    lispLibs = [ (getAttr "lispbuilder-sdl" self) (getAttr "lispbuilder-sdl-gfx" self) (getAttr "lispbuilder-sdl-mixer" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  astonish = (build-asdf-system {
    pname = "astonish";
    version = "20210124-git";
    asds = [ "astonish" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/astonish/2021-01-24/astonish-20210124-git.tgz";
      sha256 = "14qphx97q4gqcc71figc6r3cgy89rn9c43sh35fzxkln9ydk2pr6";
      system = "astonish";
      asd = "astonish";
    });
    systems = [ "astonish" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  async-process = (build-asdf-system {
    pname = "async-process";
    version = "20230618-git";
    asds = [ "async-process" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/async-process/2023-06-18/async-process-20230618-git.tgz";
      sha256 = "1arikx6lhnp6mkdw2wd81jrbgvzx5qaxz0vjr5jk6abd7in9fv9h";
      system = "async-process";
      asd = "async-process";
    });
    systems = [ "async-process" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  atdoc = (build-asdf-system {
    pname = "atdoc";
    version = "20120305-git";
    asds = [ "atdoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/atdoc/2012-03-05/atdoc-20120305-git.tgz";
      sha256 = "1w54phadjj00sy5qz5n0hmhzyjrx26h9hw06756zdpfbzk4f5il6";
      system = "atdoc";
      asd = "atdoc";
    });
    systems = [ "atdoc" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "cxml" self) (getAttr "split-sequence" self) (getAttr "swank" self) (getAttr "xuriella" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  atomics = (build-asdf-system {
    pname = "atomics";
    version = "20230618-git";
    asds = [ "atomics" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/atomics/2023-06-18/atomics-20230618-git.tgz";
      sha256 = "09qhhyvxk27b81ks90n5gzdnpyqm3ix0g2xfmsy2w7xxc0f6c71i";
      system = "atomics";
      asd = "atomics";
    });
    systems = [ "atomics" ];
    lispLibs = [ (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  atomics-test = (build-asdf-system {
    pname = "atomics-test";
    version = "20230618-git";
    asds = [ "atomics-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/atomics/2023-06-18/atomics-20230618-git.tgz";
      sha256 = "09qhhyvxk27b81ks90n5gzdnpyqm3ix0g2xfmsy2w7xxc0f6c71i";
      system = "atomics-test";
      asd = "atomics-test";
    });
    systems = [ "atomics-test" ];
    lispLibs = [ (getAttr "atomics" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  audio-tag = (build-asdf-system {
    pname = "audio-tag";
    version = "20210531-git";
    asds = [ "audio-tag" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/audio-tag/2021-05-31/audio-tag-20210531-git.tgz";
      sha256 = "1k9152wakazr34q4q5x8zzv3mjjkf0n9xdg7c2qqwigwws0ysgzh";
      system = "audio-tag";
      asd = "audio-tag";
    });
    systems = [ "audio-tag" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "osicat" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  authenticated-encryption = (build-asdf-system {
    pname = "authenticated-encryption";
    version = "20181018-git";
    asds = [ "authenticated-encryption" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/authenticated-encryption/2018-10-18/authenticated-encryption-20181018-git.tgz";
      sha256 = "0cvl4g0g59z5dicg7q3f9hhqshz2m0a6l2fzic75c3yv28q8m2vr";
      system = "authenticated-encryption";
      asd = "authenticated-encryption";
    });
    systems = [ "authenticated-encryption" ];
    lispLibs = [ (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  authenticated-encryption-test = (build-asdf-system {
    pname = "authenticated-encryption-test";
    version = "20181018-git";
    asds = [ "authenticated-encryption-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/authenticated-encryption/2018-10-18/authenticated-encryption-20181018-git.tgz";
      sha256 = "0cvl4g0g59z5dicg7q3f9hhqshz2m0a6l2fzic75c3yv28q8m2vr";
      system = "authenticated-encryption-test";
      asd = "authenticated-encryption-test";
    });
    systems = [ "authenticated-encryption-test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "authenticated-encryption" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  auto-restart = (build-asdf-system {
    pname = "auto-restart";
    version = "20221106-git";
    asds = [ "auto-restart" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/auto-restart/2022-11-06/auto-restart-20221106-git.tgz";
      sha256 = "1kzcxq57s3qfshvlp9w2yxs6kiyrvssrl94pa3vdf3x7644swrzi";
      system = "auto-restart";
      asd = "auto-restart";
    });
    systems = [ "auto-restart" ];
    lispLibs = [ (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  autoexport = (build-asdf-system {
    pname = "autoexport";
    version = "20211020-git";
    asds = [ "autoexport" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/autoexport/2021-10-20/autoexport-20211020-git.tgz";
      sha256 = "15kzq4hfsracxapxik3i6sxqqnwl7cb9lisgk9krrsk13d97l844";
      system = "autoexport";
      asd = "autoexport";
    });
    systems = [ "autoexport" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  automaton = (build-asdf-system {
    pname = "automaton";
    version = "20230618-git";
    asds = [ "automaton" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/mcclim/2023-06-18/mcclim-20230618-git.tgz";
      sha256 = "1p86931mw6glwlmshimn9bf4wbzp0jr1ppszc0r9fy7m6vcjlni6";
      system = "automaton";
      asd = "automaton";
    });
    systems = [ "automaton" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  avatar-api = (build-asdf-system {
    pname = "avatar-api";
    version = "20150608-git";
    asds = [ "avatar-api" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/avatar-api/2015-06-08/avatar-api-20150608-git.tgz";
      sha256 = "026s8m0bl13iqyakfxc6zwacvpj2bxxipms1kl3k9ql99yn8imvr";
      system = "avatar-api";
      asd = "avatar-api";
    });
    systems = [ "avatar-api" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "crypto-shortcuts" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  avatar-api-test = (build-asdf-system {
    pname = "avatar-api-test";
    version = "20150608-git";
    asds = [ "avatar-api-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/avatar-api/2015-06-08/avatar-api-20150608-git.tgz";
      sha256 = "026s8m0bl13iqyakfxc6zwacvpj2bxxipms1kl3k9ql99yn8imvr";
      system = "avatar-api-test";
      asd = "avatar-api-test";
    });
    systems = [ "avatar-api-test" ];
    lispLibs = [ (getAttr "avatar-api" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  avl-tree = (build-asdf-system {
    pname = "avl-tree";
    version = "20220707-git";
    asds = [ "avl-tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/avl-tree/2022-07-07/avl-tree-20220707-git.tgz";
      sha256 = "1xvh5rpz0kwzx42jrnh3kgqa87z5kmgd7f3fkkydiqj04hknsj7k";
      system = "avl-tree";
      asd = "avl-tree";
    });
    systems = [ "avl-tree" ];
    lispLibs = [ (getAttr "mfiano-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aws-foundation = (build-asdf-system {
    pname = "aws-foundation";
    version = "20180711-git";
    asds = [ "aws-foundation" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aws-foundation/2018-07-11/aws-foundation-20180711-git.tgz";
      sha256 = "1f5af22qw583frqjhnkf9wcccdkkpjiv0bbnlqqk7fxzm9pqpvhb";
      system = "aws-foundation";
      asd = "aws-foundation";
    });
    systems = [ "aws-foundation" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-json" self) (getAttr "cl-json-helper" self) (getAttr "dexador" self) (getAttr "ironclad" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aws-sdk = (build-asdf-system {
    pname = "aws-sdk";
    version = "20230215-git";
    asds = [ "aws-sdk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aws-sdk-lisp/2023-02-15/aws-sdk-lisp-20230215-git.tgz";
      sha256 = "0h10y5qj1jjv4nnwn0qm3bwbx67bxrvnjf578nzwn8bk85x3wvl1";
      system = "aws-sdk";
      asd = "aws-sdk";
    });
    systems = [ "aws-sdk" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "assoc-utils" self) (getAttr "aws-sign4" self) (getAttr "babel" self) (getAttr "cl-ppcre" self) (getAttr "dexador" self) (getAttr "ironclad" self) (getAttr "kebab" self) (getAttr "local-time" self) (getAttr "parser_dot_ini" self) (getAttr "quri" self) (getAttr "trivial-timeout" self) (getAttr "trivial-types" self) (getAttr "xmls" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aws-sign4 = (build-asdf-system {
    pname = "aws-sign4";
    version = "20201220-git";
    asds = [ "aws-sign4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aws-sign4/2020-12-20/aws-sign4-20201220-git.tgz";
      sha256 = "1bwqmy9vlq0ilwhp48y05cdfav9inwv4kai8mjj1a95776xjmjnk";
      system = "aws-sign4";
      asd = "aws-sign4";
    });
    systems = [ "aws-sign4" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "ironclad" self) (getAttr "local-time" self) (getAttr "secret-values" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aws-sign4-example = (build-asdf-system {
    pname = "aws-sign4-example";
    version = "20201220-git";
    asds = [ "aws-sign4-example" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aws-sign4/2020-12-20/aws-sign4-20201220-git.tgz";
      sha256 = "1bwqmy9vlq0ilwhp48y05cdfav9inwv4kai8mjj1a95776xjmjnk";
      system = "aws-sign4-example";
      asd = "aws-sign4";
    });
    systems = [ "aws-sign4-example" ];
    lispLibs = [ (getAttr "aws-sign4" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  aws-sign4-tests = (build-asdf-system {
    pname = "aws-sign4-tests";
    version = "20201220-git";
    asds = [ "aws-sign4-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/aws-sign4/2020-12-20/aws-sign4-20201220-git.tgz";
      sha256 = "1bwqmy9vlq0ilwhp48y05cdfav9inwv4kai8mjj1a95776xjmjnk";
      system = "aws-sign4-tests";
      asd = "aws-sign4";
    });
    systems = [ "aws-sign4-tests" ];
    lispLibs = [ (getAttr "aws-sign4" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ayah-captcha = (build-asdf-system {
    pname = "ayah-captcha";
    version = "20180228-git";
    asds = [ "ayah-captcha" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ayah-captcha/2018-02-28/ayah-captcha-20180228-git.tgz";
      sha256 = "1l9zg0hj5cd1yda1nnab7byrgkakh5vn3qcd4lmfidbijk6kiamw";
      system = "ayah-captcha";
      asd = "ayah-captcha";
    });
    systems = [ "ayah-captcha" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ayah-captcha-demo = (build-asdf-system {
    pname = "ayah-captcha-demo";
    version = "20180228-git";
    asds = [ "ayah-captcha-demo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ayah-captcha/2018-02-28/ayah-captcha-20180228-git.tgz";
      sha256 = "1l9zg0hj5cd1yda1nnab7byrgkakh5vn3qcd4lmfidbijk6kiamw";
      system = "ayah-captcha-demo";
      asd = "ayah-captcha-demo";
    });
    systems = [ "ayah-captcha-demo" ];
    lispLibs = [ (getAttr "ayah-captcha" self) (getAttr "cl-who" self) (getAttr "hunchentoot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  babel = (build-asdf-system {
    pname = "babel";
    version = "20230214-git";
    asds = [ "babel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/babel/2023-02-14/babel-20230214-git.tgz";
      sha256 = "1sndap9ykyyvrzlqm9smgqy49r3n67l926yg0hb7pm00plj0y380";
      system = "babel";
      asd = "babel";
    });
    systems = [ "babel" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "trivial-features" self) ];
    meta = {};
  });
  babel-streams = (build-asdf-system {
    pname = "babel-streams";
    version = "20230214-git";
    asds = [ "babel-streams" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/babel/2023-02-14/babel-20230214-git.tgz";
      sha256 = "1sndap9ykyyvrzlqm9smgqy49r3n67l926yg0hb7pm00plj0y380";
      system = "babel-streams";
      asd = "babel-streams";
    });
    systems = [ "babel-streams" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  babel-tests = (build-asdf-system {
    pname = "babel-tests";
    version = "20230214-git";
    asds = [ "babel-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/babel/2023-02-14/babel-20230214-git.tgz";
      sha256 = "1sndap9ykyyvrzlqm9smgqy49r3n67l926yg0hb7pm00plj0y380";
      system = "babel-tests";
      asd = "babel-tests";
    });
    systems = [ "babel-tests" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  base = (build-asdf-system {
    pname = "base";
    version = "master-5b2475f9-git";
    asds = [ "base" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/gendl/2023-06-18/gendl-master-5b2475f9-git.tgz";
      sha256 = "1w8xn2vg527g1s7cfhw669sdgbq1v5i927g00qzsq9di0syxvczg";
      system = "base";
      asd = "base";
    });
    systems = [ "base" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  base-blobs = (build-asdf-system {
    pname = "base-blobs";
    version = "stable-git";
    asds = [ "base-blobs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/base-blobs/2020-10-16/base-blobs-stable-git.tgz";
      sha256 = "06m8rvczj309wq8by697gvrklhff5mnn5n5sky7i11bnszrxysys";
      system = "base-blobs";
      asd = "base-blobs";
    });
    systems = [ "base-blobs" ];
    lispLibs = [ (getAttr "bodge-blobs-support" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  base64 = (build-asdf-system {
    pname = "base64";
    version = "20181018-git";
    asds = [ "base64" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/base64/2018-10-18/base64-20181018-git.tgz";
      sha256 = "0qkqcrgmcqshcsnzn4pcyk8d1j9c7pks2qf51p1hfybz5shxkqkh";
      system = "base64";
      asd = "base64";
    });
    systems = [ "base64" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  basic-binary-ipc = (build-asdf-system {
    pname = "basic-binary-ipc";
    version = "20211209-git";
    asds = [ "basic-binary-ipc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/basic-binary-ipc/2021-12-09/basic-binary-ipc-20211209-git.tgz";
      sha256 = "0bsxy27mnmzr6vys96cs2is57zvk0n9hlif9llnp4q9m2wzycbwm";
      system = "basic-binary-ipc";
      asd = "basic-binary-ipc";
    });
    systems = [ "basic-binary-ipc" ];
    lispLibs = [ (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  basic-binary-ipc-tests = (build-asdf-system {
    pname = "basic-binary-ipc-tests";
    version = "20211209-git";
    asds = [ "basic-binary-ipc-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/basic-binary-ipc/2021-12-09/basic-binary-ipc-20211209-git.tgz";
      sha256 = "0bsxy27mnmzr6vys96cs2is57zvk0n9hlif9llnp4q9m2wzycbwm";
      system = "basic-binary-ipc-tests";
      asd = "basic-binary-ipc-tests";
    });
    systems = [ "basic-binary-ipc-tests" ];
    lispLibs = [ (getAttr "basic-binary-ipc" self) (getAttr "bordeaux-threads" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bdef = (build-asdf-system {
    pname = "bdef";
    version = "20230618-git";
    asds = [ "bdef" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bdef/2023-06-18/bdef-20230618-git.tgz";
      sha256 = "16y39qkiygp733bg7pig4smfkm91mkflbdpc6b44slgpr3x37sr1";
      system = "bdef";
      asd = "bdef";
    });
    systems = [ "bdef" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "eager-future2" self) (getAttr "jsown" self) (getAttr "mutility" self) (getAttr "parse-float" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  beast = (build-asdf-system {
    pname = "beast";
    version = "20211020-hg";
    asds = [ "beast" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/beast/2021-10-20/beast-20211020-hg.tgz";
      sha256 = "0rb7yxr4clsdbgyjz9d8inxgj7zs0knrngl7gb6b8ky1vyrv12k4";
      system = "beast";
      asd = "beast";
    });
    systems = [ "beast" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  beirc = (build-asdf-system {
    pname = "beirc";
    version = "20150505-git";
    asds = [ "beirc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/beirc/2015-05-05/beirc-20150505-git.tgz";
      sha256 = "1jmxihxln51vxy85r3zx0gfrzs9ng8nmj87j5ws1fg8bwv8b2zc4";
      system = "beirc";
      asd = "beirc";
    });
    systems = [ "beirc" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "cl-irc" self) (getAttr "cl-ppcre" self) (getAttr "mcclim" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bencode = (build-asdf-system {
    pname = "bencode";
    version = "20180228-git";
    asds = [ "bencode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bencode/2018-02-28/cl-bencode-20180228-git.tgz";
      sha256 = "02n9cv5jbgzjwmw11c1a557r62m4i4gmmx38csscbq0cv6vzys1j";
      system = "bencode";
      asd = "bencode";
    });
    systems = [ "bencode" ];
    lispLibs = [ (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bencode-test = (build-asdf-system {
    pname = "bencode-test";
    version = "20180228-git";
    asds = [ "bencode-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bencode/2018-02-28/cl-bencode-20180228-git.tgz";
      sha256 = "02n9cv5jbgzjwmw11c1a557r62m4i4gmmx38csscbq0cv6vzys1j";
      system = "bencode-test";
      asd = "bencode";
    });
    systems = [ "bencode-test" ];
    lispLibs = [ (getAttr "bencode" self) (getAttr "check-it" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bermuda = (build-asdf-system {
    pname = "bermuda";
    version = "20150608-git";
    asds = [ "bermuda" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/pal/2015-06-08/pal-20150608-git.tgz";
      sha256 = "0kn6jxirrn7wzqymzsi0kx2ivl0nrrcgbl4dm1714s48qw0jwhcw";
      system = "bermuda";
      asd = "bermuda";
    });
    systems = [ "bermuda" ];
    lispLibs = [ (getAttr "pal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bert = (build-asdf-system {
    pname = "bert";
    version = "20141106-git";
    asds = [ "bert" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bert/2014-11-06/cl-bert-20141106-git.tgz";
      sha256 = "18cyk63dmcqqwsld4h65mzscgjsc085ws69z097naqm1r70kkygr";
      system = "bert";
      asd = "bert";
    });
    systems = [ "bert" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "erlang-term" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bibtex = (build-asdf-system {
    pname = "bibtex";
    version = "20181210-git";
    asds = [ "bibtex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bibtex/2018-12-10/cl-bibtex-20181210-git.tgz";
      sha256 = "1rb4yf1z0vvl6z4kyj0s81kq1pvxwpvbgiaraqllgj1wpf51m78h";
      system = "bibtex";
      asd = "bibtex";
    });
    systems = [ "bibtex" ];
    lispLibs = [ (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  big-string = (build-asdf-system {
    pname = "big-string";
    version = "20230618-git";
    asds = [ "big-string" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/big-string/2023-06-18/big-string-20230618-git.tgz";
      sha256 = "03w0y3x9sm0fv0dclmrnh55i83nviz7pw7mdg6di05gw03bnslrc";
      system = "big-string";
      asd = "big-string";
    });
    systems = [ "big-string" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bike = (build-asdf-system {
    pname = "bike";
    version = "20220707-git";
    asds = [ "bike" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bike/2022-07-07/bike-20220707-git.tgz";
      sha256 = "0slzgfi0yw45j238rhjsnw6vh8yvwzzsmz6vmia58fycf8p0vlc4";
      system = "bike";
      asd = "bike";
    });
    systems = [ "bike" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bike-internals" self) (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "named-readtables" self) (getAttr "split-sequence" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bike-examples = (build-asdf-system {
    pname = "bike-examples";
    version = "20220707-git";
    asds = [ "bike-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bike/2022-07-07/bike-20220707-git.tgz";
      sha256 = "0slzgfi0yw45j238rhjsnw6vh8yvwzzsmz6vmia58fycf8p0vlc4";
      system = "bike-examples";
      asd = "bike-examples";
    });
    systems = [ "bike-examples" ];
    lispLibs = [ (getAttr "bike" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bike-internals = (build-asdf-system {
    pname = "bike-internals";
    version = "20220707-git";
    asds = [ "bike-internals" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bike/2022-07-07/bike-20220707-git.tgz";
      sha256 = "0slzgfi0yw45j238rhjsnw6vh8yvwzzsmz6vmia58fycf8p0vlc4";
      system = "bike-internals";
      asd = "bike-internals";
    });
    systems = [ "bike-internals" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bike-tests = (build-asdf-system {
    pname = "bike-tests";
    version = "20220707-git";
    asds = [ "bike-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bike/2022-07-07/bike-20220707-git.tgz";
      sha256 = "0slzgfi0yw45j238rhjsnw6vh8yvwzzsmz6vmia58fycf8p0vlc4";
      system = "bike-tests";
      asd = "bike-tests";
    });
    systems = [ "bike-tests" ];
    lispLibs = [ (getAttr "bike" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-io = (build-asdf-system {
    pname = "binary-io";
    version = "20201016-git";
    asds = [ "binary-io" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binary-io/2020-10-16/binary-io-20201016-git.tgz";
      sha256 = "0gxnl12nydh8aslw78jc4cmq8licj342y2f04jalqb4d9m9jbri2";
      system = "binary-io";
      asd = "binary-io";
    });
    systems = [ "binary-io" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "ieee-floats" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-lass = (build-asdf-system {
    pname = "binary-lass";
    version = "20230214-git";
    asds = [ "binary-lass" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/lass/2023-02-14/lass-20230214-git.tgz";
      sha256 = "1xwwdcnaicnh16w2291vvwi4pgqbc9iw8cfjg349nmvr0dmf883q";
      system = "binary-lass";
      asd = "binary-lass";
    });
    systems = [ "binary-lass" ];
    lispLibs = [ (getAttr "lass" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-parser = (build-asdf-system {
    pname = "binary-parser";
    version = "20230214-git";
    asds = [ "binary-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binary-parser/2023-02-14/binary-parser-20230214-git.tgz";
      sha256 = "06lq5iv0ap6qnsrc73rmnr9qirllyz4yxsvimj6ny5wl2hn8i9jl";
      system = "binary-parser";
      asd = "binary-parser";
    });
    systems = [ "binary-parser" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "bitio" self) (getAttr "chipz" self) (getAttr "fast-io" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-search-tree = (build-asdf-system {
    pname = "binary-search-tree";
    version = "20220707-git";
    asds = [ "binary-search-tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binary-search-tree/2022-07-07/binary-search-tree-20220707-git.tgz";
      sha256 = "1k7p5dgziwni5yma7q3sbnr23kk2730vzb7ap6knnazpp0smgclf";
      system = "binary-search-tree";
      asd = "binary-search-tree";
    });
    systems = [ "binary-search-tree" ];
    lispLibs = [ (getAttr "mfiano-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-structures = (build-asdf-system {
    pname = "binary-structures";
    version = "20230618-git";
    asds = [ "binary-structures" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binary-structures/2023-06-18/binary-structures-20230618-git.tgz";
      sha256 = "18kz2m0k02w2j1px2hjmp49zwcg308p9jakqf9ifrsry1ar7ckja";
      system = "binary-structures";
      asd = "binary-structures";
    });
    systems = [ "binary-structures" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "nibbles" self) (getAttr "trivial-extensible-sequences" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binary-types = (build-asdf-system {
    pname = "binary-types";
    version = "20130615-git";
    asds = [ "binary-types" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binary-types/2013-06-15/binary-types-20130615-git.tgz";
      sha256 = "1bh65p9vg2kgh4m8q1a4jiyncnp5prdzh0d0l4pzh3jvfhgbm0gh";
      system = "binary-types";
      asd = "binary-types";
    });
    systems = [ "binary-types" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binascii = (build-asdf-system {
    pname = "binascii";
    version = "20150709-git";
    asds = [ "binascii" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binascii/2015-07-09/binascii-20150709-git.tgz";
      sha256 = "000rcdl8qshr7n48zq9bzrc4lkjx4ylb3r3w9x9syhiwfla9j4b7";
      system = "binascii";
      asd = "binascii";
    });
    systems = [ "binascii" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binascii-tests = (build-asdf-system {
    pname = "binascii-tests";
    version = "20150709-git";
    asds = [ "binascii-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binascii/2015-07-09/binascii-20150709-git.tgz";
      sha256 = "000rcdl8qshr7n48zq9bzrc4lkjx4ylb3r3w9x9syhiwfla9j4b7";
      system = "binascii-tests";
      asd = "binascii";
    });
    systems = [ "binascii-tests" ];
    lispLibs = [ (getAttr "binascii" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binding-arrows = (build-asdf-system {
    pname = "binding-arrows";
    version = "20210630-git";
    asds = [ "binding-arrows" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binding-arrows/2021-06-30/binding-arrows-20210630-git.tgz";
      sha256 = "0hqikgzic7kjq2n1d924yldfm30qz67cmsk6gghi9cbmxkwdlwp8";
      system = "binding-arrows";
      asd = "binding-arrows";
    });
    systems = [ "binding-arrows" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binfix = (build-asdf-system {
    pname = "binfix";
    version = "20190813-git";
    asds = [ "binfix" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binfix/2019-08-13/binfix-20190813-git.tgz";
      sha256 = "07925kj32y7ppwmz62c08gd0s6yp12s6nz1wh0pzh0ccq9nwgzhz";
      system = "binfix";
      asd = "binfix";
    });
    systems = [ "binfix" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  binomial-heap = (build-asdf-system {
    pname = "binomial-heap";
    version = "20130420-git";
    asds = [ "binomial-heap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binomial-heap/2013-04-20/binomial-heap-20130420-git.tgz";
      sha256 = "1d4jrlkdjdppnvqpqkr7i7djpgmrvrbky4pc1pxvqci5jx7xlkk6";
      system = "binomial-heap";
      asd = "binomial-heap";
    });
    systems = [ "binomial-heap" ];
    lispLibs = [  ];
    meta = {};
  });
  binpack = (build-asdf-system {
    pname = "binpack";
    version = "20230214-git";
    asds = [ "binpack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binpack/2023-02-14/binpack-20230214-git.tgz";
      sha256 = "0cfflx7aqmkzsljjaw0dwk49ii0vxm7d07s4gyrszb7zbpmz0jri";
      system = "binpack";
      asd = "binpack";
    });
    systems = [ "binpack" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {};
  });
  binpack-test = (build-asdf-system {
    pname = "binpack-test";
    version = "20230214-git";
    asds = [ "binpack-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/binpack/2023-02-14/binpack-20230214-git.tgz";
      sha256 = "0cfflx7aqmkzsljjaw0dwk49ii0vxm7d07s4gyrszb7zbpmz0jri";
      system = "binpack-test";
      asd = "binpack-test";
    });
    systems = [ "binpack-test" ];
    lispLibs = [ (getAttr "binpack" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  birch = (build-asdf-system {
    pname = "birch";
    version = "20220220-git";
    asds = [ "birch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/birch/2022-02-20/birch-20220220-git.tgz";
      sha256 = "0b2wh1n9b5r1dyvgg9hhh97plbj4j5anasfbii92s2g8h2ilb4yb";
      system = "birch";
      asd = "birch";
    });
    systems = [ "birch" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl_plus_ssl" self) (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  birch_dot_test = (build-asdf-system {
    pname = "birch.test";
    version = "20220220-git";
    asds = [ "birch.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/birch/2022-02-20/birch-20220220-git.tgz";
      sha256 = "0b2wh1n9b5r1dyvgg9hhh97plbj4j5anasfbii92s2g8h2ilb4yb";
      system = "birch.test";
      asd = "birch.test";
    });
    systems = [ "birch.test" ];
    lispLibs = [ (getAttr "birch" self) (getAttr "flexi-streams" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bit-ops = (build-asdf-system {
    pname = "bit-ops";
    version = "20180228-git";
    asds = [ "bit-ops" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bit-ops/2018-02-28/bit-ops-20180228-git.tgz";
      sha256 = "0rwmm438bgxfl5ab1vnrsxgimxnr3d5kjv9a0yzmlnbg9i2hyhz7";
      system = "bit-ops";
      asd = "bit-ops";
    });
    systems = [ "bit-ops" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "immutable-struct" self) (getAttr "iterate" self) (getAttr "lisp-namespace" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bit-ops_dot_test = (build-asdf-system {
    pname = "bit-ops.test";
    version = "20180228-git";
    asds = [ "bit-ops.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bit-ops/2018-02-28/bit-ops-20180228-git.tgz";
      sha256 = "0rwmm438bgxfl5ab1vnrsxgimxnr3d5kjv9a0yzmlnbg9i2hyhz7";
      system = "bit-ops.test";
      asd = "bit-ops.test";
    });
    systems = [ "bit-ops.test" ];
    lispLibs = [ (getAttr "bit-ops" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bit-smasher = (build-asdf-system {
    pname = "bit-smasher";
    version = "20221106-git";
    asds = [ "bit-smasher" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bit-smasher/2022-11-06/bit-smasher-20221106-git.tgz";
      sha256 = "1dad4x9sjq45zz8rys6rflsklmw77631r3k4g248ynmaqkdaqjyd";
      system = "bit-smasher";
      asd = "bit-smasher";
    });
    systems = [ "bit-smasher" ];
    lispLibs = [ (getAttr "cl-base58" self) (getAttr "cl-base64" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bit-smasher-test = (build-asdf-system {
    pname = "bit-smasher-test";
    version = "20221106-git";
    asds = [ "bit-smasher-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bit-smasher/2022-11-06/bit-smasher-20221106-git.tgz";
      sha256 = "1dad4x9sjq45zz8rys6rflsklmw77631r3k4g248ynmaqkdaqjyd";
      system = "bit-smasher-test";
      asd = "bit-smasher-test";
    });
    systems = [ "bit-smasher-test" ];
    lispLibs = [ (getAttr "bit-smasher" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bitfield = (build-asdf-system {
    pname = "bitfield";
    version = "20211230-git";
    asds = [ "bitfield" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bitfield/2021-12-30/bitfield-20211230-git.tgz";
      sha256 = "1137kdj5imc5gj9g6hj4w6ksqnqppgm3knzv7j2f8r5qpfl8rfl2";
      system = "bitfield";
      asd = "bitfield";
    });
    systems = [ "bitfield" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bitfield-schema = (build-asdf-system {
    pname = "bitfield-schema";
    version = "20120107-git";
    asds = [ "bitfield-schema" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bitfield-schema/2012-01-07/bitfield-schema-20120107-git.tgz";
      sha256 = "08xkl7rbfhrx8vj98zj1lmhv6pfg2f5gk14xj7qys7mkj2iv4li6";
      system = "bitfield-schema";
      asd = "bitfield-schema";
    });
    systems = [ "bitfield-schema" ];
    lispLibs = [ (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bitio = (build-asdf-system {
    pname = "bitio";
    version = "20220220-git";
    asds = [ "bitio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bitio/2022-02-20/bitio-20220220-git.tgz";
      sha256 = "0z2yn19nxg46j274nxzry255z86p0y3p68s1f2sg7rx9y2nx3rjg";
      system = "bitio";
      asd = "bitio";
    });
    systems = [ "bitio" ];
    lispLibs = [ (getAttr "checkl" self) (getAttr "cl-package-locks" self) (getAttr "fast-io" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bk-tree = (build-asdf-system {
    pname = "bk-tree";
    version = "20130420-git";
    asds = [ "bk-tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bk-tree/2013-04-20/bk-tree-20130420-git.tgz";
      sha256 = "1nrz6fwzvkzvs6ipc5rgas77p5hv5bnaw2in5760v240gg7lxqzz";
      system = "bk-tree";
      asd = "bk-tree";
    });
    systems = [ "bk-tree" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_data_dot_impex = (build-asdf-system {
    pname = "bknr.data.impex";
    version = "20220220-git";
    asds = [ "bknr.data.impex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.data.impex";
      asd = "bknr.data.impex";
    });
    systems = [ "bknr.data.impex" ];
    lispLibs = [ (getAttr "bknr_dot_datastore" self) (getAttr "bknr_dot_impex" self) (getAttr "bknr_dot_indices" self) (getAttr "bknr_dot_utils" self) (getAttr "cl-interpol" self) (getAttr "unit-test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_datastore = (build-asdf-system {
    pname = "bknr.datastore";
    version = "20220220-git";
    asds = [ "bknr.datastore" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.datastore";
      asd = "bknr.datastore";
    });
    systems = [ "bknr.datastore" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bknr_dot_indices" self) (getAttr "bknr_dot_utils" self) (getAttr "cl-interpol" self) (getAttr "closer-mop" self) (getAttr "trivial-utf-8" self) (getAttr "unit-test" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_impex = (build-asdf-system {
    pname = "bknr.impex";
    version = "20220220-git";
    asds = [ "bknr.impex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.impex";
      asd = "bknr.impex";
    });
    systems = [ "bknr.impex" ];
    lispLibs = [ (getAttr "bknr_dot_indices" self) (getAttr "bknr_dot_utils" self) (getAttr "bknr_dot_xml" self) (getAttr "cl-interpol" self) (getAttr "closer-mop" self) (getAttr "cxml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_indices = (build-asdf-system {
    pname = "bknr.indices";
    version = "20220220-git";
    asds = [ "bknr.indices" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.indices";
      asd = "bknr.indices";
    });
    systems = [ "bknr.indices" ];
    lispLibs = [ (getAttr "bknr_dot_skip-list" self) (getAttr "bknr_dot_utils" self) (getAttr "cl-interpol" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_modules = (build-asdf-system {
    pname = "bknr.modules";
    version = "20140713-git";
    asds = [ "bknr.modules" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-web/2014-07-13/bknr-web-20140713-git.tgz";
      sha256 = "1m73z0hv7qsc9yddrg8zs7n3zmn9h64v4d62239wrvfnmzqk75x2";
      system = "bknr.modules";
      asd = "bknr.modules";
    });
    systems = [ "bknr.modules" ];
    lispLibs = [ (getAttr "bknr_dot_utils" self) (getAttr "bknr_dot_web" self) (getAttr "cl-gd" self) (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "cl-smtp" self) (getAttr "closer-mop" self) (getAttr "cxml" self) (getAttr "md5" self) (getAttr "parenscript" self) (getAttr "puri" self) (getAttr "stem" self) (getAttr "unit-test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_skip-list = (build-asdf-system {
    pname = "bknr.skip-list";
    version = "20220220-git";
    asds = [ "bknr.skip-list" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.skip-list";
      asd = "bknr.skip-list";
    });
    systems = [ "bknr.skip-list" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_skip-list_dot_test = (build-asdf-system {
    pname = "bknr.skip-list.test";
    version = "20220220-git";
    asds = [ "bknr.skip-list.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.skip-list.test";
      asd = "bknr.skip-list";
    });
    systems = [ "bknr.skip-list.test" ];
    lispLibs = [ (getAttr "bknr_dot_skip-list" self) (getAttr "unit-test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_utils = (build-asdf-system {
    pname = "bknr.utils";
    version = "20220220-git";
    asds = [ "bknr.utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.utils";
      asd = "bknr.utils";
    });
    systems = [ "bknr.utils" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "md5" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_web = (build-asdf-system {
    pname = "bknr.web";
    version = "20140713-git";
    asds = [ "bknr.web" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-web/2014-07-13/bknr-web-20140713-git.tgz";
      sha256 = "1m73z0hv7qsc9yddrg8zs7n3zmn9h64v4d62239wrvfnmzqk75x2";
      system = "bknr.web";
      asd = "bknr.web";
    });
    systems = [ "bknr.web" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bknr_dot_data_dot_impex" self) (getAttr "bknr_dot_datastore" self) (getAttr "bknr_dot_utils" self) (getAttr "bknr_dot_xml" self) (getAttr "cl-gd" self) (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "cxml" self) (getAttr "drakma" self) (getAttr "hunchentoot" self) (getAttr "md5" self) (getAttr "parenscript" self) (getAttr "puri" self) (getAttr "unit-test" self) (getAttr "usocket" self) (getAttr "xhtmlgen" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bknr_dot_xml = (build-asdf-system {
    pname = "bknr.xml";
    version = "20220220-git";
    asds = [ "bknr.xml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bknr-datastore/2022-02-20/bknr-datastore-20220220-git.tgz";
      sha256 = "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm";
      system = "bknr.xml";
      asd = "bknr.xml";
    });
    systems = [ "bknr.xml" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cxml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  black-tie = (build-asdf-system {
    pname = "black-tie";
    version = "20220707-git";
    asds = [ "black-tie" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/black-tie/2022-07-07/black-tie-20220707-git.tgz";
      sha256 = "0a1zczxp4wkqs4cmwc4rnsgwwc2h4zqmg58cjykfzz4jh31fa43a";
      system = "black-tie";
      asd = "black-tie";
    });
    systems = [ "black-tie" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blackbird = (build-asdf-system {
    pname = "blackbird";
    version = "20221106-git";
    asds = [ "blackbird" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/blackbird/2022-11-06/blackbird-20221106-git.tgz";
      sha256 = "1r0f9473akzm6zyj494ma5p39hfkixa8aj17dhcdfa4kmqf9f6al";
      system = "blackbird";
      asd = "blackbird";
    });
    systems = [ "blackbird" ];
    lispLibs = [ (getAttr "vom" self) ];
    meta = {};
  });
  blackbird-test = (build-asdf-system {
    pname = "blackbird-test";
    version = "20221106-git";
    asds = [ "blackbird-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/blackbird/2022-11-06/blackbird-20221106-git.tgz";
      sha256 = "1r0f9473akzm6zyj494ma5p39hfkixa8aj17dhcdfa4kmqf9f6al";
      system = "blackbird-test";
      asd = "blackbird-test";
    });
    systems = [ "blackbird-test" ];
    lispLibs = [ (getAttr "blackbird" self) (getAttr "cl-async" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blas = (build-asdf-system {
    pname = "blas";
    version = "20200925-git";
    asds = [ "blas" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/f2cl/2020-09-25/f2cl-20200925-git.tgz";
      sha256 = "0kq1lrz0sg4kj64w0ysihnfwi65pami362fs2mvpyf1yhgxmq08y";
      system = "blas";
      asd = "blas";
    });
    systems = [ "blas" ];
    lispLibs = [ (getAttr "blas-complex" self) (getAttr "blas-package" self) (getAttr "blas-real" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blas-complex = (build-asdf-system {
    pname = "blas-complex";
    version = "20200925-git";
    asds = [ "blas-complex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/f2cl/2020-09-25/f2cl-20200925-git.tgz";
      sha256 = "0kq1lrz0sg4kj64w0ysihnfwi65pami362fs2mvpyf1yhgxmq08y";
      system = "blas-complex";
      asd = "blas-complex";
    });
    systems = [ "blas-complex" ];
    lispLibs = [ (getAttr "blas-real" self) (getAttr "f2cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blas-hompack = (build-asdf-system {
    pname = "blas-hompack";
    version = "20200925-git";
    asds = [ "blas-hompack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/f2cl/2020-09-25/f2cl-20200925-git.tgz";
      sha256 = "0kq1lrz0sg4kj64w0ysihnfwi65pami362fs2mvpyf1yhgxmq08y";
      system = "blas-hompack";
      asd = "blas-hompack";
    });
    systems = [ "blas-hompack" ];
    lispLibs = [ (getAttr "blas-package" self) (getAttr "f2cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blas-package = (build-asdf-system {
    pname = "blas-package";
    version = "20200925-git";
    asds = [ "blas-package" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/f2cl/2020-09-25/f2cl-20200925-git.tgz";
      sha256 = "0kq1lrz0sg4kj64w0ysihnfwi65pami362fs2mvpyf1yhgxmq08y";
      system = "blas-package";
      asd = "blas-package";
    });
    systems = [ "blas-package" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blas-real = (build-asdf-system {
    pname = "blas-real";
    version = "20200925-git";
    asds = [ "blas-real" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/f2cl/2020-09-25/f2cl-20200925-git.tgz";
      sha256 = "0kq1lrz0sg4kj64w0ysihnfwi65pami362fs2mvpyf1yhgxmq08y";
      system = "blas-real";
      asd = "blas-real";
    });
    systems = [ "blas-real" ];
    lispLibs = [ (getAttr "blas-hompack" self) (getAttr "f2cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  blocks-world = (build-asdf-system {
    pname = "blocks-world";
    version = "20120305-git";
    asds = [ "blocks-world" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/atdoc/2012-03-05/atdoc-20120305-git.tgz";
      sha256 = "1w54phadjj00sy5qz5n0hmhzyjrx26h9hw06756zdpfbzk4f5il6";
      system = "blocks-world";
      asd = "blocks-world";
    });
    systems = [ "blocks-world" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bmas = (build-asdf-system {
    pname = "bmas";
    version = "20230618-git";
    asds = [ "bmas" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bmas/2023-06-18/cl-bmas-20230618-git.tgz";
      sha256 = "0k8dxz49bmmd9d1dbmkwm9kb8hmgj9bzq0bycpr3250prin855ip";
      system = "bmas";
      asd = "bmas";
    });
    systems = [ "bmas" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-autowrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bmp-test = (build-asdf-system {
    pname = "bmp-test";
    version = "20211020-git";
    asds = [ "bmp-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-png/2021-10-20/cl-png-20211020-git.tgz";
      sha256 = "17xcb9ps5vf3if61blmx7cpfrz3gsw7jk8d5zv3f4cq8jrriqdx4";
      system = "bmp-test";
      asd = "bmp-test";
    });
    systems = [ "bmp-test" ];
    lispLibs = [ (getAttr "png" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bnf = (build-asdf-system {
    pname = "bnf";
    version = "20220220-git";
    asds = [ "bnf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bnf/2022-02-20/bnf-20220220-git.tgz";
      sha256 = "1kr6k9qs9bbza591hi1c2mlxqd5yz3nrvyd3cw7139iz1z2m7dbg";
      system = "bnf";
      asd = "bnf";
    });
    systems = [ "bnf" ];
    lispLibs = [ (getAttr "trestrul" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bnf_dot_test = (build-asdf-system {
    pname = "bnf.test";
    version = "20220220-git";
    asds = [ "bnf.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bnf/2022-02-20/bnf-20220220-git.tgz";
      sha256 = "1kr6k9qs9bbza591hi1c2mlxqd5yz3nrvyd3cw7139iz1z2m7dbg";
      system = "bnf.test";
      asd = "bnf.test";
    });
    systems = [ "bnf.test" ];
    lispLibs = [ (getAttr "bnf" self) (getAttr "jingoh" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bobbin = (build-asdf-system {
    pname = "bobbin";
    version = "20201016-hg";
    asds = [ "bobbin" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bobbin/2020-10-16/bobbin-20201016-hg.tgz";
      sha256 = "1yvx7d0cx5b119r4aays2rck33088bp7spaydnvkc329hfq1ahc2";
      system = "bobbin";
      asd = "bobbin";
    });
    systems = [ "bobbin" ];
    lispLibs = [ (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-blobs-support = (build-asdf-system {
    pname = "bodge-blobs-support";
    version = "stable-git";
    asds = [ "bodge-blobs-support" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-blobs-support/2020-10-16/bodge-blobs-support-stable-git.tgz";
      sha256 = "02nd1x6y1akp1ymv1y4z9ympwbnpd1drwi4f86xbjszxqff6jyj8";
      system = "bodge-blobs-support";
      asd = "bodge-blobs-support";
    });
    systems = [ "bodge-blobs-support" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-chipmunk = (build-asdf-system {
    pname = "bodge-chipmunk";
    version = "stable-git";
    asds = [ "bodge-chipmunk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-chipmunk/2020-10-16/bodge-chipmunk-stable-git.tgz";
      sha256 = "06zkia7rrhn1961jmayyvdbbbnf2rnr84lbd1x6gq8psfb2rif2f";
      system = "bodge-chipmunk";
      asd = "bodge-chipmunk";
    });
    systems = [ "bodge-chipmunk" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-concurrency = (build-asdf-system {
    pname = "bodge-concurrency";
    version = "stable-git";
    asds = [ "bodge-concurrency" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-concurrency/2020-10-16/bodge-concurrency-stable-git.tgz";
      sha256 = "06v2h7vassp5v50qsqxkmshcrlrzlhqaga4z7lnidfniw7f8d5vd";
      system = "bodge-concurrency";
      asd = "bodge-concurrency";
    });
    systems = [ "bodge-concurrency" ];
    lispLibs = [ (getAttr "bodge-memory" self) (getAttr "bodge-queue" self) (getAttr "bodge-utilities" self) (getAttr "bordeaux-threads" self) (getAttr "cl-flow" self) (getAttr "cl-muth" self) (getAttr "simple-flow-dispatcher" self) (getAttr "trivial-main-thread" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-glad = (build-asdf-system {
    pname = "bodge-glad";
    version = "stable-git";
    asds = [ "bodge-glad" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-glad/2020-10-16/bodge-glad-stable-git.tgz";
      sha256 = "0ghrg0z5pj36igp5wpvp1iwnvjbca3wfb60kvirhv3l9ww51jg9g";
      system = "bodge-glad";
      asd = "bodge-glad";
    });
    systems = [ "bodge-glad" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-glfw = (build-asdf-system {
    pname = "bodge-glfw";
    version = "stable-git";
    asds = [ "bodge-glfw" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-glfw/2020-10-16/bodge-glfw-stable-git.tgz";
      sha256 = "1xjg75grndl2mbfql1g2qgx810kg6wxrnhxb406m9lisd112i0m8";
      system = "bodge-glfw";
      asd = "bodge-glfw";
    });
    systems = [ "bodge-glfw" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-heap = (build-asdf-system {
    pname = "bodge-heap";
    version = "stable-git";
    asds = [ "bodge-heap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-heap/2020-10-16/bodge-heap-stable-git.tgz";
      sha256 = "1ngi9ccr9iz93mm3b4hgh2fj39vqpjrpkcfza5vly16z3r7gxca4";
      system = "bodge-heap";
      asd = "bodge-heap";
    });
    systems = [ "bodge-heap" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-host = (build-asdf-system {
    pname = "bodge-host";
    version = "stable-git";
    asds = [ "bodge-host" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-host/2021-12-09/bodge-host-stable-git.tgz";
      sha256 = "0piayirpbh91klrk3pg0g1vxhlk8yxvbr2wv923awdalwy0fn73n";
      system = "bodge-host";
      asd = "bodge-host";
    });
    systems = [ "bodge-host" ];
    lispLibs = [ (getAttr "bodge-concurrency" self) (getAttr "bodge-glfw" self) (getAttr "bodge-libc-essentials" self) (getAttr "bodge-math" self) (getAttr "bodge-utilities" self) (getAttr "cffi-c-ref" self) (getAttr "float-features" self) (getAttr "glfw-blob" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-libc-essentials = (build-asdf-system {
    pname = "bodge-libc-essentials";
    version = "stable-git";
    asds = [ "bodge-libc-essentials" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-libc-essentials/2020-10-16/bodge-libc-essentials-stable-git.tgz";
      sha256 = "1nkjhkaap78xk9rkvnnnkchphiz0qwrsfp4jsvcl6mvv3rb4gp2k";
      system = "bodge-libc-essentials";
      asd = "bodge-libc-essentials";
    });
    systems = [ "bodge-libc-essentials" ];
    lispLibs = [ (getAttr "claw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-math = (build-asdf-system {
    pname = "bodge-math";
    version = "stable-git";
    asds = [ "bodge-math" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-math/2020-10-16/bodge-math-stable-git.tgz";
      sha256 = "0r3vnl9lywn4ksy34apcv6j825qp7l1naddawr14v4lwacndb80v";
      system = "bodge-math";
      asd = "bodge-math";
    });
    systems = [ "bodge-math" ];
    lispLibs = [ (getAttr "bodge-utilities" self) (getAttr "rtg-math" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-memory = (build-asdf-system {
    pname = "bodge-memory";
    version = "stable-git";
    asds = [ "bodge-memory" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-memory/2020-10-16/bodge-memory-stable-git.tgz";
      sha256 = "19fn3dw5z6f2kpar0jx7ysy5zvqjv7yv0ca7njgaam3p891yy2j9";
      system = "bodge-memory";
      asd = "bodge-memory";
    });
    systems = [ "bodge-memory" ];
    lispLibs = [ (getAttr "bodge-utilities" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-nanovg = (build-asdf-system {
    pname = "bodge-nanovg";
    version = "stable-git";
    asds = [ "bodge-nanovg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-nanovg/2020-10-16/bodge-nanovg-stable-git.tgz";
      sha256 = "0cg4rlsddjrn0ps891n29xnd14xiis20ka5gafbz9npbj6nrc4v1";
      system = "bodge-nanovg";
      asd = "bodge-nanovg";
    });
    systems = [ "bodge-nanovg" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-nuklear = (build-asdf-system {
    pname = "bodge-nuklear";
    version = "stable-git";
    asds = [ "bodge-nuklear" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-nuklear/2020-10-16/bodge-nuklear-stable-git.tgz";
      sha256 = "15q89dz2zi99yyxhb90wyydy24y2lj5xm2mzh1mrw4v8rz9aqhc2";
      system = "bodge-nuklear";
      asd = "bodge-nuklear";
    });
    systems = [ "bodge-nuklear" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-ode = (build-asdf-system {
    pname = "bodge-ode";
    version = "stable-git";
    asds = [ "bodge-ode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-ode/2020-10-16/bodge-ode-stable-git.tgz";
      sha256 = "1c051ljn5x7ssysia7lil0ykjdnbx8dfkr45ck77plv39acgicbs";
      system = "bodge-ode";
      asd = "bodge-ode";
    });
    systems = [ "bodge-ode" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) (getAttr "float-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-openal = (build-asdf-system {
    pname = "bodge-openal";
    version = "stable-git";
    asds = [ "bodge-openal" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-openal/2020-10-16/bodge-openal-stable-git.tgz";
      sha256 = "0051pwifygj1ijv5b39ldmfrka2yrj8rpap04bw3w9cckbkp6bnw";
      system = "bodge-openal";
      asd = "bodge-openal";
    });
    systems = [ "bodge-openal" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "claw" self) (getAttr "claw-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-queue = (build-asdf-system {
    pname = "bodge-queue";
    version = "stable-git";
    asds = [ "bodge-queue" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-queue/2020-10-16/bodge-queue-stable-git.tgz";
      sha256 = "0f4252i8pfy5s4v7w1bpjawysn4cw7di405mqsx2h7skv27hvpz6";
      system = "bodge-queue";
      asd = "bodge-queue";
    });
    systems = [ "bodge-queue" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-sndfile = (build-asdf-system {
    pname = "bodge-sndfile";
    version = "stable-git";
    asds = [ "bodge-sndfile" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-sndfile/2020-10-16/bodge-sndfile-stable-git.tgz";
      sha256 = "0chdasp4zvr5n34x037lhymh90wg5xwbpr5flwj8aw0cw2nlg485";
      system = "bodge-sndfile";
      asd = "bodge-sndfile";
    });
    systems = [ "bodge-sndfile" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bodge-libc-essentials" self) (getAttr "cffi" self) (getAttr "cffi-c-ref" self) (getAttr "claw" self) (getAttr "claw-utils" self) (getAttr "static-vectors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bodge-utilities = (build-asdf-system {
    pname = "bodge-utilities";
    version = "stable-git";
    asds = [ "bodge-utilities" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bodge-utilities/2022-07-07/bodge-utilities-stable-git.tgz";
      sha256 = "0jmz7zb5ahg2kfd5nrh9nb7dda5szamjv7iv9skgcvf7rwn8qf0g";
      system = "bodge-utilities";
      asd = "bodge-utilities";
    });
    systems = [ "bodge-utilities" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "claw" self) (getAttr "dissect" self) (getAttr "local-time" self) (getAttr "log4cl" self) (getAttr "split-sequence" self) (getAttr "static-vectors" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  boondoggle = (build-asdf-system {
    pname = "boondoggle";
    version = "v1.26.0";
    asds = [ "boondoggle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/quilc/2021-12-09/quilc-v1.26.0.tgz";
      sha256 = "09qp2d6xgq4cmg6nfsdz0gbs3rvz3ln0kawmry6cls14lxnljjrr";
      system = "boondoggle";
      asd = "boondoggle";
    });
    systems = [ "boondoggle" ];
    lispLibs = [ (getAttr "cl-quil" self) (getAttr "command-line-arguments" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  boondoggle-tests = (build-asdf-system {
    pname = "boondoggle-tests";
    version = "v1.26.0";
    asds = [ "boondoggle-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/quilc/2021-12-09/quilc-v1.26.0.tgz";
      sha256 = "09qp2d6xgq4cmg6nfsdz0gbs3rvz3ln0kawmry6cls14lxnljjrr";
      system = "boondoggle-tests";
      asd = "boondoggle-tests";
    });
    systems = [ "boondoggle-tests" ];
    lispLibs = [ (getAttr "boondoggle" self) (getAttr "cl-quil" self) (getAttr "fiasco" self) (getAttr "sapaclisp" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bordeaux-fft = (build-asdf-system {
    pname = "bordeaux-fft";
    version = "20150608-http";
    asds = [ "bordeaux-fft" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bordeaux-fft/2015-06-08/bordeaux-fft-20150608-http.tgz";
      sha256 = "0kmz0wv34p8wixph5i6vj6p60xa48fflh9aq6kismlb0q4a1amp3";
      system = "bordeaux-fft";
      asd = "bordeaux-fft";
    });
    systems = [ "bordeaux-fft" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bordeaux-threads = (build-asdf-system {
    pname = "bordeaux-threads";
    version = "v0.9.1";
    asds = [ "bordeaux-threads" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bordeaux-threads/2023-06-18/bordeaux-threads-v0.9.1.tgz";
      sha256 = "1jq29g6zqavjjkphi5h5n0zg58arzyy1zrhg5xsqj7nsbn9zxnmp";
      system = "bordeaux-threads";
      asd = "bordeaux-threads";
    });
    systems = [ "bordeaux-threads" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "global-vars" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  bourbaki = (build-asdf-system {
    pname = "bourbaki";
    version = "20110110-http";
    asds = [ "bourbaki" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bourbaki/2011-01-10/bourbaki-20110110-http.tgz";
      sha256 = "0d222kjk1h60467bkjpxglds3gykily5pyrnb45yvx86shkiv4lp";
      system = "bourbaki";
      asd = "bourbaki";
    });
    systems = [ "bourbaki" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bp = (build-asdf-system {
    pname = "bp";
    version = "20230618-git";
    asds = [ "bp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bp/2023-06-18/bp-20230618-git.tgz";
      sha256 = "1kzby017cfk430vbm0i2zlxwnnz56baxfy443jnab4l0436z7b4l";
      system = "bp";
      asd = "bp";
    });
    systems = [ "bp" ];
    lispLibs = [ (getAttr "aserve" self) (getAttr "cffi" self) (getAttr "ironclad" self) (getAttr "jsown" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bst = (build-asdf-system {
    pname = "bst";
    version = "20221106-git";
    asds = [ "bst" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bst/2022-11-06/bst-20221106-git.tgz";
      sha256 = "0y052jf3gkqhb7rfx72961kg42dnqhmizk7cxlv87d1jr2906d1d";
      system = "bst";
      asd = "bst";
    });
    systems = [ "bst" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bt-semaphore = (build-asdf-system {
    pname = "bt-semaphore";
    version = "20180711-git";
    asds = [ "bt-semaphore" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bt-semaphore/2018-07-11/bt-semaphore-20180711-git.tgz";
      sha256 = "0rl7yp36225z975hg069pywwlpchwn4086cgxwsi2db5mhghpr7l";
      system = "bt-semaphore";
      asd = "bt-semaphore";
    });
    systems = [ "bt-semaphore" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bt-semaphore-test = (build-asdf-system {
    pname = "bt-semaphore-test";
    version = "20180711-git";
    asds = [ "bt-semaphore-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bt-semaphore/2018-07-11/bt-semaphore-20180711-git.tgz";
      sha256 = "0rl7yp36225z975hg069pywwlpchwn4086cgxwsi2db5mhghpr7l";
      system = "bt-semaphore-test";
      asd = "bt-semaphore-test";
    });
    systems = [ "bt-semaphore-test" ];
    lispLibs = [ (getAttr "bt-semaphore" self) (getAttr "clunit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  btrie = (build-asdf-system {
    pname = "btrie";
    version = "20140713-git";
    asds = [ "btrie" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/btrie/2014-07-13/btrie-20140713-git.tgz";
      sha256 = "0f1rs2zlpi2bcyba951h3cnyz2mfsxr2i6icmqbam5acqjdrmp30";
      system = "btrie";
      asd = "btrie";
    });
    systems = [ "btrie" ];
    lispLibs = [ (getAttr "arnesi" self) (getAttr "lift" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  btrie-tests = (build-asdf-system {
    pname = "btrie-tests";
    version = "20140713-git";
    asds = [ "btrie-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/btrie/2014-07-13/btrie-20140713-git.tgz";
      sha256 = "0f1rs2zlpi2bcyba951h3cnyz2mfsxr2i6icmqbam5acqjdrmp30";
      system = "btrie-tests";
      asd = "btrie";
    });
    systems = [ "btrie-tests" ];
    lispLibs = [ (getAttr "btrie" self) (getAttr "lift" self) (getAttr "metabang-bind" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bubble-operator-upwards = (build-asdf-system {
    pname = "bubble-operator-upwards";
    version = "1.0";
    asds = [ "bubble-operator-upwards" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bubble-operator-upwards/2012-11-25/bubble-operator-upwards-1.0.tgz";
      sha256 = "0hni8j17z3aqk67r3my1nkkjafaixvdm3cdmg89hb8hhgv0rm2x7";
      system = "bubble-operator-upwards";
      asd = "bubble-operator-upwards";
    });
    systems = [ "bubble-operator-upwards" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildapp = (build-asdf-system {
    pname = "buildapp";
    version = "1.5.6";
    asds = [ "buildapp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildapp/2015-12-18/buildapp-1.5.6.tgz";
      sha256 = "020ipjfqa3l8skd97cj5kq837wgpj28ygfxnkv64cnjrlbnzh161";
      system = "buildapp";
      asd = "buildapp";
    });
    systems = [ "buildapp" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildnode = (build-asdf-system {
    pname = "buildnode";
    version = "20170403-git";
    asds = [ "buildnode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode";
      asd = "buildnode";
    });
    systems = [ "buildnode" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "closure-html" self) (getAttr "collectors" self) (getAttr "cxml" self) (getAttr "flexi-streams" self) (getAttr "iterate" self) (getAttr "split-sequence" self) (getAttr "swank" self) (getAttr "symbol-munger" self) ];
    meta = {};
  });
  buildnode-excel = (build-asdf-system {
    pname = "buildnode-excel";
    version = "20170403-git";
    asds = [ "buildnode-excel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-excel";
      asd = "buildnode-excel";
    });
    systems = [ "buildnode-excel" ];
    lispLibs = [ (getAttr "buildnode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildnode-html5 = (build-asdf-system {
    pname = "buildnode-html5";
    version = "20170403-git";
    asds = [ "buildnode-html5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-html5";
      asd = "buildnode-html5";
    });
    systems = [ "buildnode-html5" ];
    lispLibs = [ (getAttr "buildnode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildnode-kml = (build-asdf-system {
    pname = "buildnode-kml";
    version = "20170403-git";
    asds = [ "buildnode-kml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-kml";
      asd = "buildnode-kml";
    });
    systems = [ "buildnode-kml" ];
    lispLibs = [ (getAttr "buildnode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildnode-test = (build-asdf-system {
    pname = "buildnode-test";
    version = "20170403-git";
    asds = [ "buildnode-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-test";
      asd = "buildnode";
    });
    systems = [ "buildnode-test" ];
    lispLibs = [ (getAttr "buildnode" self) (getAttr "buildnode-xhtml" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  buildnode-xhtml = (build-asdf-system {
    pname = "buildnode-xhtml";
    version = "20170403-git";
    asds = [ "buildnode-xhtml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-xhtml";
      asd = "buildnode-xhtml";
    });
    systems = [ "buildnode-xhtml" ];
    lispLibs = [ (getAttr "buildnode" self) ];
    meta = {};
  });
  buildnode-xul = (build-asdf-system {
    pname = "buildnode-xul";
    version = "20170403-git";
    asds = [ "buildnode-xul" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/buildnode/2017-04-03/buildnode-20170403-git.tgz";
      sha256 = "09pd3mkjd278dl1hq30mxh6m2iyyfha4byadyb9drw4n7ncnjggs";
      system = "buildnode-xul";
      asd = "buildnode-xul";
    });
    systems = [ "buildnode-xul" ];
    lispLibs = [ (getAttr "buildnode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  burgled-batteries = (build-asdf-system {
    pname = "burgled-batteries";
    version = "20160825-git";
    asds = [ "burgled-batteries" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/burgled-batteries/2016-08-25/burgled-batteries-20160825-git.tgz";
      sha256 = "080ff1yrmfb87pqq1jqr35djjkh3fh8i6cbhv3d1md5qy7hhgdaj";
      system = "burgled-batteries";
      asd = "burgled-batteries";
    });
    systems = [ "burgled-batteries" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-fad" self) (getAttr "parse-declarations-1_dot_0" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  burgled-batteries-tests = (build-asdf-system {
    pname = "burgled-batteries-tests";
    version = "20160825-git";
    asds = [ "burgled-batteries-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/burgled-batteries/2016-08-25/burgled-batteries-20160825-git.tgz";
      sha256 = "080ff1yrmfb87pqq1jqr35djjkh3fh8i6cbhv3d1md5qy7hhgdaj";
      system = "burgled-batteries-tests";
      asd = "burgled-batteries-tests";
    });
    systems = [ "burgled-batteries-tests" ];
    lispLibs = [ (getAttr "burgled-batteries" self) (getAttr "cl-quickcheck" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  burgled-batteries_dot_syntax = (build-asdf-system {
    pname = "burgled-batteries.syntax";
    version = "20210531-git";
    asds = [ "burgled-batteries.syntax" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/burgled-batteries.syntax/2021-05-31/burgled-batteries.syntax-20210531-git.tgz";
      sha256 = "1hx8w74cgx1qbk6r2p7lzygjqxs5mzxh7w73zrmdibny64akir9a";
      system = "burgled-batteries.syntax";
      asd = "burgled-batteries.syntax";
    });
    systems = [ "burgled-batteries.syntax" ];
    lispLibs = [ (getAttr "burgled-batteries" self) (getAttr "esrap" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  burgled-batteries_dot_syntax-test = (build-asdf-system {
    pname = "burgled-batteries.syntax-test";
    version = "20210531-git";
    asds = [ "burgled-batteries.syntax-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/burgled-batteries.syntax/2021-05-31/burgled-batteries.syntax-20210531-git.tgz";
      sha256 = "1hx8w74cgx1qbk6r2p7lzygjqxs5mzxh7w73zrmdibny64akir9a";
      system = "burgled-batteries.syntax-test";
      asd = "burgled-batteries.syntax-test";
    });
    systems = [ "burgled-batteries.syntax-test" ];
    lispLibs = [ (getAttr "burgled-batteries_dot_syntax" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bus = (build-asdf-system {
    pname = "bus";
    version = "master-5b2475f9-git";
    asds = [ "bus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/gendl/2023-06-18/gendl-master-5b2475f9-git.tgz";
      sha256 = "1w8xn2vg527g1s7cfhw669sdgbq1v5i927g00qzsq9di0syxvczg";
      system = "bus";
      asd = "bus";
    });
    systems = [ "bus" ];
    lispLibs = [ (getAttr "gwl-graphics" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bytecurry_dot_asdf-ext = (build-asdf-system {
    pname = "bytecurry.asdf-ext";
    version = "20150505-git";
    asds = [ "bytecurry.asdf-ext" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bytecurry.asdf-ext/2015-05-05/bytecurry.asdf-ext-20150505-git.tgz";
      sha256 = "07w2lz9mq35sgzzvmz9084l1sia40zkhlvfblkpzxfwyzr6cxrxa";
      system = "bytecurry.asdf-ext";
      asd = "bytecurry.asdf-ext";
    });
    systems = [ "bytecurry.asdf-ext" ];
    lispLibs = [ (getAttr "asdf-package-system" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  bytecurry_dot_mocks = (build-asdf-system {
    pname = "bytecurry.mocks";
    version = "20200325-git";
    asds = [ "bytecurry.mocks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/bytecurry.mocks/2020-03-25/bytecurry.mocks-20200325-git.tgz";
      sha256 = "0md2j6iggmfm1v7nzcmz7f0xy2jxrsg77iszpisdzmwnijfy8ks0";
      system = "bytecurry.mocks";
      asd = "bytecurry.mocks";
    });
    systems = [ "bytecurry.mocks" ];
    lispLibs = [ (getAttr "asdf-package-system" self) (getAttr "bytecurry_dot_asdf-ext" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  c2ffi-blob = (build-asdf-system {
    pname = "c2ffi-blob";
    version = "stable-git";
    asds = [ "c2ffi-blob" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/c2ffi-blob/2020-10-16/c2ffi-blob-stable-git.tgz";
      sha256 = "1rk89nycdvcb4a50zm3wdmrbz8w5xk4jgvjg2wib1dnslwnwdivc";
      system = "c2ffi-blob";
      asd = "c2ffi-blob";
    });
    systems = [ "c2ffi-blob" ];
    lispLibs = [ (getAttr "claw-support" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacau = (build-asdf-system {
    pname = "cacau";
    version = "20200610-git";
    asds = [ "cacau" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacau/2020-06-10/cacau-20200610-git.tgz";
      sha256 = "0m8v1xw68cr5ldv045rxgvnhigr4iahh7v6v32z6xlq2sj6r55x0";
      system = "cacau";
      asd = "cacau";
    });
    systems = [ "cacau" ];
    lispLibs = [ (getAttr "assertion-error" self) (getAttr "eventbus" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacau-asdf = (build-asdf-system {
    pname = "cacau-asdf";
    version = "20200610-git";
    asds = [ "cacau-asdf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacau/2020-06-10/cacau-20200610-git.tgz";
      sha256 = "0m8v1xw68cr5ldv045rxgvnhigr4iahh7v6v32z6xlq2sj6r55x0";
      system = "cacau-asdf";
      asd = "cacau-asdf";
    });
    systems = [ "cacau-asdf" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacau-examples-asdf-integration = (build-asdf-system {
    pname = "cacau-examples-asdf-integration";
    version = "20200610-git";
    asds = [ "cacau-examples-asdf-integration" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacau/2020-06-10/cacau-20200610-git.tgz";
      sha256 = "0m8v1xw68cr5ldv045rxgvnhigr4iahh7v6v32z6xlq2sj6r55x0";
      system = "cacau-examples-asdf-integration";
      asd = "cacau-examples-asdf-integration";
    });
    systems = [ "cacau-examples-asdf-integration" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacau-examples-asdf-integration-test = (build-asdf-system {
    pname = "cacau-examples-asdf-integration-test";
    version = "20200610-git";
    asds = [ "cacau-examples-asdf-integration-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacau/2020-06-10/cacau-20200610-git.tgz";
      sha256 = "0m8v1xw68cr5ldv045rxgvnhigr4iahh7v6v32z6xlq2sj6r55x0";
      system = "cacau-examples-asdf-integration-test";
      asd = "cacau-examples-asdf-integration-test";
    });
    systems = [ "cacau-examples-asdf-integration-test" ];
    lispLibs = [ (getAttr "assert-p" self) (getAttr "cacau" self) (getAttr "cacau-asdf" self) (getAttr "cacau-examples-asdf-integration" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacau-test = (build-asdf-system {
    pname = "cacau-test";
    version = "20200610-git";
    asds = [ "cacau-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacau/2020-06-10/cacau-20200610-git.tgz";
      sha256 = "0m8v1xw68cr5ldv045rxgvnhigr4iahh7v6v32z6xlq2sj6r55x0";
      system = "cacau-test";
      asd = "cacau-test";
    });
    systems = [ "cacau-test" ];
    lispLibs = [ (getAttr "assert-p" self) (getAttr "cacau" self) (getAttr "cacau-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cache-while = (build-asdf-system {
    pname = "cache-while";
    version = "20210807-git";
    asds = [ "cache-while" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cache-while/2021-08-07/cache-while-20210807-git.tgz";
      sha256 = "1qil68rfn5irmkb0jk1f6g1zy80wgc3skl8cr4rfgh7ywgm5izx3";
      system = "cache-while";
      asd = "cache-while";
    });
    systems = [ "cache-while" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cacle = (build-asdf-system {
    pname = "cacle";
    version = "20190521-git";
    asds = [ "cacle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cacle/2019-05-21/cacle-20190521-git.tgz";
      sha256 = "0h0dk0sfkfl8g0sbrs76ydb9l4znssqhx8nc5k1sg7zxpni5a4qy";
      system = "cacle";
      asd = "cacle";
    });
    systems = [ "cacle" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  calispel = (build-asdf-system {
    pname = "calispel";
    version = "20170830-git";
    asds = [ "calispel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/calispel/2017-08-30/calispel-20170830-git.tgz";
      sha256 = "08bmf3pi7n5hadpmqqkg65cxcj6kbvm997wcs1f53ml1nb79d9z8";
      system = "calispel";
      asd = "calispel";
    });
    systems = [ "calispel" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "jpl-queues" self) (getAttr "jpl-util" self) ];
    meta = {};
  });
  calispel-test = (build-asdf-system {
    pname = "calispel-test";
    version = "20170830-git";
    asds = [ "calispel-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/calispel/2017-08-30/calispel-20170830-git.tgz";
      sha256 = "08bmf3pi7n5hadpmqqkg65cxcj6kbvm997wcs1f53ml1nb79d9z8";
      system = "calispel-test";
      asd = "calispel";
    });
    systems = [ "calispel-test" ];
    lispLibs = [ (getAttr "calispel" self) (getAttr "eager-future2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cambl = (build-asdf-system {
    pname = "cambl";
    version = "20181210-git";
    asds = [ "cambl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cambl/2018-12-10/cambl-20181210-git.tgz";
      sha256 = "103mry04j2k9vznsxm7wcvccgxkil92cdrv52miwcmxl8daa4jiz";
      system = "cambl";
      asd = "cambl";
    });
    systems = [ "cambl" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-containers" self) (getAttr "fprog" self) (getAttr "local-time" self) (getAttr "periods" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cambl-test = (build-asdf-system {
    pname = "cambl-test";
    version = "20181210-git";
    asds = [ "cambl-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cambl/2018-12-10/cambl-20181210-git.tgz";
      sha256 = "103mry04j2k9vznsxm7wcvccgxkil92cdrv52miwcmxl8daa4jiz";
      system = "cambl-test";
      asd = "cambl-test";
    });
    systems = [ "cambl-test" ];
    lispLibs = [ (getAttr "cambl" self) (getAttr "xlunit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  camera-matrix = (build-asdf-system {
    pname = "camera-matrix";
    version = "20200427-git";
    asds = [ "camera-matrix" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/sucle/2020-04-27/sucle-20200427-git.tgz";
      sha256 = "033akkn9zxc6qdgycgxgybx3v23638245xrx29x2cbwnvg3i1q34";
      system = "camera-matrix";
      asd = "camera-matrix";
    });
    systems = [ "camera-matrix" ];
    lispLibs = [ (getAttr "nsb-cga" self) (getAttr "uncommon-lisp" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  can = (build-asdf-system {
    pname = "can";
    version = "20180328-git";
    asds = [ "can" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/can/2018-03-28/can-20180328-git.tgz";
      sha256 = "0m3lqc56aw46cj2z379a19fh7f1h0vaxn78xpvbxq3bwar46jzqh";
      system = "can";
      asd = "can";
    });
    systems = [ "can" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  can-test = (build-asdf-system {
    pname = "can-test";
    version = "20180328-git";
    asds = [ "can-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/can/2018-03-28/can-20180328-git.tgz";
      sha256 = "0m3lqc56aw46cj2z379a19fh7f1h0vaxn78xpvbxq3bwar46jzqh";
      system = "can-test";
      asd = "can-test";
    });
    systems = [ "can-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "can" self) (getAttr "mito" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  canonicalized-initargs = (build-asdf-system {
    pname = "canonicalized-initargs";
    version = "2.0";
    asds = [ "canonicalized-initargs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/canonicalized-initargs/2021-04-11/canonicalized-initargs_2.0.tgz";
      sha256 = "0jmmjw86x9mmlfla4kdmdqf1fjrj0p2fmv1lc4k555mcf67mj2fq";
      system = "canonicalized-initargs";
      asd = "canonicalized-initargs";
    });
    systems = [ "canonicalized-initargs" ];
    lispLibs = [ (getAttr "cesdi" self) (getAttr "closer-mop" self) (getAttr "compatible-metaclasses" self) (getAttr "enhanced-defclass" self) (getAttr "enhanced-typep" self) (getAttr "object-class" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  canonicalized-initargs__tests = (build-asdf-system {
    pname = "canonicalized-initargs_tests";
    version = "2.0";
    asds = [ "canonicalized-initargs_tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/canonicalized-initargs/2021-04-11/canonicalized-initargs_2.0.tgz";
      sha256 = "0jmmjw86x9mmlfla4kdmdqf1fjrj0p2fmv1lc4k555mcf67mj2fq";
      system = "canonicalized-initargs_tests";
      asd = "canonicalized-initargs_tests";
    });
    systems = [ "canonicalized-initargs_tests" ];
    lispLibs = [ (getAttr "canonicalized-initargs" self) (getAttr "enhanced-boolean" self) (getAttr "enhanced-eval-when" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  capstone = (build-asdf-system {
    pname = "capstone";
    version = "20220331-git";
    asds = [ "capstone" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-capstone/2022-03-31/cl-capstone-20220331-git.tgz";
      sha256 = "1jbhp1sf7mr6yrqkdyjl93m1dl901ka6gkgdj20nv2bgp400ycmp";
      system = "capstone";
      asd = "capstone";
    });
    systems = [ "capstone" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "gt" self) (getAttr "static-vectors" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caramel = (build-asdf-system {
    pname = "caramel";
    version = "20130420-git";
    asds = [ "caramel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caramel/2013-04-20/caramel-20130420-git.tgz";
      sha256 = "08kyjxd8hyk5xnnq0p0w4aqpvisv278h38pqjkz04a032dn5b87a";
      system = "caramel";
      asd = "caramel";
    });
    systems = [ "caramel" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "buildnode" self) (getAttr "closure-html" self) (getAttr "css-selectors" self) (getAttr "cxml" self) (getAttr "cxml-dom" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cardioex = (build-asdf-system {
    pname = "cardioex";
    version = "20211020-git";
    asds = [ "cardioex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cardiogram/2021-10-20/cardiogram-20211020-git.tgz";
      sha256 = "08kqcj3c4vkx5s6ba9m67xh7w7paaavp2ds072crp1x7pjkh4n5i";
      system = "cardioex";
      asd = "cardioex";
    });
    systems = [ "cardioex" ];
    lispLibs = [ (getAttr "cardiogram" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cardiogram = (build-asdf-system {
    pname = "cardiogram";
    version = "20211020-git";
    asds = [ "cardiogram" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cardiogram/2021-10-20/cardiogram-20211020-git.tgz";
      sha256 = "08kqcj3c4vkx5s6ba9m67xh7w7paaavp2ds072crp1x7pjkh4n5i";
      system = "cardiogram";
      asd = "cardiogram";
    });
    systems = [ "cardiogram" ];
    lispLibs = [ (getAttr "cl-annot" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cari3s = (build-asdf-system {
    pname = "cari3s";
    version = "20230618-git";
    asds = [ "cari3s" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cari3s/2023-06-18/cari3s-20230618-git.tgz";
      sha256 = "1flfb606fm61bnng47qhrksjsg70wsgszq1bxac9h8vix7mpc5jk";
      system = "cari3s";
      asd = "cari3s";
    });
    systems = [ "cari3s" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "closer-mop" self) (getAttr "com_dot_inuoe_dot_jzon" self) (getAttr "documentation-utils" self) (getAttr "drakma" self) (getAttr "pango-markup" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  carrier = (build-asdf-system {
    pname = "carrier";
    version = "20181210-git";
    asds = [ "carrier" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/carrier/2018-12-10/carrier-20181210-git.tgz";
      sha256 = "1xry7alc9x86y1g5k417vhvlgkwgfrl80zpsyfdwdsz7hrwff41d";
      system = "carrier";
      asd = "carrier";
    });
    systems = [ "carrier" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "blackbird" self) (getAttr "cl-async" self) (getAttr "cl-async-ssl" self) (getAttr "cl-cookie" self) (getAttr "fast-http" self) (getAttr "fast-io" self) (getAttr "quri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cartesian-product-switch = (build-asdf-system {
    pname = "cartesian-product-switch";
    version = "2.0";
    asds = [ "cartesian-product-switch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cartesian-product-switch/2012-09-09/cartesian-product-switch-2.0.tgz";
      sha256 = "18cxslj2753k6h666j0mmzg0h0z9l6ddi24gqls6h5d5svd7l3xk";
      system = "cartesian-product-switch";
      asd = "cartesian-product-switch";
    });
    systems = [ "cartesian-product-switch" ];
    lispLibs = [ (getAttr "map-bind" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman-middleware-dbimanager = (build-asdf-system {
    pname = "caveman-middleware-dbimanager";
    version = "20221106-git";
    asds = [ "caveman-middleware-dbimanager" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman/2022-11-06/caveman-20221106-git.tgz";
      sha256 = "041i1g78cn6mjv8ba4bylw57f3px2rp5a0jnj17rwkfhfcvc76md";
      system = "caveman-middleware-dbimanager";
      asd = "caveman-middleware-dbimanager";
    });
    systems = [ "caveman-middleware-dbimanager" ];
    lispLibs = [ (getAttr "dbi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2 = (build-asdf-system {
    pname = "caveman2";
    version = "20221106-git";
    asds = [ "caveman2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman/2022-11-06/caveman-20221106-git.tgz";
      sha256 = "041i1g78cn6mjv8ba4bylw57f3px2rp5a0jnj17rwkfhfcvc76md";
      system = "caveman2";
      asd = "caveman2";
    });
    systems = [ "caveman2" ];
    lispLibs = [ (getAttr "cl-project" self) (getAttr "cl-syntax-annot" self) (getAttr "dbi" self) (getAttr "lack-request" self) (getAttr "lack-response" self) (getAttr "myway" self) (getAttr "ningle" self) (getAttr "quri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-db = (build-asdf-system {
    pname = "caveman2-db";
    version = "20221106-git";
    asds = [ "caveman2-db" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman/2022-11-06/caveman-20221106-git.tgz";
      sha256 = "041i1g78cn6mjv8ba4bylw57f3px2rp5a0jnj17rwkfhfcvc76md";
      system = "caveman2-db";
      asd = "caveman2-db";
    });
    systems = [ "caveman2-db" ];
    lispLibs = [ (getAttr "caveman-middleware-dbimanager" self) (getAttr "dbi" self) (getAttr "sxql" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-test = (build-asdf-system {
    pname = "caveman2-test";
    version = "20221106-git";
    asds = [ "caveman2-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman/2022-11-06/caveman-20221106-git.tgz";
      sha256 = "041i1g78cn6mjv8ba4bylw57f3px2rp5a0jnj17rwkfhfcvc76md";
      system = "caveman2-test";
      asd = "caveman2-test";
    });
    systems = [ "caveman2-test" ];
    lispLibs = [ (getAttr "caveman2" self) (getAttr "dexador" self) (getAttr "lack-component" self) (getAttr "prove" self) (getAttr "prove-asdf" self) (getAttr "trivial-types" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-widgets = (build-asdf-system {
    pname = "caveman2-widgets";
    version = "20180228-git";
    asds = [ "caveman2-widgets" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman2-widgets/2018-02-28/caveman2-widgets-20180228-git.tgz";
      sha256 = "1rzb868m3f28z1hcr3nzlprgqqq1kwg3qyh24p36fv76b4g96wkq";
      system = "caveman2-widgets";
      asd = "caveman2-widgets";
    });
    systems = [ "caveman2-widgets" ];
    lispLibs = [ (getAttr "caveman2" self) (getAttr "moptilities" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-widgets-bootstrap = (build-asdf-system {
    pname = "caveman2-widgets-bootstrap";
    version = "20180228-git";
    asds = [ "caveman2-widgets-bootstrap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman2-widgets-bootstrap/2018-02-28/caveman2-widgets-bootstrap-20180228-git.tgz";
      sha256 = "1xh3x7r7givxxyrkh4ngx098s35qz98gcz7yjyf4dp0psfkk65xj";
      system = "caveman2-widgets-bootstrap";
      asd = "caveman2-widgets-bootstrap";
    });
    systems = [ "caveman2-widgets-bootstrap" ];
    lispLibs = [ (getAttr "caveman2" self) (getAttr "caveman2-widgets" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-widgets-bootstrap-test = (build-asdf-system {
    pname = "caveman2-widgets-bootstrap-test";
    version = "20180228-git";
    asds = [ "caveman2-widgets-bootstrap-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman2-widgets-bootstrap/2018-02-28/caveman2-widgets-bootstrap-20180228-git.tgz";
      sha256 = "1xh3x7r7givxxyrkh4ngx098s35qz98gcz7yjyf4dp0psfkk65xj";
      system = "caveman2-widgets-bootstrap-test";
      asd = "caveman2-widgets-bootstrap-test";
    });
    systems = [ "caveman2-widgets-bootstrap-test" ];
    lispLibs = [ (getAttr "caveman2-widgets-bootstrap" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  caveman2-widgets-test = (build-asdf-system {
    pname = "caveman2-widgets-test";
    version = "20180228-git";
    asds = [ "caveman2-widgets-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/caveman2-widgets/2018-02-28/caveman2-widgets-20180228-git.tgz";
      sha256 = "1rzb868m3f28z1hcr3nzlprgqqq1kwg3qyh24p36fv76b4g96wkq";
      system = "caveman2-widgets-test";
      asd = "caveman2-widgets-test";
    });
    systems = [ "caveman2-widgets-test" ];
    lispLibs = [ (getAttr "caveman2-widgets" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cblas = (build-asdf-system {
    pname = "cblas";
    version = "20221106-git";
    asds = [ "cblas" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cblas/2022-11-06/cl-cblas-20221106-git.tgz";
      sha256 = "1bd2w51r71pgm6sc6m2fms4j1bbnli023j4w3rbxw9cln0g7badp";
      system = "cblas";
      asd = "cblas";
    });
    systems = [ "cblas" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-autowrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ccl-compat = (build-asdf-system {
    pname = "ccl-compat";
    version = "20171130-git";
    asds = [ "ccl-compat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ccl-compat/2017-11-30/ccl-compat-20171130-git.tgz";
      sha256 = "15402373wprmyx4l7zgpv64vj3c11xvxnnpzqbmq4j6rljpb40da";
      system = "ccl-compat";
      asd = "ccl-compat";
    });
    systems = [ "ccl-compat" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ccldoc = (build-asdf-system {
    pname = "ccldoc";
    version = "20200427-git";
    asds = [ "ccldoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ccldoc/2020-04-27/ccldoc-20200427-git.tgz";
      sha256 = "0pxjk07drvxrk65g46lbpz2y0xgxgn04k6yvirl0hk2dry0myinp";
      system = "ccldoc";
      asd = "ccldoc";
    });
    systems = [ "ccldoc" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "ccl-compat" self) (getAttr "cl-who" self) (getAttr "s-xml" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ccldoc-libraries = (build-asdf-system {
    pname = "ccldoc-libraries";
    version = "20200427-git";
    asds = [ "ccldoc-libraries" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ccldoc/2020-04-27/ccldoc-20200427-git.tgz";
      sha256 = "0pxjk07drvxrk65g46lbpz2y0xgxgn04k6yvirl0hk2dry0myinp";
      system = "ccldoc-libraries";
      asd = "ccldoc-libraries";
    });
    systems = [ "ccldoc-libraries" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "s-xml" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cells = (build-asdf-system {
    pname = "cells";
    version = "20230618-git";
    asds = [ "cells" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cells/2023-06-18/cells-20230618-git.tgz";
      sha256 = "1mh14g8x2mpb8qdngqxgnkawqbv4xxxr3bgn01jm5d6c8jn6ph3f";
      system = "cells";
      asd = "cells";
    });
    systems = [ "cells" ];
    lispLibs = [ (getAttr "utils-kt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cells-test = (build-asdf-system {
    pname = "cells-test";
    version = "20230618-git";
    asds = [ "cells-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cells/2023-06-18/cells-20230618-git.tgz";
      sha256 = "1mh14g8x2mpb8qdngqxgnkawqbv4xxxr3bgn01jm5d6c8jn6ph3f";
      system = "cells-test";
      asd = "cells-test";
    });
    systems = [ "cells-test" ];
    lispLibs = [ (getAttr "cells" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cephes = (build-asdf-system {
    pname = "cephes";
    version = "20221106-git";
    asds = [ "cephes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cephes.cl/2022-11-06/cephes.cl-20221106-git.tgz";
      sha256 = "07krprq23i9ncdkdq69lsvzswshhrfmjds4sk1kgicjxhm37l25h";
      system = "cephes";
      asd = "cephes";
    });
    systems = [ "cephes" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl = (build-asdf-system {
    pname = "cepl";
    version = "release-quicklisp-d1a10b6c-git";
    asds = [ "cepl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl/2021-02-28/cepl-release-quicklisp-d1a10b6c-git.tgz";
      sha256 = "0izbw2advqm3wailj3dpq6zqfrfirwn14pw5qmqh8i71r51xwmm2";
      system = "cepl";
      asd = "cepl";
    });
    systems = [ "cepl" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cepl_dot_build" self) (getAttr "cffi" self) (getAttr "cl-opengl" self) (getAttr "cl-ppcre" self) (getAttr "documentation-utils" self) (getAttr "float-features" self) (getAttr "ieee-floats" self) (getAttr "split-sequence" self) (getAttr "varjo" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_build = (build-asdf-system {
    pname = "cepl.build";
    version = "release-quicklisp-d1a10b6c-git";
    asds = [ "cepl.build" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl/2021-02-28/cepl-release-quicklisp-d1a10b6c-git.tgz";
      sha256 = "0izbw2advqm3wailj3dpq6zqfrfirwn14pw5qmqh8i71r51xwmm2";
      system = "cepl.build";
      asd = "cepl.build";
    });
    systems = [ "cepl.build" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_camera = (build-asdf-system {
    pname = "cepl.camera";
    version = "release-quicklisp-1292212a-git";
    asds = [ "cepl.camera" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.camera/2018-02-28/cepl.camera-release-quicklisp-1292212a-git.tgz";
      sha256 = "0z73f95bxr2vn47g8qrvf9gzy1my25mkg7hl7kpib21yahfpzzvb";
      system = "cepl.camera";
      asd = "cepl.camera";
    });
    systems = [ "cepl.camera" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "cepl_dot_spaces" self) (getAttr "rtg-math" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_devil = (build-asdf-system {
    pname = "cepl.devil";
    version = "release-quicklisp-ea5f8514-git";
    asds = [ "cepl.devil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.devil/2018-02-28/cepl.devil-release-quicklisp-ea5f8514-git.tgz";
      sha256 = "1b64vfjchkwppcp3j4krwx2x9nj29llisqy1yc9ncbnmi9xs38a0";
      system = "cepl.devil";
      asd = "cepl.devil";
    });
    systems = [ "cepl.devil" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "cl-devil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_drm-gbm = (build-asdf-system {
    pname = "cepl.drm-gbm";
    version = "20190521-git";
    asds = [ "cepl.drm-gbm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.drm-gbm/2019-05-21/cepl.drm-gbm-20190521-git.tgz";
      sha256 = "00csd2f6z13rjqipaf02w87phn2xynmzf1jcrrshbibs204m4nmy";
      system = "cepl.drm-gbm";
      asd = "cepl.drm-gbm";
    });
    systems = [ "cepl.drm-gbm" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "cl-drm" self) (getAttr "cl-egl" self) (getAttr "cl-gbm" self) (getAttr "osicat" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_glop = (build-asdf-system {
    pname = "cepl.glop";
    version = "release-quicklisp-8ec09801-git";
    asds = [ "cepl.glop" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.glop/2018-02-28/cepl.glop-release-quicklisp-8ec09801-git.tgz";
      sha256 = "1dq727v2s22yna6ycxxs79pg13b0cyh1lfrk6hsb6vizgiks20jw";
      system = "cepl.glop";
      asd = "cepl.glop";
    });
    systems = [ "cepl.glop" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "glop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_sdl2 = (build-asdf-system {
    pname = "cepl.sdl2";
    version = "release-quicklisp-6da5a030-git";
    asds = [ "cepl.sdl2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.sdl2/2018-02-28/cepl.sdl2-release-quicklisp-6da5a030-git.tgz";
      sha256 = "0lz8yxm1g2ch0w779lhrs2xkfciy3iz6viz7cdgyd2824isvinjf";
      system = "cepl.sdl2";
      asd = "cepl.sdl2";
    });
    systems = [ "cepl.sdl2" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "sdl2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_sdl2-image = (build-asdf-system {
    pname = "cepl.sdl2-image";
    version = "release-quicklisp-94a77649-git";
    asds = [ "cepl.sdl2-image" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.sdl2-image/2018-02-28/cepl.sdl2-image-release-quicklisp-94a77649-git.tgz";
      sha256 = "16dzjk2q658xr1v9rk2iny70rjhxbgi4lcp59s5mkdfs2k3a2637";
      system = "cepl.sdl2-image";
      asd = "cepl.sdl2-image";
    });
    systems = [ "cepl.sdl2-image" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "sdl2" self) (getAttr "sdl2-image" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_sdl2-ttf = (build-asdf-system {
    pname = "cepl.sdl2-ttf";
    version = "release-quicklisp-11b498a3-git";
    asds = [ "cepl.sdl2-ttf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.sdl2-ttf/2018-01-31/cepl.sdl2-ttf-release-quicklisp-11b498a3-git.tgz";
      sha256 = "1fxj3rdv2rlyks00h18dpd42xywgnydgyvb1s4d67hjk7fl19a5p";
      system = "cepl.sdl2-ttf";
      asd = "cepl.sdl2-ttf";
    });
    systems = [ "cepl.sdl2-ttf" ];
    lispLibs = [ (getAttr "cepl_dot_sdl2" self) (getAttr "rtg-math" self) (getAttr "sdl2-ttf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_skitter_dot_glop = (build-asdf-system {
    pname = "cepl.skitter.glop";
    version = "release-quicklisp-f52b9240-git";
    asds = [ "cepl.skitter.glop" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.skitter/2018-02-28/cepl.skitter-release-quicklisp-f52b9240-git.tgz";
      sha256 = "1xz53q8klzrd7cr586jd16pypxgpy68vlvfirqhlv6jc7k99sjvs";
      system = "cepl.skitter.glop";
      asd = "cepl.skitter.glop";
    });
    systems = [ "cepl.skitter.glop" ];
    lispLibs = [ (getAttr "cepl_dot_glop" self) (getAttr "skitter_dot_glop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_skitter_dot_sdl2 = (build-asdf-system {
    pname = "cepl.skitter.sdl2";
    version = "release-quicklisp-f52b9240-git";
    asds = [ "cepl.skitter.sdl2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.skitter/2018-02-28/cepl.skitter-release-quicklisp-f52b9240-git.tgz";
      sha256 = "1xz53q8klzrd7cr586jd16pypxgpy68vlvfirqhlv6jc7k99sjvs";
      system = "cepl.skitter.sdl2";
      asd = "cepl.skitter.sdl2";
    });
    systems = [ "cepl.skitter.sdl2" ];
    lispLibs = [ (getAttr "cepl_dot_sdl2" self) (getAttr "skitter_dot_sdl2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cepl_dot_spaces = (build-asdf-system {
    pname = "cepl.spaces";
    version = "release-quicklisp-c7f83f26-git";
    asds = [ "cepl.spaces" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cepl.spaces/2018-03-28/cepl.spaces-release-quicklisp-c7f83f26-git.tgz";
      sha256 = "0z74ipd4j2spjwl6h625azdczpds3v44iin77q685ldx9rwx3k8y";
      system = "cepl.spaces";
      asd = "cepl.spaces";
    });
    systems = [ "cepl.spaces" ];
    lispLibs = [ (getAttr "cepl" self) (getAttr "documentation-utils" self) (getAttr "fn" self) (getAttr "rtg-math" self) (getAttr "rtg-math_dot_vari" self) (getAttr "varjo" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ceramic = (build-asdf-system {
    pname = "ceramic";
    version = "20210807-git";
    asds = [ "ceramic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ceramic/2021-08-07/ceramic-20210807-git.tgz";
      sha256 = "0hd553gj4cwmli45pfwhqpz7sg6kzn31iv8akaxr5ba3hssa1aap";
      system = "ceramic";
      asd = "ceramic";
    });
    systems = [ "ceramic" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "clack-handler-hunchentoot" self) (getAttr "copy-directory" self) (getAttr "electron-tools" self) (getAttr "external-program" self) (getAttr "remote-js" self) (getAttr "trivial-build" self) (getAttr "trivial-compress" self) (getAttr "trivial-download" self) (getAttr "trivial-exe" self) (getAttr "trivial-extract" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ceramic-test-app = (build-asdf-system {
    pname = "ceramic-test-app";
    version = "20210807-git";
    asds = [ "ceramic-test-app" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ceramic/2021-08-07/ceramic-20210807-git.tgz";
      sha256 = "0hd553gj4cwmli45pfwhqpz7sg6kzn31iv8akaxr5ba3hssa1aap";
      system = "ceramic-test-app";
      asd = "ceramic-test-app";
    });
    systems = [ "ceramic-test-app" ];
    lispLibs = [ (getAttr "ceramic" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cerberus = (build-asdf-system {
    pname = "cerberus";
    version = "20221106-git";
    asds = [ "cerberus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cerberus/2022-11-06/cerberus-20221106-git.tgz";
      sha256 = "04yi0wqykx5v8drdw7ln382gxdklv60mg4aqrxg2j5wlsyacs0kb";
      system = "cerberus";
      asd = "cerberus";
    });
    systems = [ "cerberus" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "flexi-streams" self) (getAttr "glass" self) (getAttr "ironclad" self) (getAttr "nibbles" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cerberus-kdc = (build-asdf-system {
    pname = "cerberus-kdc";
    version = "20221106-git";
    asds = [ "cerberus-kdc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cerberus/2022-11-06/cerberus-20221106-git.tgz";
      sha256 = "04yi0wqykx5v8drdw7ln382gxdklv60mg4aqrxg2j5wlsyacs0kb";
      system = "cerberus-kdc";
      asd = "cerberus";
    });
    systems = [ "cerberus-kdc" ];
    lispLibs = [ (getAttr "cerberus" self) (getAttr "frpc" self) (getAttr "pounds" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cesdi = (build-asdf-system {
    pname = "cesdi";
    version = "1.0.1";
    asds = [ "cesdi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cesdi/2020-07-15/cesdi_1.0.1.tgz";
      sha256 = "02f2pz5rw79ljkkx1ywh8nkpjj4g3z3s1lyvzqb8krbnx11wl0q9";
      system = "cesdi";
      asd = "cesdi";
    });
    systems = [ "cesdi" ];
    lispLibs = [ (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cesdi__tests = (build-asdf-system {
    pname = "cesdi_tests";
    version = "1.0.1";
    asds = [ "cesdi_tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cesdi/2020-07-15/cesdi_1.0.1.tgz";
      sha256 = "02f2pz5rw79ljkkx1ywh8nkpjj4g3z3s1lyvzqb8krbnx11wl0q9";
      system = "cesdi_tests";
      asd = "cesdi_tests";
    });
    systems = [ "cesdi_tests" ];
    lispLibs = [ (getAttr "cesdi" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cffi = (build-asdf-system {
    pname = "cffi";
    version = "20230618-git";
    asds = [ "cffi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi";
      asd = "cffi";
    });
    systems = [ "cffi" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "trivial-features" self) ];
    meta = {};
  });
  cffi-c-ref = (build-asdf-system {
    pname = "cffi-c-ref";
    version = "stable-git";
    asds = [ "cffi-c-ref" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi-c-ref/2020-10-16/cffi-c-ref-stable-git.tgz";
      sha256 = "1a3pp6xcisabqir3rp1gvvjfdxcvpm8yr35p38nri9azsinmmc7z";
      system = "cffi-c-ref";
      asd = "cffi-c-ref";
    });
    systems = [ "cffi-c-ref" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cffi-examples = (build-asdf-system {
    pname = "cffi-examples";
    version = "20230618-git";
    asds = [ "cffi-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-examples";
      asd = "cffi-examples";
    });
    systems = [ "cffi-examples" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cffi-grovel = (build-asdf-system {
    pname = "cffi-grovel";
    version = "20230618-git";
    asds = [ "cffi-grovel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-grovel";
      asd = "cffi-grovel";
    });
    systems = [ "cffi-grovel" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-toolchain" self) ];
    meta = {};
  });
  cffi-libffi = (build-asdf-system {
    pname = "cffi-libffi";
    version = "20230618-git";
    asds = [ "cffi-libffi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-libffi";
      asd = "cffi-libffi";
    });
    systems = [ "cffi-libffi" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cffi-tests = (build-asdf-system {
    pname = "cffi-tests";
    version = "20230618-git";
    asds = [ "cffi-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-tests";
      asd = "cffi-tests";
    });
    systems = [ "cffi-tests" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi-grovel" self) (getAttr "cffi-libffi" self) (getAttr "rt" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cffi-toolchain = (build-asdf-system {
    pname = "cffi-toolchain";
    version = "20230618-git";
    asds = [ "cffi-toolchain" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-toolchain";
      asd = "cffi-toolchain";
    });
    systems = [ "cffi-toolchain" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {};
  });
  cffi-uffi-compat = (build-asdf-system {
    pname = "cffi-uffi-compat";
    version = "20230618-git";
    asds = [ "cffi-uffi-compat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cffi/2023-06-18/cffi-20230618-git.tgz";
      sha256 = "0kjcfkpj31qqbnri23rcbp41f3b5m3cdp630prhb37wiyy3ascyz";
      system = "cffi-uffi-compat";
      asd = "cffi-uffi-compat";
    });
    systems = [ "cffi-uffi-compat" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {};
  });
  chain = (build-asdf-system {
    pname = "chain";
    version = "20211209-git";
    asds = [ "chain" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chain/2021-12-09/chain-20211209-git.tgz";
      sha256 = "0x8b2cbp1xq61fpbk0mqwbksnfynlgai3782rafsywka8rgfhmjh";
      system = "chain";
      asd = "chain";
    });
    systems = [ "chain" ];
    lispLibs = [ (getAttr "metabang-bind" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chameleon = (build-asdf-system {
    pname = "chameleon";
    version = "v2.1.1";
    asds = [ "chameleon" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chameleon/2022-02-20/chameleon-v2.1.1.tgz";
      sha256 = "1bqminvhx3hlqzxvy2a105gm9d2dxl5cy6ls5rm9wmkvw7gyza6c";
      system = "chameleon";
      asd = "chameleon";
    });
    systems = [ "chameleon" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chancery = (build-asdf-system {
    pname = "chancery";
    version = "20201016-hg";
    asds = [ "chancery" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chancery/2020-10-16/chancery-20201016-hg.tgz";
      sha256 = "1g0jgrih7q14gizy481j9z2s15pmv6iwymnpddbyqfja9miv61lw";
      system = "chancery";
      asd = "chancery";
    });
    systems = [ "chancery" ];
    lispLibs = [ (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chancery_dot_test = (build-asdf-system {
    pname = "chancery.test";
    version = "20201016-hg";
    asds = [ "chancery.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chancery/2020-10-16/chancery-20201016-hg.tgz";
      sha256 = "1g0jgrih7q14gizy481j9z2s15pmv6iwymnpddbyqfja9miv61lw";
      system = "chancery.test";
      asd = "chancery.test";
    });
    systems = [ "chancery.test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "chancery" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  changed-stream = (build-asdf-system {
    pname = "changed-stream";
    version = "20130128-git";
    asds = [ "changed-stream" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/changed-stream/2013-01-28/changed-stream-20130128-git.tgz";
      sha256 = "1cll7xclg9jr55swhi3g6z567bxvb9kmljh67091xazcfacz732i";
      system = "changed-stream";
      asd = "changed-stream";
    });
    systems = [ "changed-stream" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  changed-stream_dot_test = (build-asdf-system {
    pname = "changed-stream.test";
    version = "20130128-git";
    asds = [ "changed-stream.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/changed-stream/2013-01-28/changed-stream-20130128-git.tgz";
      sha256 = "1cll7xclg9jr55swhi3g6z567bxvb9kmljh67091xazcfacz732i";
      system = "changed-stream.test";
      asd = "changed-stream.test";
    });
    systems = [ "changed-stream.test" ];
    lispLibs = [ (getAttr "changed-stream" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chanl = (build-asdf-system {
    pname = "chanl";
    version = "20230618-git";
    asds = [ "chanl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chanl/2023-06-18/chanl-20230618-git.tgz";
      sha256 = "1z9lh7yqkbd5cn2zk5jwrlx1cz1mcz3mrk19wpjxi04x681ib1j5";
      system = "chanl";
      asd = "chanl";
    });
    systems = [ "chanl" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {};
  });
  character-modifier-bits = (build-asdf-system {
    pname = "character-modifier-bits";
    version = "20200427-git";
    asds = [ "character-modifier-bits" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/sucle/2020-04-27/sucle-20200427-git.tgz";
      sha256 = "033akkn9zxc6qdgycgxgybx3v23638245xrx29x2cbwnvg3i1q34";
      system = "character-modifier-bits";
      asd = "character-modifier-bits";
    });
    systems = [ "character-modifier-bits" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cheat-js = (build-asdf-system {
    pname = "cheat-js";
    version = "20121013-git";
    asds = [ "cheat-js" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cheat-js/2012-10-13/cheat-js-20121013-git.tgz";
      sha256 = "1h73kx0iii4y4gslz6f8kvf980bnypsras6xj38apm0fcwm93w03";
      system = "cheat-js";
      asd = "cheat-js";
    });
    systems = [ "cheat-js" ];
    lispLibs = [ (getAttr "cl-uglify-js" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  check-bnf = (build-asdf-system {
    pname = "check-bnf";
    version = "20220707-git";
    asds = [ "check-bnf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/check-bnf/2022-07-07/check-bnf-20220707-git.tgz";
      sha256 = "1dpp0xzj51a7fg9yw0xsipnsa54xj1axvkk55n0yxq9yv9ih3rb0";
      system = "check-bnf";
      asd = "check-bnf";
    });
    systems = [ "check-bnf" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "jingoh_dot_documentizer" self) (getAttr "matrix-case" self) (getAttr "millet" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  check-bnf_dot_test = (build-asdf-system {
    pname = "check-bnf.test";
    version = "20220707-git";
    asds = [ "check-bnf.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/check-bnf/2022-07-07/check-bnf-20220707-git.tgz";
      sha256 = "1dpp0xzj51a7fg9yw0xsipnsa54xj1axvkk55n0yxq9yv9ih3rb0";
      system = "check-bnf.test";
      asd = "check-bnf.test";
    });
    systems = [ "check-bnf.test" ];
    lispLibs = [ (getAttr "check-bnf" self) (getAttr "jingoh" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  check-it = (build-asdf-system {
    pname = "check-it";
    version = "20150709-git";
    asds = [ "check-it" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/check-it/2015-07-09/check-it-20150709-git.tgz";
      sha256 = "1kbjwpniffdpv003igmlz5r0vy65m7wpfnhg54fhwirp1227hgg7";
      system = "check-it";
      asd = "check-it";
    });
    systems = [ "check-it" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "optima" self) ];
    meta = {};
  });
  check-it-test = (build-asdf-system {
    pname = "check-it-test";
    version = "20150709-git";
    asds = [ "check-it-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/check-it/2015-07-09/check-it-20150709-git.tgz";
      sha256 = "1kbjwpniffdpv003igmlz5r0vy65m7wpfnhg54fhwirp1227hgg7";
      system = "check-it-test";
      asd = "check-it";
    });
    systems = [ "check-it-test" ];
    lispLibs = [ (getAttr "check-it" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  checkl = (build-asdf-system {
    pname = "checkl";
    version = "20180328-git";
    asds = [ "checkl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/checkl/2018-03-28/checkl-20180328-git.tgz";
      sha256 = "0bpisihx1gay44xmyr1dmhlwh00j0zzi04rp9fy35i95l2r4xdlx";
      system = "checkl";
      asd = "checkl";
    });
    systems = [ "checkl" ];
    lispLibs = [ (getAttr "marshal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  checkl-docs = (build-asdf-system {
    pname = "checkl-docs";
    version = "20180328-git";
    asds = [ "checkl-docs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/checkl/2018-03-28/checkl-20180328-git.tgz";
      sha256 = "0bpisihx1gay44xmyr1dmhlwh00j0zzi04rp9fy35i95l2r4xdlx";
      system = "checkl-docs";
      asd = "checkl-docs";
    });
    systems = [ "checkl-docs" ];
    lispLibs = [ (getAttr "checkl" self) (getAttr "cl-gendoc" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  checkl-test = (build-asdf-system {
    pname = "checkl-test";
    version = "20180328-git";
    asds = [ "checkl-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/checkl/2018-03-28/checkl-20180328-git.tgz";
      sha256 = "0bpisihx1gay44xmyr1dmhlwh00j0zzi04rp9fy35i95l2r4xdlx";
      system = "checkl-test";
      asd = "checkl-test";
    });
    systems = [ "checkl-test" ];
    lispLibs = [ (getAttr "checkl" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chemical-compounds = (build-asdf-system {
    pname = "chemical-compounds";
    version = "1.0.2";
    asds = [ "chemical-compounds" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chemical-compounds/2011-10-01/chemical-compounds-1.0.2.tgz";
      sha256 = "047z1lab08y4nsb32rnzqfpb6akyhibzjgmmr1bnwrh9pmhv3s2k";
      system = "chemical-compounds";
      asd = "chemical-compounds";
    });
    systems = [ "chemical-compounds" ];
    lispLibs = [ (getAttr "periodic-table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chillax = (build-asdf-system {
    pname = "chillax";
    version = "20150302-git";
    asds = [ "chillax" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chillax/2015-03-02/chillax-20150302-git.tgz";
      sha256 = "1is3qm68wyfi3rmpn8mw0x9861951a2w60snsdippikygm3smzr1";
      system = "chillax";
      asd = "chillax";
    });
    systems = [ "chillax" ];
    lispLibs = [ (getAttr "chillax_dot_core" self) (getAttr "chillax_dot_yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chillax_dot_core = (build-asdf-system {
    pname = "chillax.core";
    version = "20150302-git";
    asds = [ "chillax.core" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chillax/2015-03-02/chillax-20150302-git.tgz";
      sha256 = "1is3qm68wyfi3rmpn8mw0x9861951a2w60snsdippikygm3smzr1";
      system = "chillax.core";
      asd = "chillax.core";
    });
    systems = [ "chillax.core" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chillax_dot_jsown = (build-asdf-system {
    pname = "chillax.jsown";
    version = "20150302-git";
    asds = [ "chillax.jsown" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chillax/2015-03-02/chillax-20150302-git.tgz";
      sha256 = "1is3qm68wyfi3rmpn8mw0x9861951a2w60snsdippikygm3smzr1";
      system = "chillax.jsown";
      asd = "chillax.jsown";
    });
    systems = [ "chillax.jsown" ];
    lispLibs = [ (getAttr "chillax_dot_core" self) (getAttr "jsown" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chillax_dot_view-server = (build-asdf-system {
    pname = "chillax.view-server";
    version = "20150302-git";
    asds = [ "chillax.view-server" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chillax/2015-03-02/chillax-20150302-git.tgz";
      sha256 = "1is3qm68wyfi3rmpn8mw0x9861951a2w60snsdippikygm3smzr1";
      system = "chillax.view-server";
      asd = "chillax.view-server";
    });
    systems = [ "chillax.view-server" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chillax_dot_yason = (build-asdf-system {
    pname = "chillax.yason";
    version = "20150302-git";
    asds = [ "chillax.yason" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chillax/2015-03-02/chillax-20150302-git.tgz";
      sha256 = "1is3qm68wyfi3rmpn8mw0x9861951a2w60snsdippikygm3smzr1";
      system = "chillax.yason";
      asd = "chillax.yason";
    });
    systems = [ "chillax.yason" ];
    lispLibs = [ (getAttr "chillax_dot_core" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chipmunk-blob = (build-asdf-system {
    pname = "chipmunk-blob";
    version = "stable-git";
    asds = [ "chipmunk-blob" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chipmunk-blob/2020-10-16/chipmunk-blob-stable-git.tgz";
      sha256 = "0kdi1al1cn90hzjfnjhkxp3k5ibp6l73k3m04mkpzkzpjy7jc80d";
      system = "chipmunk-blob";
      asd = "chipmunk-blob";
    });
    systems = [ "chipmunk-blob" ];
    lispLibs = [ (getAttr "bodge-blobs-support" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chipz = (build-asdf-system {
    pname = "chipz";
    version = "20230618-git";
    asds = [ "chipz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chipz/2023-06-18/chipz-20230618-git.tgz";
      sha256 = "04ysl1lz47dd8p1cbm637kpyf84hl74xvcdpqhdyxwh4n97csm5h";
      system = "chipz";
      asd = "chipz";
    });
    systems = [ "chipz" ];
    lispLibs = [  ];
    meta = {};
  });
  chirp = (build-asdf-system {
    pname = "chirp";
    version = "20230618-git";
    asds = [ "chirp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chirp/2023-06-18/chirp-20230618-git.tgz";
      sha256 = "0714qqzac0kqhmqx9q9361l48n9hq3wjl15m91vvzy9fn7nghj93";
      system = "chirp";
      asd = "chirp";
    });
    systems = [ "chirp" ];
    lispLibs = [ (getAttr "chirp-drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chirp-core = (build-asdf-system {
    pname = "chirp-core";
    version = "20230618-git";
    asds = [ "chirp-core" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chirp/2023-06-18/chirp-20230618-git.tgz";
      sha256 = "0714qqzac0kqhmqx9q9361l48n9hq3wjl15m91vvzy9fn7nghj93";
      system = "chirp-core";
      asd = "chirp-core";
    });
    systems = [ "chirp-core" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-base64" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "ironclad" self) (getAttr "local-time" self) (getAttr "split-sequence" self) (getAttr "uuid" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chirp-dexador = (build-asdf-system {
    pname = "chirp-dexador";
    version = "20230618-git";
    asds = [ "chirp-dexador" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chirp/2023-06-18/chirp-20230618-git.tgz";
      sha256 = "0714qqzac0kqhmqx9q9361l48n9hq3wjl15m91vvzy9fn7nghj93";
      system = "chirp-dexador";
      asd = "chirp-dexador";
    });
    systems = [ "chirp-dexador" ];
    lispLibs = [ (getAttr "chirp-core" self) (getAttr "dexador" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chirp-drakma = (build-asdf-system {
    pname = "chirp-drakma";
    version = "20230618-git";
    asds = [ "chirp-drakma" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chirp/2023-06-18/chirp-20230618-git.tgz";
      sha256 = "0714qqzac0kqhmqx9q9361l48n9hq3wjl15m91vvzy9fn7nghj93";
      system = "chirp-drakma";
      asd = "chirp-drakma";
    });
    systems = [ "chirp-drakma" ];
    lispLibs = [ (getAttr "chirp-core" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chlorophyll = (build-asdf-system {
    pname = "chlorophyll";
    version = "20230618-git";
    asds = [ "chlorophyll" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chlorophyll/2023-06-18/chlorophyll-20230618-git.tgz";
      sha256 = "1hgl8sjsmyqx4gs77q4p94b63zgpxk1wi9w9niki8j0213dr1s3y";
      system = "chlorophyll";
      asd = "chlorophyll";
    });
    systems = [ "chlorophyll" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chlorophyll-test = (build-asdf-system {
    pname = "chlorophyll-test";
    version = "20230618-git";
    asds = [ "chlorophyll-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chlorophyll/2023-06-18/chlorophyll-20230618-git.tgz";
      sha256 = "1hgl8sjsmyqx4gs77q4p94b63zgpxk1wi9w9niki8j0213dr1s3y";
      system = "chlorophyll-test";
      asd = "chlorophyll-test";
    });
    systems = [ "chlorophyll-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "chlorophyll" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chrome-native-messaging = (build-asdf-system {
    pname = "chrome-native-messaging";
    version = "20150302-git";
    asds = [ "chrome-native-messaging" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chrome-native-messaging/2015-03-02/chrome-native-messaging-20150302-git.tgz";
      sha256 = "1fw02w5brpwa0kl7sx5b13fbcfv1ny8rwcj11ayj2q528i2xmpx5";
      system = "chrome-native-messaging";
      asd = "chrome-native-messaging";
    });
    systems = [ "chrome-native-messaging" ];
    lispLibs = [ (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chronicity = (build-asdf-system {
    pname = "chronicity";
    version = "20190202-git";
    asds = [ "chronicity" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chronicity/2019-02-02/chronicity-20190202-git.tgz";
      sha256 = "1h5dlgvccffd8sqszqwilscysklzfcp374zl48rq14ywgv3rnwhl";
      system = "chronicity";
      asd = "chronicity";
    });
    systems = [ "chronicity" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chronicity-test = (build-asdf-system {
    pname = "chronicity-test";
    version = "20190202-git";
    asds = [ "chronicity-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chronicity/2019-02-02/chronicity-20190202-git.tgz";
      sha256 = "1h5dlgvccffd8sqszqwilscysklzfcp374zl48rq14ywgv3rnwhl";
      system = "chronicity-test";
      asd = "chronicity-test";
    });
    systems = [ "chronicity-test" ];
    lispLibs = [ (getAttr "chronicity" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chtml-matcher = (build-asdf-system {
    pname = "chtml-matcher";
    version = "20111001-git";
    asds = [ "chtml-matcher" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chtml-matcher/2011-10-01/chtml-matcher-20111001-git.tgz";
      sha256 = "1q1ksy2w0c4dcmq8543scl11x4crh1m5w29p1wjpqhxk826jx7fd";
      system = "chtml-matcher";
      asd = "chtml-matcher";
    });
    systems = [ "chtml-matcher" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "closure-html" self) (getAttr "f-underscore" self) (getAttr "stdutils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  chunga = (build-asdf-system {
    pname = "chunga";
    version = "20221106-git";
    asds = [ "chunga" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/chunga/2022-11-06/chunga-20221106-git.tgz";
      sha256 = "117qvvfszi4s6zfcxi7mpwx14dpgamir7n124p4whwyam04b0y1b";
      system = "chunga";
      asd = "chunga";
    });
    systems = [ "chunga" ];
    lispLibs = [ (getAttr "trivial-gray-streams" self) ];
    meta = {};
  });
  ci-utils = (build-asdf-system {
    pname = "ci-utils";
    version = "20221106-git";
    asds = [ "ci-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ci-utils/2022-11-06/ci-utils-20221106-git.tgz";
      sha256 = "0srypwhcfwmy6ppv724y0vhm0icninv2zzb2f8h1985zch73cqw3";
      system = "ci-utils";
      asd = "ci-utils";
    });
    systems = [ "ci-utils" ];
    lispLibs = [ (getAttr "ci-utils-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ci-utils-features = (build-asdf-system {
    pname = "ci-utils-features";
    version = "20221106-git";
    asds = [ "ci-utils-features" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ci-utils/2022-11-06/ci-utils-20221106-git.tgz";
      sha256 = "0srypwhcfwmy6ppv724y0vhm0icninv2zzb2f8h1985zch73cqw3";
      system = "ci-utils-features";
      asd = "ci-utils-features";
    });
    systems = [ "ci-utils-features" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ciao = (build-asdf-system {
    pname = "ciao";
    version = "20230215-git";
    asds = [ "ciao" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/ciao/2023-02-15/ciao-20230215-git.tgz";
      sha256 = "1sqp9yisd7j6j5gd2vbid2xvigbhglpj7wwm3glifg1lmmqijnpv";
      system = "ciao";
      asd = "ciao";
    });
    systems = [ "ciao" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "dexador" self) (getAttr "hunchentoot" self) (getAttr "trivial-open-browser" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  circular-streams = (build-asdf-system {
    pname = "circular-streams";
    version = "20161204-git";
    asds = [ "circular-streams" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/circular-streams/2016-12-04/circular-streams-20161204-git.tgz";
      sha256 = "1wpw6d5cciyqcf92f7mvihak52pd5s47kk4qq6f0r2z2as68p5rs";
      system = "circular-streams";
      asd = "circular-streams";
    });
    systems = [ "circular-streams" ];
    lispLibs = [ (getAttr "fast-io" self) (getAttr "trivial-gray-streams" self) ];
    meta = {};
  });
  circular-streams-test = (build-asdf-system {
    pname = "circular-streams-test";
    version = "20161204-git";
    asds = [ "circular-streams-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/circular-streams/2016-12-04/circular-streams-20161204-git.tgz";
      sha256 = "1wpw6d5cciyqcf92f7mvihak52pd5s47kk4qq6f0r2z2as68p5rs";
      system = "circular-streams-test";
      asd = "circular-streams-test";
    });
    systems = [ "circular-streams-test" ];
    lispLibs = [ (getAttr "circular-streams" self) (getAttr "cl-test-more" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  city-hash = (build-asdf-system {
    pname = "city-hash";
    version = "20200925-git";
    asds = [ "city-hash" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/city-hash/2020-09-25/city-hash-20200925-git.tgz";
      sha256 = "10ksl402aa37sn78hnvlvpqibr66qzpjvf2x4a789gnl411cf44a";
      system = "city-hash";
      asd = "city-hash";
    });
    systems = [ "city-hash" ];
    lispLibs = [ (getAttr "com_dot_google_dot_base" self) (getAttr "nibbles" self) (getAttr "swap-bytes" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  city-hash-test = (build-asdf-system {
    pname = "city-hash-test";
    version = "20200925-git";
    asds = [ "city-hash-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/city-hash/2020-09-25/city-hash-20200925-git.tgz";
      sha256 = "10ksl402aa37sn78hnvlvpqibr66qzpjvf2x4a789gnl411cf44a";
      system = "city-hash-test";
      asd = "city-hash-test";
    });
    systems = [ "city-hash-test" ];
    lispLibs = [ (getAttr "city-hash" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  ckr-tables = (build-asdf-system {
    pname = "ckr-tables";
    version = "20221106-git";
    asds = [ "ckr-tables" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/lisp-critic/2022-11-06/lisp-critic-20221106-git.tgz";
      sha256 = "000vp8jsvpw80by7c7nb5394akfcr6rzzpzw049am67fh5qk89rn";
      system = "ckr-tables";
      asd = "ckr-tables";
    });
    systems = [ "ckr-tables" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl_plus_ssl = (build-asdf-system {
    pname = "cl+ssl";
    version = "20230618-git";
    asds = [ "cl+ssl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl+ssl/2023-06-18/cl+ssl-20230618-git.tgz";
      sha256 = "0d8sndn278s8c947bv7zp9mblpl6g83vq5wqa7kjk6javyg36a9c";
      system = "cl+ssl";
      asd = "cl+ssl";
    });
    systems = [ "cl+ssl" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "flexi-streams" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) (getAttr "trivial-gray-streams" self) (getAttr "usocket" self) ];
    meta = {};
  });
  cl_plus_ssl_dot_test = (build-asdf-system {
    pname = "cl+ssl.test";
    version = "20230618-git";
    asds = [ "cl+ssl.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl+ssl/2023-06-18/cl+ssl-20230618-git.tgz";
      sha256 = "0d8sndn278s8c947bv7zp9mblpl6g83vq5wqa7kjk6javyg36a9c";
      system = "cl+ssl.test";
      asd = "cl+ssl.test";
    });
    systems = [ "cl+ssl.test" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl_plus_ssl" self) (getAttr "cl-coveralls" self) (getAttr "fiveam" self) (getAttr "trivial-sockets" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-6502 = (build-asdf-system {
    pname = "cl-6502";
    version = "20211020-git";
    asds = [ "cl-6502" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-6502/2021-10-20/cl-6502-20211020-git.tgz";
      sha256 = "1mzdx141ad1rf0di09glyibxbizbmhzd9l3cqd7r3cvrvf5gkj49";
      system = "cl-6502";
      asd = "cl-6502";
    });
    systems = [ "cl-6502" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-aa = (build-asdf-system {
    pname = "cl-aa";
    version = "20180228-git";
    asds = [ "cl-aa" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vectors/2018-02-28/cl-vectors-20180228-git.tgz";
      sha256 = "0nckw4zb6s96hll8hrxzvgs2an3bfm0pxcywshbm4bq4rn7niqg4";
      system = "cl-aa";
      asd = "cl-aa";
    });
    systems = [ "cl-aa" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-aa-misc = (build-asdf-system {
    pname = "cl-aa-misc";
    version = "20180228-git";
    asds = [ "cl-aa-misc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vectors/2018-02-28/cl-vectors-20180228-git.tgz";
      sha256 = "0nckw4zb6s96hll8hrxzvgs2an3bfm0pxcywshbm4bq4rn7niqg4";
      system = "cl-aa-misc";
      asd = "cl-aa-misc";
    });
    systems = [ "cl-aa-misc" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-acronyms = (build-asdf-system {
    pname = "cl-acronyms";
    version = "20150302-git";
    asds = [ "cl-acronyms" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-acronyms/2015-03-02/cl-acronyms-20150302-git.tgz";
      sha256 = "1b827g6n87i81wbqzvmlq0yn41kfa502v5ssbh2wh1b4xznhn8cc";
      system = "cl-acronyms";
      asd = "cl-acronyms";
    });
    systems = [ "cl-acronyms" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-actors = (build-asdf-system {
    pname = "cl-actors";
    version = "20191130-git";
    asds = [ "cl-actors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/common-lisp-actors/2019-11-30/common-lisp-actors-20191130-git.tgz";
      sha256 = "0snf91yivxq6jcbvm3l6b05lcka7jrzciqd4m841amghfw32clfn";
      system = "cl-actors";
      asd = "cl-actors";
    });
    systems = [ "cl-actors" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-advice = (build-asdf-system {
    pname = "cl-advice";
    version = "20230214-git";
    asds = [ "cl-advice" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-advice/2023-02-14/cl-advice-20230214-git.tgz";
      sha256 = "038fhy7chgn9racrcikqncyiq5yqngs6d5ahxz7jkypixcdz48jx";
      system = "cl-advice";
      asd = "cl-advice";
    });
    systems = [ "cl-advice" ];
    lispLibs = [ (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-advice-tests = (build-asdf-system {
    pname = "cl-advice-tests";
    version = "20230214-git";
    asds = [ "cl-advice-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-advice/2023-02-14/cl-advice-20230214-git.tgz";
      sha256 = "038fhy7chgn9racrcikqncyiq5yqngs6d5ahxz7jkypixcdz48jx";
      system = "cl-advice-tests";
      asd = "cl-advice-tests";
    });
    systems = [ "cl-advice-tests" ];
    lispLibs = [ (getAttr "cl-advice" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-alc = (build-asdf-system {
    pname = "cl-alc";
    version = "20221106-git";
    asds = [ "cl-alc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openal/2022-11-06/cl-openal-20221106-git.tgz";
      sha256 = "0jmp81mf23ckcm4knnh0q7zpmyls5220imaqbmnl0xvvra10b1zy";
      system = "cl-alc";
      asd = "cl-alc";
    });
    systems = [ "cl-alc" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-openal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-algebraic-data-type = (build-asdf-system {
    pname = "cl-algebraic-data-type";
    version = "20191007-git";
    asds = [ "cl-algebraic-data-type" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-algebraic-data-type/2019-10-07/cl-algebraic-data-type-20191007-git.tgz";
      sha256 = "1lnqxcv8pd5z8n0g5p2l0dbljx9pqiv18hxl0vhsh7ldhkrjv2jx";
      system = "cl-algebraic-data-type";
      asd = "cl-algebraic-data-type";
    });
    systems = [ "cl-algebraic-data-type" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "global-vars" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-all = (build-asdf-system {
    pname = "cl-all";
    version = "20230618-git";
    asds = [ "cl-all" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-all/2023-06-18/cl-all-20230618-git.tgz";
      sha256 = "1nf4jwrws8j1vym3r3a5gyvf73vqx90qj71fsbw7w2hf5sw4wi9p";
      system = "cl-all";
      asd = "cl-all";
    });
    systems = [ "cl-all" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-alut = (build-asdf-system {
    pname = "cl-alut";
    version = "20221106-git";
    asds = [ "cl-alut" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openal/2022-11-06/cl-openal-20221106-git.tgz";
      sha256 = "0jmp81mf23ckcm4knnh0q7zpmyls5220imaqbmnl0xvvra10b1zy";
      system = "cl-alut";
      asd = "cl-alut";
    });
    systems = [ "cl-alut" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-openal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-amqp = (build-asdf-system {
    pname = "cl-amqp";
    version = "v0.4.1";
    asds = [ "cl-amqp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-amqp/2019-10-08/cl-amqp-v0.4.1.tgz";
      sha256 = "1ggd77ckfr54z7z5yi8d04k310x2dhf53qija8dzjhk1r9py20vz";
      system = "cl-amqp";
      asd = "cl-amqp";
    });
    systems = [ "cl-amqp" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "collectors" self) (getAttr "fast-io" self) (getAttr "local-time" self) (getAttr "log4cl" self) (getAttr "nibbles" self) (getAttr "trivial-utf-8" self) (getAttr "wu-decimal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-amqp_dot_test = (build-asdf-system {
    pname = "cl-amqp.test";
    version = "v0.4.1";
    asds = [ "cl-amqp.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-amqp/2019-10-08/cl-amqp-v0.4.1.tgz";
      sha256 = "1ggd77ckfr54z7z5yi8d04k310x2dhf53qija8dzjhk1r9py20vz";
      system = "cl-amqp.test";
      asd = "cl-amqp.test";
    });
    systems = [ "cl-amqp.test" ];
    lispLibs = [ (getAttr "cl-amqp" self) (getAttr "cl-interpol" self) (getAttr "log4cl" self) (getAttr "mw-equiv" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana = (build-asdf-system {
    pname = "cl-ana";
    version = "20220707-git";
    asds = [ "cl-ana" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana";
      asd = "cl-ana";
    });
    systems = [ "cl-ana" ];
    lispLibs = [ (getAttr "cl-ana_dot_array-utils" self) (getAttr "cl-ana_dot_binary-tree" self) (getAttr "cl-ana_dot_calculus" self) (getAttr "cl-ana_dot_clos-utils" self) (getAttr "cl-ana_dot_columnar-table" self) (getAttr "cl-ana_dot_csv-table" self) (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_file-utils" self) (getAttr "cl-ana_dot_fitting" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_hdf-table" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_int-char" self) (getAttr "cl-ana_dot_linear-algebra" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_lorentz" self) (getAttr "cl-ana_dot_makeres" self) (getAttr "cl-ana_dot_makeres-block" self) (getAttr "cl-ana_dot_makeres-branch" self) (getAttr "cl-ana_dot_makeres-graphviz" self) (getAttr "cl-ana_dot_makeres-macro" self) (getAttr "cl-ana_dot_makeres-progress" self) (getAttr "cl-ana_dot_makeres-table" self) (getAttr "cl-ana_dot_makeres-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_ntuple-table" self) (getAttr "cl-ana_dot_package-utils" self) (getAttr "cl-ana_dot_pathname-utils" self) (getAttr "cl-ana_dot_plotting" self) (getAttr "cl-ana_dot_quantity" self) (getAttr "cl-ana_dot_reusable-table" self) (getAttr "cl-ana_dot_serialization" self) (getAttr "cl-ana_dot_spline" self) (getAttr "cl-ana_dot_statistical-learning" self) (getAttr "cl-ana_dot_statistics" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-ana_dot_table-utils" self) (getAttr "cl-ana_dot_table-viewing" self) (getAttr "cl-ana_dot_tensor" self) ];
    meta = {};
  });
  cl-ana_dot_array-utils = (build-asdf-system {
    pname = "cl-ana.array-utils";
    version = "20220707-git";
    asds = [ "cl-ana.array-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.array-utils";
      asd = "cl-ana.array-utils";
    });
    systems = [ "cl-ana.array-utils" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_binary-tree = (build-asdf-system {
    pname = "cl-ana.binary-tree";
    version = "20220707-git";
    asds = [ "cl-ana.binary-tree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.binary-tree";
      asd = "cl-ana.binary-tree";
    });
    systems = [ "cl-ana.binary-tree" ];
    lispLibs = [ (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_calculus = (build-asdf-system {
    pname = "cl-ana.calculus";
    version = "20220707-git";
    asds = [ "cl-ana.calculus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.calculus";
      asd = "cl-ana.calculus";
    });
    systems = [ "cl-ana.calculus" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_linear-algebra" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_clos-utils = (build-asdf-system {
    pname = "cl-ana.clos-utils";
    version = "20220707-git";
    asds = [ "cl-ana.clos-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.clos-utils";
      asd = "cl-ana.clos-utils";
    });
    systems = [ "cl-ana.clos-utils" ];
    lispLibs = [ (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_columnar-table = (build-asdf-system {
    pname = "cl-ana.columnar-table";
    version = "20220707-git";
    asds = [ "cl-ana.columnar-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.columnar-table";
      asd = "cl-ana.columnar-table";
    });
    systems = [ "cl-ana.columnar-table" ];
    lispLibs = [ (getAttr "cl-ana_dot_reusable-table" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_csv-table = (build-asdf-system {
    pname = "cl-ana.csv-table";
    version = "20220707-git";
    asds = [ "cl-ana.csv-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.csv-table";
      asd = "cl-ana.csv-table";
    });
    systems = [ "cl-ana.csv-table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "antik" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-csv" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_error-propogation = (build-asdf-system {
    pname = "cl-ana.error-propogation";
    version = "20220707-git";
    asds = [ "cl-ana.error-propogation" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.error-propogation";
      asd = "cl-ana.error-propogation";
    });
    systems = [ "cl-ana.error-propogation" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_math-functions" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_file-utils = (build-asdf-system {
    pname = "cl-ana.file-utils";
    version = "20220707-git";
    asds = [ "cl-ana.file-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.file-utils";
      asd = "cl-ana.file-utils";
    });
    systems = [ "cl-ana.file-utils" ];
    lispLibs = [ (getAttr "external-program" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_fitting = (build-asdf-system {
    pname = "cl-ana.fitting";
    version = "20220707-git";
    asds = [ "cl-ana.fitting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.fitting";
      asd = "cl-ana.fitting";
    });
    systems = [ "cl-ana.fitting" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "gsll" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_functional-utils = (build-asdf-system {
    pname = "cl-ana.functional-utils";
    version = "20220707-git";
    asds = [ "cl-ana.functional-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.functional-utils";
      asd = "cl-ana.functional-utils";
    });
    systems = [ "cl-ana.functional-utils" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_generic-math = (build-asdf-system {
    pname = "cl-ana.generic-math";
    version = "20220707-git";
    asds = [ "cl-ana.generic-math" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.generic-math";
      asd = "cl-ana.generic-math";
    });
    systems = [ "cl-ana.generic-math" ];
    lispLibs = [ (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_package-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_gnuplot-interface = (build-asdf-system {
    pname = "cl-ana.gnuplot-interface";
    version = "20220707-git";
    asds = [ "cl-ana.gnuplot-interface" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.gnuplot-interface";
      asd = "cl-ana.gnuplot-interface";
    });
    systems = [ "cl-ana.gnuplot-interface" ];
    lispLibs = [ (getAttr "external-program" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_gsl-cffi = (build-asdf-system {
    pname = "cl-ana.gsl-cffi";
    version = "20220707-git";
    asds = [ "cl-ana.gsl-cffi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.gsl-cffi";
      asd = "cl-ana.gsl-cffi";
    });
    systems = [ "cl-ana.gsl-cffi" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_hash-table-utils = (build-asdf-system {
    pname = "cl-ana.hash-table-utils";
    version = "20220707-git";
    asds = [ "cl-ana.hash-table-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.hash-table-utils";
      asd = "cl-ana.hash-table-utils";
    });
    systems = [ "cl-ana.hash-table-utils" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_hdf-cffi = (build-asdf-system {
    pname = "cl-ana.hdf-cffi";
    version = "20220707-git";
    asds = [ "cl-ana.hdf-cffi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.hdf-cffi";
      asd = "cl-ana.hdf-cffi";
    });
    systems = [ "cl-ana.hdf-cffi" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_hdf-table = (build-asdf-system {
    pname = "cl-ana.hdf-table";
    version = "20220707-git";
    asds = [ "cl-ana.hdf-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.hdf-table";
      asd = "cl-ana.hdf-table";
    });
    systems = [ "cl-ana.hdf-table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_binary-tree" self) (getAttr "cl-ana_dot_hdf-typespec" self) (getAttr "cl-ana_dot_hdf-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-ana_dot_typed-table" self) (getAttr "cl-ana_dot_typespec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_hdf-typespec = (build-asdf-system {
    pname = "cl-ana.hdf-typespec";
    version = "20220707-git";
    asds = [ "cl-ana.hdf-typespec" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.hdf-typespec";
      asd = "cl-ana.hdf-typespec";
    });
    systems = [ "cl-ana.hdf-typespec" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ana_dot_hdf-cffi" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_typespec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_hdf-utils = (build-asdf-system {
    pname = "cl-ana.hdf-utils";
    version = "20220707-git";
    asds = [ "cl-ana.hdf-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.hdf-utils";
      asd = "cl-ana.hdf-utils";
    });
    systems = [ "cl-ana.hdf-utils" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ana_dot_hdf-cffi" self) (getAttr "cl-ana_dot_hdf-typespec" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_pathname-utils" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_typespec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_histogram = (build-asdf-system {
    pname = "cl-ana.histogram";
    version = "20220707-git";
    asds = [ "cl-ana.histogram" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.histogram";
      asd = "cl-ana.histogram";
    });
    systems = [ "cl-ana.histogram" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_binary-tree" self) (getAttr "cl-ana_dot_clos-utils" self) (getAttr "cl-ana_dot_fitting" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_int-char = (build-asdf-system {
    pname = "cl-ana.int-char";
    version = "20220707-git";
    asds = [ "cl-ana.int-char" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.int-char";
      asd = "cl-ana.int-char";
    });
    systems = [ "cl-ana.int-char" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_linear-algebra = (build-asdf-system {
    pname = "cl-ana.linear-algebra";
    version = "20220707-git";
    asds = [ "cl-ana.linear-algebra" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.linear-algebra";
      asd = "cl-ana.linear-algebra";
    });
    systems = [ "cl-ana.linear-algebra" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "gsll" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_list-utils = (build-asdf-system {
    pname = "cl-ana.list-utils";
    version = "20220707-git";
    asds = [ "cl-ana.list-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.list-utils";
      asd = "cl-ana.list-utils";
    });
    systems = [ "cl-ana.list-utils" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_string-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_lorentz = (build-asdf-system {
    pname = "cl-ana.lorentz";
    version = "20220707-git";
    asds = [ "cl-ana.lorentz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.lorentz";
      asd = "cl-ana.lorentz";
    });
    systems = [ "cl-ana.lorentz" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_linear-algebra" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_macro-utils = (build-asdf-system {
    pname = "cl-ana.macro-utils";
    version = "20220707-git";
    asds = [ "cl-ana.macro-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.macro-utils";
      asd = "cl-ana.macro-utils";
    });
    systems = [ "cl-ana.macro-utils" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres = (build-asdf-system {
    pname = "cl-ana.makeres";
    version = "20220707-git";
    asds = [ "cl-ana.makeres" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres";
      asd = "cl-ana.makeres";
    });
    systems = [ "cl-ana.makeres" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_file-utils" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_hdf-utils" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_pathname-utils" self) (getAttr "cl-ana_dot_plotting" self) (getAttr "cl-ana_dot_reusable-table" self) (getAttr "cl-ana_dot_serialization" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-fad" self) (getAttr "external-program" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-block = (build-asdf-system {
    pname = "cl-ana.makeres-block";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-block" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-block";
      asd = "cl-ana.makeres-block";
    });
    systems = [ "cl-ana.makeres-block" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_makeres" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-branch = (build-asdf-system {
    pname = "cl-ana.makeres-branch";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-branch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-branch";
      asd = "cl-ana.makeres-branch";
    });
    systems = [ "cl-ana.makeres-branch" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_makeres" self) (getAttr "cl-ana_dot_map" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-graphviz = (build-asdf-system {
    pname = "cl-ana.makeres-graphviz";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-graphviz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-graphviz";
      asd = "cl-ana.makeres-graphviz";
    });
    systems = [ "cl-ana.makeres-graphviz" ];
    lispLibs = [ (getAttr "cl-ana_dot_makeres" self) (getAttr "external-program" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-macro = (build-asdf-system {
    pname = "cl-ana.makeres-macro";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-macro" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-macro";
      asd = "cl-ana.makeres-macro";
    });
    systems = [ "cl-ana.makeres-macro" ];
    lispLibs = [ (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_makeres" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-progress = (build-asdf-system {
    pname = "cl-ana.makeres-progress";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-progress" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-progress";
      asd = "cl-ana.makeres-progress";
    });
    systems = [ "cl-ana.makeres-progress" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_makeres" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-table = (build-asdf-system {
    pname = "cl-ana.makeres-table";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-table";
      asd = "cl-ana.makeres-table";
    });
    systems = [ "cl-ana.makeres-table" ];
    lispLibs = [ (getAttr "cl-ana_dot_csv-table" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_hdf-table" self) (getAttr "cl-ana_dot_hdf-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_makeres" self) (getAttr "cl-ana_dot_makeres-macro" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_ntuple-table" self) (getAttr "cl-ana_dot_reusable-table" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_makeres-utils = (build-asdf-system {
    pname = "cl-ana.makeres-utils";
    version = "20220707-git";
    asds = [ "cl-ana.makeres-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.makeres-utils";
      asd = "cl-ana.makeres-utils";
    });
    systems = [ "cl-ana.makeres-utils" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_file-utils" self) (getAttr "cl-ana_dot_fitting" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_makeres" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_pathname-utils" self) (getAttr "cl-ana_dot_plotting" self) (getAttr "cl-ana_dot_reusable-table" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_map = (build-asdf-system {
    pname = "cl-ana.map";
    version = "20220707-git";
    asds = [ "cl-ana.map" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.map";
      asd = "cl-ana.map";
    });
    systems = [ "cl-ana.map" ];
    lispLibs = [ (getAttr "cl-ana_dot_hash-table-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_math-functions = (build-asdf-system {
    pname = "cl-ana.math-functions";
    version = "20220707-git";
    asds = [ "cl-ana.math-functions" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.math-functions";
      asd = "cl-ana.math-functions";
    });
    systems = [ "cl-ana.math-functions" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "gsll" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_memoization = (build-asdf-system {
    pname = "cl-ana.memoization";
    version = "20220707-git";
    asds = [ "cl-ana.memoization" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.memoization";
      asd = "cl-ana.memoization";
    });
    systems = [ "cl-ana.memoization" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_ntuple-table = (build-asdf-system {
    pname = "cl-ana.ntuple-table";
    version = "20220707-git";
    asds = [ "cl-ana.ntuple-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.ntuple-table";
      asd = "cl-ana.ntuple-table";
    });
    systems = [ "cl-ana.ntuple-table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ana_dot_gsl-cffi" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-ana_dot_typed-table" self) (getAttr "cl-ana_dot_typespec" self) (getAttr "gsll" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_package-utils = (build-asdf-system {
    pname = "cl-ana.package-utils";
    version = "20220707-git";
    asds = [ "cl-ana.package-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.package-utils";
      asd = "cl-ana.package-utils";
    });
    systems = [ "cl-ana.package-utils" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_pathname-utils = (build-asdf-system {
    pname = "cl-ana.pathname-utils";
    version = "20220707-git";
    asds = [ "cl-ana.pathname-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.pathname-utils";
      asd = "cl-ana.pathname-utils";
    });
    systems = [ "cl-ana.pathname-utils" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_plotting = (build-asdf-system {
    pname = "cl-ana.plotting";
    version = "20220707-git";
    asds = [ "cl-ana.plotting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.plotting";
      asd = "cl-ana.plotting";
    });
    systems = [ "cl-ana.plotting" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_gnuplot-interface" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_pathname-utils" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "external-program" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_quantity = (build-asdf-system {
    pname = "cl-ana.quantity";
    version = "20220707-git";
    asds = [ "cl-ana.quantity" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.quantity";
      asd = "cl-ana.quantity";
    });
    systems = [ "cl-ana.quantity" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_symbol-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_reusable-table = (build-asdf-system {
    pname = "cl-ana.reusable-table";
    version = "20220707-git";
    asds = [ "cl-ana.reusable-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.reusable-table";
      asd = "cl-ana.reusable-table";
    });
    systems = [ "cl-ana.reusable-table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_serialization = (build-asdf-system {
    pname = "cl-ana.serialization";
    version = "20220707-git";
    asds = [ "cl-ana.serialization" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.serialization";
      asd = "cl-ana.serialization";
    });
    systems = [ "cl-ana.serialization" ];
    lispLibs = [ (getAttr "cl-ana_dot_error-propogation" self) (getAttr "cl-ana_dot_hdf-table" self) (getAttr "cl-ana_dot_hdf-utils" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_int-char" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_typespec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_spline = (build-asdf-system {
    pname = "cl-ana.spline";
    version = "20220707-git";
    asds = [ "cl-ana.spline" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.spline";
      asd = "cl-ana.spline";
    });
    systems = [ "cl-ana.spline" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-ana_dot_fitting" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_tensor" self) (getAttr "gsll" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_statistical-learning = (build-asdf-system {
    pname = "cl-ana.statistical-learning";
    version = "20220707-git";
    asds = [ "cl-ana.statistical-learning" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.statistical-learning";
      asd = "cl-ana.statistical-learning";
    });
    systems = [ "cl-ana.statistical-learning" ];
    lispLibs = [ (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_linear-algebra" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_math-functions" self) (getAttr "cl-ana_dot_statistics" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_statistics = (build-asdf-system {
    pname = "cl-ana.statistics";
    version = "20220707-git";
    asds = [ "cl-ana.statistics" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.statistics";
      asd = "cl-ana.statistics";
    });
    systems = [ "cl-ana.statistics" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_map" self) (getAttr "cl-ana_dot_math-functions" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_string-utils = (build-asdf-system {
    pname = "cl-ana.string-utils";
    version = "20220707-git";
    asds = [ "cl-ana.string-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.string-utils";
      asd = "cl-ana.string-utils";
    });
    systems = [ "cl-ana.string-utils" ];
    lispLibs = [ (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_symbol-utils = (build-asdf-system {
    pname = "cl-ana.symbol-utils";
    version = "20220707-git";
    asds = [ "cl-ana.symbol-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.symbol-utils";
      asd = "cl-ana.symbol-utils";
    });
    systems = [ "cl-ana.symbol-utils" ];
    lispLibs = [ (getAttr "cl-ana_dot_list-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_table = (build-asdf-system {
    pname = "cl-ana.table";
    version = "20220707-git";
    asds = [ "cl-ana.table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.table";
      asd = "cl-ana.table";
    });
    systems = [ "cl-ana.table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_functional-utils" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_table-utils = (build-asdf-system {
    pname = "cl-ana.table-utils";
    version = "20220707-git";
    asds = [ "cl-ana.table-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.table-utils";
      asd = "cl-ana.table-utils";
    });
    systems = [ "cl-ana.table-utils" ];
    lispLibs = [ (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_hash-table-utils" self) (getAttr "cl-ana_dot_statistics" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_table-viewing = (build-asdf-system {
    pname = "cl-ana.table-viewing";
    version = "20220707-git";
    asds = [ "cl-ana.table-viewing" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.table-viewing";
      asd = "cl-ana.table-viewing";
    });
    systems = [ "cl-ana.table-viewing" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_histogram" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_plotting" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_tensor = (build-asdf-system {
    pname = "cl-ana.tensor";
    version = "20220707-git";
    asds = [ "cl-ana.tensor" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.tensor";
      asd = "cl-ana.tensor";
    });
    systems = [ "cl-ana.tensor" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_generic-math" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_macro-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_typed-table = (build-asdf-system {
    pname = "cl-ana.typed-table";
    version = "20220707-git";
    asds = [ "cl-ana.typed-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.typed-table";
      asd = "cl-ana.typed-table";
    });
    systems = [ "cl-ana.typed-table" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_table" self) (getAttr "cl-ana_dot_typespec" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ana_dot_typespec = (build-asdf-system {
    pname = "cl-ana.typespec";
    version = "20220707-git";
    asds = [ "cl-ana.typespec" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ana/2022-07-07/cl-ana-20220707-git.tgz";
      sha256 = "1dg8wkc2bv66lykr2fjgn91jw7aa9xnpk20h0g8pp2xr6981gfl9";
      system = "cl-ana.typespec";
      asd = "cl-ana.typespec";
    });
    systems = [ "cl-ana.typespec" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ana_dot_int-char" self) (getAttr "cl-ana_dot_list-utils" self) (getAttr "cl-ana_dot_memoization" self) (getAttr "cl-ana_dot_string-utils" self) (getAttr "cl-ana_dot_symbol-utils" self) (getAttr "cl-ana_dot_tensor" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-android = (build-asdf-system {
    pname = "cl-android";
    version = "20150804-git";
    asds = [ "cl-android" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sl4a/2015-08-04/cl-sl4a-20150804-git.tgz";
      sha256 = "0lqla60apkc8xfiyi43w18dldf0m8z5q290wv3d89qf0n9gwk3cr";
      system = "cl-android";
      asd = "cl-android";
    });
    systems = [ "cl-android" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-annot = (build-asdf-system {
    pname = "cl-annot";
    version = "20150608-git";
    asds = [ "cl-annot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot/2015-06-08/cl-annot-20150608-git.tgz";
      sha256 = "1wq1gs9jjd5m6iwrv06c2d7i5dvqsfjcljgbspfbc93cg5xahk4n";
      system = "cl-annot";
      asd = "cl-annot";
    });
    systems = [ "cl-annot" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {};
  });
  cl-annot-prove = (build-asdf-system {
    pname = "cl-annot-prove";
    version = "20150923-git";
    asds = [ "cl-annot-prove" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot-prove/2015-09-23/cl-annot-prove-20150923-git.tgz";
      sha256 = "000nlxxs1id1pccp3y5s9xnm76fc5r87q0bxmjrpklxwwf5y8wwy";
      system = "cl-annot-prove";
      asd = "cl-annot-prove";
    });
    systems = [ "cl-annot-prove" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "cl-ppcre" self) (getAttr "cl-syntax" self) (getAttr "cl-syntax-annot" self) (getAttr "prove" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-annot-prove-test = (build-asdf-system {
    pname = "cl-annot-prove-test";
    version = "20150923-git";
    asds = [ "cl-annot-prove-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot-prove/2015-09-23/cl-annot-prove-20150923-git.tgz";
      sha256 = "000nlxxs1id1pccp3y5s9xnm76fc5r87q0bxmjrpklxwwf5y8wwy";
      system = "cl-annot-prove-test";
      asd = "cl-annot-prove-test";
    });
    systems = [ "cl-annot-prove-test" ];
    lispLibs = [ (getAttr "cl-annot-prove" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-annot-revisit = (build-asdf-system {
    pname = "cl-annot-revisit";
    version = "20221106-git";
    asds = [ "cl-annot-revisit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot-revisit/2022-11-06/cl-annot-revisit-20221106-git.tgz";
      sha256 = "0jlllgq14bi1rddzlmq9wfs4vb24apgqz17wfd79kjjcmnzzjp4m";
      system = "cl-annot-revisit";
      asd = "cl-annot-revisit";
    });
    systems = [ "cl-annot-revisit" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-annot-revisit-compat = (build-asdf-system {
    pname = "cl-annot-revisit-compat";
    version = "20221106-git";
    asds = [ "cl-annot-revisit-compat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot-revisit/2022-11-06/cl-annot-revisit-20221106-git.tgz";
      sha256 = "0jlllgq14bi1rddzlmq9wfs4vb24apgqz17wfd79kjjcmnzzjp4m";
      system = "cl-annot-revisit-compat";
      asd = "cl-annot-revisit-compat";
    });
    systems = [ "cl-annot-revisit-compat" ];
    lispLibs = [ (getAttr "cl-annot-revisit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-annot-revisit-test = (build-asdf-system {
    pname = "cl-annot-revisit-test";
    version = "20221106-git";
    asds = [ "cl-annot-revisit-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-annot-revisit/2022-11-06/cl-annot-revisit-20221106-git.tgz";
      sha256 = "0jlllgq14bi1rddzlmq9wfs4vb24apgqz17wfd79kjjcmnzzjp4m";
      system = "cl-annot-revisit-test";
      asd = "cl-annot-revisit-test";
    });
    systems = [ "cl-annot-revisit-test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "cl-annot-revisit" self) (getAttr "cl-annot-revisit-compat" self) (getAttr "trivial-macroexpand-all" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-anonfun = (build-asdf-system {
    pname = "cl-anonfun";
    version = "20111203-git";
    asds = [ "cl-anonfun" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-anonfun/2011-12-03/cl-anonfun-20111203-git.tgz";
      sha256 = "086x2vjvasdy9bhikvdzx34nrq008c0sfkq3ncv0i9mhfk5xwp2j";
      system = "cl-anonfun";
      asd = "cl-anonfun";
    });
    systems = [ "cl-anonfun" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-ansi-term = (build-asdf-system {
    pname = "cl-ansi-term";
    version = "20211020-git";
    asds = [ "cl-ansi-term" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ansi-term/2021-10-20/cl-ansi-term-20211020-git.tgz";
      sha256 = "1wz8xx1dk5v1v5cvfh4a5cf5mdrn8lnz8mpf55c34inb0bxjlx87";
      system = "cl-ansi-term";
      asd = "cl-ansi-term";
    });
    systems = [ "cl-ansi-term" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "str" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ansi-text = (build-asdf-system {
    pname = "cl-ansi-text";
    version = "20211020-git";
    asds = [ "cl-ansi-text" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ansi-text/2021-10-20/cl-ansi-text-20211020-git.tgz";
      sha256 = "0nk7ajqfa937w1iy3zy86jjbw8yffm05cqs4wxkgl97v6kmmya14";
      system = "cl-ansi-text";
      asd = "cl-ansi-text";
    });
    systems = [ "cl-ansi-text" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-colors2" self) ];
    meta = {};
  });
  cl-ansi-text_dot_test = (build-asdf-system {
    pname = "cl-ansi-text.test";
    version = "20211020-git";
    asds = [ "cl-ansi-text.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ansi-text/2021-10-20/cl-ansi-text-20211020-git.tgz";
      sha256 = "0nk7ajqfa937w1iy3zy86jjbw8yffm05cqs4wxkgl97v6kmmya14";
      system = "cl-ansi-text.test";
      asd = "cl-ansi-text.test";
    });
    systems = [ "cl-ansi-text.test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ansi-text" self) (getAttr "cl-colors2" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-apertium-stream = (build-asdf-system {
    pname = "cl-apertium-stream";
    version = "20230618-git";
    asds = [ "cl-apertium-stream" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-apertium-stream-parser/2023-06-18/cl-apertium-stream-parser-20230618-git.tgz";
      sha256 = "1f3v5pgar83iw443haa4nlzy1qvr55xxqggq9klvsji1a3jdypqy";
      system = "cl-apertium-stream";
      asd = "cl-apertium-stream";
    });
    systems = [ "cl-apertium-stream" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "esrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-apple-plist = (build-asdf-system {
    pname = "cl-apple-plist";
    version = "20111105-git";
    asds = [ "cl-apple-plist" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-apple-plist/2011-11-05/cl-apple-plist-20111105-git.tgz";
      sha256 = "104j5lvvp7apdx59kbwc6kpa8b82y20w03627ml91lpbqk9bq63f";
      system = "cl-apple-plist";
      asd = "cl-apple-plist";
    });
    systems = [ "cl-apple-plist" ];
    lispLibs = [ (getAttr "html-encode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-arff-parser = (build-asdf-system {
    pname = "cl-arff-parser";
    version = "20130421-git";
    asds = [ "cl-arff-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-arff-parser/2013-04-21/cl-arff-parser-20130421-git.tgz";
      sha256 = "0rn76r48b2y2richfy3si4r8kbwkvm7q15g34sxi0fkfmx15z4jx";
      system = "cl-arff-parser";
      asd = "cl-arff-parser";
    });
    systems = [ "cl-arff-parser" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-argparse = (build-asdf-system {
    pname = "cl-argparse";
    version = "20210531-git";
    asds = [ "cl-argparse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-argparse/2021-05-31/cl-argparse-20210531-git.tgz";
      sha256 = "05vy2iaqr7yiaw0ykzwm0ml0mil5qagy87b8hqx4vvb3lq1qpn14";
      system = "cl-argparse";
      asd = "cl-argparse";
    });
    systems = [ "cl-argparse" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-aristid = (build-asdf-system {
    pname = "cl-aristid";
    version = "20200925-git";
    asds = [ "cl-aristid" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-aristid/2020-09-25/cl-aristid-20200925-git.tgz";
      sha256 = "0k573k3wydy6dd5pmvqdxmlwk0n5kq2wsk86syddhqyjgx2jmw98";
      system = "cl-aristid";
      asd = "cl-aristid";
    });
    systems = [ "cl-aristid" ];
    lispLibs = [ (getAttr "cl-colors" self) (getAttr "cl-svg" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-arxiv-api = (build-asdf-system {
    pname = "cl-arxiv-api";
    version = "20170403-git";
    asds = [ "cl-arxiv-api" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-arxiv-api/2017-04-03/cl-arxiv-api-20170403-git.tgz";
      sha256 = "1id95gszqxmmjydv1vjv2vyxz0svqvnx74bmgy63xnajb4kfnpq3";
      system = "cl-arxiv-api";
      asd = "cl-arxiv-api";
    });
    systems = [ "cl-arxiv-api" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "cxml" self) (getAttr "iterate" self) (getAttr "trivial-http" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ascii-art = (build-asdf-system {
    pname = "cl-ascii-art";
    version = "20171019-git";
    asds = [ "cl-ascii-art" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ascii-art/2017-10-19/cl-ascii-art-20171019-git.tgz";
      sha256 = "03d3bd8m7dd2l4170vky8y8ini3giqhjpd06rlswz287mkvzq8aa";
      system = "cl-ascii-art";
      asd = "cl-ascii-art";
    });
    systems = [ "cl-ascii-art" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ansi-text" self) (getAttr "cl-ppcre" self) (getAttr "inferior-shell" self) (getAttr "iterate" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ascii-table = (build-asdf-system {
    pname = "cl-ascii-table";
    version = "20200610-git";
    asds = [ "cl-ascii-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ascii-table/2020-06-10/cl-ascii-table-20200610-git.tgz";
      sha256 = "1nclyypd2p06hyfydcv16m9lbj1xmrpmf00wp8mfyhwimv021zlp";
      system = "cl-ascii-table";
      asd = "cl-ascii-table";
    });
    systems = [ "cl-ascii-table" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-association-rules = (build-asdf-system {
    pname = "cl-association-rules";
    version = "20170403-git";
    asds = [ "cl-association-rules" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-association-rules/2017-04-03/cl-association-rules-20170403-git.tgz";
      sha256 = "1d4sg9j30ydk1m17byacww8l2x9ggb82iay507g08ij0jxdky86z";
      system = "cl-association-rules";
      asd = "cl-association-rules";
    });
    systems = [ "cl-association-rules" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-association-rules-tests = (build-asdf-system {
    pname = "cl-association-rules-tests";
    version = "20170403-git";
    asds = [ "cl-association-rules-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-association-rules/2017-04-03/cl-association-rules-20170403-git.tgz";
      sha256 = "1d4sg9j30ydk1m17byacww8l2x9ggb82iay507g08ij0jxdky86z";
      system = "cl-association-rules-tests";
      asd = "cl-association-rules";
    });
    systems = [ "cl-association-rules-tests" ];
    lispLibs = [ (getAttr "cl-association-rules" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-async = (build-asdf-system {
    pname = "cl-async";
    version = "20230618-git";
    asds = [ "cl-async" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async";
      asd = "cl-async";
    });
    systems = [ "cl-async" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cffi" self) (getAttr "cl-async-base" self) (getAttr "cl-async-util" self) (getAttr "cl-libuv" self) (getAttr "cl-ppcre" self) (getAttr "static-vectors" self) (getAttr "trivial-features" self) (getAttr "trivial-gray-streams" self) ];
    meta = {};
  });
  cl-async-await = (build-asdf-system {
    pname = "cl-async-await";
    version = "20201016-git";
    asds = [ "cl-async-await" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async-await/2020-10-16/cl-async-await-20201016-git.tgz";
      sha256 = "1slhn9z4hljvad3hd8jmvw4q4m6310s04yh3212wvbfar8q0yasj";
      system = "cl-async-await";
      asd = "cl-async-await";
    });
    systems = [ "cl-async-await" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "closer-mop" self) (getAttr "simple-actors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-async-base = (build-asdf-system {
    pname = "cl-async-base";
    version = "20230618-git";
    asds = [ "cl-async-base" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async-base";
      asd = "cl-async";
    });
    systems = [ "cl-async-base" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-libuv" self) ];
    meta = {};
  });
  cl-async-future = (build-asdf-system {
    pname = "cl-async-future";
    version = "20150113-git";
    asds = [ "cl-async-future" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async-future/2015-01-13/cl-async-future-20150113-git.tgz";
      sha256 = "0z0sc7qlzzxk99f4l26zp6rai9kv0kj0f599sxai5s44p17zbbvh";
      system = "cl-async-future";
      asd = "cl-async-future";
    });
    systems = [ "cl-async-future" ];
    lispLibs = [ (getAttr "blackbird" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-async-repl = (build-asdf-system {
    pname = "cl-async-repl";
    version = "20230618-git";
    asds = [ "cl-async-repl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async-repl";
      asd = "cl-async-repl";
    });
    systems = [ "cl-async-repl" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-async" self) ];
    meta = {};
  });
  cl-async-ssl = (build-asdf-system {
    pname = "cl-async-ssl";
    version = "20230618-git";
    asds = [ "cl-async-ssl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async-ssl";
      asd = "cl-async-ssl";
    });
    systems = [ "cl-async-ssl" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-async" self) (getAttr "vom" self) ];
    meta = {};
  });
  cl-async-test = (build-asdf-system {
    pname = "cl-async-test";
    version = "20230618-git";
    asds = [ "cl-async-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async-test";
      asd = "cl-async-test";
    });
    systems = [ "cl-async-test" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-async" self) (getAttr "cl-async-ssl" self) (getAttr "fiveam" self) (getAttr "flexi-streams" self) (getAttr "ironclad" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-async-util = (build-asdf-system {
    pname = "cl-async-util";
    version = "20230618-git";
    asds = [ "cl-async-util" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-async/2023-06-18/cl-async-20230618-git.tgz";
      sha256 = "0xii3kxrbrgf7y9037h1y1x68fa2bvspa3dqsz53rbbs81n51ysj";
      system = "cl-async-util";
      asd = "cl-async";
    });
    systems = [ "cl-async-util" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-async-base" self) (getAttr "cl-libuv" self) (getAttr "cl-ppcre" self) (getAttr "fast-io" self) (getAttr "vom" self) ];
    meta = {};
  });
  cl-aubio = (build-asdf-system {
    pname = "cl-aubio";
    version = "20200427-git";
    asds = [ "cl-aubio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-aubio/2020-04-27/cl-aubio-20200427-git.tgz";
      sha256 = "1xyflxy46z4487dbnizhv058y2mdka9iyikl097m60w42blidpn3";
      system = "cl-aubio";
      asd = "cl-aubio";
    });
    systems = [ "cl-aubio" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-libffi" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-authorize-net = (build-asdf-system {
    pname = "cl-authorize-net";
    version = "20150113-git";
    asds = [ "cl-authorize-net" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-creditcard/2015-01-13/cl-creditcard-20150113-git.tgz";
      sha256 = "1qq9r7q50k7jw6sv65aqi9xalaw8m6aqsbb0cgpjxv8wdhy934cr";
      system = "cl-authorize-net";
      asd = "cl-authorize-net";
    });
    systems = [ "cl-authorize-net" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-creditcard" self) (getAttr "drakma" self) (getAttr "split-sequence" self) (getAttr "symbol-munger" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-authorize-net-tests = (build-asdf-system {
    pname = "cl-authorize-net-tests";
    version = "20150113-git";
    asds = [ "cl-authorize-net-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-creditcard/2015-01-13/cl-creditcard-20150113-git.tgz";
      sha256 = "1qq9r7q50k7jw6sv65aqi9xalaw8m6aqsbb0cgpjxv8wdhy934cr";
      system = "cl-authorize-net-tests";
      asd = "cl-authorize-net";
    });
    systems = [ "cl-authorize-net-tests" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-authorize-net" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-autorepo = (build-asdf-system {
    pname = "cl-autorepo";
    version = "20180711-git";
    asds = [ "cl-autorepo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-autorepo/2018-07-11/cl-autorepo-20180711-git.tgz";
      sha256 = "01hpg3r3493mri44kxp8sjy8i5kfvjklmnksvm0727i6bhpf8cz9";
      system = "cl-autorepo";
      asd = "cl-autorepo";
    });
    systems = [ "cl-autorepo" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-autowrap = (build-asdf-system {
    pname = "cl-autowrap";
    version = "20221106-git";
    asds = [ "cl-autowrap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-autowrap/2022-11-06/cl-autowrap-20221106-git.tgz";
      sha256 = "0pbabpmg61bflx6kxllqvhbvxqwjsik3nnynqdhgzzkgzk6jlixv";
      system = "cl-autowrap";
      asd = "cl-autowrap";
    });
    systems = [ "cl-autowrap" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-json" self) (getAttr "cl-ppcre" self) (getAttr "defpackage-plus" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-autowrap-test = (build-asdf-system {
    pname = "cl-autowrap-test";
    version = "20221106-git";
    asds = [ "cl-autowrap-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-autowrap/2022-11-06/cl-autowrap-20221106-git.tgz";
      sha256 = "0pbabpmg61bflx6kxllqvhbvxqwjsik3nnynqdhgzzkgzk6jlixv";
      system = "cl-autowrap-test";
      asd = "cl-autowrap-test";
    });
    systems = [ "cl-autowrap-test" ];
    lispLibs = [ (getAttr "cl-autowrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-azure = (build-asdf-system {
    pname = "cl-azure";
    version = "20160825-git";
    asds = [ "cl-azure" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-azure/2016-08-25/cl-azure-20160825-git.tgz";
      sha256 = "19sgzbvgs1f1h3qhx11xhpia2x3n8x729h9fsqkc7fap0ak1h31d";
      system = "cl-azure";
      asd = "cl-azure";
    });
    systems = [ "cl-azure" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-base64" self) (getAttr "cl-json" self) (getAttr "cl-ppcre" self) (getAttr "cxml" self) (getAttr "drakma" self) (getAttr "ironclad" self) (getAttr "puri" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base16 = (build-asdf-system {
    pname = "cl-base16";
    version = "20200925-git";
    asds = [ "cl-base16" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base16/2020-09-25/cl-base16-20200925-git.tgz";
      sha256 = "0m7ndmk4xhizn3q3ywjvw8sg4pfgp6lrd0wac5d1bf7wbw6afh5q";
      system = "cl-base16";
      asd = "cl-base16";
    });
    systems = [ "cl-base16" ];
    lispLibs = [ (getAttr "cl-mustache" self) (getAttr "cl-slug" self) (getAttr "cl-yaml" self) (getAttr "trivial-shell" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base32 = (build-asdf-system {
    pname = "cl-base32";
    version = "20130420-git";
    asds = [ "cl-base32" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base32/2013-04-20/cl-base32-20130420-git.tgz";
      sha256 = "17jrng8jb05d64ggyd11hp308c2fl5drvf9g175blgrkkl8l4mf8";
      system = "cl-base32";
      asd = "cl-base32";
    });
    systems = [ "cl-base32" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base32-tests = (build-asdf-system {
    pname = "cl-base32-tests";
    version = "20130420-git";
    asds = [ "cl-base32-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base32/2013-04-20/cl-base32-20130420-git.tgz";
      sha256 = "17jrng8jb05d64ggyd11hp308c2fl5drvf9g175blgrkkl8l4mf8";
      system = "cl-base32-tests";
      asd = "cl-base32";
    });
    systems = [ "cl-base32-tests" ];
    lispLibs = [ (getAttr "cl-base32" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base58 = (build-asdf-system {
    pname = "cl-base58";
    version = "20150113-git";
    asds = [ "cl-base58" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base58/2015-01-13/cl-base58-20150113-git.tgz";
      sha256 = "01wiiyz1jzxx3zhxi2hpq5n8hv28g1mn0adk793vwjzh4v5bi5zz";
      system = "cl-base58";
      asd = "cl-base58";
    });
    systems = [ "cl-base58" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base58-test = (build-asdf-system {
    pname = "cl-base58-test";
    version = "20150113-git";
    asds = [ "cl-base58-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base58/2015-01-13/cl-base58-20150113-git.tgz";
      sha256 = "01wiiyz1jzxx3zhxi2hpq5n8hv28g1mn0adk793vwjzh4v5bi5zz";
      system = "cl-base58-test";
      asd = "cl-base58-test";
    });
    systems = [ "cl-base58-test" ];
    lispLibs = [ (getAttr "cl-base58" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-base64 = (build-asdf-system {
    pname = "cl-base64";
    version = "20201016-git";
    asds = [ "cl-base64" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-base64/2020-10-16/cl-base64-20201016-git.tgz";
      sha256 = "12jj54h0fs6n237cvnp8v6hn0imfksammq22ys6pi0gwz2w47rbj";
      system = "cl-base64";
      asd = "cl-base64";
    });
    systems = [ "cl-base64" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-bayesnet = (build-asdf-system {
    pname = "cl-bayesnet";
    version = "20130420-git";
    asds = [ "cl-bayesnet" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bayesnet/2013-04-20/cl-bayesnet-20130420-git.tgz";
      sha256 = "02as2isvgm89qpyj49ccs1cg4fl9iswxi26w4j0svsha0q1dh5m8";
      system = "cl-bayesnet";
      asd = "cl-bayesnet";
    });
    systems = [ "cl-bayesnet" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "s-xml" self) (getAttr "trivial-shell" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bcrypt = (build-asdf-system {
    pname = "cl-bcrypt";
    version = "20230214-git";
    asds = [ "cl-bcrypt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bcrypt/2023-02-14/cl-bcrypt-20230214-git.tgz";
      sha256 = "1rhjxjlh3nwld9vr8d1cjnfwla2is9kracb0q6jds1rvxw9gknwh";
      system = "cl-bcrypt";
      asd = "cl-bcrypt";
    });
    systems = [ "cl-bcrypt" ];
    lispLibs = [ (getAttr "binascii" self) (getAttr "cl-ppcre" self) (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bcrypt_dot_test = (build-asdf-system {
    pname = "cl-bcrypt.test";
    version = "20230214-git";
    asds = [ "cl-bcrypt.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bcrypt/2023-02-14/cl-bcrypt-20230214-git.tgz";
      sha256 = "1rhjxjlh3nwld9vr8d1cjnfwla2is9kracb0q6jds1rvxw9gknwh";
      system = "cl-bcrypt.test";
      asd = "cl-bcrypt.test";
    });
    systems = [ "cl-bcrypt.test" ];
    lispLibs = [ (getAttr "cl-bcrypt" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-beanstalk = (build-asdf-system {
    pname = "cl-beanstalk";
    version = "20220707-git";
    asds = [ "cl-beanstalk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-beanstalk/2022-07-07/cl-beanstalk-20220707-git.tgz";
      sha256 = "0vca8dw2l765m7g7xcpzi80m8f3145hhshh8ym602336fhiz61q1";
      system = "cl-beanstalk";
      asd = "cl-beanstalk";
    });
    systems = [ "cl-beanstalk" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bip39 = (build-asdf-system {
    pname = "cl-bip39";
    version = "20180711-git";
    asds = [ "cl-bip39" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bip39/2018-07-11/cl-bip39-20180711-git.tgz";
      sha256 = "04h4lhppvavvqknp11gaj4ka2wpn9i883w1w27llblkg2vnn0816";
      system = "cl-bip39";
      asd = "cl-bip39";
    });
    systems = [ "cl-bip39" ];
    lispLibs = [ (getAttr "ironclad" self) (getAttr "secure-random" self) (getAttr "split-sequence" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bloggy = (build-asdf-system {
    pname = "cl-bloggy";
    version = "20211020-git";
    asds = [ "cl-bloggy" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bloggy/2021-10-20/cl-bloggy-20211020-git.tgz";
      sha256 = "1clz2a0s3g3jbsrpypb4byb432l0yb4658riqs6ckin57c4bzxc8";
      system = "cl-bloggy";
      asd = "cl-bloggy";
    });
    systems = [ "cl-bloggy" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "do-urlencode" self) (getAttr "hunchentoot" self) (getAttr "lass" self) (getAttr "local-time" self) (getAttr "lorem-ipsum" self) (getAttr "spinneret" self) (getAttr "str" self) (getAttr "xml-emitter" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bloom = (build-asdf-system {
    pname = "cl-bloom";
    version = "20180228-git";
    asds = [ "cl-bloom" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bloom/2018-02-28/cl-bloom-20180228-git.tgz";
      sha256 = "1ircc5sa0a2xlx0fca0is6inwrk311hbj8jx6r4sas5pfv78k4am";
      system = "cl-bloom";
      asd = "cl-bloom";
    });
    systems = [ "cl-bloom" ];
    lispLibs = [ (getAttr "cl-murmurhash" self) (getAttr "static-vectors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bloom-filter = (build-asdf-system {
    pname = "cl-bloom-filter";
    version = "20221106-git";
    asds = [ "cl-bloom-filter" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bloom-filter/2022-11-06/cl-bloom-filter-20221106-git.tgz";
      sha256 = "1s9m617fh3krh2klc2nx7jf89nk43cvvrnvqrhvw9jprw7gqanvq";
      system = "cl-bloom-filter";
      asd = "cl-bloom-filter";
    });
    systems = [ "cl-bloom-filter" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bmp = (build-asdf-system {
    pname = "cl-bmp";
    version = "20230618-git";
    asds = [ "cl-bmp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bmp/2023-06-18/cl-bmp-20230618-git.tgz";
      sha256 = "1pkhr4z785skn42pz6lmlv931mrbyh27f97sfgpzrv25fs2cabfm";
      system = "cl-bmp";
      asd = "cl-bmp";
    });
    systems = [ "cl-bmp" ];
    lispLibs = [ (getAttr "binary-structures" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bnf = (build-asdf-system {
    pname = "cl-bnf";
    version = "20230214-git";
    asds = [ "cl-bnf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bnf/2023-02-14/cl-bnf-20230214-git.tgz";
      sha256 = "05lskaz5kwl4sk8mb13l4kvr3q0q56dyarmznpp1cjpan6rdyr4x";
      system = "cl-bnf";
      asd = "cl-bnf";
    });
    systems = [ "cl-bnf" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bnf-examples = (build-asdf-system {
    pname = "cl-bnf-examples";
    version = "20230214-git";
    asds = [ "cl-bnf-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bnf/2023-02-14/cl-bnf-20230214-git.tgz";
      sha256 = "05lskaz5kwl4sk8mb13l4kvr3q0q56dyarmznpp1cjpan6rdyr4x";
      system = "cl-bnf-examples";
      asd = "cl-bnf-examples";
    });
    systems = [ "cl-bnf-examples" ];
    lispLibs = [ (getAttr "cl-bnf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bnf-tests = (build-asdf-system {
    pname = "cl-bnf-tests";
    version = "20230214-git";
    asds = [ "cl-bnf-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bnf/2023-02-14/cl-bnf-20230214-git.tgz";
      sha256 = "05lskaz5kwl4sk8mb13l4kvr3q0q56dyarmznpp1cjpan6rdyr4x";
      system = "cl-bnf-tests";
      asd = "cl-bnf-tests";
    });
    systems = [ "cl-bnf-tests" ];
    lispLibs = [ (getAttr "cl-bnf" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bootstrap = (build-asdf-system {
    pname = "cl-bootstrap";
    version = "20180831-git";
    asds = [ "cl-bootstrap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bootstrap/2018-08-31/cl-bootstrap-20180831-git.tgz";
      sha256 = "0pk7wx4arsljxlnbx1hzcgxwsvhdp3gn22wv43xls2jv1rdi2xry";
      system = "cl-bootstrap";
      asd = "cl-bootstrap";
    });
    systems = [ "cl-bootstrap" ];
    lispLibs = [ (getAttr "cl-who" self) (getAttr "parenscript" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bootstrap-demo = (build-asdf-system {
    pname = "cl-bootstrap-demo";
    version = "20180831-git";
    asds = [ "cl-bootstrap-demo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bootstrap/2018-08-31/cl-bootstrap-20180831-git.tgz";
      sha256 = "0pk7wx4arsljxlnbx1hzcgxwsvhdp3gn22wv43xls2jv1rdi2xry";
      system = "cl-bootstrap-demo";
      asd = "cl-bootstrap-demo";
    });
    systems = [ "cl-bootstrap-demo" ];
    lispLibs = [ (getAttr "cl-bootstrap" self) (getAttr "cl-who" self) (getAttr "hunchentoot" self) (getAttr "parenscript" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bootstrap-test = (build-asdf-system {
    pname = "cl-bootstrap-test";
    version = "20180831-git";
    asds = [ "cl-bootstrap-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bootstrap/2018-08-31/cl-bootstrap-20180831-git.tgz";
      sha256 = "0pk7wx4arsljxlnbx1hzcgxwsvhdp3gn22wv43xls2jv1rdi2xry";
      system = "cl-bootstrap-test";
      asd = "cl-bootstrap-test";
    });
    systems = [ "cl-bootstrap-test" ];
    lispLibs = [ (getAttr "cl-bootstrap" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bplustree = (build-asdf-system {
    pname = "cl-bplustree";
    version = "20180328-git";
    asds = [ "cl-bplustree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bplustree/2018-03-28/cl-bplustree-20180328-git.tgz";
      sha256 = "1d9pm9fi9bhh73bhcgig0wq5i4fvc4551kxvny3di6x6yr7j2kbl";
      system = "cl-bplustree";
      asd = "cl-bplustree";
    });
    systems = [ "cl-bplustree" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bplustree-test = (build-asdf-system {
    pname = "cl-bplustree-test";
    version = "20180328-git";
    asds = [ "cl-bplustree-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bplustree/2018-03-28/cl-bplustree-20180328-git.tgz";
      sha256 = "1d9pm9fi9bhh73bhcgig0wq5i4fvc4551kxvny3di6x6yr7j2kbl";
      system = "cl-bplustree-test";
      asd = "cl-bplustree";
    });
    systems = [ "cl-bplustree-test" ];
    lispLibs = [ (getAttr "cl-bplustree" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bson = (build-asdf-system {
    pname = "cl-bson";
    version = "20170403-git";
    asds = [ "cl-bson" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bson/2017-04-03/cl-bson-20170403-git.tgz";
      sha256 = "107mx5kvqw7f7q9mw3qa120gz1z153fwv8jmn5qi2sbfnglkz2gy";
      system = "cl-bson";
      asd = "cl-bson";
    });
    systems = [ "cl-bson" ];
    lispLibs = [ (getAttr "arrow-macros" self) (getAttr "babel" self) (getAttr "cl-intbytes" self) (getAttr "fast-io" self) (getAttr "ieee-floats" self) (getAttr "let-over-lambda" self) (getAttr "local-time" self) (getAttr "named-readtables" self) (getAttr "rutils" self) (getAttr "trivial-shell" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bson-test = (build-asdf-system {
    pname = "cl-bson-test";
    version = "20170403-git";
    asds = [ "cl-bson-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bson/2017-04-03/cl-bson-20170403-git.tgz";
      sha256 = "107mx5kvqw7f7q9mw3qa120gz1z153fwv8jmn5qi2sbfnglkz2gy";
      system = "cl-bson-test";
      asd = "cl-bson-test";
    });
    systems = [ "cl-bson-test" ];
    lispLibs = [ (getAttr "cl-bson" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-buchberger = (build-asdf-system {
    pname = "cl-buchberger";
    version = "20201016-git";
    asds = [ "cl-buchberger" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-buchberger/2020-10-16/cl-buchberger-20201016-git.tgz";
      sha256 = "105kwri3hjla1cydc323y8dfi4cjg0g4hxjzdh13inmvxwcf049w";
      system = "cl-buchberger";
      asd = "cl-buchberger";
    });
    systems = [ "cl-buchberger" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-bus = (build-asdf-system {
    pname = "cl-bus";
    version = "20211209-git";
    asds = [ "cl-bus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-bus/2021-12-09/cl-bus-20211209-git.tgz";
      sha256 = "1galzqm1qv2slibn3awfyxnmlslxmzw09a8fidmbdy1r0ppp5r7z";
      system = "cl-bus";
      asd = "cl-bus";
    });
    systems = [ "cl-bus" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ca = (build-asdf-system {
    pname = "cl-ca";
    version = "20161204-git";
    asds = [ "cl-ca" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ca/2016-12-04/cl-ca-20161204-git.tgz";
      sha256 = "0kpwpxw3c8q7b2ajyj9rzhs1r1h6kipdm9qjkgsn0sqrmx9acfnz";
      system = "cl-ca";
      asd = "cl-ca";
    });
    systems = [ "cl-ca" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cache-tables = (build-asdf-system {
    pname = "cl-cache-tables";
    version = "20171019-git";
    asds = [ "cl-cache-tables" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cache-tables/2017-10-19/cl-cache-tables-20171019-git.tgz";
      sha256 = "008m7v39mq2475y1f4if5iazb15rm02g22id4q4qgig1zx2vfpg1";
      system = "cl-cache-tables";
      asd = "cl-cache-tables";
    });
    systems = [ "cl-cache-tables" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cache-tables-tests = (build-asdf-system {
    pname = "cl-cache-tables-tests";
    version = "20171019-git";
    asds = [ "cl-cache-tables-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cache-tables/2017-10-19/cl-cache-tables-20171019-git.tgz";
      sha256 = "008m7v39mq2475y1f4if5iazb15rm02g22id4q4qgig1zx2vfpg1";
      system = "cl-cache-tables-tests";
      asd = "cl-cache-tables";
    });
    systems = [ "cl-cache-tables-tests" ];
    lispLibs = [ (getAttr "cl-cache-tables" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cairo2 = (build-asdf-system {
    pname = "cl-cairo2";
    version = "20211020-git";
    asds = [ "cl-cairo2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cairo2/2021-10-20/cl-cairo2-20211020-git.tgz";
      sha256 = "0cpfgyxw6pz7y033dlya8c4vjmkpw127zdq3a9xclp9q8jbdlb7q";
      system = "cl-cairo2";
      asd = "cl-cairo2";
    });
    systems = [ "cl-cairo2" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-colors" self) (getAttr "cl-utilities" self) (getAttr "metabang-bind" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-cairo2-demos = (build-asdf-system {
    pname = "cl-cairo2-demos";
    version = "20211020-git";
    asds = [ "cl-cairo2-demos" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cairo2/2021-10-20/cl-cairo2-20211020-git.tgz";
      sha256 = "0cpfgyxw6pz7y033dlya8c4vjmkpw127zdq3a9xclp9q8jbdlb7q";
      system = "cl-cairo2-demos";
      asd = "cl-cairo2-demos";
    });
    systems = [ "cl-cairo2-demos" ];
    lispLibs = [ (getAttr "cl-cairo2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cairo2-xlib = (build-asdf-system {
    pname = "cl-cairo2-xlib";
    version = "20211020-git";
    asds = [ "cl-cairo2-xlib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cairo2/2021-10-20/cl-cairo2-20211020-git.tgz";
      sha256 = "0cpfgyxw6pz7y033dlya8c4vjmkpw127zdq3a9xclp9q8jbdlb7q";
      system = "cl-cairo2-xlib";
      asd = "cl-cairo2-xlib";
    });
    systems = [ "cl-cairo2-xlib" ];
    lispLibs = [ (getAttr "cl-cairo2" self) (getAttr "cl-freetype2" self) ];
    meta = {};
  });
  cl-case-control = (build-asdf-system {
    pname = "cl-case-control";
    version = "20141106-git";
    asds = [ "cl-case-control" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-case-control/2014-11-06/cl-case-control-20141106-git.tgz";
      sha256 = "0510m1dfz4abw3s7w0axr1b1nsmi72avr850r0sn6p2pq091pc71";
      system = "cl-case-control";
      asd = "cl-case-control";
    });
    systems = [ "cl-case-control" ];
    lispLibs = [ (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-catmull-rom-spline = (build-asdf-system {
    pname = "cl-catmull-rom-spline";
    version = "20220220-git";
    asds = [ "cl-catmull-rom-spline" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-catmull-rom-spline/2022-02-20/cl-catmull-rom-spline-20220220-git.tgz";
      sha256 = "0702swja11zpfdx04l0901ipvi0acg17mk9ryvhibnbzq70npyjs";
      system = "cl-catmull-rom-spline";
      asd = "cl-catmull-rom-spline";
    });
    systems = [ "cl-catmull-rom-spline" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cerf = (build-asdf-system {
    pname = "cl-cerf";
    version = "20210531-git";
    asds = [ "cl-cerf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cerf/2021-05-31/cl-cerf-20210531-git.tgz";
      sha256 = "0n1b6ig1d0dqkjn06iqsk0m4y7j7msi2gcq7niivcwc4s0ry0ljn";
      system = "cl-cerf";
      asd = "cl-cerf";
    });
    systems = [ "cl-cerf" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-libffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk = (build-asdf-system {
    pname = "cl-cffi-gtk";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk";
      asd = "cl-cffi-gtk";
    });
    systems = [ "cl-cffi-gtk" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-cairo" self) (getAttr "cl-cffi-gtk-gdk" self) (getAttr "cl-cffi-gtk-gdk-pixbuf" self) (getAttr "cl-cffi-gtk-gio" self) (getAttr "cl-cffi-gtk-glib" self) (getAttr "cl-cffi-gtk-gobject" self) (getAttr "cl-cffi-gtk-pango" self) ];
    meta = {};
  });
  cl-cffi-gtk-cairo = (build-asdf-system {
    pname = "cl-cffi-gtk-cairo";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-cairo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-cairo";
      asd = "cl-cffi-gtk-cairo";
    });
    systems = [ "cl-cffi-gtk-cairo" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-glib" self) ];
    meta = {};
  });
  cl-cffi-gtk-demo-cairo = (build-asdf-system {
    pname = "cl-cffi-gtk-demo-cairo";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-demo-cairo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-demo-cairo";
      asd = "cl-cffi-gtk-demo-cairo";
    });
    systems = [ "cl-cffi-gtk-demo-cairo" ];
    lispLibs = [ (getAttr "cl-cffi-gtk" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk-demo-glib = (build-asdf-system {
    pname = "cl-cffi-gtk-demo-glib";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-demo-glib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-demo-glib";
      asd = "cl-cffi-gtk-demo-glib";
    });
    systems = [ "cl-cffi-gtk-demo-glib" ];
    lispLibs = [ (getAttr "cl-cffi-gtk" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk-demo-gobject = (build-asdf-system {
    pname = "cl-cffi-gtk-demo-gobject";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-demo-gobject" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-demo-gobject";
      asd = "cl-cffi-gtk-demo-gobject";
    });
    systems = [ "cl-cffi-gtk-demo-gobject" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-gobject" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk-example-gtk = (build-asdf-system {
    pname = "cl-cffi-gtk-example-gtk";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-example-gtk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-example-gtk";
      asd = "cl-cffi-gtk-example-gtk";
    });
    systems = [ "cl-cffi-gtk-example-gtk" ];
    lispLibs = [ (getAttr "cl-cffi-gtk" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk-gdk = (build-asdf-system {
    pname = "cl-cffi-gtk-gdk";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-gdk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-gdk";
      asd = "cl-cffi-gtk-gdk";
    });
    systems = [ "cl-cffi-gtk-gdk" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-cairo" self) (getAttr "cl-cffi-gtk-gdk-pixbuf" self) (getAttr "cl-cffi-gtk-gio" self) (getAttr "cl-cffi-gtk-glib" self) (getAttr "cl-cffi-gtk-gobject" self) (getAttr "cl-cffi-gtk-pango" self) ];
    meta = {};
  });
  cl-cffi-gtk-gdk-pixbuf = (build-asdf-system {
    pname = "cl-cffi-gtk-gdk-pixbuf";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-gdk-pixbuf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-gdk-pixbuf";
      asd = "cl-cffi-gtk-gdk-pixbuf";
    });
    systems = [ "cl-cffi-gtk-gdk-pixbuf" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-glib" self) (getAttr "cl-cffi-gtk-gobject" self) ];
    meta = {};
  });
  cl-cffi-gtk-gio = (build-asdf-system {
    pname = "cl-cffi-gtk-gio";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-gio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-gio";
      asd = "cl-cffi-gtk-gio";
    });
    systems = [ "cl-cffi-gtk-gio" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-glib" self) (getAttr "cl-cffi-gtk-gobject" self) ];
    meta = {};
  });
  cl-cffi-gtk-glib = (build-asdf-system {
    pname = "cl-cffi-gtk-glib";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-glib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-glib";
      asd = "cl-cffi-gtk-glib";
    });
    systems = [ "cl-cffi-gtk-glib" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "iterate" self) (getAttr "trivial-features" self) ];
    meta = {};
  });
  cl-cffi-gtk-gobject = (build-asdf-system {
    pname = "cl-cffi-gtk-gobject";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-gobject" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-gobject";
      asd = "cl-cffi-gtk-gobject";
    });
    systems = [ "cl-cffi-gtk-gobject" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-glib" self) (getAttr "closer-mop" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-cffi-gtk-opengl-demo = (build-asdf-system {
    pname = "cl-cffi-gtk-opengl-demo";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-opengl-demo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-opengl-demo";
      asd = "cl-cffi-gtk-opengl-demo";
    });
    systems = [ "cl-cffi-gtk-opengl-demo" ];
    lispLibs = [ (getAttr "cl-cffi-gtk" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cffi-gtk-pango = (build-asdf-system {
    pname = "cl-cffi-gtk-pango";
    version = "20230214-git";
    asds = [ "cl-cffi-gtk-pango" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cffi-gtk/2023-02-14/cl-cffi-gtk-20230214-git.tgz";
      sha256 = "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3";
      system = "cl-cffi-gtk-pango";
      asd = "cl-cffi-gtk-pango";
    });
    systems = [ "cl-cffi-gtk-pango" ];
    lispLibs = [ (getAttr "cl-cffi-gtk-cairo" self) (getAttr "cl-cffi-gtk-glib" self) (getAttr "cl-cffi-gtk-gobject" self) ];
    meta = {};
  });
  cl-change-case = (build-asdf-system {
    pname = "cl-change-case";
    version = "20210411-git";
    asds = [ "cl-change-case" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-change-case/2021-04-11/cl-change-case-20210411-git.tgz";
      sha256 = "027qvcx261g0gwjvwn2n4w0biw1xq3c5s41smbb3ppxszyax82dx";
      system = "cl-change-case";
      asd = "cl-change-case";
    });
    systems = [ "cl-change-case" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-ppcre-unicode" self) ];
    meta = {};
  });
  cl-charms = (build-asdf-system {
    pname = "cl-charms";
    version = "20230618-git";
    asds = [ "cl-charms" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-charms/2023-06-18/cl-charms-20230618-git.tgz";
      sha256 = "0g6kw0b3b8wjb89rv6slyjl55pymadkcf35ig4d22z8igac7kj8b";
      system = "cl-charms";
      asd = "cl-charms";
    });
    systems = [ "cl-charms" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-charms-marquee = (build-asdf-system {
    pname = "cl-charms-marquee";
    version = "20230618-git";
    asds = [ "cl-charms-marquee" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-charms/2023-06-18/cl-charms-20230618-git.tgz";
      sha256 = "0g6kw0b3b8wjb89rv6slyjl55pymadkcf35ig4d22z8igac7kj8b";
      system = "cl-charms-marquee";
      asd = "cl-charms-marquee";
    });
    systems = [ "cl-charms-marquee" ];
    lispLibs = [ (getAttr "cl-charms" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-charms-paint = (build-asdf-system {
    pname = "cl-charms-paint";
    version = "20230618-git";
    asds = [ "cl-charms-paint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-charms/2023-06-18/cl-charms-20230618-git.tgz";
      sha256 = "0g6kw0b3b8wjb89rv6slyjl55pymadkcf35ig4d22z8igac7kj8b";
      system = "cl-charms-paint";
      asd = "cl-charms-paint";
    });
    systems = [ "cl-charms-paint" ];
    lispLibs = [ (getAttr "cl-charms" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-charms-timer = (build-asdf-system {
    pname = "cl-charms-timer";
    version = "20230618-git";
    asds = [ "cl-charms-timer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-charms/2023-06-18/cl-charms-20230618-git.tgz";
      sha256 = "0g6kw0b3b8wjb89rv6slyjl55pymadkcf35ig4d22z8igac7kj8b";
      system = "cl-charms-timer";
      asd = "cl-charms-timer";
    });
    systems = [ "cl-charms-timer" ];
    lispLibs = [ (getAttr "cl-charms" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cheshire-cat = (build-asdf-system {
    pname = "cl-cheshire-cat";
    version = "20121125-git";
    asds = [ "cl-cheshire-cat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cheshire-cat/2012-11-25/cl-cheshire-cat-20121125-git.tgz";
      sha256 = "1kgm1pa2c4r90nfs38x7fsw730nw13z7p6f11rv67hdjcydh2f11";
      system = "cl-cheshire-cat";
      asd = "cl-cheshire-cat";
    });
    systems = [ "cl-cheshire-cat" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-ppcre" self) (getAttr "cl-store" self) (getAttr "hunchentoot" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-clblas = (build-asdf-system {
    pname = "cl-clblas";
    version = "20181018-git";
    asds = [ "cl-clblas" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-clblas/2018-10-18/cl-clblas-20181018-git.tgz";
      sha256 = "0cn4hvywaw97ccnj2wxjf20lh7h7n5fs6rq6kgjyfs9cxcixmvrj";
      system = "cl-clblas";
      asd = "cl-clblas";
    });
    systems = [ "cl-clblas" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-clblas-test = (build-asdf-system {
    pname = "cl-clblas-test";
    version = "20181018-git";
    asds = [ "cl-clblas-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-clblas/2018-10-18/cl-clblas-20181018-git.tgz";
      sha256 = "0cn4hvywaw97ccnj2wxjf20lh7h7n5fs6rq6kgjyfs9cxcixmvrj";
      system = "cl-clblas-test";
      asd = "cl-clblas-test";
    });
    systems = [ "cl-clblas-test" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-clblas" self) (getAttr "cl-oclapi" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cli = (build-asdf-system {
    pname = "cl-cli";
    version = "20151218-git";
    asds = [ "cl-cli" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cli/2015-12-18/cl-cli-20151218-git.tgz";
      sha256 = "0zlifq55r78vfdlqf8jy6rkny73438f1i9cp9a8vybmila5dij3q";
      system = "cl-cli";
      asd = "cl-cli";
    });
    systems = [ "cl-cli" ];
    lispLibs = [ (getAttr "split-sequence" self) ];
    meta = {};
  });
  cl-clsparse = (build-asdf-system {
    pname = "cl-clsparse";
    version = "20190813-git";
    asds = [ "cl-clsparse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-clsparse/2019-08-13/cl-clsparse-20190813-git.tgz";
      sha256 = "0cmmwx2ka1jp5711x21knw3zi6kcpkpcs39dm62w82s97bv794gz";
      system = "cl-clsparse";
      asd = "cl-clsparse";
    });
    systems = [ "cl-clsparse" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-libffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cognito = (build-asdf-system {
    pname = "cl-cognito";
    version = "20181210-git";
    asds = [ "cl-cognito" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cognito/2018-12-10/cl-cognito-20181210-git.tgz";
      sha256 = "0zy4yg4zggvxwbvkjkd89d2ps236kz6pvz90zn6gzq812wnidsd3";
      system = "cl-cognito";
      asd = "cl-cognito";
    });
    systems = [ "cl-cognito" ];
    lispLibs = [ (getAttr "aws-foundation" self) (getAttr "cl-base64" self) (getAttr "cl-json-helper" self) (getAttr "ironclad" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-coinpayments = (build-asdf-system {
    pname = "cl-coinpayments";
    version = "20210807-git";
    asds = [ "cl-coinpayments" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-coinpayments/2021-08-07/cl-coinpayments-20210807-git.tgz";
      sha256 = "1vgsh95vjqqg0a6lqg1ivs36yjx6ck8cqhsmlr5l3ldfd8yr65q7";
      system = "cl-coinpayments";
      asd = "cl-coinpayments";
    });
    systems = [ "cl-coinpayments" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "closer-mop" self) (getAttr "dexador" self) (getAttr "ironclad" self) (getAttr "jonathan" self) (getAttr "str" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-collider = (build-asdf-system {
    pname = "cl-collider";
    version = "20230618-git";
    asds = [ "cl-collider" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-collider/2023-06-18/cl-collider-20230618-git.tgz";
      sha256 = "0q6qp5cy7fc98dqb81j5blqg2da6jf22zzp8r8czzvsg5pgjipgz";
      system = "cl-collider";
      asd = "cl-collider";
    });
    systems = [ "cl-collider" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "named-readtables" self) (getAttr "pileup" self) (getAttr "sc-osc" self) (getAttr "simple-inferiors" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-colors = (build-asdf-system {
    pname = "cl-colors";
    version = "20180328-git";
    asds = [ "cl-colors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-colors/2018-03-28/cl-colors-20180328-git.tgz";
      sha256 = "0l446lday4hybsm9bq3jli97fvv8jb1d33abg79vbylpwjmf3y9a";
      system = "cl-colors";
      asd = "cl-colors";
    });
    systems = [ "cl-colors" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "let-plus" self) ];
    meta = {};
  });
  cl-colors-tests = (build-asdf-system {
    pname = "cl-colors-tests";
    version = "20180328-git";
    asds = [ "cl-colors-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-colors/2018-03-28/cl-colors-20180328-git.tgz";
      sha256 = "0l446lday4hybsm9bq3jli97fvv8jb1d33abg79vbylpwjmf3y9a";
      system = "cl-colors-tests";
      asd = "cl-colors";
    });
    systems = [ "cl-colors-tests" ];
    lispLibs = [ (getAttr "cl-colors" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-colors2 = (build-asdf-system {
    pname = "cl-colors2";
    version = "20230618-git";
    asds = [ "cl-colors2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-colors2/2023-06-18/cl-colors2-20230618-git.tgz";
      sha256 = "00gaynvc91s4cizpmzkbw94ay77jpdvx0jw2qhx06xa4q4kazv01";
      system = "cl-colors2";
      asd = "cl-colors2";
    });
    systems = [ "cl-colors2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) ];
    meta = {};
  });
  cl-conllu = (build-asdf-system {
    pname = "cl-conllu";
    version = "20211209-git";
    asds = [ "cl-conllu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-conllu/2021-12-09/cl-conllu-20211209-git.tgz";
      sha256 = "0n69k0apifnirs2g3rfdsxiwy6dimd9qqxaqywaingvbd7yn42jn";
      system = "cl-conllu";
      asd = "cl-conllu";
    });
    systems = [ "cl-conllu" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-log" self) (getAttr "cl-markup" self) (getAttr "cl-ppcre" self) (getAttr "lispbuilder-lexer" self) (getAttr "optima_dot_ppcre" self) (getAttr "split-sequence" self) (getAttr "uuid" self) (getAttr "wilbur" self) (getAttr "xmls" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-conspack = (build-asdf-system {
    pname = "cl-conspack";
    version = "20230214-git";
    asds = [ "cl-conspack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-conspack/2023-02-14/cl-conspack-20230214-git.tgz";
      sha256 = "0y5wp5c89ph44k2xjppy1c1jf2ac3q9yrk22da2rkwnbxn0h1a8d";
      system = "cl-conspack";
      asd = "cl-conspack";
    });
    systems = [ "cl-conspack" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "fast-io" self) (getAttr "ieee-floats" self) (getAttr "trivial-garbage" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-conspack-test = (build-asdf-system {
    pname = "cl-conspack-test";
    version = "20230214-git";
    asds = [ "cl-conspack-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-conspack/2023-02-14/cl-conspack-20230214-git.tgz";
      sha256 = "0y5wp5c89ph44k2xjppy1c1jf2ac3q9yrk22da2rkwnbxn0h1a8d";
      system = "cl-conspack-test";
      asd = "cl-conspack-test";
    });
    systems = [ "cl-conspack-test" ];
    lispLibs = [ (getAttr "cl-conspack" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cont = (build-asdf-system {
    pname = "cl-cont";
    version = "20110219-darcs";
    asds = [ "cl-cont" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cont/2011-02-19/cl-cont-20110219-darcs.tgz";
      sha256 = "1zf8zvb0i6jm3hhfks4w74hibm6avgc6f9s1qwgjrn2bcik8lrvz";
      system = "cl-cont";
      asd = "cl-cont";
    });
    systems = [ "cl-cont" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cont-test = (build-asdf-system {
    pname = "cl-cont-test";
    version = "20110219-darcs";
    asds = [ "cl-cont-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cont/2011-02-19/cl-cont-20110219-darcs.tgz";
      sha256 = "1zf8zvb0i6jm3hhfks4w74hibm6avgc6f9s1qwgjrn2bcik8lrvz";
      system = "cl-cont-test";
      asd = "cl-cont-test";
    });
    systems = [ "cl-cont-test" ];
    lispLibs = [ (getAttr "cl-cont" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-containers = (build-asdf-system {
    pname = "cl-containers";
    version = "20230214-git";
    asds = [ "cl-containers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-containers/2023-02-14/cl-containers-20230214-git.tgz";
      sha256 = "0gz601vdqkh8mbym61jzvp834wphbyrz3rw26f5b1qh5kxidzdwa";
      system = "cl-containers";
      asd = "cl-containers";
    });
    systems = [ "cl-containers" ];
    lispLibs = [ (getAttr "asdf-system-connections" self) (getAttr "metatilities-base" self) ];
    meta = {};
  });
  cl-containers-test = (build-asdf-system {
    pname = "cl-containers-test";
    version = "20230214-git";
    asds = [ "cl-containers-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-containers/2023-02-14/cl-containers-20230214-git.tgz";
      sha256 = "0gz601vdqkh8mbym61jzvp834wphbyrz3rw26f5b1qh5kxidzdwa";
      system = "cl-containers-test";
      asd = "cl-containers-test";
    });
    systems = [ "cl-containers-test" ];
    lispLibs = [ (getAttr "cl-containers" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cookie = (build-asdf-system {
    pname = "cl-cookie";
    version = "20220707-git";
    asds = [ "cl-cookie" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cookie/2022-07-07/cl-cookie-20220707-git.tgz";
      sha256 = "07hqamcdpdxmx2j7prawgl6cdr13b2jbrhrrhfik5n00ah4yw524";
      system = "cl-cookie";
      asd = "cl-cookie";
    });
    systems = [ "cl-cookie" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "proc-parse" self) (getAttr "quri" self) ];
    meta = {};
  });
  cl-cookie-test = (build-asdf-system {
    pname = "cl-cookie-test";
    version = "20220707-git";
    asds = [ "cl-cookie-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cookie/2022-07-07/cl-cookie-20220707-git.tgz";
      sha256 = "07hqamcdpdxmx2j7prawgl6cdr13b2jbrhrrhfik5n00ah4yw524";
      system = "cl-cookie-test";
      asd = "cl-cookie-test";
    });
    systems = [ "cl-cookie-test" ];
    lispLibs = [ (getAttr "cl-cookie" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-coroutine = (build-asdf-system {
    pname = "cl-coroutine";
    version = "20160929-git";
    asds = [ "cl-coroutine" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-coroutine/2016-09-29/cl-coroutine-20160929-git.tgz";
      sha256 = "1cqdhdjxffgfs116l1swjlsmcbly0xgcgrckvaajd566idj9yj4l";
      system = "cl-coroutine";
      asd = "cl-coroutine";
    });
    systems = [ "cl-coroutine" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-cont" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-coroutine-test = (build-asdf-system {
    pname = "cl-coroutine-test";
    version = "20160929-git";
    asds = [ "cl-coroutine-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-coroutine/2016-09-29/cl-coroutine-20160929-git.tgz";
      sha256 = "1cqdhdjxffgfs116l1swjlsmcbly0xgcgrckvaajd566idj9yj4l";
      system = "cl-coroutine-test";
      asd = "cl-coroutine-test";
    });
    systems = [ "cl-coroutine-test" ];
    lispLibs = [ (getAttr "cl-coroutine" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-coveralls = (build-asdf-system {
    pname = "cl-coveralls";
    version = "20210411-git";
    asds = [ "cl-coveralls" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-coveralls/2021-04-11/cl-coveralls-20210411-git.tgz";
      sha256 = "1n4jks92827xbi2zzy6gsx3r2gl97difl04da9wz94n9rjj3bcz0";
      system = "cl-coveralls";
      asd = "cl-coveralls";
    });
    systems = [ "cl-coveralls" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "dexador" self) (getAttr "flexi-streams" self) (getAttr "ironclad" self) (getAttr "jonathan" self) (getAttr "lquery" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-coveralls-test = (build-asdf-system {
    pname = "cl-coveralls-test";
    version = "20210411-git";
    asds = [ "cl-coveralls-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-coveralls/2021-04-11/cl-coveralls-20210411-git.tgz";
      sha256 = "1n4jks92827xbi2zzy6gsx3r2gl97difl04da9wz94n9rjj3bcz0";
      system = "cl-coveralls-test";
      asd = "cl-coveralls-test";
    });
    systems = [ "cl-coveralls-test" ];
    lispLibs = [ (getAttr "cl-coveralls" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-covid19 = (build-asdf-system {
    pname = "cl-covid19";
    version = "20220331-git";
    asds = [ "cl-covid19" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-covid19/2022-03-31/cl-covid19-20220331-git.tgz";
      sha256 = "0nxdharz29nrdylrwnhgdayfsfwm0vd5g487mi4i5lly8q0i9vl0";
      system = "cl-covid19";
      asd = "cl-covid19";
    });
    systems = [ "cl-covid19" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ascii-table" self) (getAttr "cl-csv" self) (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_dbi" self) (getAttr "cl-migratum_dot_provider_dot_local-path" self) (getAttr "dexador" self) (getAttr "djula" self) (getAttr "jonathan" self) (getAttr "quri" self) (getAttr "tmpdir" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cpu-affinity = (build-asdf-system {
    pname = "cl-cpu-affinity";
    version = "20210411-git";
    asds = [ "cl-cpu-affinity" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/femlisp/2021-04-11/femlisp-20210411-git.tgz";
      sha256 = "08l2x1jq3vfhh8m14wijd8c78n589cy5hd2py2jfj3yfiqyipasa";
      system = "cl-cpu-affinity";
      asd = "cl-cpu-affinity";
    });
    systems = [ "cl-cpu-affinity" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cpus = (build-asdf-system {
    pname = "cl-cpus";
    version = "20230618-git";
    asds = [ "cl-cpus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cpus/2023-06-18/cl-cpus-20230618-git.tgz";
      sha256 = "1gxyb85hpjmhz7vhny9cscrzldx06f7c5q93pl1qs0s3b7avh5vd";
      system = "cl-cpus";
      asd = "cl-cpus";
    });
    systems = [ "cl-cpus" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cram = (build-asdf-system {
    pname = "cl-cram";
    version = "20230618-git";
    asds = [ "cl-cram" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cram/2023-06-18/cl-cram-20230618-git.tgz";
      sha256 = "139p4hbb6ac57ay5vgr969d3rki9ypk9ninaqm5vkax2hcx7mq3i";
      system = "cl-cram";
      asd = "cl-cram";
    });
    systems = [ "cl-cram" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-crc64 = (build-asdf-system {
    pname = "cl-crc64";
    version = "20140713-git";
    asds = [ "cl-crc64" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-crc64/2014-07-13/cl-crc64-20140713-git.tgz";
      sha256 = "1cqky5ps28r49z6ib4vjwfjpq3ml81p2ayf0nqppf2lc4vf3kb20";
      system = "cl-crc64";
      asd = "cl-crc64";
    });
    systems = [ "cl-crc64" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-creditcard = (build-asdf-system {
    pname = "cl-creditcard";
    version = "20150113-git";
    asds = [ "cl-creditcard" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-creditcard/2015-01-13/cl-creditcard-20150113-git.tgz";
      sha256 = "1qq9r7q50k7jw6sv65aqi9xalaw8m6aqsbb0cgpjxv8wdhy934cr";
      system = "cl-creditcard";
      asd = "cl-creditcard";
    });
    systems = [ "cl-creditcard" ];
    lispLibs = [ (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cron = (build-asdf-system {
    pname = "cl-cron";
    version = "20221106-git";
    asds = [ "cl-cron" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cron/2022-11-06/cl-cron-20221106-git.tgz";
      sha256 = "1yl7ajy8b2mf5i9f8x3458s4y00rkkpy70xbzz3fi08l9rp2sp3z";
      system = "cl-cron";
      asd = "cl-cron";
    });
    systems = [ "cl-cron" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-css = (build-asdf-system {
    pname = "cl-css";
    version = "20140914-git";
    asds = [ "cl-css" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-css/2014-09-14/cl-css-20140914-git.tgz";
      sha256 = "1lc42zi2sw11fl2589sc19nr5sd2p0wy7wgvgwaggxa5f3ajhsmd";
      system = "cl-css";
      asd = "cl-css";
    });
    systems = [ "cl-css" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-csv = (build-asdf-system {
    pname = "cl-csv";
    version = "20201016-git";
    asds = [ "cl-csv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-csv/2020-10-16/cl-csv-20201016-git.tgz";
      sha256 = "0gcmlbwx5m3kwgk12qi80w08ak8fgdnvyia429fz6gnxmhg0k54x";
      system = "cl-csv";
      asd = "cl-csv";
    });
    systems = [ "cl-csv" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "iterate" self) ];
    meta = {};
  });
  cl-csv-clsql = (build-asdf-system {
    pname = "cl-csv-clsql";
    version = "20201016-git";
    asds = [ "cl-csv-clsql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-csv/2020-10-16/cl-csv-20201016-git.tgz";
      sha256 = "0gcmlbwx5m3kwgk12qi80w08ak8fgdnvyia429fz6gnxmhg0k54x";
      system = "cl-csv-clsql";
      asd = "cl-csv-clsql";
    });
    systems = [ "cl-csv-clsql" ];
    lispLibs = [ (getAttr "cl-csv" self) (getAttr "clsql-helper" self) (getAttr "data-table-clsql" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-csv-data-table = (build-asdf-system {
    pname = "cl-csv-data-table";
    version = "20201016-git";
    asds = [ "cl-csv-data-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-csv/2020-10-16/cl-csv-20201016-git.tgz";
      sha256 = "0gcmlbwx5m3kwgk12qi80w08ak8fgdnvyia429fz6gnxmhg0k54x";
      system = "cl-csv-data-table";
      asd = "cl-csv-data-table";
    });
    systems = [ "cl-csv-data-table" ];
    lispLibs = [ (getAttr "cl-csv" self) (getAttr "data-table" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cuda = (build-asdf-system {
    pname = "cl-cuda";
    version = "20210807-git";
    asds = [ "cl-cuda" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cuda/2021-08-07/cl-cuda-20210807-git.tgz";
      sha256 = "019m2khbiadm0yxfhbbfsidnmxq9spn3hn8r6vx4cw3i22jin0hg";
      system = "cl-cuda";
      asd = "cl-cuda";
    });
    systems = [ "cl-cuda" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-pattern" self) (getAttr "cl-ppcre" self) (getAttr "cl-reexport" self) (getAttr "external-program" self) (getAttr "osicat" self) (getAttr "split-sequence" self) ];
    meta = {};
  });
  cl-cuda-examples = (build-asdf-system {
    pname = "cl-cuda-examples";
    version = "20210807-git";
    asds = [ "cl-cuda-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cuda/2021-08-07/cl-cuda-20210807-git.tgz";
      sha256 = "019m2khbiadm0yxfhbbfsidnmxq9spn3hn8r6vx4cw3i22jin0hg";
      system = "cl-cuda-examples";
      asd = "cl-cuda-examples";
    });
    systems = [ "cl-cuda-examples" ];
    lispLibs = [ (getAttr "cl-cuda" self) (getAttr "imago" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cuda-interop = (build-asdf-system {
    pname = "cl-cuda-interop";
    version = "20210807-git";
    asds = [ "cl-cuda-interop" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cuda/2021-08-07/cl-cuda-20210807-git.tgz";
      sha256 = "019m2khbiadm0yxfhbbfsidnmxq9spn3hn8r6vx4cw3i22jin0hg";
      system = "cl-cuda-interop";
      asd = "cl-cuda-interop";
    });
    systems = [ "cl-cuda-interop" ];
    lispLibs = [ (getAttr "cl-cuda" self) (getAttr "cl-glu" self) (getAttr "cl-glut" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cuda-interop-examples = (build-asdf-system {
    pname = "cl-cuda-interop-examples";
    version = "20210807-git";
    asds = [ "cl-cuda-interop-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cuda/2021-08-07/cl-cuda-20210807-git.tgz";
      sha256 = "019m2khbiadm0yxfhbbfsidnmxq9spn3hn8r6vx4cw3i22jin0hg";
      system = "cl-cuda-interop-examples";
      asd = "cl-cuda-interop-examples";
    });
    systems = [ "cl-cuda-interop-examples" ];
    lispLibs = [ (getAttr "cl-cuda-interop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-cuda-misc = (build-asdf-system {
    pname = "cl-cuda-misc";
    version = "20210807-git";
    asds = [ "cl-cuda-misc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-cuda/2021-08-07/cl-cuda-20210807-git.tgz";
      sha256 = "019m2khbiadm0yxfhbbfsidnmxq9spn3hn8r6vx4cw3i22jin0hg";
      system = "cl-cuda-misc";
      asd = "cl-cuda-misc";
    });
    systems = [ "cl-cuda-misc" ];
    lispLibs = [ (getAttr "cl-emb" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-custom-hash-table = (build-asdf-system {
    pname = "cl-custom-hash-table";
    version = "20201220-git";
    asds = [ "cl-custom-hash-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-custom-hash-table/2020-12-20/cl-custom-hash-table-20201220-git.tgz";
      sha256 = "1lyp3lhqq3p2n04agaar5v50ai3vd6zvi6yq4phw3fcl2jzdjhk3";
      system = "cl-custom-hash-table";
      asd = "cl-custom-hash-table";
    });
    systems = [ "cl-custom-hash-table" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-custom-hash-table-test = (build-asdf-system {
    pname = "cl-custom-hash-table-test";
    version = "20201220-git";
    asds = [ "cl-custom-hash-table-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-custom-hash-table/2020-12-20/cl-custom-hash-table-20201220-git.tgz";
      sha256 = "1lyp3lhqq3p2n04agaar5v50ai3vd6zvi6yq4phw3fcl2jzdjhk3";
      system = "cl-custom-hash-table-test";
      asd = "cl-custom-hash-table-test";
    });
    systems = [ "cl-custom-hash-table-test" ];
    lispLibs = [ (getAttr "cl-custom-hash-table" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-darksky = (build-asdf-system {
    pname = "cl-darksky";
    version = "20180711-git";
    asds = [ "cl-darksky" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-darksky/2018-07-11/cl-darksky-20180711-git.tgz";
      sha256 = "049rziv10z0ygvm0fi98jlxdd5xcqf9gp6ah7jwn9bcxwg5y0wcf";
      system = "cl-darksky";
      asd = "cl-darksky";
    });
    systems = [ "cl-darksky" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "dexador" self) (getAttr "jonathan" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-darksky-test = (build-asdf-system {
    pname = "cl-darksky-test";
    version = "20180711-git";
    asds = [ "cl-darksky-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-darksky/2018-07-11/cl-darksky-20180711-git.tgz";
      sha256 = "049rziv10z0ygvm0fi98jlxdd5xcqf9gp6ah7jwn9bcxwg5y0wcf";
      system = "cl-darksky-test";
      asd = "cl-darksky-test";
    });
    systems = [ "cl-darksky-test" ];
    lispLibs = [ (getAttr "cl-darksky" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-data-structures = (build-asdf-system {
    pname = "cl-data-structures";
    version = "20230618-git";
    asds = [ "cl-data-structures" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-data-structures/2023-06-18/cl-data-structures-20230618-git.tgz";
      sha256 = "1z4sgwc6q7r3k2cx04b00a6gql20g5nxa6i7n7s5k6x3px96r5gc";
      system = "cl-data-structures";
      asd = "cl-data-structures";
    });
    systems = [ "cl-data-structures" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "documentation-utils-extensions" self) (getAttr "flexichain" self) (getAttr "iterate" self) (getAttr "lparallel" self) (getAttr "metabang-bind" self) (getAttr "more-conditions" self) (getAttr "serapeum" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-data-structures-tests = (build-asdf-system {
    pname = "cl-data-structures-tests";
    version = "20230618-git";
    asds = [ "cl-data-structures-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-data-structures/2023-06-18/cl-data-structures-20230618-git.tgz";
      sha256 = "1z4sgwc6q7r3k2cx04b00a6gql20g5nxa6i7n7s5k6x3px96r5gc";
      system = "cl-data-structures-tests";
      asd = "cl-data-structures-tests";
    });
    systems = [ "cl-data-structures-tests" ];
    lispLibs = [ (getAttr "cl-data-structures" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-date-time-parser = (build-asdf-system {
    pname = "cl-date-time-parser";
    version = "20140713-git";
    asds = [ "cl-date-time-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-date-time-parser/2014-07-13/cl-date-time-parser-20140713-git.tgz";
      sha256 = "0dswpbbb57jm609xxfah25dxxhjzc7qh5lr1a1ffkpms84l0r7m5";
      system = "cl-date-time-parser";
      asd = "cl-date-time-parser";
    });
    systems = [ "cl-date-time-parser" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "parse-float" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dbi = (build-asdf-system {
    pname = "cl-dbi";
    version = "20230618-git";
    asds = [ "cl-dbi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dbi/2023-06-18/cl-dbi-20230618-git.tgz";
      sha256 = "0kkhxiz5b7arsp394yk1qrndvg0069p27vap3ba47cv3z4sb0d50";
      system = "cl-dbi";
      asd = "cl-dbi";
    });
    systems = [ "cl-dbi" ];
    lispLibs = [ (getAttr "dbi" self) ];
    meta = {};
  });
  cl-debug-print = (build-asdf-system {
    pname = "cl-debug-print";
    version = "20210807-git";
    asds = [ "cl-debug-print" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-debug-print/2021-08-07/cl-debug-print-20210807-git.tgz";
      sha256 = "1cm5nybmv0pq9s4lrwhd01rjj1wlcj1sjcrcakabi7w7b5zw4cyh";
      system = "cl-debug-print";
      asd = "cl-debug-print";
    });
    systems = [ "cl-debug-print" ];
    lispLibs = [ (getAttr "cl-syntax" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-debug-print-test = (build-asdf-system {
    pname = "cl-debug-print-test";
    version = "20210807-git";
    asds = [ "cl-debug-print-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-debug-print/2021-08-07/cl-debug-print-20210807-git.tgz";
      sha256 = "1cm5nybmv0pq9s4lrwhd01rjj1wlcj1sjcrcakabi7w7b5zw4cyh";
      system = "cl-debug-print-test";
      asd = "cl-debug-print-test";
    });
    systems = [ "cl-debug-print-test" ];
    lispLibs = [ (getAttr "cl-debug-print" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dejavu = (build-asdf-system {
    pname = "cl-dejavu";
    version = "20210124-git";
    asds = [ "cl-dejavu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dejavu/2021-01-24/cl-dejavu-20210124-git.tgz";
      sha256 = "1lbxiq21bxj8r11c58cqskgn8gnl2p8q1ydkhdsv7i7xnhv2y7r0";
      system = "cl-dejavu";
      asd = "cl-dejavu";
    });
    systems = [ "cl-dejavu" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-devil = (build-asdf-system {
    pname = "cl-devil";
    version = "20150302-git";
    asds = [ "cl-devil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-devil/2015-03-02/cl-devil-20150302-git.tgz";
      sha256 = "1qdjb7xwzjkv99s8q0834lfdq4ch5j2ymrmqsvwzhg47ys17pvvf";
      system = "cl-devil";
      asd = "cl-devil";
    });
    systems = [ "cl-devil" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-diceware = (build-asdf-system {
    pname = "cl-diceware";
    version = "20150923-git";
    asds = [ "cl-diceware" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-diceware/2015-09-23/cl-diceware-20150923-git.tgz";
      sha256 = "0560ji51ksp8kngn2pyi41vw9zlnwiqj64ici43lzjx0qgv5v84l";
      system = "cl-diceware";
      asd = "cl-diceware";
    });
    systems = [ "cl-diceware" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-difflib = (build-asdf-system {
    pname = "cl-difflib";
    version = "20130128-git";
    asds = [ "cl-difflib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-difflib/2013-01-28/cl-difflib-20130128-git.tgz";
      sha256 = "08if0abhqg191xcz9s7xv8faqq51nswzp8hw423fkqjzr24pmq48";
      system = "cl-difflib";
      asd = "cl-difflib";
    });
    systems = [ "cl-difflib" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-difflib-tests = (build-asdf-system {
    pname = "cl-difflib-tests";
    version = "20130128-git";
    asds = [ "cl-difflib-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-difflib/2013-01-28/cl-difflib-20130128-git.tgz";
      sha256 = "08if0abhqg191xcz9s7xv8faqq51nswzp8hw423fkqjzr24pmq48";
      system = "cl-difflib-tests";
      asd = "cl-difflib-tests";
    });
    systems = [ "cl-difflib-tests" ];
    lispLibs = [ (getAttr "cl-difflib" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-digraph = (build-asdf-system {
    pname = "cl-digraph";
    version = "20230214-hg";
    asds = [ "cl-digraph" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-digraph/2023-02-14/cl-digraph-20230214-hg.tgz";
      sha256 = "12s787nx5ppll581rccblxqalb653iq9z5bzivqm4dnibh5v83f2";
      system = "cl-digraph";
      asd = "cl-digraph";
    });
    systems = [ "cl-digraph" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-digraph_dot_dot = (build-asdf-system {
    pname = "cl-digraph.dot";
    version = "20230214-hg";
    asds = [ "cl-digraph.dot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-digraph/2023-02-14/cl-digraph-20230214-hg.tgz";
      sha256 = "12s787nx5ppll581rccblxqalb653iq9z5bzivqm4dnibh5v83f2";
      system = "cl-digraph.dot";
      asd = "cl-digraph.dot";
    });
    systems = [ "cl-digraph.dot" ];
    lispLibs = [ (getAttr "cl-digraph" self) (getAttr "cl-dot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-digraph_dot_test = (build-asdf-system {
    pname = "cl-digraph.test";
    version = "20230214-hg";
    asds = [ "cl-digraph.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-digraph/2023-02-14/cl-digraph-20230214-hg.tgz";
      sha256 = "12s787nx5ppll581rccblxqalb653iq9z5bzivqm4dnibh5v83f2";
      system = "cl-digraph.test";
      asd = "cl-digraph.test";
    });
    systems = [ "cl-digraph.test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "alexandria" self) (getAttr "cl-digraph" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-diskspace = (build-asdf-system {
    pname = "cl-diskspace";
    version = "20220331-git";
    asds = [ "cl-diskspace" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-diskspace/2022-03-31/cl-diskspace-20220331-git.tgz";
      sha256 = "0l19hxqw6b8i5i1jdbr45k1xib9axcwdagsp3y8wkb35g6wwc0s7";
      system = "cl-diskspace";
      asd = "cl-diskspace";
    });
    systems = [ "cl-diskspace" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-disque = (build-asdf-system {
    pname = "cl-disque";
    version = "20171227-git";
    asds = [ "cl-disque" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-disque/2017-12-27/cl-disque-20171227-git.tgz";
      sha256 = "0z26ls9vzlq43fwn307nb7xvqck5h3l9yygf93b0filki83krg3s";
      system = "cl-disque";
      asd = "cl-disque";
    });
    systems = [ "cl-disque" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "rutils" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-disque-test = (build-asdf-system {
    pname = "cl-disque-test";
    version = "20171227-git";
    asds = [ "cl-disque-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-disque/2017-12-27/cl-disque-20171227-git.tgz";
      sha256 = "0z26ls9vzlq43fwn307nb7xvqck5h3l9yygf93b0filki83krg3s";
      system = "cl-disque-test";
      asd = "cl-disque-test";
    });
    systems = [ "cl-disque-test" ];
    lispLibs = [ (getAttr "cl-disque" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-djula-svg = (build-asdf-system {
    pname = "cl-djula-svg";
    version = "20221106-git";
    asds = [ "cl-djula-svg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-djula-svg/2022-11-06/cl-djula-svg-20221106-git.tgz";
      sha256 = "1jxgngr51ars234by4vnczfqmkwi2iy94sdxnj3pkjrdximy5any";
      system = "cl-djula-svg";
      asd = "cl-djula-svg";
    });
    systems = [ "cl-djula-svg" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "xmls" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-djula-tailwind = (build-asdf-system {
    pname = "cl-djula-tailwind";
    version = "20221106-git";
    asds = [ "cl-djula-tailwind" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-djula-tailwind/2022-11-06/cl-djula-tailwind-20221106-git.tgz";
      sha256 = "059mfgh53gpj74rgr7b61fnm24bwx8hdrw15mjk687y9sna3avda";
      system = "cl-djula-tailwind";
      asd = "cl-djula-tailwind";
    });
    systems = [ "cl-djula-tailwind" ];
    lispLibs = [ (getAttr "cl-css" self) (getAttr "cl-minify-css" self) (getAttr "cl-ppcre" self) (getAttr "djula" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dot = (build-asdf-system {
    pname = "cl-dot";
    version = "20220707-git";
    asds = [ "cl-dot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dot/2022-07-07/cl-dot-20220707-git.tgz";
      sha256 = "0mcvzqfcg5rzr8rz8aa2yr2jl3ifflaksvps08zj71hbhiacqpxa";
      system = "cl-dot";
      asd = "cl-dot";
    });
    systems = [ "cl-dot" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-dotenv = (build-asdf-system {
    pname = "cl-dotenv";
    version = "20181018-git";
    asds = [ "cl-dotenv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dotenv/2018-10-18/cl-dotenv-20181018-git.tgz";
      sha256 = "0cdbk886aizsnqqs3z4jfn8nyrnxj4yb3y00av49xc4h83h6xn53";
      system = "cl-dotenv";
      asd = "cl-dotenv";
    });
    systems = [ "cl-dotenv" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "serapeum" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dotenv-test = (build-asdf-system {
    pname = "cl-dotenv-test";
    version = "20181018-git";
    asds = [ "cl-dotenv-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dotenv/2018-10-18/cl-dotenv-20181018-git.tgz";
      sha256 = "0cdbk886aizsnqqs3z4jfn8nyrnxj4yb3y00av49xc4h83h6xn53";
      system = "cl-dotenv-test";
      asd = "cl-dotenv-test";
    });
    systems = [ "cl-dotenv-test" ];
    lispLibs = [ (getAttr "cl-dotenv" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-drawille = (build-asdf-system {
    pname = "cl-drawille";
    version = "20210807-git";
    asds = [ "cl-drawille" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-drawille/2021-08-07/cl-drawille-20210807-git.tgz";
      sha256 = "0wmiz0c7h2zsfj7inzzn8jivnfsc94rq8pczfi44h36n2jg6hdys";
      system = "cl-drawille";
      asd = "cl-drawille";
    });
    systems = [ "cl-drawille" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "osicat" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-drm = (build-asdf-system {
    pname = "cl-drm";
    version = "20161204-git";
    asds = [ "cl-drm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-drm/2016-12-04/cl-drm-20161204-git.tgz";
      sha256 = "018jsdi9hs71x14mq18k08hwrgdvvbc2yqbqww6gara0bg9cl3l6";
      system = "cl-drm";
      asd = "cl-drm";
    });
    systems = [ "cl-drm" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dropbox = (build-asdf-system {
    pname = "cl-dropbox";
    version = "20150608-git";
    asds = [ "cl-dropbox" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dropbox/2015-06-08/cl-dropbox-20150608-git.tgz";
      sha256 = "09giwr1wlz42flrpy71gv60p53nixjk9jaj4lirgf59dkh718f9x";
      system = "cl-dropbox";
      asd = "cl-dropbox";
    });
    systems = [ "cl-dropbox" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "cl-oauth" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dsl = (build-asdf-system {
    pname = "cl-dsl";
    version = "20130720-git";
    asds = [ "cl-dsl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dsl/2013-07-20/cl-dsl-20130720-git.tgz";
      sha256 = "1bj5yp20r8z6gi6rpf88kpy4i06c8i2d3cg5sjlq7d1ninkb4gg4";
      system = "cl-dsl";
      asd = "cl-dsl";
    });
    systems = [ "cl-dsl" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-dsl-tests = (build-asdf-system {
    pname = "cl-dsl-tests";
    version = "20130720-git";
    asds = [ "cl-dsl-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-dsl/2013-07-20/cl-dsl-20130720-git.tgz";
      sha256 = "1bj5yp20r8z6gi6rpf88kpy4i06c8i2d3cg5sjlq7d1ninkb4gg4";
      system = "cl-dsl-tests";
      asd = "cl-dsl";
    });
    systems = [ "cl-dsl-tests" ];
    lispLibs = [ (getAttr "cl-dsl" self) (getAttr "eos" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-durian = (build-asdf-system {
    pname = "cl-durian";
    version = "20150608-git";
    asds = [ "cl-durian" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-durian/2015-06-08/cl-durian-20150608-git.tgz";
      sha256 = "0s89gr5gwwkyirrv7l5fzk9ws7fhy087c3myksblsh00z1xcrvng";
      system = "cl-durian";
      asd = "cl-durian";
    });
    systems = [ "cl-durian" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-earley-parser = (build-asdf-system {
    pname = "cl-earley-parser";
    version = "20211020-git";
    asds = [ "cl-earley-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-earley-parser/2021-10-20/cl-earley-parser-20211020-git.tgz";
      sha256 = "1pkry3ynxn2y3nf13lc3zjqgf4hx43d9zb0w0m34s51xd4xp2h1x";
      system = "cl-earley-parser";
      asd = "cl-earley-parser";
    });
    systems = [ "cl-earley-parser" ];
    lispLibs = [ (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ecma-48 = (build-asdf-system {
    pname = "cl-ecma-48";
    version = "20200218-http";
    asds = [ "cl-ecma-48" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ecma-48/2020-02-18/cl-ecma-48-20200218-http.tgz";
      sha256 = "1y3srzahci25qp959b87m82d1i1i8jmq039yp9nf0hifxyhw6dgy";
      system = "cl-ecma-48";
      asd = "cl-ecma-48";
    });
    systems = [ "cl-ecma-48" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-egl = (build-asdf-system {
    pname = "cl-egl";
    version = "20190521-git";
    asds = [ "cl-egl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-egl/2019-05-21/cl-egl-20190521-git.tgz";
      sha256 = "19shhzmdc9f1128slc9m4ns6zraka99awqgb4dkrwzgv7w3miqfl";
      system = "cl-egl";
      asd = "cl-egl";
    });
    systems = [ "cl-egl" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-elastic = (build-asdf-system {
    pname = "cl-elastic";
    version = "20200218-git";
    asds = [ "cl-elastic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-elastic/2020-02-18/cl-elastic-20200218-git.tgz";
      sha256 = "107ha226n3mxzvm0cp8kvgybcv4rr0b4lwik4f4j7lrhz6xvnncq";
      system = "cl-elastic";
      asd = "cl-elastic";
    });
    systems = [ "cl-elastic" ];
    lispLibs = [ (getAttr "drakma" self) (getAttr "named-readtables" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-elastic-test = (build-asdf-system {
    pname = "cl-elastic-test";
    version = "20200218-git";
    asds = [ "cl-elastic-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-elastic/2020-02-18/cl-elastic-20200218-git.tgz";
      sha256 = "107ha226n3mxzvm0cp8kvgybcv4rr0b4lwik4f4j7lrhz6xvnncq";
      system = "cl-elastic-test";
      asd = "cl-elastic-test";
    });
    systems = [ "cl-elastic-test" ];
    lispLibs = [ (getAttr "cl-elastic" self) (getAttr "named-readtables" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-emacs-if = (build-asdf-system {
    pname = "cl-emacs-if";
    version = "20120305-git";
    asds = [ "cl-emacs-if" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-emacs-if/2012-03-05/cl-emacs-if-20120305-git.tgz";
      sha256 = "0br3jvihq24ymqjn2r2qnl3l099r329bsqh18nmkk3yw3kclrcfv";
      system = "cl-emacs-if";
      asd = "cl-emacs-if";
    });
    systems = [ "cl-emacs-if" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-emb = (build-asdf-system {
    pname = "cl-emb";
    version = "20190521-git";
    asds = [ "cl-emb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-emb/2019-05-21/cl-emb-20190521-git.tgz";
      sha256 = "1xcm31n7afh5316lwz8iqbjx7kn5lw0l11arg8mhdmkx42aj4gkk";
      system = "cl-emb";
      asd = "cl-emb";
    });
    systems = [ "cl-emb" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {};
  });
  cl-emoji = (build-asdf-system {
    pname = "cl-emoji";
    version = "20200218-git";
    asds = [ "cl-emoji" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-emoji/2020-02-18/cl-emoji-20200218-git.tgz";
      sha256 = "1v91kzx42qyjm936frvfsr0cgnj9g197x78xlda6x7x6xri2r9gm";
      system = "cl-emoji";
      asd = "cl-emoji";
    });
    systems = [ "cl-emoji" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-emoji-test = (build-asdf-system {
    pname = "cl-emoji-test";
    version = "20200218-git";
    asds = [ "cl-emoji-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-emoji/2020-02-18/cl-emoji-20200218-git.tgz";
      sha256 = "1v91kzx42qyjm936frvfsr0cgnj9g197x78xlda6x7x6xri2r9gm";
      system = "cl-emoji-test";
      asd = "cl-emoji-test";
    });
    systems = [ "cl-emoji-test" ];
    lispLibs = [ (getAttr "cl-emoji" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-env = (build-asdf-system {
    pname = "cl-env";
    version = "20180430-git";
    asds = [ "cl-env" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-env/2018-04-30/cl-env-20180430-git.tgz";
      sha256 = "1r0d004gr1za9ib53jhxkx315wd4av0ar2063dcvs9g4nahk2d07";
      system = "cl-env";
      asd = "cl-env";
    });
    systems = [ "cl-env" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-environments = (build-asdf-system {
    pname = "cl-environments";
    version = "20211020-git";
    asds = [ "cl-environments" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-environments/2021-10-20/cl-environments-20211020-git.tgz";
      sha256 = "0k3f1sldd6nwphz80vc4k28z9g56rylln4admag628cyswx4qz99";
      system = "cl-environments";
      asd = "cl-environments";
    });
    systems = [ "cl-environments" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "collectors" self) (getAttr "optima" self) (getAttr "parse-declarations-1_dot_0" self) ];
    meta = {};
  });
  cl-epoch = (build-asdf-system {
    pname = "cl-epoch";
    version = "20181210-git";
    asds = [ "cl-epoch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-epoch/2018-12-10/cl-epoch-20181210-git.tgz";
      sha256 = "091p6j5l85afzcm3m9myxzr8j3hiwh0iyj8w0sgld85n2ykbbird";
      system = "cl-epoch";
      asd = "cl-epoch";
    });
    systems = [ "cl-epoch" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-etcd = (build-asdf-system {
    pname = "cl-etcd";
    version = "20230214-git";
    asds = [ "cl-etcd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-etcd/2023-02-14/cl-etcd-20230214-git.tgz";
      sha256 = "0bals10r07prxvjxd744vz02ri72isf168lkhrx9qkc96hd214ah";
      system = "cl-etcd";
      asd = "cl-etcd";
    });
    systems = [ "cl-etcd" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "async-process" self) (getAttr "bordeaux-threads" self) (getAttr "cl-base64" self) (getAttr "cl-json" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "str" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-events = (build-asdf-system {
    pname = "cl-events";
    version = "20160318-git";
    asds = [ "cl-events" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-events/2016-03-18/cl-events-20160318-git.tgz";
      sha256 = "1r847q1bwblnb2395dsydylr9nxgjx7gdwc9dx1051zhvi9in36g";
      system = "cl-events";
      asd = "cl-events";
    });
    systems = [ "cl-events" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "blackbird" self) (getAttr "iterate" self) (getAttr "log4cl" self) (getAttr "lparallel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-events_dot_test = (build-asdf-system {
    pname = "cl-events.test";
    version = "20160318-git";
    asds = [ "cl-events.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-events/2016-03-18/cl-events-20160318-git.tgz";
      sha256 = "1r847q1bwblnb2395dsydylr9nxgjx7gdwc9dx1051zhvi9in36g";
      system = "cl-events.test";
      asd = "cl-events.test";
    });
    systems = [ "cl-events.test" ];
    lispLibs = [ (getAttr "cl-events" self) (getAttr "log4cl" self) (getAttr "mw-equiv" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ewkb = (build-asdf-system {
    pname = "cl-ewkb";
    version = "20110619-git";
    asds = [ "cl-ewkb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ewkb/2011-06-19/cl-ewkb-20110619-git.tgz";
      sha256 = "1mk5j34m9gkwl7c4d464l42gclxlrcpifp2nq41z3fsfl8badn6w";
      system = "cl-ewkb";
      asd = "cl-ewkb";
    });
    systems = [ "cl-ewkb" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "ieee-floats" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ewkb-tests = (build-asdf-system {
    pname = "cl-ewkb-tests";
    version = "20110619-git";
    asds = [ "cl-ewkb-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ewkb/2011-06-19/cl-ewkb-20110619-git.tgz";
      sha256 = "1mk5j34m9gkwl7c4d464l42gclxlrcpifp2nq41z3fsfl8badn6w";
      system = "cl-ewkb-tests";
      asd = "cl-ewkb";
    });
    systems = [ "cl-ewkb-tests" ];
    lispLibs = [ (getAttr "cl-ewkb" self) (getAttr "postmodern" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-factoring = (build-asdf-system {
    pname = "cl-factoring";
    version = "20221106-git";
    asds = [ "cl-factoring" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-factoring/2022-11-06/cl-factoring-20221106-git.tgz";
      sha256 = "0vn3kb8mmi93pr76lx1mbwp7qc2krzb0ayzcrffwq2aw2q201fhd";
      system = "cl-factoring";
      asd = "cl-factoring";
    });
    systems = [ "cl-factoring" ];
    lispLibs = [ (getAttr "cl-primality" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fad = (build-asdf-system {
    pname = "cl-fad";
    version = "20220220-git";
    asds = [ "cl-fad" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fad/2022-02-20/cl-fad-20220220-git.tgz";
      sha256 = "0a1xqldrq170lflnns3xp6swpnvsvllf5vq0h7sz8jqh4riqlny6";
      system = "cl-fad";
      asd = "cl-fad";
    });
    systems = [ "cl-fad" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) ];
    meta = {};
  });
  cl-fam = (build-asdf-system {
    pname = "cl-fam";
    version = "20121125-git";
    asds = [ "cl-fam" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fam/2012-11-25/cl-fam-20121125-git.tgz";
      sha256 = "1imv87imhxvigghx3l28kbsldz6hpqd32280wjwffqwvadhx0gng";
      system = "cl-fam";
      asd = "cl-fam";
    });
    systems = [ "cl-fam" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fast-ecs = (build-asdf-system {
    pname = "cl-fast-ecs";
    version = "20230618-git";
    asds = [ "cl-fast-ecs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fast-ecs/2023-06-18/cl-fast-ecs-20230618-git.tgz";
      sha256 = "00nw5nwzcz8x1x1lycmjik8pcqzxrl896j0xjjl33rjljsmj45sx";
      system = "cl-fast-ecs";
      asd = "cl-fast-ecs";
    });
    systems = [ "cl-fast-ecs" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fastcgi = (build-asdf-system {
    pname = "cl-fastcgi";
    version = "20210124-git";
    asds = [ "cl-fastcgi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fastcgi/2021-01-24/cl-fastcgi-20210124-git.tgz";
      sha256 = "0xgmhx766q4nmrvn5z7ag3ikpr9phlh8ypi8b14azshq9lqbq0m7";
      system = "cl-fastcgi";
      asd = "cl-fastcgi";
    });
    systems = [ "cl-fastcgi" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fbclient = (build-asdf-system {
    pname = "cl-fbclient";
    version = "20140113-git";
    asds = [ "cl-fbclient" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fbclient/2014-01-13/cl-fbclient-20140113-git.tgz";
      sha256 = "1q2dwizrjnal3fdcdgim4kdq0dma71p3s8w6i8bjkg4fs49k5p9j";
      system = "cl-fbclient";
      asd = "cl-fbclient";
    });
    systems = [ "cl-fbclient" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fbx = (build-asdf-system {
    pname = "cl-fbx";
    version = "20230618-git";
    asds = [ "cl-fbx" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fbx/2023-06-18/cl-fbx-20230618-git.tgz";
      sha256 = "0aki1k91qvgn0qa0s4fj734dc89wqmi348s8ya6491kpbpxcvygf";
      system = "cl-fbx";
      asd = "cl-fbx";
    });
    systems = [ "cl-fbx" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "float-features" self) (getAttr "static-vectors" self) (getAttr "trivial-extensible-sequences" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-feedparser = (build-asdf-system {
    pname = "cl-feedparser";
    version = "20230618-git";
    asds = [ "cl-feedparser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-feedparser/2023-06-18/cl-feedparser-20230618-git.tgz";
      sha256 = "18cl4318g8szhdsqvg68ajry91m1hn0znmsqd0r2ikq6l5wpixmb";
      system = "cl-feedparser";
      asd = "cl-feedparser";
    });
    systems = [ "cl-feedparser" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "asdf-package-system" self) (getAttr "cl-html5-parser" self) (getAttr "cl-ppcre" self) (getAttr "fset" self) (getAttr "fxml" self) (getAttr "local-time" self) (getAttr "net-telent-date" self) (getAttr "plump" self) (getAttr "quri" self) (getAttr "serapeum" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-feedparser-tests = (build-asdf-system {
    pname = "cl-feedparser-tests";
    version = "20230618-git";
    asds = [ "cl-feedparser-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-feedparser/2023-06-18/cl-feedparser-20230618-git.tgz";
      sha256 = "18cl4318g8szhdsqvg68ajry91m1hn0znmsqd0r2ikq6l5wpixmb";
      system = "cl-feedparser-tests";
      asd = "cl-feedparser-tests";
    });
    systems = [ "cl-feedparser-tests" ];
    lispLibs = [ (getAttr "cl-feedparser" self) (getAttr "fiveam" self) (getAttr "fxml" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fix = (build-asdf-system {
    pname = "cl-fix";
    version = "20230214-git";
    asds = [ "cl-fix" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fix/2023-02-14/cl-fix-20230214-git.tgz";
      sha256 = "0hw9sms558vn964sw5bav74wmfahf066nqj1xyd6b3f1lz3jarbb";
      system = "cl-fix";
      asd = "cl-fix";
    });
    systems = [ "cl-fix" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "arrow-macros" self) (getAttr "bordeaux-threads" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "log4cl" self) (getAttr "parse-number" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fixtures = (build-asdf-system {
    pname = "cl-fixtures";
    version = "20200325-git";
    asds = [ "cl-fixtures" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fixtures/2020-03-25/cl-fixtures-20200325-git.tgz";
      sha256 = "01z8brw32lv8lqn6r9srwrna5gkd4cyncpbpg6pc0khgdxzpzaag";
      system = "cl-fixtures";
      asd = "cl-fixtures";
    });
    systems = [ "cl-fixtures" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fixtures-test = (build-asdf-system {
    pname = "cl-fixtures-test";
    version = "20200325-git";
    asds = [ "cl-fixtures-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fixtures/2020-03-25/cl-fixtures-20200325-git.tgz";
      sha256 = "01z8brw32lv8lqn6r9srwrna5gkd4cyncpbpg6pc0khgdxzpzaag";
      system = "cl-fixtures-test";
      asd = "cl-fixtures-test";
    });
    systems = [ "cl-fixtures-test" ];
    lispLibs = [ (getAttr "cl-fixtures" self) (getAttr "incf-cl" self) (getAttr "prove" self) (getAttr "prove-asdf" self) (getAttr "rutils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-flac = (build-asdf-system {
    pname = "cl-flac";
    version = "20190710-git";
    asds = [ "cl-flac" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-flac/2019-07-10/cl-flac-20190710-git.tgz";
      sha256 = "1dgr5xqf175hzq3sxpbixxia2k2g3rz0pn6msch4dnvk7a1naqlc";
      system = "cl-flac";
      asd = "cl-flac";
    });
    systems = [ "cl-flac" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-flow = (build-asdf-system {
    pname = "cl-flow";
    version = "stable-git";
    asds = [ "cl-flow" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-flow/2022-07-07/cl-flow-stable-git.tgz";
      sha256 = "0mh9g0zj2kwnsq31zg4af5k9jvfbwp28zx02f0r1jlg2rha87vlg";
      system = "cl-flow";
      asd = "cl-flow";
    });
    systems = [ "cl-flow" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-muth" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-flowd = (build-asdf-system {
    pname = "cl-flowd";
    version = "20140713-git";
    asds = [ "cl-flowd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-flowd/2014-07-13/cl-flowd-20140713-git.tgz";
      sha256 = "0qppiqgy4fgvkm519bqjrw1mfp90q8fs1spvawf24d1nzslf51pj";
      system = "cl-flowd";
      asd = "cl-flowd";
    });
    systems = [ "cl-flowd" ];
    lispLibs = [ (getAttr "cl-annot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fluent-logger = (build-asdf-system {
    pname = "cl-fluent-logger";
    version = "20211020-git";
    asds = [ "cl-fluent-logger" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fluent-logger/2021-10-20/cl-fluent-logger-20211020-git.tgz";
      sha256 = "14q7ymdg3hsri2z2c8fb1syqgdlk8b288v4gw645dbaxfpava2qq";
      system = "cl-fluent-logger";
      asd = "cl-fluent-logger";
    });
    systems = [ "cl-fluent-logger" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-messagepack" self) (getAttr "jonathan" self) (getAttr "local-time" self) (getAttr "pack" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fluiddb = (build-asdf-system {
    pname = "cl-fluiddb";
    version = "20130312-git";
    asds = [ "cl-fluiddb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fluidinfo/2013-03-12/cl-fluidinfo-20130312-git.tgz";
      sha256 = "0npkkp2w88f6vb9pckjp4q4d4idx9p2s4s4imljs2vfym2j3w0wb";
      system = "cl-fluiddb";
      asd = "cl-fluiddb";
    });
    systems = [ "cl-fluiddb" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-json" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fluiddb-test = (build-asdf-system {
    pname = "cl-fluiddb-test";
    version = "20130312-git";
    asds = [ "cl-fluiddb-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fluidinfo/2013-03-12/cl-fluidinfo-20130312-git.tgz";
      sha256 = "0npkkp2w88f6vb9pckjp4q4d4idx9p2s4s4imljs2vfym2j3w0wb";
      system = "cl-fluiddb-test";
      asd = "cl-fluiddb-test";
    });
    systems = [ "cl-fluiddb-test" ];
    lispLibs = [ (getAttr "cl-fluiddb" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fluidinfo = (build-asdf-system {
    pname = "cl-fluidinfo";
    version = "20130312-git";
    asds = [ "cl-fluidinfo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fluidinfo/2013-03-12/cl-fluidinfo-20130312-git.tgz";
      sha256 = "0npkkp2w88f6vb9pckjp4q4d4idx9p2s4s4imljs2vfym2j3w0wb";
      system = "cl-fluidinfo";
      asd = "cl-fluidinfo";
    });
    systems = [ "cl-fluidinfo" ];
    lispLibs = [ (getAttr "cl-fluiddb" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fond = (build-asdf-system {
    pname = "cl-fond";
    version = "20191130-git";
    asds = [ "cl-fond" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fond/2019-11-30/cl-fond-20191130-git.tgz";
      sha256 = "03ygcw1azb44bhdsqcq99xi4ci0by76ap5jf5l2d1vfxq04v8grq";
      system = "cl-fond";
      asd = "cl-fond";
    });
    systems = [ "cl-fond" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-opengl" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-form-types = (build-asdf-system {
    pname = "cl-form-types";
    version = "20230618-git";
    asds = [ "cl-form-types" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-form-types/2023-06-18/cl-form-types-20230618-git.tgz";
      sha256 = "0755anv54zlk3cdxw972x4i353zwzwckm6ybda8hk07akgryqqfk";
      system = "cl-form-types";
      asd = "cl-form-types";
    });
    systems = [ "cl-form-types" ];
    lispLibs = [ (getAttr "agutil" self) (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "arrows" self) (getAttr "cl-environments" self) (getAttr "introspect-environment" self) (getAttr "optima" self) ];
    meta = {};
  });
  cl-forms = (build-asdf-system {
    pname = "cl-forms";
    version = "20230618-git";
    asds = [ "cl-forms" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms";
      asd = "cl-forms";
    });
    systems = [ "cl-forms" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "clavier" self) (getAttr "fmt" self) (getAttr "hunchentoot" self) (getAttr "ironclad" self) (getAttr "str" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_demo = (build-asdf-system {
    pname = "cl-forms.demo";
    version = "20230618-git";
    asds = [ "cl-forms.demo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.demo";
      asd = "cl-forms.demo";
    });
    systems = [ "cl-forms.demo" ];
    lispLibs = [ (getAttr "cl-css" self) (getAttr "cl-forms" self) (getAttr "cl-forms_dot_djula" self) (getAttr "cl-forms_dot_test" self) (getAttr "cl-forms_dot_who" self) (getAttr "cl-forms_dot_who_dot_bootstrap" self) (getAttr "cl-who" self) (getAttr "djula" self) (getAttr "hunchentoot" self) (getAttr "trivial-open-browser" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_djula = (build-asdf-system {
    pname = "cl-forms.djula";
    version = "20230618-git";
    asds = [ "cl-forms.djula" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.djula";
      asd = "cl-forms.djula";
    });
    systems = [ "cl-forms.djula" ];
    lispLibs = [ (getAttr "cl-forms" self) (getAttr "cl-forms_dot_who" self) (getAttr "djula" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_peppol = (build-asdf-system {
    pname = "cl-forms.peppol";
    version = "20230618-git";
    asds = [ "cl-forms.peppol" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.peppol";
      asd = "cl-forms.peppol";
    });
    systems = [ "cl-forms.peppol" ];
    lispLibs = [ (getAttr "cl-forms" self) (getAttr "peppol" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_test = (build-asdf-system {
    pname = "cl-forms.test";
    version = "20230618-git";
    asds = [ "cl-forms.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.test";
      asd = "cl-forms.test";
    });
    systems = [ "cl-forms.test" ];
    lispLibs = [ (getAttr "cl-forms" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_who = (build-asdf-system {
    pname = "cl-forms.who";
    version = "20230618-git";
    asds = [ "cl-forms.who" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.who";
      asd = "cl-forms.who";
    });
    systems = [ "cl-forms.who" ];
    lispLibs = [ (getAttr "cl-forms" self) (getAttr "cl-who" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-forms_dot_who_dot_bootstrap = (build-asdf-system {
    pname = "cl-forms.who.bootstrap";
    version = "20230618-git";
    asds = [ "cl-forms.who.bootstrap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-forms/2023-06-18/cl-forms-20230618-git.tgz";
      sha256 = "1mwy1j5m1vb8bis5lzprkf4xgbgb941f39wbzw3viqk6r2v54qzx";
      system = "cl-forms.who.bootstrap";
      asd = "cl-forms.who.bootstrap";
    });
    systems = [ "cl-forms.who.bootstrap" ];
    lispLibs = [ (getAttr "cl-forms_dot_who" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-freeimage = (build-asdf-system {
    pname = "cl-freeimage";
    version = "20170403-git";
    asds = [ "cl-freeimage" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-freeimage/2017-04-03/cl-freeimage-20170403-git.tgz";
      sha256 = "1333i8sh670nkb0c35xp511xjlafn5zh8a6gk3wnh19gffvj63hq";
      system = "cl-freeimage";
      asd = "cl-freeimage";
    });
    systems = [ "cl-freeimage" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-freetype2 = (build-asdf-system {
    pname = "cl-freetype2";
    version = "20220707-git";
    asds = [ "cl-freetype2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-freetype2/2022-07-07/cl-freetype2-20220707-git.tgz";
      sha256 = "1nhq3qslja0bcgpbmzfycqhd4vw1l58zh4ia15m1h6535qxliy0q";
      system = "cl-freetype2";
      asd = "cl-freetype2";
    });
    systems = [ "cl-freetype2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-freetype2-tests = (build-asdf-system {
    pname = "cl-freetype2-tests";
    version = "20220707-git";
    asds = [ "cl-freetype2-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-freetype2/2022-07-07/cl-freetype2-20220707-git.tgz";
      sha256 = "1nhq3qslja0bcgpbmzfycqhd4vw1l58zh4ia15m1h6535qxliy0q";
      system = "cl-freetype2-tests";
      asd = "cl-freetype2-tests";
    });
    systems = [ "cl-freetype2-tests" ];
    lispLibs = [ (getAttr "cl-freetype2" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fsnotify = (build-asdf-system {
    pname = "cl-fsnotify";
    version = "20150302-git";
    asds = [ "cl-fsnotify" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fsnotify/2015-03-02/cl-fsnotify-20150302-git.tgz";
      sha256 = "0693ga1xqcvi89j3aw0lmyi3a1yl3hrfwli2jiwxv0mgpcaxz0yr";
      system = "cl-fsnotify";
      asd = "cl-fsnotify";
    });
    systems = [ "cl-fsnotify" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ftp = (build-asdf-system {
    pname = "cl-ftp";
    version = "20150608-http";
    asds = [ "cl-ftp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ftp/2015-06-08/cl-ftp-20150608-http.tgz";
      sha256 = "1m955rjpaynybzmb9q631mll764hm06lydvhra50mfjj75ynwsvw";
      system = "cl-ftp";
      asd = "cl-ftp";
    });
    systems = [ "cl-ftp" ];
    lispLibs = [ (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-fuse = (build-asdf-system {
    pname = "cl-fuse";
    version = "20200925-git";
    asds = [ "cl-fuse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fuse/2020-09-25/cl-fuse-20200925-git.tgz";
      sha256 = "1qxvf8ybn0v1hiaz11k1h47y0dksj8ah9v8jdfrjp9ad1rrrnxqs";
      system = "cl-fuse";
      asd = "cl-fuse";
    });
    systems = [ "cl-fuse" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-utilities" self) (getAttr "iterate" self) (getAttr "trivial-backtrace" self) (getAttr "trivial-utf-8" self) ];
    meta = {};
  });
  cl-fuse-meta-fs = (build-asdf-system {
    pname = "cl-fuse-meta-fs";
    version = "20190710-git";
    asds = [ "cl-fuse-meta-fs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fuse-meta-fs/2019-07-10/cl-fuse-meta-fs-20190710-git.tgz";
      sha256 = "1wbi7lvczfn09qb72rg1bps9w51mz42dwa7lyjl2hp8lbwc2a5a9";
      system = "cl-fuse-meta-fs";
      asd = "cl-fuse-meta-fs";
    });
    systems = [ "cl-fuse-meta-fs" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-fuse" self) (getAttr "iterate" self) (getAttr "pcall" self) ];
    meta = {};
  });
  cl-fuzz = (build-asdf-system {
    pname = "cl-fuzz";
    version = "20181018-git";
    asds = [ "cl-fuzz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fuzz/2018-10-18/cl-fuzz-20181018-git.tgz";
      sha256 = "1zvlh0nh4iip75p6dblx5kajqaa3hhv6mdjbx9cids8491r388rz";
      system = "cl-fuzz";
      asd = "cl-fuzz";
    });
    systems = [ "cl-fuzz" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {};
  });
  cl-fxml = (build-asdf-system {
    pname = "cl-fxml";
    version = "20220331-git";
    asds = [ "cl-fxml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-fxml/2022-03-31/cl-fxml-20220331-git.tgz";
      sha256 = "0i5w3z0rgyi42rlhvf92k95w6bajf3m1x9g4zprwf602kp7abr3c";
      system = "cl-fxml";
      asd = "cl-fxml";
    });
    systems = [ "cl-fxml" ];
    lispLibs = [ (getAttr "agnostic-lizard" self) (getAttr "alexandria" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gamepad = (build-asdf-system {
    pname = "cl-gamepad";
    version = "20230618-git";
    asds = [ "cl-gamepad" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gamepad/2023-06-18/cl-gamepad-20230618-git.tgz";
      sha256 = "0y6kg9wq92p07i1chm1v7j7p77iqc5c985pdvmmivcip8zmd4hm4";
      system = "cl-gamepad";
      asd = "cl-gamepad";
    });
    systems = [ "cl-gamepad" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gap-buffer = (build-asdf-system {
    pname = "cl-gap-buffer";
    version = "20230618-git";
    asds = [ "cl-gap-buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gap-buffer/2023-06-18/cl-gap-buffer-20230618-git.tgz";
      sha256 = "0dzwhzv139z9pspnh1krnldnk4nfrj8f5khh08085xkc5bgg1jfv";
      system = "cl-gap-buffer";
      asd = "cl-gap-buffer";
    });
    systems = [ "cl-gap-buffer" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gbm = (build-asdf-system {
    pname = "cl-gbm";
    version = "20180430-git";
    asds = [ "cl-gbm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gbm/2018-04-30/cl-gbm-20180430-git.tgz";
      sha256 = "14bshi7q1hhyag8va9javjjn5cnhmwyjlw8vvvb4fyzfspz3kpdx";
      system = "cl-gbm";
      asd = "cl-gbm";
    });
    systems = [ "cl-gbm" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gcrypt = (build-asdf-system {
    pname = "cl-gcrypt";
    version = "20211209-git";
    asds = [ "cl-gcrypt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gcrypt/2021-12-09/cl-gcrypt-20211209-git.tgz";
      sha256 = "1f4gx5ssirr4f3n68i2da6ad7hbhgsk18zv0gfqy3q635zai0z3w";
      system = "cl-gcrypt";
      asd = "cl-gcrypt";
    });
    systems = [ "cl-gcrypt" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gcrypt-test = (build-asdf-system {
    pname = "cl-gcrypt-test";
    version = "20211209-git";
    asds = [ "cl-gcrypt-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gcrypt/2021-12-09/cl-gcrypt-20211209-git.tgz";
      sha256 = "1f4gx5ssirr4f3n68i2da6ad7hbhgsk18zv0gfqy3q635zai0z3w";
      system = "cl-gcrypt-test";
      asd = "cl-gcrypt-test";
    });
    systems = [ "cl-gcrypt-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cffi" self) (getAttr "cl-gcrypt" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gd = (build-asdf-system {
    pname = "cl-gd";
    version = "20201220-git";
    asds = [ "cl-gd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gd/2020-12-20/cl-gd-20201220-git.tgz";
      sha256 = "1wa6nv5bdf0v38hzr6cfadkk6mhvvnj9lpl9igcxygdjbnn2a3y6";
      system = "cl-gd";
      asd = "cl-gd";
    });
    systems = [ "cl-gd" ];
    lispLibs = [ (getAttr "uffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gd-test = (build-asdf-system {
    pname = "cl-gd-test";
    version = "20201220-git";
    asds = [ "cl-gd-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gd/2020-12-20/cl-gd-20201220-git.tgz";
      sha256 = "1wa6nv5bdf0v38hzr6cfadkk6mhvvnj9lpl9igcxygdjbnn2a3y6";
      system = "cl-gd-test";
      asd = "cl-gd-test";
    });
    systems = [ "cl-gd-test" ];
    lispLibs = [ (getAttr "cl-gd" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gdata = (build-asdf-system {
    pname = "cl-gdata";
    version = "20171130-git";
    asds = [ "cl-gdata" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gdata/2017-11-30/cl-gdata-20171130-git.tgz";
      sha256 = "0x2sq03nacjbq7p9baxlhr7bb0xg7v1ljq7qj1b3xrd4rbcibxi9";
      system = "cl-gdata";
      asd = "cl-gdata";
    });
    systems = [ "cl-gdata" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-json" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "cxml" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "gzip-stream" self) (getAttr "local-time" self) (getAttr "parse-number" self) (getAttr "split-sequence" self) (getAttr "string-case" self) (getAttr "trivial-utf-8" self) (getAttr "url-rewrite" self) (getAttr "xpath" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gearman = (build-asdf-system {
    pname = "cl-gearman";
    version = "20211020-git";
    asds = [ "cl-gearman" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gearman/2021-10-20/cl-gearman-20211020-git.tgz";
      sha256 = "0cnkpqn43p55xlhdi8bws2ssa1ahvzbgggh3pam0zbqma2m525j6";
      system = "cl-gearman";
      asd = "cl-gearman";
    });
    systems = [ "cl-gearman" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gearman-test = (build-asdf-system {
    pname = "cl-gearman-test";
    version = "20211020-git";
    asds = [ "cl-gearman-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gearman/2021-10-20/cl-gearman-20211020-git.tgz";
      sha256 = "0cnkpqn43p55xlhdi8bws2ssa1ahvzbgggh3pam0zbqma2m525j6";
      system = "cl-gearman-test";
      asd = "cl-gearman-test";
    });
    systems = [ "cl-gearman-test" ];
    lispLibs = [ (getAttr "cl-gearman" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gendoc = (build-asdf-system {
    pname = "cl-gendoc";
    version = "20180831-git";
    asds = [ "cl-gendoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gendoc/2018-08-31/cl-gendoc-20180831-git.tgz";
      sha256 = "19f8fmz2hj332kh3y3fbil2dchpckdsqci6ljhadymd8p2h6w4ws";
      system = "cl-gendoc";
      asd = "cl-gendoc";
    });
    systems = [ "cl-gendoc" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "_3bmd-ext-code-blocks" self) (getAttr "cl-who" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gendoc-docs = (build-asdf-system {
    pname = "cl-gendoc-docs";
    version = "20180831-git";
    asds = [ "cl-gendoc-docs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gendoc/2018-08-31/cl-gendoc-20180831-git.tgz";
      sha256 = "19f8fmz2hj332kh3y3fbil2dchpckdsqci6ljhadymd8p2h6w4ws";
      system = "cl-gendoc-docs";
      asd = "cl-gendoc";
    });
    systems = [ "cl-gendoc-docs" ];
    lispLibs = [ (getAttr "cl-gendoc" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gene-searcher = (build-asdf-system {
    pname = "cl-gene-searcher";
    version = "20111001-git";
    asds = [ "cl-gene-searcher" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gene-searcher/2011-10-01/cl-gene-searcher-20111001-git.tgz";
      sha256 = "0n8p6yk600h7m050bjxazmcxdrcfrkcklrcj8ncflyshm72qv1yk";
      system = "cl-gene-searcher";
      asd = "cl-gene-searcher";
    });
    systems = [ "cl-gene-searcher" ];
    lispLibs = [ (getAttr "clsql-sqlite3" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-generator = (build-asdf-system {
    pname = "cl-generator";
    version = "20221106-git";
    asds = [ "cl-generator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-generator/2022-11-06/cl-generator-20221106-git.tgz";
      sha256 = "0aa5prw6f4fqw9j8m6kvdb3h3lqyvi15dd1l6437p9408mmyxk30";
      system = "cl-generator";
      asd = "cl-generator";
    });
    systems = [ "cl-generator" ];
    lispLibs = [ (getAttr "cl-cont" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-generator-test = (build-asdf-system {
    pname = "cl-generator-test";
    version = "20221106-git";
    asds = [ "cl-generator-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-generator/2022-11-06/cl-generator-20221106-git.tgz";
      sha256 = "0aa5prw6f4fqw9j8m6kvdb3h3lqyvi15dd1l6437p9408mmyxk30";
      system = "cl-generator-test";
      asd = "cl-generator-test";
    });
    systems = [ "cl-generator-test" ];
    lispLibs = [ (getAttr "cl-generator" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-geocode = (build-asdf-system {
    pname = "cl-geocode";
    version = "20190813-git";
    asds = [ "cl-geocode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-geocode/2019-08-13/cl-geocode-20190813-git.tgz";
      sha256 = "17z0v29rrhsfjikg4sn9ynxckh5i3ahjn7c8qs381n1p9fbd668l";
      system = "cl-geocode";
      asd = "cl-geocode";
    });
    systems = [ "cl-geocode" ];
    lispLibs = [ (getAttr "acl-compat" self) (getAttr "aserve" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-geoip = (build-asdf-system {
    pname = "cl-geoip";
    version = "20130615-git";
    asds = [ "cl-geoip" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-geoip/2013-06-15/cl-geoip-20130615-git.tgz";
      sha256 = "0ys8wysppx06j3s0dc9lc9zjizr1fmj388fiigyn1wrdyyka41y2";
      system = "cl-geoip";
      asd = "cl-geoip";
    });
    systems = [ "cl-geoip" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-geometry = (build-asdf-system {
    pname = "cl-geometry";
    version = "20160531-git";
    asds = [ "cl-geometry" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-geometry/2016-05-31/cl-geometry-20160531-git.tgz";
      sha256 = "188xrd8plvc34gz7q01zmkdrzxbpwzln103l5dl78pa4a6vzz34h";
      system = "cl-geometry";
      asd = "cl-geometry";
    });
    systems = [ "cl-geometry" ];
    lispLibs = [ (getAttr "iterate" self) (getAttr "trees" self) ];
    meta = {};
  });
  cl-geometry-tests = (build-asdf-system {
    pname = "cl-geometry-tests";
    version = "20160531-git";
    asds = [ "cl-geometry-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-geometry/2016-05-31/cl-geometry-20160531-git.tgz";
      sha256 = "188xrd8plvc34gz7q01zmkdrzxbpwzln103l5dl78pa4a6vzz34h";
      system = "cl-geometry-tests";
      asd = "cl-geometry-tests";
    });
    systems = [ "cl-geometry-tests" ];
    lispLibs = [ (getAttr "cl-geometry" self) (getAttr "iterate" self) (getAttr "vecto" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-geos = (build-asdf-system {
    pname = "cl-geos";
    version = "20180711-git";
    asds = [ "cl-geos" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-geos/2018-07-11/cl-geos-20180711-git.tgz";
      sha256 = "0igq2c1p82pbkyc7zg90fm3lbsmhwnfmb3q8jc8baklb958555ck";
      system = "cl-geos";
      asd = "cl-geos";
    });
    systems = [ "cl-geos" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "trivial-garbage" self) (getAttr "xarray" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-getopt = (build-asdf-system {
    pname = "cl-getopt";
    version = "20211209-git";
    asds = [ "cl-getopt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-getopt/2021-12-09/cl-getopt-20211209-git.tgz";
      sha256 = "16qkpg2qln7q9j5614py00zwsnmxcy3xcmhb4m8f0w0zbnpvkjxl";
      system = "cl-getopt";
      asd = "cl-getopt";
    });
    systems = [ "cl-getopt" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-getx = (build-asdf-system {
    pname = "cl-getx";
    version = "20200925-git";
    asds = [ "cl-getx" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-getx/2020-09-25/cl-getx-20200925-git.tgz";
      sha256 = "07gi346vqrhnbkdk4l6g06z4shhnx7f4l44jgayzfdd0xkv02brv";
      system = "cl-getx";
      asd = "cl-getx";
    });
    systems = [ "cl-getx" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gimei = (build-asdf-system {
    pname = "cl-gimei";
    version = "20211020-git";
    asds = [ "cl-gimei" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gimei/2021-10-20/cl-gimei-20211020-git.tgz";
      sha256 = "1405qbqrrrmanmg2dl7yfdj8z4vcsj1silpsa7i1y00pd18xgk8q";
      system = "cl-gimei";
      asd = "cl-gimei";
    });
    systems = [ "cl-gimei" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-yaml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gio = (build-asdf-system {
    pname = "cl-gio";
    version = "20230618-git";
    asds = [ "cl-gio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glib/2023-06-18/cl-glib-20230618-git.tgz";
      sha256 = "0dxa493zdp1p93cahhpp3yaggn3j3kkn90mdw99g4ld7scmiglp4";
      system = "cl-gio";
      asd = "cl-gio";
    });
    systems = [ "cl-gio" ];
    lispLibs = [ (getAttr "cl-gobject-introspection-wrapper" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gists = (build-asdf-system {
    pname = "cl-gists";
    version = "20180228-git";
    asds = [ "cl-gists" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gists/2018-02-28/cl-gists-20180228-git.tgz";
      sha256 = "1ipwapb71ls0gy4prg1j9x5ki4frf6l1f9iphjnsis7kdpbm2mi7";
      system = "cl-gists";
      asd = "cl-gists";
    });
    systems = [ "cl-gists" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-syntax" self) (getAttr "cl-syntax-annot" self) (getAttr "dexador" self) (getAttr "jonathan" self) (getAttr "local-time" self) (getAttr "quri" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gists-test = (build-asdf-system {
    pname = "cl-gists-test";
    version = "20180228-git";
    asds = [ "cl-gists-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gists/2018-02-28/cl-gists-20180228-git.tgz";
      sha256 = "1ipwapb71ls0gy4prg1j9x5ki4frf6l1f9iphjnsis7kdpbm2mi7";
      system = "cl-gists-test";
      asd = "cl-gists-test";
    });
    systems = [ "cl-gists-test" ];
    lispLibs = [ (getAttr "cl-gists" self) (getAttr "closer-mop" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-git = (build-asdf-system {
    pname = "cl-git";
    version = "20230618-git";
    asds = [ "cl-git" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-git/2023-06-18/cl-git-20230618-git.tgz";
      sha256 = "13h7n3nbpf2qq0vq0dz33r0468baskw83pjfxb3hik4rllrv04h6";
      system = "cl-git";
      asd = "cl-git";
    });
    systems = [ "cl-git" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-fad" self) (getAttr "closer-mop" self) (getAttr "flexi-streams" self) (getAttr "local-time" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-github-v3 = (build-asdf-system {
    pname = "cl-github-v3";
    version = "20191227-git";
    asds = [ "cl-github-v3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-github-v3/2019-12-27/cl-github-v3-20191227-git.tgz";
      sha256 = "1xwfw6y3vm7236rd6pdmb5akk63gpzhllx99mv4r7ia3yyf9d4f8";
      system = "cl-github-v3";
      asd = "cl-github-v3";
    });
    systems = [ "cl-github-v3" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw = (build-asdf-system {
    pname = "cl-glfw";
    version = "20150302-git";
    asds = [ "cl-glfw" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw";
      asd = "cl-glfw";
    });
    systems = [ "cl-glfw" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-glfw-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-ftgl = (build-asdf-system {
    pname = "cl-glfw-ftgl";
    version = "20150302-git";
    asds = [ "cl-glfw-ftgl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-ftgl";
      asd = "cl-glfw-ftgl";
    });
    systems = [ "cl-glfw-ftgl" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-glu = (build-asdf-system {
    pname = "cl-glfw-glu";
    version = "20150302-git";
    asds = [ "cl-glfw-glu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-glu";
      asd = "cl-glfw-glu";
    });
    systems = [ "cl-glfw-glu" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-glfw-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-3dfx__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-3dfx_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-3dfx_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-3dfx_multisample";
      asd = "cl-glfw-opengl-3dfx_multisample";
    });
    systems = [ "cl-glfw-opengl-3dfx_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-3dfx__tbuffer = (build-asdf-system {
    pname = "cl-glfw-opengl-3dfx_tbuffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-3dfx_tbuffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-3dfx_tbuffer";
      asd = "cl-glfw-opengl-3dfx_tbuffer";
    });
    systems = [ "cl-glfw-opengl-3dfx_tbuffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-3dfx__texture__compression__fxt1 = (build-asdf-system {
    pname = "cl-glfw-opengl-3dfx_texture_compression_fxt1";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-3dfx_texture_compression_fxt1" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-3dfx_texture_compression_fxt1";
      asd = "cl-glfw-opengl-3dfx_texture_compression_fxt1";
    });
    systems = [ "cl-glfw-opengl-3dfx_texture_compression_fxt1" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__blend__minmax__factor = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_blend_minmax_factor";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_blend_minmax_factor" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_blend_minmax_factor";
      asd = "cl-glfw-opengl-amd_blend_minmax_factor";
    });
    systems = [ "cl-glfw-opengl-amd_blend_minmax_factor" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__depth__clamp__separate = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_depth_clamp_separate";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_depth_clamp_separate" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_depth_clamp_separate";
      asd = "cl-glfw-opengl-amd_depth_clamp_separate";
    });
    systems = [ "cl-glfw-opengl-amd_depth_clamp_separate" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__draw__buffers__blend = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_draw_buffers_blend";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_draw_buffers_blend" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_draw_buffers_blend";
      asd = "cl-glfw-opengl-amd_draw_buffers_blend";
    });
    systems = [ "cl-glfw-opengl-amd_draw_buffers_blend" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__multi__draw__indirect = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_multi_draw_indirect";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_multi_draw_indirect" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_multi_draw_indirect";
      asd = "cl-glfw-opengl-amd_multi_draw_indirect";
    });
    systems = [ "cl-glfw-opengl-amd_multi_draw_indirect" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__name__gen__delete = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_name_gen_delete";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_name_gen_delete" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_name_gen_delete";
      asd = "cl-glfw-opengl-amd_name_gen_delete";
    });
    systems = [ "cl-glfw-opengl-amd_name_gen_delete" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__performance__monitor = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_performance_monitor";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_performance_monitor" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_performance_monitor";
      asd = "cl-glfw-opengl-amd_performance_monitor";
    });
    systems = [ "cl-glfw-opengl-amd_performance_monitor" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__sample__positions = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_sample_positions";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_sample_positions" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_sample_positions";
      asd = "cl-glfw-opengl-amd_sample_positions";
    });
    systems = [ "cl-glfw-opengl-amd_sample_positions" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__seamless__cubemap__per__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_seamless_cubemap_per_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_seamless_cubemap_per_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_seamless_cubemap_per_texture";
      asd = "cl-glfw-opengl-amd_seamless_cubemap_per_texture";
    });
    systems = [ "cl-glfw-opengl-amd_seamless_cubemap_per_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-amd__vertex__shader__tesselator = (build-asdf-system {
    pname = "cl-glfw-opengl-amd_vertex_shader_tesselator";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-amd_vertex_shader_tesselator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-amd_vertex_shader_tesselator";
      asd = "cl-glfw-opengl-amd_vertex_shader_tesselator";
    });
    systems = [ "cl-glfw-opengl-amd_vertex_shader_tesselator" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__aux__depth__stencil = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_aux_depth_stencil";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_aux_depth_stencil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_aux_depth_stencil";
      asd = "cl-glfw-opengl-apple_aux_depth_stencil";
    });
    systems = [ "cl-glfw-opengl-apple_aux_depth_stencil" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__client__storage = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_client_storage";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_client_storage" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_client_storage";
      asd = "cl-glfw-opengl-apple_client_storage";
    });
    systems = [ "cl-glfw-opengl-apple_client_storage" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__element__array = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_element_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_element_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_element_array";
      asd = "cl-glfw-opengl-apple_element_array";
    });
    systems = [ "cl-glfw-opengl-apple_element_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__fence = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_fence";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_fence" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_fence";
      asd = "cl-glfw-opengl-apple_fence";
    });
    systems = [ "cl-glfw-opengl-apple_fence" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__float__pixels = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_float_pixels";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_float_pixels" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_float_pixels";
      asd = "cl-glfw-opengl-apple_float_pixels";
    });
    systems = [ "cl-glfw-opengl-apple_float_pixels" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__flush__buffer__range = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_flush_buffer_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_flush_buffer_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_flush_buffer_range";
      asd = "cl-glfw-opengl-apple_flush_buffer_range";
    });
    systems = [ "cl-glfw-opengl-apple_flush_buffer_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__object__purgeable = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_object_purgeable";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_object_purgeable" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_object_purgeable";
      asd = "cl-glfw-opengl-apple_object_purgeable";
    });
    systems = [ "cl-glfw-opengl-apple_object_purgeable" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__rgb__422 = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_rgb_422";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_rgb_422" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_rgb_422";
      asd = "cl-glfw-opengl-apple_rgb_422";
    });
    systems = [ "cl-glfw-opengl-apple_rgb_422" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__row__bytes = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_row_bytes";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_row_bytes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_row_bytes";
      asd = "cl-glfw-opengl-apple_row_bytes";
    });
    systems = [ "cl-glfw-opengl-apple_row_bytes" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__specular__vector = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_specular_vector";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_specular_vector" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_specular_vector";
      asd = "cl-glfw-opengl-apple_specular_vector";
    });
    systems = [ "cl-glfw-opengl-apple_specular_vector" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__texture__range = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_texture_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_texture_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_texture_range";
      asd = "cl-glfw-opengl-apple_texture_range";
    });
    systems = [ "cl-glfw-opengl-apple_texture_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__transform__hint = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_transform_hint";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_transform_hint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_transform_hint";
      asd = "cl-glfw-opengl-apple_transform_hint";
    });
    systems = [ "cl-glfw-opengl-apple_transform_hint" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__vertex__array__object = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_vertex_array_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_vertex_array_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_vertex_array_object";
      asd = "cl-glfw-opengl-apple_vertex_array_object";
    });
    systems = [ "cl-glfw-opengl-apple_vertex_array_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__vertex__array__range = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_vertex_array_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_vertex_array_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_vertex_array_range";
      asd = "cl-glfw-opengl-apple_vertex_array_range";
    });
    systems = [ "cl-glfw-opengl-apple_vertex_array_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__vertex__program__evaluators = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_vertex_program_evaluators";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_vertex_program_evaluators" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_vertex_program_evaluators";
      asd = "cl-glfw-opengl-apple_vertex_program_evaluators";
    });
    systems = [ "cl-glfw-opengl-apple_vertex_program_evaluators" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-apple__ycbcr__422 = (build-asdf-system {
    pname = "cl-glfw-opengl-apple_ycbcr_422";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-apple_ycbcr_422" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-apple_ycbcr_422";
      asd = "cl-glfw-opengl-apple_ycbcr_422";
    });
    systems = [ "cl-glfw-opengl-apple_ycbcr_422" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__blend__func__extended = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_blend_func_extended";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_blend_func_extended" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_blend_func_extended";
      asd = "cl-glfw-opengl-arb_blend_func_extended";
    });
    systems = [ "cl-glfw-opengl-arb_blend_func_extended" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__color__buffer__float = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_color_buffer_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_color_buffer_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_color_buffer_float";
      asd = "cl-glfw-opengl-arb_color_buffer_float";
    });
    systems = [ "cl-glfw-opengl-arb_color_buffer_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__copy__buffer = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_copy_buffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_copy_buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_copy_buffer";
      asd = "cl-glfw-opengl-arb_copy_buffer";
    });
    systems = [ "cl-glfw-opengl-arb_copy_buffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__depth__buffer__float = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_depth_buffer_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_depth_buffer_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_depth_buffer_float";
      asd = "cl-glfw-opengl-arb_depth_buffer_float";
    });
    systems = [ "cl-glfw-opengl-arb_depth_buffer_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__depth__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_depth_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_depth_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_depth_clamp";
      asd = "cl-glfw-opengl-arb_depth_clamp";
    });
    systems = [ "cl-glfw-opengl-arb_depth_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__depth__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_depth_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_depth_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_depth_texture";
      asd = "cl-glfw-opengl-arb_depth_texture";
    });
    systems = [ "cl-glfw-opengl-arb_depth_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__draw__buffers = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_draw_buffers";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_draw_buffers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_draw_buffers";
      asd = "cl-glfw-opengl-arb_draw_buffers";
    });
    systems = [ "cl-glfw-opengl-arb_draw_buffers" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__draw__buffers__blend = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_draw_buffers_blend";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_draw_buffers_blend" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_draw_buffers_blend";
      asd = "cl-glfw-opengl-arb_draw_buffers_blend";
    });
    systems = [ "cl-glfw-opengl-arb_draw_buffers_blend" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__draw__elements__base__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_draw_elements_base_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_draw_elements_base_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_draw_elements_base_vertex";
      asd = "cl-glfw-opengl-arb_draw_elements_base_vertex";
    });
    systems = [ "cl-glfw-opengl-arb_draw_elements_base_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__draw__indirect = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_draw_indirect";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_draw_indirect" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_draw_indirect";
      asd = "cl-glfw-opengl-arb_draw_indirect";
    });
    systems = [ "cl-glfw-opengl-arb_draw_indirect" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__draw__instanced = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_draw_instanced";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_draw_instanced" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_draw_instanced";
      asd = "cl-glfw-opengl-arb_draw_instanced";
    });
    systems = [ "cl-glfw-opengl-arb_draw_instanced" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__es2__compatibility = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_es2_compatibility";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_es2_compatibility" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_es2_compatibility";
      asd = "cl-glfw-opengl-arb_es2_compatibility";
    });
    systems = [ "cl-glfw-opengl-arb_es2_compatibility" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__fragment__program = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_fragment_program";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_fragment_program" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_fragment_program";
      asd = "cl-glfw-opengl-arb_fragment_program";
    });
    systems = [ "cl-glfw-opengl-arb_fragment_program" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__fragment__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_fragment_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_fragment_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_fragment_shader";
      asd = "cl-glfw-opengl-arb_fragment_shader";
    });
    systems = [ "cl-glfw-opengl-arb_fragment_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__framebuffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_framebuffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_framebuffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_framebuffer_object";
      asd = "cl-glfw-opengl-arb_framebuffer_object";
    });
    systems = [ "cl-glfw-opengl-arb_framebuffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__framebuffer__object__deprecated = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_framebuffer_object_deprecated";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_framebuffer_object_deprecated" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_framebuffer_object_deprecated";
      asd = "cl-glfw-opengl-arb_framebuffer_object_deprecated";
    });
    systems = [ "cl-glfw-opengl-arb_framebuffer_object_deprecated" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__framebuffer__srgb = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_framebuffer_srgb";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_framebuffer_srgb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_framebuffer_srgb";
      asd = "cl-glfw-opengl-arb_framebuffer_srgb";
    });
    systems = [ "cl-glfw-opengl-arb_framebuffer_srgb" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__geometry__shader4 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_geometry_shader4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_geometry_shader4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_geometry_shader4";
      asd = "cl-glfw-opengl-arb_geometry_shader4";
    });
    systems = [ "cl-glfw-opengl-arb_geometry_shader4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__get__program__binary = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_get_program_binary";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_get_program_binary" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_get_program_binary";
      asd = "cl-glfw-opengl-arb_get_program_binary";
    });
    systems = [ "cl-glfw-opengl-arb_get_program_binary" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__gpu__shader5 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_gpu_shader5";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_gpu_shader5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_gpu_shader5";
      asd = "cl-glfw-opengl-arb_gpu_shader5";
    });
    systems = [ "cl-glfw-opengl-arb_gpu_shader5" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__gpu__shader__fp64 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_gpu_shader_fp64";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_gpu_shader_fp64" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_gpu_shader_fp64";
      asd = "cl-glfw-opengl-arb_gpu_shader_fp64";
    });
    systems = [ "cl-glfw-opengl-arb_gpu_shader_fp64" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__half__float__pixel = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_half_float_pixel";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_half_float_pixel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_half_float_pixel";
      asd = "cl-glfw-opengl-arb_half_float_pixel";
    });
    systems = [ "cl-glfw-opengl-arb_half_float_pixel" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__half__float__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_half_float_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_half_float_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_half_float_vertex";
      asd = "cl-glfw-opengl-arb_half_float_vertex";
    });
    systems = [ "cl-glfw-opengl-arb_half_float_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__imaging = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_imaging";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_imaging" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_imaging";
      asd = "cl-glfw-opengl-arb_imaging";
    });
    systems = [ "cl-glfw-opengl-arb_imaging" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__imaging__deprecated = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_imaging_deprecated";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_imaging_deprecated" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_imaging_deprecated";
      asd = "cl-glfw-opengl-arb_imaging_deprecated";
    });
    systems = [ "cl-glfw-opengl-arb_imaging_deprecated" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__instanced__arrays = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_instanced_arrays";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_instanced_arrays" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_instanced_arrays";
      asd = "cl-glfw-opengl-arb_instanced_arrays";
    });
    systems = [ "cl-glfw-opengl-arb_instanced_arrays" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__map__buffer__range = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_map_buffer_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_map_buffer_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_map_buffer_range";
      asd = "cl-glfw-opengl-arb_map_buffer_range";
    });
    systems = [ "cl-glfw-opengl-arb_map_buffer_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__matrix__palette = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_matrix_palette";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_matrix_palette" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_matrix_palette";
      asd = "cl-glfw-opengl-arb_matrix_palette";
    });
    systems = [ "cl-glfw-opengl-arb_matrix_palette" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_multisample";
      asd = "cl-glfw-opengl-arb_multisample";
    });
    systems = [ "cl-glfw-opengl-arb_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__multitexture = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_multitexture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_multitexture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_multitexture";
      asd = "cl-glfw-opengl-arb_multitexture";
    });
    systems = [ "cl-glfw-opengl-arb_multitexture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__occlusion__query = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_occlusion_query";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_occlusion_query" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_occlusion_query";
      asd = "cl-glfw-opengl-arb_occlusion_query";
    });
    systems = [ "cl-glfw-opengl-arb_occlusion_query" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__occlusion__query2 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_occlusion_query2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_occlusion_query2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_occlusion_query2";
      asd = "cl-glfw-opengl-arb_occlusion_query2";
    });
    systems = [ "cl-glfw-opengl-arb_occlusion_query2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__pixel__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_pixel_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_pixel_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_pixel_buffer_object";
      asd = "cl-glfw-opengl-arb_pixel_buffer_object";
    });
    systems = [ "cl-glfw-opengl-arb_pixel_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__point__parameters = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_point_parameters";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_point_parameters" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_point_parameters";
      asd = "cl-glfw-opengl-arb_point_parameters";
    });
    systems = [ "cl-glfw-opengl-arb_point_parameters" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__point__sprite = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_point_sprite";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_point_sprite" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_point_sprite";
      asd = "cl-glfw-opengl-arb_point_sprite";
    });
    systems = [ "cl-glfw-opengl-arb_point_sprite" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__provoking__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_provoking_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_provoking_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_provoking_vertex";
      asd = "cl-glfw-opengl-arb_provoking_vertex";
    });
    systems = [ "cl-glfw-opengl-arb_provoking_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__robustness = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_robustness";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_robustness" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_robustness";
      asd = "cl-glfw-opengl-arb_robustness";
    });
    systems = [ "cl-glfw-opengl-arb_robustness" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__sample__shading = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_sample_shading";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_sample_shading" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_sample_shading";
      asd = "cl-glfw-opengl-arb_sample_shading";
    });
    systems = [ "cl-glfw-opengl-arb_sample_shading" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__sampler__objects = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_sampler_objects";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_sampler_objects" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_sampler_objects";
      asd = "cl-glfw-opengl-arb_sampler_objects";
    });
    systems = [ "cl-glfw-opengl-arb_sampler_objects" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__seamless__cube__map = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_seamless_cube_map";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_seamless_cube_map" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_seamless_cube_map";
      asd = "cl-glfw-opengl-arb_seamless_cube_map";
    });
    systems = [ "cl-glfw-opengl-arb_seamless_cube_map" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__separate__shader__objects = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_separate_shader_objects";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_separate_shader_objects" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_separate_shader_objects";
      asd = "cl-glfw-opengl-arb_separate_shader_objects";
    });
    systems = [ "cl-glfw-opengl-arb_separate_shader_objects" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shader__objects = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shader_objects";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shader_objects" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shader_objects";
      asd = "cl-glfw-opengl-arb_shader_objects";
    });
    systems = [ "cl-glfw-opengl-arb_shader_objects" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shader__subroutine = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shader_subroutine";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shader_subroutine" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shader_subroutine";
      asd = "cl-glfw-opengl-arb_shader_subroutine";
    });
    systems = [ "cl-glfw-opengl-arb_shader_subroutine" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shading__language__100 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shading_language_100";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shading_language_100" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shading_language_100";
      asd = "cl-glfw-opengl-arb_shading_language_100";
    });
    systems = [ "cl-glfw-opengl-arb_shading_language_100" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shading__language__include = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shading_language_include";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shading_language_include" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shading_language_include";
      asd = "cl-glfw-opengl-arb_shading_language_include";
    });
    systems = [ "cl-glfw-opengl-arb_shading_language_include" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shadow = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shadow";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shadow" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shadow";
      asd = "cl-glfw-opengl-arb_shadow";
    });
    systems = [ "cl-glfw-opengl-arb_shadow" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__shadow__ambient = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_shadow_ambient";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_shadow_ambient" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_shadow_ambient";
      asd = "cl-glfw-opengl-arb_shadow_ambient";
    });
    systems = [ "cl-glfw-opengl-arb_shadow_ambient" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__tessellation__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_tessellation_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_tessellation_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_tessellation_shader";
      asd = "cl-glfw-opengl-arb_tessellation_shader";
    });
    systems = [ "cl-glfw-opengl-arb_tessellation_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__border__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_border_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_border_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_border_clamp";
      asd = "cl-glfw-opengl-arb_texture_border_clamp";
    });
    systems = [ "cl-glfw-opengl-arb_texture_border_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_buffer_object";
      asd = "cl-glfw-opengl-arb_texture_buffer_object";
    });
    systems = [ "cl-glfw-opengl-arb_texture_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__buffer__object__rgb32 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_buffer_object_rgb32";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_buffer_object_rgb32" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_buffer_object_rgb32";
      asd = "cl-glfw-opengl-arb_texture_buffer_object_rgb32";
    });
    systems = [ "cl-glfw-opengl-arb_texture_buffer_object_rgb32" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__compression = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_compression";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_compression" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_compression";
      asd = "cl-glfw-opengl-arb_texture_compression";
    });
    systems = [ "cl-glfw-opengl-arb_texture_compression" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__compression__bptc = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_compression_bptc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_compression_bptc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_compression_bptc";
      asd = "cl-glfw-opengl-arb_texture_compression_bptc";
    });
    systems = [ "cl-glfw-opengl-arb_texture_compression_bptc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__compression__rgtc = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_compression_rgtc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_compression_rgtc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_compression_rgtc";
      asd = "cl-glfw-opengl-arb_texture_compression_rgtc";
    });
    systems = [ "cl-glfw-opengl-arb_texture_compression_rgtc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__cube__map = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_cube_map";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_cube_map" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_cube_map";
      asd = "cl-glfw-opengl-arb_texture_cube_map";
    });
    systems = [ "cl-glfw-opengl-arb_texture_cube_map" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__cube__map__array = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_cube_map_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_cube_map_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_cube_map_array";
      asd = "cl-glfw-opengl-arb_texture_cube_map_array";
    });
    systems = [ "cl-glfw-opengl-arb_texture_cube_map_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__env__combine = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_env_combine";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_env_combine" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_env_combine";
      asd = "cl-glfw-opengl-arb_texture_env_combine";
    });
    systems = [ "cl-glfw-opengl-arb_texture_env_combine" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__env__dot3 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_env_dot3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_env_dot3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_env_dot3";
      asd = "cl-glfw-opengl-arb_texture_env_dot3";
    });
    systems = [ "cl-glfw-opengl-arb_texture_env_dot3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__float = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_float";
      asd = "cl-glfw-opengl-arb_texture_float";
    });
    systems = [ "cl-glfw-opengl-arb_texture_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__gather = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_gather";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_gather" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_gather";
      asd = "cl-glfw-opengl-arb_texture_gather";
    });
    systems = [ "cl-glfw-opengl-arb_texture_gather" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__mirrored__repeat = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_mirrored_repeat";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_mirrored_repeat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_mirrored_repeat";
      asd = "cl-glfw-opengl-arb_texture_mirrored_repeat";
    });
    systems = [ "cl-glfw-opengl-arb_texture_mirrored_repeat" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_multisample";
      asd = "cl-glfw-opengl-arb_texture_multisample";
    });
    systems = [ "cl-glfw-opengl-arb_texture_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__rectangle = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_rectangle";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_rectangle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_rectangle";
      asd = "cl-glfw-opengl-arb_texture_rectangle";
    });
    systems = [ "cl-glfw-opengl-arb_texture_rectangle" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__rg = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_rg";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_rg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_rg";
      asd = "cl-glfw-opengl-arb_texture_rg";
    });
    systems = [ "cl-glfw-opengl-arb_texture_rg" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__rgb10__a2ui = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_rgb10_a2ui";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_rgb10_a2ui" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_rgb10_a2ui";
      asd = "cl-glfw-opengl-arb_texture_rgb10_a2ui";
    });
    systems = [ "cl-glfw-opengl-arb_texture_rgb10_a2ui" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__texture__swizzle = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_texture_swizzle";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_texture_swizzle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_texture_swizzle";
      asd = "cl-glfw-opengl-arb_texture_swizzle";
    });
    systems = [ "cl-glfw-opengl-arb_texture_swizzle" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__timer__query = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_timer_query";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_timer_query" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_timer_query";
      asd = "cl-glfw-opengl-arb_timer_query";
    });
    systems = [ "cl-glfw-opengl-arb_timer_query" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__transform__feedback2 = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_transform_feedback2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_transform_feedback2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_transform_feedback2";
      asd = "cl-glfw-opengl-arb_transform_feedback2";
    });
    systems = [ "cl-glfw-opengl-arb_transform_feedback2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__transpose__matrix = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_transpose_matrix";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_transpose_matrix" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_transpose_matrix";
      asd = "cl-glfw-opengl-arb_transpose_matrix";
    });
    systems = [ "cl-glfw-opengl-arb_transpose_matrix" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__uniform__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_uniform_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_uniform_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_uniform_buffer_object";
      asd = "cl-glfw-opengl-arb_uniform_buffer_object";
    });
    systems = [ "cl-glfw-opengl-arb_uniform_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__array__bgra = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_array_bgra";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_array_bgra" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_array_bgra";
      asd = "cl-glfw-opengl-arb_vertex_array_bgra";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_array_bgra" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__array__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_array_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_array_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_array_object";
      asd = "cl-glfw-opengl-arb_vertex_array_object";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_array_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__attrib__64bit = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_attrib_64bit";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_attrib_64bit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_attrib_64bit";
      asd = "cl-glfw-opengl-arb_vertex_attrib_64bit";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_attrib_64bit" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__blend = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_blend";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_blend" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_blend";
      asd = "cl-glfw-opengl-arb_vertex_blend";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_blend" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_buffer_object";
      asd = "cl-glfw-opengl-arb_vertex_buffer_object";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__program = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_program";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_program" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_program";
      asd = "cl-glfw-opengl-arb_vertex_program";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_program" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_shader";
      asd = "cl-glfw-opengl-arb_vertex_shader";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__vertex__type__2__10__10__10__rev = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_vertex_type_2_10_10_10_rev";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_vertex_type_2_10_10_10_rev" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_vertex_type_2_10_10_10_rev";
      asd = "cl-glfw-opengl-arb_vertex_type_2_10_10_10_rev";
    });
    systems = [ "cl-glfw-opengl-arb_vertex_type_2_10_10_10_rev" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__viewport__array = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_viewport_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_viewport_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_viewport_array";
      asd = "cl-glfw-opengl-arb_viewport_array";
    });
    systems = [ "cl-glfw-opengl-arb_viewport_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-arb__window__pos = (build-asdf-system {
    pname = "cl-glfw-opengl-arb_window_pos";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-arb_window_pos" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-arb_window_pos";
      asd = "cl-glfw-opengl-arb_window_pos";
    });
    systems = [ "cl-glfw-opengl-arb_window_pos" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__draw__buffers = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_draw_buffers";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_draw_buffers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_draw_buffers";
      asd = "cl-glfw-opengl-ati_draw_buffers";
    });
    systems = [ "cl-glfw-opengl-ati_draw_buffers" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__element__array = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_element_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_element_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_element_array";
      asd = "cl-glfw-opengl-ati_element_array";
    });
    systems = [ "cl-glfw-opengl-ati_element_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__envmap__bumpmap = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_envmap_bumpmap";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_envmap_bumpmap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_envmap_bumpmap";
      asd = "cl-glfw-opengl-ati_envmap_bumpmap";
    });
    systems = [ "cl-glfw-opengl-ati_envmap_bumpmap" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__fragment__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_fragment_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_fragment_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_fragment_shader";
      asd = "cl-glfw-opengl-ati_fragment_shader";
    });
    systems = [ "cl-glfw-opengl-ati_fragment_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__map__object__buffer = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_map_object_buffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_map_object_buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_map_object_buffer";
      asd = "cl-glfw-opengl-ati_map_object_buffer";
    });
    systems = [ "cl-glfw-opengl-ati_map_object_buffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__meminfo = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_meminfo";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_meminfo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_meminfo";
      asd = "cl-glfw-opengl-ati_meminfo";
    });
    systems = [ "cl-glfw-opengl-ati_meminfo" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__pixel__format__float = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_pixel_format_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_pixel_format_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_pixel_format_float";
      asd = "cl-glfw-opengl-ati_pixel_format_float";
    });
    systems = [ "cl-glfw-opengl-ati_pixel_format_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__pn__triangles = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_pn_triangles";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_pn_triangles" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_pn_triangles";
      asd = "cl-glfw-opengl-ati_pn_triangles";
    });
    systems = [ "cl-glfw-opengl-ati_pn_triangles" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__separate__stencil = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_separate_stencil";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_separate_stencil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_separate_stencil";
      asd = "cl-glfw-opengl-ati_separate_stencil";
    });
    systems = [ "cl-glfw-opengl-ati_separate_stencil" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__text__fragment__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_text_fragment_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_text_fragment_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_text_fragment_shader";
      asd = "cl-glfw-opengl-ati_text_fragment_shader";
    });
    systems = [ "cl-glfw-opengl-ati_text_fragment_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__texture__env__combine3 = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_texture_env_combine3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_texture_env_combine3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_texture_env_combine3";
      asd = "cl-glfw-opengl-ati_texture_env_combine3";
    });
    systems = [ "cl-glfw-opengl-ati_texture_env_combine3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__texture__float = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_texture_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_texture_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_texture_float";
      asd = "cl-glfw-opengl-ati_texture_float";
    });
    systems = [ "cl-glfw-opengl-ati_texture_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__texture__mirror__once = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_texture_mirror_once";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_texture_mirror_once" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_texture_mirror_once";
      asd = "cl-glfw-opengl-ati_texture_mirror_once";
    });
    systems = [ "cl-glfw-opengl-ati_texture_mirror_once" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__vertex__array__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_vertex_array_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_vertex_array_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_vertex_array_object";
      asd = "cl-glfw-opengl-ati_vertex_array_object";
    });
    systems = [ "cl-glfw-opengl-ati_vertex_array_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__vertex__attrib__array__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_vertex_attrib_array_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_vertex_attrib_array_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_vertex_attrib_array_object";
      asd = "cl-glfw-opengl-ati_vertex_attrib_array_object";
    });
    systems = [ "cl-glfw-opengl-ati_vertex_attrib_array_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ati__vertex__streams = (build-asdf-system {
    pname = "cl-glfw-opengl-ati_vertex_streams";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ati_vertex_streams" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ati_vertex_streams";
      asd = "cl-glfw-opengl-ati_vertex_streams";
    });
    systems = [ "cl-glfw-opengl-ati_vertex_streams" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-core = (build-asdf-system {
    pname = "cl-glfw-opengl-core";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-core" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-core";
      asd = "cl-glfw-opengl-core";
    });
    systems = [ "cl-glfw-opengl-core" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-glfw-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__422__pixels = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_422_pixels";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_422_pixels" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_422_pixels";
      asd = "cl-glfw-opengl-ext_422_pixels";
    });
    systems = [ "cl-glfw-opengl-ext_422_pixels" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__abgr = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_abgr";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_abgr" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_abgr";
      asd = "cl-glfw-opengl-ext_abgr";
    });
    systems = [ "cl-glfw-opengl-ext_abgr" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__bgra = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_bgra";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_bgra" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_bgra";
      asd = "cl-glfw-opengl-ext_bgra";
    });
    systems = [ "cl-glfw-opengl-ext_bgra" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__bindable__uniform = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_bindable_uniform";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_bindable_uniform" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_bindable_uniform";
      asd = "cl-glfw-opengl-ext_bindable_uniform";
    });
    systems = [ "cl-glfw-opengl-ext_bindable_uniform" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__blend__color = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_blend_color";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_blend_color" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_blend_color";
      asd = "cl-glfw-opengl-ext_blend_color";
    });
    systems = [ "cl-glfw-opengl-ext_blend_color" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__blend__equation__separate = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_blend_equation_separate";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_blend_equation_separate" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_blend_equation_separate";
      asd = "cl-glfw-opengl-ext_blend_equation_separate";
    });
    systems = [ "cl-glfw-opengl-ext_blend_equation_separate" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__blend__func__separate = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_blend_func_separate";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_blend_func_separate" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_blend_func_separate";
      asd = "cl-glfw-opengl-ext_blend_func_separate";
    });
    systems = [ "cl-glfw-opengl-ext_blend_func_separate" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__blend__minmax = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_blend_minmax";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_blend_minmax" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_blend_minmax";
      asd = "cl-glfw-opengl-ext_blend_minmax";
    });
    systems = [ "cl-glfw-opengl-ext_blend_minmax" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__blend__subtract = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_blend_subtract";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_blend_subtract" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_blend_subtract";
      asd = "cl-glfw-opengl-ext_blend_subtract";
    });
    systems = [ "cl-glfw-opengl-ext_blend_subtract" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__clip__volume__hint = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_clip_volume_hint";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_clip_volume_hint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_clip_volume_hint";
      asd = "cl-glfw-opengl-ext_clip_volume_hint";
    });
    systems = [ "cl-glfw-opengl-ext_clip_volume_hint" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__cmyka = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_cmyka";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_cmyka" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_cmyka";
      asd = "cl-glfw-opengl-ext_cmyka";
    });
    systems = [ "cl-glfw-opengl-ext_cmyka" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__color__subtable = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_color_subtable";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_color_subtable" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_color_subtable";
      asd = "cl-glfw-opengl-ext_color_subtable";
    });
    systems = [ "cl-glfw-opengl-ext_color_subtable" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__compiled__vertex__array = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_compiled_vertex_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_compiled_vertex_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_compiled_vertex_array";
      asd = "cl-glfw-opengl-ext_compiled_vertex_array";
    });
    systems = [ "cl-glfw-opengl-ext_compiled_vertex_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__convolution = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_convolution";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_convolution" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_convolution";
      asd = "cl-glfw-opengl-ext_convolution";
    });
    systems = [ "cl-glfw-opengl-ext_convolution" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__coordinate__frame = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_coordinate_frame";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_coordinate_frame" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_coordinate_frame";
      asd = "cl-glfw-opengl-ext_coordinate_frame";
    });
    systems = [ "cl-glfw-opengl-ext_coordinate_frame" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__copy__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_copy_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_copy_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_copy_texture";
      asd = "cl-glfw-opengl-ext_copy_texture";
    });
    systems = [ "cl-glfw-opengl-ext_copy_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__cull__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_cull_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_cull_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_cull_vertex";
      asd = "cl-glfw-opengl-ext_cull_vertex";
    });
    systems = [ "cl-glfw-opengl-ext_cull_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__depth__bounds__test = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_depth_bounds_test";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_depth_bounds_test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_depth_bounds_test";
      asd = "cl-glfw-opengl-ext_depth_bounds_test";
    });
    systems = [ "cl-glfw-opengl-ext_depth_bounds_test" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__direct__state__access = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_direct_state_access";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_direct_state_access" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_direct_state_access";
      asd = "cl-glfw-opengl-ext_direct_state_access";
    });
    systems = [ "cl-glfw-opengl-ext_direct_state_access" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__draw__buffers2 = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_draw_buffers2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_draw_buffers2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_draw_buffers2";
      asd = "cl-glfw-opengl-ext_draw_buffers2";
    });
    systems = [ "cl-glfw-opengl-ext_draw_buffers2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__draw__instanced = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_draw_instanced";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_draw_instanced" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_draw_instanced";
      asd = "cl-glfw-opengl-ext_draw_instanced";
    });
    systems = [ "cl-glfw-opengl-ext_draw_instanced" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__draw__range__elements = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_draw_range_elements";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_draw_range_elements" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_draw_range_elements";
      asd = "cl-glfw-opengl-ext_draw_range_elements";
    });
    systems = [ "cl-glfw-opengl-ext_draw_range_elements" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__fog__coord = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_fog_coord";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_fog_coord" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_fog_coord";
      asd = "cl-glfw-opengl-ext_fog_coord";
    });
    systems = [ "cl-glfw-opengl-ext_fog_coord" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__framebuffer__blit = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_framebuffer_blit";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_framebuffer_blit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_framebuffer_blit";
      asd = "cl-glfw-opengl-ext_framebuffer_blit";
    });
    systems = [ "cl-glfw-opengl-ext_framebuffer_blit" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__framebuffer__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_framebuffer_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_framebuffer_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_framebuffer_multisample";
      asd = "cl-glfw-opengl-ext_framebuffer_multisample";
    });
    systems = [ "cl-glfw-opengl-ext_framebuffer_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__framebuffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_framebuffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_framebuffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_framebuffer_object";
      asd = "cl-glfw-opengl-ext_framebuffer_object";
    });
    systems = [ "cl-glfw-opengl-ext_framebuffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__framebuffer__srgb = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_framebuffer_srgb";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_framebuffer_srgb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_framebuffer_srgb";
      asd = "cl-glfw-opengl-ext_framebuffer_srgb";
    });
    systems = [ "cl-glfw-opengl-ext_framebuffer_srgb" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__geometry__shader4 = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_geometry_shader4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_geometry_shader4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_geometry_shader4";
      asd = "cl-glfw-opengl-ext_geometry_shader4";
    });
    systems = [ "cl-glfw-opengl-ext_geometry_shader4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__gpu__program__parameters = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_gpu_program_parameters";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_gpu_program_parameters" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_gpu_program_parameters";
      asd = "cl-glfw-opengl-ext_gpu_program_parameters";
    });
    systems = [ "cl-glfw-opengl-ext_gpu_program_parameters" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__gpu__shader4 = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_gpu_shader4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_gpu_shader4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_gpu_shader4";
      asd = "cl-glfw-opengl-ext_gpu_shader4";
    });
    systems = [ "cl-glfw-opengl-ext_gpu_shader4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__histogram = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_histogram";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_histogram" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_histogram";
      asd = "cl-glfw-opengl-ext_histogram";
    });
    systems = [ "cl-glfw-opengl-ext_histogram" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__index__array__formats = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_index_array_formats";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_index_array_formats" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_index_array_formats";
      asd = "cl-glfw-opengl-ext_index_array_formats";
    });
    systems = [ "cl-glfw-opengl-ext_index_array_formats" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__index__func = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_index_func";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_index_func" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_index_func";
      asd = "cl-glfw-opengl-ext_index_func";
    });
    systems = [ "cl-glfw-opengl-ext_index_func" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__index__material = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_index_material";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_index_material" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_index_material";
      asd = "cl-glfw-opengl-ext_index_material";
    });
    systems = [ "cl-glfw-opengl-ext_index_material" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__light__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_light_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_light_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_light_texture";
      asd = "cl-glfw-opengl-ext_light_texture";
    });
    systems = [ "cl-glfw-opengl-ext_light_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__multi__draw__arrays = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_multi_draw_arrays";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_multi_draw_arrays" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_multi_draw_arrays";
      asd = "cl-glfw-opengl-ext_multi_draw_arrays";
    });
    systems = [ "cl-glfw-opengl-ext_multi_draw_arrays" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_multisample";
      asd = "cl-glfw-opengl-ext_multisample";
    });
    systems = [ "cl-glfw-opengl-ext_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__packed__depth__stencil = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_packed_depth_stencil";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_packed_depth_stencil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_packed_depth_stencil";
      asd = "cl-glfw-opengl-ext_packed_depth_stencil";
    });
    systems = [ "cl-glfw-opengl-ext_packed_depth_stencil" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__packed__float = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_packed_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_packed_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_packed_float";
      asd = "cl-glfw-opengl-ext_packed_float";
    });
    systems = [ "cl-glfw-opengl-ext_packed_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__packed__pixels = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_packed_pixels";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_packed_pixels" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_packed_pixels";
      asd = "cl-glfw-opengl-ext_packed_pixels";
    });
    systems = [ "cl-glfw-opengl-ext_packed_pixels" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__paletted__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_paletted_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_paletted_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_paletted_texture";
      asd = "cl-glfw-opengl-ext_paletted_texture";
    });
    systems = [ "cl-glfw-opengl-ext_paletted_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__pixel__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_pixel_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_pixel_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_pixel_buffer_object";
      asd = "cl-glfw-opengl-ext_pixel_buffer_object";
    });
    systems = [ "cl-glfw-opengl-ext_pixel_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__pixel__transform = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_pixel_transform";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_pixel_transform" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_pixel_transform";
      asd = "cl-glfw-opengl-ext_pixel_transform";
    });
    systems = [ "cl-glfw-opengl-ext_pixel_transform" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__point__parameters = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_point_parameters";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_point_parameters" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_point_parameters";
      asd = "cl-glfw-opengl-ext_point_parameters";
    });
    systems = [ "cl-glfw-opengl-ext_point_parameters" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__polygon__offset = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_polygon_offset";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_polygon_offset" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_polygon_offset";
      asd = "cl-glfw-opengl-ext_polygon_offset";
    });
    systems = [ "cl-glfw-opengl-ext_polygon_offset" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__provoking__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_provoking_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_provoking_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_provoking_vertex";
      asd = "cl-glfw-opengl-ext_provoking_vertex";
    });
    systems = [ "cl-glfw-opengl-ext_provoking_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__secondary__color = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_secondary_color";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_secondary_color" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_secondary_color";
      asd = "cl-glfw-opengl-ext_secondary_color";
    });
    systems = [ "cl-glfw-opengl-ext_secondary_color" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__separate__shader__objects = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_separate_shader_objects";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_separate_shader_objects" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_separate_shader_objects";
      asd = "cl-glfw-opengl-ext_separate_shader_objects";
    });
    systems = [ "cl-glfw-opengl-ext_separate_shader_objects" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__separate__specular__color = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_separate_specular_color";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_separate_specular_color" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_separate_specular_color";
      asd = "cl-glfw-opengl-ext_separate_specular_color";
    });
    systems = [ "cl-glfw-opengl-ext_separate_specular_color" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__shader__image__load__store = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_shader_image_load_store";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_shader_image_load_store" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_shader_image_load_store";
      asd = "cl-glfw-opengl-ext_shader_image_load_store";
    });
    systems = [ "cl-glfw-opengl-ext_shader_image_load_store" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__stencil__clear__tag = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_stencil_clear_tag";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_stencil_clear_tag" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_stencil_clear_tag";
      asd = "cl-glfw-opengl-ext_stencil_clear_tag";
    });
    systems = [ "cl-glfw-opengl-ext_stencil_clear_tag" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__stencil__two__side = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_stencil_two_side";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_stencil_two_side" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_stencil_two_side";
      asd = "cl-glfw-opengl-ext_stencil_two_side";
    });
    systems = [ "cl-glfw-opengl-ext_stencil_two_side" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__stencil__wrap = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_stencil_wrap";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_stencil_wrap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_stencil_wrap";
      asd = "cl-glfw-opengl-ext_stencil_wrap";
    });
    systems = [ "cl-glfw-opengl-ext_stencil_wrap" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__subtexture = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_subtexture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_subtexture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_subtexture";
      asd = "cl-glfw-opengl-ext_subtexture";
    });
    systems = [ "cl-glfw-opengl-ext_subtexture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture";
      asd = "cl-glfw-opengl-ext_texture";
    });
    systems = [ "cl-glfw-opengl-ext_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture3d = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture3d";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture3d" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture3d";
      asd = "cl-glfw-opengl-ext_texture3d";
    });
    systems = [ "cl-glfw-opengl-ext_texture3d" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__array = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_array";
      asd = "cl-glfw-opengl-ext_texture_array";
    });
    systems = [ "cl-glfw-opengl-ext_texture_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_buffer_object";
      asd = "cl-glfw-opengl-ext_texture_buffer_object";
    });
    systems = [ "cl-glfw-opengl-ext_texture_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__compression__latc = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_compression_latc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_compression_latc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_compression_latc";
      asd = "cl-glfw-opengl-ext_texture_compression_latc";
    });
    systems = [ "cl-glfw-opengl-ext_texture_compression_latc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__compression__rgtc = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_compression_rgtc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_compression_rgtc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_compression_rgtc";
      asd = "cl-glfw-opengl-ext_texture_compression_rgtc";
    });
    systems = [ "cl-glfw-opengl-ext_texture_compression_rgtc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__compression__s3tc = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_compression_s3tc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_compression_s3tc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_compression_s3tc";
      asd = "cl-glfw-opengl-ext_texture_compression_s3tc";
    });
    systems = [ "cl-glfw-opengl-ext_texture_compression_s3tc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__cube__map = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_cube_map";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_cube_map" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_cube_map";
      asd = "cl-glfw-opengl-ext_texture_cube_map";
    });
    systems = [ "cl-glfw-opengl-ext_texture_cube_map" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__env__combine = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_env_combine";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_env_combine" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_env_combine";
      asd = "cl-glfw-opengl-ext_texture_env_combine";
    });
    systems = [ "cl-glfw-opengl-ext_texture_env_combine" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__env__dot3 = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_env_dot3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_env_dot3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_env_dot3";
      asd = "cl-glfw-opengl-ext_texture_env_dot3";
    });
    systems = [ "cl-glfw-opengl-ext_texture_env_dot3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__filter__anisotropic = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_filter_anisotropic";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_filter_anisotropic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_filter_anisotropic";
      asd = "cl-glfw-opengl-ext_texture_filter_anisotropic";
    });
    systems = [ "cl-glfw-opengl-ext_texture_filter_anisotropic" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__integer = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_integer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_integer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_integer";
      asd = "cl-glfw-opengl-ext_texture_integer";
    });
    systems = [ "cl-glfw-opengl-ext_texture_integer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__lod__bias = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_lod_bias";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_lod_bias" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_lod_bias";
      asd = "cl-glfw-opengl-ext_texture_lod_bias";
    });
    systems = [ "cl-glfw-opengl-ext_texture_lod_bias" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__mirror__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_mirror_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_mirror_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_mirror_clamp";
      asd = "cl-glfw-opengl-ext_texture_mirror_clamp";
    });
    systems = [ "cl-glfw-opengl-ext_texture_mirror_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__object = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_object";
      asd = "cl-glfw-opengl-ext_texture_object";
    });
    systems = [ "cl-glfw-opengl-ext_texture_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__perturb__normal = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_perturb_normal";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_perturb_normal" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_perturb_normal";
      asd = "cl-glfw-opengl-ext_texture_perturb_normal";
    });
    systems = [ "cl-glfw-opengl-ext_texture_perturb_normal" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__shared__exponent = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_shared_exponent";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_shared_exponent" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_shared_exponent";
      asd = "cl-glfw-opengl-ext_texture_shared_exponent";
    });
    systems = [ "cl-glfw-opengl-ext_texture_shared_exponent" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__snorm = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_snorm";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_snorm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_snorm";
      asd = "cl-glfw-opengl-ext_texture_snorm";
    });
    systems = [ "cl-glfw-opengl-ext_texture_snorm" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__srgb = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_srgb";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_srgb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_srgb";
      asd = "cl-glfw-opengl-ext_texture_srgb";
    });
    systems = [ "cl-glfw-opengl-ext_texture_srgb" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__srgb__decode = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_srgb_decode";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_srgb_decode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_srgb_decode";
      asd = "cl-glfw-opengl-ext_texture_srgb_decode";
    });
    systems = [ "cl-glfw-opengl-ext_texture_srgb_decode" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__texture__swizzle = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_texture_swizzle";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_texture_swizzle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_texture_swizzle";
      asd = "cl-glfw-opengl-ext_texture_swizzle";
    });
    systems = [ "cl-glfw-opengl-ext_texture_swizzle" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__timer__query = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_timer_query";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_timer_query" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_timer_query";
      asd = "cl-glfw-opengl-ext_timer_query";
    });
    systems = [ "cl-glfw-opengl-ext_timer_query" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__transform__feedback = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_transform_feedback";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_transform_feedback" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_transform_feedback";
      asd = "cl-glfw-opengl-ext_transform_feedback";
    });
    systems = [ "cl-glfw-opengl-ext_transform_feedback" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__vertex__array = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_vertex_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_vertex_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_vertex_array";
      asd = "cl-glfw-opengl-ext_vertex_array";
    });
    systems = [ "cl-glfw-opengl-ext_vertex_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__vertex__array__bgra = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_vertex_array_bgra";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_vertex_array_bgra" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_vertex_array_bgra";
      asd = "cl-glfw-opengl-ext_vertex_array_bgra";
    });
    systems = [ "cl-glfw-opengl-ext_vertex_array_bgra" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__vertex__attrib__64bit = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_vertex_attrib_64bit";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_vertex_attrib_64bit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_vertex_attrib_64bit";
      asd = "cl-glfw-opengl-ext_vertex_attrib_64bit";
    });
    systems = [ "cl-glfw-opengl-ext_vertex_attrib_64bit" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__vertex__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_vertex_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_vertex_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_vertex_shader";
      asd = "cl-glfw-opengl-ext_vertex_shader";
    });
    systems = [ "cl-glfw-opengl-ext_vertex_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ext__vertex__weighting = (build-asdf-system {
    pname = "cl-glfw-opengl-ext_vertex_weighting";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ext_vertex_weighting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ext_vertex_weighting";
      asd = "cl-glfw-opengl-ext_vertex_weighting";
    });
    systems = [ "cl-glfw-opengl-ext_vertex_weighting" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-gremedy__frame__terminator = (build-asdf-system {
    pname = "cl-glfw-opengl-gremedy_frame_terminator";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-gremedy_frame_terminator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-gremedy_frame_terminator";
      asd = "cl-glfw-opengl-gremedy_frame_terminator";
    });
    systems = [ "cl-glfw-opengl-gremedy_frame_terminator" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-gremedy__string__marker = (build-asdf-system {
    pname = "cl-glfw-opengl-gremedy_string_marker";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-gremedy_string_marker" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-gremedy_string_marker";
      asd = "cl-glfw-opengl-gremedy_string_marker";
    });
    systems = [ "cl-glfw-opengl-gremedy_string_marker" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-hp__convolution__border__modes = (build-asdf-system {
    pname = "cl-glfw-opengl-hp_convolution_border_modes";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-hp_convolution_border_modes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-hp_convolution_border_modes";
      asd = "cl-glfw-opengl-hp_convolution_border_modes";
    });
    systems = [ "cl-glfw-opengl-hp_convolution_border_modes" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-hp__image__transform = (build-asdf-system {
    pname = "cl-glfw-opengl-hp_image_transform";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-hp_image_transform" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-hp_image_transform";
      asd = "cl-glfw-opengl-hp_image_transform";
    });
    systems = [ "cl-glfw-opengl-hp_image_transform" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-hp__occlusion__test = (build-asdf-system {
    pname = "cl-glfw-opengl-hp_occlusion_test";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-hp_occlusion_test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-hp_occlusion_test";
      asd = "cl-glfw-opengl-hp_occlusion_test";
    });
    systems = [ "cl-glfw-opengl-hp_occlusion_test" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-hp__texture__lighting = (build-asdf-system {
    pname = "cl-glfw-opengl-hp_texture_lighting";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-hp_texture_lighting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-hp_texture_lighting";
      asd = "cl-glfw-opengl-hp_texture_lighting";
    });
    systems = [ "cl-glfw-opengl-hp_texture_lighting" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ibm__cull__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-ibm_cull_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ibm_cull_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ibm_cull_vertex";
      asd = "cl-glfw-opengl-ibm_cull_vertex";
    });
    systems = [ "cl-glfw-opengl-ibm_cull_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ibm__multimode__draw__arrays = (build-asdf-system {
    pname = "cl-glfw-opengl-ibm_multimode_draw_arrays";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ibm_multimode_draw_arrays" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ibm_multimode_draw_arrays";
      asd = "cl-glfw-opengl-ibm_multimode_draw_arrays";
    });
    systems = [ "cl-glfw-opengl-ibm_multimode_draw_arrays" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ibm__rasterpos__clip = (build-asdf-system {
    pname = "cl-glfw-opengl-ibm_rasterpos_clip";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ibm_rasterpos_clip" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ibm_rasterpos_clip";
      asd = "cl-glfw-opengl-ibm_rasterpos_clip";
    });
    systems = [ "cl-glfw-opengl-ibm_rasterpos_clip" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ibm__texture__mirrored__repeat = (build-asdf-system {
    pname = "cl-glfw-opengl-ibm_texture_mirrored_repeat";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ibm_texture_mirrored_repeat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ibm_texture_mirrored_repeat";
      asd = "cl-glfw-opengl-ibm_texture_mirrored_repeat";
    });
    systems = [ "cl-glfw-opengl-ibm_texture_mirrored_repeat" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ibm__vertex__array__lists = (build-asdf-system {
    pname = "cl-glfw-opengl-ibm_vertex_array_lists";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ibm_vertex_array_lists" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ibm_vertex_array_lists";
      asd = "cl-glfw-opengl-ibm_vertex_array_lists";
    });
    systems = [ "cl-glfw-opengl-ibm_vertex_array_lists" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ingr__blend__func__separate = (build-asdf-system {
    pname = "cl-glfw-opengl-ingr_blend_func_separate";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ingr_blend_func_separate" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ingr_blend_func_separate";
      asd = "cl-glfw-opengl-ingr_blend_func_separate";
    });
    systems = [ "cl-glfw-opengl-ingr_blend_func_separate" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ingr__color__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-ingr_color_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ingr_color_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ingr_color_clamp";
      asd = "cl-glfw-opengl-ingr_color_clamp";
    });
    systems = [ "cl-glfw-opengl-ingr_color_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-ingr__interlace__read = (build-asdf-system {
    pname = "cl-glfw-opengl-ingr_interlace_read";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-ingr_interlace_read" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-ingr_interlace_read";
      asd = "cl-glfw-opengl-ingr_interlace_read";
    });
    systems = [ "cl-glfw-opengl-ingr_interlace_read" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-intel__parallel__arrays = (build-asdf-system {
    pname = "cl-glfw-opengl-intel_parallel_arrays";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-intel_parallel_arrays" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-intel_parallel_arrays";
      asd = "cl-glfw-opengl-intel_parallel_arrays";
    });
    systems = [ "cl-glfw-opengl-intel_parallel_arrays" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__pack__invert = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_pack_invert";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_pack_invert" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_pack_invert";
      asd = "cl-glfw-opengl-mesa_pack_invert";
    });
    systems = [ "cl-glfw-opengl-mesa_pack_invert" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__packed__depth__stencil = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_packed_depth_stencil";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_packed_depth_stencil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_packed_depth_stencil";
      asd = "cl-glfw-opengl-mesa_packed_depth_stencil";
    });
    systems = [ "cl-glfw-opengl-mesa_packed_depth_stencil" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__program__debug = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_program_debug";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_program_debug" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_program_debug";
      asd = "cl-glfw-opengl-mesa_program_debug";
    });
    systems = [ "cl-glfw-opengl-mesa_program_debug" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__resize__buffers = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_resize_buffers";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_resize_buffers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_resize_buffers";
      asd = "cl-glfw-opengl-mesa_resize_buffers";
    });
    systems = [ "cl-glfw-opengl-mesa_resize_buffers" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__shader__debug = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_shader_debug";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_shader_debug" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_shader_debug";
      asd = "cl-glfw-opengl-mesa_shader_debug";
    });
    systems = [ "cl-glfw-opengl-mesa_shader_debug" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__trace = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_trace";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_trace" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_trace";
      asd = "cl-glfw-opengl-mesa_trace";
    });
    systems = [ "cl-glfw-opengl-mesa_trace" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__window__pos = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_window_pos";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_window_pos" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_window_pos";
      asd = "cl-glfw-opengl-mesa_window_pos";
    });
    systems = [ "cl-glfw-opengl-mesa_window_pos" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesa__ycbcr__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-mesa_ycbcr_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesa_ycbcr_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesa_ycbcr_texture";
      asd = "cl-glfw-opengl-mesa_ycbcr_texture";
    });
    systems = [ "cl-glfw-opengl-mesa_ycbcr_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-mesax__texture__stack = (build-asdf-system {
    pname = "cl-glfw-opengl-mesax_texture_stack";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-mesax_texture_stack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-mesax_texture_stack";
      asd = "cl-glfw-opengl-mesax_texture_stack";
    });
    systems = [ "cl-glfw-opengl-mesax_texture_stack" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__conditional__render = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_conditional_render";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_conditional_render" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_conditional_render";
      asd = "cl-glfw-opengl-nv_conditional_render";
    });
    systems = [ "cl-glfw-opengl-nv_conditional_render" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__copy__depth__to__color = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_copy_depth_to_color";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_copy_depth_to_color" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_copy_depth_to_color";
      asd = "cl-glfw-opengl-nv_copy_depth_to_color";
    });
    systems = [ "cl-glfw-opengl-nv_copy_depth_to_color" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__copy__image = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_copy_image";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_copy_image" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_copy_image";
      asd = "cl-glfw-opengl-nv_copy_image";
    });
    systems = [ "cl-glfw-opengl-nv_copy_image" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__depth__buffer__float = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_depth_buffer_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_depth_buffer_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_depth_buffer_float";
      asd = "cl-glfw-opengl-nv_depth_buffer_float";
    });
    systems = [ "cl-glfw-opengl-nv_depth_buffer_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__depth__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_depth_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_depth_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_depth_clamp";
      asd = "cl-glfw-opengl-nv_depth_clamp";
    });
    systems = [ "cl-glfw-opengl-nv_depth_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__evaluators = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_evaluators";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_evaluators" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_evaluators";
      asd = "cl-glfw-opengl-nv_evaluators";
    });
    systems = [ "cl-glfw-opengl-nv_evaluators" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__explicit__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_explicit_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_explicit_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_explicit_multisample";
      asd = "cl-glfw-opengl-nv_explicit_multisample";
    });
    systems = [ "cl-glfw-opengl-nv_explicit_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__fence = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_fence";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_fence" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_fence";
      asd = "cl-glfw-opengl-nv_fence";
    });
    systems = [ "cl-glfw-opengl-nv_fence" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__float__buffer = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_float_buffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_float_buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_float_buffer";
      asd = "cl-glfw-opengl-nv_float_buffer";
    });
    systems = [ "cl-glfw-opengl-nv_float_buffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__fog__distance = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_fog_distance";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_fog_distance" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_fog_distance";
      asd = "cl-glfw-opengl-nv_fog_distance";
    });
    systems = [ "cl-glfw-opengl-nv_fog_distance" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__fragment__program = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_fragment_program";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_fragment_program" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_fragment_program";
      asd = "cl-glfw-opengl-nv_fragment_program";
    });
    systems = [ "cl-glfw-opengl-nv_fragment_program" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__fragment__program2 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_fragment_program2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_fragment_program2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_fragment_program2";
      asd = "cl-glfw-opengl-nv_fragment_program2";
    });
    systems = [ "cl-glfw-opengl-nv_fragment_program2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__framebuffer__multisample__coverage = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_framebuffer_multisample_coverage";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_framebuffer_multisample_coverage" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_framebuffer_multisample_coverage";
      asd = "cl-glfw-opengl-nv_framebuffer_multisample_coverage";
    });
    systems = [ "cl-glfw-opengl-nv_framebuffer_multisample_coverage" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__geometry__program4 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_geometry_program4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_geometry_program4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_geometry_program4";
      asd = "cl-glfw-opengl-nv_geometry_program4";
    });
    systems = [ "cl-glfw-opengl-nv_geometry_program4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__gpu__program4 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_gpu_program4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_gpu_program4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_gpu_program4";
      asd = "cl-glfw-opengl-nv_gpu_program4";
    });
    systems = [ "cl-glfw-opengl-nv_gpu_program4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__gpu__program5 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_gpu_program5";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_gpu_program5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_gpu_program5";
      asd = "cl-glfw-opengl-nv_gpu_program5";
    });
    systems = [ "cl-glfw-opengl-nv_gpu_program5" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__gpu__shader5 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_gpu_shader5";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_gpu_shader5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_gpu_shader5";
      asd = "cl-glfw-opengl-nv_gpu_shader5";
    });
    systems = [ "cl-glfw-opengl-nv_gpu_shader5" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__half__float = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_half_float";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_half_float" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_half_float";
      asd = "cl-glfw-opengl-nv_half_float";
    });
    systems = [ "cl-glfw-opengl-nv_half_float" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__light__max__exponent = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_light_max_exponent";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_light_max_exponent" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_light_max_exponent";
      asd = "cl-glfw-opengl-nv_light_max_exponent";
    });
    systems = [ "cl-glfw-opengl-nv_light_max_exponent" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__multisample__coverage = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_multisample_coverage";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_multisample_coverage" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_multisample_coverage";
      asd = "cl-glfw-opengl-nv_multisample_coverage";
    });
    systems = [ "cl-glfw-opengl-nv_multisample_coverage" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__multisample__filter__hint = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_multisample_filter_hint";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_multisample_filter_hint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_multisample_filter_hint";
      asd = "cl-glfw-opengl-nv_multisample_filter_hint";
    });
    systems = [ "cl-glfw-opengl-nv_multisample_filter_hint" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__occlusion__query = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_occlusion_query";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_occlusion_query" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_occlusion_query";
      asd = "cl-glfw-opengl-nv_occlusion_query";
    });
    systems = [ "cl-glfw-opengl-nv_occlusion_query" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__packed__depth__stencil = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_packed_depth_stencil";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_packed_depth_stencil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_packed_depth_stencil";
      asd = "cl-glfw-opengl-nv_packed_depth_stencil";
    });
    systems = [ "cl-glfw-opengl-nv_packed_depth_stencil" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__parameter__buffer__object = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_parameter_buffer_object";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_parameter_buffer_object" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_parameter_buffer_object";
      asd = "cl-glfw-opengl-nv_parameter_buffer_object";
    });
    systems = [ "cl-glfw-opengl-nv_parameter_buffer_object" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__pixel__data__range = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_pixel_data_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_pixel_data_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_pixel_data_range";
      asd = "cl-glfw-opengl-nv_pixel_data_range";
    });
    systems = [ "cl-glfw-opengl-nv_pixel_data_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__point__sprite = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_point_sprite";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_point_sprite" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_point_sprite";
      asd = "cl-glfw-opengl-nv_point_sprite";
    });
    systems = [ "cl-glfw-opengl-nv_point_sprite" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__present__video = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_present_video";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_present_video" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_present_video";
      asd = "cl-glfw-opengl-nv_present_video";
    });
    systems = [ "cl-glfw-opengl-nv_present_video" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__primitive__restart = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_primitive_restart";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_primitive_restart" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_primitive_restart";
      asd = "cl-glfw-opengl-nv_primitive_restart";
    });
    systems = [ "cl-glfw-opengl-nv_primitive_restart" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__register__combiners = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_register_combiners";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_register_combiners" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_register_combiners";
      asd = "cl-glfw-opengl-nv_register_combiners";
    });
    systems = [ "cl-glfw-opengl-nv_register_combiners" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__register__combiners2 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_register_combiners2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_register_combiners2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_register_combiners2";
      asd = "cl-glfw-opengl-nv_register_combiners2";
    });
    systems = [ "cl-glfw-opengl-nv_register_combiners2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__shader__buffer__load = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_shader_buffer_load";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_shader_buffer_load" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_shader_buffer_load";
      asd = "cl-glfw-opengl-nv_shader_buffer_load";
    });
    systems = [ "cl-glfw-opengl-nv_shader_buffer_load" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__shader__buffer__store = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_shader_buffer_store";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_shader_buffer_store" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_shader_buffer_store";
      asd = "cl-glfw-opengl-nv_shader_buffer_store";
    });
    systems = [ "cl-glfw-opengl-nv_shader_buffer_store" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__tessellation__program5 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_tessellation_program5";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_tessellation_program5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_tessellation_program5";
      asd = "cl-glfw-opengl-nv_tessellation_program5";
    });
    systems = [ "cl-glfw-opengl-nv_tessellation_program5" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texgen__emboss = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texgen_emboss";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texgen_emboss" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texgen_emboss";
      asd = "cl-glfw-opengl-nv_texgen_emboss";
    });
    systems = [ "cl-glfw-opengl-nv_texgen_emboss" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texgen__reflection = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texgen_reflection";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texgen_reflection" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texgen_reflection";
      asd = "cl-glfw-opengl-nv_texgen_reflection";
    });
    systems = [ "cl-glfw-opengl-nv_texgen_reflection" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__barrier = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_barrier";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_barrier" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_barrier";
      asd = "cl-glfw-opengl-nv_texture_barrier";
    });
    systems = [ "cl-glfw-opengl-nv_texture_barrier" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__env__combine4 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_env_combine4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_env_combine4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_env_combine4";
      asd = "cl-glfw-opengl-nv_texture_env_combine4";
    });
    systems = [ "cl-glfw-opengl-nv_texture_env_combine4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__expand__normal = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_expand_normal";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_expand_normal" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_expand_normal";
      asd = "cl-glfw-opengl-nv_texture_expand_normal";
    });
    systems = [ "cl-glfw-opengl-nv_texture_expand_normal" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_multisample";
      asd = "cl-glfw-opengl-nv_texture_multisample";
    });
    systems = [ "cl-glfw-opengl-nv_texture_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__rectangle = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_rectangle";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_rectangle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_rectangle";
      asd = "cl-glfw-opengl-nv_texture_rectangle";
    });
    systems = [ "cl-glfw-opengl-nv_texture_rectangle" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__shader = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_shader";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_shader" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_shader";
      asd = "cl-glfw-opengl-nv_texture_shader";
    });
    systems = [ "cl-glfw-opengl-nv_texture_shader" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__shader2 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_shader2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_shader2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_shader2";
      asd = "cl-glfw-opengl-nv_texture_shader2";
    });
    systems = [ "cl-glfw-opengl-nv_texture_shader2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__texture__shader3 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_texture_shader3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_texture_shader3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_texture_shader3";
      asd = "cl-glfw-opengl-nv_texture_shader3";
    });
    systems = [ "cl-glfw-opengl-nv_texture_shader3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__transform__feedback = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_transform_feedback";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_transform_feedback" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_transform_feedback";
      asd = "cl-glfw-opengl-nv_transform_feedback";
    });
    systems = [ "cl-glfw-opengl-nv_transform_feedback" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__transform__feedback2 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_transform_feedback2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_transform_feedback2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_transform_feedback2";
      asd = "cl-glfw-opengl-nv_transform_feedback2";
    });
    systems = [ "cl-glfw-opengl-nv_transform_feedback2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__array__range = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_array_range";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_array_range" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_array_range";
      asd = "cl-glfw-opengl-nv_vertex_array_range";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_array_range" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__array__range2 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_array_range2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_array_range2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_array_range2";
      asd = "cl-glfw-opengl-nv_vertex_array_range2";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_array_range2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__attrib__integer__64bit = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_attrib_integer_64bit";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_attrib_integer_64bit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_attrib_integer_64bit";
      asd = "cl-glfw-opengl-nv_vertex_attrib_integer_64bit";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_attrib_integer_64bit" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__buffer__unified__memory = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_buffer_unified_memory";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_buffer_unified_memory" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_buffer_unified_memory";
      asd = "cl-glfw-opengl-nv_vertex_buffer_unified_memory";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_buffer_unified_memory" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__program = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_program";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_program" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_program";
      asd = "cl-glfw-opengl-nv_vertex_program";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_program" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__program2__option = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_program2_option";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_program2_option" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_program2_option";
      asd = "cl-glfw-opengl-nv_vertex_program2_option";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_program2_option" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__program3 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_program3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_program3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_program3";
      asd = "cl-glfw-opengl-nv_vertex_program3";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_program3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-nv__vertex__program4 = (build-asdf-system {
    pname = "cl-glfw-opengl-nv_vertex_program4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-nv_vertex_program4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-nv_vertex_program4";
      asd = "cl-glfw-opengl-nv_vertex_program4";
    });
    systems = [ "cl-glfw-opengl-nv_vertex_program4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-oes__read__format = (build-asdf-system {
    pname = "cl-glfw-opengl-oes_read_format";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-oes_read_format" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-oes_read_format";
      asd = "cl-glfw-opengl-oes_read_format";
    });
    systems = [ "cl-glfw-opengl-oes_read_format" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-oml__interlace = (build-asdf-system {
    pname = "cl-glfw-opengl-oml_interlace";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-oml_interlace" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-oml_interlace";
      asd = "cl-glfw-opengl-oml_interlace";
    });
    systems = [ "cl-glfw-opengl-oml_interlace" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-oml__resample = (build-asdf-system {
    pname = "cl-glfw-opengl-oml_resample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-oml_resample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-oml_resample";
      asd = "cl-glfw-opengl-oml_resample";
    });
    systems = [ "cl-glfw-opengl-oml_resample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-oml__subsample = (build-asdf-system {
    pname = "cl-glfw-opengl-oml_subsample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-oml_subsample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-oml_subsample";
      asd = "cl-glfw-opengl-oml_subsample";
    });
    systems = [ "cl-glfw-opengl-oml_subsample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-pgi__misc__hints = (build-asdf-system {
    pname = "cl-glfw-opengl-pgi_misc_hints";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-pgi_misc_hints" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-pgi_misc_hints";
      asd = "cl-glfw-opengl-pgi_misc_hints";
    });
    systems = [ "cl-glfw-opengl-pgi_misc_hints" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-pgi__vertex__hints = (build-asdf-system {
    pname = "cl-glfw-opengl-pgi_vertex_hints";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-pgi_vertex_hints" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-pgi_vertex_hints";
      asd = "cl-glfw-opengl-pgi_vertex_hints";
    });
    systems = [ "cl-glfw-opengl-pgi_vertex_hints" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-rend__screen__coordinates = (build-asdf-system {
    pname = "cl-glfw-opengl-rend_screen_coordinates";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-rend_screen_coordinates" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-rend_screen_coordinates";
      asd = "cl-glfw-opengl-rend_screen_coordinates";
    });
    systems = [ "cl-glfw-opengl-rend_screen_coordinates" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-s3__s3tc = (build-asdf-system {
    pname = "cl-glfw-opengl-s3_s3tc";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-s3_s3tc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-s3_s3tc";
      asd = "cl-glfw-opengl-s3_s3tc";
    });
    systems = [ "cl-glfw-opengl-s3_s3tc" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgi__color__table = (build-asdf-system {
    pname = "cl-glfw-opengl-sgi_color_table";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgi_color_table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgi_color_table";
      asd = "cl-glfw-opengl-sgi_color_table";
    });
    systems = [ "cl-glfw-opengl-sgi_color_table" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgi__depth__pass__instrument = (build-asdf-system {
    pname = "cl-glfw-opengl-sgi_depth_pass_instrument";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgi_depth_pass_instrument" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgi_depth_pass_instrument";
      asd = "cl-glfw-opengl-sgi_depth_pass_instrument";
    });
    systems = [ "cl-glfw-opengl-sgi_depth_pass_instrument" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__detail__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_detail_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_detail_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_detail_texture";
      asd = "cl-glfw-opengl-sgis_detail_texture";
    });
    systems = [ "cl-glfw-opengl-sgis_detail_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__fog__function = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_fog_function";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_fog_function" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_fog_function";
      asd = "cl-glfw-opengl-sgis_fog_function";
    });
    systems = [ "cl-glfw-opengl-sgis_fog_function" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__multisample = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_multisample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_multisample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_multisample";
      asd = "cl-glfw-opengl-sgis_multisample";
    });
    systems = [ "cl-glfw-opengl-sgis_multisample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__pixel__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_pixel_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_pixel_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_pixel_texture";
      asd = "cl-glfw-opengl-sgis_pixel_texture";
    });
    systems = [ "cl-glfw-opengl-sgis_pixel_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__point__parameters = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_point_parameters";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_point_parameters" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_point_parameters";
      asd = "cl-glfw-opengl-sgis_point_parameters";
    });
    systems = [ "cl-glfw-opengl-sgis_point_parameters" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__sharpen__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_sharpen_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_sharpen_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_sharpen_texture";
      asd = "cl-glfw-opengl-sgis_sharpen_texture";
    });
    systems = [ "cl-glfw-opengl-sgis_sharpen_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__texture4d = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_texture4d";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_texture4d" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_texture4d";
      asd = "cl-glfw-opengl-sgis_texture4d";
    });
    systems = [ "cl-glfw-opengl-sgis_texture4d" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__texture__color__mask = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_texture_color_mask";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_texture_color_mask" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_texture_color_mask";
      asd = "cl-glfw-opengl-sgis_texture_color_mask";
    });
    systems = [ "cl-glfw-opengl-sgis_texture_color_mask" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__texture__filter4 = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_texture_filter4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_texture_filter4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_texture_filter4";
      asd = "cl-glfw-opengl-sgis_texture_filter4";
    });
    systems = [ "cl-glfw-opengl-sgis_texture_filter4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgis__texture__select = (build-asdf-system {
    pname = "cl-glfw-opengl-sgis_texture_select";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgis_texture_select" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgis_texture_select";
      asd = "cl-glfw-opengl-sgis_texture_select";
    });
    systems = [ "cl-glfw-opengl-sgis_texture_select" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__async = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_async";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_async" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_async";
      asd = "cl-glfw-opengl-sgix_async";
    });
    systems = [ "cl-glfw-opengl-sgix_async" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__depth__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_depth_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_depth_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_depth_texture";
      asd = "cl-glfw-opengl-sgix_depth_texture";
    });
    systems = [ "cl-glfw-opengl-sgix_depth_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__flush__raster = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_flush_raster";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_flush_raster" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_flush_raster";
      asd = "cl-glfw-opengl-sgix_flush_raster";
    });
    systems = [ "cl-glfw-opengl-sgix_flush_raster" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__fog__scale = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_fog_scale";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_fog_scale" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_fog_scale";
      asd = "cl-glfw-opengl-sgix_fog_scale";
    });
    systems = [ "cl-glfw-opengl-sgix_fog_scale" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__fragment__lighting = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_fragment_lighting";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_fragment_lighting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_fragment_lighting";
      asd = "cl-glfw-opengl-sgix_fragment_lighting";
    });
    systems = [ "cl-glfw-opengl-sgix_fragment_lighting" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__framezoom = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_framezoom";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_framezoom" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_framezoom";
      asd = "cl-glfw-opengl-sgix_framezoom";
    });
    systems = [ "cl-glfw-opengl-sgix_framezoom" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__igloo__interface = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_igloo_interface";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_igloo_interface" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_igloo_interface";
      asd = "cl-glfw-opengl-sgix_igloo_interface";
    });
    systems = [ "cl-glfw-opengl-sgix_igloo_interface" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__instruments = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_instruments";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_instruments" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_instruments";
      asd = "cl-glfw-opengl-sgix_instruments";
    });
    systems = [ "cl-glfw-opengl-sgix_instruments" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__line__quality__hint = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_line_quality_hint";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_line_quality_hint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_line_quality_hint";
      asd = "cl-glfw-opengl-sgix_line_quality_hint";
    });
    systems = [ "cl-glfw-opengl-sgix_line_quality_hint" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__list__priority = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_list_priority";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_list_priority" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_list_priority";
      asd = "cl-glfw-opengl-sgix_list_priority";
    });
    systems = [ "cl-glfw-opengl-sgix_list_priority" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__pixel__texture = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_pixel_texture";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_pixel_texture" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_pixel_texture";
      asd = "cl-glfw-opengl-sgix_pixel_texture";
    });
    systems = [ "cl-glfw-opengl-sgix_pixel_texture" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__polynomial__ffd = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_polynomial_ffd";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_polynomial_ffd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_polynomial_ffd";
      asd = "cl-glfw-opengl-sgix_polynomial_ffd";
    });
    systems = [ "cl-glfw-opengl-sgix_polynomial_ffd" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__reference__plane = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_reference_plane";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_reference_plane" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_reference_plane";
      asd = "cl-glfw-opengl-sgix_reference_plane";
    });
    systems = [ "cl-glfw-opengl-sgix_reference_plane" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__resample = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_resample";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_resample" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_resample";
      asd = "cl-glfw-opengl-sgix_resample";
    });
    systems = [ "cl-glfw-opengl-sgix_resample" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__scalebias__hint = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_scalebias_hint";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_scalebias_hint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_scalebias_hint";
      asd = "cl-glfw-opengl-sgix_scalebias_hint";
    });
    systems = [ "cl-glfw-opengl-sgix_scalebias_hint" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__shadow = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_shadow";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_shadow" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_shadow";
      asd = "cl-glfw-opengl-sgix_shadow";
    });
    systems = [ "cl-glfw-opengl-sgix_shadow" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__shadow__ambient = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_shadow_ambient";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_shadow_ambient" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_shadow_ambient";
      asd = "cl-glfw-opengl-sgix_shadow_ambient";
    });
    systems = [ "cl-glfw-opengl-sgix_shadow_ambient" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__slim = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_slim";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_slim" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_slim";
      asd = "cl-glfw-opengl-sgix_slim";
    });
    systems = [ "cl-glfw-opengl-sgix_slim" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__sprite = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_sprite";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_sprite" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_sprite";
      asd = "cl-glfw-opengl-sgix_sprite";
    });
    systems = [ "cl-glfw-opengl-sgix_sprite" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__tag__sample__buffer = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_tag_sample_buffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_tag_sample_buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_tag_sample_buffer";
      asd = "cl-glfw-opengl-sgix_tag_sample_buffer";
    });
    systems = [ "cl-glfw-opengl-sgix_tag_sample_buffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__texture__coordinate__clamp = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_texture_coordinate_clamp";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_texture_coordinate_clamp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_texture_coordinate_clamp";
      asd = "cl-glfw-opengl-sgix_texture_coordinate_clamp";
    });
    systems = [ "cl-glfw-opengl-sgix_texture_coordinate_clamp" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__texture__lod__bias = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_texture_lod_bias";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_texture_lod_bias" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_texture_lod_bias";
      asd = "cl-glfw-opengl-sgix_texture_lod_bias";
    });
    systems = [ "cl-glfw-opengl-sgix_texture_lod_bias" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__texture__multi__buffer = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_texture_multi_buffer";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_texture_multi_buffer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_texture_multi_buffer";
      asd = "cl-glfw-opengl-sgix_texture_multi_buffer";
    });
    systems = [ "cl-glfw-opengl-sgix_texture_multi_buffer" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sgix__ycrcba = (build-asdf-system {
    pname = "cl-glfw-opengl-sgix_ycrcba";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sgix_ycrcba" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sgix_ycrcba";
      asd = "cl-glfw-opengl-sgix_ycrcba";
    });
    systems = [ "cl-glfw-opengl-sgix_ycrcba" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__convolution__border__modes = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_convolution_border_modes";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_convolution_border_modes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_convolution_border_modes";
      asd = "cl-glfw-opengl-sun_convolution_border_modes";
    });
    systems = [ "cl-glfw-opengl-sun_convolution_border_modes" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__global__alpha = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_global_alpha";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_global_alpha" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_global_alpha";
      asd = "cl-glfw-opengl-sun_global_alpha";
    });
    systems = [ "cl-glfw-opengl-sun_global_alpha" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__mesh__array = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_mesh_array";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_mesh_array" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_mesh_array";
      asd = "cl-glfw-opengl-sun_mesh_array";
    });
    systems = [ "cl-glfw-opengl-sun_mesh_array" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__slice__accum = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_slice_accum";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_slice_accum" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_slice_accum";
      asd = "cl-glfw-opengl-sun_slice_accum";
    });
    systems = [ "cl-glfw-opengl-sun_slice_accum" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__triangle__list = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_triangle_list";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_triangle_list" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_triangle_list";
      asd = "cl-glfw-opengl-sun_triangle_list";
    });
    systems = [ "cl-glfw-opengl-sun_triangle_list" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sun__vertex = (build-asdf-system {
    pname = "cl-glfw-opengl-sun_vertex";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sun_vertex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sun_vertex";
      asd = "cl-glfw-opengl-sun_vertex";
    });
    systems = [ "cl-glfw-opengl-sun_vertex" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-sunx__constant__data = (build-asdf-system {
    pname = "cl-glfw-opengl-sunx_constant_data";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-sunx_constant_data" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-sunx_constant_data";
      asd = "cl-glfw-opengl-sunx_constant_data";
    });
    systems = [ "cl-glfw-opengl-sunx_constant_data" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__0 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_0";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_0" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_0";
      asd = "cl-glfw-opengl-version_1_0";
    });
    systems = [ "cl-glfw-opengl-version_1_0" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__1 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_1";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_1" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_1";
      asd = "cl-glfw-opengl-version_1_1";
    });
    systems = [ "cl-glfw-opengl-version_1_1" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__2 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_2";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_2";
      asd = "cl-glfw-opengl-version_1_2";
    });
    systems = [ "cl-glfw-opengl-version_1_2" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__3 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_3";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_3";
      asd = "cl-glfw-opengl-version_1_3";
    });
    systems = [ "cl-glfw-opengl-version_1_3" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__4 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_4";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_4";
      asd = "cl-glfw-opengl-version_1_4";
    });
    systems = [ "cl-glfw-opengl-version_1_4" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__1__5 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_1_5";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_1_5" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_1_5";
      asd = "cl-glfw-opengl-version_1_5";
    });
    systems = [ "cl-glfw-opengl-version_1_5" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__2__0 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_2_0";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_2_0" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_2_0";
      asd = "cl-glfw-opengl-version_2_0";
    });
    systems = [ "cl-glfw-opengl-version_2_0" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-version__2__1 = (build-asdf-system {
    pname = "cl-glfw-opengl-version_2_1";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-version_2_1" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-version_2_1";
      asd = "cl-glfw-opengl-version_2_1";
    });
    systems = [ "cl-glfw-opengl-version_2_1" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-win__phong__shading = (build-asdf-system {
    pname = "cl-glfw-opengl-win_phong_shading";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-win_phong_shading" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-win_phong_shading";
      asd = "cl-glfw-opengl-win_phong_shading";
    });
    systems = [ "cl-glfw-opengl-win_phong_shading" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-opengl-win__specular__fog = (build-asdf-system {
    pname = "cl-glfw-opengl-win_specular_fog";
    version = "20150302-git";
    asds = [ "cl-glfw-opengl-win_specular_fog" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-opengl-win_specular_fog";
      asd = "cl-glfw-opengl-win_specular_fog";
    });
    systems = [ "cl-glfw-opengl-win_specular_fog" ];
    lispLibs = [ (getAttr "cl-glfw-opengl-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw-types = (build-asdf-system {
    pname = "cl-glfw-types";
    version = "20150302-git";
    asds = [ "cl-glfw-types" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw/2015-03-02/cl-glfw-20150302-git.tgz";
      sha256 = "07zgrvv480h1xid1f50vj61d1xcrick2dqw04swac4137w9rwpj6";
      system = "cl-glfw-types";
      asd = "cl-glfw-types";
    });
    systems = [ "cl-glfw-types" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw3 = (build-asdf-system {
    pname = "cl-glfw3";
    version = "20210531-git";
    asds = [ "cl-glfw3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw3/2021-05-31/cl-glfw3-20210531-git.tgz";
      sha256 = "1wzr43nckdx4rlgxzhm1r4kfc264q969mc43y0js9ramh7l8gba5";
      system = "cl-glfw3";
      asd = "cl-glfw3";
    });
    systems = [ "cl-glfw3" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glfw3-examples = (build-asdf-system {
    pname = "cl-glfw3-examples";
    version = "20210531-git";
    asds = [ "cl-glfw3-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glfw3/2021-05-31/cl-glfw3-20210531-git.tgz";
      sha256 = "1wzr43nckdx4rlgxzhm1r4kfc264q969mc43y0js9ramh7l8gba5";
      system = "cl-glfw3-examples";
      asd = "cl-glfw3-examples";
    });
    systems = [ "cl-glfw3-examples" ];
    lispLibs = [ (getAttr "cl-glfw3" self) (getAttr "cl-opengl" self) (getAttr "trivial-main-thread" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glib = (build-asdf-system {
    pname = "cl-glib";
    version = "20230618-git";
    asds = [ "cl-glib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glib/2023-06-18/cl-glib-20230618-git.tgz";
      sha256 = "0dxa493zdp1p93cahhpp3yaggn3j3kkn90mdw99g4ld7scmiglp4";
      system = "cl-glib";
      asd = "cl-glib";
    });
    systems = [ "cl-glib" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-gobject-introspection-wrapper" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gltf = (build-asdf-system {
    pname = "cl-gltf";
    version = "20230618-git";
    asds = [ "cl-gltf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gltf/2023-06-18/cl-gltf-20230618-git.tgz";
      sha256 = "1dbp791r0z63dhyclw16q6wzh2yl0mdx3x3abmgbwdqi8vcbyrkz";
      system = "cl-gltf";
      asd = "cl-gltf";
    });
    systems = [ "cl-gltf" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "com_dot_inuoe_dot_jzon" self) (getAttr "documentation-utils" self) (getAttr "mmap" self) (getAttr "nibbles" self) (getAttr "qbase64" self) (getAttr "static-vectors" self) (getAttr "trivial-extensible-sequences" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glu = (build-asdf-system {
    pname = "cl-glu";
    version = "20191130-git";
    asds = [ "cl-glu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opengl/2019-11-30/cl-opengl-20191130-git.tgz";
      sha256 = "0mhqmll09f079pnd6mgswz9nvr6h5n27d4q7zpmm2igf1v460id7";
      system = "cl-glu";
      asd = "cl-glu";
    });
    systems = [ "cl-glu" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glut = (build-asdf-system {
    pname = "cl-glut";
    version = "20191130-git";
    asds = [ "cl-glut" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opengl/2019-11-30/cl-opengl-20191130-git.tgz";
      sha256 = "0mhqmll09f079pnd6mgswz9nvr6h5n27d4q7zpmm2igf1v460id7";
      system = "cl-glut";
      asd = "cl-glut";
    });
    systems = [ "cl-glut" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-glut-examples = (build-asdf-system {
    pname = "cl-glut-examples";
    version = "20191130-git";
    asds = [ "cl-glut-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opengl/2019-11-30/cl-opengl-20191130-git.tgz";
      sha256 = "0mhqmll09f079pnd6mgswz9nvr6h5n27d4q7zpmm2igf1v460id7";
      system = "cl-glut-examples";
      asd = "cl-glut-examples";
    });
    systems = [ "cl-glut-examples" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-glu" self) (getAttr "cl-glut" self) (getAttr "cl-opengl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gobject = (build-asdf-system {
    pname = "cl-gobject";
    version = "20230618-git";
    asds = [ "cl-gobject" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-glib/2023-06-18/cl-glib-20230618-git.tgz";
      sha256 = "0dxa493zdp1p93cahhpp3yaggn3j3kkn90mdw99g4ld7scmiglp4";
      system = "cl-gobject";
      asd = "cl-gobject";
    });
    systems = [ "cl-gobject" ];
    lispLibs = [ (getAttr "cl-gobject-introspection-wrapper" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gobject-introspection = (build-asdf-system {
    pname = "cl-gobject-introspection";
    version = "20230618-git";
    asds = [ "cl-gobject-introspection" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gobject-introspection/2023-06-18/cl-gobject-introspection-20230618-git.tgz";
      sha256 = "18n4wg93sf6cjmpcpr47bg2rd8mbm9ml9lykmjsxgvsf3nwr5vnw";
      system = "cl-gobject-introspection";
      asd = "cl-gobject-introspection";
    });
    systems = [ "cl-gobject-introspection" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "iterate" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-gobject-introspection-test = (build-asdf-system {
    pname = "cl-gobject-introspection-test";
    version = "20230618-git";
    asds = [ "cl-gobject-introspection-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gobject-introspection/2023-06-18/cl-gobject-introspection-20230618-git.tgz";
      sha256 = "18n4wg93sf6cjmpcpr47bg2rd8mbm9ml9lykmjsxgvsf3nwr5vnw";
      system = "cl-gobject-introspection-test";
      asd = "cl-gobject-introspection-test";
    });
    systems = [ "cl-gobject-introspection-test" ];
    lispLibs = [ (getAttr "cl-gobject-introspection" self) (getAttr "fiveam" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gobject-introspection-wrapper = (build-asdf-system {
    pname = "cl-gobject-introspection-wrapper";
    version = "20230618-git";
    asds = [ "cl-gobject-introspection-wrapper" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gobject-introspection-wrapper/2023-06-18/cl-gobject-introspection-wrapper-20230618-git.tgz";
      sha256 = "05np2zs5806ib6qfz7d6knyaz6llxgwvjqavl1fsz5hcga40296s";
      system = "cl-gobject-introspection-wrapper";
      asd = "cl-gobject-introspection-wrapper";
    });
    systems = [ "cl-gobject-introspection-wrapper" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-gobject-introspection" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gopher = (build-asdf-system {
    pname = "cl-gopher";
    version = "20220331-git";
    asds = [ "cl-gopher" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gopher/2022-03-31/cl-gopher-20220331-git.tgz";
      sha256 = "1ky4s33m5d0wvdaqji12pxr93qqfl5x62zjp3m4ihbdj0ws3yw2f";
      system = "cl-gopher";
      asd = "cl-gopher";
    });
    systems = [ "cl-gopher" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "quri" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gpio = (build-asdf-system {
    pname = "cl-gpio";
    version = "20211209-git";
    asds = [ "cl-gpio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gpio/2021-12-09/cl-gpio-20211209-git.tgz";
      sha256 = "0kc8vi0rb9c3952p3qmc3c23pdb6yfg21bbrg4jrgdar0k0ldz5a";
      system = "cl-gpio";
      asd = "cl-gpio";
    });
    systems = [ "cl-gpio" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-graph = (build-asdf-system {
    pname = "cl-graph";
    version = "20230214-git";
    asds = [ "cl-graph" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-graph/2023-02-14/cl-graph-20230214-git.tgz";
      sha256 = "0g1abkph9zb0m9zz6q2471ml9q9acdhwyapk8ra3bisqpwlxvpyf";
      system = "cl-graph";
      asd = "cl-graph";
    });
    systems = [ "cl-graph" ];
    lispLibs = [ (getAttr "asdf-system-connections" self) (getAttr "cl-containers" self) (getAttr "metabang-bind" self) (getAttr "metatilities-base" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-graph_plus_hu_dot_dwim_dot_graphviz = (build-asdf-system {
    pname = "cl-graph+hu.dwim.graphviz";
    version = "20230214-git";
    asds = [ "cl-graph+hu.dwim.graphviz" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-graph/2023-02-14/cl-graph-20230214-git.tgz";
      sha256 = "0g1abkph9zb0m9zz6q2471ml9q9acdhwyapk8ra3bisqpwlxvpyf";
      system = "cl-graph+hu.dwim.graphviz";
      asd = "cl-graph+hu.dwim.graphviz";
    });
    systems = [ "cl-graph+hu.dwim.graphviz" ];
    lispLibs = [ (getAttr "cl-graph" self) (getAttr "hu_dot_dwim_dot_graphviz" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-grip = (build-asdf-system {
    pname = "cl-grip";
    version = "20211020-git";
    asds = [ "cl-grip" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-grip/2021-10-20/cl-grip-20211020-git.tgz";
      sha256 = "1qplxq5082wai2blmq29a852jv5kdzwc8n9qlv0kqysjppph0hqz";
      system = "cl-grip";
      asd = "cl-grip";
    });
    systems = [ "cl-grip" ];
    lispLibs = [ (getAttr "cl-strings" self) (getAttr "local-time" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-grnm = (build-asdf-system {
    pname = "cl-grnm";
    version = "20180131-git";
    asds = [ "cl-grnm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-grnm/2018-01-31/cl-grnm-20180131-git.tgz";
      sha256 = "1hb5n37n3x2ylrghcqsia2g9a6f5wg24l659jiz4ncpi5bsv4m3s";
      system = "cl-grnm";
      asd = "cl-grnm";
    });
    systems = [ "cl-grnm" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-growl = (build-asdf-system {
    pname = "cl-growl";
    version = "20161208-git";
    asds = [ "cl-growl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-growl/2016-12-08/cl-growl-20161208-git.tgz";
      sha256 = "1qgj3sq22dznwxj1b3rw0099fsf6wgfbc63r376pab74kdnji3n6";
      system = "cl-growl";
      asd = "cl-growl";
    });
    systems = [ "cl-growl" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "ironclad" self) (getAttr "trivial-utf-8" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gss = (build-asdf-system {
    pname = "cl-gss";
    version = "20180228-git";
    asds = [ "cl-gss" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gss/2018-02-28/cl-gss-20180228-git.tgz";
      sha256 = "0zhxxn3zarird255s9i56bz0fm6dkv00mn8bbsjrhskg3wpcg4pb";
      system = "cl-gss";
      asd = "cl-gss";
    });
    systems = [ "cl-gss" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "trivial-garbage" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-gtk2-gdk = (build-asdf-system {
    pname = "cl-gtk2-gdk";
    version = "20211020-git";
    asds = [ "cl-gtk2-gdk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gtk2/2021-10-20/cl-gtk2-20211020-git.tgz";
      sha256 = "1lnrwd7s47cmksllim56mcg9l5m6jrwv6f0q1hq5lr8xpi5ix9vx";
      system = "cl-gtk2-gdk";
      asd = "cl-gtk2-gdk";
    });
    systems = [ "cl-gtk2-gdk" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-gtk2-glib" self) (getAttr "cl-gtk2-pango" self) ];
    meta = {};
  });
  cl-gtk2-glib = (build-asdf-system {
    pname = "cl-gtk2-glib";
    version = "20211020-git";
    asds = [ "cl-gtk2-glib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gtk2/2021-10-20/cl-gtk2-20211020-git.tgz";
      sha256 = "1lnrwd7s47cmksllim56mcg9l5m6jrwv6f0q1hq5lr8xpi5ix9vx";
      system = "cl-gtk2-glib";
      asd = "cl-gtk2-glib";
    });
    systems = [ "cl-gtk2-glib" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "closer-mop" self) (getAttr "iterate" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-gtk2-pango = (build-asdf-system {
    pname = "cl-gtk2-pango";
    version = "20211020-git";
    asds = [ "cl-gtk2-pango" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-gtk2/2021-10-20/cl-gtk2-20211020-git.tgz";
      sha256 = "1lnrwd7s47cmksllim56mcg9l5m6jrwv6f0q1hq5lr8xpi5ix9vx";
      system = "cl-gtk2-pango";
      asd = "cl-gtk2-pango";
    });
    systems = [ "cl-gtk2-pango" ];
    lispLibs = [ (getAttr "cl-gtk2-glib" self) (getAttr "iterate" self) ];
    meta = {};
  });
  cl-haml = (build-asdf-system {
    pname = "cl-haml";
    version = "20180228-git";
    asds = [ "cl-haml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-haml/2018-02-28/cl-haml-20180228-git.tgz";
      sha256 = "017qr3509ha2680h3c8ip5rqyfaz7v9hfjmx0pg1wrjqw8vyjyb5";
      system = "cl-haml";
      asd = "cl-haml";
    });
    systems = [ "cl-haml" ];
    lispLibs = [ (getAttr "cl-who" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-haml-test = (build-asdf-system {
    pname = "cl-haml-test";
    version = "20180228-git";
    asds = [ "cl-haml-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-haml/2018-02-28/cl-haml-20180228-git.tgz";
      sha256 = "017qr3509ha2680h3c8ip5rqyfaz7v9hfjmx0pg1wrjqw8vyjyb5";
      system = "cl-haml-test";
      asd = "cl-haml";
    });
    systems = [ "cl-haml-test" ];
    lispLibs = [ (getAttr "cl-haml" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hamt = (build-asdf-system {
    pname = "cl-hamt";
    version = "20200325-git";
    asds = [ "cl-hamt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hamt/2020-03-25/cl-hamt-20200325-git.tgz";
      sha256 = "1ycbd73ykfj5j9sdhlzamyv18qbjj6xqf7fhm4fa0nsyr6sr3rf5";
      system = "cl-hamt";
      asd = "cl-hamt";
    });
    systems = [ "cl-hamt" ];
    lispLibs = [ (getAttr "cl-murmurhash" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hamt-examples = (build-asdf-system {
    pname = "cl-hamt-examples";
    version = "20200325-git";
    asds = [ "cl-hamt-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hamt/2020-03-25/cl-hamt-20200325-git.tgz";
      sha256 = "1ycbd73ykfj5j9sdhlzamyv18qbjj6xqf7fhm4fa0nsyr6sr3rf5";
      system = "cl-hamt-examples";
      asd = "cl-hamt-examples";
    });
    systems = [ "cl-hamt-examples" ];
    lispLibs = [ (getAttr "cl-hamt" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hamt-test = (build-asdf-system {
    pname = "cl-hamt-test";
    version = "20200325-git";
    asds = [ "cl-hamt-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hamt/2020-03-25/cl-hamt-20200325-git.tgz";
      sha256 = "1ycbd73ykfj5j9sdhlzamyv18qbjj6xqf7fhm4fa0nsyr6sr3rf5";
      system = "cl-hamt-test";
      asd = "cl-hamt-test";
    });
    systems = [ "cl-hamt-test" ];
    lispLibs = [ (getAttr "cl-hamt" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hash-table-destructuring = (build-asdf-system {
    pname = "cl-hash-table-destructuring";
    version = "20160531-git";
    asds = [ "cl-hash-table-destructuring" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hash-table-destructuring/2016-05-31/cl-hash-table-destructuring-20160531-git.tgz";
      sha256 = "0za8jlqfvsilmnidk429509vbdd18w7ykcycni411pjpz0lxrh1v";
      system = "cl-hash-table-destructuring";
      asd = "cl-hash-table-destructuring";
    });
    systems = [ "cl-hash-table-destructuring" ];
    lispLibs = [ (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hash-table-destructuring-test = (build-asdf-system {
    pname = "cl-hash-table-destructuring-test";
    version = "20160531-git";
    asds = [ "cl-hash-table-destructuring-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hash-table-destructuring/2016-05-31/cl-hash-table-destructuring-20160531-git.tgz";
      sha256 = "0za8jlqfvsilmnidk429509vbdd18w7ykcycni411pjpz0lxrh1v";
      system = "cl-hash-table-destructuring-test";
      asd = "cl-hash-table-destructuring";
    });
    systems = [ "cl-hash-table-destructuring-test" ];
    lispLibs = [ (getAttr "cl-hash-table-destructuring" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hash-util = (build-asdf-system {
    pname = "cl-hash-util";
    version = "20190107-git";
    asds = [ "cl-hash-util" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hash-util/2019-01-07/cl-hash-util-20190107-git.tgz";
      sha256 = "0dnd0405d81w25cqq4g8gk2r5wm03cis965c1pmb2f5p4ifwq87a";
      system = "cl-hash-util";
      asd = "cl-hash-util";
    });
    systems = [ "cl-hash-util" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hash-util-test = (build-asdf-system {
    pname = "cl-hash-util-test";
    version = "20190107-git";
    asds = [ "cl-hash-util-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hash-util/2019-01-07/cl-hash-util-20190107-git.tgz";
      sha256 = "0dnd0405d81w25cqq4g8gk2r5wm03cis965c1pmb2f5p4ifwq87a";
      system = "cl-hash-util-test";
      asd = "cl-hash-util-test";
    });
    systems = [ "cl-hash-util-test" ];
    lispLibs = [ (getAttr "cl-hash-util" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-heap = (build-asdf-system {
    pname = "cl-heap";
    version = "0.1.6";
    asds = [ "cl-heap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-heap/2013-03-12/cl-heap-0.1.6.tgz";
      sha256 = "01bss182x9i167lfv0lr8ylavk2m42s84vz6629kspgjhczm52w7";
      system = "cl-heap";
      asd = "cl-heap";
    });
    systems = [ "cl-heap" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-heap-tests = (build-asdf-system {
    pname = "cl-heap-tests";
    version = "0.1.6";
    asds = [ "cl-heap-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-heap/2013-03-12/cl-heap-0.1.6.tgz";
      sha256 = "01bss182x9i167lfv0lr8ylavk2m42s84vz6629kspgjhczm52w7";
      system = "cl-heap-tests";
      asd = "cl-heap-tests";
    });
    systems = [ "cl-heap-tests" ];
    lispLibs = [ (getAttr "cl-heap" self) (getAttr "xlunit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-heredoc = (build-asdf-system {
    pname = "cl-heredoc";
    version = "20220707-git";
    asds = [ "cl-heredoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-heredoc/2022-07-07/cl-heredoc-20220707-git.tgz";
      sha256 = "0hj9y6drd93nwcbmwwhnc30flm48ppw4rhfgfyqfc02fq2wnc83z";
      system = "cl-heredoc";
      asd = "cl-heredoc";
    });
    systems = [ "cl-heredoc" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-heredoc-test = (build-asdf-system {
    pname = "cl-heredoc-test";
    version = "20220707-git";
    asds = [ "cl-heredoc-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-heredoc/2022-07-07/cl-heredoc-20220707-git.tgz";
      sha256 = "0hj9y6drd93nwcbmwwhnc30flm48ppw4rhfgfyqfc02fq2wnc83z";
      system = "cl-heredoc-test";
      asd = "cl-heredoc-test";
    });
    systems = [ "cl-heredoc-test" ];
    lispLibs = [ (getAttr "cl-heredoc" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hooks = (build-asdf-system {
    pname = "cl-hooks";
    version = "20181210-git";
    asds = [ "cl-hooks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/architecture.hooks/2018-12-10/architecture.hooks-20181210-git.tgz";
      sha256 = "0bg3l0a28lw5gqqjp6p6b5nhwqk46sgkb7184w5qbfngw1hk8x9y";
      system = "cl-hooks";
      asd = "cl-hooks";
    });
    systems = [ "cl-hooks" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "let-plus" self) (getAttr "trivial-garbage" self) ];
    meta = {};
  });
  cl-html-diff = (build-asdf-system {
    pname = "cl-html-diff";
    version = "20130128-git";
    asds = [ "cl-html-diff" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html-diff/2013-01-28/cl-html-diff-20130128-git.tgz";
      sha256 = "1varnijivzd4jpimn1cz8p5ks713zzha5cgl4vmb0xr8ahravwzb";
      system = "cl-html-diff";
      asd = "cl-html-diff";
    });
    systems = [ "cl-html-diff" ];
    lispLibs = [ (getAttr "cl-difflib" self) ];
    meta = {};
  });
  cl-html-parse = (build-asdf-system {
    pname = "cl-html-parse";
    version = "20200925-git";
    asds = [ "cl-html-parse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html-parse/2020-09-25/cl-html-parse-20200925-git.tgz";
      sha256 = "0d78slyqw6zshh72ppmxc85xdnd0jfhaqkzrf1cn7yjxl6h4lp7s";
      system = "cl-html-parse";
      asd = "cl-html-parse";
    });
    systems = [ "cl-html-parse" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-html-readme = (build-asdf-system {
    pname = "cl-html-readme";
    version = "quicklisp-current-release-fa304a63-git";
    asds = [ "cl-html-readme" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html-readme/2021-02-28/cl-html-readme-quicklisp-current-release-fa304a63-git.tgz";
      sha256 = "01z2ykfhg7wx7sz4kp1c6cj9ffbpppnfgfd2jpizd7f5id2wi3cb";
      system = "cl-html-readme";
      asd = "cl-html-readme";
    });
    systems = [ "cl-html-readme" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-html5-parser = (build-asdf-system {
    pname = "cl-html5-parser";
    version = "20190521-git";
    asds = [ "cl-html5-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html5-parser/2019-05-21/cl-html5-parser-20190521-git.tgz";
      sha256 = "04if61wigylsmn996rbfl8ylsd0d9hzdmg7p2wiglncibjzcl5k9";
      system = "cl-html5-parser";
      asd = "cl-html5-parser";
    });
    systems = [ "cl-html5-parser" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "string-case" self) ];
    meta = {};
  });
  cl-html5-parser-cxml = (build-asdf-system {
    pname = "cl-html5-parser-cxml";
    version = "20190521-git";
    asds = [ "cl-html5-parser-cxml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html5-parser/2019-05-21/cl-html5-parser-20190521-git.tgz";
      sha256 = "04if61wigylsmn996rbfl8ylsd0d9hzdmg7p2wiglncibjzcl5k9";
      system = "cl-html5-parser-cxml";
      asd = "cl-html5-parser-cxml";
    });
    systems = [ "cl-html5-parser-cxml" ];
    lispLibs = [ (getAttr "cl-html5-parser" self) (getAttr "cxml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-html5-parser-tests = (build-asdf-system {
    pname = "cl-html5-parser-tests";
    version = "20190521-git";
    asds = [ "cl-html5-parser-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-html5-parser/2019-05-21/cl-html5-parser-20190521-git.tgz";
      sha256 = "04if61wigylsmn996rbfl8ylsd0d9hzdmg7p2wiglncibjzcl5k9";
      system = "cl-html5-parser-tests";
      asd = "cl-html5-parser-tests";
    });
    systems = [ "cl-html5-parser-tests" ];
    lispLibs = [ (getAttr "cl-html5-parser" self) (getAttr "json-streams" self) (getAttr "split-sequence" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-htmlprag = (build-asdf-system {
    pname = "cl-htmlprag";
    version = "20160628-git";
    asds = [ "cl-htmlprag" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-htmlprag/2016-06-28/cl-htmlprag-20160628-git.tgz";
      sha256 = "1akfy9rldx5a2h34vf7y02pj2j7b5anbxja53m41ism4vklgqg1c";
      system = "cl-htmlprag";
      asd = "cl-htmlprag";
    });
    systems = [ "cl-htmlprag" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "optima" self) (getAttr "parse-number" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-httpsqs = (build-asdf-system {
    pname = "cl-httpsqs";
    version = "20180228-git";
    asds = [ "cl-httpsqs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-httpsqs/2018-02-28/cl-httpsqs-20180228-git.tgz";
      sha256 = "14nhr03lm8012crczjpgsmf0ydipqf3kggayshm7w72vkyf0haj7";
      system = "cl-httpsqs";
      asd = "cl-httpsqs";
    });
    systems = [ "cl-httpsqs" ];
    lispLibs = [ (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-hue = (build-asdf-system {
    pname = "cl-hue";
    version = "20150113-git";
    asds = [ "cl-hue" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-hue/2015-01-13/cl-hue-20150113-git.tgz";
      sha256 = "0d2qv60pih1xmk0zzbdwcsyk8k9abjzilcmhz3jdicinl8jinfr4";
      system = "cl-hue";
      asd = "cl-hue";
    });
    systems = [ "cl-hue" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "drakma" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-i18n = (build-asdf-system {
    pname = "cl-i18n";
    version = "20230618-git";
    asds = [ "cl-i18n" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-i18n/2023-06-18/cl-i18n-20230618-git.tgz";
      sha256 = "17hglrrwfr28ig7bqkrlkcclcmg4zssi44qra8lsdbkf36imqj83";
      system = "cl-i18n";
      asd = "cl-i18n";
    });
    systems = [ "cl-i18n" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-ppcre-unicode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-id3 = (build-asdf-system {
    pname = "cl-id3";
    version = "20230618-git";
    asds = [ "cl-id3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-id3/2023-06-18/cl-id3-20230618-git.tgz";
      sha256 = "0p5rcxy6zy8jq673yphbq5dq0g28vx9g7kfklfhicg2blpzy2yf5";
      system = "cl-id3";
      asd = "cl-id3";
    });
    systems = [ "cl-id3" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ilu = (build-asdf-system {
    pname = "cl-ilu";
    version = "20150302-git";
    asds = [ "cl-ilu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-devil/2015-03-02/cl-devil-20150302-git.tgz";
      sha256 = "1qdjb7xwzjkv99s8q0834lfdq4ch5j2ymrmqsvwzhg47ys17pvvf";
      system = "cl-ilu";
      asd = "cl-ilu";
    });
    systems = [ "cl-ilu" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-devil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ilut = (build-asdf-system {
    pname = "cl-ilut";
    version = "20150302-git";
    asds = [ "cl-ilut" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-devil/2015-03-02/cl-devil-20150302-git.tgz";
      sha256 = "1qdjb7xwzjkv99s8q0834lfdq4ch5j2ymrmqsvwzhg47ys17pvvf";
      system = "cl-ilut";
      asd = "cl-ilut";
    });
    systems = [ "cl-ilut" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-devil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-incognia = (build-asdf-system {
    pname = "cl-incognia";
    version = "20211230-git";
    asds = [ "cl-incognia" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-incognia/2021-12-30/cl-incognia-20211230-git.tgz";
      sha256 = "0c5v7vqh26vg4mzzz7rkq3r29ygj2q4fw6v56pi79bbszyklfs21";
      system = "cl-incognia";
      asd = "cl-incognia";
    });
    systems = [ "cl-incognia" ];
    lispLibs = [ (getAttr "dexador" self) (getAttr "jonathan" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-indentify = (build-asdf-system {
    pname = "cl-indentify";
    version = "20230214-git";
    asds = [ "cl-indentify" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-indentify/2023-02-14/cl-indentify-20230214-git.tgz";
      sha256 = "1np7b3mh3wd5dv7nvwmjl5rgy7m0qf0fx61s04yazlh46k3d0nxd";
      system = "cl-indentify";
      asd = "cl-indentify";
    });
    systems = [ "cl-indentify" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-inflector = (build-asdf-system {
    pname = "cl-inflector";
    version = "20150113-git";
    asds = [ "cl-inflector" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-inflector/2015-01-13/cl-inflector-20150113-git.tgz";
      sha256 = "1xwwlhik1la4fp984qnx2dqq24v012qv4x0y49sngfpwg7n0ya7y";
      system = "cl-inflector";
      asd = "cl-inflector";
    });
    systems = [ "cl-inflector" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-inflector-test = (build-asdf-system {
    pname = "cl-inflector-test";
    version = "20150113-git";
    asds = [ "cl-inflector-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-inflector/2015-01-13/cl-inflector-20150113-git.tgz";
      sha256 = "1xwwlhik1la4fp984qnx2dqq24v012qv4x0y49sngfpwg7n0ya7y";
      system = "cl-inflector-test";
      asd = "cl-inflector";
    });
    systems = [ "cl-inflector-test" ];
    lispLibs = [ (getAttr "cl-inflector" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-influxdb = (build-asdf-system {
    pname = "cl-influxdb";
    version = "20180131-git";
    asds = [ "cl-influxdb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-influxdb/2018-01-31/cl-influxdb-20180131-git.tgz";
      sha256 = "0fqnsdw6x79qsvw7l6xp1gxgzcj6jwpa4mn0z2gbbipff4g7k527";
      system = "cl-influxdb";
      asd = "cl-influxdb";
    });
    systems = [ "cl-influxdb" ];
    lispLibs = [ (getAttr "cl-annot" self) (getAttr "cl-json" self) (getAttr "do-urlencode" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-info = (build-asdf-system {
    pname = "cl-info";
    version = "20221106-git";
    asds = [ "cl-info" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-info/2022-11-06/cl-info-20221106-git.tgz";
      sha256 = "1mg58n6qizssm8wqxnxgkrxaabmjzbrfjh9qld69y5z60zrybg1f";
      system = "cl-info";
      asd = "cl-info";
    });
    systems = [ "cl-info" ];
    lispLibs = [ (getAttr "_40ants-doc" self) (getAttr "docs-config" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-info-test = (build-asdf-system {
    pname = "cl-info-test";
    version = "20221106-git";
    asds = [ "cl-info-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-info/2022-11-06/cl-info-20221106-git.tgz";
      sha256 = "1mg58n6qizssm8wqxnxgkrxaabmjzbrfjh9qld69y5z60zrybg1f";
      system = "cl-info-test";
      asd = "cl-info-test";
    });
    systems = [ "cl-info-test" ];
    lispLibs = [ (getAttr "cl-info" self) (getAttr "hamcrest" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ini = (build-asdf-system {
    pname = "cl-ini";
    version = "20201220-git";
    asds = [ "cl-ini" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ini/2020-12-20/cl-ini-20201220-git.tgz";
      sha256 = "12vy3gspqn0wmkyz5id1xrgv1scgb16m7pkvmbmi19vlpj2iyq7p";
      system = "cl-ini";
      asd = "cl-ini";
    });
    systems = [ "cl-ini" ];
    lispLibs = [ (getAttr "str" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ini-test = (build-asdf-system {
    pname = "cl-ini-test";
    version = "20201220-git";
    asds = [ "cl-ini-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ini/2020-12-20/cl-ini-20201220-git.tgz";
      sha256 = "12vy3gspqn0wmkyz5id1xrgv1scgb16m7pkvmbmi19vlpj2iyq7p";
      system = "cl-ini-test";
      asd = "cl-ini-test";
    });
    systems = [ "cl-ini-test" ];
    lispLibs = [ (getAttr "cl-ini" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-inotify = (build-asdf-system {
    pname = "cl-inotify";
    version = "20220707-git";
    asds = [ "cl-inotify" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-inotify/2022-07-07/cl-inotify-20220707-git.tgz";
      sha256 = "0d3bvp5lqnddzhk1w9yyli03njbkhc8d129a058g0j49kgd47c7v";
      system = "cl-inotify";
      asd = "cl-inotify";
    });
    systems = [ "cl-inotify" ];
    lispLibs = [ (getAttr "binary-types" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "iolib" self) (getAttr "iolib_dot_asdf" self) (getAttr "iolib_dot_base" self) (getAttr "iolib_dot_conf" self) (getAttr "osicat" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-inotify-tests = (build-asdf-system {
    pname = "cl-inotify-tests";
    version = "20220707-git";
    asds = [ "cl-inotify-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-inotify/2022-07-07/cl-inotify-20220707-git.tgz";
      sha256 = "0d3bvp5lqnddzhk1w9yyli03njbkhc8d129a058g0j49kgd47c7v";
      system = "cl-inotify-tests";
      asd = "cl-inotify-tests";
    });
    systems = [ "cl-inotify-tests" ];
    lispLibs = [ (getAttr "cl-inotify" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-intbytes = (build-asdf-system {
    pname = "cl-intbytes";
    version = "20150923-git";
    asds = [ "cl-intbytes" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-intbytes/2015-09-23/cl-intbytes-20150923-git.tgz";
      sha256 = "0chwfda7pi8mrgwj31li7f0x0hr5yrp4csiq8hwkgd4c1ag1z9fx";
      system = "cl-intbytes";
      asd = "cl-intbytes";
    });
    systems = [ "cl-intbytes" ];
    lispLibs = [ (getAttr "fast-io" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-intbytes-test = (build-asdf-system {
    pname = "cl-intbytes-test";
    version = "20150923-git";
    asds = [ "cl-intbytes-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-intbytes/2015-09-23/cl-intbytes-20150923-git.tgz";
      sha256 = "0chwfda7pi8mrgwj31li7f0x0hr5yrp4csiq8hwkgd4c1ag1z9fx";
      system = "cl-intbytes-test";
      asd = "cl-intbytes-test";
    });
    systems = [ "cl-intbytes-test" ];
    lispLibs = [ (getAttr "cl-intbytes" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-interpol = (build-asdf-system {
    pname = "cl-interpol";
    version = "20221106-git";
    asds = [ "cl-interpol" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-interpol/2022-11-06/cl-interpol-20221106-git.tgz";
      sha256 = "1nkjn8byyfdxhi84rbpqs87bb5m478lvphfgxqqv0q37rn75c946";
      system = "cl-interpol";
      asd = "cl-interpol";
    });
    systems = [ "cl-interpol" ];
    lispLibs = [ (getAttr "cl-unicode" self) (getAttr "named-readtables" self) ];
    meta = {};
  });
  cl-interval = (build-asdf-system {
    pname = "cl-interval";
    version = "20200715-git";
    asds = [ "cl-interval" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-interval/2020-07-15/cl-interval-20200715-git.tgz";
      sha256 = "1425l6xmrqadjqgqb5qasisf14pbr6zpj30bpxfv8hhnxs5njq4p";
      system = "cl-interval";
      asd = "cl-interval";
    });
    systems = [ "cl-interval" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-interval-docs = (build-asdf-system {
    pname = "cl-interval-docs";
    version = "20200715-git";
    asds = [ "cl-interval-docs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-interval/2020-07-15/cl-interval-20200715-git.tgz";
      sha256 = "1425l6xmrqadjqgqb5qasisf14pbr6zpj30bpxfv8hhnxs5njq4p";
      system = "cl-interval-docs";
      asd = "cl-interval-docs";
    });
    systems = [ "cl-interval-docs" ];
    lispLibs = [ (getAttr "cl-gendoc" self) (getAttr "cl-interval" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ipfs-api2 = (build-asdf-system {
    pname = "cl-ipfs-api2";
    version = "20210630-git";
    asds = [ "cl-ipfs-api2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ipfs-api2/2021-06-30/cl-ipfs-api2-20210630-git.tgz";
      sha256 = "1h0csxk4db1hid793mk5kz3nbjyl7z4ic1zk2wy46k1vz5lnnsph";
      system = "cl-ipfs-api2";
      asd = "cl-ipfs-api2";
    });
    systems = [ "cl-ipfs-api2" ];
    lispLibs = [ (getAttr "arnesi" self) (getAttr "drakma" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-irc = (build-asdf-system {
    pname = "cl-irc";
    version = "0.9.2";
    asds = [ "cl-irc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-irc/2015-09-23/cl-irc-0.9.2.tgz";
      sha256 = "15h3ram8b6vyg4718ad2m92xgilda2x3zmkzbjnijk69kkqsq01r";
      system = "cl-irc";
      asd = "cl-irc";
    });
    systems = [ "cl-irc" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-irc-test = (build-asdf-system {
    pname = "cl-irc-test";
    version = "0.9.2";
    asds = [ "cl-irc-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-irc/2015-09-23/cl-irc-0.9.2.tgz";
      sha256 = "15h3ram8b6vyg4718ad2m92xgilda2x3zmkzbjnijk69kkqsq01r";
      system = "cl-irc-test";
      asd = "cl-irc-test";
    });
    systems = [ "cl-irc-test" ];
    lispLibs = [ (getAttr "cl-irc" self) (getAttr "rt" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-irregsexp = (build-asdf-system {
    pname = "cl-irregsexp";
    version = "20160825-git";
    asds = [ "cl-irregsexp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-irregsexp/2016-08-25/cl-irregsexp-20160825-git.tgz";
      sha256 = "09pf3jlqskcs32shbj9q3m0zww5pxyrizbvk2nxiwwnbl1rdb406";
      system = "cl-irregsexp";
      asd = "cl-irregsexp";
    });
    systems = [ "cl-irregsexp" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-isaac = (build-asdf-system {
    pname = "cl-isaac";
    version = "20221106-git";
    asds = [ "cl-isaac" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-isaac/2022-11-06/cl-isaac-20221106-git.tgz";
      sha256 = "0ig1mf8iridfr7vci9gy499194h0hda0xki5s6g0y04g85ibnpw9";
      system = "cl-isaac";
      asd = "cl-isaac";
    });
    systems = [ "cl-isaac" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-iterative = (build-asdf-system {
    pname = "cl-iterative";
    version = "20160318-git";
    asds = [ "cl-iterative" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-iterative/2016-03-18/cl-iterative-20160318-git.tgz";
      sha256 = "01h2fs7nq2wivjwh9swsmfdvsdmd7j9dvzgrq0ijbq456zm8vilq";
      system = "cl-iterative";
      asd = "cl-iterative";
    });
    systems = [ "cl-iterative" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "optima" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-iterative-tests = (build-asdf-system {
    pname = "cl-iterative-tests";
    version = "20160318-git";
    asds = [ "cl-iterative-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-iterative/2016-03-18/cl-iterative-20160318-git.tgz";
      sha256 = "01h2fs7nq2wivjwh9swsmfdvsdmd7j9dvzgrq0ijbq456zm8vilq";
      system = "cl-iterative-tests";
      asd = "cl-iterative-tests";
    });
    systems = [ "cl-iterative-tests" ];
    lispLibs = [ (getAttr "cl-iterative" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-itertools = (build-asdf-system {
    pname = "cl-itertools";
    version = "20160421-git";
    asds = [ "cl-itertools" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-itertools/2016-04-21/cl-itertools-20160421-git.tgz";
      sha256 = "0m1g7nxqnz03bcj46skcr2d50pi3lb4hwizna5d4mvl5hk4zwbxr";
      system = "cl-itertools";
      asd = "cl-itertools";
    });
    systems = [ "cl-itertools" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-coroutine" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-itertools-tests = (build-asdf-system {
    pname = "cl-itertools-tests";
    version = "20160421-git";
    asds = [ "cl-itertools-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-itertools/2016-04-21/cl-itertools-20160421-git.tgz";
      sha256 = "0m1g7nxqnz03bcj46skcr2d50pi3lb4hwizna5d4mvl5hk4zwbxr";
      system = "cl-itertools-tests";
      asd = "cl-itertools";
    });
    systems = [ "cl-itertools-tests" ];
    lispLibs = [ (getAttr "cl-itertools" self) (getAttr "fiveam" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-jpeg = (build-asdf-system {
    pname = "cl-jpeg";
    version = "20230214-git";
    asds = [ "cl-jpeg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-jpeg/2023-02-14/cl-jpeg-20230214-git.tgz";
      sha256 = "1xl1id4k1bdw6hf24ndkzr6nxi30yw7xlr1fhfmxnwjqwy5hcq14";
      system = "cl-jpeg";
      asd = "cl-jpeg";
    });
    systems = [ "cl-jpeg" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-js = (build-asdf-system {
    pname = "cl-js";
    version = "20230214-git";
    asds = [ "cl-js" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/js/2023-02-14/js-20230214-git.tgz";
      sha256 = "1bf2p506zcmsqmfm5lamvxwqzcs2p8y5rf63i3s8wi46nkgqr0m7";
      system = "cl-js";
      asd = "cl-js";
    });
    systems = [ "cl-js" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "parse-js" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-jschema = (build-asdf-system {
    pname = "cl-jschema";
    version = "v1.1.1";
    asds = [ "cl-jschema" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-jschema/2023-06-18/cl-jschema-v1.1.1.tgz";
      sha256 = "0awc7hy07sg4h8k58xxxy578a5qklpkj3slslp7ghfzfdbi7nz11";
      system = "cl-jschema";
      asd = "cl-jschema";
    });
    systems = [ "cl-jschema" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "com_dot_inuoe_dot_jzon" self) (getAttr "puri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-json = (build-asdf-system {
    pname = "cl-json";
    version = "20220707-git";
    asds = [ "cl-json" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-json/2022-07-07/cl-json-20220707-git.tgz";
      sha256 = "12vakz47d1i7pywgb9cm2364fzykidc9m7l7b6n9lx0gn2qx9ar5";
      system = "cl-json";
      asd = "cl-json";
    });
    systems = [ "cl-json" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-json-helper = (build-asdf-system {
    pname = "cl-json-helper";
    version = "20181210-git";
    asds = [ "cl-json-helper" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-json-helper/2018-12-10/cl-json-helper-20181210-git.tgz";
      sha256 = "1dhv5lh514m7bvl77xjhb4ky7nf4bskgpld7rqg3rq24k4y0c79a";
      system = "cl-json-helper";
      asd = "cl-json-helper";
    });
    systems = [ "cl-json-helper" ];
    lispLibs = [ (getAttr "cl-json" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-json-pointer = (build-asdf-system {
    pname = "cl-json-pointer";
    version = "20221106-git";
    asds = [ "cl-json-pointer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-json-pointer/2022-11-06/cl-json-pointer-20221106-git.tgz";
      sha256 = "0b7a755wc2ghsd1pv7d32877b21h4nssp41xs017anbmj55czb2h";
      system = "cl-json-pointer";
      asd = "cl-json-pointer";
    });
    systems = [ "cl-json-pointer" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) (getAttr "st-json" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-json-schema = (build-asdf-system {
    pname = "cl-json-schema";
    version = "20210228-git";
    asds = [ "cl-json-schema" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-json-schema/2021-02-28/cl-json-schema-20210228-git.tgz";
      sha256 = "1c90c9j6d2b02zyyqd07200waqa4saq0svps7vfy5a3lxp9vag9i";
      system = "cl-json-schema";
      asd = "cl-json-schema";
    });
    systems = [ "cl-json-schema" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "trivial-do" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-json-schema-tests = (build-asdf-system {
    pname = "cl-json-schema-tests";
    version = "20210228-git";
    asds = [ "cl-json-schema-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-json-schema/2021-02-28/cl-json-schema-20210228-git.tgz";
      sha256 = "1c90c9j6d2b02zyyqd07200waqa4saq0svps7vfy5a3lxp9vag9i";
      system = "cl-json-schema-tests";
      asd = "cl-json-schema-tests";
    });
    systems = [ "cl-json-schema-tests" ];
    lispLibs = [ (getAttr "cl-json-schema" self) (getAttr "cl-ppcre" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-jsonl = (build-asdf-system {
    pname = "cl-jsonl";
    version = "20230618-git";
    asds = [ "cl-jsonl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-jsonl/2023-06-18/cl-jsonl-20230618-git.tgz";
      sha256 = "0q6yrlpa3lyzaia12fnvr3blpm63lb88by63kdhb7sp1dl3h1in6";
      system = "cl-jsonl";
      asd = "cl-jsonl";
    });
    systems = [ "cl-jsonl" ];
    lispLibs = [ (getAttr "gtwiwtg" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-jsx = (build-asdf-system {
    pname = "cl-jsx";
    version = "20160208-git";
    asds = [ "cl-jsx" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-jsx/2016-02-08/cl-jsx-20160208-git.tgz";
      sha256 = "1vkqs65sqnfkfka2p93ibfrgg3wps3qhlcgcd8j40h0bv3phcjp7";
      system = "cl-jsx";
      asd = "cl-jsx";
    });
    systems = [ "cl-jsx" ];
    lispLibs = [ (getAttr "cl-who" self) (getAttr "esrap" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-jsx-test = (build-asdf-system {
    pname = "cl-jsx-test";
    version = "20160208-git";
    asds = [ "cl-jsx-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-jsx/2016-02-08/cl-jsx-20160208-git.tgz";
      sha256 = "1vkqs65sqnfkfka2p93ibfrgg3wps3qhlcgcd8j40h0bv3phcjp7";
      system = "cl-jsx-test";
      asd = "cl-jsx-test";
    });
    systems = [ "cl-jsx-test" ];
    lispLibs = [ (getAttr "cl-jsx" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-junit-xml = (build-asdf-system {
    pname = "cl-junit-xml";
    version = "20150113-git";
    asds = [ "cl-junit-xml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-junit-xml/2015-01-13/cl-junit-xml-20150113-git.tgz";
      sha256 = "1ssrcgw5bhfsb5lk7jb8jyz77mj6sg23wc3gmnw747iqvpikwakr";
      system = "cl-junit-xml";
      asd = "cl-junit-xml";
    });
    systems = [ "cl-junit-xml" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cxml" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-junit-xml_dot_lisp-unit = (build-asdf-system {
    pname = "cl-junit-xml.lisp-unit";
    version = "20150113-git";
    asds = [ "cl-junit-xml.lisp-unit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-junit-xml/2015-01-13/cl-junit-xml-20150113-git.tgz";
      sha256 = "1ssrcgw5bhfsb5lk7jb8jyz77mj6sg23wc3gmnw747iqvpikwakr";
      system = "cl-junit-xml.lisp-unit";
      asd = "cl-junit-xml.lisp-unit";
    });
    systems = [ "cl-junit-xml.lisp-unit" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-junit-xml" self) (getAttr "cl-ppcre" self) (getAttr "iterate" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-junit-xml_dot_lisp-unit2 = (build-asdf-system {
    pname = "cl-junit-xml.lisp-unit2";
    version = "20150113-git";
    asds = [ "cl-junit-xml.lisp-unit2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-junit-xml/2015-01-13/cl-junit-xml-20150113-git.tgz";
      sha256 = "1ssrcgw5bhfsb5lk7jb8jyz77mj6sg23wc3gmnw747iqvpikwakr";
      system = "cl-junit-xml.lisp-unit2";
      asd = "cl-junit-xml.lisp-unit2";
    });
    systems = [ "cl-junit-xml.lisp-unit2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-junit-xml" self) (getAttr "cl-ppcre" self) (getAttr "iterate" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-junit-xml_dot_test = (build-asdf-system {
    pname = "cl-junit-xml.test";
    version = "20150113-git";
    asds = [ "cl-junit-xml.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-junit-xml/2015-01-13/cl-junit-xml-20150113-git.tgz";
      sha256 = "1ssrcgw5bhfsb5lk7jb8jyz77mj6sg23wc3gmnw747iqvpikwakr";
      system = "cl-junit-xml.test";
      asd = "cl-junit-xml";
    });
    systems = [ "cl-junit-xml.test" ];
    lispLibs = [ (getAttr "cl-junit-xml" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-k8055 = (build-asdf-system {
    pname = "cl-k8055";
    version = "20190710-git";
    asds = [ "cl-k8055" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-k8055/2019-07-10/cl-k8055-20190710-git.tgz";
      sha256 = "069j5hrcpcm9vlh2f0myqwggp30inycxn61ivi1ppa97f8f1rrig";
      system = "cl-k8055";
      asd = "cl-k8055";
    });
    systems = [ "cl-k8055" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-kanren = (build-asdf-system {
    pname = "cl-kanren";
    version = "20191007-git";
    asds = [ "cl-kanren" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-kanren/2019-10-07/cl-kanren-20191007-git.tgz";
      sha256 = "1r0qzvs92d7kgl83fx8c27jmsh17agr7jpb1nmmc56phjvq0z7ll";
      system = "cl-kanren";
      asd = "cl-kanren";
    });
    systems = [ "cl-kanren" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-kanren-test = (build-asdf-system {
    pname = "cl-kanren-test";
    version = "20191007-git";
    asds = [ "cl-kanren-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-kanren/2019-10-07/cl-kanren-20191007-git.tgz";
      sha256 = "1r0qzvs92d7kgl83fx8c27jmsh17agr7jpb1nmmc56phjvq0z7ll";
      system = "cl-kanren-test";
      asd = "cl-kanren-test";
    });
    systems = [ "cl-kanren-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-kanren" self) (getAttr "clunit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-keycloak = (build-asdf-system {
    pname = "cl-keycloak";
    version = "20190710-git";
    asds = [ "cl-keycloak" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-keycloak/2019-07-10/cl-keycloak-20190710-git.tgz";
      sha256 = "052x10xj951061xa80kp1ziwrr8hskjsr7q2ni1d1ab26rkmhb9q";
      system = "cl-keycloak";
      asd = "cl-keycloak";
    });
    systems = [ "cl-keycloak" ];
    lispLibs = [ (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-kraken = (build-asdf-system {
    pname = "cl-kraken";
    version = "20220331-git";
    asds = [ "cl-kraken" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-kraken/2022-03-31/cl-kraken-20220331-git.tgz";
      sha256 = "07a9a7yqii0gsiaf4r6jfz2nb2m8766rv4acqcdjm8zmsllwx7jz";
      system = "cl-kraken";
      asd = "cl-kraken";
    });
    systems = [ "cl-kraken" ];
    lispLibs = [ (getAttr "cl-base64" self) (getAttr "dexador" self) (getAttr "ironclad" self) (getAttr "jsown" self) (getAttr "quri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ksuid = (build-asdf-system {
    pname = "cl-ksuid";
    version = "20170830-git";
    asds = [ "cl-ksuid" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ksuid/2017-08-30/cl-ksuid-20170830-git.tgz";
      sha256 = "142fr8l6aa6wxnjxv04f61hy9504cx9x1r10byhmj475s5pfr6gl";
      system = "cl-ksuid";
      asd = "cl-ksuid";
    });
    systems = [ "cl-ksuid" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "ironclad" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ksuid-test = (build-asdf-system {
    pname = "cl-ksuid-test";
    version = "20170830-git";
    asds = [ "cl-ksuid-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ksuid/2017-08-30/cl-ksuid-20170830-git.tgz";
      sha256 = "142fr8l6aa6wxnjxv04f61hy9504cx9x1r10byhmj475s5pfr6gl";
      system = "cl-ksuid-test";
      asd = "cl-ksuid";
    });
    systems = [ "cl-ksuid-test" ];
    lispLibs = [ (getAttr "cl-ksuid" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ktx = (build-asdf-system {
    pname = "cl-ktx";
    version = "20230618-git";
    asds = [ "cl-ktx" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ktx/2023-06-18/cl-ktx-20230618-git.tgz";
      sha256 = "0zd3xxcxp431kacaa6axnlg8ar7nbcndxpz340b7w9782rqfvvnx";
      system = "cl-ktx";
      asd = "cl-ktx";
    });
    systems = [ "cl-ktx" ];
    lispLibs = [ (getAttr "binary-structures" self) (getAttr "cl-opengl" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-kyoto-cabinet = (build-asdf-system {
    pname = "cl-kyoto-cabinet";
    version = "20191130-git";
    asds = [ "cl-kyoto-cabinet" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-kyoto-cabinet/2019-11-30/cl-kyoto-cabinet-20191130-git.tgz";
      sha256 = "0ayp87ggayaf8d1dblpv90a87fmgh9vhhcah3ch6jvcw6zzb9lcr";
      system = "cl-kyoto-cabinet";
      asd = "cl-kyoto-cabinet";
    });
    systems = [ "cl-kyoto-cabinet" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-l10n = (build-asdf-system {
    pname = "cl-l10n";
    version = "20211209-git";
    asds = [ "cl-l10n" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-l10n/2021-12-09/cl-l10n-20211209-git.tgz";
      sha256 = "10yknvjcbgc82a6k6yzj2diki2z2s04q5kg642f2gfj2rl3bjyz7";
      system = "cl-l10n";
      asd = "cl-l10n";
    });
    systems = [ "cl-l10n" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-l10n-cldr" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "cxml" self) (getAttr "flexi-streams" self) (getAttr "iterate" self) (getAttr "local-time" self) (getAttr "metabang-bind" self) ];
    meta = {};
  });
  cl-l10n-cldr = (build-asdf-system {
    pname = "cl-l10n-cldr";
    version = "20120909-darcs";
    asds = [ "cl-l10n-cldr" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-l10n-cldr/2012-09-09/cl-l10n-cldr-20120909-darcs.tgz";
      sha256 = "1mwkjdc51158v9rpdpsc1qzqqs0x8hb9k1k7b0pm8q7dp9rrb53v";
      system = "cl-l10n-cldr";
      asd = "cl-l10n-cldr";
    });
    systems = [ "cl-l10n-cldr" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-lambdacalc = (build-asdf-system {
    pname = "cl-lambdacalc";
    version = "20230214-git";
    asds = [ "cl-lambdacalc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lambdacalc/2023-02-14/cl-lambdacalc-20230214-git.tgz";
      sha256 = "0ja08d6p1dnbpf8yl8n59vis5lzr3x32in3iin72zmhj5n60axbd";
      system = "cl-lambdacalc";
      asd = "cl-lambdacalc";
    });
    systems = [ "cl-lambdacalc" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lambdacalc-test = (build-asdf-system {
    pname = "cl-lambdacalc-test";
    version = "20230214-git";
    asds = [ "cl-lambdacalc-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lambdacalc/2023-02-14/cl-lambdacalc-20230214-git.tgz";
      sha256 = "0ja08d6p1dnbpf8yl8n59vis5lzr3x32in3iin72zmhj5n60axbd";
      system = "cl-lambdacalc-test";
      asd = "cl-lambdacalc-test";
    });
    systems = [ "cl-lambdacalc-test" ];
    lispLibs = [ (getAttr "cl-lambdacalc" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-las = (build-asdf-system {
    pname = "cl-las";
    version = "20221106-git";
    asds = [ "cl-las" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-las/2022-11-06/cl-las-20221106-git.tgz";
      sha256 = "119v5mrvxhz8b3alqj9gzfbzhigdm1n1hmwyylncn5w5dkq3jc9k";
      system = "cl-las";
      asd = "cl-las";
    });
    systems = [ "cl-las" ];
    lispLibs = [ (getAttr "binary-io" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lastfm = (build-asdf-system {
    pname = "cl-lastfm";
    version = "0.2.1";
    asds = [ "cl-lastfm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lastfm/2014-07-13/cl-lastfm-0.2.1.tgz";
      sha256 = "0f37b8swgfz57bffcypjhcgzj5dhanssiraahkianj65a6zbindl";
      system = "cl-lastfm";
      asd = "cl-lastfm";
    });
    systems = [ "cl-lastfm" ];
    lispLibs = [ (getAttr "cxml-stp" self) (getAttr "drakma" self) (getAttr "trivial-utf-8" self) (getAttr "url-rewrite" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lastfm-test = (build-asdf-system {
    pname = "cl-lastfm-test";
    version = "0.2.1";
    asds = [ "cl-lastfm-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lastfm/2014-07-13/cl-lastfm-0.2.1.tgz";
      sha256 = "0f37b8swgfz57bffcypjhcgzj5dhanssiraahkianj65a6zbindl";
      system = "cl-lastfm-test";
      asd = "cl-lastfm-test";
    });
    systems = [ "cl-lastfm-test" ];
    lispLibs = [ (getAttr "cl-lastfm" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-launch = (build-asdf-system {
    pname = "cl-launch";
    version = "4.1.4.1";
    asds = [ "cl-launch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-launch/2015-10-31/cl-launch-4.1.4.1.tgz";
      sha256 = "041nh1sh9rqdk9c1kr63n3g2pn11i68x9plzyfq36wmyhz2aypnr";
      system = "cl-launch";
      asd = "cl-launch";
    });
    systems = [ "cl-launch" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ledger = (build-asdf-system {
    pname = "cl-ledger";
    version = "20200218-git";
    asds = [ "cl-ledger" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ledger/2020-02-18/cl-ledger-20200218-git.tgz";
      sha256 = "1dpxna9s0rgshqbc58h698ihwyk34a3napb8zrm8vbq8aigjrrzs";
      system = "cl-ledger";
      asd = "cl-ledger";
    });
    systems = [ "cl-ledger" ];
    lispLibs = [ (getAttr "cambl" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "periods-series" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lex = (build-asdf-system {
    pname = "cl-lex";
    version = "20160929-git";
    asds = [ "cl-lex" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lex/2016-09-29/cl-lex-20160929-git.tgz";
      sha256 = "1kg50f76bfpfxcv4dfivq1n9a0xlsra2ajb0vd68lxwgbidgyc2y";
      system = "cl-lex";
      asd = "cl-lex";
    });
    systems = [ "cl-lex" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lexer = (build-asdf-system {
    pname = "cl-lexer";
    version = "20191007-git";
    asds = [ "cl-lexer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lexer/2019-10-07/cl-lexer-20191007-git.tgz";
      sha256 = "182fnmazfmc3zdp14lvpxlaxrwwsjp8mbjn8sdzywjxcnvlpkdmk";
      system = "cl-lexer";
      asd = "cl-lexer";
    });
    systems = [ "cl-lexer" ];
    lispLibs = [ (getAttr "regex" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-liballegro = (build-asdf-system {
    pname = "cl-liballegro";
    version = "20230618-git";
    asds = [ "cl-liballegro" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-liballegro/2023-06-18/cl-liballegro-20230618-git.tgz";
      sha256 = "03rslsr4mqs6dblp92mis3s3vd0nz87i5j12r3vsqqa11aw3ymax";
      system = "cl-liballegro";
      asd = "cl-liballegro";
    });
    systems = [ "cl-liballegro" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-libffi" self) (getAttr "float-features" self) (getAttr "trivial-garbage" self) (getAttr "trivial-gray-streams" self) (getAttr "trivial-main-thread" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-liballegro-nuklear = (build-asdf-system {
    pname = "cl-liballegro-nuklear";
    version = "20230618-git";
    asds = [ "cl-liballegro-nuklear" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-liballegro-nuklear/2023-06-18/cl-liballegro-nuklear-20230618-git.tgz";
      sha256 = "19wl0fhpqvwgcsr38l6ljid25lcj9676ralw8lwnx8aqh1q1s9yb";
      system = "cl-liballegro-nuklear";
      asd = "cl-liballegro-nuklear";
    });
    systems = [ "cl-liballegro-nuklear" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-libffi" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libevent2 = (build-asdf-system {
    pname = "cl-libevent2";
    version = "20190107-git";
    asds = [ "cl-libevent2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libevent2/2019-01-07/cl-libevent2-20190107-git.tgz";
      sha256 = "18c8cxlh0vmyca7ihj8dz3f1j31h7y0kcis6qr6mpkzyi0k2cf0g";
      system = "cl-libevent2";
      asd = "cl-libevent2";
    });
    systems = [ "cl-libevent2" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libevent2-ssl = (build-asdf-system {
    pname = "cl-libevent2-ssl";
    version = "20190107-git";
    asds = [ "cl-libevent2-ssl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libevent2/2019-01-07/cl-libevent2-20190107-git.tgz";
      sha256 = "18c8cxlh0vmyca7ihj8dz3f1j31h7y0kcis6qr6mpkzyi0k2cf0g";
      system = "cl-libevent2-ssl";
      asd = "cl-libevent2-ssl";
    });
    systems = [ "cl-libevent2-ssl" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-libevent2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libiio = (build-asdf-system {
    pname = "cl-libiio";
    version = "20191130-git";
    asds = [ "cl-libiio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libiio/2019-11-30/cl-libiio-20191130-git.tgz";
      sha256 = "1z1jslm303c22imhshr92j1mq7g3j81xa5rk5psj3x00papncwmr";
      system = "cl-libiio";
      asd = "cl-libiio";
    });
    systems = [ "cl-libiio" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libinput = (build-asdf-system {
    pname = "cl-libinput";
    version = "20220707-git";
    asds = [ "cl-libinput" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libinput/2022-07-07/cl-libinput-20220707-git.tgz";
      sha256 = "18c3rl3d2bizbp3607gnn9j50x84f2mkypj9rqbry56i5gcw8zkh";
      system = "cl-libinput";
      asd = "cl-libinput";
    });
    systems = [ "cl-libinput" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "osicat" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-liblinear = (build-asdf-system {
    pname = "cl-liblinear";
    version = "20211020-git";
    asds = [ "cl-liblinear" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libsvm/2021-10-20/cl-libsvm-20211020-git.tgz";
      sha256 = "0fpcw82hz6bp2hicjhvhxwcj4azprcl911n8q941lk8xcld3pmi0";
      system = "cl-liblinear";
      asd = "cl-liblinear";
    });
    systems = [ "cl-liblinear" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libpuzzle = (build-asdf-system {
    pname = "cl-libpuzzle";
    version = "20150608-git";
    asds = [ "cl-libpuzzle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libpuzzle/2015-06-08/cl-libpuzzle-20150608-git.tgz";
      sha256 = "0qgpdg4lni4sq6jp23qcd1jldsnrsn4h5b14ddmc8mb7va4qshlp";
      system = "cl-libpuzzle";
      asd = "cl-libpuzzle";
    });
    systems = [ "cl-libpuzzle" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libpuzzle-test = (build-asdf-system {
    pname = "cl-libpuzzle-test";
    version = "20150608-git";
    asds = [ "cl-libpuzzle-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libpuzzle/2015-06-08/cl-libpuzzle-20150608-git.tgz";
      sha256 = "0qgpdg4lni4sq6jp23qcd1jldsnrsn4h5b14ddmc8mb7va4qshlp";
      system = "cl-libpuzzle-test";
      asd = "cl-libpuzzle-test";
    });
    systems = [ "cl-libpuzzle-test" ];
    lispLibs = [ (getAttr "cl-libpuzzle" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libsvm = (build-asdf-system {
    pname = "cl-libsvm";
    version = "20211020-git";
    asds = [ "cl-libsvm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libsvm/2021-10-20/cl-libsvm-20211020-git.tgz";
      sha256 = "0fpcw82hz6bp2hicjhvhxwcj4azprcl911n8q941lk8xcld3pmi0";
      system = "cl-libsvm";
      asd = "cl-libsvm";
    });
    systems = [ "cl-libsvm" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libsvm-format = (build-asdf-system {
    pname = "cl-libsvm-format";
    version = "20180711-git";
    asds = [ "cl-libsvm-format" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libsvm-format/2018-07-11/cl-libsvm-format-20180711-git.tgz";
      sha256 = "0284aj84xszhkhlivaigf9qj855fxad3mzmv3zfr0qzb5k0nzwrg";
      system = "cl-libsvm-format";
      asd = "cl-libsvm-format";
    });
    systems = [ "cl-libsvm-format" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libsvm-format-test = (build-asdf-system {
    pname = "cl-libsvm-format-test";
    version = "20180711-git";
    asds = [ "cl-libsvm-format-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libsvm-format/2018-07-11/cl-libsvm-format-20180711-git.tgz";
      sha256 = "0284aj84xszhkhlivaigf9qj855fxad3mzmv3zfr0qzb5k0nzwrg";
      system = "cl-libsvm-format-test";
      asd = "cl-libsvm-format-test";
    });
    systems = [ "cl-libsvm-format-test" ];
    lispLibs = [ (getAttr "cl-libsvm-format" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libusb = (build-asdf-system {
    pname = "cl-libusb";
    version = "20210228-git";
    asds = [ "cl-libusb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libusb/2021-02-28/cl-libusb-20210228-git.tgz";
      sha256 = "0kyzgcflwb85q58fgn82sp0bipnq5bprg5i4h0h3jxafqqyagbnk";
      system = "cl-libusb";
      asd = "cl-libusb";
    });
    systems = [ "cl-libusb" ];
    lispLibs = [ (getAttr "libusb-ffi" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libuv = (build-asdf-system {
    pname = "cl-libuv";
    version = "20230618-git";
    asds = [ "cl-libuv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libuv/2023-06-18/cl-libuv-20230618-git.tgz";
      sha256 = "13kymryibhlq7jc8q3yar0c676srx82axfmz0x2r5kq7k94cknl9";
      system = "cl-libuv";
      asd = "cl-libuv";
    });
    systems = [ "cl-libuv" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {};
  });
  cl-libuv-config = (build-asdf-system {
    pname = "cl-libuv-config";
    version = "20230618-git";
    asds = [ "cl-libuv-config" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libuv/2023-06-18/cl-libuv-20230618-git.tgz";
      sha256 = "13kymryibhlq7jc8q3yar0c676srx82axfmz0x2r5kq7k94cknl9";
      system = "cl-libuv-config";
      asd = "cl-libuv-config";
    });
    systems = [ "cl-libuv-config" ];
    lispLibs = [ (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libxml2 = (build-asdf-system {
    pname = "cl-libxml2";
    version = "20130615-git";
    asds = [ "cl-libxml2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libxml2/2013-06-15/cl-libxml2-20130615-git.tgz";
      sha256 = "09049c13cfp5sc6x9lrw762jd7a9qkfq5jgngqgrzn4kn9qscarw";
      system = "cl-libxml2";
      asd = "cl-libxml2";
    });
    systems = [ "cl-libxml2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "flexi-streams" self) (getAttr "garbage-pools" self) (getAttr "iterate" self) (getAttr "metabang-bind" self) (getAttr "puri" self) ];
    meta = {};
  });
  cl-libxml2-test = (build-asdf-system {
    pname = "cl-libxml2-test";
    version = "20130615-git";
    asds = [ "cl-libxml2-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libxml2/2013-06-15/cl-libxml2-20130615-git.tgz";
      sha256 = "09049c13cfp5sc6x9lrw762jd7a9qkfq5jgngqgrzn4kn9qscarw";
      system = "cl-libxml2-test";
      asd = "cl-libxml2";
    });
    systems = [ "cl-libxml2-test" ];
    lispLibs = [ (getAttr "cl-libxml2" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-libyaml = (build-asdf-system {
    pname = "cl-libyaml";
    version = "20201220-git";
    asds = [ "cl-libyaml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libyaml/2020-12-20/cl-libyaml-20201220-git.tgz";
      sha256 = "06pvmackyhq03rjmihpx6w63m6cy8wx78ll5xpwwvd85bgrqq817";
      system = "cl-libyaml";
      asd = "cl-libyaml";
    });
    systems = [ "cl-libyaml" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {};
  });
  cl-libyaml-test = (build-asdf-system {
    pname = "cl-libyaml-test";
    version = "20201220-git";
    asds = [ "cl-libyaml-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-libyaml/2020-12-20/cl-libyaml-20201220-git.tgz";
      sha256 = "06pvmackyhq03rjmihpx6w63m6cy8wx78ll5xpwwvd85bgrqq817";
      system = "cl-libyaml-test";
      asd = "cl-libyaml-test";
    });
    systems = [ "cl-libyaml-test" ];
    lispLibs = [ (getAttr "cl-libyaml" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lite = (build-asdf-system {
    pname = "cl-lite";
    version = "master-5b2475f9-git";
    asds = [ "cl-lite" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/gendl/2023-06-18/gendl-master-5b2475f9-git.tgz";
      sha256 = "1w8xn2vg527g1s7cfhw669sdgbq1v5i927g00qzsq9di0syxvczg";
      system = "cl-lite";
      asd = "cl-lite";
    });
    systems = [ "cl-lite" ];
    lispLibs = [ (getAttr "glisp" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-locale = (build-asdf-system {
    pname = "cl-locale";
    version = "20151031-git";
    asds = [ "cl-locale" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-locale/2015-10-31/cl-locale-20151031-git.tgz";
      sha256 = "1rhannhpsw1yg1fpflam483a3w9qb1izgyvmnmiddv3dn4qsmn9p";
      system = "cl-locale";
      asd = "cl-locale";
    });
    systems = [ "cl-locale" ];
    lispLibs = [ (getAttr "anaphora" self) (getAttr "arnesi" self) (getAttr "cl-annot" self) (getAttr "cl-syntax" self) (getAttr "cl-syntax-annot" self) ];
    meta = {};
  });
  cl-locale-syntax = (build-asdf-system {
    pname = "cl-locale-syntax";
    version = "20151031-git";
    asds = [ "cl-locale-syntax" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-locale/2015-10-31/cl-locale-20151031-git.tgz";
      sha256 = "1rhannhpsw1yg1fpflam483a3w9qb1izgyvmnmiddv3dn4qsmn9p";
      system = "cl-locale-syntax";
      asd = "cl-locale-syntax";
    });
    systems = [ "cl-locale-syntax" ];
    lispLibs = [ (getAttr "cl-locale" self) (getAttr "cl-syntax" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-locale-test = (build-asdf-system {
    pname = "cl-locale-test";
    version = "20151031-git";
    asds = [ "cl-locale-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-locale/2015-10-31/cl-locale-20151031-git.tgz";
      sha256 = "1rhannhpsw1yg1fpflam483a3w9qb1izgyvmnmiddv3dn4qsmn9p";
      system = "cl-locale-test";
      asd = "cl-locale-test";
    });
    systems = [ "cl-locale-test" ];
    lispLibs = [ (getAttr "cl-locale" self) (getAttr "cl-syntax" self) (getAttr "flexi-streams" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-locatives = (build-asdf-system {
    pname = "cl-locatives";
    version = "20230618-git";
    asds = [ "cl-locatives" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-locatives/2023-06-18/cl-locatives-20230618-git.tgz";
      sha256 = "05avna8fj3bicdhbcvnjmv9dnqq10g26m9pwgmrh6a4hyxz9zdaq";
      system = "cl-locatives";
      asd = "cl-locatives";
    });
    systems = [ "cl-locatives" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-log = (build-asdf-system {
    pname = "cl-log";
    version = ".1.0.1";
    asds = [ "cl-log" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-log/2013-01-28/cl-log.1.0.1.tgz";
      sha256 = "0lfy3sxr2shhv8qpyry9kk9gcwwl6bhfgzv0pczibl70mgraqnys";
      system = "cl-log";
      asd = "cl-log";
    });
    systems = [ "cl-log" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-log-test = (build-asdf-system {
    pname = "cl-log-test";
    version = ".1.0.1";
    asds = [ "cl-log-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-log/2013-01-28/cl-log.1.0.1.tgz";
      sha256 = "0lfy3sxr2shhv8qpyry9kk9gcwwl6bhfgzv0pczibl70mgraqnys";
      system = "cl-log-test";
      asd = "cl-log-test";
    });
    systems = [ "cl-log-test" ];
    lispLibs = [ (getAttr "cl-log" self) (getAttr "eos" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-logic = (build-asdf-system {
    pname = "cl-logic";
    version = "20141217-git";
    asds = [ "cl-logic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-logic/2014-12-17/cl-logic-20141217-git.tgz";
      sha256 = "17n2wzqali3j6b7pqbydipwlxgwdrj4mdnsgwjdyz32n8jvfyjwh";
      system = "cl-logic";
      asd = "cl-logic";
    });
    systems = [ "cl-logic" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "quine-mccluskey" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ltsv = (build-asdf-system {
    pname = "cl-ltsv";
    version = "20140713-git";
    asds = [ "cl-ltsv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ltsv/2014-07-13/cl-ltsv-20140713-git.tgz";
      sha256 = "1bjvnwxyaaw3yrq5hws2fr4qmk5938hdh2np2bqpm4m3b2c94n22";
      system = "cl-ltsv";
      asd = "cl-ltsv";
    });
    systems = [ "cl-ltsv" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ltsv-test = (build-asdf-system {
    pname = "cl-ltsv-test";
    version = "20140713-git";
    asds = [ "cl-ltsv-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ltsv/2014-07-13/cl-ltsv-20140713-git.tgz";
      sha256 = "1bjvnwxyaaw3yrq5hws2fr4qmk5938hdh2np2bqpm4m3b2c94n22";
      system = "cl-ltsv-test";
      asd = "cl-ltsv-test";
    });
    systems = [ "cl-ltsv-test" ];
    lispLibs = [ (getAttr "cl-ltsv" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-lzma = (build-asdf-system {
    pname = "cl-lzma";
    version = "20191130-git";
    asds = [ "cl-lzma" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-lzma/2019-11-30/cl-lzma-20191130-git.tgz";
      sha256 = "17fdinmi2ffdga17slv86van0sp9gkvlmjprfdwak2jzziz6fxx6";
      system = "cl-lzma";
      asd = "cl-lzma";
    });
    systems = [ "cl-lzma" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-autowrap" self) (getAttr "fast-io" self) (getAttr "static-vectors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-m4 = (build-asdf-system {
    pname = "cl-m4";
    version = "20130312-git";
    asds = [ "cl-m4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-m4/2013-03-12/cl-m4-20130312-git.tgz";
      sha256 = "1dqdhxb45j4vqmx38xkq32gsckldca8rxpf2idg4b61wd21c0ci6";
      system = "cl-m4";
      asd = "cl-m4";
    });
    systems = [ "cl-m4" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cl-fad" self) (getAttr "cl-ppcre" self) (getAttr "external-program" self) (getAttr "graylex" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-m4-test = (build-asdf-system {
    pname = "cl-m4-test";
    version = "20130312-git";
    asds = [ "cl-m4-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-m4/2013-03-12/cl-m4-20130312-git.tgz";
      sha256 = "1dqdhxb45j4vqmx38xkq32gsckldca8rxpf2idg4b61wd21c0ci6";
      system = "cl-m4-test";
      asd = "cl-m4-test";
    });
    systems = [ "cl-m4-test" ];
    lispLibs = [ (getAttr "cl-heredoc" self) (getAttr "cl-m4" self) (getAttr "hu_dot_dwim_dot_stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mango = (build-asdf-system {
    pname = "cl-mango";
    version = "20200925-git";
    asds = [ "cl-mango" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mango/2020-09-25/cl-mango-20200925-git.tgz";
      sha256 = "0ipa1azakzqigq103m1j2z597bp2i34kx4z1418kp2jn8zwbdz5s";
      system = "cl-mango";
      asd = "cl-mango";
    });
    systems = [ "cl-mango" ];
    lispLibs = [ (getAttr "drakma" self) (getAttr "json-mop" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markdown = (build-asdf-system {
    pname = "cl-markdown";
    version = "20191227-git";
    asds = [ "cl-markdown" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markdown/2019-12-27/cl-markdown-20191227-git.tgz";
      sha256 = "1wksi765nk8kf5qm2chh7dcn6k562kvc108dzdb9y5iwp97lqqvg";
      system = "cl-markdown";
      asd = "cl-markdown";
    });
    systems = [ "cl-markdown" ];
    lispLibs = [ (getAttr "anaphora" self) (getAttr "cl-containers" self) (getAttr "cl-ppcre" self) (getAttr "dynamic-classes" self) (getAttr "metabang-bind" self) (getAttr "metatilities-base" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markdown-comparisons = (build-asdf-system {
    pname = "cl-markdown-comparisons";
    version = "20191227-git";
    asds = [ "cl-markdown-comparisons" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markdown/2019-12-27/cl-markdown-20191227-git.tgz";
      sha256 = "1wksi765nk8kf5qm2chh7dcn6k562kvc108dzdb9y5iwp97lqqvg";
      system = "cl-markdown-comparisons";
      asd = "cl-markdown-comparisons";
    });
    systems = [ "cl-markdown-comparisons" ];
    lispLibs = [ (getAttr "cl-html-diff" self) (getAttr "cl-markdown" self) (getAttr "html-encode" self) (getAttr "lift" self) (getAttr "lml2" self) (getAttr "trivial-shell" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markdown-test = (build-asdf-system {
    pname = "cl-markdown-test";
    version = "20191227-git";
    asds = [ "cl-markdown-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markdown/2019-12-27/cl-markdown-20191227-git.tgz";
      sha256 = "1wksi765nk8kf5qm2chh7dcn6k562kvc108dzdb9y5iwp97lqqvg";
      system = "cl-markdown-test";
      asd = "cl-markdown-test";
    });
    systems = [ "cl-markdown-test" ];
    lispLibs = [ (getAttr "cl-markdown" self) (getAttr "lift" self) (getAttr "trivial-shell" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless = (build-asdf-system {
    pname = "cl-markless";
    version = "20230618-git";
    asds = [ "cl-markless" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless";
      asd = "cl-markless";
    });
    systems = [ "cl-markless" ];
    lispLibs = [ (getAttr "documentation-utils" self) (getAttr "trivial-indent" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless-epub = (build-asdf-system {
    pname = "cl-markless-epub";
    version = "20230618-git";
    asds = [ "cl-markless-epub" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless-epub";
      asd = "cl-markless-epub";
    });
    systems = [ "cl-markless-epub" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-markless-plump" self) (getAttr "trivial-gray-streams" self) (getAttr "trivial-indent" self) (getAttr "trivial-mimes" self) (getAttr "zip" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless-markdown = (build-asdf-system {
    pname = "cl-markless-markdown";
    version = "20230618-git";
    asds = [ "cl-markless-markdown" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless-markdown";
      asd = "cl-markless-markdown";
    });
    systems = [ "cl-markless-markdown" ];
    lispLibs = [ (getAttr "_3bmd" self) (getAttr "_3bmd-ext-code-blocks" self) (getAttr "cl-markless" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless-plump = (build-asdf-system {
    pname = "cl-markless-plump";
    version = "20230618-git";
    asds = [ "cl-markless-plump" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless-plump";
      asd = "cl-markless-plump";
    });
    systems = [ "cl-markless-plump" ];
    lispLibs = [ (getAttr "cl-markless" self) (getAttr "plump-dom" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless-standalone = (build-asdf-system {
    pname = "cl-markless-standalone";
    version = "20230618-git";
    asds = [ "cl-markless-standalone" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless-standalone";
      asd = "cl-markless-standalone";
    });
    systems = [ "cl-markless-standalone" ];
    lispLibs = [ (getAttr "cl-markless" self) (getAttr "cl-markless-epub" self) (getAttr "cl-markless-markdown" self) (getAttr "cl-markless-plump" self) (getAttr "command-line-arguments" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markless-test = (build-asdf-system {
    pname = "cl-markless-test";
    version = "20230618-git";
    asds = [ "cl-markless-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markless/2023-06-18/cl-markless-20230618-git.tgz";
      sha256 = "120d0lf02a9ch1z47mfpsdj313ir5mz483jh3hlgja94ia8qpcw6";
      system = "cl-markless-test";
      asd = "cl-markless-test";
    });
    systems = [ "cl-markless-test" ];
    lispLibs = [ (getAttr "cl-markless" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-marklogic = (build-asdf-system {
    pname = "cl-marklogic";
    version = "20210124-git";
    asds = [ "cl-marklogic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-marklogic/2021-01-24/cl-marklogic-20210124-git.tgz";
      sha256 = "0baq2ccb88zyr2dqdvpm32lsin4zalv11w48x4xm80cr4kw45fk5";
      system = "cl-marklogic";
      asd = "cl-marklogic";
    });
    systems = [ "cl-marklogic" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "drakma" self) (getAttr "fiveam" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-markup = (build-asdf-system {
    pname = "cl-markup";
    version = "20131003-git";
    asds = [ "cl-markup" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markup/2013-10-03/cl-markup-20131003-git.tgz";
      sha256 = "10l6k45971dl13fkdmva7zc6i453lmq9j4xax2ci6pjzlc6xjhp7";
      system = "cl-markup";
      asd = "cl-markup";
    });
    systems = [ "cl-markup" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-markup-test = (build-asdf-system {
    pname = "cl-markup-test";
    version = "20131003-git";
    asds = [ "cl-markup-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-markup/2013-10-03/cl-markup-20131003-git.tgz";
      sha256 = "10l6k45971dl13fkdmva7zc6i453lmq9j4xax2ci6pjzlc6xjhp7";
      system = "cl-markup-test";
      asd = "cl-markup-test";
    });
    systems = [ "cl-markup-test" ];
    lispLibs = [ (getAttr "cl-markup" self) (getAttr "cl-test-more" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-match = (build-asdf-system {
    pname = "cl-match";
    version = "20121125-git";
    asds = [ "cl-match" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-match/2012-11-25/cl-match-20121125-git.tgz";
      sha256 = "1qc8gzp7f4phgyi5whkxacrqzdqs0y1hvkf71m8n7l303jly9wjf";
      system = "cl-match";
      asd = "cl-match";
    });
    systems = [ "cl-match" ];
    lispLibs = [ (getAttr "standard-cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-match-test = (build-asdf-system {
    pname = "cl-match-test";
    version = "20121125-git";
    asds = [ "cl-match-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-match/2012-11-25/cl-match-20121125-git.tgz";
      sha256 = "1qc8gzp7f4phgyi5whkxacrqzdqs0y1hvkf71m8n7l303jly9wjf";
      system = "cl-match-test";
      asd = "cl-match-test";
    });
    systems = [ "cl-match-test" ];
    lispLibs = [ (getAttr "cl-match" self) (getAttr "pcl-unit-test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mathstats = (build-asdf-system {
    pname = "cl-mathstats";
    version = "20230214-git";
    asds = [ "cl-mathstats" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mathstats/2023-02-14/cl-mathstats-20230214-git.tgz";
      sha256 = "17ic625bdsvgfjndl4zzxkjy7dcl54alg2pdr0jjn4cpysffga6z";
      system = "cl-mathstats";
      asd = "cl-mathstats";
    });
    systems = [ "cl-mathstats" ];
    lispLibs = [ (getAttr "cl-containers" self) (getAttr "metatilities-base" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mathstats-test = (build-asdf-system {
    pname = "cl-mathstats-test";
    version = "20230214-git";
    asds = [ "cl-mathstats-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mathstats/2023-02-14/cl-mathstats-20230214-git.tgz";
      sha256 = "17ic625bdsvgfjndl4zzxkjy7dcl54alg2pdr0jjn4cpysffga6z";
      system = "cl-mathstats-test";
      asd = "cl-mathstats-test";
    });
    systems = [ "cl-mathstats-test" ];
    lispLibs = [ (getAttr "cl-mathstats" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-maxminddb = (build-asdf-system {
    pname = "cl-maxminddb";
    version = "20210630-git";
    asds = [ "cl-maxminddb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-maxminddb/2021-06-30/cl-maxminddb-20210630-git.tgz";
      sha256 = "1mm7cpiygcka39pj4a0rvhayfl4wh0zfjkda60yshq24xmml84pw";
      system = "cl-maxminddb";
      asd = "cl-maxminddb";
    });
    systems = [ "cl-maxminddb" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cffi" self) (getAttr "cffi-libffi" self) (getAttr "ieee-floats" self) (getAttr "iterate" self) (getAttr "metabang-bind" self) (getAttr "mmap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-maxsat = (build-asdf-system {
    pname = "cl-maxsat";
    version = "20200218-git";
    asds = [ "cl-maxsat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-maxsat/2020-02-18/cl-maxsat-20200218-git.tgz";
      sha256 = "0qy4hhi8y3wv88x3s88g2hl2cz25cjp26xapd3z4h7lrx7cy786i";
      system = "cl-maxsat";
      asd = "cl-maxsat";
    });
    systems = [ "cl-maxsat" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-sat" self) (getAttr "iterate" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-maxsat_dot_test = (build-asdf-system {
    pname = "cl-maxsat.test";
    version = "20200218-git";
    asds = [ "cl-maxsat.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-maxsat/2020-02-18/cl-maxsat-20200218-git.tgz";
      sha256 = "0qy4hhi8y3wv88x3s88g2hl2cz25cjp26xapd3z4h7lrx7cy786i";
      system = "cl-maxsat.test";
      asd = "cl-maxsat.test";
    });
    systems = [ "cl-maxsat.test" ];
    lispLibs = [ (getAttr "cl-maxsat" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mdb = (build-asdf-system {
    pname = "cl-mdb";
    version = "20220707-git";
    asds = [ "cl-mdb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mdb/2022-07-07/cl-mdb-20220707-git.tgz";
      sha256 = "1xkhk39485yv3j9bshnnv74c95asf9704g80wb8vwvwsvqi7ym2a";
      system = "cl-mdb";
      asd = "cl-mdb";
    });
    systems = [ "cl-mdb" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mecab = (build-asdf-system {
    pname = "cl-mecab";
    version = "20181018-git";
    asds = [ "cl-mecab" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mecab/2018-10-18/cl-mecab-20181018-git.tgz";
      sha256 = "0lfan9p8dsniyp60g6n8awfjvv8lyickc40qdxiry6kmp65636ps";
      system = "cl-mecab";
      asd = "cl-mecab";
    });
    systems = [ "cl-mecab" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mecab-test = (build-asdf-system {
    pname = "cl-mecab-test";
    version = "20181018-git";
    asds = [ "cl-mecab-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mecab/2018-10-18/cl-mecab-20181018-git.tgz";
      sha256 = "0lfan9p8dsniyp60g6n8awfjvv8lyickc40qdxiry6kmp65636ps";
      system = "cl-mecab-test";
      asd = "cl-mecab-test";
    });
    systems = [ "cl-mecab-test" ];
    lispLibs = [ (getAttr "cl-mecab" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mechanize = (build-asdf-system {
    pname = "cl-mechanize";
    version = "20180711-git";
    asds = [ "cl-mechanize" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mechanize/2018-07-11/cl-mechanize-20180711-git.tgz";
      sha256 = "0y86sdi2nl3jv6n535cd62jax0mpc0cckrhffaqacbgbdjc875sn";
      system = "cl-mechanize";
      asd = "cl-mechanize";
    });
    systems = [ "cl-mechanize" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "closure-html" self) (getAttr "cxml-stp" self) (getAttr "drakma" self) (getAttr "puri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mediawiki = (build-asdf-system {
    pname = "cl-mediawiki";
    version = "20161204-git";
    asds = [ "cl-mediawiki" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mediawiki/2016-12-04/cl-mediawiki-20161204-git.tgz";
      sha256 = "1wrysj9l64k3xx152yw1arvn1glnx60j730qvj8prm65iid95xgm";
      system = "cl-mediawiki";
      asd = "cl-mediawiki";
    });
    systems = [ "cl-mediawiki" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cxml" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mediawiki-test = (build-asdf-system {
    pname = "cl-mediawiki-test";
    version = "20161204-git";
    asds = [ "cl-mediawiki-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mediawiki/2016-12-04/cl-mediawiki-20161204-git.tgz";
      sha256 = "1wrysj9l64k3xx152yw1arvn1glnx60j730qvj8prm65iid95xgm";
      system = "cl-mediawiki-test";
      asd = "cl-mediawiki-test";
    });
    systems = [ "cl-mediawiki-test" ];
    lispLibs = [ (getAttr "cl-mediawiki" self) (getAttr "lisp-unit2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-megolm = (build-asdf-system {
    pname = "cl-megolm";
    version = "20230214-git";
    asds = [ "cl-megolm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-megolm/2023-02-14/cl-megolm-20230214-git.tgz";
      sha256 = "1n80v63pw2ck419fglgdhhqnc06jmams6mnxb8sqdg966qxhql2k";
      system = "cl-megolm";
      asd = "cl-megolm";
    });
    systems = [ "cl-megolm" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "claw-olm" self) (getAttr "ironclad" self) (getAttr "jonathan" self) (getAttr "lisp-unit" self) (getAttr "s-base64" self) (getAttr "str" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-memcached = (build-asdf-system {
    pname = "cl-memcached";
    version = "20150608-git";
    asds = [ "cl-memcached" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-memcached/2015-06-08/cl-memcached-20150608-git.tgz";
      sha256 = "0g66m0yiazzh0447qbmgxjn4kxjcx9bk2l8cimyzmriz5d0j2q3i";
      system = "cl-memcached";
      asd = "cl-memcached";
    });
    systems = [ "cl-memcached" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "pooler" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-messagepack = (build-asdf-system {
    pname = "cl-messagepack";
    version = "20201016-git";
    asds = [ "cl-messagepack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-messagepack/2020-10-16/cl-messagepack-20201016-git.tgz";
      sha256 = "0lhw8wz45q9jgh7fn5ihj7ccl3wm2c2x3vb4cijgg6vhbrwlw2qh";
      system = "cl-messagepack";
      asd = "cl-messagepack";
    });
    systems = [ "cl-messagepack" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "closer-mop" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-messagepack-rpc = (build-asdf-system {
    pname = "cl-messagepack-rpc";
    version = "20171227-git";
    asds = [ "cl-messagepack-rpc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-messagepack-rpc/2017-12-27/cl-messagepack-rpc-20171227-git.tgz";
      sha256 = "02nrnhav28v5vwig9mmmmax59nl0sbjkmdzwakzpj6y1gafiqgy9";
      system = "cl-messagepack-rpc";
      asd = "cl-messagepack-rpc";
    });
    systems = [ "cl-messagepack-rpc" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-async" self) (getAttr "cl-libuv" self) (getAttr "cl-messagepack" self) (getAttr "flexi-streams" self) (getAttr "trivial-backtrace" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-messagepack-rpc-tests = (build-asdf-system {
    pname = "cl-messagepack-rpc-tests";
    version = "20171227-git";
    asds = [ "cl-messagepack-rpc-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-messagepack-rpc/2017-12-27/cl-messagepack-rpc-20171227-git.tgz";
      sha256 = "02nrnhav28v5vwig9mmmmax59nl0sbjkmdzwakzpj6y1gafiqgy9";
      system = "cl-messagepack-rpc-tests";
      asd = "cl-messagepack-rpc-tests";
    });
    systems = [ "cl-messagepack-rpc-tests" ];
    lispLibs = [ (getAttr "cl-messagepack-rpc" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-messagepack-tests = (build-asdf-system {
    pname = "cl-messagepack-tests";
    version = "20201016-git";
    asds = [ "cl-messagepack-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-messagepack/2020-10-16/cl-messagepack-20201016-git.tgz";
      sha256 = "0lhw8wz45q9jgh7fn5ihj7ccl3wm2c2x3vb4cijgg6vhbrwlw2qh";
      system = "cl-messagepack-tests";
      asd = "cl-messagepack-tests";
    });
    systems = [ "cl-messagepack-tests" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "cl-messagepack" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migrations = (build-asdf-system {
    pname = "cl-migrations";
    version = "20110110-http";
    asds = [ "cl-migrations" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migrations/2011-01-10/cl-migrations-20110110-http.tgz";
      sha256 = "0mq3ir1kffw921q5a878964ghnrhcrh79p6yxsrb25bzkwpnfx02";
      system = "cl-migrations";
      asd = "cl-migrations";
    });
    systems = [ "cl-migrations" ];
    lispLibs = [ (getAttr "clsql" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum = (build-asdf-system {
    pname = "cl-migratum";
    version = "20230214-git";
    asds = [ "cl-migratum" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum";
      asd = "cl-migratum";
    });
    systems = [ "cl-migratum" ];
    lispLibs = [ (getAttr "cl-ascii-table" self) (getAttr "cl-reexport" self) (getAttr "local-time" self) (getAttr "log4cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_cli = (build-asdf-system {
    pname = "cl-migratum.cli";
    version = "20230214-git";
    asds = [ "cl-migratum.cli" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.cli";
      asd = "cl-migratum.cli";
    });
    systems = [ "cl-migratum.cli" ];
    lispLibs = [ (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_dbi" self) (getAttr "cl-migratum_dot_driver_dot_rdbms-postgresql" self) (getAttr "cl-migratum_dot_provider_dot_local-path" self) (getAttr "clingon" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_driver_dot_dbi = (build-asdf-system {
    pname = "cl-migratum.driver.dbi";
    version = "20230214-git";
    asds = [ "cl-migratum.driver.dbi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.driver.dbi";
      asd = "cl-migratum.driver.dbi";
    });
    systems = [ "cl-migratum.driver.dbi" ];
    lispLibs = [ (getAttr "cl-dbi" self) (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_mixins" self) (getAttr "cl-ppcre" self) (getAttr "log4cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_driver_dot_mixins = (build-asdf-system {
    pname = "cl-migratum.driver.mixins";
    version = "20230214-git";
    asds = [ "cl-migratum.driver.mixins" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.driver.mixins";
      asd = "cl-migratum.driver.mixins";
    });
    systems = [ "cl-migratum.driver.mixins" ];
    lispLibs = [ (getAttr "cl-migratum" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_driver_dot_rdbms-postgresql = (build-asdf-system {
    pname = "cl-migratum.driver.rdbms-postgresql";
    version = "20230214-git";
    asds = [ "cl-migratum.driver.rdbms-postgresql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.driver.rdbms-postgresql";
      asd = "cl-migratum.driver.rdbms-postgresql";
    });
    systems = [ "cl-migratum.driver.rdbms-postgresql" ];
    lispLibs = [ (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_mixins" self) (getAttr "cl-ppcre" self) (getAttr "hu_dot_dwim_dot_logger" self) (getAttr "hu_dot_dwim_dot_rdbms_dot_postgresql" self) (getAttr "log4cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_provider_dot_local-path = (build-asdf-system {
    pname = "cl-migratum.provider.local-path";
    version = "20230214-git";
    asds = [ "cl-migratum.provider.local-path" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.provider.local-path";
      asd = "cl-migratum.provider.local-path";
    });
    systems = [ "cl-migratum.provider.local-path" ];
    lispLibs = [ (getAttr "cl-migratum" self) (getAttr "cl-ppcre" self) (getAttr "log4cl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-migratum_dot_test = (build-asdf-system {
    pname = "cl-migratum.test";
    version = "20230214-git";
    asds = [ "cl-migratum.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-migratum/2023-02-14/cl-migratum-20230214-git.tgz";
      sha256 = "0zfs62rhzj5d0pm6lbc70c0im1da3phaq7swr8rm8chqkgsqil0p";
      system = "cl-migratum.test";
      asd = "cl-migratum.test";
    });
    systems = [ "cl-migratum.test" ];
    lispLibs = [ (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_dbi" self) (getAttr "cl-migratum_dot_driver_dot_rdbms-postgresql" self) (getAttr "cl-migratum_dot_provider_dot_local-path" self) (getAttr "dbd-sqlite3" self) (getAttr "rove" self) (getAttr "tmpdir" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mime = (build-asdf-system {
    pname = "cl-mime";
    version = "20201220-git";
    asds = [ "cl-mime" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mime/2020-12-20/cl-mime-20201220-git.tgz";
      sha256 = "0i2vyc1d4qp36f3c3qfpx9rkp3d2ka80r40wc9lsvhqn1hjxa2gv";
      system = "cl-mime";
      asd = "cl-mime";
    });
    systems = [ "cl-mime" ];
    lispLibs = [ (getAttr "cl-base64" self) (getAttr "cl-ppcre" self) (getAttr "cl-qprint" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mime-from-string = (build-asdf-system {
    pname = "cl-mime-from-string";
    version = "20200427-git";
    asds = [ "cl-mime-from-string" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mime-from-string/2020-04-27/cl-mime-from-string-20200427-git.tgz";
      sha256 = "1pzhfbv6j3b0vvf4rxxd56v54lh6v7cs16nq2d64cawn6qzmk4bp";
      system = "cl-mime-from-string";
      asd = "cl-mime-from-string";
    });
    systems = [ "cl-mime-from-string" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mime-test = (build-asdf-system {
    pname = "cl-mime-test";
    version = "20201220-git";
    asds = [ "cl-mime-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mime/2020-12-20/cl-mime-20201220-git.tgz";
      sha256 = "0i2vyc1d4qp36f3c3qfpx9rkp3d2ka80r40wc9lsvhqn1hjxa2gv";
      system = "cl-mime-test";
      asd = "cl-mime-test";
    });
    systems = [ "cl-mime-test" ];
    lispLibs = [ (getAttr "cl-mime" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mimeparse = (build-asdf-system {
    pname = "cl-mimeparse";
    version = "20210531-git";
    asds = [ "cl-mimeparse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mimeparse/2021-05-31/cl-mimeparse-20210531-git.tgz";
      sha256 = "0gdkpi3620va0a3q56svcn1q9f5w0pqfhx30lnldg8fjnrdfiwkk";
      system = "cl-mimeparse";
      asd = "cl-mimeparse";
    });
    systems = [ "cl-mimeparse" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "parse-number" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mimeparse-tests = (build-asdf-system {
    pname = "cl-mimeparse-tests";
    version = "20210531-git";
    asds = [ "cl-mimeparse-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mimeparse/2021-05-31/cl-mimeparse-20210531-git.tgz";
      sha256 = "0gdkpi3620va0a3q56svcn1q9f5w0pqfhx30lnldg8fjnrdfiwkk";
      system = "cl-mimeparse-tests";
      asd = "cl-mimeparse-tests";
    });
    systems = [ "cl-mimeparse-tests" ];
    lispLibs = [ (getAttr "cl-mimeparse" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-minify-css = (build-asdf-system {
    pname = "cl-minify-css";
    version = "20200925-git";
    asds = [ "cl-minify-css" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-minify-css/2020-09-25/cl-minify-css-20200925-git.tgz";
      sha256 = "1wj1mh7qzr8ybqyx7kxnpsmj3d9lylnzmq1qmycdyf2llqkcdxgd";
      system = "cl-minify-css";
      asd = "cl-minify-css";
    });
    systems = [ "cl-minify-css" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-minify-css-test = (build-asdf-system {
    pname = "cl-minify-css-test";
    version = "20200925-git";
    asds = [ "cl-minify-css-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-minify-css/2020-09-25/cl-minify-css-20200925-git.tgz";
      sha256 = "1wj1mh7qzr8ybqyx7kxnpsmj3d9lylnzmq1qmycdyf2llqkcdxgd";
      system = "cl-minify-css-test";
      asd = "cl-minify-css-test";
    });
    systems = [ "cl-minify-css-test" ];
    lispLibs = [ (getAttr "assert-p" self) (getAttr "cacau" self) (getAttr "cacau-asdf" self) (getAttr "cl-minify-css" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed = (build-asdf-system {
    pname = "cl-mixed";
    version = "20230618-git";
    asds = [ "cl-mixed" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed";
      asd = "cl-mixed";
    });
    systems = [ "cl-mixed" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "static-vectors" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-aaudio = (build-asdf-system {
    pname = "cl-mixed-aaudio";
    version = "20230618-git";
    asds = [ "cl-mixed-aaudio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-aaudio";
      asd = "cl-mixed-aaudio";
    });
    systems = [ "cl-mixed-aaudio" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-alsa = (build-asdf-system {
    pname = "cl-mixed-alsa";
    version = "20230618-git";
    asds = [ "cl-mixed-alsa" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-alsa";
      asd = "cl-mixed-alsa";
    });
    systems = [ "cl-mixed-alsa" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-coreaudio = (build-asdf-system {
    pname = "cl-mixed-coreaudio";
    version = "20230618-git";
    asds = [ "cl-mixed-coreaudio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-coreaudio";
      asd = "cl-mixed-coreaudio";
    });
    systems = [ "cl-mixed-coreaudio" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cl-mixed" self) (getAttr "float-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-examples = (build-asdf-system {
    pname = "cl-mixed-examples";
    version = "20230618-git";
    asds = [ "cl-mixed-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-examples";
      asd = "cl-mixed-examples";
    });
    systems = [ "cl-mixed-examples" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "cl-mixed-mpg123" self) (getAttr "cl-mixed-out123" self) (getAttr "cl-mixed-pulse" self) (getAttr "cl-mixed-wav" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-flac = (build-asdf-system {
    pname = "cl-mixed-flac";
    version = "20230618-git";
    asds = [ "cl-mixed-flac" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-flac";
      asd = "cl-mixed-flac";
    });
    systems = [ "cl-mixed-flac" ];
    lispLibs = [ (getAttr "cl-flac" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-jack = (build-asdf-system {
    pname = "cl-mixed-jack";
    version = "20230618-git";
    asds = [ "cl-mixed-jack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-jack";
      asd = "cl-mixed-jack";
    });
    systems = [ "cl-mixed-jack" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-mpg123 = (build-asdf-system {
    pname = "cl-mixed-mpg123";
    version = "20230618-git";
    asds = [ "cl-mixed-mpg123" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-mpg123";
      asd = "cl-mixed-mpg123";
    });
    systems = [ "cl-mixed-mpg123" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "cl-mpg123" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-mpt = (build-asdf-system {
    pname = "cl-mixed-mpt";
    version = "20230618-git";
    asds = [ "cl-mixed-mpt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-mpt";
      asd = "cl-mixed-mpt";
    });
    systems = [ "cl-mixed-mpt" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "static-vectors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-opus = (build-asdf-system {
    pname = "cl-mixed-opus";
    version = "20230618-git";
    asds = [ "cl-mixed-opus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-opus";
      asd = "cl-mixed-opus";
    });
    systems = [ "cl-mixed-opus" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "cl-opus" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-oss = (build-asdf-system {
    pname = "cl-mixed-oss";
    version = "20230618-git";
    asds = [ "cl-mixed-oss" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-oss";
      asd = "cl-mixed-oss";
    });
    systems = [ "cl-mixed-oss" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-out123 = (build-asdf-system {
    pname = "cl-mixed-out123";
    version = "20230618-git";
    asds = [ "cl-mixed-out123" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-out123";
      asd = "cl-mixed-out123";
    });
    systems = [ "cl-mixed-out123" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "cl-out123" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-pulse = (build-asdf-system {
    pname = "cl-mixed-pulse";
    version = "20230618-git";
    asds = [ "cl-mixed-pulse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-pulse";
      asd = "cl-mixed-pulse";
    });
    systems = [ "cl-mixed-pulse" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-sdl2 = (build-asdf-system {
    pname = "cl-mixed-sdl2";
    version = "20230618-git";
    asds = [ "cl-mixed-sdl2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-sdl2";
      asd = "cl-mixed-sdl2";
    });
    systems = [ "cl-mixed-sdl2" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "sdl2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-vorbis = (build-asdf-system {
    pname = "cl-mixed-vorbis";
    version = "20230618-git";
    asds = [ "cl-mixed-vorbis" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-vorbis";
      asd = "cl-mixed-vorbis";
    });
    systems = [ "cl-mixed-vorbis" ];
    lispLibs = [ (getAttr "cl-mixed" self) (getAttr "cl-vorbis" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-wasapi = (build-asdf-system {
    pname = "cl-mixed-wasapi";
    version = "20230618-git";
    asds = [ "cl-mixed-wasapi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-wasapi";
      asd = "cl-mixed-wasapi";
    });
    systems = [ "cl-mixed-wasapi" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) (getAttr "com-on" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-wav = (build-asdf-system {
    pname = "cl-mixed-wav";
    version = "20230618-git";
    asds = [ "cl-mixed-wav" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-wav";
      asd = "cl-mixed-wav";
    });
    systems = [ "cl-mixed-wav" ];
    lispLibs = [ (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-winmm = (build-asdf-system {
    pname = "cl-mixed-winmm";
    version = "20230618-git";
    asds = [ "cl-mixed-winmm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-winmm";
      asd = "cl-mixed-winmm";
    });
    systems = [ "cl-mixed-winmm" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mixed-xaudio2 = (build-asdf-system {
    pname = "cl-mixed-xaudio2";
    version = "20230618-git";
    asds = [ "cl-mixed-xaudio2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mixed/2023-06-18/cl-mixed-20230618-git.tgz";
      sha256 = "0bd77bxw55mqyqmkb9s53ay0frkq5k6bgxakzkqg5kyjdryli36c";
      system = "cl-mixed-xaudio2";
      asd = "cl-mixed-xaudio2";
    });
    systems = [ "cl-mixed-xaudio2" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mixed" self) (getAttr "com-on" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mock = (build-asdf-system {
    pname = "cl-mock";
    version = "20221106-git";
    asds = [ "cl-mock" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mock/2022-11-06/cl-mock-20221106-git.tgz";
      sha256 = "19641sm3klx9yfk8lr376rfkd26vy72yp1hkpkqcw3q3m1xrf9xp";
      system = "cl-mock";
      asd = "cl-mock";
    });
    systems = [ "cl-mock" ];
    lispLibs = [ (getAttr "cl-mock-basic" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mock-basic = (build-asdf-system {
    pname = "cl-mock-basic";
    version = "20221106-git";
    asds = [ "cl-mock-basic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mock/2022-11-06/cl-mock-20221106-git.tgz";
      sha256 = "19641sm3klx9yfk8lr376rfkd26vy72yp1hkpkqcw3q3m1xrf9xp";
      system = "cl-mock-basic";
      asd = "cl-mock-basic";
    });
    systems = [ "cl-mock-basic" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mock-tests = (build-asdf-system {
    pname = "cl-mock-tests";
    version = "20221106-git";
    asds = [ "cl-mock-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mock/2022-11-06/cl-mock-20221106-git.tgz";
      sha256 = "19641sm3klx9yfk8lr376rfkd26vy72yp1hkpkqcw3q3m1xrf9xp";
      system = "cl-mock-tests";
      asd = "cl-mock-tests";
    });
    systems = [ "cl-mock-tests" ];
    lispLibs = [ (getAttr "cl-mock" self) (getAttr "cl-mock-tests-basic" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mock-tests-basic = (build-asdf-system {
    pname = "cl-mock-tests-basic";
    version = "20221106-git";
    asds = [ "cl-mock-tests-basic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mock/2022-11-06/cl-mock-20221106-git.tgz";
      sha256 = "19641sm3klx9yfk8lr376rfkd26vy72yp1hkpkqcw3q3m1xrf9xp";
      system = "cl-mock-tests-basic";
      asd = "cl-mock-tests-basic";
    });
    systems = [ "cl-mock-tests-basic" ];
    lispLibs = [ (getAttr "cl-mock-basic" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-modio = (build-asdf-system {
    pname = "cl-modio";
    version = "20230618-git";
    asds = [ "cl-modio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-modio/2023-06-18/cl-modio-20230618-git.tgz";
      sha256 = "0hz87v81pi8kr2c7az30czpdf7v757lkzlsmdcc59p94pipca7m9";
      system = "cl-modio";
      asd = "cl-modio";
    });
    systems = [ "cl-modio" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "com_dot_inuoe_dot_jzon" self) (getAttr "documentation-utils" self) (getAttr "drakma" self) (getAttr "language-codes" self) (getAttr "zippy" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-monad-macros = (build-asdf-system {
    pname = "cl-monad-macros";
    version = "20110619-svn";
    asds = [ "cl-monad-macros" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-monad-macros/2011-06-19/cl-monad-macros-20110619-svn.tgz";
      sha256 = "184p018xb07yd04bpscrwrnwv1cdxh9hxggmrnj95lhlr6r97l1z";
      system = "cl-monad-macros";
      asd = "cl-monad-macros";
    });
    systems = [ "cl-monad-macros" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-moneris = (build-asdf-system {
    pname = "cl-moneris";
    version = "20110418-git";
    asds = [ "cl-moneris" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-moneris/2011-04-18/cl-moneris-20110418-git.tgz";
      sha256 = "1jvzssjb273ijbdcpxpl6ajh02k4h6l5j4vjxkh69cnrq3dcsvfc";
      system = "cl-moneris";
      asd = "cl-moneris";
    });
    systems = [ "cl-moneris" ];
    lispLibs = [ (getAttr "drakma" self) (getAttr "s-xml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-moneris-test = (build-asdf-system {
    pname = "cl-moneris-test";
    version = "20110418-git";
    asds = [ "cl-moneris-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-moneris/2011-04-18/cl-moneris-20110418-git.tgz";
      sha256 = "1jvzssjb273ijbdcpxpl6ajh02k4h6l5j4vjxkh69cnrq3dcsvfc";
      system = "cl-moneris-test";
      asd = "cl-moneris-test";
    });
    systems = [ "cl-moneris-test" ];
    lispLibs = [ (getAttr "cl-moneris" self) (getAttr "eos" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mongo = (build-asdf-system {
    pname = "cl-mongo";
    version = "20160531-git";
    asds = [ "cl-mongo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mongo/2016-05-31/cl-mongo-20160531-git.tgz";
      sha256 = "1l3kydbxbxhs1z76v6qpwjnabv8wf0mff1pfjkrpjfz6bia1svx6";
      system = "cl-mongo";
      asd = "cl-mongo";
    });
    systems = [ "cl-mongo" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "bordeaux-threads" self) (getAttr "documentation-template" self) (getAttr "lisp-unit" self) (getAttr "parenscript" self) (getAttr "split-sequence" self) (getAttr "usocket" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mongo-id = (build-asdf-system {
    pname = "cl-mongo-id";
    version = "20201220-git";
    asds = [ "cl-mongo-id" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mongo-id/2020-12-20/cl-mongo-id-20201220-git.tgz";
      sha256 = "1bpwmh5970rpr6ayygcgdg96hq2dlrksgpa1vdmy5l6vdbw9xrys";
      system = "cl-mongo-id";
      asd = "cl-mongo-id";
    });
    systems = [ "cl-mongo-id" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "local-time" self) (getAttr "md5" self) (getAttr "secure-random" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-monitors = (build-asdf-system {
    pname = "cl-monitors";
    version = "20190710-git";
    asds = [ "cl-monitors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-monitors/2019-07-10/cl-monitors-20190710-git.tgz";
      sha256 = "0arwj7san3hsjws1fj3l8iqm92fipw0bfl3gzvvx6sa3cmy3m8vj";
      system = "cl-monitors";
      asd = "cl-monitors";
    });
    systems = [ "cl-monitors" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mop = (build-asdf-system {
    pname = "cl-mop";
    version = "20150113-git";
    asds = [ "cl-mop" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mop/2015-01-13/cl-mop-20150113-git.tgz";
      sha256 = "0wqjbp6jr868a89hklf1ppxkdfbznafrdpriakqiraicvr9kvksg";
      system = "cl-mop";
      asd = "cl-mop";
    });
    systems = [ "cl-mop" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-morse = (build-asdf-system {
    pname = "cl-morse";
    version = "v1.0.0";
    asds = [ "cl-morse" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-morse/2022-07-07/cl-morse-v1.0.0.tgz";
      sha256 = "01sh34nhbsx2dsrb2r1vkd4j8lzm9gjd5jfi8a4cs4m3djjwhh5i";
      system = "cl-morse";
      asd = "cl-morse";
    });
    systems = [ "cl-morse" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-moss = (build-asdf-system {
    pname = "cl-moss";
    version = "20171019-git";
    asds = [ "cl-moss" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-moss/2017-10-19/cl-moss-20171019-git.tgz";
      sha256 = "1qxzppnyxc8lkhfbbp5m3dbhp4rfkyc2lfrry2448i5w5icrigzd";
      system = "cl-moss";
      asd = "cl-moss";
    });
    systems = [ "cl-moss" ];
    lispLibs = [ (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mount-info = (build-asdf-system {
    pname = "cl-mount-info";
    version = "20200218-git";
    asds = [ "cl-mount-info" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mount-info/2020-02-18/cl-mount-info-20200218-git.tgz";
      sha256 = "0vza9gj9q42nzb5v8aj22lmn4aqx9vrddsb5a343nbwfz89hbh9x";
      system = "cl-mount-info";
      asd = "cl-mount-info";
    });
    systems = [ "cl-mount-info" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpg123 = (build-asdf-system {
    pname = "cl-mpg123";
    version = "20230618-git";
    asds = [ "cl-mpg123" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpg123/2023-06-18/cl-mpg123-20230618-git.tgz";
      sha256 = "0smrgr2i2vcgnzkfafpix9dq1wzfs3yd2q6l5p66cplm4lhd7ni4";
      system = "cl-mpg123";
      asd = "cl-mpg123";
    });
    systems = [ "cl-mpg123" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpg123-example = (build-asdf-system {
    pname = "cl-mpg123-example";
    version = "20230618-git";
    asds = [ "cl-mpg123-example" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpg123/2023-06-18/cl-mpg123-20230618-git.tgz";
      sha256 = "0smrgr2i2vcgnzkfafpix9dq1wzfs3yd2q6l5p66cplm4lhd7ni4";
      system = "cl-mpg123-example";
      asd = "cl-mpg123-example";
    });
    systems = [ "cl-mpg123-example" ];
    lispLibs = [ (getAttr "cl-mpg123" self) (getAttr "cl-out123" self) (getAttr "verbose" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpi = (build-asdf-system {
    pname = "cl-mpi";
    version = "20190710-git";
    asds = [ "cl-mpi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpi/2019-07-10/cl-mpi-20190710-git.tgz";
      sha256 = "1ykwk7acjhzpsjgm2b5svdpyw2qgrh860gkx3n2ckyrgd9l9q6jb";
      system = "cl-mpi";
      asd = "cl-mpi";
    });
    systems = [ "cl-mpi" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-mpi-asdf-integration" self) (getAttr "static-vectors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpi-asdf-integration = (build-asdf-system {
    pname = "cl-mpi-asdf-integration";
    version = "20190710-git";
    asds = [ "cl-mpi-asdf-integration" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpi/2019-07-10/cl-mpi-20190710-git.tgz";
      sha256 = "1ykwk7acjhzpsjgm2b5svdpyw2qgrh860gkx3n2ckyrgd9l9q6jb";
      system = "cl-mpi-asdf-integration";
      asd = "cl-mpi-asdf-integration";
    });
    systems = [ "cl-mpi-asdf-integration" ];
    lispLibs = [ (getAttr "cffi-grovel" self) (getAttr "cffi-toolchain" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpi-examples = (build-asdf-system {
    pname = "cl-mpi-examples";
    version = "20190710-git";
    asds = [ "cl-mpi-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpi/2019-07-10/cl-mpi-20190710-git.tgz";
      sha256 = "1ykwk7acjhzpsjgm2b5svdpyw2qgrh860gkx3n2ckyrgd9l9q6jb";
      system = "cl-mpi-examples";
      asd = "cl-mpi-examples";
    });
    systems = [ "cl-mpi-examples" ];
    lispLibs = [ (getAttr "cl-mpi" self) (getAttr "cl-mpi-asdf-integration" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpi-extensions = (build-asdf-system {
    pname = "cl-mpi-extensions";
    version = "20190710-git";
    asds = [ "cl-mpi-extensions" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpi/2019-07-10/cl-mpi-20190710-git.tgz";
      sha256 = "1ykwk7acjhzpsjgm2b5svdpyw2qgrh860gkx3n2ckyrgd9l9q6jb";
      system = "cl-mpi-extensions";
      asd = "cl-mpi-extensions";
    });
    systems = [ "cl-mpi-extensions" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-conspack" self) (getAttr "cl-mpi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mpi-test-suite = (build-asdf-system {
    pname = "cl-mpi-test-suite";
    version = "20190710-git";
    asds = [ "cl-mpi-test-suite" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mpi/2019-07-10/cl-mpi-20190710-git.tgz";
      sha256 = "1ykwk7acjhzpsjgm2b5svdpyw2qgrh860gkx3n2ckyrgd9l9q6jb";
      system = "cl-mpi-test-suite";
      asd = "cl-mpi-test-suite";
    });
    systems = [ "cl-mpi-test-suite" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-mpi" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mtgnet = (build-asdf-system {
    pname = "cl-mtgnet";
    version = "20180711-git";
    asds = [ "cl-mtgnet" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mtgnet/2018-07-11/cl-mtgnet-20180711-git.tgz";
      sha256 = "08mwkfa9s51is6npn7al4rn5a65ip2bq0psb1pdvh111h5zqxdrb";
      system = "cl-mtgnet";
      asd = "cl-mtgnet";
    });
    systems = [ "cl-mtgnet" ];
    lispLibs = [ (getAttr "blackbird" self) (getAttr "cl-json" self) (getAttr "cl-netstring_plus" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mtgnet-async = (build-asdf-system {
    pname = "cl-mtgnet-async";
    version = "20180711-git";
    asds = [ "cl-mtgnet-async" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mtgnet/2018-07-11/cl-mtgnet-20180711-git.tgz";
      sha256 = "08mwkfa9s51is6npn7al4rn5a65ip2bq0psb1pdvh111h5zqxdrb";
      system = "cl-mtgnet-async";
      asd = "cl-mtgnet-async";
    });
    systems = [ "cl-mtgnet-async" ];
    lispLibs = [ (getAttr "cl-async" self) (getAttr "cl-mtgnet" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mtgnet-sync = (build-asdf-system {
    pname = "cl-mtgnet-sync";
    version = "20180711-git";
    asds = [ "cl-mtgnet-sync" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mtgnet/2018-07-11/cl-mtgnet-20180711-git.tgz";
      sha256 = "08mwkfa9s51is6npn7al4rn5a65ip2bq0psb1pdvh111h5zqxdrb";
      system = "cl-mtgnet-sync";
      asd = "cl-mtgnet-sync";
    });
    systems = [ "cl-mtgnet-sync" ];
    lispLibs = [ (getAttr "cl-mtgnet" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-murmurhash = (build-asdf-system {
    pname = "cl-murmurhash";
    version = "20210630-git";
    asds = [ "cl-murmurhash" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-murmurhash/2021-06-30/cl-murmurhash-20210630-git.tgz";
      sha256 = "0251r0mpjm0y3qsm4lm7ncvrkxvgwc53spdm1p2mpayhvkkqqsws";
      system = "cl-murmurhash";
      asd = "cl-murmurhash";
    });
    systems = [ "cl-murmurhash" ];
    lispLibs = [ (getAttr "babel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mustache = (build-asdf-system {
    pname = "cl-mustache";
    version = "20200325-git";
    asds = [ "cl-mustache" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mustache/2020-03-25/cl-mustache-20200325-git.tgz";
      sha256 = "1wsmr46c56l0chshffk3rbvd7v2jwplmgmkkyr98n5n2qnjcqrc4";
      system = "cl-mustache";
      asd = "cl-mustache";
    });
    systems = [ "cl-mustache" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-mustache-test = (build-asdf-system {
    pname = "cl-mustache-test";
    version = "20200325-git";
    asds = [ "cl-mustache-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mustache/2020-03-25/cl-mustache-20200325-git.tgz";
      sha256 = "1wsmr46c56l0chshffk3rbvd7v2jwplmgmkkyr98n5n2qnjcqrc4";
      system = "cl-mustache-test";
      asd = "cl-mustache-test";
    });
    systems = [ "cl-mustache-test" ];
    lispLibs = [ (getAttr "cl-mustache" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-muth = (build-asdf-system {
    pname = "cl-muth";
    version = "stable-git";
    asds = [ "cl-muth" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-muth/2022-07-07/cl-muth-stable-git.tgz";
      sha256 = "0409arzy51chgi9anj9s2zn0qkx9wnphlbwcdvpamr4b51b60xjz";
      system = "cl-muth";
      asd = "cl-muth";
    });
    systems = [ "cl-muth" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bodge-heap" self) (getAttr "bodge-queue" self) (getAttr "bordeaux-threads" self) (getAttr "trivial-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw = (build-asdf-system {
    pname = "cl-mw";
    version = "20150407-git";
    asds = [ "cl-mw" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw";
      asd = "cl-mw";
    });
    systems = [ "cl-mw" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "hu_dot_dwim_dot_serializer" self) (getAttr "iolib" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_argument-processing = (build-asdf-system {
    pname = "cl-mw.examples.argument-processing";
    version = "20150407-git";
    asds = [ "cl-mw.examples.argument-processing" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.argument-processing";
      asd = "cl-mw.examples.argument-processing";
    });
    systems = [ "cl-mw.examples.argument-processing" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_hello-world = (build-asdf-system {
    pname = "cl-mw.examples.hello-world";
    version = "20150407-git";
    asds = [ "cl-mw.examples.hello-world" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.hello-world";
      asd = "cl-mw.examples.hello-world";
    });
    systems = [ "cl-mw.examples.hello-world" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_higher-order = (build-asdf-system {
    pname = "cl-mw.examples.higher-order";
    version = "20150407-git";
    asds = [ "cl-mw.examples.higher-order" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.higher-order";
      asd = "cl-mw.examples.higher-order";
    });
    systems = [ "cl-mw.examples.higher-order" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_monte-carlo-pi = (build-asdf-system {
    pname = "cl-mw.examples.monte-carlo-pi";
    version = "20150407-git";
    asds = [ "cl-mw.examples.monte-carlo-pi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.monte-carlo-pi";
      asd = "cl-mw.examples.monte-carlo-pi";
    });
    systems = [ "cl-mw.examples.monte-carlo-pi" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_ping = (build-asdf-system {
    pname = "cl-mw.examples.ping";
    version = "20150407-git";
    asds = [ "cl-mw.examples.ping" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.ping";
      asd = "cl-mw.examples.ping";
    });
    systems = [ "cl-mw.examples.ping" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mw_dot_examples_dot_with-task-policy = (build-asdf-system {
    pname = "cl-mw.examples.with-task-policy";
    version = "20150407-git";
    asds = [ "cl-mw.examples.with-task-policy" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mw/2015-04-07/cl-mw-20150407-git.tgz";
      sha256 = "1bpkpb86hpp7sz9mk19rbdlfcis2npc3a7w6jlph7s8brxl1h1jn";
      system = "cl-mw.examples.with-task-policy";
      asd = "cl-mw.examples.with-task-policy";
    });
    systems = [ "cl-mw.examples.with-task-policy" ];
    lispLibs = [ (getAttr "cl-mw" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-myriam = (build-asdf-system {
    pname = "cl-myriam";
    version = "20220331-git";
    asds = [ "cl-myriam" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-myriam/2022-03-31/cl-myriam-20220331-git.tgz";
      sha256 = "0vyyyy6yj62id5m1a98rbq3pz7hm74znnawxh4apqhrff37xcs1l";
      system = "cl-myriam";
      asd = "cl-myriam";
    });
    systems = [ "cl-myriam" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "bordeaux-threads" self) (getAttr "cl-conspack" self) (getAttr "cl-ppcre" self) (getAttr "lparallel" self) (getAttr "pzmq" self) (getAttr "serapeum" self) (getAttr "sha3" self) (getAttr "str" self) (getAttr "usocket" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-mysql = (build-asdf-system {
    pname = "cl-mysql";
    version = "20200610-git";
    asds = [ "cl-mysql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mysql/2020-06-10/cl-mysql-20200610-git.tgz";
      sha256 = "1jk2571w5zhrmza4mr5z4ia6g7r5hzhp8dsxnpx2ypnla9xpxv5h";
      system = "cl-mysql";
      asd = "cl-mysql";
    });
    systems = [ "cl-mysql" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {};
  });
  cl-mysql-test = (build-asdf-system {
    pname = "cl-mysql-test";
    version = "20200610-git";
    asds = [ "cl-mysql-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-mysql/2020-06-10/cl-mysql-20200610-git.tgz";
      sha256 = "1jk2571w5zhrmza4mr5z4ia6g7r5hzhp8dsxnpx2ypnla9xpxv5h";
      system = "cl-mysql-test";
      asd = "cl-mysql-test";
    });
    systems = [ "cl-mysql-test" ];
    lispLibs = [ (getAttr "cl-mysql" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store = (build-asdf-system {
    pname = "cl-naive-store";
    version = "20230618-git";
    asds = [ "cl-naive-store" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store";
      asd = "cl-naive-store";
    });
    systems = [ "cl-naive-store" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_document-type-defs" self) (getAttr "cl-naive-store_dot_document-types" self) (getAttr "cl-naive-store_dot_naive-core" self) (getAttr "cl-naive-store_dot_naive-documents" self) (getAttr "cl-naive-store_dot_naive-indexed" self) (getAttr "cl-naive-store_dot_naive-merkle" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_document-type-defs = (build-asdf-system {
    pname = "cl-naive-store.document-type-defs";
    version = "20230618-git";
    asds = [ "cl-naive-store.document-type-defs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.document-type-defs";
      asd = "cl-naive-store.document-type-defs";
    });
    systems = [ "cl-naive-store.document-type-defs" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_document-types" self) (getAttr "cl-naive-store_dot_naive-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_document-types = (build-asdf-system {
    pname = "cl-naive-store.document-types";
    version = "20230618-git";
    asds = [ "cl-naive-store.document-types" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.document-types";
      asd = "cl-naive-store.document-types";
    });
    systems = [ "cl-naive-store.document-types" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_naive-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_naive-core = (build-asdf-system {
    pname = "cl-naive-store.naive-core";
    version = "20230618-git";
    asds = [ "cl-naive-store.naive-core" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.naive-core";
      asd = "cl-naive-store.naive-core";
    });
    systems = [ "cl-naive-store.naive-core" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-cpus" self) (getAttr "cl-fad" self) (getAttr "cl-getx" self) (getAttr "cl-murmurhash" self) (getAttr "ironclad" self) (getAttr "local-time" self) (getAttr "lparallel" self) (getAttr "split-sequence" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_naive-documents = (build-asdf-system {
    pname = "cl-naive-store.naive-documents";
    version = "20230618-git";
    asds = [ "cl-naive-store.naive-documents" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.naive-documents";
      asd = "cl-naive-store.naive-documents";
    });
    systems = [ "cl-naive-store.naive-documents" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_document-type-defs" self) (getAttr "cl-naive-store_dot_document-types" self) (getAttr "cl-naive-store_dot_naive-core" self) (getAttr "cl-naive-store_dot_naive-indexed" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_naive-indexed = (build-asdf-system {
    pname = "cl-naive-store.naive-indexed";
    version = "20230618-git";
    asds = [ "cl-naive-store.naive-indexed" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.naive-indexed";
      asd = "cl-naive-store.naive-indexed";
    });
    systems = [ "cl-naive-store.naive-indexed" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_naive-core" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_naive-merkle = (build-asdf-system {
    pname = "cl-naive-store.naive-merkle";
    version = "20230618-git";
    asds = [ "cl-naive-store.naive-merkle" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.naive-merkle";
      asd = "cl-naive-store.naive-merkle";
    });
    systems = [ "cl-naive-store.naive-merkle" ];
    lispLibs = [ (getAttr "cl-naive-store_dot_naive-documents" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-naive-store_dot_test = (build-asdf-system {
    pname = "cl-naive-store.test";
    version = "20230618-git";
    asds = [ "cl-naive-store.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-naive-store/2023-06-18/cl-naive-store-20230618-git.tgz";
      sha256 = "0z9f1hfm63idnivcymzlimqmrdrr87p88vcajq83nhhhqjr6jc9w";
      system = "cl-naive-store.test";
      asd = "cl-naive-store.test";
    });
    systems = [ "cl-naive-store.test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-naive-store" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ncurses = (build-asdf-system {
    pname = "cl-ncurses";
    version = "0.1.4";
    asds = [ "cl-ncurses" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ncurses/2010-10-06/cl-ncurses_0.1.4.tgz";
      sha256 = "1frcap93i4ni3d648rrbnjjpz7p4cxlv57mmzlpxpzchzbcga026";
      system = "cl-ncurses";
      asd = "cl-ncurses";
    });
    systems = [ "cl-ncurses" ];
    lispLibs = [ (getAttr "uffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-neo4j = (build-asdf-system {
    pname = "cl-neo4j";
    version = "release-b8ad637a-git";
    asds = [ "cl-neo4j" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-neo4j/2013-01-28/cl-neo4j-release-b8ad637a-git.tgz";
      sha256 = "061xqjn08aqynfqygk48pwjp1d1mnhcb6fnl4lcfyw261dxsp871";
      system = "cl-neo4j";
      asd = "cl-neo4j";
    });
    systems = [ "cl-neo4j" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "babel" self) (getAttr "cl-json" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-neo4j_dot_tests = (build-asdf-system {
    pname = "cl-neo4j.tests";
    version = "release-b8ad637a-git";
    asds = [ "cl-neo4j.tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-neo4j/2013-01-28/cl-neo4j-release-b8ad637a-git.tgz";
      sha256 = "061xqjn08aqynfqygk48pwjp1d1mnhcb6fnl4lcfyw261dxsp871";
      system = "cl-neo4j.tests";
      asd = "cl-neo4j";
    });
    systems = [ "cl-neo4j.tests" ];
    lispLibs = [ (getAttr "cl-neo4j" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-neovim = (build-asdf-system {
    pname = "cl-neovim";
    version = "20190521-git";
    asds = [ "cl-neovim" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-neovim/2019-05-21/cl-neovim-20190521-git.tgz";
      sha256 = "06hy30px9cppqzh0c8nkbyysbpw2l247r4g43wfw96rflrdwy6ks";
      system = "cl-neovim";
      asd = "cl-neovim";
    });
    systems = [ "cl-neovim" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-messagepack-rpc" self) (getAttr "form-fiddle" self) (getAttr "split-sequence" self) (getAttr "vom" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-netpbm = (build-asdf-system {
    pname = "cl-netpbm";
    version = "20201016-hg";
    asds = [ "cl-netpbm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-netpbm/2020-10-16/cl-netpbm-20201016-hg.tgz";
      sha256 = "1xhpyn7nkadvbv8n7sbjyfj9qzr90p66dhq1j9f0jj4lmarp8anp";
      system = "cl-netpbm";
      asd = "cl-netpbm";
    });
    systems = [ "cl-netpbm" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-netstring_plus = (build-asdf-system {
    pname = "cl-netstring+";
    version = "20150709-git";
    asds = [ "cl-netstring+" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-netstring-plus/2015-07-09/cl-netstring-plus-20150709-git.tgz";
      sha256 = "03nxhgkab8lsx8mvavd4yny1894yxl5bllvqb12hyjdgg1v8whrr";
      system = "cl-netstring+";
      asd = "cl-netstring+";
    });
    systems = [ "cl-netstring+" ];
    lispLibs = [ (getAttr "flexi-streams" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-netstrings = (build-asdf-system {
    pname = "cl-netstrings";
    version = "20121013-git";
    asds = [ "cl-netstrings" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-netstrings/2012-10-13/cl-netstrings-20121013-git.tgz";
      sha256 = "1mprrb8i3fjpmw7w461ib8zrcjwx77sqwaxyqq7i8yqkbhk7p1ql";
      system = "cl-netstrings";
      asd = "cl-netstrings";
    });
    systems = [ "cl-netstrings" ];
    lispLibs = [ (getAttr "arnesi" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-notebook = (build-asdf-system {
    pname = "cl-notebook";
    version = "20201220-git";
    asds = [ "cl-notebook" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-notebook/2020-12-20/cl-notebook-20201220-git.tgz";
      sha256 = "0kg5wdclz9i64gcx27z5bs739hsvjrfl9kf1awi31x4142yxrva8";
      system = "cl-notebook";
      asd = "cl-notebook";
    });
    systems = [ "cl-notebook" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cl-css" self) (getAttr "cl-fad" self) (getAttr "cl-who" self) (getAttr "closer-mop" self) (getAttr "fact-base" self) (getAttr "house" self) (getAttr "parenscript" self) (getAttr "prove-asdf" self) (getAttr "qlot" self) (getAttr "quri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ntp-client = (build-asdf-system {
    pname = "cl-ntp-client";
    version = "20210630-git";
    asds = [ "cl-ntp-client" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ntp-client/2021-06-30/cl-ntp-client-20210630-git.tgz";
      sha256 = "1mc16bvs0l8srnxjcjg4m192rw5waq291zks2jslxmxij0pa28cm";
      system = "cl-ntp-client";
      asd = "cl-ntp-client";
    });
    systems = [ "cl-ntp-client" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ntriples = (build-asdf-system {
    pname = "cl-ntriples";
    version = "20190307-hg";
    asds = [ "cl-ntriples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ntriples/2019-03-07/cl-ntriples-20190307-hg.tgz";
      sha256 = "0k8q2r2nxkgxp91398gb0iwfy9kd2mn519nxxa3zq831c433l2mq";
      system = "cl-ntriples";
      asd = "cl-ntriples";
    });
    systems = [ "cl-ntriples" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oauth = (build-asdf-system {
    pname = "cl-oauth";
    version = "20150804-git";
    asds = [ "cl-oauth" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-oauth/2015-08-04/cl-oauth-20150804-git.tgz";
      sha256 = "1q4r5i3099684q5x9wqddrm9g88qm16nnra9glvxngywfjc5zzkk";
      system = "cl-oauth";
      asd = "cl-oauth";
    });
    systems = [ "cl-oauth" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "babel" self) (getAttr "cl-base64" self) (getAttr "closer-mop" self) (getAttr "drakma" self) (getAttr "f-underscore" self) (getAttr "hunchentoot" self) (getAttr "ironclad" self) (getAttr "puri" self) (getAttr "split-sequence" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oauth_dot_tests = (build-asdf-system {
    pname = "cl-oauth.tests";
    version = "20150804-git";
    asds = [ "cl-oauth.tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-oauth/2015-08-04/cl-oauth-20150804-git.tgz";
      sha256 = "1q4r5i3099684q5x9wqddrm9g88qm16nnra9glvxngywfjc5zzkk";
      system = "cl-oauth.tests";
      asd = "cl-oauth";
    });
    systems = [ "cl-oauth.tests" ];
    lispLibs = [ (getAttr "cl-oauth" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oclapi = (build-asdf-system {
    pname = "cl-oclapi";
    version = "20180831-git";
    asds = [ "cl-oclapi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-oclapi/2018-08-31/cl-oclapi-20180831-git.tgz";
      sha256 = "0aix5ipw98fsnvg1w7qmrjbwgn70gn7vf5av21xsgblp2sd7w2aw";
      system = "cl-oclapi";
      asd = "cl-oclapi";
    });
    systems = [ "cl-oclapi" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-annot" self) (getAttr "cl-reexport" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oclapi-test = (build-asdf-system {
    pname = "cl-oclapi-test";
    version = "20180831-git";
    asds = [ "cl-oclapi-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-oclapi/2018-08-31/cl-oclapi-20180831-git.tgz";
      sha256 = "0aix5ipw98fsnvg1w7qmrjbwgn70gn7vf5av21xsgblp2sd7w2aw";
      system = "cl-oclapi-test";
      asd = "cl-oclapi-test";
    });
    systems = [ "cl-oclapi-test" ];
    lispLibs = [ (getAttr "cl-annot" self) (getAttr "cl-oclapi" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-octet-streams = (build-asdf-system {
    pname = "cl-octet-streams";
    version = "20201220-git";
    asds = [ "cl-octet-streams" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-octet-streams/2020-12-20/cl-octet-streams-20201220-git.tgz";
      sha256 = "1hffh98bv4w5yrchagzwqrc43d2p473pvw7ka4kyyvhrr52dk2f8";
      system = "cl-octet-streams";
      asd = "cl-octet-streams";
    });
    systems = [ "cl-octet-streams" ];
    lispLibs = [ (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ode = (build-asdf-system {
    pname = "cl-ode";
    version = "20160628-git";
    asds = [ "cl-ode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ode/2016-06-28/cl-ode-20160628-git.tgz";
      sha256 = "1pxm2pq0br0rhdfnvs5jqfkxfs8bc9wdqrzwyv83l8n7pax941b0";
      system = "cl-ode";
      asd = "cl-ode";
    });
    systems = [ "cl-ode" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ohm = (build-asdf-system {
    pname = "cl-ohm";
    version = "20180228-git";
    asds = [ "cl-ohm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ohm/2018-02-28/cl-ohm-20180228-git.tgz";
      sha256 = "00gdfsiba761gk7xw91wfnr9yv84maagf9idh55bk5bs4ws1ymyp";
      system = "cl-ohm";
      asd = "cl-ohm";
    });
    systems = [ "cl-ohm" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-redis" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oju = (build-asdf-system {
    pname = "cl-oju";
    version = "20230214-git";
    asds = [ "cl-oju" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-oju/2023-02-14/cl-oju-20230214-git.tgz";
      sha256 = "0pcb659m487w4nv3m0ryl0fbwdgc1vdz06hsm4l1gwi3w9gcq477";
      system = "cl-oju";
      asd = "cl-oju";
    });
    systems = [ "cl-oju" ];
    lispLibs = [ (getAttr "_1am" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-olefs = (build-asdf-system {
    pname = "cl-olefs";
    version = "20150709-git";
    asds = [ "cl-olefs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-olefs/2015-07-09/cl-olefs-20150709-git.tgz";
      sha256 = "0cqna6zzfrjmsq17yc4wg204kr77riczqjpm1w5cj1mba43zcac7";
      system = "cl-olefs";
      asd = "cl-olefs";
    });
    systems = [ "cl-olefs" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-one-time-passwords = (build-asdf-system {
    pname = "cl-one-time-passwords";
    version = "20171019-git";
    asds = [ "cl-one-time-passwords" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-one-time-passwords/2017-10-19/cl-one-time-passwords-20171019-git.tgz";
      sha256 = "1nhq2jij257cfaadh9k421qaisicxpmx3wsc4kivf1psgbrc56lg";
      system = "cl-one-time-passwords";
      asd = "cl-one-time-passwords";
    });
    systems = [ "cl-one-time-passwords" ];
    lispLibs = [ (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-one-time-passwords-test = (build-asdf-system {
    pname = "cl-one-time-passwords-test";
    version = "20171019-git";
    asds = [ "cl-one-time-passwords-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-one-time-passwords/2017-10-19/cl-one-time-passwords-20171019-git.tgz";
      sha256 = "1nhq2jij257cfaadh9k421qaisicxpmx3wsc4kivf1psgbrc56lg";
      system = "cl-one-time-passwords-test";
      asd = "cl-one-time-passwords-test";
    });
    systems = [ "cl-one-time-passwords-test" ];
    lispLibs = [ (getAttr "cl-one-time-passwords" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-oneliner = (build-asdf-system {
    pname = "cl-oneliner";
    version = "20131003-git";
    asds = [ "cl-oneliner" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/oneliner/2013-10-03/oneliner-20131003-git.tgz";
      sha256 = "0q9350s0r9yjmfc2360g35qi04b3867gd7hw5ada4176whinmjxb";
      system = "cl-oneliner";
      asd = "cl-oneliner";
    });
    systems = [ "cl-oneliner" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "lisp-unit" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-online-learning = (build-asdf-system {
    pname = "cl-online-learning";
    version = "20220331-git";
    asds = [ "cl-online-learning" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-online-learning/2022-03-31/cl-online-learning-20220331-git.tgz";
      sha256 = "136v9kxcy53qar2j4y38awnw2idnf0lwxqwx7wgak664w3hxs6k8";
      system = "cl-online-learning";
      asd = "cl-online-learning";
    });
    systems = [ "cl-online-learning" ];
    lispLibs = [ (getAttr "cl-libsvm-format" self) (getAttr "cl-store" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-online-learning-test = (build-asdf-system {
    pname = "cl-online-learning-test";
    version = "20220331-git";
    asds = [ "cl-online-learning-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-online-learning/2022-03-31/cl-online-learning-20220331-git.tgz";
      sha256 = "136v9kxcy53qar2j4y38awnw2idnf0lwxqwx7wgak664w3hxs6k8";
      system = "cl-online-learning-test";
      asd = "cl-online-learning-test";
    });
    systems = [ "cl-online-learning-test" ];
    lispLibs = [ (getAttr "cl-online-learning" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-openal = (build-asdf-system {
    pname = "cl-openal";
    version = "20221106-git";
    asds = [ "cl-openal" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openal/2022-11-06/cl-openal-20221106-git.tgz";
      sha256 = "0jmp81mf23ckcm4knnh0q7zpmyls5220imaqbmnl0xvvra10b1zy";
      system = "cl-openal";
      asd = "cl-openal";
    });
    systems = [ "cl-openal" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-openal-examples = (build-asdf-system {
    pname = "cl-openal-examples";
    version = "20221106-git";
    asds = [ "cl-openal-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openal/2022-11-06/cl-openal-20221106-git.tgz";
      sha256 = "0jmp81mf23ckcm4knnh0q7zpmyls5220imaqbmnl0xvvra10b1zy";
      system = "cl-openal-examples";
      asd = "cl-openal-examples";
    });
    systems = [ "cl-openal-examples" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-alc" self) (getAttr "cl-alut" self) (getAttr "cl-openal" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opencl = (build-asdf-system {
    pname = "cl-opencl";
    version = "20211209-git";
    asds = [ "cl-opencl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opencl/2021-12-09/cl-opencl-20211209-git.tgz";
      sha256 = "1agg6rg7lsbq2jgarx25bwm1nw22jpl20bzhyn4ivygcgzp2mv29";
      system = "cl-opencl";
      asd = "cl-opencl";
    });
    systems = [ "cl-opencl" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opencl-utils = (build-asdf-system {
    pname = "cl-opencl-utils";
    version = "20230214-git";
    asds = [ "cl-opencl-utils" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opencl-utils/2023-02-14/cl-opencl-utils-20230214-git.tgz";
      sha256 = "17l4wsvhjj3zvhl5nsigh9fwnv7s7xiqfk2998gh86j32a02r95y";
      system = "cl-opencl-utils";
      asd = "cl-opencl-utils";
    });
    systems = [ "cl-opencl-utils" ];
    lispLibs = [ (getAttr "cl-opencl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opengl = (build-asdf-system {
    pname = "cl-opengl";
    version = "20191130-git";
    asds = [ "cl-opengl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opengl/2019-11-30/cl-opengl-20191130-git.tgz";
      sha256 = "0mhqmll09f079pnd6mgswz9nvr6h5n27d4q7zpmm2igf1v460id7";
      system = "cl-opengl";
      asd = "cl-opengl";
    });
    systems = [ "cl-opengl" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "float-features" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opensearch-query-builder = (build-asdf-system {
    pname = "cl-opensearch-query-builder";
    version = "20230618-git";
    asds = [ "cl-opensearch-query-builder" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opensearch-query-builder/2023-06-18/cl-opensearch-query-builder-20230618-git.tgz";
      sha256 = "0sdhp5517ikh40gd8m8qw2jczr0nd7c4i5r31kssx7763zq968i5";
      system = "cl-opensearch-query-builder";
      asd = "cl-opensearch-query-builder";
    });
    systems = [ "cl-opensearch-query-builder" ];
    lispLibs = [ (getAttr "com_dot_inuoe_dot_jzon" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-openstack-client = (build-asdf-system {
    pname = "cl-openstack-client";
    version = "20191007-git";
    asds = [ "cl-openstack-client" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openstack-client/2019-10-07/cl-openstack-client-20191007-git.tgz";
      sha256 = "1sak75i82vn3acg7bxx8vjbw2y35wbq1vkh1yqhs68ksnph6d097";
      system = "cl-openstack-client";
      asd = "cl-openstack-client";
    });
    systems = [ "cl-openstack-client" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-json" self) (getAttr "drakma" self) (getAttr "local-time" self) (getAttr "uri-template" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-openstack-client-test = (build-asdf-system {
    pname = "cl-openstack-client-test";
    version = "20191007-git";
    asds = [ "cl-openstack-client-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-openstack-client/2019-10-07/cl-openstack-client-20191007-git.tgz";
      sha256 = "1sak75i82vn3acg7bxx8vjbw2y35wbq1vkh1yqhs68ksnph6d097";
      system = "cl-openstack-client-test";
      asd = "cl-openstack-client-test";
    });
    systems = [ "cl-openstack-client-test" ];
    lispLibs = [ (getAttr "chunga" self) (getAttr "cl-openstack-client" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "fiveam" self) (getAttr "flexi-streams" self) (getAttr "local-time" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opsresearch = (build-asdf-system {
    pname = "cl-opsresearch";
    version = "20170403-git";
    asds = [ "cl-opsresearch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opsresearch/2017-04-03/cl-opsresearch-20170403-git.tgz";
      sha256 = "1fipw6qjggswzcg8ifwx5qnhnc7mmi53s6h14l0vzj6afa5rdpm7";
      system = "cl-opsresearch";
      asd = "cl-opsresearch";
    });
    systems = [ "cl-opsresearch" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-opus = (build-asdf-system {
    pname = "cl-opus";
    version = "20230618-git";
    asds = [ "cl-opus" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-opus/2023-06-18/cl-opus-20230618-git.tgz";
      sha256 = "1xclwnmx6vjmiznjwgwdfzh192f3hpfm234lc0j0sjxhk7a547z7";
      system = "cl-opus";
      asd = "cl-opus";
    });
    systems = [ "cl-opus" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "static-vectors" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-org-mode = (build-asdf-system {
    pname = "cl-org-mode";
    version = "20101207-git";
    asds = [ "cl-org-mode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-org-mode/2010-12-07/cl-org-mode-20101207-git.tgz";
      sha256 = "1fvwl9jlbpd352b5zn2d45mabsim5xvzabwyz1h10hwv4gviymzf";
      system = "cl-org-mode";
      asd = "cl-org-mode";
    });
    systems = [ "cl-org-mode" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-out123 = (build-asdf-system {
    pname = "cl-out123";
    version = "20230618-git";
    asds = [ "cl-out123" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-out123/2023-06-18/cl-out123-20230618-git.tgz";
      sha256 = "0ahgc5l5lbpl3ini4pn5crh8b7dlr386pxczl0d4h6djhccxzs4w";
      system = "cl-out123";
      asd = "cl-out123";
    });
    systems = [ "cl-out123" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pack = (build-asdf-system {
    pname = "cl-pack";
    version = "20200427-git";
    asds = [ "cl-pack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pack/2020-04-27/cl-pack-20200427-git.tgz";
      sha256 = "0q7gawy0cwy49m1mxgj0jqnzzckk2ps74ncfaw1pqiqilfyx7np6";
      system = "cl-pack";
      asd = "cl-pack";
    });
    systems = [ "cl-pack" ];
    lispLibs = [ (getAttr "ieee-floats" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pack-test = (build-asdf-system {
    pname = "cl-pack-test";
    version = "20200427-git";
    asds = [ "cl-pack-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pack/2020-04-27/cl-pack-20200427-git.tgz";
      sha256 = "0q7gawy0cwy49m1mxgj0jqnzzckk2ps74ncfaw1pqiqilfyx7np6";
      system = "cl-pack-test";
      asd = "cl-pack";
    });
    systems = [ "cl-pack-test" ];
    lispLibs = [ (getAttr "cl-pack" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-package-locks = (build-asdf-system {
    pname = "cl-package-locks";
    version = "20111203-git";
    asds = [ "cl-package-locks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-package-locks/2011-12-03/cl-package-locks-20111203-git.tgz";
      sha256 = "0g3gfljnvpgd66ccd2sqawlkwqx4a0wsdrg5180va61w869cgxqq";
      system = "cl-package-locks";
      asd = "cl-package-locks";
    });
    systems = [ "cl-package-locks" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pango = (build-asdf-system {
    pname = "cl-pango";
    version = "20170403-git";
    asds = [ "cl-pango" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pango/2017-04-03/cl-pango-20170403-git.tgz";
      sha256 = "0zkn4yn8nkkjr0x1vcy856cvbmnyhdidqz0in8xvd2i93jvw5w0i";
      system = "cl-pango";
      asd = "cl-pango";
    });
    systems = [ "cl-pango" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-cairo2" self) (getAttr "xmls" self) ];
    meta = {};
  });
  cl-parallel = (build-asdf-system {
    pname = "cl-parallel";
    version = "20130312-git";
    asds = [ "cl-parallel" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-parallel/2013-03-12/cl-parallel-20130312-git.tgz";
      sha256 = "1hmkcbwkj7rx8zg5wf2w06nvbabldpr7hbbg1ycj0fss86s2cx2c";
      system = "cl-parallel";
      asd = "cl-parallel";
    });
    systems = [ "cl-parallel" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pass = (build-asdf-system {
    pname = "cl-pass";
    version = "20201220-git";
    asds = [ "cl-pass" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pass/2020-12-20/cl-pass-20201220-git.tgz";
      sha256 = "05qx4jrkxqbqi72cxgswbpnifbdvp9mh7apc7566v522899bh0hb";
      system = "cl-pass";
      asd = "cl-pass";
    });
    systems = [ "cl-pass" ];
    lispLibs = [ (getAttr "ironclad" self) (getAttr "split-sequence" self) (getAttr "trivial-utf-8" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pass-test = (build-asdf-system {
    pname = "cl-pass-test";
    version = "20201220-git";
    asds = [ "cl-pass-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pass/2020-12-20/cl-pass-20201220-git.tgz";
      sha256 = "05qx4jrkxqbqi72cxgswbpnifbdvp9mh7apc7566v522899bh0hb";
      system = "cl-pass-test";
      asd = "cl-pass-test";
    });
    systems = [ "cl-pass-test" ];
    lispLibs = [ (getAttr "cl-pass" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-paths = (build-asdf-system {
    pname = "cl-paths";
    version = "20180228-git";
    asds = [ "cl-paths" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vectors/2018-02-28/cl-vectors-20180228-git.tgz";
      sha256 = "0nckw4zb6s96hll8hrxzvgs2an3bfm0pxcywshbm4bq4rn7niqg4";
      system = "cl-paths";
      asd = "cl-paths";
    });
    systems = [ "cl-paths" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-paths-ttf = (build-asdf-system {
    pname = "cl-paths-ttf";
    version = "20180228-git";
    asds = [ "cl-paths-ttf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vectors/2018-02-28/cl-vectors-20180228-git.tgz";
      sha256 = "0nckw4zb6s96hll8hrxzvgs2an3bfm0pxcywshbm4bq4rn7niqg4";
      system = "cl-paths-ttf";
      asd = "cl-paths-ttf";
    });
    systems = [ "cl-paths-ttf" ];
    lispLibs = [ (getAttr "cl-paths" self) (getAttr "zpb-ttf" self) ];
    meta = {};
  });
  cl-pattern = (build-asdf-system {
    pname = "cl-pattern";
    version = "20140713-git";
    asds = [ "cl-pattern" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pattern/2014-07-13/cl-pattern-20140713-git.tgz";
      sha256 = "0kc1yynn1ysa7bcaazhi1pq8l3hj3jq6p835kh5di7g1imrfkrny";
      system = "cl-pattern";
      asd = "cl-pattern";
    });
    systems = [ "cl-pattern" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-annot" self) (getAttr "cl-syntax" self) (getAttr "cl-syntax-annot" self) ];
    meta = {};
  });
  cl-pattern-benchmark = (build-asdf-system {
    pname = "cl-pattern-benchmark";
    version = "20140713-git";
    asds = [ "cl-pattern-benchmark" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pattern/2014-07-13/cl-pattern-20140713-git.tgz";
      sha256 = "0kc1yynn1ysa7bcaazhi1pq8l3hj3jq6p835kh5di7g1imrfkrny";
      system = "cl-pattern-benchmark";
      asd = "cl-pattern-benchmark";
    });
    systems = [ "cl-pattern-benchmark" ];
    lispLibs = [ (getAttr "cl-pattern" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-patterns = (build-asdf-system {
    pname = "cl-patterns";
    version = "20230618-git";
    asds = [ "cl-patterns" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-patterns/2023-06-18/cl-patterns-20230618-git.tgz";
      sha256 = "1vra1wbflwzm4d9b1b3id4wk5jhqgi6cypgjkghsj0yw4rkccvhc";
      system = "cl-patterns";
      asd = "cl-patterns";
    });
    systems = [ "cl-patterns" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "closer-mop" self) (getAttr "dissect" self) (getAttr "local-time" self) (getAttr "mutility" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-paymill = (build-asdf-system {
    pname = "cl-paymill";
    version = "20131111-git";
    asds = [ "cl-paymill" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-paymill/2013-11-11/cl-paymill-20131111-git.tgz";
      sha256 = "1dhddmw7gxfxbv1vfqi6nzyh8m5n3b160ch6ianf5sn6apmi92nw";
      system = "cl-paymill";
      asd = "cl-paymill";
    });
    systems = [ "cl-paymill" ];
    lispLibs = [ (getAttr "cl_plus_ssl" self) (getAttr "drakma" self) (getAttr "st-json" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-paypal = (build-asdf-system {
    pname = "cl-paypal";
    version = "20101006-git";
    asds = [ "cl-paypal" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-paypal/2010-10-06/cl-paypal-20101006-git.tgz";
      sha256 = "0cc6zv17klgiyj1mbbrkbvajkr6dwsjv3iilh57vhdqd01lrhnb2";
      system = "cl-paypal";
      asd = "cl-paypal";
    });
    systems = [ "cl-paypal" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "hunchentoot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pcg = (build-asdf-system {
    pname = "cl-pcg";
    version = "20201016-hg";
    asds = [ "cl-pcg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pcg/2020-10-16/cl-pcg-20201016-hg.tgz";
      sha256 = "1w2b2y5fgjc6z8akvlmwasj90dnjv55nvb8pghq4xpv43hfy73mp";
      system = "cl-pcg";
      asd = "cl-pcg";
    });
    systems = [ "cl-pcg" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pcg_dot_test = (build-asdf-system {
    pname = "cl-pcg.test";
    version = "20201016-hg";
    asds = [ "cl-pcg.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pcg/2020-10-16/cl-pcg-20201016-hg.tgz";
      sha256 = "1w2b2y5fgjc6z8akvlmwasj90dnjv55nvb8pghq4xpv43hfy73mp";
      system = "cl-pcg.test";
      asd = "cl-pcg.test";
    });
    systems = [ "cl-pcg.test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "cl-pcg" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pdf = (build-asdf-system {
    pname = "cl-pdf";
    version = "20230214-git";
    asds = [ "cl-pdf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pdf/2023-02-14/cl-pdf-20230214-git.tgz";
      sha256 = "0j7hbqv6yzrgx0inqinpw8h22728l53ccciw6iymzz4g92j9fzlq";
      system = "cl-pdf";
      asd = "cl-pdf";
    });
    systems = [ "cl-pdf" ];
    lispLibs = [ (getAttr "iterate" self) (getAttr "zpb-ttf" self) ];
    meta = {};
  });
  cl-pdf-doc = (build-asdf-system {
    pname = "cl-pdf-doc";
    version = "20210531-git";
    asds = [ "cl-pdf-doc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-typesetting/2021-05-31/cl-typesetting-20210531-git.tgz";
      sha256 = "0fcs5mq0gxfczbrg7ay8r4bf5r4g6blvpdbjkhcl8dapcikyn35h";
      system = "cl-pdf-doc";
      asd = "cl-pdf-doc";
    });
    systems = [ "cl-pdf-doc" ];
    lispLibs = [ (getAttr "cl-pdf" self) (getAttr "cl-typesetting" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pdf-parser = (build-asdf-system {
    pname = "cl-pdf-parser";
    version = "20230214-git";
    asds = [ "cl-pdf-parser" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pdf/2023-02-14/cl-pdf-20230214-git.tgz";
      sha256 = "0j7hbqv6yzrgx0inqinpw8h22728l53ccciw6iymzz4g92j9fzlq";
      system = "cl-pdf-parser";
      asd = "cl-pdf-parser";
    });
    systems = [ "cl-pdf-parser" ];
    lispLibs = [ (getAttr "cl-pdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-performance-tuning-helper = (build-asdf-system {
    pname = "cl-performance-tuning-helper";
    version = "20130615-git";
    asds = [ "cl-performance-tuning-helper" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-performance-tuning-helper/2013-06-15/cl-performance-tuning-helper-20130615-git.tgz";
      sha256 = "1j0k319il271grm6hjqq2bazp5l105lazayqsmpsy8lsy4lmy0c3";
      system = "cl-performance-tuning-helper";
      asd = "cl-performance-tuning-helper";
    });
    systems = [ "cl-performance-tuning-helper" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-performance-tuning-helper-test = (build-asdf-system {
    pname = "cl-performance-tuning-helper-test";
    version = "20130615-git";
    asds = [ "cl-performance-tuning-helper-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-performance-tuning-helper/2013-06-15/cl-performance-tuning-helper-20130615-git.tgz";
      sha256 = "1j0k319il271grm6hjqq2bazp5l105lazayqsmpsy8lsy4lmy0c3";
      system = "cl-performance-tuning-helper-test";
      asd = "cl-performance-tuning-helper-test";
    });
    systems = [ "cl-performance-tuning-helper-test" ];
    lispLibs = [ (getAttr "cl-performance-tuning-helper" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-permutation = (build-asdf-system {
    pname = "cl-permutation";
    version = "20211209-git";
    asds = [ "cl-permutation" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-permutation/2021-12-09/cl-permutation-20211209-git.tgz";
      sha256 = "0i932g0k50y24hxizni6zfya4kcw77yk3b0llivm9g50s7fxj9dk";
      system = "cl-permutation";
      asd = "cl-permutation";
    });
    systems = [ "cl-permutation" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-fft" self) (getAttr "cl-algebraic-data-type" self) (getAttr "closer-mop" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-permutation-examples = (build-asdf-system {
    pname = "cl-permutation-examples";
    version = "20211209-git";
    asds = [ "cl-permutation-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-permutation/2021-12-09/cl-permutation-20211209-git.tgz";
      sha256 = "0i932g0k50y24hxizni6zfya4kcw77yk3b0llivm9g50s7fxj9dk";
      system = "cl-permutation-examples";
      asd = "cl-permutation-examples";
    });
    systems = [ "cl-permutation-examples" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-permutation" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-permutation-tests = (build-asdf-system {
    pname = "cl-permutation-tests";
    version = "20211209-git";
    asds = [ "cl-permutation-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-permutation/2021-12-09/cl-permutation-20211209-git.tgz";
      sha256 = "0i932g0k50y24hxizni6zfya4kcw77yk3b0llivm9g50s7fxj9dk";
      system = "cl-permutation-tests";
      asd = "cl-permutation-tests";
    });
    systems = [ "cl-permutation-tests" ];
    lispLibs = [ (getAttr "cl-permutation" self) (getAttr "cl-permutation-examples" self) (getAttr "fiasco" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-photo = (build-asdf-system {
    pname = "cl-photo";
    version = "20150923-git";
    asds = [ "cl-photo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-photo/2015-09-23/cl-photo-20150923-git.tgz";
      sha256 = "03rzsi1rqvlnw43z7kh5sy1h8gjxc5n0cfryfkkqnhym9q9186mj";
      system = "cl-photo";
      asd = "cl-photo";
    });
    systems = [ "cl-photo" ];
    lispLibs = [ (getAttr "kmrcl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-photo-tests = (build-asdf-system {
    pname = "cl-photo-tests";
    version = "20150923-git";
    asds = [ "cl-photo-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-photo/2015-09-23/cl-photo-20150923-git.tgz";
      sha256 = "03rzsi1rqvlnw43z7kh5sy1h8gjxc5n0cfryfkkqnhym9q9186mj";
      system = "cl-photo-tests";
      asd = "cl-photo-tests";
    });
    systems = [ "cl-photo-tests" ];
    lispLibs = [ (getAttr "cl-photo" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-plplot = (build-asdf-system {
    pname = "cl-plplot";
    version = "20180228-git";
    asds = [ "cl-plplot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-plplot/2018-02-28/cl-plplot-20180228-git.tgz";
      sha256 = "0hfgq47ga2r764jfc3ywaz5ynnvp701fjhbw0s4j1mrw4gaf6y6w";
      system = "cl-plplot";
      asd = "cl-plplot";
    });
    systems = [ "cl-plplot" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-plumbing = (build-asdf-system {
    pname = "cl-plumbing";
    version = "20181018-git";
    asds = [ "cl-plumbing" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-plumbing/2018-10-18/cl-plumbing-20181018-git.tgz";
      sha256 = "0bc4qqj0c4hghwx8jm3vg422c3i8livv3vvzfzi0gw79khaqdiyr";
      system = "cl-plumbing";
      asd = "cl-plumbing";
    });
    systems = [ "cl-plumbing" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "iterate" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-plumbing-test = (build-asdf-system {
    pname = "cl-plumbing-test";
    version = "20181018-git";
    asds = [ "cl-plumbing-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-plumbing/2018-10-18/cl-plumbing-20181018-git.tgz";
      sha256 = "0bc4qqj0c4hghwx8jm3vg422c3i8livv3vvzfzi0gw79khaqdiyr";
      system = "cl-plumbing-test";
      asd = "cl-plumbing-test";
    });
    systems = [ "cl-plumbing-test" ];
    lispLibs = [ (getAttr "cl-plumbing" self) (getAttr "iterate" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-plus-c = (build-asdf-system {
    pname = "cl-plus-c";
    version = "20221106-git";
    asds = [ "cl-plus-c" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-autowrap/2022-11-06/cl-autowrap-20221106-git.tgz";
      sha256 = "0pbabpmg61bflx6kxllqvhbvxqwjsik3nnynqdhgzzkgzk6jlixv";
      system = "cl-plus-c";
      asd = "cl-plus-c";
    });
    systems = [ "cl-plus-c" ];
    lispLibs = [ (getAttr "cl-autowrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ply = (build-asdf-system {
    pname = "cl-ply";
    version = "20150505-git";
    asds = [ "cl-ply" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ply/2015-05-05/cl-ply-20150505-git.tgz";
      sha256 = "1va3il5ahvziwm6i3f2zy3vchv0qkh1l7jci7gnfam43gf88fl12";
      system = "cl-ply";
      asd = "cl-ply";
    });
    systems = [ "cl-ply" ];
    lispLibs = [ (getAttr "cl-pattern" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ply-test = (build-asdf-system {
    pname = "cl-ply-test";
    version = "20150505-git";
    asds = [ "cl-ply-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ply/2015-05-05/cl-ply-20150505-git.tgz";
      sha256 = "1va3il5ahvziwm6i3f2zy3vchv0qkh1l7jci7gnfam43gf88fl12";
      system = "cl-ply-test";
      asd = "cl-ply-test";
    });
    systems = [ "cl-ply-test" ];
    lispLibs = [ (getAttr "cl-ply" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-poker-eval = (build-asdf-system {
    pname = "cl-poker-eval";
    version = "20150804-git";
    asds = [ "cl-poker-eval" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-poker-eval/2015-08-04/cl-poker-eval-20150804-git.tgz";
      sha256 = "1w4dsr4j7r3n7p0jbp8ccwwk83wcjjiz1rhhfrqpsd9v263v7kw8";
      system = "cl-poker-eval";
      asd = "cl-poker-eval";
    });
    systems = [ "cl-poker-eval" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pop = (build-asdf-system {
    pname = "cl-pop";
    version = "20110418-http";
    asds = [ "cl-pop" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pop/2011-04-18/cl-pop-20110418-http.tgz";
      sha256 = "1g47p9w2pzf7glx92cz859di9pz454xpaq97p76lcvyilxk6q819";
      system = "cl-pop";
      asd = "cl-pop";
    });
    systems = [ "cl-pop" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-portaudio = (build-asdf-system {
    pname = "cl-portaudio";
    version = "20201220-git";
    asds = [ "cl-portaudio" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-portaudio/2020-12-20/cl-portaudio-20201220-git.tgz";
      sha256 = "177c6bgf30caj5qpzfnzhbamax7c5zm2p4911mw7fay94vjs7zyb";
      system = "cl-portaudio";
      asd = "cl-portaudio";
    });
    systems = [ "cl-portaudio" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "ffa" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-postgres = (build-asdf-system {
    pname = "cl-postgres";
    version = "20230214-git";
    asds = [ "cl-postgres" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/postmodern/2023-02-14/postmodern-20230214-git.tgz";
      sha256 = "19pk3jinlv70arcz6073lglg4mf972h03rxynn4z9qabqc2gk9kw";
      system = "cl-postgres";
      asd = "cl-postgres";
    });
    systems = [ "cl-postgres" ];
    lispLibs = [ (getAttr "cl-base64" self) (getAttr "ironclad" self) (getAttr "md5" self) (getAttr "split-sequence" self) (getAttr "uax-15" self) ];
    meta = {};
  });
  cl-postgres_plus_local-time = (build-asdf-system {
    pname = "cl-postgres+local-time";
    version = "20230214-git";
    asds = [ "cl-postgres+local-time" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/local-time/2023-02-14/local-time-20230214-git.tgz";
      sha256 = "1dbp33zmkqzzshmf5k76pxqgli285wvy0p0dhcz816fdikpwn2jg";
      system = "cl-postgres+local-time";
      asd = "cl-postgres+local-time";
    });
    systems = [ "cl-postgres+local-time" ];
    lispLibs = [ (getAttr "cl-postgres" self) (getAttr "local-time" self) ];
    meta = {};
  });
  cl-postgres_plus_local-time-duration = (build-asdf-system {
    pname = "cl-postgres+local-time-duration";
    version = "20180430-git";
    asds = [ "cl-postgres+local-time-duration" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/local-time-duration/2018-04-30/local-time-duration-20180430-git.tgz";
      sha256 = "0f13mg18lv31lclz9jvqyj8d85p1jj1366nlld8m3dxnnwsbbkd6";
      system = "cl-postgres+local-time-duration";
      asd = "cl-postgres+local-time-duration";
    });
    systems = [ "cl-postgres+local-time-duration" ];
    lispLibs = [ (getAttr "cl-postgres" self) (getAttr "local-time-duration" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-postgres-datetime = (build-asdf-system {
    pname = "cl-postgres-datetime";
    version = "20190521-git";
    asds = [ "cl-postgres-datetime" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-postgres-datetime/2019-05-21/cl-postgres-datetime-20190521-git.tgz";
      sha256 = "1vwv5j1i968927j070bagqx9i114a8phmx7k9ankj9j5zg5dj0l3";
      system = "cl-postgres-datetime";
      asd = "cl-postgres-datetime";
    });
    systems = [ "cl-postgres-datetime" ];
    lispLibs = [ (getAttr "cl-postgres" self) (getAttr "local-time" self) (getAttr "simple-date" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-postgres-plus-uuid = (build-asdf-system {
    pname = "cl-postgres-plus-uuid";
    version = "20181018-git";
    asds = [ "cl-postgres-plus-uuid" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-postgres-plus-uuid/2018-10-18/cl-postgres-plus-uuid-20181018-git.tgz";
      sha256 = "1iw11v67gpwgpa5dw3d7chjmkc4d7sdwrqvnx0vg0m2qf4j7azmi";
      system = "cl-postgres-plus-uuid";
      asd = "cl-postgres-plus-uuid";
    });
    systems = [ "cl-postgres-plus-uuid" ];
    lispLibs = [ (getAttr "cl-postgres" self) (getAttr "uuid" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ppcre = (build-asdf-system {
    pname = "cl-ppcre";
    version = "20230618-git";
    asds = [ "cl-ppcre" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ppcre/2023-06-18/cl-ppcre-20230618-git.tgz";
      sha256 = "1l9q5bz9i8n241fcjfj5a769y0n4iybkv4zjhkf7dap5dmjyxwjr";
      system = "cl-ppcre";
      asd = "cl-ppcre";
    });
    systems = [ "cl-ppcre" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-ppcre-template = (build-asdf-system {
    pname = "cl-ppcre-template";
    version = "20230214-git";
    asds = [ "cl-ppcre-template" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unification/2023-02-14/cl-unification-20230214-git.tgz";
      sha256 = "1ngb74ngn9j6pxkp0nddgnq32jpkr2gvnb71swvziqic1d93194l";
      system = "cl-ppcre-template";
      asd = "cl-ppcre-template";
    });
    systems = [ "cl-ppcre-template" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-unification" self) ];
    meta = {};
  });
  cl-ppcre-unicode = (build-asdf-system {
    pname = "cl-ppcre-unicode";
    version = "20230618-git";
    asds = [ "cl-ppcre-unicode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ppcre/2023-06-18/cl-ppcre-20230618-git.tgz";
      sha256 = "1l9q5bz9i8n241fcjfj5a769y0n4iybkv4zjhkf7dap5dmjyxwjr";
      system = "cl-ppcre-unicode";
      asd = "cl-ppcre-unicode";
    });
    systems = [ "cl-ppcre-unicode" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-unicode" self) ];
    meta = {};
  });
  cl-prevalence = (build-asdf-system {
    pname = "cl-prevalence";
    version = "20230214-git";
    asds = [ "cl-prevalence" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prevalence/2023-02-14/cl-prevalence-20230214-git.tgz";
      sha256 = "1lb957ivshgp56phqhvhsmnc4r55x5shvi3mpsan2xsm4hvqspp0";
      system = "cl-prevalence";
      asd = "cl-prevalence";
    });
    systems = [ "cl-prevalence" ];
    lispLibs = [ (getAttr "moptilities" self) (getAttr "s-sysdeps" self) (getAttr "s-xml" self) ];
    meta = {};
  });
  cl-prevalence-test = (build-asdf-system {
    pname = "cl-prevalence-test";
    version = "20230214-git";
    asds = [ "cl-prevalence-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prevalence/2023-02-14/cl-prevalence-20230214-git.tgz";
      sha256 = "1lb957ivshgp56phqhvhsmnc4r55x5shvi3mpsan2xsm4hvqspp0";
      system = "cl-prevalence-test";
      asd = "cl-prevalence-test";
    });
    systems = [ "cl-prevalence-test" ];
    lispLibs = [ (getAttr "cl-prevalence" self) (getAttr "find-port" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-primality = (build-asdf-system {
    pname = "cl-primality";
    version = "20150608-git";
    asds = [ "cl-primality" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-primality/2015-06-08/cl-primality-20150608-git.tgz";
      sha256 = "1hvbsd5x7yrrrh7jjq0p8ign3ppzzpacmmz7nps60wgk38q1b618";
      system = "cl-primality";
      asd = "cl-primality";
    });
    systems = [ "cl-primality" ];
    lispLibs = [ (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-primality-test = (build-asdf-system {
    pname = "cl-primality-test";
    version = "20150608-git";
    asds = [ "cl-primality-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-primality/2015-06-08/cl-primality-20150608-git.tgz";
      sha256 = "1hvbsd5x7yrrrh7jjq0p8ign3ppzzpacmmz7nps60wgk38q1b618";
      system = "cl-primality-test";
      asd = "cl-primality-test";
    });
    systems = [ "cl-primality-test" ];
    lispLibs = [ (getAttr "cl-primality" self) (getAttr "iterate" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prime-maker = (build-asdf-system {
    pname = "cl-prime-maker";
    version = "20150302-git";
    asds = [ "cl-prime-maker" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prime-maker/2015-03-02/cl-prime-maker-20150302-git.tgz";
      sha256 = "0hs95zs990aiwspss2dzmjvl18ipvlkx3p9cgmcncqxhgkizds9s";
      system = "cl-prime-maker";
      asd = "cl-prime-maker";
    });
    systems = [ "cl-prime-maker" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-progress-bar = (build-asdf-system {
    pname = "cl-progress-bar";
    version = "20211209-git";
    asds = [ "cl-progress-bar" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-progress-bar/2021-12-09/cl-progress-bar-20211209-git.tgz";
      sha256 = "1y4kg4qb4bxkqnc84mczx5fhqlr6qbagxwsn93xrilv8lqg8ymiv";
      system = "cl-progress-bar";
      asd = "cl-progress-bar";
    });
    systems = [ "cl-progress-bar" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "documentation-utils-extensions" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-project = (build-asdf-system {
    pname = "cl-project";
    version = "20200715-git";
    asds = [ "cl-project" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-project/2020-07-15/cl-project-20200715-git.tgz";
      sha256 = "1rmh6s1ncv8s2yrr14ja9wisgg745sq6xibqwb341ikdicxdp26y";
      system = "cl-project";
      asd = "cl-project";
    });
    systems = [ "cl-project" ];
    lispLibs = [ (getAttr "cl-emb" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-project-test = (build-asdf-system {
    pname = "cl-project-test";
    version = "20200715-git";
    asds = [ "cl-project-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-project/2020-07-15/cl-project-20200715-git.tgz";
      sha256 = "1rmh6s1ncv8s2yrr14ja9wisgg745sq6xibqwb341ikdicxdp26y";
      system = "cl-project-test";
      asd = "cl-project-test";
    });
    systems = [ "cl-project-test" ];
    lispLibs = [ (getAttr "caveman2" self) (getAttr "cl-project" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2 = (build-asdf-system {
    pname = "cl-prolog2";
    version = "20211209-git";
    asds = [ "cl-prolog2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2";
      asd = "cl-prolog2";
    });
    systems = [ "cl-prolog2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "external-program" self) (getAttr "trivia" self) (getAttr "trivia_dot_quasiquote" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_bprolog = (build-asdf-system {
    pname = "cl-prolog2.bprolog";
    version = "20211209-git";
    asds = [ "cl-prolog2.bprolog" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.bprolog";
      asd = "cl-prolog2.bprolog";
    });
    systems = [ "cl-prolog2.bprolog" ];
    lispLibs = [ (getAttr "cl-prolog2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_bprolog_dot_test = (build-asdf-system {
    pname = "cl-prolog2.bprolog.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.bprolog.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.bprolog.test";
      asd = "cl-prolog2.bprolog.test";
    });
    systems = [ "cl-prolog2.bprolog.test" ];
    lispLibs = [ (getAttr "cl-prolog2_dot_bprolog" self) (getAttr "cl-prolog2_dot_test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_gprolog = (build-asdf-system {
    pname = "cl-prolog2.gprolog";
    version = "20211209-git";
    asds = [ "cl-prolog2.gprolog" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.gprolog";
      asd = "cl-prolog2.gprolog";
    });
    systems = [ "cl-prolog2.gprolog" ];
    lispLibs = [ (getAttr "cl-prolog2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_gprolog_dot_test = (build-asdf-system {
    pname = "cl-prolog2.gprolog.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.gprolog.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.gprolog.test";
      asd = "cl-prolog2.gprolog.test";
    });
    systems = [ "cl-prolog2.gprolog.test" ];
    lispLibs = [ (getAttr "cl-prolog2_dot_gprolog" self) (getAttr "cl-prolog2_dot_test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_swi = (build-asdf-system {
    pname = "cl-prolog2.swi";
    version = "20211209-git";
    asds = [ "cl-prolog2.swi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.swi";
      asd = "cl-prolog2.swi";
    });
    systems = [ "cl-prolog2.swi" ];
    lispLibs = [ (getAttr "cl-prolog2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_swi_dot_test = (build-asdf-system {
    pname = "cl-prolog2.swi.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.swi.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.swi.test";
      asd = "cl-prolog2.swi.test";
    });
    systems = [ "cl-prolog2.swi.test" ];
    lispLibs = [ (getAttr "cl-prolog2_dot_swi" self) (getAttr "cl-prolog2_dot_test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_test = (build-asdf-system {
    pname = "cl-prolog2.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.test";
      asd = "cl-prolog2.test";
    });
    systems = [ "cl-prolog2.test" ];
    lispLibs = [ (getAttr "cl-prolog2" self) (getAttr "fiveam" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_xsb = (build-asdf-system {
    pname = "cl-prolog2.xsb";
    version = "20211209-git";
    asds = [ "cl-prolog2.xsb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.xsb";
      asd = "cl-prolog2.xsb";
    });
    systems = [ "cl-prolog2.xsb" ];
    lispLibs = [ (getAttr "cl-prolog2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_xsb_dot_test = (build-asdf-system {
    pname = "cl-prolog2.xsb.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.xsb.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.xsb.test";
      asd = "cl-prolog2.xsb.test";
    });
    systems = [ "cl-prolog2.xsb.test" ];
    lispLibs = [ (getAttr "cl-prolog2_dot_test" self) (getAttr "cl-prolog2_dot_xsb" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_yap = (build-asdf-system {
    pname = "cl-prolog2.yap";
    version = "20211209-git";
    asds = [ "cl-prolog2.yap" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.yap";
      asd = "cl-prolog2.yap";
    });
    systems = [ "cl-prolog2.yap" ];
    lispLibs = [ (getAttr "cl-prolog2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-prolog2_dot_yap_dot_test = (build-asdf-system {
    pname = "cl-prolog2.yap.test";
    version = "20211209-git";
    asds = [ "cl-prolog2.yap.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-prolog2/2021-12-09/cl-prolog2-20211209-git.tgz";
      sha256 = "15xa1i2r72ll6zfhq6gkv0h36kifqjvbsmnycd145vgd0dvh5pgg";
      system = "cl-prolog2.yap.test";
      asd = "cl-prolog2.yap.test";
    });
    systems = [ "cl-prolog2.yap.test" ];
    lispLibs = [ (getAttr "cl-prolog2_dot_test" self) (getAttr "cl-prolog2_dot_yap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-protobufs_dot_asdf = (build-asdf-system {
    pname = "cl-protobufs.asdf";
    version = "20230618-git";
    asds = [ "cl-protobufs.asdf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-protobufs/2023-06-18/cl-protobufs-20230618-git.tgz";
      sha256 = "13rva5cb2w0a74z28w68pm9gfjcg54lnvifss4rwj2n5zx549c9r";
      system = "cl-protobufs.asdf";
      asd = "cl-protobufs.asdf";
    });
    systems = [ "cl-protobufs.asdf" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pslib = (build-asdf-system {
    pname = "cl-pslib";
    version = "20201016-git";
    asds = [ "cl-pslib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pslib/2020-10-16/cl-pslib-20201016-git.tgz";
      sha256 = "1l3ig57lrqdbm3kd9kbch3y3az8kryc9bqn896vz3a3w3rnwcv5a";
      system = "cl-pslib";
      asd = "cl-pslib";
    });
    systems = [ "cl-pslib" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-colors2" self) (getAttr "cl-ppcre-unicode" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-pslib-barcode = (build-asdf-system {
    pname = "cl-pslib-barcode";
    version = "20200218-git";
    asds = [ "cl-pslib-barcode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-pslib-barcode/2020-02-18/cl-pslib-barcode-20200218-git.tgz";
      sha256 = "10hmvjx03m54xyrjdw92kfpcvch0by0c8lwj899rbgxwfjsbwc49";
      system = "cl-pslib-barcode";
      asd = "cl-pslib-barcode";
    });
    systems = [ "cl-pslib-barcode" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-colors2" self) (getAttr "cl-ppcre-unicode" self) (getAttr "cl-pslib" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-punch = (build-asdf-system {
    pname = "cl-punch";
    version = "20190107-git";
    asds = [ "cl-punch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-punch/2019-01-07/cl-punch-20190107-git.tgz";
      sha256 = "1sjgwn6c77n8pgs0rrw70xfl18rps6a0dlf2chfsbgk8shz6qyl2";
      system = "cl-punch";
      asd = "cl-punch";
    });
    systems = [ "cl-punch" ];
    lispLibs = [ (getAttr "cl-syntax" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-punch-test = (build-asdf-system {
    pname = "cl-punch-test";
    version = "20190107-git";
    asds = [ "cl-punch-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-punch/2019-01-07/cl-punch-20190107-git.tgz";
      sha256 = "1sjgwn6c77n8pgs0rrw70xfl18rps6a0dlf2chfsbgk8shz6qyl2";
      system = "cl-punch-test";
      asd = "cl-punch-test";
    });
    systems = [ "cl-punch-test" ];
    lispLibs = [ (getAttr "cl-punch" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-qprint = (build-asdf-system {
    pname = "cl-qprint";
    version = "20150804-git";
    asds = [ "cl-qprint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-qprint/2015-08-04/cl-qprint-20150804-git.tgz";
      sha256 = "099h0rrdzxnlmn8avi72mg2dl0kccp7w01b2p9nwyy4b8yr32cir";
      system = "cl-qprint";
      asd = "cl-qprint";
    });
    systems = [ "cl-qprint" ];
    lispLibs = [ (getAttr "flexi-streams" self) ];
    meta = {};
  });
  cl-qrencode = (build-asdf-system {
    pname = "cl-qrencode";
    version = "20191007-git";
    asds = [ "cl-qrencode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-qrencode/2019-10-07/cl-qrencode-20191007-git.tgz";
      sha256 = "1l5k131dchbf6cj8a8xqa731790p01p3qa1kdy2wa9dawy3ymkxr";
      system = "cl-qrencode";
      asd = "cl-qrencode";
    });
    systems = [ "cl-qrencode" ];
    lispLibs = [ (getAttr "zpng" self) ];
    meta = {};
  });
  cl-qrencode-test = (build-asdf-system {
    pname = "cl-qrencode-test";
    version = "20191007-git";
    asds = [ "cl-qrencode-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-qrencode/2019-10-07/cl-qrencode-20191007-git.tgz";
      sha256 = "1l5k131dchbf6cj8a8xqa731790p01p3qa1kdy2wa9dawy3ymkxr";
      system = "cl-qrencode-test";
      asd = "cl-qrencode-test";
    });
    systems = [ "cl-qrencode-test" ];
    lispLibs = [ (getAttr "cl-qrencode" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-quickcheck = (build-asdf-system {
    pname = "cl-quickcheck";
    version = "20200610-git";
    asds = [ "cl-quickcheck" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-quickcheck/2020-06-10/cl-quickcheck-20200610-git.tgz";
      sha256 = "0cfyxbdhklvdk3qdzyxxaq9q6cxnsvqjfi86nay1vc7h6ziysb60";
      system = "cl-quickcheck";
      asd = "cl-quickcheck";
    });
    systems = [ "cl-quickcheck" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-quil = (build-asdf-system {
    pname = "cl-quil";
    version = "v1.26.0";
    asds = [ "cl-quil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/quilc/2021-12-09/quilc-v1.26.0.tgz";
      sha256 = "09qp2d6xgq4cmg6nfsdz0gbs3rvz3ln0kawmry6cls14lxnljjrr";
      system = "cl-quil";
      asd = "cl-quil";
    });
    systems = [ "cl-quil" ];
    lispLibs = [ (getAttr "abstract-classes" self) (getAttr "alexa" self) (getAttr "alexandria" self) (getAttr "cl-algebraic-data-type" self) (getAttr "cl-grnm" self) (getAttr "cl-heap" self) (getAttr "cl-permutation" self) (getAttr "closer-mop" self) (getAttr "flexi-streams" self) (getAttr "global-vars" self) (getAttr "magicl" self) (getAttr "optima" self) (getAttr "parse-float" self) (getAttr "queues_dot_priority-queue" self) (getAttr "salza2" self) (getAttr "singleton-classes" self) (getAttr "split-sequence" self) (getAttr "trivial-garbage" self) (getAttr "yacc" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-quil-benchmarking = (build-asdf-system {
    pname = "cl-quil-benchmarking";
    version = "v1.26.0";
    asds = [ "cl-quil-benchmarking" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/quilc/2021-12-09/quilc-v1.26.0.tgz";
      sha256 = "09qp2d6xgq4cmg6nfsdz0gbs3rvz3ln0kawmry6cls14lxnljjrr";
      system = "cl-quil-benchmarking";
      asd = "cl-quil-benchmarking";
    });
    systems = [ "cl-quil-benchmarking" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-quil" self) (getAttr "metering" self) (getAttr "qvm-app" self) (getAttr "trivial-benchmark" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-quil-tests = (build-asdf-system {
    pname = "cl-quil-tests";
    version = "v1.26.0";
    asds = [ "cl-quil-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/quilc/2021-12-09/quilc-v1.26.0.tgz";
      sha256 = "09qp2d6xgq4cmg6nfsdz0gbs3rvz3ln0kawmry6cls14lxnljjrr";
      system = "cl-quil-tests";
      asd = "cl-quil-tests";
    });
    systems = [ "cl-quil-tests" ];
    lispLibs = [ (getAttr "alexa" self) (getAttr "alexandria" self) (getAttr "cl-permutation" self) (getAttr "cl-ppcre" self) (getAttr "cl-quil" self) (getAttr "fiasco" self) (getAttr "magicl" self) (getAttr "qvm" self) (getAttr "yacc" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rabbit = (build-asdf-system {
    pname = "cl-rabbit";
    version = "20210411-git";
    asds = [ "cl-rabbit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rabbit/2021-04-11/cl-rabbit-20210411-git.tgz";
      sha256 = "1q1mhqxqvxbr6ak7j0ym6mjhhq6r0pqk1l7az9hfajmqmw3xfija";
      system = "cl-rabbit";
      asd = "cl-rabbit";
    });
    systems = [ "cl-rabbit" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "cffi-libffi" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rabbit-tests = (build-asdf-system {
    pname = "cl-rabbit-tests";
    version = "20210411-git";
    asds = [ "cl-rabbit-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rabbit/2021-04-11/cl-rabbit-20210411-git.tgz";
      sha256 = "1q1mhqxqvxbr6ak7j0ym6mjhhq6r0pqk1l7az9hfajmqmw3xfija";
      system = "cl-rabbit-tests";
      asd = "cl-rabbit-tests";
    });
    systems = [ "cl-rabbit-tests" ];
    lispLibs = [ (getAttr "cl-rabbit" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-randist = (build-asdf-system {
    pname = "cl-randist";
    version = "20221106-git";
    asds = [ "cl-randist" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-randist/2022-11-06/cl-randist-20221106-git.tgz";
      sha256 = "1r0d76n5zjqg5fb2ypqx5i1wg4hsg5g0c126ylqb28wdaf2yjz5a";
      system = "cl-randist";
      asd = "cl-randist";
    });
    systems = [ "cl-randist" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-random-forest = (build-asdf-system {
    pname = "cl-random-forest";
    version = "20221106-git";
    asds = [ "cl-random-forest" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-random-forest/2022-11-06/cl-random-forest-20221106-git.tgz";
      sha256 = "0jn5f3s1zvjql35c4m67lqc0vjr7sm7kzf8w4jfbfabcnxf3y6jx";
      system = "cl-random-forest";
      asd = "cl-random-forest";
    });
    systems = [ "cl-random-forest" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-libsvm-format" self) (getAttr "cl-online-learning" self) (getAttr "lparallel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-random-forest-test = (build-asdf-system {
    pname = "cl-random-forest-test";
    version = "20221106-git";
    asds = [ "cl-random-forest-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-random-forest/2022-11-06/cl-random-forest-20221106-git.tgz";
      sha256 = "0jn5f3s1zvjql35c4m67lqc0vjr7sm7kzf8w4jfbfabcnxf3y6jx";
      system = "cl-random-forest-test";
      asd = "cl-random-forest-test";
    });
    systems = [ "cl-random-forest-test" ];
    lispLibs = [ (getAttr "cl-random-forest" self) (getAttr "prove" self) (getAttr "prove-asdf" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rdfxml = (build-asdf-system {
    pname = "cl-rdfxml";
    version = "20140713-git";
    asds = [ "cl-rdfxml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rdfxml/2014-07-13/cl-rdfxml-20140713-git.tgz";
      sha256 = "09v76qg6l3y1llapnkfqrfgib67h7lpkzrdmfimwk49bi80iii8v";
      system = "cl-rdfxml";
      asd = "cl-rdfxml";
    });
    systems = [ "cl-rdfxml" ];
    lispLibs = [ (getAttr "cxml" self) (getAttr "puri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rdkafka = (build-asdf-system {
    pname = "cl-rdkafka";
    version = "20230214-git";
    asds = [ "cl-rdkafka" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rdkafka/2023-02-14/cl-rdkafka-20230214-git.tgz";
      sha256 = "10y56avak66k2la9bmfzrni01wybi86avxjh64hz57b351bf2s55";
      system = "cl-rdkafka";
      asd = "cl-rdkafka";
    });
    systems = [ "cl-rdkafka" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cffi" self) (getAttr "cffi-grovel" self) (getAttr "lparallel" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-readline = (build-asdf-system {
    pname = "cl-readline";
    version = "20220707-git";
    asds = [ "cl-readline" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-readline/2022-07-07/cl-readline-20220707-git.tgz";
      sha256 = "0bxvfd7hmj9yvcar3f3kd1cxxx4pqzri6sa28bp9w9bm25g4ddhf";
      system = "cl-readline";
      asd = "cl-readline";
    });
    systems = [ "cl-readline" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) ];
    meta = {};
  });
  cl-recaptcha = (build-asdf-system {
    pname = "cl-recaptcha";
    version = "20150608-git";
    asds = [ "cl-recaptcha" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-recaptcha/2015-06-08/cl-recaptcha-20150608-git.tgz";
      sha256 = "09qdmzbhc5hikay31mbsfd7dps72rm4gcdbbi0b6gkb6qbia6m71";
      system = "cl-recaptcha";
      asd = "cl-recaptcha";
    });
    systems = [ "cl-recaptcha" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "jsown" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-redis = (build-asdf-system {
    pname = "cl-redis";
    version = "20200925-git";
    asds = [ "cl-redis" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-redis/2020-09-25/cl-redis-20200925-git.tgz";
      sha256 = "0x5ahxb5cx37biyn3cjycshhm1rr9p5cf1a9l5hd1n1xjxm2f8vi";
      system = "cl-redis";
      asd = "cl-redis";
    });
    systems = [ "cl-redis" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "rutils" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-redis-test = (build-asdf-system {
    pname = "cl-redis-test";
    version = "20200925-git";
    asds = [ "cl-redis-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-redis/2020-09-25/cl-redis-20200925-git.tgz";
      sha256 = "0x5ahxb5cx37biyn3cjycshhm1rr9p5cf1a9l5hd1n1xjxm2f8vi";
      system = "cl-redis-test";
      asd = "cl-redis";
    });
    systems = [ "cl-redis-test" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-redis" self) (getAttr "flexi-streams" self) (getAttr "should-test" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-reexport = (build-asdf-system {
    pname = "cl-reexport";
    version = "20210228-git";
    asds = [ "cl-reexport" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-reexport/2021-02-28/cl-reexport-20210228-git.tgz";
      sha256 = "02la6z3ickhmh2m87ymm2ijh9nkn7l6slskj99l8a1rhps394qqc";
      system = "cl-reexport";
      asd = "cl-reexport";
    });
    systems = [ "cl-reexport" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {};
  });
  cl-reexport-test = (build-asdf-system {
    pname = "cl-reexport-test";
    version = "20210228-git";
    asds = [ "cl-reexport-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-reexport/2021-02-28/cl-reexport-20210228-git.tgz";
      sha256 = "02la6z3ickhmh2m87ymm2ijh9nkn7l6slskj99l8a1rhps394qqc";
      system = "cl-reexport-test";
      asd = "cl-reexport-test";
    });
    systems = [ "cl-reexport-test" ];
    lispLibs = [ (getAttr "cl-reexport" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-renderdoc = (build-asdf-system {
    pname = "cl-renderdoc";
    version = "20200925-git";
    asds = [ "cl-renderdoc" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-renderdoc/2020-09-25/cl-renderdoc-20200925-git.tgz";
      sha256 = "0rrcp4y1f07x8h0ikvf5ncc3pbqj6vaciblab9qghmgdglnn7akx";
      system = "cl-renderdoc";
      asd = "cl-renderdoc";
    });
    systems = [ "cl-renderdoc" ];
    lispLibs = [ (getAttr "cl-autowrap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-replica = (build-asdf-system {
    pname = "cl-replica";
    version = "20230618-git";
    asds = [ "cl-replica" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-replica/2023-06-18/cl-replica-20230618-git.tgz";
      sha256 = "06nywqz7il4dk79s3ga8115s5cr9bpz1fh8b7jms5wxlc1h5p0mn";
      system = "cl-replica";
      asd = "cl-replica";
    });
    systems = [ "cl-replica" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rethinkdb = (build-asdf-system {
    pname = "cl-rethinkdb";
    version = "20160825-git";
    asds = [ "cl-rethinkdb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rethinkdb/2016-08-25/cl-rethinkdb-20160825-git.tgz";
      sha256 = "0sps1p203gn7i123w96pj5ggpncmkngkfdb6zfnm5yjq544sjjf7";
      system = "cl-rethinkdb";
      asd = "cl-rethinkdb";
    });
    systems = [ "cl-rethinkdb" ];
    lispLibs = [ (getAttr "blackbird" self) (getAttr "cl-async" self) (getAttr "cl-base64" self) (getAttr "cl-hash-util" self) (getAttr "cl-ppcre" self) (getAttr "event-glue" self) (getAttr "fast-io" self) (getAttr "jonathan" self) (getAttr "local-time" self) (getAttr "vom" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rethinkdb-test = (build-asdf-system {
    pname = "cl-rethinkdb-test";
    version = "20160825-git";
    asds = [ "cl-rethinkdb-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rethinkdb/2016-08-25/cl-rethinkdb-20160825-git.tgz";
      sha256 = "0sps1p203gn7i123w96pj5ggpncmkngkfdb6zfnm5yjq544sjjf7";
      system = "cl-rethinkdb-test";
      asd = "cl-rethinkdb-test";
    });
    systems = [ "cl-rethinkdb-test" ];
    lispLibs = [ (getAttr "blackbird" self) (getAttr "cl-async" self) (getAttr "cl-ppcre" self) (getAttr "cl-rethinkdb" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rfc2047 = (build-asdf-system {
    pname = "cl-rfc2047";
    version = "20150804-git";
    asds = [ "cl-rfc2047" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rfc2047/2015-08-04/cl-rfc2047-20150804-git.tgz";
      sha256 = "1kh48p5i7lmv1hcdsddlcjavhai9gi54jndnbpm9r55a6ladi8gv";
      system = "cl-rfc2047";
      asd = "cl-rfc2047";
    });
    systems = [ "cl-rfc2047" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-base64" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rfc2047-test = (build-asdf-system {
    pname = "cl-rfc2047-test";
    version = "20150804-git";
    asds = [ "cl-rfc2047-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rfc2047/2015-08-04/cl-rfc2047-20150804-git.tgz";
      sha256 = "1kh48p5i7lmv1hcdsddlcjavhai9gi54jndnbpm9r55a6ladi8gv";
      system = "cl-rfc2047-test";
      asd = "cl-rfc2047-test";
    });
    systems = [ "cl-rfc2047-test" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-rfc2047" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rfc4251 = (build-asdf-system {
    pname = "cl-rfc4251";
    version = "20230214-git";
    asds = [ "cl-rfc4251" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rfc4251/2023-02-14/cl-rfc4251-20230214-git.tgz";
      sha256 = "0r3ji4l9d6ha6h01isjg4661w0q9f8hnm6sa24xzw8lwxpg2blm0";
      system = "cl-rfc4251";
      asd = "cl-rfc4251";
    });
    systems = [ "cl-rfc4251" ];
    lispLibs = [ (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rfc4251_dot_test = (build-asdf-system {
    pname = "cl-rfc4251.test";
    version = "20230214-git";
    asds = [ "cl-rfc4251.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rfc4251/2023-02-14/cl-rfc4251-20230214-git.tgz";
      sha256 = "0r3ji4l9d6ha6h01isjg4661w0q9f8hnm6sa24xzw8lwxpg2blm0";
      system = "cl-rfc4251.test";
      asd = "cl-rfc4251.test";
    });
    systems = [ "cl-rfc4251.test" ];
    lispLibs = [ (getAttr "cl-rfc4251" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-riff = (build-asdf-system {
    pname = "cl-riff";
    version = "20220707-git";
    asds = [ "cl-riff" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-riff/2022-07-07/cl-riff-20220707-git.tgz";
      sha256 = "0b2j6yw3xkv6611snn7cy56vmnjfgi58wyvfr9lx82xkakd9rw3z";
      system = "cl-riff";
      asd = "cl-riff";
    });
    systems = [ "cl-riff" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rlimit = (build-asdf-system {
    pname = "cl-rlimit";
    version = "20150608-git";
    asds = [ "cl-rlimit" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rlimit/2015-06-08/cl-rlimit-20150608-git.tgz";
      sha256 = "19p02r380qhs76qlcb3jp4lm4nsnpy7zch01fdiwn7l7xgxkzxh0";
      system = "cl-rlimit";
      asd = "cl-rlimit";
    });
    systems = [ "cl-rlimit" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rmath = (build-asdf-system {
    pname = "cl-rmath";
    version = "20180328-git";
    asds = [ "cl-rmath" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rmath/2018-03-28/cl-rmath-20180328-git.tgz";
      sha256 = "1ld8vbpy10paymx2hn0mcgd21i7cjhdrayln1jx0kayqxm12mmk4";
      system = "cl-rmath";
      asd = "cl-rmath";
    });
    systems = [ "cl-rmath" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-robdd = (build-asdf-system {
    pname = "cl-robdd";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "cl-robdd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "cl-robdd";
      asd = "cl-robdd";
    });
    systems = [ "cl-robdd" ];
    lispLibs = [ (getAttr "adjuvant" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-robdd-analysis = (build-asdf-system {
    pname = "cl-robdd-analysis";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "cl-robdd-analysis" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "cl-robdd-analysis";
      asd = "cl-robdd-analysis";
    });
    systems = [ "cl-robdd-analysis" ];
    lispLibs = [ (getAttr "adjuvant" self) (getAttr "cl-fad" self) (getAttr "cl-robdd" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-robdd-analysis-test = (build-asdf-system {
    pname = "cl-robdd-analysis-test";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "cl-robdd-analysis-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "cl-robdd-analysis-test";
      asd = "cl-robdd-analysis-test";
    });
    systems = [ "cl-robdd-analysis-test" ];
    lispLibs = [ (getAttr "adjuvant" self) (getAttr "cl-robdd-analysis" self) (getAttr "scrutiny" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-robdd-test = (build-asdf-system {
    pname = "cl-robdd-test";
    version = "export-to-quicklisp-502a46e2-git";
    asds = [ "cl-robdd-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/regular-type-expression/2020-02-18/regular-type-expression-export-to-quicklisp-502a46e2-git.tgz";
      sha256 = "1im07p7sbbhdjx9v8fx3v1xdqx1085lra6fsb4sh2bssw7m5xfxi";
      system = "cl-robdd-test";
      asd = "cl-robdd-test";
    });
    systems = [ "cl-robdd-test" ];
    lispLibs = [ (getAttr "adjuvant" self) (getAttr "cl-fad" self) (getAttr "cl-robdd" self) (getAttr "scrutiny" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rrd = (build-asdf-system {
    pname = "cl-rrd";
    version = "20130128-git";
    asds = [ "cl-rrd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rrd/2013-01-28/cl-rrd-20130128-git.tgz";
      sha256 = "0a7fs46q41qzi6k8q9lvxryn2m90vamcsw7vl9kcjivyckjqrsm2";
      system = "cl-rrd";
      asd = "cl-rrd";
    });
    systems = [ "cl-rrd" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rrt = (build-asdf-system {
    pname = "cl-rrt";
    version = "20200925-git";
    asds = [ "cl-rrt" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rrt/2020-09-25/cl-rrt-20200925-git.tgz";
      sha256 = "0lf1dvw5j9awy7ic1i4j5wd7657a170ywxihinmsdn4bwd4fynv0";
      system = "cl-rrt";
      asd = "cl-rrt";
    });
    systems = [ "cl-rrt" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cl-syntax-annot" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rrt_dot_benchmark = (build-asdf-system {
    pname = "cl-rrt.benchmark";
    version = "20200925-git";
    asds = [ "cl-rrt.benchmark" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rrt/2020-09-25/cl-rrt-20200925-git.tgz";
      sha256 = "0lf1dvw5j9awy7ic1i4j5wd7657a170ywxihinmsdn4bwd4fynv0";
      system = "cl-rrt.benchmark";
      asd = "cl-rrt.benchmark";
    });
    systems = [ "cl-rrt.benchmark" ];
    lispLibs = [ (getAttr "cl-rrt" self) (getAttr "cl-rrt_dot_rtree" self) (getAttr "cl-rrt_dot_test" self) (getAttr "fiveam" self) (getAttr "vecto" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rrt_dot_rtree = (build-asdf-system {
    pname = "cl-rrt.rtree";
    version = "20200925-git";
    asds = [ "cl-rrt.rtree" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rrt/2020-09-25/cl-rrt-20200925-git.tgz";
      sha256 = "0lf1dvw5j9awy7ic1i4j5wd7657a170ywxihinmsdn4bwd4fynv0";
      system = "cl-rrt.rtree";
      asd = "cl-rrt.rtree";
    });
    systems = [ "cl-rrt.rtree" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cl-rrt" self) (getAttr "cl-syntax-annot" self) (getAttr "iterate" self) (getAttr "spatial-trees" self) (getAttr "spatial-trees_dot_nns" self) (getAttr "trivia" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rrt_dot_test = (build-asdf-system {
    pname = "cl-rrt.test";
    version = "20200925-git";
    asds = [ "cl-rrt.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rrt/2020-09-25/cl-rrt-20200925-git.tgz";
      sha256 = "0lf1dvw5j9awy7ic1i4j5wd7657a170ywxihinmsdn4bwd4fynv0";
      system = "cl-rrt.test";
      asd = "cl-rrt.test";
    });
    systems = [ "cl-rrt.test" ];
    lispLibs = [ (getAttr "cl-rrt" self) (getAttr "cl-rrt_dot_rtree" self) (getAttr "fiveam" self) (getAttr "vecto" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rsvg2 = (build-asdf-system {
    pname = "cl-rsvg2";
    version = "20200925-git";
    asds = [ "cl-rsvg2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rsvg2/2020-09-25/cl-rsvg2-20200925-git.tgz";
      sha256 = "1amq4q27lj0nzffvwmqrkg8v9pdcf0281zzrvxl9w6vdm9qy1v3n";
      system = "cl-rsvg2";
      asd = "cl-rsvg2";
    });
    systems = [ "cl-rsvg2" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-cairo2" self) (getAttr "cl-gtk2-glib" self) (getAttr "trivial-gray-streams" self) ];
    meta = {};
  });
  cl-rsvg2-pixbuf = (build-asdf-system {
    pname = "cl-rsvg2-pixbuf";
    version = "20200925-git";
    asds = [ "cl-rsvg2-pixbuf" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rsvg2/2020-09-25/cl-rsvg2-20200925-git.tgz";
      sha256 = "1amq4q27lj0nzffvwmqrkg8v9pdcf0281zzrvxl9w6vdm9qy1v3n";
      system = "cl-rsvg2-pixbuf";
      asd = "cl-rsvg2-pixbuf";
    });
    systems = [ "cl-rsvg2-pixbuf" ];
    lispLibs = [ (getAttr "cl-gtk2-gdk" self) (getAttr "cl-rsvg2" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rsvg2-test = (build-asdf-system {
    pname = "cl-rsvg2-test";
    version = "20200925-git";
    asds = [ "cl-rsvg2-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rsvg2/2020-09-25/cl-rsvg2-20200925-git.tgz";
      sha256 = "1amq4q27lj0nzffvwmqrkg8v9pdcf0281zzrvxl9w6vdm9qy1v3n";
      system = "cl-rsvg2-test";
      asd = "cl-rsvg2-test";
    });
    systems = [ "cl-rsvg2-test" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-rsvg2" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rules = (build-asdf-system {
    pname = "cl-rules";
    version = "20190710-git";
    asds = [ "cl-rules" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rules/2019-07-10/cl-rules-20190710-git.tgz";
      sha256 = "0jidck62n0jkfqwrpqjn43zmjb3jlfaxxhn2lsyfwy2740i8ppr1";
      system = "cl-rules";
      asd = "cl-rules";
    });
    systems = [ "cl-rules" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-yaml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-rules-test = (build-asdf-system {
    pname = "cl-rules-test";
    version = "20190710-git";
    asds = [ "cl-rules-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-rules/2019-07-10/cl-rules-20190710-git.tgz";
      sha256 = "0jidck62n0jkfqwrpqjn43zmjb3jlfaxxhn2lsyfwy2740i8ppr1";
      system = "cl-rules-test";
      asd = "cl-rules-test";
    });
    systems = [ "cl-rules-test" ];
    lispLibs = [ (getAttr "cl-rules" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-s3 = (build-asdf-system {
    pname = "cl-s3";
    version = "20130128-git";
    asds = [ "cl-s3" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-s3/2013-01-28/cl-s3-20130128-git.tgz";
      sha256 = "1lbvf7phkm5vjk013p484rh4vh33i58jlqq3z4cv2yxqcw6r639d";
      system = "cl-s3";
      asd = "cl-s3";
    });
    systems = [ "cl-s3" ];
    lispLibs = [ (getAttr "ironclad" self) (getAttr "s-base64" self) (getAttr "s-http-client" self) (getAttr "s-utils" self) (getAttr "s-xml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sam = (build-asdf-system {
    pname = "cl-sam";
    version = "20150608-git";
    asds = [ "cl-sam" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sam/2015-06-08/cl-sam-20150608-git.tgz";
      sha256 = "0frrxz70jin4sa5n087zm4ikckf1zdjqqpjq3llrv46753c62fc6";
      system = "cl-sam";
      asd = "cl-sam";
    });
    systems = [ "cl-sam" ];
    lispLibs = [ (getAttr "deoxybyte-gzip" self) (getAttr "deoxybyte-systems" self) (getAttr "deoxybyte-unix" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sam-test = (build-asdf-system {
    pname = "cl-sam-test";
    version = "20150608-git";
    asds = [ "cl-sam-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sam/2015-06-08/cl-sam-20150608-git.tgz";
      sha256 = "0frrxz70jin4sa5n087zm4ikckf1zdjqqpjq3llrv46753c62fc6";
      system = "cl-sam-test";
      asd = "cl-sam-test";
    });
    systems = [ "cl-sam-test" ];
    lispLibs = [ (getAttr "cl-sam" self) (getAttr "deoxybyte-io" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sandbox = (build-asdf-system {
    pname = "cl-sandbox";
    version = "20180131-git";
    asds = [ "cl-sandbox" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sandbox/2018-01-31/cl-sandbox-20180131-git.tgz";
      sha256 = "053zxy3zi5jvlbg8zxlf922sxb32mq34zvwfhgpj4rcmgvgmqnxv";
      system = "cl-sandbox";
      asd = "cl-sandbox";
    });
    systems = [ "cl-sandbox" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sasl = (build-asdf-system {
    pname = "cl-sasl";
    version = "v0.3.2";
    asds = [ "cl-sasl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sasl/2019-05-21/cl-sasl-v0.3.2.tgz";
      sha256 = "0a05q8rls2hn46rbbk6w5km9kqvhsj365zlw6hp32724xy2nd98w";
      system = "cl-sasl";
      asd = "cl-sasl";
    });
    systems = [ "cl-sasl" ];
    lispLibs = [ (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sat = (build-asdf-system {
    pname = "cl-sat";
    version = "20220707-git";
    asds = [ "cl-sat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat/2022-07-07/cl-sat-20220707-git.tgz";
      sha256 = "1fcvxpmja757vyyhcpb00g150dyx90jsg9z8s596vy1nb0z81f49";
      system = "cl-sat";
      asd = "cl-sat";
    });
    systems = [ "cl-sat" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "iterate" self) (getAttr "trivia" self) (getAttr "trivial-features" self) ];
    meta = {};
  });
  cl-sat_dot_glucose = (build-asdf-system {
    pname = "cl-sat.glucose";
    version = "20220331-git";
    asds = [ "cl-sat.glucose" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat.glucose/2022-03-31/cl-sat.glucose-20220331-git.tgz";
      sha256 = "11hbhsjzw3xzz6i6niisk5h271kg52y3y77sl6ljnszfgp9xjfxy";
      system = "cl-sat.glucose";
      asd = "cl-sat.glucose";
    });
    systems = [ "cl-sat.glucose" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-sat" self) (getAttr "iterate" self) (getAttr "trivia" self) (getAttr "trivial-package-manager" self) ];
    meta = {};
  });
  cl-sat_dot_glucose_dot_test = (build-asdf-system {
    pname = "cl-sat.glucose.test";
    version = "20220331-git";
    asds = [ "cl-sat.glucose.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat.glucose/2022-03-31/cl-sat.glucose-20220331-git.tgz";
      sha256 = "11hbhsjzw3xzz6i6niisk5h271kg52y3y77sl6ljnszfgp9xjfxy";
      system = "cl-sat.glucose.test";
      asd = "cl-sat.glucose.test";
    });
    systems = [ "cl-sat.glucose.test" ];
    lispLibs = [ (getAttr "cl-sat_dot_glucose" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sat_dot_minisat = (build-asdf-system {
    pname = "cl-sat.minisat";
    version = "20220331-git";
    asds = [ "cl-sat.minisat" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat.minisat/2022-03-31/cl-sat.minisat-20220331-git.tgz";
      sha256 = "1jrpsdalz9wd3aipfvigimzgzrlb6fylw9cxf1vhhmii46yg9mdr";
      system = "cl-sat.minisat";
      asd = "cl-sat.minisat";
    });
    systems = [ "cl-sat.minisat" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-sat" self) (getAttr "iterate" self) (getAttr "trivia" self) (getAttr "trivial-package-manager" self) ];
    meta = {};
  });
  cl-sat_dot_minisat_dot_test = (build-asdf-system {
    pname = "cl-sat.minisat.test";
    version = "20220331-git";
    asds = [ "cl-sat.minisat.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat.minisat/2022-03-31/cl-sat.minisat-20220331-git.tgz";
      sha256 = "1jrpsdalz9wd3aipfvigimzgzrlb6fylw9cxf1vhhmii46yg9mdr";
      system = "cl-sat.minisat.test";
      asd = "cl-sat.minisat.test";
    });
    systems = [ "cl-sat.minisat.test" ];
    lispLibs = [ (getAttr "cl-sat_dot_minisat" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sat_dot_test = (build-asdf-system {
    pname = "cl-sat.test";
    version = "20220707-git";
    asds = [ "cl-sat.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sat/2022-07-07/cl-sat-20220707-git.tgz";
      sha256 = "1fcvxpmja757vyyhcpb00g150dyx90jsg9z8s596vy1nb0z81f49";
      system = "cl-sat.test";
      asd = "cl-sat.test";
    });
    systems = [ "cl-sat.test" ];
    lispLibs = [ (getAttr "cl-sat" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scram = (build-asdf-system {
    pname = "cl-scram";
    version = "20150923-git";
    asds = [ "cl-scram" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scram/2015-09-23/cl-scram-20150923-git.tgz";
      sha256 = "1absr9h9z79f1fbs4g33y2rc9jsqjs7vd2l5sl8dvqq4fyx8v6g0";
      system = "cl-scram";
      asd = "cl-scram";
    });
    systems = [ "cl-scram" ];
    lispLibs = [ (getAttr "cl-base64" self) (getAttr "cl-sasl" self) (getAttr "ironclad" self) (getAttr "secure-random" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scribd = (build-asdf-system {
    pname = "cl-scribd";
    version = "20130312-git";
    asds = [ "cl-scribd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scribd/2013-03-12/cl-scribd-20130312-git.tgz";
      sha256 = "0r4ah3f1ndi66bm1mir3ldl31sfbmav0kdfpb16f1n9931452mry";
      system = "cl-scribd";
      asd = "cl-scribd";
    });
    systems = [ "cl-scribd" ];
    lispLibs = [ (getAttr "cxml" self) (getAttr "drakma" self) (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scripting = (build-asdf-system {
    pname = "cl-scripting";
    version = "20211020-git";
    asds = [ "cl-scripting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scripting/2021-10-20/cl-scripting-20211020-git.tgz";
      sha256 = "1xi8klkn4fhmcrnhxzxvl0rj68dc7az6l2hc10560g9jvblcmmpp";
      system = "cl-scripting";
      asd = "cl-scripting";
    });
    systems = [ "cl-scripting" ];
    lispLibs = [ (getAttr "cl-launch" self) (getAttr "fare-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scrobbler = (build-asdf-system {
    pname = "cl-scrobbler";
    version = "20111105-git";
    asds = [ "cl-scrobbler" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scrobbler/2011-11-05/cl-scrobbler-20111105-git.tgz";
      sha256 = "0cd0zfmhxf5chcg7hncavfjr8m06cjbiyqylk76z8mprdsv1n062";
      system = "cl-scrobbler";
      asd = "cl-scrobbler";
    });
    systems = [ "cl-scrobbler" ];
    lispLibs = [ (getAttr "arnesi" self) (getAttr "cl-store" self) (getAttr "drakma" self) (getAttr "flexi-streams" self) (getAttr "md5" self) (getAttr "st-json" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scrobbler-tests = (build-asdf-system {
    pname = "cl-scrobbler-tests";
    version = "20111105-git";
    asds = [ "cl-scrobbler-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scrobbler/2011-11-05/cl-scrobbler-20111105-git.tgz";
      sha256 = "0cd0zfmhxf5chcg7hncavfjr8m06cjbiyqylk76z8mprdsv1n062";
      system = "cl-scrobbler-tests";
      asd = "cl-scrobbler";
    });
    systems = [ "cl-scrobbler-tests" ];
    lispLibs = [ (getAttr "cl-scrobbler" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scsu = (build-asdf-system {
    pname = "cl-scsu";
    version = "20221106-git";
    asds = [ "cl-scsu" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scsu/2022-11-06/cl-scsu-20221106-git.tgz";
      sha256 = "0jiqyayflyyrdks4yl894vzw2bkxkd87w4sy4n6ikjz450xk3yxf";
      system = "cl-scsu";
      asd = "cl-scsu";
    });
    systems = [ "cl-scsu" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-scsu-test = (build-asdf-system {
    pname = "cl-scsu-test";
    version = "20221106-git";
    asds = [ "cl-scsu-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-scsu/2022-11-06/cl-scsu-20221106-git.tgz";
      sha256 = "0jiqyayflyyrdks4yl894vzw2bkxkd87w4sy4n6ikjz450xk3yxf";
      system = "cl-scsu-test";
      asd = "cl-scsu-test";
    });
    systems = [ "cl-scsu-test" ];
    lispLibs = [ (getAttr "_1am" self) (getAttr "alexandria" self) (getAttr "cl-scsu" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-selenium = (build-asdf-system {
    pname = "cl-selenium";
    version = "20180328-git";
    asds = [ "cl-selenium" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-selenium-webdriver/2018-03-28/cl-selenium-webdriver-20180328-git.tgz";
      sha256 = "0216vqg1ax5gcqahclii7ifqpc92rbi86rfcf1qn8bdahmfjccbb";
      system = "cl-selenium";
      asd = "cl-selenium";
    });
    systems = [ "cl-selenium" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-json" self) (getAttr "dexador" self) (getAttr "quri" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-selenium-test = (build-asdf-system {
    pname = "cl-selenium-test";
    version = "20180328-git";
    asds = [ "cl-selenium-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-selenium-webdriver/2018-03-28/cl-selenium-webdriver-20180328-git.tgz";
      sha256 = "0216vqg1ax5gcqahclii7ifqpc92rbi86rfcf1qn8bdahmfjccbb";
      system = "cl-selenium-test";
      asd = "cl-selenium-test";
    });
    systems = [ "cl-selenium-test" ];
    lispLibs = [ (getAttr "cl-selenium" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-semver = (build-asdf-system {
    pname = "cl-semver";
    version = "20230618-git";
    asds = [ "cl-semver" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-semver/2023-06-18/cl-semver-20230618-git.tgz";
      sha256 = "1zlcn7lrpvjiixgqm4yxnqqwak1hxfmxmchkpvrly41yhl586ril";
      system = "cl-semver";
      asd = "cl-semver";
    });
    systems = [ "cl-semver" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "esrap" self) (getAttr "named-readtables" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-semver-test = (build-asdf-system {
    pname = "cl-semver-test";
    version = "20230618-git";
    asds = [ "cl-semver-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-semver/2023-06-18/cl-semver-20230618-git.tgz";
      sha256 = "1zlcn7lrpvjiixgqm4yxnqqwak1hxfmxmchkpvrly41yhl586ril";
      system = "cl-semver-test";
      asd = "cl-semver-test";
    });
    systems = [ "cl-semver-test" ];
    lispLibs = [ (getAttr "cl-semver" self) (getAttr "stefil" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sentiment = (build-asdf-system {
    pname = "cl-sentiment";
    version = "20130128-git";
    asds = [ "cl-sentiment" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sentiment/2013-01-28/cl-sentiment-20130128-git.tgz";
      sha256 = "18jx6ivbzcg9bsmp1pmlqvzr4kfxzll75b4viz1hrkq78nsnpp5v";
      system = "cl-sentiment";
      asd = "cl-sentiment";
    });
    systems = [ "cl-sentiment" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ses4 = (build-asdf-system {
    pname = "cl-ses4";
    version = "20221106-git";
    asds = [ "cl-ses4" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ses4/2022-11-06/cl-ses4-20221106-git.tgz";
      sha256 = "1n31k81i19hx26h9wcz39fsciq92hbblnbd15krblx9g877a1598";
      system = "cl-ses4";
      asd = "cl-ses4";
    });
    systems = [ "cl-ses4" ];
    lispLibs = [ (getAttr "arrow-macros" self) (getAttr "cl-base64" self) (getAttr "cl-ppcre" self) (getAttr "dexador" self) (getAttr "ironclad" self) (getAttr "local-time" self) (getAttr "quickapp" self) (getAttr "quri" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-setlocale = (build-asdf-system {
    pname = "cl-setlocale";
    version = "20201220-git";
    asds = [ "cl-setlocale" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-setlocale/2020-12-20/cl-setlocale-20201220-git.tgz";
      sha256 = "0g1b89yj6n42ayf2074krk3h9yvglqxn54a6i3sxgpsqww2ll2a1";
      system = "cl-setlocale";
      asd = "cl-setlocale";
    });
    systems = [ "cl-setlocale" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cffi-grovel" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sha1 = (build-asdf-system {
    pname = "cl-sha1";
    version = "20210807-git";
    asds = [ "cl-sha1" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sha1/2021-08-07/cl-sha1-20210807-git.tgz";
      sha256 = "16hczcr7ghah0p9fi29ddrw5c4zbb2d4765iigfx7yrgk5z5jb8p";
      system = "cl-sha1";
      asd = "cl-sha1";
    });
    systems = [ "cl-sha1" ];
    lispLibs = [ (getAttr "cl-base64" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-shellwords = (build-asdf-system {
    pname = "cl-shellwords";
    version = "20150923-git";
    asds = [ "cl-shellwords" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-shellwords/2015-09-23/cl-shellwords-20150923-git.tgz";
      sha256 = "0im8cni1ig5zaha9gbmma7zk1xxa4xajvzfgalvl2f0fhvksl4pn";
      system = "cl-shellwords";
      asd = "cl-shellwords";
    });
    systems = [ "cl-shellwords" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {};
  });
  cl-shellwords-test = (build-asdf-system {
    pname = "cl-shellwords-test";
    version = "20150923-git";
    asds = [ "cl-shellwords-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-shellwords/2015-09-23/cl-shellwords-20150923-git.tgz";
      sha256 = "0im8cni1ig5zaha9gbmma7zk1xxa4xajvzfgalvl2f0fhvksl4pn";
      system = "cl-shellwords-test";
      asd = "cl-shellwords-test";
    });
    systems = [ "cl-shellwords-test" ];
    lispLibs = [ (getAttr "cl-shellwords" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-simple-concurrent-jobs = (build-asdf-system {
    pname = "cl-simple-concurrent-jobs";
    version = "20150505-git";
    asds = [ "cl-simple-concurrent-jobs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-simple-concurrent-jobs/2015-05-05/cl-simple-concurrent-jobs-20150505-git.tgz";
      sha256 = "0mv7svsil58h8v8kq9965bpbradmhfpyrmi61dbzp5mbw8c5mrwj";
      system = "cl-simple-concurrent-jobs";
      asd = "cl-simple-concurrent-jobs";
    });
    systems = [ "cl-simple-concurrent-jobs" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "chanl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-simple-table = (build-asdf-system {
    pname = "cl-simple-table";
    version = "20130312-git";
    asds = [ "cl-simple-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-simple-table/2013-03-12/cl-simple-table-20130312-git.tgz";
      sha256 = "1pnczi5hbqlyxxvzlpy6vc58qc9hh9mdm5rgq304bp3v2qajh0b7";
      system = "cl-simple-table";
      asd = "cl-simple-table";
    });
    systems = [ "cl-simple-table" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-singleton-mixin = (build-asdf-system {
    pname = "cl-singleton-mixin";
    version = "20150505-git";
    asds = [ "cl-singleton-mixin" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-singleton-mixin/2015-05-05/cl-singleton-mixin-20150505-git.tgz";
      sha256 = "10dvwzx1kw9ac163i6sc8yfg3hpkn0dlq4hf6qipb46b4mcib01s";
      system = "cl-singleton-mixin";
      asd = "cl-singleton-mixin";
    });
    systems = [ "cl-singleton-mixin" ];
    lispLibs = [ (getAttr "closer-mop" self) (getAttr "metap" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-singleton-mixin-test = (build-asdf-system {
    pname = "cl-singleton-mixin-test";
    version = "20150505-git";
    asds = [ "cl-singleton-mixin-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-singleton-mixin/2015-05-05/cl-singleton-mixin-20150505-git.tgz";
      sha256 = "10dvwzx1kw9ac163i6sc8yfg3hpkn0dlq4hf6qipb46b4mcib01s";
      system = "cl-singleton-mixin-test";
      asd = "cl-singleton-mixin-test";
    });
    systems = [ "cl-singleton-mixin-test" ];
    lispLibs = [ (getAttr "cl-singleton-mixin" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-skip-list = (build-asdf-system {
    pname = "cl-skip-list";
    version = "20220707-git";
    asds = [ "cl-skip-list" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-skip-list/2022-07-07/cl-skip-list-20220707-git.tgz";
      sha256 = "1k3hbi9n1yzky3hjcg48jkkkp2jx5vm7bsywhnyyb1z6hz5phakd";
      system = "cl-skip-list";
      asd = "cl-skip-list";
    });
    systems = [ "cl-skip-list" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-skkserv = (build-asdf-system {
    pname = "cl-skkserv";
    version = "20201220-git";
    asds = [ "cl-skkserv" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-skkserv/2020-12-20/cl-skkserv-20201220-git.tgz";
      sha256 = "1khbfsvf70dyrrkbwcblzd6bkgx1z6k9ras57inmv2lqqr93m5l4";
      system = "cl-skkserv";
      asd = "cl-skkserv";
    });
    systems = [ "cl-skkserv" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "esrap" self) (getAttr "flexi-streams" self) (getAttr "jp-numeral" self) (getAttr "named-readtables" self) (getAttr "papyrus" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slice = (build-asdf-system {
    pname = "cl-slice";
    version = "20210531-git";
    asds = [ "cl-slice" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slice/2021-05-31/cl-slice-20210531-git.tgz";
      sha256 = "1ybznf4y5lda6bn163jcvj281qzhm24dfcwhbgxmm5n6f27gdccl";
      system = "cl-slice";
      asd = "cl-slice";
    });
    systems = [ "cl-slice" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "let-plus" self) ];
    meta = {};
  });
  cl-slice-tests = (build-asdf-system {
    pname = "cl-slice-tests";
    version = "20210531-git";
    asds = [ "cl-slice-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slice/2021-05-31/cl-slice-20210531-git.tgz";
      sha256 = "1ybznf4y5lda6bn163jcvj281qzhm24dfcwhbgxmm5n6f27gdccl";
      system = "cl-slice-tests";
      asd = "cl-slice";
    });
    systems = [ "cl-slice-tests" ];
    lispLibs = [ (getAttr "cl-slice" self) (getAttr "clunit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slp = (build-asdf-system {
    pname = "cl-slp";
    version = "20140826-git";
    asds = [ "cl-slp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slp/2014-08-26/cl-slp-20140826-git.tgz";
      sha256 = "10wfrw6r6w646lzx0nasnfvjpy63icxl8qm4888dpcjc57y1cd1w";
      system = "cl-slp";
      asd = "cl-slp";
    });
    systems = [ "cl-slp" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slug = (build-asdf-system {
    pname = "cl-slug";
    version = "20180228-git";
    asds = [ "cl-slug" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slug/2018-02-28/cl-slug-20180228-git.tgz";
      sha256 = "1asdq6xllmsvfw5fky9wblqcx9isac9jrrlkfl7vyxcq1wxrnflx";
      system = "cl-slug";
      asd = "cl-slug";
    });
    systems = [ "cl-slug" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slug-test = (build-asdf-system {
    pname = "cl-slug-test";
    version = "20180228-git";
    asds = [ "cl-slug-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slug/2018-02-28/cl-slug-20180228-git.tgz";
      sha256 = "1asdq6xllmsvfw5fky9wblqcx9isac9jrrlkfl7vyxcq1wxrnflx";
      system = "cl-slug-test";
      asd = "cl-slug-test";
    });
    systems = [ "cl-slug-test" ];
    lispLibs = [ (getAttr "cl-slug" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slugify = (build-asdf-system {
    pname = "cl-slugify";
    version = "20230618-git";
    asds = [ "cl-slugify" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slugify/2023-06-18/cl-slugify-20230618-git.tgz";
      sha256 = "18vjz9xb8q73j2bd609if2r6svljsnivl3sniz2p7j7w0qppps72";
      system = "cl-slugify";
      asd = "cl-slugify";
    });
    systems = [ "cl-slugify" ];
    lispLibs = [ (getAttr "cl-unac" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-slugify_dot_tests = (build-asdf-system {
    pname = "cl-slugify.tests";
    version = "20230618-git";
    asds = [ "cl-slugify.tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-slugify/2023-06-18/cl-slugify-20230618-git.tgz";
      sha256 = "18vjz9xb8q73j2bd609if2r6svljsnivl3sniz2p7j7w0qppps72";
      system = "cl-slugify.tests";
      asd = "cl-slugify.tests";
    });
    systems = [ "cl-slugify.tests" ];
    lispLibs = [ (getAttr "cl-slugify" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-smt-lib = (build-asdf-system {
    pname = "cl-smt-lib";
    version = "20220331-git";
    asds = [ "cl-smt-lib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-smt-lib/2022-03-31/cl-smt-lib-20220331-git.tgz";
      sha256 = "09xqpmzd8rmp4dkj6mzwlwnhqk266abqvskz9dm6mr3cnf2r774z";
      system = "cl-smt-lib";
      asd = "cl-smt-lib";
    });
    systems = [ "cl-smt-lib" ];
    lispLibs = [ (getAttr "asdf-package-system" self) (getAttr "named-readtables" self) (getAttr "trivial-gray-streams" self) ];
    meta = {};
  });
  cl-smtp = (build-asdf-system {
    pname = "cl-smtp";
    version = "20210228-git";
    asds = [ "cl-smtp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-smtp/2021-02-28/cl-smtp-20210228-git.tgz";
      sha256 = "0vjjfapcrdc5671jz2d24h8zvpz7skq1x6pi9fvw6ls5sgms6fr0";
      system = "cl-smtp";
      asd = "cl-smtp";
    });
    systems = [ "cl-smtp" ];
    lispLibs = [ (getAttr "cl_plus_ssl" self) (getAttr "cl-base64" self) (getAttr "flexi-streams" self) (getAttr "trivial-gray-streams" self) (getAttr "usocket" self) ];
    meta = {};
  });
  cl-soil = (build-asdf-system {
    pname = "cl-soil";
    version = "release-quicklisp-f27087ce-git";
    asds = [ "cl-soil" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-soil/2018-08-31/cl-soil-release-quicklisp-f27087ce-git.tgz";
      sha256 = "0mnz5yaw3kc14ja9g4j7dxh96kd82ifj25gy0dil7kqjd08lwcq9";
      system = "cl-soil";
      asd = "cl-soil";
    });
    systems = [ "cl-soil" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-opengl" self) (getAttr "documentation-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-soloud = (build-asdf-system {
    pname = "cl-soloud";
    version = "20190710-git";
    asds = [ "cl-soloud" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-soloud/2019-07-10/cl-soloud-20190710-git.tgz";
      sha256 = "1scdnhf052sa77zd4f250mxdqjjny2jcigwhgccrp1gldcs0ks37";
      system = "cl-soloud";
      asd = "cl-soloud";
    });
    systems = [ "cl-soloud" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-mpg123" self) (getAttr "documentation-utils" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) (getAttr "trivial-indent" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sophia = (build-asdf-system {
    pname = "cl-sophia";
    version = "20150608-git";
    asds = [ "cl-sophia" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sophia/2015-06-08/cl-sophia-20150608-git.tgz";
      sha256 = "1x027mr7lg5fs0d82n5mshnd19kan76y3zb9yxbcnq222l4j8j00";
      system = "cl-sophia";
      asd = "cl-sophia";
    });
    systems = [ "cl-sophia" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-fad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sophia-test = (build-asdf-system {
    pname = "cl-sophia-test";
    version = "20150608-git";
    asds = [ "cl-sophia-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sophia/2015-06-08/cl-sophia-20150608-git.tgz";
      sha256 = "1x027mr7lg5fs0d82n5mshnd19kan76y3zb9yxbcnq222l4j8j00";
      system = "cl-sophia-test";
      asd = "cl-sophia";
    });
    systems = [ "cl-sophia-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-sophia" self) (getAttr "lisp-unit" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-spark = (build-asdf-system {
    pname = "cl-spark";
    version = "20150709-git";
    asds = [ "cl-spark" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-spark/2015-07-09/cl-spark-20150709-git.tgz";
      sha256 = "0my1fsgi2rjaqkpk934f2bjy63pmnj7faza3fzvnk6k3l66y19nk";
      system = "cl-spark";
      asd = "cl-spark";
    });
    systems = [ "cl-spark" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-spark-test = (build-asdf-system {
    pname = "cl-spark-test";
    version = "20150709-git";
    asds = [ "cl-spark-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-spark/2015-07-09/cl-spark-20150709-git.tgz";
      sha256 = "0my1fsgi2rjaqkpk934f2bjy63pmnj7faza3fzvnk6k3l66y19nk";
      system = "cl-spark-test";
      asd = "cl-spark-test";
    });
    systems = [ "cl-spark-test" ];
    lispLibs = [ (getAttr "cl-spark" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sparql = (build-asdf-system {
    pname = "cl-sparql";
    version = "20220331-git";
    asds = [ "cl-sparql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sparql/2022-03-31/cl-sparql-20220331-git.tgz";
      sha256 = "1fjp5a25yly3l3pg07gzhz8q830fcaz0dwspigw8v90sx4insz0p";
      system = "cl-sparql";
      asd = "cl-sparql";
    });
    systems = [ "cl-sparql" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "parser-combinators" self) (getAttr "puri" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sparql-tests = (build-asdf-system {
    pname = "cl-sparql-tests";
    version = "20220331-git";
    asds = [ "cl-sparql-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sparql/2022-03-31/cl-sparql-20220331-git.tgz";
      sha256 = "1fjp5a25yly3l3pg07gzhz8q830fcaz0dwspigw8v90sx4insz0p";
      system = "cl-sparql-tests";
      asd = "cl-sparql-tests";
    });
    systems = [ "cl-sparql-tests" ];
    lispLibs = [ (getAttr "cl-sparql" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-speedy-queue = (build-asdf-system {
    pname = "cl-speedy-queue";
    version = "20150302-git";
    asds = [ "cl-speedy-queue" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-speedy-queue/2015-03-02/cl-speedy-queue-20150302-git.tgz";
      sha256 = "0czhnvxn9lvbjz9h1lb7y18nqrsq3drq5icd3lqdaa07362alriq";
      system = "cl-speedy-queue";
      asd = "cl-speedy-queue";
    });
    systems = [ "cl-speedy-queue" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-spidev = (build-asdf-system {
    pname = "cl-spidev";
    version = "20190710-git";
    asds = [ "cl-spidev" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-spidev/2019-07-10/cl-spidev-20190710-git.tgz";
      sha256 = "1kif1ygpm7z7bymg86h305171vnp5jsqyq4dz8h3fbi1rzjnqfcy";
      system = "cl-spidev";
      asd = "cl-spidev";
    });
    systems = [ "cl-spidev" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ssdb = (build-asdf-system {
    pname = "cl-ssdb";
    version = "20210124-git";
    asds = [ "cl-ssdb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ssdb/2021-01-24/cl-ssdb-20210124-git.tgz";
      sha256 = "05l0wg4a1kxgggmg1nalq811by76lja0gpa2c4i999h74bf4n3dc";
      system = "cl-ssdb";
      asd = "cl-ssdb";
    });
    systems = [ "cl-ssdb" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "parse-number" self) (getAttr "rutils" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ssdb-test = (build-asdf-system {
    pname = "cl-ssdb-test";
    version = "20210124-git";
    asds = [ "cl-ssdb-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ssdb/2021-01-24/cl-ssdb-20210124-git.tgz";
      sha256 = "05l0wg4a1kxgggmg1nalq811by76lja0gpa2c4i999h74bf4n3dc";
      system = "cl-ssdb-test";
      asd = "cl-ssdb-test";
    });
    systems = [ "cl-ssdb-test" ];
    lispLibs = [ (getAttr "cl-ssdb" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ssh-keys = (build-asdf-system {
    pname = "cl-ssh-keys";
    version = "20230214-git";
    asds = [ "cl-ssh-keys" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ssh-keys/2023-02-14/cl-ssh-keys-20230214-git.tgz";
      sha256 = "04mmsw3zvwf93majl5y3kynifq00mhd1102g8gf9lgps2mqblh2d";
      system = "cl-ssh-keys";
      asd = "cl-ssh-keys";
    });
    systems = [ "cl-ssh-keys" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "binascii" self) (getAttr "cl-rfc4251" self) (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-ssh-keys_dot_test = (build-asdf-system {
    pname = "cl-ssh-keys.test";
    version = "20230214-git";
    asds = [ "cl-ssh-keys.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-ssh-keys/2023-02-14/cl-ssh-keys-20230214-git.tgz";
      sha256 = "04mmsw3zvwf93majl5y3kynifq00mhd1102g8gf9lgps2mqblh2d";
      system = "cl-ssh-keys.test";
      asd = "cl-ssh-keys.test";
    });
    systems = [ "cl-ssh-keys.test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ssh-keys" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-statsd = (build-asdf-system {
    pname = "cl-statsd";
    version = "20170124-git";
    asds = [ "cl-statsd" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-statsd/2017-01-24/cl-statsd-20170124-git.tgz";
      sha256 = "1l2sxbzhp7wwalxn8k0k1gis9c9w462fygfw4ps0s1bnhgbvr6qb";
      system = "cl-statsd";
      asd = "cl-statsd";
    });
    systems = [ "cl-statsd" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-interpol" self) (getAttr "local-time" self) (getAttr "log4cl" self) (getAttr "safe-queue" self) (getAttr "trivial-utf-8" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-statsd_dot_test = (build-asdf-system {
    pname = "cl-statsd.test";
    version = "20170124-git";
    asds = [ "cl-statsd.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-statsd/2017-01-24/cl-statsd-20170124-git.tgz";
      sha256 = "1l2sxbzhp7wwalxn8k0k1gis9c9w462fygfw4ps0s1bnhgbvr6qb";
      system = "cl-statsd.test";
      asd = "cl-statsd.test";
    });
    systems = [ "cl-statsd.test" ];
    lispLibs = [ (getAttr "cl-statsd" self) (getAttr "log4cl" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-steamworks = (build-asdf-system {
    pname = "cl-steamworks";
    version = "20230618-git";
    asds = [ "cl-steamworks" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-steamworks/2023-06-18/cl-steamworks-20230618-git.tgz";
      sha256 = "1fzj3rlqw1kwdlmh0ga0y71p2n1adflcamzx4yp9kga552c1db5j";
      system = "cl-steamworks";
      asd = "cl-steamworks";
    });
    systems = [ "cl-steamworks" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "float-features" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) (getAttr "trivial-gray-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-steamworks-generator = (build-asdf-system {
    pname = "cl-steamworks-generator";
    version = "20230618-git";
    asds = [ "cl-steamworks-generator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-steamworks/2023-06-18/cl-steamworks-20230618-git.tgz";
      sha256 = "1fzj3rlqw1kwdlmh0ga0y71p2n1adflcamzx4yp9kga552c1db5j";
      system = "cl-steamworks-generator";
      asd = "cl-steamworks-generator";
    });
    systems = [ "cl-steamworks-generator" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-ppcre" self) (getAttr "parse-number" self) (getAttr "pathname-utils" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-stomp = (build-asdf-system {
    pname = "cl-stomp";
    version = "20200925-git";
    asds = [ "cl-stomp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-stomp/2020-09-25/cl-stomp-20200925-git.tgz";
      sha256 = "180y0x53ghsvz6n0bz67aw69p962bsslarikk89rf41kcv998xvw";
      system = "cl-stomp";
      asd = "cl-stomp";
    });
    systems = [ "cl-stomp" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "bordeaux-threads" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-stopwatch = (build-asdf-system {
    pname = "cl-stopwatch";
    version = "20230618-git";
    asds = [ "cl-stopwatch" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-stopwatch/2023-06-18/cl-stopwatch-20230618-git.tgz";
      sha256 = "14jmylqk1kijbhhn897r76ii4xg32k22p4v7h29jbcs9y2mn2day";
      system = "cl-stopwatch";
      asd = "cl-stopwatch";
    });
    systems = [ "cl-stopwatch" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-store = (build-asdf-system {
    pname = "cl-store";
    version = "20230214-git";
    asds = [ "cl-store" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-store/2023-02-14/cl-store-20230214-git.tgz";
      sha256 = "1kw39lmbiaksrxsq8pf5np8vjarymcvlc451z83275194av3imix";
      system = "cl-store";
      asd = "cl-store";
    });
    systems = [ "cl-store" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-store-tests = (build-asdf-system {
    pname = "cl-store-tests";
    version = "20230214-git";
    asds = [ "cl-store-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-store/2023-02-14/cl-store-20230214-git.tgz";
      sha256 = "1kw39lmbiaksrxsq8pf5np8vjarymcvlc451z83275194av3imix";
      system = "cl-store-tests";
      asd = "cl-store";
    });
    systems = [ "cl-store-tests" ];
    lispLibs = [ (getAttr "cl-store" self) (getAttr "rt" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-stream = (build-asdf-system {
    pname = "cl-stream";
    version = "20190521-git";
    asds = [ "cl-stream" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-stream/2019-05-21/cl-stream-20190521-git.tgz";
      sha256 = "1r2spbcx3ifz51yq2pxkdb1n2k5fvyg3pz3w42mnw99pq78cbasv";
      system = "cl-stream";
      asd = "cl-stream";
    });
    systems = [ "cl-stream" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-strftime = (build-asdf-system {
    pname = "cl-strftime";
    version = "20160318-git";
    asds = [ "cl-strftime" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-strftime/2016-03-18/cl-strftime-20160318-git.tgz";
      sha256 = "00c8hq7vzgb89ab3q7mrp60x743kiqmsk1g51ynhxlqhph2bnslf";
      system = "cl-strftime";
      asd = "cl-strftime";
    });
    systems = [ "cl-strftime" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "local-time" self) (getAttr "serapeum" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-string-complete = (build-asdf-system {
    pname = "cl-string-complete";
    version = "20230618-git";
    asds = [ "cl-string-complete" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-string-complete/2023-06-18/cl-string-complete-20230618-git.tgz";
      sha256 = "14l1yyz5fakz5xn31yjfn4mz7j9rcbijw1sp4mdfizfvjbbwcixl";
      system = "cl-string-complete";
      asd = "cl-string-complete";
    });
    systems = [ "cl-string-complete" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-string-generator = (build-asdf-system {
    pname = "cl-string-generator";
    version = "20210630-git";
    asds = [ "cl-string-generator" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-string-generator/2021-06-30/cl-string-generator-20210630-git.tgz";
      sha256 = "0zm6lyzd205lw30fdvnhrrlv9fylpfqksqxl32zvj9vzcn8qc1vi";
      system = "cl-string-generator";
      asd = "cl-string-generator";
    });
    systems = [ "cl-string-generator" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-string-match = (build-asdf-system {
    pname = "cl-string-match";
    version = "20211209-git";
    asds = [ "cl-string-match" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-string-match/2021-12-09/cl-string-match-20211209-git.tgz";
      sha256 = "0zndlkw3qy3vw4px4qv884z6232w8zfaliyc88irjwizdv35wcq9";
      system = "cl-string-match";
      asd = "cl-string-match";
    });
    systems = [ "cl-string-match" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "ascii-strings" self) (getAttr "iterate" self) (getAttr "jpl-queues" self) (getAttr "mgl-pax" self) (getAttr "yacc" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-string-match-test = (build-asdf-system {
    pname = "cl-string-match-test";
    version = "20211209-git";
    asds = [ "cl-string-match-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-string-match/2021-12-09/cl-string-match-20211209-git.tgz";
      sha256 = "0zndlkw3qy3vw4px4qv884z6232w8zfaliyc88irjwizdv35wcq9";
      system = "cl-string-match-test";
      asd = "cl-string-match-test";
    });
    systems = [ "cl-string-match-test" ];
    lispLibs = [ (getAttr "ascii-strings" self) (getAttr "cl-string-match" self) (getAttr "lisp-unit" self) (getAttr "simple-scanf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-strings = (build-asdf-system {
    pname = "cl-strings";
    version = "20210411-git";
    asds = [ "cl-strings" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-strings/2021-04-11/cl-strings-20210411-git.tgz";
      sha256 = "1j8hs54fn0wsf5zfzhhgiva47n9hsmfa74iinahz6nmcs8iy75aj";
      system = "cl-strings";
      asd = "cl-strings";
    });
    systems = [ "cl-strings" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-strings-tests = (build-asdf-system {
    pname = "cl-strings-tests";
    version = "20210411-git";
    asds = [ "cl-strings-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-strings/2021-04-11/cl-strings-20210411-git.tgz";
      sha256 = "1j8hs54fn0wsf5zfzhhgiva47n9hsmfa74iinahz6nmcs8iy75aj";
      system = "cl-strings-tests";
      asd = "cl-strings";
    });
    systems = [ "cl-strings-tests" ];
    lispLibs = [ (getAttr "cl-strings" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-svg = (build-asdf-system {
    pname = "cl-svg";
    version = "20180228-git";
    asds = [ "cl-svg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-svg/2018-02-28/cl-svg-20180228-git.tgz";
      sha256 = "11rmzimy6j7ln7q5y1h2kw1225rsfb6fpn89qjcq7h5lc8fay0wz";
      system = "cl-svg";
      asd = "cl-svg";
    });
    systems = [ "cl-svg" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-svm = (build-asdf-system {
    pname = "cl-svm";
    version = "20110418-git";
    asds = [ "cl-svm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-svm/2011-04-18/cl-svm-20110418-git.tgz";
      sha256 = "03d070k3bl5c0b2f6bzig5gkhlj074v74f7kg8hh3znrbmwji2wv";
      system = "cl-svm";
      asd = "cl-svm";
    });
    systems = [ "cl-svm" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-swagger = (build-asdf-system {
    pname = "cl-swagger";
    version = "20180831-git";
    asds = [ "cl-swagger" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-swagger-codegen/2018-08-31/cl-swagger-codegen-20180831-git.tgz";
      sha256 = "1lkp69n7wscyf2az3h2bmxmvzzppdfxcq5s0m607b1f7nfmxzjsq";
      system = "cl-swagger";
      asd = "cl-swagger";
    });
    systems = [ "cl-swagger" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "cl-mustache" self) (getAttr "cl-ppcre" self) (getAttr "drakma" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sxml = (build-asdf-system {
    pname = "cl-sxml";
    version = "20200325-git";
    asds = [ "cl-sxml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sxml/2020-03-25/cl-sxml-20200325-git.tgz";
      sha256 = "1105s9whidq1lf0lli2wdhcfcs5gwzxa0h1x3izx4mp2p7psvciz";
      system = "cl-sxml";
      asd = "cl-sxml";
    });
    systems = [ "cl-sxml" ];
    lispLibs = [ (getAttr "cxml" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-sxml-test = (build-asdf-system {
    pname = "cl-sxml-test";
    version = "20200325-git";
    asds = [ "cl-sxml-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-sxml/2020-03-25/cl-sxml-20200325-git.tgz";
      sha256 = "1105s9whidq1lf0lli2wdhcfcs5gwzxa0h1x3izx4mp2p7psvciz";
      system = "cl-sxml-test";
      asd = "cl-sxml";
    });
    systems = [ "cl-sxml-test" ];
    lispLibs = [ (getAttr "cl-sxml" self) (getAttr "fiveam" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax = (build-asdf-system {
    pname = "cl-syntax";
    version = "20150407-git";
    asds = [ "cl-syntax" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax";
      asd = "cl-syntax";
    });
    systems = [ "cl-syntax" ];
    lispLibs = [ (getAttr "named-readtables" self) (getAttr "trivial-types" self) ];
    meta = {};
  });
  cl-syntax-annot = (build-asdf-system {
    pname = "cl-syntax-annot";
    version = "20150407-git";
    asds = [ "cl-syntax-annot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-annot";
      asd = "cl-syntax-annot";
    });
    systems = [ "cl-syntax-annot" ];
    lispLibs = [ (getAttr "cl-annot" self) (getAttr "cl-syntax" self) ];
    meta = {};
  });
  cl-syntax-anonfun = (build-asdf-system {
    pname = "cl-syntax-anonfun";
    version = "20150407-git";
    asds = [ "cl-syntax-anonfun" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-anonfun";
      asd = "cl-syntax-anonfun";
    });
    systems = [ "cl-syntax-anonfun" ];
    lispLibs = [ (getAttr "cl-anonfun" self) (getAttr "cl-syntax" self) ];
    meta = {};
  });
  cl-syntax-clsql = (build-asdf-system {
    pname = "cl-syntax-clsql";
    version = "20150407-git";
    asds = [ "cl-syntax-clsql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-clsql";
      asd = "cl-syntax-clsql";
    });
    systems = [ "cl-syntax-clsql" ];
    lispLibs = [ (getAttr "cl-syntax" self) (getAttr "clsql" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax-debug-print = (build-asdf-system {
    pname = "cl-syntax-debug-print";
    version = "20210807-git";
    asds = [ "cl-syntax-debug-print" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-debug-print/2021-08-07/cl-debug-print-20210807-git.tgz";
      sha256 = "1cm5nybmv0pq9s4lrwhd01rjj1wlcj1sjcrcakabi7w7b5zw4cyh";
      system = "cl-syntax-debug-print";
      asd = "cl-syntax-debug-print";
    });
    systems = [ "cl-syntax-debug-print" ];
    lispLibs = [ (getAttr "cl-debug-print" self) (getAttr "cl-syntax" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax-fare-quasiquote = (build-asdf-system {
    pname = "cl-syntax-fare-quasiquote";
    version = "20150407-git";
    asds = [ "cl-syntax-fare-quasiquote" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-fare-quasiquote";
      asd = "cl-syntax-fare-quasiquote";
    });
    systems = [ "cl-syntax-fare-quasiquote" ];
    lispLibs = [ (getAttr "cl-syntax" self) (getAttr "fare-quasiquote" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax-interpol = (build-asdf-system {
    pname = "cl-syntax-interpol";
    version = "20150407-git";
    asds = [ "cl-syntax-interpol" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-interpol";
      asd = "cl-syntax-interpol";
    });
    systems = [ "cl-syntax-interpol" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cl-syntax" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax-lsx = (build-asdf-system {
    pname = "cl-syntax-lsx";
    version = "20220220-git";
    asds = [ "cl-syntax-lsx" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/lsx/2022-02-20/lsx-20220220-git.tgz";
      sha256 = "1pdq6csr8pkzcq2zkhhm6wkp9zxx2aypjd16rcw4q43mff09y041";
      system = "cl-syntax-lsx";
      asd = "cl-syntax-lsx";
    });
    systems = [ "cl-syntax-lsx" ];
    lispLibs = [ (getAttr "cl-syntax" self) (getAttr "lsx" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-syntax-markup = (build-asdf-system {
    pname = "cl-syntax-markup";
    version = "20150407-git";
    asds = [ "cl-syntax-markup" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syntax/2015-04-07/cl-syntax-20150407-git.tgz";
      sha256 = "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y";
      system = "cl-syntax-markup";
      asd = "cl-syntax-markup";
    });
    systems = [ "cl-syntax-markup" ];
    lispLibs = [ (getAttr "cl-markup" self) (getAttr "cl-syntax" self) ];
    meta = {};
  });
  cl-syslog = (build-asdf-system {
    pname = "cl-syslog";
    version = "20190202-git";
    asds = [ "cl-syslog" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-syslog/2019-02-02/cl-syslog-20190202-git.tgz";
      sha256 = "1qcz55jiqwk91b01hsahxnha884f6zf2883j2m51sqph0mvj69mh";
      system = "cl-syslog";
      asd = "cl-syslog";
    });
    systems = [ "cl-syslog" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cffi" self) (getAttr "global-vars" self) (getAttr "local-time" self) (getAttr "split-sequence" self) (getAttr "usocket" self) ];
    meta = {};
  });
  cl-table = (build-asdf-system {
    pname = "cl-table";
    version = "20130128-git";
    asds = [ "cl-table" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-table/2013-01-28/cl-table-20130128-git.tgz";
      sha256 = "0c7bdnpi473grayycdcdh4q8fi137i3c80k05k87pvjdrl1qnkpn";
      system = "cl-table";
      asd = "cl-table";
    });
    systems = [ "cl-table" ];
    lispLibs = [ (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tasukete = (build-asdf-system {
    pname = "cl-tasukete";
    version = "20180228-git";
    asds = [ "cl-tasukete" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tasukete/2018-02-28/cl-tasukete-20180228-git.tgz";
      sha256 = "0i8ibg2a33mb32vr2b70psb5dvh47r52lfhkh84rxzmcsk6ww230";
      system = "cl-tasukete";
      asd = "cl-tasukete";
    });
    systems = [ "cl-tasukete" ];
    lispLibs = [ (getAttr "cl-annot" self) (getAttr "cl-gists" self) (getAttr "dissect" self) (getAttr "jonathan" self) (getAttr "local-time" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tasukete-test = (build-asdf-system {
    pname = "cl-tasukete-test";
    version = "20180228-git";
    asds = [ "cl-tasukete-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tasukete/2018-02-28/cl-tasukete-20180228-git.tgz";
      sha256 = "0i8ibg2a33mb32vr2b70psb5dvh47r52lfhkh84rxzmcsk6ww230";
      system = "cl-tasukete-test";
      asd = "cl-tasukete-test";
    });
    systems = [ "cl-tasukete-test" ];
    lispLibs = [ (getAttr "cl-tasukete" self) (getAttr "dissect" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-telebot = (build-asdf-system {
    pname = "cl-telebot";
    version = "20211020-git";
    asds = [ "cl-telebot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-telebot/2021-10-20/cl-telebot-20211020-git.tgz";
      sha256 = "0nl002l4f3x6843s6h5w2iz2hganxb369k8c2hbbgqq7plb4mdf1";
      system = "cl-telebot";
      asd = "cl-telebot";
    });
    systems = [ "cl-telebot" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "dexador" self) (getAttr "jonathan" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-telegram-bot = (build-asdf-system {
    pname = "cl-telegram-bot";
    version = "20230618-git";
    asds = [ "cl-telegram-bot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-telegram-bot/2023-06-18/cl-telegram-bot-20230618-git.tgz";
      sha256 = "11a1fswifiaa14ilzp1lsncwvmqwgwlcxccx16sa1j3ip44lbr3v";
      system = "cl-telegram-bot";
      asd = "cl-telegram-bot";
    });
    systems = [ "cl-telegram-bot" ];
    lispLibs = [ (getAttr "_40ants-asdf-system" self) (getAttr "alexandria" self) (getAttr "arrows" self) (getAttr "bordeaux-threads" self) (getAttr "cl-ppcre" self) (getAttr "cl-strings" self) (getAttr "closer-mop" self) (getAttr "dexador" self) (getAttr "jonathan" self) (getAttr "kebab" self) (getAttr "log4cl" self) (getAttr "serapeum" self) (getAttr "trivial-backtrace" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-telegram-bot-ci = (build-asdf-system {
    pname = "cl-telegram-bot-ci";
    version = "20230618-git";
    asds = [ "cl-telegram-bot-ci" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-telegram-bot/2023-06-18/cl-telegram-bot-20230618-git.tgz";
      sha256 = "11a1fswifiaa14ilzp1lsncwvmqwgwlcxccx16sa1j3ip44lbr3v";
      system = "cl-telegram-bot-ci";
      asd = "cl-telegram-bot-ci";
    });
    systems = [ "cl-telegram-bot-ci" ];
    lispLibs = [ (getAttr "_40ants-ci" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-telegram-bot-docs = (build-asdf-system {
    pname = "cl-telegram-bot-docs";
    version = "20230618-git";
    asds = [ "cl-telegram-bot-docs" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-telegram-bot/2023-06-18/cl-telegram-bot-20230618-git.tgz";
      sha256 = "11a1fswifiaa14ilzp1lsncwvmqwgwlcxccx16sa1j3ip44lbr3v";
      system = "cl-telegram-bot-docs";
      asd = "cl-telegram-bot-docs";
    });
    systems = [ "cl-telegram-bot-docs" ];
    lispLibs = [ (getAttr "_40ants-doc" self) (getAttr "cl-telegram-bot" self) (getAttr "docs-config" self) (getAttr "named-readtables" self) (getAttr "pythonic-string-reader" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-telegram-bot-tests = (build-asdf-system {
    pname = "cl-telegram-bot-tests";
    version = "20230618-git";
    asds = [ "cl-telegram-bot-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-telegram-bot/2023-06-18/cl-telegram-bot-20230618-git.tgz";
      sha256 = "11a1fswifiaa14ilzp1lsncwvmqwgwlcxccx16sa1j3ip44lbr3v";
      system = "cl-telegram-bot-tests";
      asd = "cl-telegram-bot-tests";
    });
    systems = [ "cl-telegram-bot-tests" ];
    lispLibs = [ (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-template = (build-asdf-system {
    pname = "cl-template";
    version = "20130615-git";
    asds = [ "cl-template" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-template/2013-06-15/cl-template-20130615-git.tgz";
      sha256 = "1rhg023a2nxsk5x6abd6i0a8sh36aj0bgsh80w60m3b7xlsva2x2";
      system = "cl-template";
      asd = "cl-template";
    });
    systems = [ "cl-template" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-template-tests = (build-asdf-system {
    pname = "cl-template-tests";
    version = "20130615-git";
    asds = [ "cl-template-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-template/2013-06-15/cl-template-20130615-git.tgz";
      sha256 = "1rhg023a2nxsk5x6abd6i0a8sh36aj0bgsh80w60m3b7xlsva2x2";
      system = "cl-template-tests";
      asd = "cl-template";
    });
    systems = [ "cl-template-tests" ];
    lispLibs = [ (getAttr "cl-template" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-termbox = (build-asdf-system {
    pname = "cl-termbox";
    version = "20211020-git";
    asds = [ "cl-termbox" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-termbox/2021-10-20/cl-termbox-20211020-git.tgz";
      sha256 = "1igmq64zndkgchmzggp34jrmxa81dqlhz2il8qizrpfw5a39cpld";
      system = "cl-termbox";
      asd = "cl-termbox";
    });
    systems = [ "cl-termbox" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tesseract = (build-asdf-system {
    pname = "cl-tesseract";
    version = "20171130-git";
    asds = [ "cl-tesseract" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tesseract/2017-11-30/cl-tesseract-20171130-git.tgz";
      sha256 = "086627k8whbj60bpw9r3jrdifr4bigqpnp9hxsi7r6702gixz50x";
      system = "cl-tesseract";
      asd = "cl-tesseract";
    });
    systems = [ "cl-tesseract" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-test-more = (build-asdf-system {
    pname = "cl-test-more";
    version = "20200218-git";
    asds = [ "cl-test-more" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/prove/2020-02-18/prove-20200218-git.tgz";
      sha256 = "0ca6ha3zhmckq3ad9lxm6sbg4i0hg3m81xhan4dkxd3x9898jzpc";
      system = "cl-test-more";
      asd = "cl-test-more";
    });
    systems = [ "cl-test-more" ];
    lispLibs = [ (getAttr "prove" self) ];
    meta = {};
  });
  cl-tetris3d = (build-asdf-system {
    pname = "cl-tetris3d";
    version = "20181210-git";
    asds = [ "cl-tetris3d" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tetris3d/2018-12-10/cl-tetris3d-20181210-git.tgz";
      sha256 = "09n7344is2vfbp32cd22ynk14h4vqs4xw3plbhga8q25ghhx5y9p";
      system = "cl-tetris3d";
      asd = "cl-tetris3d";
    });
    systems = [ "cl-tetris3d" ];
    lispLibs = [ (getAttr "cl-glu" self) (getAttr "cl-opengl" self) (getAttr "iterate" self) (getAttr "lispbuilder-sdl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-textmagic = (build-asdf-system {
    pname = "cl-textmagic";
    version = "20151218-git";
    asds = [ "cl-textmagic" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-textmagic/2015-12-18/cl-textmagic-20151218-git.tgz";
      sha256 = "0xw6g1r5vxmnbz3kxf2q6s9dr9l2aacyri1wchzw4jx5wlcnkshw";
      system = "cl-textmagic";
      asd = "cl-textmagic";
    });
    systems = [ "cl-textmagic" ];
    lispLibs = [ (getAttr "cl-json" self) (getAttr "dexador" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-textmagic-test = (build-asdf-system {
    pname = "cl-textmagic-test";
    version = "20151218-git";
    asds = [ "cl-textmagic-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-textmagic/2015-12-18/cl-textmagic-20151218-git.tgz";
      sha256 = "0xw6g1r5vxmnbz3kxf2q6s9dr9l2aacyri1wchzw4jx5wlcnkshw";
      system = "cl-textmagic-test";
      asd = "cl-textmagic-test";
    });
    systems = [ "cl-textmagic-test" ];
    lispLibs = [ (getAttr "cl-textmagic" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tga = (build-asdf-system {
    pname = "cl-tga";
    version = "20160318-git";
    asds = [ "cl-tga" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tga/2016-03-18/cl-tga-20160318-git.tgz";
      sha256 = "03k3npmn0xd3fd2m7vwxph82av2xrfb150imqrinlzqmzvz1v1br";
      system = "cl-tga";
      asd = "cl-tga";
    });
    systems = [ "cl-tga" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-threadpool = (build-asdf-system {
    pname = "cl-threadpool";
    version = "quickload-current-release-6f50a83e-git";
    asds = [ "cl-threadpool" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-threadpool/2023-06-18/cl-threadpool-quickload-current-release-6f50a83e-git.tgz";
      sha256 = "17zdinrp31d6b9fdb2mi83cwmcgpj7wqzbqy5kjlfc6p6jspcqln";
      system = "cl-threadpool";
      asd = "cl-threadpool";
    });
    systems = [ "cl-threadpool" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "queues_dot_simple-cqueue" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tidy = (build-asdf-system {
    pname = "cl-tidy";
    version = "20170830-git";
    asds = [ "cl-tidy" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tidy/2017-08-30/cl-tidy-20170830-git.tgz";
      sha256 = "13j0jgf6czb24148w2wxfwlji6vnc49qvyr5wzq5ps55b27ddlz6";
      system = "cl-tidy";
      asd = "cl-tidy";
    });
    systems = [ "cl-tidy" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tiled = (build-asdf-system {
    pname = "cl-tiled";
    version = "20230618-git";
    asds = [ "cl-tiled" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tiled/2023-06-18/cl-tiled-20230618-git.tgz";
      sha256 = "050ylqmwxmdjn8lzhh9al1hf0arjn2jhznfcrl71aiks8q0bx1sm";
      system = "cl-tiled";
      asd = "cl-tiled";
    });
    systems = [ "cl-tiled" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "chipz" self) (getAttr "cl-base64" self) (getAttr "cl-json" self) (getAttr "nibbles" self) (getAttr "parse-float" self) (getAttr "split-sequence" self) (getAttr "xmls" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tk = (build-asdf-system {
    pname = "cl-tk";
    version = "20150608-git";
    asds = [ "cl-tk" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tk/2015-06-08/cl-tk-20150608-git.tgz";
      sha256 = "0fm4q4pkzbyxr6227vavvy4lm7rfw214lp2dylgzjzcp6f5r4n7w";
      system = "cl-tk";
      asd = "cl-tk";
    });
    systems = [ "cl-tk" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tld = (build-asdf-system {
    pname = "cl-tld";
    version = "20220220-git";
    asds = [ "cl-tld" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tld/2022-02-20/cl-tld-20220220-git.tgz";
      sha256 = "1xm471p92in5g4fcxgqshwgr2d7937jw7jv6j473slwkxjvx8dp6";
      system = "cl-tld";
      asd = "cl-tld";
    });
    systems = [ "cl-tld" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tls = (build-asdf-system {
    pname = "cl-tls";
    version = "20221106-git";
    asds = [ "cl-tls" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tls/2022-11-06/cl-tls-20221106-git.tgz";
      sha256 = "1j6gwv21ibkk6xd1xxm54wgwp09dzqg60b8z72hivpnq8gwm0ba7";
      system = "cl-tls";
      asd = "cl-tls";
    });
    systems = [ "cl-tls" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-base64" self) (getAttr "fast-io" self) (getAttr "ironclad" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tokyo-cabinet = (build-asdf-system {
    pname = "cl-tokyo-cabinet";
    version = "20160825-git";
    asds = [ "cl-tokyo-cabinet" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tokyo-cabinet/2016-08-25/cl-tokyo-cabinet-20160825-git.tgz";
      sha256 = "07961in8fa09bjnpwkdn0w6dj37nppzmgg50kf8khspnjh1sjsr2";
      system = "cl-tokyo-cabinet";
      asd = "cl-tokyo-cabinet";
    });
    systems = [ "cl-tokyo-cabinet" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "deoxybyte-systems" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tokyo-cabinet-test = (build-asdf-system {
    pname = "cl-tokyo-cabinet-test";
    version = "20160825-git";
    asds = [ "cl-tokyo-cabinet-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tokyo-cabinet/2016-08-25/cl-tokyo-cabinet-20160825-git.tgz";
      sha256 = "07961in8fa09bjnpwkdn0w6dj37nppzmgg50kf8khspnjh1sjsr2";
      system = "cl-tokyo-cabinet-test";
      asd = "cl-tokyo-cabinet-test";
    });
    systems = [ "cl-tokyo-cabinet-test" ];
    lispLibs = [ (getAttr "cl-tokyo-cabinet" self) (getAttr "deoxybyte-io" self) (getAttr "deoxybyte-utilities" self) (getAttr "lift" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-toml = (build-asdf-system {
    pname = "cl-toml";
    version = "20191130-git";
    asds = [ "cl-toml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-toml/2019-11-30/cl-toml-20191130-git.tgz";
      sha256 = "1g5i60i78s0ms608fyc6sgaaqr6jdsln75n26lmfbcaqw2g1q9dk";
      system = "cl-toml";
      asd = "cl-toml";
    });
    systems = [ "cl-toml" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "esrap" self) (getAttr "local-time" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-toml-test = (build-asdf-system {
    pname = "cl-toml-test";
    version = "20191130-git";
    asds = [ "cl-toml-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-toml/2019-11-30/cl-toml-20191130-git.tgz";
      sha256 = "1g5i60i78s0ms608fyc6sgaaqr6jdsln75n26lmfbcaqw2g1q9dk";
      system = "cl-toml-test";
      asd = "cl-toml-test";
    });
    systems = [ "cl-toml-test" ];
    lispLibs = [ (getAttr "cl-toml" self) (getAttr "prove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tqdm = (build-asdf-system {
    pname = "cl-tqdm";
    version = "20230618-git";
    asds = [ "cl-tqdm" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tqdm/2023-06-18/cl-tqdm-20230618-git.tgz";
      sha256 = "12qkl7l83smdv5laz6hkgy5462dygc5i0ng9w7nila9j3zr0cc3y";
      system = "cl-tqdm";
      asd = "cl-tqdm";
    });
    systems = [ "cl-tqdm" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-transmission = (build-asdf-system {
    pname = "cl-transmission";
    version = "20200325-git";
    asds = [ "cl-transmission" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-transmission/2020-03-25/cl-transmission-20200325-git.tgz";
      sha256 = "0sg3f2jqs2z3mvscjhc43hkd34vlcc4c8hq8rhh5w1gjg19z57hb";
      system = "cl-transmission";
      asd = "cl-transmission";
    });
    systems = [ "cl-transmission" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "drakma" self) (getAttr "jonathan" self) (getAttr "named-readtables" self) (getAttr "rutils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-transmission-test = (build-asdf-system {
    pname = "cl-transmission-test";
    version = "20200325-git";
    asds = [ "cl-transmission-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-transmission/2020-03-25/cl-transmission-20200325-git.tgz";
      sha256 = "0sg3f2jqs2z3mvscjhc43hkd34vlcc4c8hq8rhh5w1gjg19z57hb";
      system = "cl-transmission-test";
      asd = "cl-transmission-test";
    });
    systems = [ "cl-transmission-test" ];
    lispLibs = [ (getAttr "cl-transmission" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-trie = (build-asdf-system {
    pname = "cl-trie";
    version = "20230214-git";
    asds = [ "cl-trie" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-trie/2023-02-14/cl-trie-20230214-git.tgz";
      sha256 = "0d0mnac9rbqvwr45650yimfw4fyldbgasj139g7y1wzrranrcldf";
      system = "cl-trie";
      asd = "cl-trie";
    });
    systems = [ "cl-trie" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-trie-examples = (build-asdf-system {
    pname = "cl-trie-examples";
    version = "20230214-git";
    asds = [ "cl-trie-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-trie/2023-02-14/cl-trie-20230214-git.tgz";
      sha256 = "0d0mnac9rbqvwr45650yimfw4fyldbgasj139g7y1wzrranrcldf";
      system = "cl-trie-examples";
      asd = "cl-trie-examples";
    });
    systems = [ "cl-trie-examples" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-trie" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tui = (build-asdf-system {
    pname = "cl-tui";
    version = "20200427-git";
    asds = [ "cl-tui" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tui/2020-04-27/cl-tui-20200427-git.tgz";
      sha256 = "1s0z7sjb3p1fxypc2x9fl0y094qa1a2iqjbn5him4hs8z7xm5kz8";
      system = "cl-tui";
      asd = "cl-tui";
    });
    systems = [ "cl-tui" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "anaphora" self) (getAttr "cl-charms" self) (getAttr "cl-containers" self) (getAttr "osicat" self) (getAttr "split-sequence" self) (getAttr "trivial-types" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tulip-graph = (build-asdf-system {
    pname = "cl-tulip-graph";
    version = "20130615-git";
    asds = [ "cl-tulip-graph" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tulip-graph/2013-06-15/cl-tulip-graph-20130615-git.tgz";
      sha256 = "0zmmwqabbyzdikn8x0xqrj192wr5w87l828nwandqg59af2isxav";
      system = "cl-tulip-graph";
      asd = "cl-tulip-graph";
    });
    systems = [ "cl-tulip-graph" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-tuples = (build-asdf-system {
    pname = "cl-tuples";
    version = "20140713-git";
    asds = [ "cl-tuples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-tuples/2014-07-13/cl-tuples-20140713-git.tgz";
      sha256 = "060xmr03y8n0mnf4x4fnrirljcjk1jcir7jsjq4w9d5vzq3aqm9m";
      system = "cl-tuples";
      asd = "cl-tuples";
    });
    systems = [ "cl-tuples" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-twit-repl = (build-asdf-system {
    pname = "cl-twit-repl";
    version = "20180228-git";
    asds = [ "cl-twit-repl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-twitter/2018-02-28/cl-twitter-20180228-git.tgz";
      sha256 = "07l86c63ssahpz3s9f7d99mbzmh60askkpdrhjrdbzd1vxlwkhcr";
      system = "cl-twit-repl";
      asd = "cl-twit-repl";
    });
    systems = [ "cl-twit-repl" ];
    lispLibs = [ (getAttr "cl-twitter" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-twitter = (build-asdf-system {
    pname = "cl-twitter";
    version = "20180228-git";
    asds = [ "cl-twitter" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-twitter/2018-02-28/cl-twitter-20180228-git.tgz";
      sha256 = "07l86c63ssahpz3s9f7d99mbzmh60askkpdrhjrdbzd1vxlwkhcr";
      system = "cl-twitter";
      asd = "cl-twitter";
    });
    systems = [ "cl-twitter" ];
    lispLibs = [ (getAttr "anaphora" self) (getAttr "cl-json" self) (getAttr "cl-oauth" self) (getAttr "cl-ppcre" self) (getAttr "closer-mop" self) (getAttr "drakma" self) (getAttr "trivial-http" self) (getAttr "url-rewrite" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-typesetting = (build-asdf-system {
    pname = "cl-typesetting";
    version = "20210531-git";
    asds = [ "cl-typesetting" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-typesetting/2021-05-31/cl-typesetting-20210531-git.tgz";
      sha256 = "0fcs5mq0gxfczbrg7ay8r4bf5r4g6blvpdbjkhcl8dapcikyn35h";
      system = "cl-typesetting";
      asd = "cl-typesetting";
    });
    systems = [ "cl-typesetting" ];
    lispLibs = [ (getAttr "cl-pdf" self) ];
    meta = {};
  });
  cl-uglify-js = (build-asdf-system {
    pname = "cl-uglify-js";
    version = "20150709-git";
    asds = [ "cl-uglify-js" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-uglify-js/2015-07-09/cl-uglify-js-20150709-git.tgz";
      sha256 = "0k39y3c93jgxpr7gwz7w0d8yknn1fdnxrjhd03057lvk5w8js27a";
      system = "cl-uglify-js";
      asd = "cl-uglify-js";
    });
    systems = [ "cl-uglify-js" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-ppcre-unicode" self) (getAttr "iterate" self) (getAttr "parse-js" self) (getAttr "parse-number" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-unac = (build-asdf-system {
    pname = "cl-unac";
    version = "20230618-git";
    asds = [ "cl-unac" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unac/2023-06-18/cl-unac-20230618-git.tgz";
      sha256 = "16i4lwg70k05dw3vynyyz09ldgr4zzd1ar68g4jcxk7q4ijfdw9m";
      system = "cl-unac";
      asd = "cl-unac";
    });
    systems = [ "cl-unac" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "cl-unac_dot_config" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-unac_dot_config = (build-asdf-system {
    pname = "cl-unac.config";
    version = "20230618-git";
    asds = [ "cl-unac.config" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unac/2023-06-18/cl-unac-20230618-git.tgz";
      sha256 = "16i4lwg70k05dw3vynyyz09ldgr4zzd1ar68g4jcxk7q4ijfdw9m";
      system = "cl-unac.config";
      asd = "cl-unac.config";
    });
    systems = [ "cl-unac.config" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-unac_dot_tests = (build-asdf-system {
    pname = "cl-unac.tests";
    version = "20230618-git";
    asds = [ "cl-unac.tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unac/2023-06-18/cl-unac-20230618-git.tgz";
      sha256 = "16i4lwg70k05dw3vynyyz09ldgr4zzd1ar68g4jcxk7q4ijfdw9m";
      system = "cl-unac.tests";
      asd = "cl-unac.tests";
    });
    systems = [ "cl-unac.tests" ];
    lispLibs = [ (getAttr "cl-unac" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-unicode = (build-asdf-system {
    pname = "cl-unicode";
    version = "20210228-git";
    asds = [ "cl-unicode" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unicode/2021-02-28/cl-unicode-20210228-git.tgz";
      sha256 = "1a9gbzvi5gj3z9gcia1rgmnk0dzgc82vz47bgnfvhn4q0c7mvk31";
      system = "cl-unicode";
      asd = "cl-unicode";
    });
    systems = [ "cl-unicode" ];
    lispLibs = [ (getAttr "cl-ppcre" self) ];
    meta = {};
  });
  cl-unification = (build-asdf-system {
    pname = "cl-unification";
    version = "20230214-git";
    asds = [ "cl-unification" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unification/2023-02-14/cl-unification-20230214-git.tgz";
      sha256 = "1ngb74ngn9j6pxkp0nddgnq32jpkr2gvnb71swvziqic1d93194l";
      system = "cl-unification";
      asd = "cl-unification";
    });
    systems = [ "cl-unification" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-unification-lib = (build-asdf-system {
    pname = "cl-unification-lib";
    version = "20230214-git";
    asds = [ "cl-unification-lib" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unification/2023-02-14/cl-unification-20230214-git.tgz";
      sha256 = "1ngb74ngn9j6pxkp0nddgnq32jpkr2gvnb71swvziqic1d93194l";
      system = "cl-unification-lib";
      asd = "cl-unification-lib";
    });
    systems = [ "cl-unification-lib" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cl-unification" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-unification-test = (build-asdf-system {
    pname = "cl-unification-test";
    version = "20230214-git";
    asds = [ "cl-unification-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-unification/2023-02-14/cl-unification-20230214-git.tgz";
      sha256 = "1ngb74ngn9j6pxkp0nddgnq32jpkr2gvnb71swvziqic1d93194l";
      system = "cl-unification-test";
      asd = "cl-unification-test";
    });
    systems = [ "cl-unification-test" ];
    lispLibs = [ (getAttr "cl-unification" self) (getAttr "ptester" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-union-find = (build-asdf-system {
    pname = "cl-union-find";
    version = "20221106-git";
    asds = [ "cl-union-find" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-union-find/2022-11-06/cl-union-find-20221106-git.tgz";
      sha256 = "14xciva5v3c4zi4vzp1vfhs82a2654yhkfyllr3b0cr7x36jdm7y";
      system = "cl-union-find";
      asd = "cl-union-find";
    });
    systems = [ "cl-union-find" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-utilities = (build-asdf-system {
    pname = "cl-utilities";
    version = "1.2.4";
    asds = [ "cl-utilities" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-utilities/2010-10-06/cl-utilities-1.2.4.tgz";
      sha256 = "1dmbkdr8xm2jw5yx1makqbf1ypqbm0hpkd7zyknxv3cblvz0a87w";
      system = "cl-utilities";
      asd = "cl-utilities";
    });
    systems = [ "cl-utilities" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-variates = (build-asdf-system {
    pname = "cl-variates";
    version = "20180131-darcs";
    asds = [ "cl-variates" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-variates/2018-01-31/cl-variates-20180131-darcs.tgz";
      sha256 = "02pd02isfxrn3h8h5kh369rwy17hfjkmd7j24pcihfskamgcqgfx";
      system = "cl-variates";
      asd = "cl-variates";
    });
    systems = [ "cl-variates" ];
    lispLibs = [ (getAttr "asdf-system-connections" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-vectors = (build-asdf-system {
    pname = "cl-vectors";
    version = "20180228-git";
    asds = [ "cl-vectors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vectors/2018-02-28/cl-vectors-20180228-git.tgz";
      sha256 = "0nckw4zb6s96hll8hrxzvgs2an3bfm0pxcywshbm4bq4rn7niqg4";
      system = "cl-vectors";
      asd = "cl-vectors";
    });
    systems = [ "cl-vectors" ];
    lispLibs = [ (getAttr "cl-aa" self) (getAttr "cl-paths" self) ];
    meta = {};
  });
  cl-vhdl = (build-asdf-system {
    pname = "cl-vhdl";
    version = "20160421-git";
    asds = [ "cl-vhdl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vhdl/2016-04-21/cl-vhdl-20160421-git.tgz";
      sha256 = "0i2780ljak8kcqa2zm24dk2fk771m2mvmnbq4xd4vvx9z87lbnvi";
      system = "cl-vhdl";
      asd = "cl-vhdl";
    });
    systems = [ "cl-vhdl" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "cl-itertools" self) (getAttr "cl-ppcre" self) (getAttr "esrap-liquid" self) (getAttr "iterate" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-vhdl-tests = (build-asdf-system {
    pname = "cl-vhdl-tests";
    version = "20160421-git";
    asds = [ "cl-vhdl-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vhdl/2016-04-21/cl-vhdl-20160421-git.tgz";
      sha256 = "0i2780ljak8kcqa2zm24dk2fk771m2mvmnbq4xd4vvx9z87lbnvi";
      system = "cl-vhdl-tests";
      asd = "cl-vhdl";
    });
    systems = [ "cl-vhdl-tests" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cl-vhdl" self) (getAttr "fare-quasiquote-optima" self) (getAttr "fiveam" self) (getAttr "optima" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-video = (build-asdf-system {
    pname = "cl-video";
    version = "20180228-git";
    asds = [ "cl-video" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-video/2018-02-28/cl-video-20180228-git.tgz";
      sha256 = "1azldcp6r0j1kw6rczicmnv4m0d7rq4m5axz48ny6r2qybha80lr";
      system = "cl-video";
      asd = "cl-video";
    });
    systems = [ "cl-video" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-video-avi = (build-asdf-system {
    pname = "cl-video-avi";
    version = "20180228-git";
    asds = [ "cl-video-avi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-video/2018-02-28/cl-video-20180228-git.tgz";
      sha256 = "1azldcp6r0j1kw6rczicmnv4m0d7rq4m5axz48ny6r2qybha80lr";
      system = "cl-video-avi";
      asd = "cl-video-avi";
    });
    systems = [ "cl-video-avi" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-jpeg" self) (getAttr "cl-riff" self) (getAttr "cl-video" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-video-gif = (build-asdf-system {
    pname = "cl-video-gif";
    version = "20180228-git";
    asds = [ "cl-video-gif" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-video/2018-02-28/cl-video-20180228-git.tgz";
      sha256 = "1azldcp6r0j1kw6rczicmnv4m0d7rq4m5axz48ny6r2qybha80lr";
      system = "cl-video-gif";
      asd = "cl-video-gif";
    });
    systems = [ "cl-video-gif" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-video" self) (getAttr "skippy" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-video-player = (build-asdf-system {
    pname = "cl-video-player";
    version = "20180228-git";
    asds = [ "cl-video-player" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-video/2018-02-28/cl-video-20180228-git.tgz";
      sha256 = "1azldcp6r0j1kw6rczicmnv4m0d7rq4m5axz48ny6r2qybha80lr";
      system = "cl-video-player";
      asd = "cl-video-player";
    });
    systems = [ "cl-video-player" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "cl-portaudio" self) (getAttr "cl-video-avi" self) (getAttr "cl-video-gif" self) (getAttr "cl-video-wav" self) (getAttr "clx" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-video-wav = (build-asdf-system {
    pname = "cl-video-wav";
    version = "20180228-git";
    asds = [ "cl-video-wav" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-video/2018-02-28/cl-video-20180228-git.tgz";
      sha256 = "1azldcp6r0j1kw6rczicmnv4m0d7rq4m5axz48ny6r2qybha80lr";
      system = "cl-video-wav";
      asd = "cl-video-wav";
    });
    systems = [ "cl-video-wav" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-riff" self) (getAttr "cl-video" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-virtualbox = (build-asdf-system {
    pname = "cl-virtualbox";
    version = "20180831-git";
    asds = [ "cl-virtualbox" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-virtualbox/2018-08-31/cl-virtualbox-20180831-git.tgz";
      sha256 = "1jzn8jjn9yn9vgnn1r6h0iyxb6j17wm8lmf9j5hk4yqwdzb2nidv";
      system = "cl-virtualbox";
      asd = "cl-virtualbox";
    });
    systems = [ "cl-virtualbox" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-vorbis = (build-asdf-system {
    pname = "cl-vorbis";
    version = "20230214-git";
    asds = [ "cl-vorbis" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-vorbis/2023-02-14/cl-vorbis-20230214-git.tgz";
      sha256 = "0713pl5c2khfpf8m3h1l2y0ilack7akf580h70jq6qcrnq3h4b40";
      system = "cl-vorbis";
      asd = "cl-vorbis";
    });
    systems = [ "cl-vorbis" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "documentation-utils" self) (getAttr "static-vectors" self) (getAttr "trivial-features" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-voxelize = (build-asdf-system {
    pname = "cl-voxelize";
    version = "20150709-git";
    asds = [ "cl-voxelize" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-voxelize/2015-07-09/cl-voxelize-20150709-git.tgz";
      sha256 = "1sim8n175dgy0i0dxi1vsqzgjx07lgsnrgn3bizzka58ni5y8xdm";
      system = "cl-voxelize";
      asd = "cl-voxelize";
    });
    systems = [ "cl-voxelize" ];
    lispLibs = [ (getAttr "alexandria" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-voxelize-examples = (build-asdf-system {
    pname = "cl-voxelize-examples";
    version = "20150709-git";
    asds = [ "cl-voxelize-examples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-voxelize/2015-07-09/cl-voxelize-20150709-git.tgz";
      sha256 = "1sim8n175dgy0i0dxi1vsqzgjx07lgsnrgn3bizzka58ni5y8xdm";
      system = "cl-voxelize-examples";
      asd = "cl-voxelize-examples";
    });
    systems = [ "cl-voxelize-examples" ];
    lispLibs = [ (getAttr "cl-ply" self) (getAttr "cl-voxelize" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-voxelize-test = (build-asdf-system {
    pname = "cl-voxelize-test";
    version = "20150709-git";
    asds = [ "cl-voxelize-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-voxelize/2015-07-09/cl-voxelize-20150709-git.tgz";
      sha256 = "1sim8n175dgy0i0dxi1vsqzgjx07lgsnrgn3bizzka58ni5y8xdm";
      system = "cl-voxelize-test";
      asd = "cl-voxelize-test";
    });
    systems = [ "cl-voxelize-test" ];
    lispLibs = [ (getAttr "cl-voxelize" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wadler-pprint = (build-asdf-system {
    pname = "cl-wadler-pprint";
    version = "20191007-git";
    asds = [ "cl-wadler-pprint" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wadler-pprint/2019-10-07/cl-wadler-pprint-20191007-git.tgz";
      sha256 = "0y5jxk7yiw8wng7hg91cwibh6d2hf1sv2mzqhkds6l4myhzxb4jr";
      system = "cl-wadler-pprint";
      asd = "cl-wadler-pprint";
    });
    systems = [ "cl-wadler-pprint" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wav = (build-asdf-system {
    pname = "cl-wav";
    version = "20221106-git";
    asds = [ "cl-wav" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wav/2022-11-06/cl-wav-20221106-git.tgz";
      sha256 = "1nf4zw72v0c9fl8mr4si5cr2xz753ydzv19mfzy5dqqx0k1g7wyl";
      system = "cl-wav";
      asd = "cl-wav";
    });
    systems = [ "cl-wav" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-riff" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wave-file-writer = (build-asdf-system {
    pname = "cl-wave-file-writer";
    version = "quickload-current-release-42cde6cf-git";
    asds = [ "cl-wave-file-writer" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wave-file-writer/2021-10-20/cl-wave-file-writer-quickload-current-release-42cde6cf-git.tgz";
      sha256 = "0mxzp6rm7ah86vp1xj67q43al71k62x407m5vmbldvyb6pmx37fp";
      system = "cl-wave-file-writer";
      asd = "cl-wave-file-writer";
    });
    systems = [ "cl-wave-file-writer" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wavefront = (build-asdf-system {
    pname = "cl-wavefront";
    version = "20230618-git";
    asds = [ "cl-wavefront" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wavefront/2023-06-18/cl-wavefront-20230618-git.tgz";
      sha256 = "0429bmcrwf2wjy0xlwckj8hbjkk2nyzyxck1y42b8dv1a6np8i7c";
      system = "cl-wavefront";
      asd = "cl-wavefront";
    });
    systems = [ "cl-wavefront" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "documentation-utils" self) (getAttr "parse-float" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wavelets = (build-asdf-system {
    pname = "cl-wavelets";
    version = "20220707-git";
    asds = [ "cl-wavelets" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wavelets/2022-07-07/cl-wavelets-20220707-git.tgz";
      sha256 = "0z4r01d5mv4rachz5rr5zvnv94q7ka17138vcpsb05sz00vv03ba";
      system = "cl-wavelets";
      asd = "cl-wavelets";
    });
    systems = [ "cl-wavelets" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "serapeum" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wayland = (build-asdf-system {
    pname = "cl-wayland";
    version = "20190307-git";
    asds = [ "cl-wayland" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wayland/2019-03-07/cl-wayland-20190307-git.tgz";
      sha256 = "1axdkdm5d2bvj674jq6ylwhfwbzzs7yjj6f04c519qbdq9sknbcn";
      system = "cl-wayland";
      asd = "cl-wayland";
    });
    systems = [ "cl-wayland" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-weather-jp = (build-asdf-system {
    pname = "cl-weather-jp";
    version = "20160208-git";
    asds = [ "cl-weather-jp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-weather-jp/2016-02-08/cl-weather-jp-20160208-git.tgz";
      sha256 = "15bp7gdk7ck9xs9lx2rrzqw6awlk6nz03cqy14wv2lvy3j84dc01";
      system = "cl-weather-jp";
      asd = "cl-weather-jp";
    });
    systems = [ "cl-weather-jp" ];
    lispLibs = [ (getAttr "clss" self) (getAttr "dexador" self) (getAttr "function-cache" self) (getAttr "jonathan" self) (getAttr "plump" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-weather-jp-test = (build-asdf-system {
    pname = "cl-weather-jp-test";
    version = "20160208-git";
    asds = [ "cl-weather-jp-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-weather-jp/2016-02-08/cl-weather-jp-20160208-git.tgz";
      sha256 = "15bp7gdk7ck9xs9lx2rrzqw6awlk6nz03cqy14wv2lvy3j84dc01";
      system = "cl-weather-jp-test";
      asd = "cl-weather-jp-test";
    });
    systems = [ "cl-weather-jp-test" ];
    lispLibs = [ (getAttr "cl-weather-jp" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-webdav = (build-asdf-system {
    pname = "cl-webdav";
    version = "20170830-git";
    asds = [ "cl-webdav" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-webdav/2017-08-30/cl-webdav-20170830-git.tgz";
      sha256 = "1cmzv763k4s5blfhx2p8s7q9gk20p8mj9p34dngydc14d2acrxmg";
      system = "cl-webdav";
      asd = "cl-webdav";
    });
    systems = [ "cl-webdav" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "cxml" self) (getAttr "hunchentoot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-webdriver-client = (build-asdf-system {
    pname = "cl-webdriver-client";
    version = "20211230-git";
    asds = [ "cl-webdriver-client" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-webdriver-client/2021-12-30/cl-webdriver-client-20211230-git.tgz";
      sha256 = "12ackxk5glsi2dg7kjn6gr1c6r6xnmd23hwsbb9fghwjl23cqlri";
      system = "cl-webdriver-client";
      asd = "cl-webdriver-client";
    });
    systems = [ "cl-webdriver-client" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "assoc-utils" self) (getAttr "cl-json" self) (getAttr "dexador" self) (getAttr "quri" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-webdriver-client-test = (build-asdf-system {
    pname = "cl-webdriver-client-test";
    version = "20211230-git";
    asds = [ "cl-webdriver-client-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-webdriver-client/2021-12-30/cl-webdriver-client-20211230-git.tgz";
      sha256 = "12ackxk5glsi2dg7kjn6gr1c6r6xnmd23hwsbb9fghwjl23cqlri";
      system = "cl-webdriver-client-test";
      asd = "cl-webdriver-client-test";
    });
    systems = [ "cl-webdriver-client-test" ];
    lispLibs = [ (getAttr "cl-webdriver-client" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-webkit2 = (build-asdf-system {
    pname = "cl-webkit2";
    version = "20230618-git";
    asds = [ "cl-webkit2" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-webkit/2023-06-18/cl-webkit-20230618-git.tgz";
      sha256 = "0mqgmq97yaqyz50n6r83g3ndzymr9kqcmfn8x5a7968wz74ixz1z";
      system = "cl-webkit2";
      asd = "cl-webkit2";
    });
    systems = [ "cl-webkit2" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cffi" self) (getAttr "cl-cffi-gtk" self) ];
    meta = {};
  });
  cl-who = (build-asdf-system {
    pname = "cl-who";
    version = "20220331-git";
    asds = [ "cl-who" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-who/2022-03-31/cl-who-20220331-git.tgz";
      sha256 = "1rdvs113q6d46cblwhsv1vmm31p952wyzkyibqix0ypadpczlgp5";
      system = "cl-who";
      asd = "cl-who";
    });
    systems = [ "cl-who" ];
    lispLibs = [  ];
    meta = {};
  });
  cl-who-test = (build-asdf-system {
    pname = "cl-who-test";
    version = "20220331-git";
    asds = [ "cl-who-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-who/2022-03-31/cl-who-20220331-git.tgz";
      sha256 = "1rdvs113q6d46cblwhsv1vmm31p952wyzkyibqix0ypadpczlgp5";
      system = "cl-who-test";
      asd = "cl-who";
    });
    systems = [ "cl-who-test" ];
    lispLibs = [ (getAttr "cl-who" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-why = (build-asdf-system {
    pname = "cl-why";
    version = "20180228-git";
    asds = [ "cl-why" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-why/2018-02-28/cl-why-20180228-git.tgz";
      sha256 = "01xm7gj1wwd7i3r49jfdm96gwl7nvrn0h6q22kpzrb8zs48wj947";
      system = "cl-why";
      asd = "cl-why";
    });
    systems = [ "cl-why" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-why-test = (build-asdf-system {
    pname = "cl-why-test";
    version = "20180228-git";
    asds = [ "cl-why-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-why/2018-02-28/cl-why-20180228-git.tgz";
      sha256 = "01xm7gj1wwd7i3r49jfdm96gwl7nvrn0h6q22kpzrb8zs48wj947";
      system = "cl-why-test";
      asd = "cl-why";
    });
    systems = [ "cl-why-test" ];
    lispLibs = [ (getAttr "cl-why" self) (getAttr "flexi-streams" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-with = (build-asdf-system {
    pname = "cl-with";
    version = "20211020-git";
    asds = [ "cl-with" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-with/2021-10-20/cl-with-20211020-git.tgz";
      sha256 = "1x4laq7zi12xb28rfrh8hcy92pkfvjxsp2nn6jkmrhfynky5180w";
      system = "cl-with";
      asd = "cl-with";
    });
    systems = [ "cl-with" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wol_dot_cli = (build-asdf-system {
    pname = "cl-wol.cli";
    version = "20230214-git";
    asds = [ "cl-wol.cli" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wol/2023-02-14/cl-wol-20230214-git.tgz";
      sha256 = "0nmwcm0wmbsy3fsh1ingm004610ji8z6mzb2p7lsqlvynl1z65r8";
      system = "cl-wol.cli";
      asd = "cl-wol.cli";
    });
    systems = [ "cl-wol.cli" ];
    lispLibs = [ (getAttr "cl-ascii-table" self) (getAttr "cl-migratum" self) (getAttr "cl-migratum_dot_driver_dot_dbi" self) (getAttr "cl-migratum_dot_provider_dot_local-path" self) (getAttr "cl-wol_dot_core" self) (getAttr "clingon" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wol_dot_core = (build-asdf-system {
    pname = "cl-wol.core";
    version = "20230214-git";
    asds = [ "cl-wol.core" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wol/2023-02-14/cl-wol-20230214-git.tgz";
      sha256 = "0nmwcm0wmbsy3fsh1ingm004610ji8z6mzb2p7lsqlvynl1z65r8";
      system = "cl-wol.core";
      asd = "cl-wol.core";
    });
    systems = [ "cl-wol.core" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wol_dot_test = (build-asdf-system {
    pname = "cl-wol.test";
    version = "20230214-git";
    asds = [ "cl-wol.test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wol/2023-02-14/cl-wol-20230214-git.tgz";
      sha256 = "0nmwcm0wmbsy3fsh1ingm004610ji8z6mzb2p7lsqlvynl1z65r8";
      system = "cl-wol.test";
      asd = "cl-wol.test";
    });
    systems = [ "cl-wol.test" ];
    lispLibs = [ (getAttr "cl-wol_dot_core" self) (getAttr "rove" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-wordcut = (build-asdf-system {
    pname = "cl-wordcut";
    version = "20160421-git";
    asds = [ "cl-wordcut" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-wordcut/2016-04-21/cl-wordcut-20160421-git.tgz";
      sha256 = "1b8b3b1rgk0y87l54325ilcly8rq9qxalcsmw6rk8q6dq13lgv78";
      system = "cl-wordcut";
      asd = "cl-wordcut";
    });
    systems = [ "cl-wordcut" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xdg = (build-asdf-system {
    pname = "cl-xdg";
    version = "20170124-git";
    asds = [ "cl-xdg" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xdg/2017-01-24/cl-xdg-20170124-git.tgz";
      sha256 = "078hgsab0gl6s96wq09ibq5alzyyqh6wwc3yjs44fv18561p5jgc";
      system = "cl-xdg";
      asd = "cl-xdg";
    });
    systems = [ "cl-xdg" ];
    lispLibs = [ (getAttr "cl-sxml" self) (getAttr "cl-xmlspam" self) (getAttr "flexi-streams" self) (getAttr "parse-number" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xdg-test = (build-asdf-system {
    pname = "cl-xdg-test";
    version = "20170124-git";
    asds = [ "cl-xdg-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xdg/2017-01-24/cl-xdg-20170124-git.tgz";
      sha256 = "078hgsab0gl6s96wq09ibq5alzyyqh6wwc3yjs44fv18561p5jgc";
      system = "cl-xdg-test";
      asd = "cl-xdg";
    });
    systems = [ "cl-xdg-test" ];
    lispLibs = [ (getAttr "cl-xdg" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xkb = (build-asdf-system {
    pname = "cl-xkb";
    version = "20230214-git";
    asds = [ "cl-xkb" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xkb/2023-02-14/cl-xkb-20230214-git.tgz";
      sha256 = "002bskv0dvq2hahz7dah2zwwkp2zrkf98w7lm96jmqfn8vyp4k75";
      system = "cl-xkb";
      asd = "cl-xkb";
    });
    systems = [ "cl-xkb" ];
    lispLibs = [ (getAttr "cffi" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xkeysym = (build-asdf-system {
    pname = "cl-xkeysym";
    version = "20140914-git";
    asds = [ "cl-xkeysym" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xkeysym/2014-09-14/cl-xkeysym-20140914-git.tgz";
      sha256 = "0yxijl6xb5apb6v6qm8g3kfdr90slgg6vsnx4d1ps9z4zhrjlc6c";
      system = "cl-xkeysym";
      asd = "cl-xkeysym";
    });
    systems = [ "cl-xkeysym" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xmlspam = (build-asdf-system {
    pname = "cl-xmlspam";
    version = "20101006-http";
    asds = [ "cl-xmlspam" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xmlspam/2010-10-06/cl-xmlspam-20101006-http.tgz";
      sha256 = "03jw57889b60nsqgb13vrf5q1g2fasah7qv7knjlx2w4mc1ci7ks";
      system = "cl-xmlspam";
      asd = "cl-xmlspam";
    });
    systems = [ "cl-xmlspam" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "cxml" self) ];
    meta = {};
  });
  cl-xmpp = (build-asdf-system {
    pname = "cl-xmpp";
    version = "0.8.1";
    asds = [ "cl-xmpp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xmpp/2010-10-06/cl-xmpp-0.8.1.tgz";
      sha256 = "1kzzq1y0625zlg83ppcpb0aqzvqbga9x3gm826grmy4rf5jrhz5f";
      system = "cl-xmpp";
      asd = "cl-xmpp";
    });
    systems = [ "cl-xmpp" ];
    lispLibs = [ (getAttr "cxml" self) (getAttr "ironclad" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xmpp-sasl = (build-asdf-system {
    pname = "cl-xmpp-sasl";
    version = "0.8.1";
    asds = [ "cl-xmpp-sasl" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xmpp/2010-10-06/cl-xmpp-0.8.1.tgz";
      sha256 = "1kzzq1y0625zlg83ppcpb0aqzvqbga9x3gm826grmy4rf5jrhz5f";
      system = "cl-xmpp-sasl";
      asd = "cl-xmpp-sasl";
    });
    systems = [ "cl-xmpp-sasl" ];
    lispLibs = [ (getAttr "cl-base64" self) (getAttr "cl-sasl" self) (getAttr "cl-xmpp" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xmpp-tls = (build-asdf-system {
    pname = "cl-xmpp-tls";
    version = "0.8.1";
    asds = [ "cl-xmpp-tls" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xmpp/2010-10-06/cl-xmpp-0.8.1.tgz";
      sha256 = "1kzzq1y0625zlg83ppcpb0aqzvqbga9x3gm826grmy4rf5jrhz5f";
      system = "cl-xmpp-tls";
      asd = "cl-xmpp-tls";
    });
    systems = [ "cl-xmpp-tls" ];
    lispLibs = [ (getAttr "cl_plus_ssl" self) (getAttr "cl-xmpp-sasl" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xul = (build-asdf-system {
    pname = "cl-xul";
    version = "20160318-git";
    asds = [ "cl-xul" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xul/2016-03-18/cl-xul-20160318-git.tgz";
      sha256 = "0ldny4bjfndrkyqcq6klqxvqkpb0lhcqlj52y89ybl9w7dkl2d9p";
      system = "cl-xul";
      asd = "cl-xul";
    });
    systems = [ "cl-xul" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-json" self) (getAttr "closer-mop" self) (getAttr "clws" self) (getAttr "cxml" self) (getAttr "log5" self) (getAttr "md5" self) (getAttr "parenscript" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-xul-test = (build-asdf-system {
    pname = "cl-xul-test";
    version = "20160318-git";
    asds = [ "cl-xul-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-xul/2016-03-18/cl-xul-20160318-git.tgz";
      sha256 = "0ldny4bjfndrkyqcq6klqxvqkpb0lhcqlj52y89ybl9w7dkl2d9p";
      system = "cl-xul-test";
      asd = "cl-xul-test";
    });
    systems = [ "cl-xul-test" ];
    lispLibs = [ (getAttr "cl-xul" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yaclyaml = (build-asdf-system {
    pname = "cl-yaclyaml";
    version = "20160825-git";
    asds = [ "cl-yaclyaml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yaclyaml/2016-08-25/cl-yaclyaml-20160825-git.tgz";
      sha256 = "1clfhz4ii2p11yc3bm23ib4rx0rfxsh18ddc2br82i7mbwks3pll";
      system = "cl-yaclyaml";
      asd = "cl-yaclyaml";
    });
    systems = [ "cl-yaclyaml" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-interpol" self) (getAttr "cl-ppcre" self) (getAttr "cl-test-more" self) (getAttr "esrap-liquid" self) (getAttr "iterate" self) (getAttr "parse-number" self) (getAttr "rutils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yaclyaml-tests = (build-asdf-system {
    pname = "cl-yaclyaml-tests";
    version = "20160825-git";
    asds = [ "cl-yaclyaml-tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yaclyaml/2016-08-25/cl-yaclyaml-20160825-git.tgz";
      sha256 = "1clfhz4ii2p11yc3bm23ib4rx0rfxsh18ddc2br82i7mbwks3pll";
      system = "cl-yaclyaml-tests";
      asd = "cl-yaclyaml";
    });
    systems = [ "cl-yaclyaml-tests" ];
    lispLibs = [ (getAttr "cl-interpol" self) (getAttr "cl-yaclyaml" self) (getAttr "fiveam" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yahoo-finance = (build-asdf-system {
    pname = "cl-yahoo-finance";
    version = "20130312-git";
    asds = [ "cl-yahoo-finance" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yahoo-finance/2013-03-12/cl-yahoo-finance-20130312-git.tgz";
      sha256 = "1qhs4j00iw1w81lx0vmyiayzqyvixaxc5j2rc89qlr1gx12mqadl";
      system = "cl-yahoo-finance";
      asd = "cl-yahoo-finance";
    });
    systems = [ "cl-yahoo-finance" ];
    lispLibs = [ (getAttr "babel" self) (getAttr "cl-csv" self) (getAttr "drakma" self) (getAttr "url-rewrite" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yaml = (build-asdf-system {
    pname = "cl-yaml";
    version = "20221106-git";
    asds = [ "cl-yaml" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yaml/2022-11-06/cl-yaml-20221106-git.tgz";
      sha256 = "053fvrrd0p2xx4zxbz4kg9469895ypwsbjfd3nwpi7lwcll2bir5";
      system = "cl-yaml";
      asd = "cl-yaml";
    });
    systems = [ "cl-yaml" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-libyaml" self) (getAttr "cl-ppcre" self) (getAttr "parse-number" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yaml-test = (build-asdf-system {
    pname = "cl-yaml-test";
    version = "20221106-git";
    asds = [ "cl-yaml-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yaml/2022-11-06/cl-yaml-20221106-git.tgz";
      sha256 = "053fvrrd0p2xx4zxbz4kg9469895ypwsbjfd3nwpi7lwcll2bir5";
      system = "cl-yaml-test";
      asd = "cl-yaml-test";
    });
    systems = [ "cl-yaml-test" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fad" self) (getAttr "cl-yaml" self) (getAttr "fiveam" self) (getAttr "generic-comparability" self) (getAttr "trivial-benchmark" self) (getAttr "yason" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-yesql = (build-asdf-system {
    pname = "cl-yesql";
    version = "20211020-git";
    asds = [ "cl-yesql" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-yesql/2021-10-20/cl-yesql-20211020-git.tgz";
      sha256 = "0bg133kprbssv0z4ir2hkhf72fbmnz9v9861ncs1isqaby2d4xlj";
      system = "cl-yesql";
      asd = "cl-yesql";
    });
    systems = [ "cl-yesql" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "asdf-package-system" self) (getAttr "esrap" self) (getAttr "serapeum" self) (getAttr "trivia" self) (getAttr "vernacular" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-zipper = (build-asdf-system {
    pname = "cl-zipper";
    version = "20200610-git";
    asds = [ "cl-zipper" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-zipper/2020-06-10/cl-zipper-20200610-git.tgz";
      sha256 = "1zcfy97l40ynbldxpx8nad81jlrfp0k2vic10wbkrqdfkr696xkg";
      system = "cl-zipper";
      asd = "cl-zipper";
    });
    systems = [ "cl-zipper" ];
    lispLibs = [ (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl-zipper-test = (build-asdf-system {
    pname = "cl-zipper-test";
    version = "20200610-git";
    asds = [ "cl-zipper-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl-zipper/2020-06-10/cl-zipper-20200610-git.tgz";
      sha256 = "1zcfy97l40ynbldxpx8nad81jlrfp0k2vic10wbkrqdfkr696xkg";
      system = "cl-zipper-test";
      asd = "cl-zipper";
    });
    systems = [ "cl-zipper-test" ];
    lispLibs = [ (getAttr "cl-zipper" self) (getAttr "prove-asdf" self) (getAttr "test-utils" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  cl4store = (build-asdf-system {
    pname = "cl4store";
    version = "20200325-git";
    asds = [ "cl4store" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/cl4store/2020-03-25/cl4store-20200325-git.tgz";
      sha256 = "0qajxwlvmb5vd9qynnl0n62bcl1xhin49xk0p44v6pig8q2jzc26";
      system = "cl4store";
      asd = "cl4store";
    });
    systems = [ "cl4store" ];
    lispLibs = [ (getAttr "cl-rdfxml" self) (getAttr "cl-sparql" self) (getAttr "drakma" self) (getAttr "log5" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clache = (build-asdf-system {
    pname = "clache";
    version = "20171130-git";
    asds = [ "clache" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clache/2017-11-30/clache-20171130-git.tgz";
      sha256 = "0wxg004bsay58vr6xr6mlk7wj415qmvisqxvpnjsg6glfwca86ys";
      system = "clache";
      asd = "clache";
    });
    systems = [ "clache" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-annot" self) (getAttr "cl-fad" self) (getAttr "cl-store" self) (getAttr "cl-syntax" self) (getAttr "cl-syntax-annot" self) (getAttr "ironclad" self) (getAttr "trivial-garbage" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clache-test = (build-asdf-system {
    pname = "clache-test";
    version = "20171130-git";
    asds = [ "clache-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clache/2017-11-30/clache-20171130-git.tgz";
      sha256 = "0wxg004bsay58vr6xr6mlk7wj415qmvisqxvpnjsg6glfwca86ys";
      system = "clache-test";
      asd = "clache-test";
    });
    systems = [ "clache-test" ];
    lispLibs = [ (getAttr "cl-test-more" self) (getAttr "clache" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack = (build-asdf-system {
    pname = "clack";
    version = "20230618-git";
    asds = [ "clack" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack";
      asd = "clack";
    });
    systems = [ "clack" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "lack" self) (getAttr "lack-middleware-backtrace" self) (getAttr "lack-util" self) (getAttr "swank" self) (getAttr "usocket" self) ];
    meta = {};
  });
  clack-errors = (build-asdf-system {
    pname = "clack-errors";
    version = "20190813-git";
    asds = [ "clack-errors" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-errors/2019-08-13/clack-errors-20190813-git.tgz";
      sha256 = "0z6jyn37phnpq02l5wml8z0593g8ps95c0c2lzkhi3is2wcj9cpf";
      system = "clack-errors";
      asd = "clack-errors";
    });
    systems = [ "clack-errors" ];
    lispLibs = [ (getAttr "cl-ppcre" self) (getAttr "clack" self) (getAttr "closer-mop" self) (getAttr "djula" self) (getAttr "local-time" self) (getAttr "trivial-backtrace" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-errors-demo = (build-asdf-system {
    pname = "clack-errors-demo";
    version = "20190813-git";
    asds = [ "clack-errors-demo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-errors/2019-08-13/clack-errors-20190813-git.tgz";
      sha256 = "0z6jyn37phnpq02l5wml8z0593g8ps95c0c2lzkhi3is2wcj9cpf";
      system = "clack-errors-demo";
      asd = "clack-errors-demo";
    });
    systems = [ "clack-errors-demo" ];
    lispLibs = [ (getAttr "cl-markup" self) (getAttr "clack-errors" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-errors-test = (build-asdf-system {
    pname = "clack-errors-test";
    version = "20190813-git";
    asds = [ "clack-errors-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-errors/2019-08-13/clack-errors-20190813-git.tgz";
      sha256 = "0z6jyn37phnpq02l5wml8z0593g8ps95c0c2lzkhi3is2wcj9cpf";
      system = "clack-errors-test";
      asd = "clack-errors-test";
    });
    systems = [ "clack-errors-test" ];
    lispLibs = [ (getAttr "clack" self) (getAttr "clack-errors" self) (getAttr "drakma" self) (getAttr "fiveam" self) (getAttr "hunchentoot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-handler-fcgi = (build-asdf-system {
    pname = "clack-handler-fcgi";
    version = "20230618-git";
    asds = [ "clack-handler-fcgi" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-handler-fcgi";
      asd = "clack-handler-fcgi";
    });
    systems = [ "clack-handler-fcgi" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-fastcgi" self) (getAttr "flexi-streams" self) (getAttr "quri" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-handler-hunchentoot = (build-asdf-system {
    pname = "clack-handler-hunchentoot";
    version = "20230618-git";
    asds = [ "clack-handler-hunchentoot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-handler-hunchentoot";
      asd = "clack-handler-hunchentoot";
    });
    systems = [ "clack-handler-hunchentoot" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "clack-socket" self) (getAttr "flexi-streams" self) (getAttr "hunchentoot" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-handler-toot = (build-asdf-system {
    pname = "clack-handler-toot";
    version = "20230618-git";
    asds = [ "clack-handler-toot" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-handler-toot";
      asd = "clack-handler-toot";
    });
    systems = [ "clack-handler-toot" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "bordeaux-threads" self) (getAttr "cl-ppcre" self) (getAttr "flexi-streams" self) (getAttr "split-sequence" self) (getAttr "toot" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-handler-woo = (build-asdf-system {
    pname = "clack-handler-woo";
    version = "20220707-git";
    asds = [ "clack-handler-woo" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/woo/2022-07-07/woo-20220707-git.tgz";
      sha256 = "0ar7w2nfxhxirlcxxq4j1v4cnmvfkw3ip4i53b853g0pfb84m3kz";
      system = "clack-handler-woo";
      asd = "clack-handler-woo";
    });
    systems = [ "clack-handler-woo" ];
    lispLibs = [ (getAttr "woo" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-handler-wookie = (build-asdf-system {
    pname = "clack-handler-wookie";
    version = "20230618-git";
    asds = [ "clack-handler-wookie" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-handler-wookie";
      asd = "clack-handler-wookie";
    });
    systems = [ "clack-handler-wookie" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "babel" self) (getAttr "cl-async" self) (getAttr "clack-socket" self) (getAttr "fast-http" self) (getAttr "fast-io" self) (getAttr "flexi-streams" self) (getAttr "quri" self) (getAttr "split-sequence" self) (getAttr "wookie" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-pretend = (build-asdf-system {
    pname = "clack-pretend";
    version = "20210630-git";
    asds = [ "clack-pretend" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-pretend/2021-06-30/clack-pretend-20210630-git.tgz";
      sha256 = "1fhbznnrfkg9n3ql97h4adaqf968gn7i9xpggb4zzszc8gwiyasg";
      system = "clack-pretend";
      asd = "clack-pretend";
    });
    systems = [ "clack-pretend" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "circular-streams" self) (getAttr "cl-hash-util" self) (getAttr "clack" self) (getAttr "lack-request" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-socket = (build-asdf-system {
    pname = "clack-socket";
    version = "20230618-git";
    asds = [ "clack-socket" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-socket";
      asd = "clack-socket";
    });
    systems = [ "clack-socket" ];
    lispLibs = [  ];
    meta = {};
  });
  clack-static-asset-djula-helpers = (build-asdf-system {
    pname = "clack-static-asset-djula-helpers";
    version = "20211209-git";
    asds = [ "clack-static-asset-djula-helpers" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-static-asset-middleware/2021-12-09/clack-static-asset-middleware-20211209-git.tgz";
      sha256 = "0fk288812sdm012knqx4qqdhggdqbfgd0zfb6mc06xig20wj02hc";
      system = "clack-static-asset-djula-helpers";
      asd = "clack-static-asset-djula-helpers";
    });
    systems = [ "clack-static-asset-djula-helpers" ];
    lispLibs = [ (getAttr "clack-static-asset-middleware" self) (getAttr "djula" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-static-asset-middleware = (build-asdf-system {
    pname = "clack-static-asset-middleware";
    version = "20211209-git";
    asds = [ "clack-static-asset-middleware" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-static-asset-middleware/2021-12-09/clack-static-asset-middleware-20211209-git.tgz";
      sha256 = "0fk288812sdm012knqx4qqdhggdqbfgd0zfb6mc06xig20wj02hc";
      system = "clack-static-asset-middleware";
      asd = "clack-static-asset-middleware";
    });
    systems = [ "clack-static-asset-middleware" ];
    lispLibs = [ (getAttr "alexandria" self) (getAttr "cl-ppcre" self) (getAttr "ironclad" self) (getAttr "local-time" self) (getAttr "trivial-mimes" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-static-asset-middleware-test = (build-asdf-system {
    pname = "clack-static-asset-middleware-test";
    version = "20211209-git";
    asds = [ "clack-static-asset-middleware-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack-static-asset-middleware/2021-12-09/clack-static-asset-middleware-20211209-git.tgz";
      sha256 = "0fk288812sdm012knqx4qqdhggdqbfgd0zfb6mc06xig20wj02hc";
      system = "clack-static-asset-middleware-test";
      asd = "clack-static-asset-middleware-test";
    });
    systems = [ "clack-static-asset-middleware-test" ];
    lispLibs = [ (getAttr "clack-static-asset-djula-helpers" self) (getAttr "clack-static-asset-middleware" self) (getAttr "lack-test" self) (getAttr "prove" self) (getAttr "prove-asdf" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clack-test = (build-asdf-system {
    pname = "clack-test";
    version = "20230618-git";
    asds = [ "clack-test" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clack/2023-06-18/clack-20230618-git.tgz";
      sha256 = "1xvxgzzd8jv0ig2hwq4yaxsshs5j55v144c34wqyva3c56j3640i";
      system = "clack-test";
      asd = "clack-test";
    });
    systems = [ "clack-test" ];
    lispLibs = [ (getAttr "bordeaux-threads" self) (getAttr "clack" self) (getAttr "clack-handler-hunchentoot" self) (getAttr "dexador" self) (getAttr "flexi-streams" self) (getAttr "http-body" self) (getAttr "ironclad" self) (getAttr "rove" self) (getAttr "usocket" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  clad = (build-asdf-system {
    pname = "clad";
    version = "20230618-git";
    asds = [ "clad" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/clad/2023-06-18/clad-20230618-git.tgz";
      sha256 = "0ssjjcj9mzkqgxqja7061gm63jlzshw9y0zpz4sdincai8bikyr7";
      system = "clad";
      asd = "clad";
    });
    systems = [ "clad" ];
    lispLibs = [  ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  class-options = (build-asdf-system {
    pname = "class-options";
    version = "1.0.1";
    asds = [ "class-options" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/class-options/2020-10-16/class-options_1.0.1.tgz";
      sha256 = "1dkgr1vbrsra44jznzz2bvdf8nlpdrrkjcqrfs8aa7axksda3bqk";
      system = "class-options";
      asd = "class-options";
    });
    systems = [ "class-options" ];
    lispLibs = [ (getAttr "closer-mop" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  class-options__tests = (build-asdf-system {
    pname = "class-options_tests";
    version = "1.0.1";
    asds = [ "class-options_tests" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/class-options/2020-10-16/class-options_1.0.1.tgz";
      sha256 = "1dkgr1vbrsra44jznzz2bvdf8nlpdrrkjcqrfs8aa7axksda3bqk";
      system = "class-options_tests";
      asd = "class-options_tests";
    });
    systems = [ "class-options_tests" ];
    lispLibs = [ (getAttr "class-options" self) (getAttr "closer-mop" self) (getAttr "enhanced-boolean" self) (getAttr "parachute" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  classimp = (build-asdf-system {
    pname = "classimp";
    version = "20230618-git";
    asds = [ "classimp" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/classimp/2023-06-18/classimp-20230618-git.tgz";
      sha256 = "0i343lmvbssbgszz9s33hsn21hkrib1rdmkmcncyf644aa6ps598";
      system = "classimp";
      asd = "classimp";
    });
    systems = [ "classimp" ];
    lispLibs = [ (getAttr "cffi" self) (getAttr "split-sequence" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  classimp-samples = (build-asdf-system {
    pname = "classimp-samples";
    version = "20230618-git";
    asds = [ "classimp-samples" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/classimp/2023-06-18/classimp-20230618-git.tgz";
      sha256 = "0i343lmvbssbgszz9s33hsn21hkrib1rdmkmcncyf644aa6ps598";
      system = "classimp-samples";
      asd = "classimp-samples";
    });
    systems = [ "classimp-samples" ];
    lispLibs = [ (getAttr "cl-fad" self) (getAttr "cl-glu" self) (getAttr "cl-glut" self) (getAttr "cl-ilut" self) (getAttr "classimp" self) ];
    meta = {
      hydraPlatforms = [  ];
    };
  });
  classowary = (build-asdf-system {
    pname = "classowary";
    version = "20191007-git";
    asds = [ "classowary" ];
    src = (createAsd {
      url = "http://beta.quicklisp.org/archive/classowary/2019-10-07/classowary-20191007-git.tgz";
      sha256 = "099vmnl3lny427c1vzqrxc2mi57lv944cwn0z9hb0fndlr30alkh";
      system = "classowary";
      asd = "classowary";
    });
    systems = [ "classowary