{
  lib,
  appdirs,
  buildPythonPackage,
  cvss,
  fetchFromGitHub,
  httpx,
  msgpack,
  orjson,
  packageurl-python,
  pytestCheckHook,
  pythonOlder,
  pythonRelaxDepsHook,
  semver,
  setuptools,
  tabulate,
}:

buildPythonPackage rec {
  pname = "appthreat-vulnerability-db";
  version = "5.6.7";
  pyproject = true;

  disabled = pythonOlder "3.10";

  src = fetchFromGitHub {
    owner = "AppThreat";
    repo = "vulnerability-db";
    rev = "refs/tags/v${version}";
    hash = "sha256-/QzK+su+g2ESZ81C0coxKf13WOUVz1GyfJbOrO7fS98=";
  };

  postPatch = ''
    substituteInPlace pyproject.toml \
      --replace-fail " --cov-report=term-missing --no-cov-on-fail --cov vdb" ""
  '';

  pythonRelaxDeps = [
    "msgpack"
    "semver"
  ];

  build-system = [ setuptools ];

  nativeBuildInputs = [ pythonRelaxDepsHook ];

  dependencies = [
    appdirs
    cvss
    httpx
    msgpack
    orjson
    packageurl-python
    semver
    tabulate
  ] ++ httpx.optional-dependencies.http2;

  nativeCheckInputs = [ pytestCheckHook ];

  preCheck = ''
    export HOME=$(mktemp -d);
  '';

  disabledTests = [
    # Tests require network access
    "test_bulk_search"
    "test_download_recent"
  ];

  pythonImportsCheck = [ "vdb" ];

  meta = with lib; {
    description = "Vulnerability database and package search for sources such as OSV, NVD, GitHub and npm";
    homepage = "https://github.com/appthreat/vulnerability-db";
    changelog = "https://github.com/AppThreat/vulnerability-db/releases/tag/v${version}";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
    mainProgram = "vdb";
  };
}
