{
  lib,
  buildPythonPackage,
  fetchpatch,
  fetchPypi,
  substituteAll,
  pyparsing,
  graphviz,
  pytestCheckHook,
  texliveSmall,
}:

buildPythonPackage rec {
  pname = "dot2tex";
  version = "2.11.3";
  format = "setuptools";

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-KZoq8FruW74CV6VipQapPieSk9XDjyjQirissyM/584=";
  };

  patches = [
    (substituteAll {
      src = ./path.patch;
      inherit graphviz;
    })
    ./test.patch # https://github.com/kjellmf/dot2tex/issues/5

    # https://github.com/xyz2tex/dot2tex/pull/104 does not merge cleanly
    ./remove-duplicate-script.patch
  ];

  propagatedBuildInputs = [ pyparsing ];

  nativeCheckInputs = [
    pytestCheckHook
    (texliveSmall.withPackages (
      ps: with ps; [
        preview
        pstricks
      ]
    ))
  ];

  meta = with lib; {
    description = "Convert graphs generated by Graphviz to LaTeX friendly formats";
    mainProgram = "dot2tex";
    homepage = "https://github.com/kjellmf/dot2tex";
    license = licenses.mit;
  };
}
