{
  lib,
  stdenv,
  buildPythonPackage,
  cmake,
  cython,
  fetchFromGitHub,
  pytestCheckHook,
  pythonOlder,
  rapidfuzz,
  rapidfuzz-cpp,
  scikit-build,
}:

buildPythonPackage rec {
  pname = "levenshtein";
  version = "0.25.1";
  pyproject = true;

  disabled = pythonOlder "3.8";

  src = fetchFromGitHub {
    owner = "maxbachmann";
    repo = "Levenshtein";
    rev = "refs/tags/v${version}";
    hash = "sha256-ye2XQL/ZQPlA4dy3tlr03WyGhfl7SaOXMt10cWHnW5o=";
    fetchSubmodules = true; # # for vendored `rapidfuzz-cpp`
  };

  nativeBuildInputs = [
    cmake
    cython
    scikit-build
  ];

  dontUseCmakeConfigure = true;

  buildInputs = [ rapidfuzz-cpp ];

  env.NIX_CFLAGS_COMPILE = toString (
    lib.optionals (stdenv.cc.isClang && stdenv.isDarwin) [
      "-fno-lto" # work around https://github.com/NixOS/nixpkgs/issues/19098
    ]
  );

  dependencies = [ rapidfuzz ];

  nativeCheckInputs = [ pytestCheckHook ];

  pythonImportsCheck = [ "Levenshtein" ];

  meta = with lib; {
    description = "Functions for fast computation of Levenshtein distance and string similarity";
    homepage = "https://github.com/maxbachmann/Levenshtein";
    changelog = "https://github.com/maxbachmann/Levenshtein/blob/${src.rev}/HISTORY.md";
    license = licenses.gpl2Plus;
    maintainers = with maintainers; [ fab ];
  };
}
