{
  stdenv,
  lib,
  buildPythonPackage,
  notmuch,
  python,
  cffi,
}:

buildPythonPackage {
  pname = "notmuch2";
  format = "setuptools";
  inherit (notmuch) version src;

  sourceRoot = "notmuch-${notmuch.version}/bindings/python-cffi";

  nativeBuildInputs = [ cffi ];
  buildInputs = [
    python
    notmuch
  ];

  propagatedBuildInputs = [ cffi ];

  # since notmuch 0.35, this package expects _notmuch_config.py that is
  # generated by notmuch's configure script. We write one which references our
  # built libraries.
  postPatch = ''
    cat > _notmuch_config.py << EOF
    import os
    dir_path = os.path.dirname(os.path.realpath(__file__))
    NOTMUCH_VERSION_FILE=os.path.join(dir_path, '../../version.txt')
    NOTMUCH_INCLUDE_DIR='${notmuch.out}/lib'
    NOTMUCH_LIB_DIR='${notmuch.out}/lib'
    EOF
  '';

  # no tests
  doCheck = false;
  pythonImportsCheck = [ "notmuch2" ];

  meta = with lib; {
    description = "Pythonic bindings for the notmuch mail database using CFFI";
    homepage = "https://notmuchmail.org/";
    license = licenses.gpl3;
    maintainers = with maintainers; [ teto ];
  };
}
