{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  pytestCheckHook,
  pythonOlder,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.2.18";
  pyproject = true;

  disabled = pythonOlder "3.7";

  src = fetchPypi {
    pname = "pyExploitDb";
    inherit version;
    hash = "sha256-pwlS0304aTSrGZFIj5f+jstcFwcy/liqQBW8p7hUhKE=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyExploitDb" ];

  meta = with lib; {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/GoVanguard/pyExploitDb";
    changelog = "https://github.com/GoVanguard/pyExploitDb/blob/master/ChangeLog.md";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ fab ];
  };
}
