{ lib, rustPlatform, fetchFromSourcehut }:

rustPlatform.buildRustPackage rec {
  pname = "rusty-man";
  version = "0.5.0";

  src = fetchFromSourcehut {
    owner = "~ireas";
    repo = pname;
    rev = "v${version}";
    sha256 = "sha256-djprzmogT1OEf0/+twdxzx30YaMNzFjXkZd4IDsH8oo=";
  };

  cargoSha256 = "sha256-Wf8D6y3LRYJpQjFFt0w5X+BOllbR3mc4Gzcr1ad3zD0=";

  meta = with lib; {
    description = "A command-line viewer for documentation generated by rustdoc";
    mainProgram = "rusty-man";
    homepage = "https://git.sr.ht/~ireas/rusty-man";
    changelog = "https://git.sr.ht/~ireas/rusty-man/tree/v${version}/item/CHANGELOG.md";
    license = licenses.mit;
    maintainers = with maintainers; [ figsoda ];
  };
}
