{ buildGoModule, fetchFromGitHub, lib }:

buildGoModule rec {
  pname = "summon";
  version = "0.9.6";

  src = fetchFromGitHub {
    owner = "cyberark";
    repo = "summon";
    rev = "v${version}";
    hash = "sha256-OOIq6U7HCxcYvBFZdewSpglg9lFzITsb6IPu/EID+Z0=";
  };

  vendorHash = "sha256-qh3DJFxf1FqYgbULo4M+0nSOQ6uTlMTjAqNl7l+IPvk=";

  subPackages = [ "cmd" ];

  postInstall = ''
    mv $out/bin/cmd $out/bin/summon
  '';

  meta = with lib; {
    description =
      "CLI that provides on-demand secrets access for common DevOps tools";
    mainProgram = "summon";
    homepage = "https://cyberark.github.io/summon";
    license = lib.licenses.mit;
    maintainers = with maintainers; [ quentini ];
  };
}
