{ pkgs, haskellPackages }:

let
  # This can be regenerated by running `cabal2nix .` in the current directory.
  pkgDef =
    { mkDerivation, base, lib }:
      mkDerivation {
        pname = "haskell-setBuildTarget";
        version = "0.1.0.0";
        src = ./.;
        isLibrary = false;
        isExecutable = true;
        executableHaskellDepends = [ base ];
        license = lib.licenses.bsd3;
      };

  drv = haskellPackages.callPackage pkgDef {};

  test  = target: excluded:
    let only = pkgs.haskell.lib.compose.setBuildTarget target drv;
    in ''
         if [[ ! -f "${only}/bin/${target}" ]]; then
           echo "${target} was not built"
           exit 1
         fi

         if [[ -f "${only}/bin/${excluded}" ]]; then
           echo "${excluded} was built, when it should not have been"
           exit 1
         fi
     '';

in
pkgs.runCommand "test haskell.lib.compose.setBuildTarget" {
  meta = {
    inherit (drv.meta) platforms;
  };
} ''
  ${test "foo" "bar"}
  ${test "bar" "foo"}
  touch "$out"
''

