{
  lib,
  buildPythonApplication,
  fetchFromGitHub,
  # aiohttp[speedups]
  aiodns,
  aiohttp,
  beautifulsoup4,
  brotlipy,
  cvss,
  distro,
  filetype,
  google-cloud-sdk,
  jinja2,
  jsonschema,
  lib4sbom,
  packageurl-python,
  packaging,
  plotly,
  pytestCheckHook,
  python-gnupg,
  pyyaml,
  requests,
  rich,
  rpmfile,
  setuptools,
  xmlschema,
  zstandard,
  reportlab,
  pip,
  testers,
  cve-bin-tool,
}:

buildPythonApplication rec {
  pname = "cve-bin-tool";
  version = "3.3";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "intel";
    repo = "cve-bin-tool";
    rev = "refs/tags/v${version}";
    hash = "sha256-A5w4U5EDX+UZWNMuz8GTOcubo8N2KfDlVV0aRNsO8/E=";
  };

  # Wants to open a sqlite database, access the internet, etc
  doCheck = false;

  dependencies = [
    # aiohttp[speedups]
    aiodns
    aiohttp
    beautifulsoup4
    brotlipy
    cvss
    distro
    filetype
    google-cloud-sdk # gsutil
    jinja2
    jsonschema
    lib4sbom
    packageurl-python
    packaging
    plotly
    python-gnupg
    pyyaml
    requests
    rich
    rpmfile
    setuptools
    xmlschema
    zstandard
  ];

  optional-dependencies = {
    pdf = [ reportlab ];
  };

  propagatedBuildInputs = [ pip ];

  nativeCheckInputs = [ pytestCheckHook ] ++ lib.flatten (lib.attrValues optional-dependencies);

  pythonImportsCheck = [ "cve_bin_tool" ];

  passthru.tests.version = testers.testVersion { package = cve-bin-tool; };

  meta = with lib; {
    description = "CVE Binary Checker Tool";
    homepage = "https://github.com/intel/cve-bin-tool";
    license = licenses.gpl3Plus;
    maintainers = [ ];
  };
}
