{ lib
, fetchFromGitHub
, python3
}:

python3.pkgs.buildPythonApplication rec {
  pname = "pentestgpt";
  version = "unstable-2023-06-27";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "GreyDGL";
    repo = "PentestGPT";
    rev = "e63a91f466a035e036827e8f492bc47c5c1135af";
    hash = "sha256-m0R/kMmbr5Ixuqvw6ZRoaAGCnI3j86Iwk4+TYqv0WbU=";
  };

  postPatch = ''
    substituteInPlace requirements.txt \
      --replace "playwright==1.28.0" "playwright" \
      --replace "beautifulsoup4~=4.11.2" "" \
      --replace "black" "" \
      --replace "pytest" ""
  '';

  propagatedBuildInputs = with python3.pkgs; [
    beautifulsoup4
    colorama
    google
    langchain
    loguru
    openai
    playwright
    prompt-toolkit
    pycookiecheat
    pyyaml
    requests
    rich
    sqlmap
    tiktoken
  ];

  # Tests require network access
  doCheck = false;

  pythonImportsCheck = [
    "pentestgpt"
  ];

  meta = with lib; {
    description = "GPT-empowered penetration testing tool";
    homepage = "https://github.com/GreyDGL/PentestGPT";
    changelog = "https://github.com/GreyDGL/PentestGPT/releases/tag/v${version}";
    license = licenses.mit;
    maintainers = with maintainers; [ fab ];
  };
}
