# Release 23.05 (“Stoat”, 2023.05/31) {#sec-release-23.05}

The NixOS release team is happy to announce a new version of NixOS. The release is called NixOS 23.05 ("Stoat").

NixOS is a Linux distribution, whose set of packages can also be used on other Linux systems and macOS.

Support is planned until the end of December 2023, handing over to NixOS 23.11.

To upgrade to the latest release, follow the [upgrade chapter](https://nixos.org/manual/nixos/stable/index.html#sec-upgrading).

## Highlights {#sec-release-23.05-highlights}

In addition to numerous new and updated packages, this release has the following highlights:

- The default [Nix](https://github.com/NixOS/nix) version was updated from 2.11 to 2.13. In particular, this includes a [small language alteration](https://github.com/NixOS/nix/issues/8259) in the way floats are represented in `builtins.toJSON`. See the release notes for [2.12](https://nixos.org/manual/nix/stable/release-notes/rl-2.12.html) and [2.13](https://nixos.org/manual/nix/unstable/release-notes/rl-2.13.html) for more information.

- The default [Linux Kernel](https://kernel.org/) was updated from version 5.15 to 6.1, see [Kernelnewbies](https://kernelnewbies.org/Linux_6.1) for what has changed. All Kernels currently shown on [kernel.org](https://kernel.org/) are available.

- [systemd](https://systemd.io) has been updated from v252 to v253, see [the release notes](https://github.com/systemd/systemd/blob/v253/NEWS#L3-L659) for more information on the changes.
    - Updating with `nixos-rebuild boot` and rebooting is recommended, since in some rare cases the `nixos-rebuild switch` into the new generation on a live system might fail due to missing mount units.

- [glibc](https://www.gnu.org/software/libc/) has been updated from version 2.35 to 2.37, see [the release notes](https://sourceware.org/glibc/wiki/Release/2.37) for what was changed.

- [libxcrypt](https://github.com/besser82/libxcrypt), the library providing the `crypt(3)` password hashing function, is now built without support for algorithms not flagged [`strong`](https://github.com/besser82/libxcrypt/blob/v4.4.33/lib/hashes.conf#L48). This affects the availability of password hashing algorithms used for system login (`login(1)`, `passwd(1)`), but also Apache2 Basic-Auth, Samba, OpenLDAP, Dovecot, and [many other packages](https://sourcegraph.com/search?q=context:global+repo:%5Egithub%5C.com/NixOS/nixpkgs%24+libxcrypt&patternType=standard&sm=1&groupBy=path).

- NixOS now defaults to using [nsncd](https://github.com/twosigma/nsncd), a non-caching reimplementation of nscd in Rust, as its NSS lookup dispatcher. This replaces the buggy and deprecated nscd implementation provided through glibc. When you find problems, you can switch back by disabling it:
  ```nix
  {
    services.nscd.enableNsncd = false;
  }
  ```

- The internal option `boot.bootspec.enable` is now enabled by default because [RFC 0125](https://github.com/NixOS/rfcs/pull/125) was merged. This means you will have a bootspec document called `boot.json` generated for each system and specialisation in the top-level. This is useful to enable advanced boot use cases in NixOS, such as Secure Boot.

- Two changes to `nixos-rebuild` are important to highlight as well.
    - Support for an extra `--specialisation` option was added that can be used to change specialisation for `switch` and `test` commands.
    - The `--target-host` and `--build-host` options no longer treat the `localhost` value specially – to build on resp. deploy to a local machine, omit the relevant flag.

- [Python](https://www.python.org) implements [PEP 668](https://peps.python.org/pep-0668/), providing better feedback to users that try to run `pip install` for system-wide or user home installations.

- [Cinnamon](https://github.com/linuxmint/Cinnamon) has been updated to version 5.6, see [the pull request](https://github.com/NixOS/nixpkgs/pull/201328#issue-1449910204) for what was changed.

- [GNOME](https://www.gnome.org) has been updated to version 44, see the [the release notes](https://release.gnome.org/44/) for details.

- [KDE Plasma](https://kde.org/de/plasma-desktop/) has been updated to version 5.27, see [the release notes](https://kde.org/announcements/plasma/5/5.27.0/) for what was changed.

- `openra` was updated to `20230225`. Due to large scope of the update, currently only `openraPackages.engines.release` and `openraPackages.engines.latest` packages are available.
  If you want to use the old engine versions or mods, they were moved to the `openraPackages_2019` namespace.

## New Services {#sec-release-23.05-new-services}

- [Akkoma](https://akkoma.social), an ActivityPub microblogging server. Available as [services.akkoma](options.html#opt-services.akkoma.enable).

- [alertmanager-irc-relay](https://github.com/google/alertmanager-irc-relay), a Prometheus Alertmanager IRC Relay. Available as [services.prometheus.alertmanagerIrcRelay](options.html#opt-services.prometheus.alertmanagerIrcRelay.enable).

- [alice-lg](https://github.com/alice-lg/alice-lg), a looking-glass for BGP sessions. Available as [services.alice-lg](#opt-services.alice-lg.enable).

- [atuin](https://github.com/ellie/atuin), a sync server for shell history. Available as [services.atuin](#opt-services.atuin.enable).

- [authelia](https://www.authelia.com/), an open-source authentication and authorization server. Available as [services.authelia](options.html#opt-services.authelia.enable).

- [birdwatcher](github.com/alice-lg/birdwatcher), a small HTTP server meant to provide an API defined by Barry O'Donovan's birds-eye to the BIRD internet routing daemon. Available as [services.birdwatcher](#opt-services.birdwatcher.enable).

- [blesh](https://github.com/akinomyoga/ble.sh), a line editor written in pure bash. Available as [programs.bash.blesh](#opt-programs.bash.blesh.enable).

- [Budgie Desktop](https://github.com/BuddiesOfBudgie/budgie-desktop), a familiar, modern desktop environment. Available as [services.xserver.desktopManager.budgie](options.html#opt-services.xserver.desktopManager.budgie).

- [clash-verge](https://github.com/zzzgydi/clash-verge), a Clash GUI based on tauri. Available as [programs.clash-verge](#opt-programs.clash-verge.enable).

- [Cloudlog](https://www.magicbug.co.uk/cloudlog/), a web-based Amateur Radio logging application. Available as [services.cloudlog](#opt-services.cloudlog.enable).

- [consul-template](https://github.com/hashicorp/consul-template/), a template renderer, notifier, and supervisor for HashiCorp Consul and Vault data. Available as [services.consul-template](#opt-services.consul-template.instances).

- [cups-pdf-to-pdf](https://github.com/alexivkin/CUPS-PDF-to-PDF), a PDF-generating CUPS backend based on [cups-pdf](https://www.cups-pdf.de/). Available as [services.printing.cups-pdf](#opt-services.printing.cups-pdf.enable).

- [Deepin Desktop Environment](https://github.com/linuxdeepin/dde), an elegant, easy to use and reliable desktop environment. Available as [services.xserver.desktopManager.deepin](options.html#opt-services.xserver.desktopManager.deepin).

- [esphome](https://esphome.io), a dashboard to configure ESP8266/ESP32 devices for use with Home Automation systems. Available as [services.esphome](#opt-services.esphome.enable).

- [frigate](https://frigate.video), an open source NVR built around real-time AI object detection. Available as [services.frigate](#opt-services.frigate.enable).

- [fzf](https://github.com/junegunn/fzf), a command line fuzzyfinder. Available as [programs.fzf](#opt-programs.fzf.fuzzyCompletion).

- [gemstash](https://github.com/rubygems/gemstash), a RubyGems.org cache and private gem server. Available as [services.gemstash](#opt-services.gemstash.enable).

- [gitea-actions-runner](https://gitea.com/gitea/act_runner), a CI runner for Gitea/Forgejo Actions. Available as [services.gitea-actions-runner](#opt-services.gitea-actions-runner.instances).

- [evdevremapkeys](https://github.com/philipl/evdevremapkeys), a daemon to remap key events. Available as [services.evdevremapkeys](#opt-services.evdevremapkeys.enable).

- [gmediarender](https://github.com/hzeller/gmrender-resurrect), a simple, headless UPnP/DLNA renderer.  Available as [services.gmediarender](options.html#opt-services.gmediarender.enable).

- [go2rtc](https://github.com/AlexxIT/go2rtc), a camera streaming application with support for RTSP, WebRTC, HomeKit, FFMPEG, RTMP and other protocols. Available as [services.go2rtc](options.html#opt-services.go2rtc.enable).

- [goeland](https://github.com/slurdge/goeland), an alternative to rss2email written in Golang with many filters. Available as [services.goeland](#opt-services.goeland.enable).

- [gonic](https://github.com/sentriz/gonic), a Subsonic music streaming server. Available as [services.gonic](#opt-services.gonic.enable).

- [hardware.ipu6](#opt-hardware.ipu6.enable), drivers for IPU6 based webcams on Intel Tiger Lake and Alder Lake.

- [harmonia](https://github.com/nix-community/harmonia/), a Nix binary cache implemented in Rust using [libnixstore](https://docs.rs/libnixstore/latest/libnixstore/). Available as [services.harmonia](options.html#opt-services.harmonia.enable).

- [hyprland](https://github.com/hyprwm/hyprland), a dynamic tiling Wayland compositor that doesn't sacrifice on its looks. Available as [programs.hyprland](#opt-programs.hyprland.enable).

- [imaginary](https://github.com/h2non/imaginary), a microservice for high-level image processing that Nextcloud can use to generate previews. Available as [services.imaginary](#opt-services.imaginary.enable).

- [ivpn](https://www.ivpn.net/), a secure, private VPN with fast WireGuard connections. Available as [services.ivpn](#opt-services.ivpn.enable).

- [vmalert](https://victoriametrics.com/), an alerting engine for VictoriaMetrics. Available as [services.vmalert](#opt-services.vmalert.enable).

- [jellyseerr](https://github.com/Fallenbagel/jellyseerr), a web-based requests manager for Jellyfin, forked from Overseerr. Available as [services.jellyseerr](#opt-services.jellyseerr.enable).

- [kavita](https://kavitareader.com), a self-hosted digital library. Available as [services.kavita](options.html#opt-services.kavita.enable).

- [keyd](https://github.com/rvaiya/keyd), a key remapping daemon for Linux. Available as [services.keyd](#opt-services.keyd.enable).

- [lldap](https://github.com/lldap/lldap), a lightweight authentication server that provides an opinionated, simplified LDAP interface for authentication. Available as [services.lldap](#opt-services.lldap.enable).

- [minipro](https://gitlab.com/DavidGriffith/minipro/), an open source program for controlling the MiniPRO TL866xx series of chip programmers. Available as [programs.minipro](options.html#opt-programs.minipro.enable).

- [mmsd](https://gitlab.com/kop316/mmsd), a lower level daemon that transmits and receives MMSes. Available as [services.mmsd](#opt-services.mmsd.enable).

- [monica](https://www.monicahq.com), an open source personal CRM. Available as [services.monica](options.html#opt-services.monica.enable).

- [networkd-dispatcher](https://gitlab.com/craftyguy/networkd-dispatcher), a dispatcher service for systemd-networkd connection status changes. Available as [services.networkd-dispatcher](#opt-services.networkd-dispatcher.enable).

- [nimdow](https://github.com/avahe-kellenberger/nimdow), a window manager written in Nim, inspired by dwm. Available as [services.xserver.windowManager.nimdow.enable](options.html#opt-services.xserver.windowManager.nimdow.enable).

- [opensearch](https://opensearch.org), a search server alternative to Elasticsearch. Available as [services.opensearch](options.html#opt-services.opensearch.enable).

- [openvscode-server](https://github.com/gitpod-io/openvscode-server), run VS Code on a remote machine with access through a modern web browser from any device, anywhere. Available as [services.openvscode-server](#opt-services.openvscode-server.enable).

- [peroxide](https://github.com/ljanyst/peroxide), a fork of the official [ProtonMail bridge](https://github.com/ProtonMail/proton-bridge) that aims to be similar to [Hydroxide](https://github.com/emersion/hydroxide). Available as [services.peroxide](#opt-services.peroxide.enable).

- [photoprism](https://photoprism.app/), a AI-powered photos app for the decentralized web. Available as [services.photoprism](options.html#opt-services.photoprism.enable).

- [Pixelfed](https://pixelfed.org/), an Instagram-like ActivityPub server. Available as [services.pixelfed](options.html#opt-services.pixelfed.enable).

- [PufferPanel](https://pufferpanel.com), a game server management panel designed to be easy to use. Available as [services.pufferpanel](#opt-services.pufferpanel.enable).

- [QDMR](https://dm3mat.darc.de/qdmr/), a GUI application and command line tool for programming DMR radios [programs.qdmr](#opt-programs.qdmr.enable).

- [readarr](https://github.com/Readarr/Readarr), book manager and automation (Sonarr for ebooks). Available as [services.readarr](options.html#opt-services.readarr.enable).

- [ReGreet](https://github.com/rharish101/ReGreet), a clean and customizable greeter for greetd. Available as [programs.regreet](#opt-programs.regreet.enable).

- [rshim](https://github.com/Mellanox/rshim-user-space), the user-space rshim driver for the BlueField SoC. Available as [services.rshim](options.html#opt-services.rshim.enable).

- [SFTPGo](https://github.com/drakkan/sftpgo), a fully featured and highly configurable SFTP server with optional HTTP/S, FTP/S and WebDAV support. Available as [services.sftpgo](options.html#opt-services.sftpgo.enable).

- [sharing](https://github.com/parvardegr/sharing), a command-line tool to share directories and files from the CLI to iOS and Android devices without the need of an extra client app. Available as [programs.sharing](#opt-programs.sharing.enable).

- [sniffnet](https://github.com/GyulyVGC/sniffnet), an application to monitor your network traffic. Available as [programs.sniffnet](#opt-programs.sniffnet.enable).

- [stargazer](https://sr.ht/~zethra/stargazer/), a fast and easy to use Gemini server. Available as [services.stargazer](#opt-services.stargazer.enable).

- [stevenblack-blocklist](https://github.com/StevenBlack/hosts), a unified hosts file with base extensions for blocking unwanted websites. Available as [networking.stevenblack](options.html#opt-networking.stevenblack.enable).

- [systemd-repart](https://www.freedesktop.org/software/systemd/man/systemd-repart.service.html), grow and add partitions to a partition table. Available as [systemd.repart](options.html#opt-systemd.repart) and [boot.initrd.systemd.repart](options.html#opt-boot.initrd.systemd.repart)

- [trippy](https://github.com/fujiapple852/trippy), a network diagnostic tool. Available as [programs.trippy](#opt-programs.trippy.enable).

- [tts](https://github.com/coqui-ai/TTS), a battle-tested deep learning toolkit for Text-to-Speech. Multiple servers may be configured below [services.tts.servers](#opt-services.tts.servers).

- [ulogd](https://www.netfilter.org/projects/ulogd/index.html), a userspace logging daemon for netfilter/iptables related logging. Available as [services.ulogd](options.html#opt-services.ulogd.enable).

- [v2rayA](https://v2raya.org), a Linux web GUI client of Project V which supports V2Ray, Xray, SS, SSR, Trojan and Pingtunnel. Available as [services.v2raya](options.html#opt-services.v2raya.enable).

- [v4l2-relayd](https://git.launchpad.net/v4l2-relayd), a streaming relay for v4l2loopback using gstreamer. Available as [services.v4l2-relayd](#opt-services.v4l2-relayd.instances._name_.enable).

- [vault-agent](https://developer.hashicorp.com/vault/docs/agent), a template renderer and API auth proxy for HashiCorp Vault, similar to `consul-template`. Available as [services.vault-agent](#opt-services.vault-agent.instances).

- [webhook](https://github.com/adnanh/webhook), a lightweight webhook server. Available as [services.webhook](#opt-services.webhook.enable).

- [wgautomesh](https://git.deuxfleurs.fr/Deuxfleurs/wgautomesh), a simple utility to help connect wireguard nodes together in a full mesh topology. Available as [services.wgautomesh](options.html#opt-services.wgautomesh.enable).

- [woodpecker](https://woodpecker-ci.org/), a simple CI engine with great extensibility. Available as [services.woodpecker-server](#opt-services.woodpecker-server.enable) and [services.woodpecker-agents](#opt-services.woodpecker-agents.agents._name_.enable).

- [wstunnel](https://github.com/erebe/wstunnel), a proxy tunnelling arbitrary TCP or UDP traffic through a WebSocket connection. Available as [services.wstunnel](options.html#opt-services.wstunnel.enable).

## Backward Incompatibilities {#sec-release-23.05-incompatibilities}

- `services.asusd` configuration now uses strings instead of structured configuration, as upstream switched to the [RON](https://github.com/ron-rs/ron) configuration format. Support for structured configuration may return when [RON](https://github.com/ron-rs/ron) generation is implemented in nixpkgs.

- `borgbackup` module now has an option for inhibiting system sleep while backups are running, defaulting to off (not inhibiting sleep), available as [`services.borgbackup.jobs.<name>.inhibitsSleep`](#opt-services.borgbackup.jobs._name_.inhibitsSleep).

- The `openssh` client now comes with the `~C` escape sequence disabled by default. It can be re-enabled by setting `EnableEscapeCommandline yes`

- The `programs.ssh` client module does not read `/etc/ssh/ssh_known_hosts2` anymore, since this location is [deprecated since 2001](https://marc.info/?l=openssh-unix-dev&m=100508718416162&w=2).

- The `services.openssh` server module does not read `~/.ssh/authorized_keys2` anymore, since this location is [deprecated since 2001](https://marc.info/?l=openssh-unix-dev&m=100508718416162&w=2).

- MAC-then-encrypt algorithms were removed from the default selection of `services.openssh.settings.Macs`. If you still require these [MACs](https://en.wikipedia.org/wiki/Message_authentication_code), for example when you are relying on libssh2 (e.g. VLC) or the SSH library shipped on the iPhone, you can re-add them like this:

  ```nix
  {
    services.openssh.settings.Macs = [
      "hmac-sha2-512"
      "hmac-sha2-256"
      "umac-128@openssh.com"
    ];
  }
  ```

- `podman` now uses the `netavark` network stack. Users will need to delete all of their local containers, images, volumes, etc, by running `podman system reset --force` once before upgrading their systems.

- `git-bug` has been updated to at least version 0.8.0, which includes backwards incompatible changes. The `git-bug-migration` package can be used to upgrade existing repositories.

- `graylog` has been updated to version 5, which can not be updated directly from the previously packaged version 3.3. If you had installed the previously packaged version 3.3, please follow the [upgrade path](https://go2docs.graylog.org/5-0/upgrading_graylog/upgrade_path.htm) from 3.3 to 4.0 to 4.3 to 5.0.

- `buildFHSUserEnv` is now called `buildFHSEnv` and uses FlatPak's Bubblewrap sandboxing tool rather than Nixpkgs' own chrootenv. The old chrootenv-based implementation is still available via `buildFHSEnvChroot` but is considered deprecated and will be removed when the remaining uses inside Nixpkgs have been migrated. If your FHSEnv-wrapped application misbehaves when using the new bubblewrap implementation, please create an issue in Nixpkgs.

- `nushell` has been updated to at least version 0.77.0, which includes potential breaking changes in aliases. The old aliases are now available as `old-alias` but it is recommended you migrate to the new format. See [Reworked aliases](https://www.nushell.sh/blog/2023-03-14-nushell_0_77.html#reworked-aliases-breaking-changes-kubouch).

- `gajim` has been updated to version 1.7.3 which has disabled legacy ciphers. See [changelog for version 1.7.0](https://dev.gajim.org/gajim/gajim/-/releases/1.7.0).

- `keepassx` and `keepassx2` have been removed, due to upstream [stopping development](https://www.keepassx.org/index.html%3Fp=636.html). Consider [KeePassXC](https://keepassxc.org) as a maintained alternative.

- The [services.kubo.settings](#opt-services.kubo.settings) option is now no longer stateful. If you changed any of the options in [services.kubo.settings](#opt-services.kubo.settings) in the past and then removed them from your NixOS configuration again, those changes are still in your Kubo configuration file but will now be reset to the default. If you're unsure, you may want to make a backup of your configuration file (probably `/var/lib/ipfs/config`) and compare after the update.

- The Kubo HTTP API will no longer listen on localhost and will instead only listen on a Unix domain socket by default. Read the [services.kubo.settings.Addresses.API](#opt-services.kubo.settings.Addresses.API) option description for more information.

- The EC2 image module no longer fetches instance metadata in stage-1. This results in a significantly smaller initramfs, since network drivers no longer need to be included, and faster boots, since metadata fetching can happen in parallel with startup of other services.
  This breaks services which rely on metadata being present by the time stage-2 is entered. Anything which reads EC2 metadata from `/etc/ec2-metadata` should now have an `after` dependency on `fetch-ec2-metadata.service`

- The mailman service now defaults to using a randomly generated REST API password instead of a hard-coded one.

- `minio` removed support for its legacy filesystem backend in [RELEASE.2022-10-29T06-21-33Z](https://github.com/minio/minio/releases/tag/RELEASE.2022-10-29T06-21-33Z). This means if your storage was created with the old format, minio will no longer start. Unfortunately, minio doesn't provide an automatic migration, they only provide [instructions how to manually convert the node](https://min.io/docs/minio/windows/operations/install-deploy-manage/migrate-fs-gateway.html). To facilitate this migration, we keep around the last version that still supports the old filesystem backend as `minio_legacy_fs`. Use it via `services.minio.package = minio_legacy_fs;` to export your data before switching to the new version. See the corresponding [issue](https://github.com/NixOS/nixpkgs/issues/199318) for more details.

- `services.sourcehut.dispatch` and the corresponding package (`sourcehut.dispatchsrht`) have been removed due to [upstream deprecation](https://sourcehut.org/blog/2022-08-01-dispatch-deprecation-plans/).

- The attributes used by `services.snapper.configs.<name>` have changed. Migrate from this:

  ```nix
  {
    services.snapper.configs.example = {
      subvolume = "/example";
      extraConfig = ''
        ALLOW_USERS="alice"
      '';
    };
  }
  ```

  to this:

  ```nix
  {
    services.snapper.configs.example = {
      SUBVOLUME = "/example";
      ALLOW_USERS = [ "alice" ];
    };
  }
  ```

- The default module options for [services.snapserver.openFirewall](#opt-services.snapserver.openFirewall), [services.tmate-ssh-server.openFirewall](#opt-services.tmate-ssh-server.openFirewall) and `services.unifi-video.openFirewall` have been changed from `true` to `false`. You will need to explicitly set this option to `true`, or configure your firewall.

- The option `i18n.inputMethod.fcitx5.enableRimeData` has been removed. Default RIME data is now included in `fcitx5-rime` by default, and can be customized using

  ```nix
  fcitx5-rime.override {
    rimeDataPkgs = [
      pkgs.rime-data
      # ...
    ];
  }
  ```

- The `udev` hwdb.bin file is now built with systemd-hwdb rather than the [deprecated "udevadm hwdb"](https://github.com/systemd/systemd/pull/25714). This may impact mappings where the same key is defined in multiple matching entries. The updated behavior will select the latest definition in case of conflict. In general, this should be a positive change, as the hwdb source files are designed with this ordering in mind. As an example, the mapping of the HP Dev One keyboard scan code for "mute mic" is corrected by this update. This change may impact users who have worked-around previously incorrect mappings.

- Kime has been updated from 2.5.6 to 3.0.2 and the `i18n.inputMethod.kime.config` option has been removed. Users should use `daemonModules`, `iconColor`, and `extraConfig` options under `i18n.inputMethod.kime` instead.

- `tut` has been updated from 1.0.34 to 2.0.0, and now uses the TOML format for the configuration file instead of INI. Additional information can be found [here](https://github.com/RasmusLindroth/tut/releases/tag/2.0.0).

- `i3status-rust` has been updated from 0.22.0 to 0.30.5, and this brings many changes to its configuration format. Additional information can be found [here](https://github.com/greshake/i3status-rust/blob/v0.30.0/NEWS.md).

- The `wordpress` derivation no longer contains any built-in plugins or themes. If you need them, you have to add them back to prevent your site from breaking. You can find them in `wordpressPackages.{plugins,themes}`.

- `llvmPackages_rocm.llvm` will not contain `clang` or `compiler-rt`. `llvmPackages_rocm.clang` will not contain `llvm`. `llvmPackages_rocm.clangNoCompilerRt` has been removed in favor of using `llvmPackages_rocm.clang-unwrapped`.

- `services.xserver.desktopManager.plasma5.excludePackages` has been moved to `environment.plasma5.excludePackages`, for consistency with other Desktop Environments.

- `teleport` has been updated from major version 10 to major version 12. Please see upstream [upgrade instructions](https://goteleport.com/docs/setup/operations/upgrading/) and release notes for versions [11](https://goteleport.com/docs/changelog/#1100) and [12](https://goteleport.com/docs/changelog/#1201). Note that Teleport does not officially support upgrades across more than one major version at a time. If you're running Teleport server components, it is recommended to first upgrade to an intermediate 11.x version by setting `services.teleport.package = pkgs.teleport_11`. Afterwards, this option can be removed to upgrade to the default version (12).

- The EC2 image module previously detected and automatically mounted ext3-formatted instance store devices and partitions in stage-1 (initramfs), storing `/tmp` on the first discovered device. This behaviour, which only catered to very specific use cases and could not be disabled, has been removed. Users relying on this should provide their own implementation, and probably use ext4 and perform the mount in stage-2.

- The EC2 image module previously detected and activated swap-formatted instance store devices and partitions in stage-1 (initramfs). This behaviour has been removed. Users relying on this should provide their own implementation.

- `gitlab` has been upgraded from major version 15 to major version 16 and requires at least PostgreSQL 13.6. Check the [upgrade guide](#module-services-postgres-upgrading) in the NixOS manual on how to upgrade your PostgreSQL installation.

- `gitlab` 16 deprecates the use of external container registries, in our case `pkgs.docker-distribution`. Module users who have [`services.gitlab.registry.enable`](#opt-services.gitlab.registry.enable) set to `true` are advised to back up their state and switch to gitlab's fork by setting [`services.gitlab.registry.package`](#opt-services.gitlab.registry.package) to `pkgs.gitlab-container-registry`.

- `fail2ban` has been updated to 1.0.2, which has a few breaking changes compared to 0.11.2 ([changelog for 1.0.1](https://github.com/fail2ban/fail2ban/blob/1.0.1/ChangeLog), [changelog for 1.0.2](https://github.com/fail2ban/fail2ban/blob/1.0.2/ChangeLog))

- `albert` has been updated from 0.17.6 to 0.20.13, and 0.18.0 changed the config format and many plugins ([changelog for 0.18.0](https://github.com/albertlauncher/albert/blob/v0.18.0/CHANGELOG.md))

- `dokuwiki` has been updated from 2023-07-31a (Igor) to 2023-04-04 (Jack Jackrum), which has [completely removed](https://www.dokuwiki.org/changes#release_2023-04-04_jack_jackrum) the options to embed HTML and PHP for security reasons. The [htmlok plugin](https://www.dokuwiki.org/plugin:htmlok) can be used to regain this functionality.

- The old unsupported version 6.x of the ELK-stack and Elastic beats have been removed. Use OpenSearch instead.

- The `cosmoc` package has been removed. The upstream scripts in `cosmocc` should be used instead.

- Qt 5.12 and 5.14 have been removed, as the corresponding branches have been EOL upstream for a long time. This affected under 10 packages in nixpkgs, largely unmaintained upstream as well, however, out-of-tree package expressions may need to be updated manually.

- The [services.wordpress.sites.&lt;name&gt;.plugins](#opt-services.wordpress.sites._name_.plugins) and [services.wordpress.sites.&lt;name&gt;.themes](#opt-services.wordpress.sites._name_.themes) options have been converted from sets to attribute sets to allow for consumers to specify explicit install paths via attribute name.

- `protonmail-bridge` package has been updated to major version 3.

- Nebula now runs as a system user and group created for each nebula network, using the `CAP_NET_ADMIN` ambient capability on launch rather than starting as root. Ensure that any files each Nebula instance needs to access are owned by the correct user and group, by default `nebula-${networkName}`.

- The `i18n.inputMethod.fcitx` option has been replaced with `i18n.inputMethod.fcitx5` because fcitx 4 `pkgs.fcitx` has been removed.

- In `mastodon` it is now necessary to specify location of file with `PostgreSQL` database password. In `services.mastodon.database.passwordFile` parameter default value `/var/lib/mastodon/secrets/db-password` has been changed to `null`.

- The `nix.readOnlyStore` option has been renamed to `boot.readOnlyNixStore` to clarify that it configures the NixOS boot process, not the Nix daemon.

- The latest available version of Nextcloud is v26 (available as `pkgs.nextcloud26`) which uses PHP 8.2 as interpreter by default. The installation logic is as follows:
  - If `system.stateVersion` is >=23.05, `pkgs.nextcloud26` will be installed by default.
  - If `system.stateVersion` is >=22.11, `pkgs.nextcloud25` will be installed by default.
  - Please note that an upgrade from v24 (or older) to v26 directly is not possible. Please upgrade to `nextcloud25` (or earlier) first. Nextcloud prohibits skipping major versions while upgrading. You can upgrade by declaring [`services.nextcloud.package = pkgs.nextcloud25;`](options.html#opt-services.nextcloud.package).
  - It's recommended to use the latest version available (i.e. v26) and to specify that using `services.nextcloud.package`.

- .NET 5.0 and .NET 3.1 were removed due to being end-of-life, use a newer, supported .NET version. Visit the  [Support Policy](https://dotnet.microsoft.com/en-us/platform/support/policy/dotnet-core) for more information.

- The iputils package, which is installed by default, no longer provides the
  `ninfod`, `rarpd` and `rdisc` tools. See [upstream's release notes](https://github.com/iputils/iputils/releases/tag/20221126) for more details and available replacements.

- The ppp plugin `rp-pppoe.so` has been renamed to `pppoe.so` in ppp 2.4.9. Starting from ppp 2.5.0, there is no longer an alias for backwards compatibility. Configurations that use this plugin must be updated accordingly from `plugin rp-pppoe.so` to `plugin pppoe.so`. See [upstream change](https://github.com/ppp-project/ppp/commit/610a7bd76eb1f99f22317541b35001b1e24877ed).

- [services.xserver.videoDrivers](options.html#opt-services.xserver.videoDrivers) now defaults to the `modesetting` driver over device-specific ones. The `radeon`, `amdgpu` and `nouveau` drivers are still available, but effectively unmaintained and not recommended for use. Note that this __does not__ affect your regular graphics drivers; this only concerns the DDX component of the driver, which most people are not relying on.

- [services.xserver.libinput.enable](options.html#opt-services.xserver.libinput.enable) is now set by default, enabling the more actively maintained and consistently behaved input device driver.

- To enable the HTTP3 (QUIC) protocol for a nginx virtual host, set the `quic` attribute on it to true, e.g. `services.nginx.virtualHosts.<name>.quic = true;`.

- In `services.fail2ban`, `bantime-increment.<name>` options now default to `null` (except `bantime-increment.enable`) and are used to set the corresponding option in `jail.local` only if not `null`. Also, enforce that `bantime-increment.formula` and `bantime-increment.multipliers` are not both specified.

- The default `asterisk` package was changed to v20 from v19. Asterisk versions 16 and 19 have been dropped due to being EOL. You may need to update /var/lib/asterisk to match the template files in `${asterisk-20}/var/lib/asterisk`.

- conntrack helper autodetection has been removed from kernels 6.0 and up upstream, and an assertion was added to ensure things don't silently stop working. Migrate your configuration to assign helpers explicitly or use an older LTS kernel branch as a temporary workaround.

- The `services.pipewire.config` options have been removed, as they have basically never worked correctly. All behavior defined by the default configuration can be overridden with drop-in files as necessary - see [below](#sec-release-23.05-migration-pipewire) for details.

- The catch-all `hardware.video.hidpi.enable` option was removed. Users on high density displays may want to:

  - Set `services.xserver.upscaleDefaultCursor` to upscale the default X11 cursor for higher resolutions
  - Adjust settings under `fonts.fontconfig` according to preference
  - Adjust `console.font` according to preference, though the kernel will generally choose a reasonably sized font

- `services.pipewire.media-session` and the `pipewire-media-session` package have been removed, as they are no longer supported upstream. Users are encouraged to use `services.pipewire.wireplumber` instead.

- The `baget` package and module was removed due to being unmaintained.

- The `qlandkartegt` and `garmindev` packages were removed due to being unmaintained and insecure.

- The `go-ethereum` package has been updated to v1.11.5 and the `puppeth` command is no longer available as of v1.11.0.

- The `pnpm` package has be updated to from version 7.29.1 to version 8.1.1 and Node.js 14 support has been discontinued (though, there are workarounds if Node.js 14 is still required)
  - Migration instructions: ["Before updating pnpm to v8 in your CI, regenerate your pnpm-lock.yaml. To upgrade your lockfile, run pnpm install and commit the changes. Existing dependencies will not be updated; however, due to configuration changes in pnpm v8, some missing peer dependencies may be added to the lockfile and some packages may get deduplicated. You can commit the new lockfile even before upgrading Node.js in the CI, as pnpm v7 already supports the new lockfile format."](https://github.com/pnpm/pnpm/releases/tag/v8.0.0)

- The `zplug` package changes its output path from `$out` to `$out/share/zplug`. Users should update their dependency on `${pkgs.zplug}/init.zsh` to `${pkgs.zplug}/share/zplug/init.zsh`.

- The `pict-rs` package was updated from an 0.3 alpha release to 0.3 stable, and related environment variables now require two underscores instead of one.

- The `shattered-pixel-dungeon` game was updated from 1.1.2 to 2.0.2.
  - The location of game data has changed. To migrate it, run `mv ~/.shatteredpixel ~/.local/share/.shatteredpixel`
  - The update will delete all your in-progress games.

- `espanso` has been updated to major version 2. Therefore, migration steps may need to be performed. See [the official migration instructions](https://espanso.org/docs/migration/overview/) for how to perform these migrations. Further, `espanso-wayland` can now be used for Wayland support.

- Only `k3s` version 1.26 is included. Users of the `k3s_1_24` or `k3s_1_25` packages should upgrade to use the `1.26` version of the package.

- The `nerdfonts` package has been updated to major version 3, which includes potential [breaking changes](https://github.com/ryanoasis/nerd-fonts/releases/tag/v3.0.0).

## Other Notable Changes {#sec-release-23.05-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- To follow [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) a few options of `openssh` have been moved from `extraConfig` to the new freeform option `settings` and renamed, e.g.:
  - `services.openssh.forwardX11` to `services.openssh.settings.X11Forwarding`
  - `services.openssh.kbdInteractiveAuthentication` -> `services.openssh.settings.KbdInteractiveAuthentication`
  - `services.openssh.passwordAuthentication` to `services.openssh.settings.PasswordAuthentication`
  - `services.openssh.useDns` to `services.openssh.settings.UseDns`
  - `services.openssh.permitRootLogin` to `services.openssh.settings.PermitRootLogin`
  - `services.openssh.logLevel` to `services.openssh.settings.LogLevel`
  - `services.openssh.kexAlgorithms` to `services.openssh.settings.KexAlgorithms`
  - `services.openssh.macs` to `services.openssh.settings.Macs`
  - `services.openssh.ciphers` to `services.openssh.settings.Ciphers`
  - `services.openssh.gatewayPorts` to `services.openssh.settings.GatewayPorts`


- `vim_configurable` has been renamed to `vim-full` to avoid confusion: `vim-full`'s build-time features are configurable, but both `vim` and `vim-full` are _customizable_ (in the sense of user configuration, like vimrc).

- Pantheon now defaults to Mutter 43 and GNOME settings daemon 43, all Pantheon packages are now tracking elementary OS 7 updates.

- The module for the application firewall `opensnitch` got the ability to configure rules. Available as [services.opensnitch.rules](#opt-services.opensnitch.rules)

- The module `usbmuxd` now has the ability to change the package used by the daemon. In case you're experiencing issues with `usbmuxd` you can try an alternative program like `usbmuxd2`. Available as [services.usbmuxd.package](#opt-services.usbmuxd.package)

- `netbox` was updated to 3.5. NixOS' `services.netbox.package` still defaults to 3.3 if `stateVersion` is earlier than 23.05. Please review upstream's breaking changes [for 3.4.0](https://github.com/netbox-community/netbox/releases/tag/v3.4.0) and [for 3.5.0](https://github.com/netbox-community/netbox/releases/tag/v3.5.0), and upgrade NetBox by changing `services.netbox.package`. Database migrations will be run automatically.

- `services.netbox` now support RFC42-style options, through `services.netbox.settings`.

- `services.mastodon` gained a tootctl wrapped named `mastodon-tootctl` similar to `nextcloud-occ` which can be executed from any user and switches to the configured mastodon user with sudo and sources the environment variables.

- `services.borgmatic` now allows for multiple configurations, placed in `/etc/borgmatic.d/`, you can define them with `services.borgmatic.configurations`.

- `service.openafsServer` features a new backup server `pkgs.fabs` as a
  replacement for openafs's own `buserver`. See
  [FABS](https://github.com/openafs-contrib/fabs) to check if this is an viable
  replacement. It stores backups as volume dump files and thus better integrates
  into contemporary backup solutions.

- `services.maddy` got several updates:
  - Configuration of users and their credentials using `services.maddy.ensureCredentials`.
  - TLS configuration is now possible via `services.maddy.tls` with two loaders present: ACME and file based.

- The `dnsmasq` service now takes configuration via the
  `services.dnsmasq.settings` attribute set. The option
  `services.dnsmasq.extraConfig` will be deprecated when NixOS 22.11 reaches
  end of life.

- The `dokuwiki` service is now configured via `services.dokuwiki.sites.<name>.settings` attribute set; `extraConfig` has been removed.
  The `{aclUse,superUser,disableActions}` attributes have been renamed accordingly. `pluginsConfig` now only accepts an attribute set of booleans.
  Passing plain PHP is no longer possible.
  Same applies to `acl` which now also only accepts structured `settings`.

- The `zsh` package changes the way to set environment variables on NixOS systems where `programs.zsh.enable` equals `false`.  It now sources `/etc/set-environment` when reading the system-level `zshenv` file.  Before, it sourced `/etc/profile` when reading the system-level `zprofile` file.

- The `wordpress` service now takes configuration via the `services.wordpress.sites.<name>.settings` attribute set, `extraConfig` is still available to append  additional text to `wp-config.php`.

- To reduce closure size in `nixos/modules/profiles/minimal.nix` profile disabled installation documentations and manuals. Also disabled `logrotate` and `udisks2` services.

- To reduce closure size in `nixos/modules/installer/netboot/netboot-minimal.nix` profile disabled load linux firmwares, pre-installing the complete stdenv and `networking.wireless` service.

- The minimal ISO image now uses the `nixos/modules/profiles/minimal.nix` profile.

- NixOS installer ISOs can now be built for `powerpc64le-linux`; see `nixos/modules/installer/sd-card/sd-image-powerpc64le.nix` and [PR 192672](https://github.com/NixOS/nixpkgs/pull/192672).  Hydra does not support this platform, so you must build the binaries yourself.

- The `ghcWithPackages` and `ghcWithHoogle` wrappers will now also symlink GHC's
  and all included libraries' documentation to `$out/share/doc` for convenience.
  If undesired, the old behavior can be restored by overriding the builders with
  `{ installDocumentation = false; }`.

- The nftables module now validates its ruleset at build time. The new `networking.nftables.checkRuleset` option allows disabling this check, which may fail when rules have very specific requirements, that the sandbox environment, by default, will not cover. The `networking.nftables.preCheckRuleset` option can be used to prepare the environment before the checks are run.

- The `services.mastodon` module now supports connection to a remote `PostgreSQL` database.

- [`services.nextcloud.database.createLocally`](#opt-services.nextcloud.database.createLocally) now uses socket authentication and is no longer compatible with password authentication.
  - If you want the module to manage the database for you, unset [`services.nextcloud.config.dbpassFile`](#opt-services.nextcloud.config.dbpassFile) (and [`services.nextcloud.config.dbhost`](#opt-services.nextcloud.config.dbhost), if it's set).
  - If you want to use password authentication **and** create the database locally, you will have to use [`services.mysql`](#opt-services.mysql.enable) to set it up.

- [`services.nextcloud.config.objectstore.s3.sseCKeyFile`](#opt-services.nextcloud.config.objectstore.s3.sseCKeyFile) is a new option to enable server-side encryption with customer provided keys (SSE-C) for your S3 in Nextcloud.

- NixOS swap partitions with random encryption can now control the sector size, cipher, and key size used to set up the plain encryption device over the underlying block device rather than allowing them to be determined by `cryptsetup(8)`. One can use these features like so:

  ```nix
  {
    swapDevices = [ {
      device = "/dev/disk/by-partlabel/swapspace";
      randomEncryption = {
        enable = true;
        cipher = "aes-xts-plain64";
        keySize = 512;
        sectorSize = 4096;
      };
    } ];
  }
  ```

- New option `security.pam.zfs` to enable unlocking and mounting of encrypted ZFS home dataset at login.

- `services.peertube` now requires you to specify the secret file `secrets.secretsFile`. It can be generated by running `openssl rand -hex 32`.  Before upgrading, check the release notes for [PeerTube v5.0.0](https://github.com/Chocobozzz/PeerTube/releases/tag/v5.0.0).And backup your data.

- `services.chronyd` is now started with additional systemd sandbox/hardening options for better security.

- PostgreSQL has added opt-in support for [JIT compilation](https://www.postgresql.org/docs/current/jit-reason.html). It can be enabled like this:
  ```nix
  {
    services.postgresql.enableJIT = true;
  }
  ```

- `services.netdata` offers a [`services.netdata.deadlineBeforeStopSec`](#opt-services.netdata.deadlineBeforeStopSec) option which will control the deadline (in seconds) after which systemd will consider your netdata instance as dead if it didn't start in the elapsed time. It is helpful when your netdata instance takes longer to start because of a large amount of state or upgrades.

- `services.dhcpcd` service stopped soliciting or accepting IPv6 Router Advertisements on interfaces that use static IPv6 addresses.
  If your network provides both IPv6 unique local addresses (ULA) and globally unique addresses (GUA) through autoconfiguration with SLAAC, you must add the parameter `networking.dhcpcd.IPv6rs = true;`.

- The module `services.headscale` was refactored to be compliant with [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md). To be precise, this means that the following things have changed:

  - Most settings have been migrated below [services.headscale.settings](#opt-services.headscale.settings) which is a freeform attribute-set that will be converted into headscale's YAML config format. This means that the configuration from [headscale's example configuration](https://github.com/juanfont/headscale/blob/main/config-example.yaml) can be directly written as attribute-set in Nix within this option.

- `services.kubo` now unmounts `ipfsMountDir` and `ipnsMountDir` even if it is killed unexpectedly when `autoMount` is enabled.

- `services.grafana` listens only on localhost by default again. This was changed to the upstream default of `0.0.0.0` by accident in the freeform setting conversion.

- Grafana Tempo has been updated to version 2.0. See the [upstream upgrade guide](https://grafana.com/docs/tempo/latest/release-notes/v2-0/#upgrade-considerations) for migration instructions.

- A new `virtualisation.rosetta` module was added to allow running `x86_64` binaries through [Rosetta](https://developer.apple.com/documentation/apple-silicon/about-the-rosetta-translation-environment) inside virtualised NixOS guests on Apple Silicon. This feature works by default with the [UTM](https://docs.getutm.app/) virtualisation [package](https://search.nixos.org/packages?channel=23.05&show=utm&from=0&size=1&sort=relevance&type=packages&query=utm).

- The new option `users.motdFile` allows configuring a Message Of The Day that can be updated dynamically.

- The `root` package is now built with the `"-Dgnuinstall=ON"` CMake flag, making the output conform the `bin` `lib` `share` layout. In this layout, `tutorials` is under `share/doc/ROOT/`; `cmake`, `font`, `icons`, `js` and `macro` under `share/root`; `Makefile.comp` and `Makefile.config` under `etc/root`.

- There are various new options in the `services.nginx` module:
    - Enabling global redirect in `services.nginx.virtualHosts` now allows one to add exceptions with the `locations` option.
    - The `proxyCachePath` option has been added to `services.nginx`. It allows configuring the [`proxy_cache_path`](https://nginx.org/en/docs/http/ngx_http_proxy_module.html#proxy_cache_path), that configures the storage path and various other settings for the cache.
    - A new option `recommendedBrotliSettings` has been added to `services.nginx`. Learn more about compression in Brotli format [here](https://github.com/google/ngx_brotli/blob/master/README.md).
    - `services.nginx.recommendedProxySettings` now removes the `Connection` header preventing clients from closing backend connections.

- The nginx module also received an update to `services.nginx.recommendedGzipSettings`:
  - Enables gzip compression for only certain proxied requests.
  - Allow checking and loading of precompressed files.
  - Updated gzip mime-types.
  - Increased the minimum length of a response that will be gzipped.

- [Garage](https://garagehq.deuxfleurs.fr/) version is based on [system.stateVersion](options.html#opt-system.stateVersion), existing installations will keep using version 0.7. New installations will use version 0.8. In order to upgrade a Garage cluster, please follow [upstream instructions](https://garagehq.deuxfleurs.fr/documentation/cookbook/upgrading/) and configure [services.garage.package](options.html#opt-services.garage.package).

- Nebula now supports the `services.nebula.networks.<name>.isRelay` and `services.nebula.networks.<name>.relays` configuration options for setting up or allowing traffic relaying. See the [announcement](https://www.defined.net/blog/announcing-relay-support-in-nebula/) for more details about relays.

- Resilio sync secret keys can now be provided using a secrets file at runtime, preventing these secrets from ending up in the Nix store.

- The `firewall` and `nat` modules can now optionally rely on an nftables based implementation. Enable `networking.nftables` to use it.

- The `services.fwupd` module now allows arbitrary daemon settings to be configured in a structured manner ([`services.fwupd.daemonSettings`](#opt-services.fwupd.daemonSettings)).

- `services.xserver.desktopManager.plasma5.phononBackend` now defaults to vlc according to [upstrean recommendation](https://community.kde.org/Distributions/Packaging_Recommendations#Non-Plasma_packages)

- The `zramSwap` is now implemented with `zram-generator`, and the option `zramSwap.numDevices` for using ZRAM devices as general purpose ephemeral block devices has been removed.

- As Singularity has renamed to [Apptainer](https://apptainer.org/news/community-announcement-20211130)
  to distinguish from [an un-renamed fork by Sylabs Inc.](https://sylabs.io/2021/05/singularity-community-edition),
  there are now two packages of Singularity/Apptainer:
  * `apptainer`: From `github.com/apptainer/apptainer`, which is the new repo after renaming.
  * `singularity`: From `github.com/sylabs/singularity`, which is the fork by Sylabs Inc..

  `singularity-tools.buildImage` got a new input argument `singularity` to specify which package to use.

- The new option `programs.singularity.enableFakeroot`, if set to `true`, provides `--fakeroot` support for `apptainer` and `singularity`.

- The new option `services.tailscale.useRoutingFeatures` controls various settings for using Tailscale features like exit nodes and subnet routers. If you wish to use your machine as an exit node, you can set this setting to `server`, otherwise if you wish to use an exit node you can set this setting to `client`. The strict RPF warning has been removed as the RPF will be loosened automatically based on the value of this setting.

- `openjdk` from version 11 and above is not build with `openjfx` (i.e.: JavaFX) support by default anymore. You can re-enable it by overriding, e.g.: `openjdk11.override { enableJavaFX = true; };`.

- [Xastir](https://xastir.org/index.php/Main_Page) can now access AX.25 interfaces via the `libax25` package.

- `nixos-version` now accepts `--configuration-revision` to display more information about the current generation revision

- The option `services.nomad.extraSettingsPlugins` has been fixed to allow more than one plugin in the path.

- The option `services.prometheus.exporters.pihole.interval` does not exist anymore and has been removed.

- The option `services.gpsd.device` has been replaced with  `services.gpsd.devices`, which supports multiple devices.

- `k3s` can now be configured with an `EnvironmentFile` for its systemd service, allowing secrets to be provided without ending up in the Nix Store.

- The `gitea` module options have been moved into a freeform attribute set below `services.gitea.settings`.

- `boot.initrd.luks.device.<name>` has a new `tryEmptyPassphrase` option, this is useful for OEMs who need to install an encrypted disk with a future settable passphrase

- The `bind` module now allows the per-zone `allow-query` setting to be configured (previously it was hard-coded to `any`; it still defaults to `any` to retain compatibility).

- The option `services.jitsi-videobridge.apis` has been renamed to `colibriRestApi` and turned into a boolean. Setting it to `true` will enable the private rest API, useful for monitoring using `services.prometheus.exporters.jitsi.enable`. Learn more about the API: "[The COLIBRI control interface (/colibri/)](https://github.com/jitsi/jitsi-videobridge/blob/v2.3/doc/rest.md)".

- Booting from a volume managed by the Stratis storage management daemon is now supported. Use `fileSystems.<name>.stratis.poolUuid` to configure the pool containing the fs.

## Nixpkgs internals {#sec-release-23.05-nixpkgs-internals}

- `buildDunePackage` now defaults to `strictDeps = true` which means that any library should go into `buildInputs` or `checkInputs`. Any executable that is run on the building machine should go into `nativeBuildInputs` or `nativeCheckInputs` respectively. Example of executables are `ocaml`, `findlib` and `menhir`. PPXs are libraries which are built by dune and should therefore not go into `nativeBuildInputs`.

- `buildFHSUserEnv` is now called `buildFHSEnv` and uses FlatPak's Bubblewrap sandboxing tool rather than Nixpkgs' own chrootenv. The old chrootenv-based implementation is still available via `buildFHSEnvChroot` but is considered deprecated and will be removed when the remaining uses inside Nixpkgs have been migrated. If your FHSEnv-wrapped application misbehaves when using the new bubblewrap implementation, please create an issue in Nixpkgs.

- Top-level `buildPlatform`, `hostPlatform`, `targetPlatform` have been deprecated, use `stdenv.X` instead.

- `carnix` and `cratesIO` has been removed due to being unmaintained, use alternatives such as [naersk](https://github.com/nix-community/naersk) and [crate2nix](https://github.com/kolloch/crate2nix) instead.

- `checkInputs` have been renamed to `nativeCheckInputs`, because they behave the same as `nativeBuildInputs` when `doCheck` is set. `checkInputs` now denote a new type of dependencies, added to `buildInputs` when `doCheck` is set. As a rule of thumb, `nativeCheckInputs` are tools on `$PATH` used during the tests, and `checkInputs` are libraries which are linked to executables built as part of the tests. Similarly, `installCheckInputs` are renamed to `nativeInstallCheckInputs`, corresponding to `nativeBuildInputs`, and `installCheckInputs` are a new type of dependencies added to `buildInputs` when `doInstallCheck` is set. (Note that this change will not cause breakage to derivations with `strictDeps` unset, which are most packages except python, rust, ocaml and go packages).

- DocBook option documentation, which has been deprecated since 22.11, will now cause a warning when documentation is built. Out-of-tree modules should migrate to using CommonMark documentation as outlined in [](#sec-option-declarations) to silence this warning.

  DocBook option documentation support will be removed in the next release and CommonMark will become the default. DocBook option documentation that has not been migrated until then will no longer render properly or cause errors.

- `lib.systems.examples.ghcjs` and consequently `pkgsCross.ghcjs` now use the target triplet `javascript-unknown-ghcjs` instead of `js-unknown-ghcjs`. This has been done to match an [upstream decision](https://gitlab.haskell.org/ghc/ghc/-/commit/6636b670233522f01d002c9b97827d00289dbf5c) to follow Cabal's platform naming more closely. Nixpkgs will also reject `js` as an architecture name.

- Lisp gained a [manual section](https://nixos.org/manual/nixpkgs/stable/#lisp), documenting a new and backwards incompatible interface. The previous interface will be removed in a future release.

- Calling `makeSetupHook` without passing a `name` argument is deprecated.

- `nixos/lib/make-disk-image.nix` handles `contents` arguments that are directories better, fixing a bug where it used to put them in a subdirectory of the intended `target`.

- `nixos/lib/make-disk-image.nix` can now mutate EFI variables, run user-provided EFI firmware or variable templates. This is now extensively documented in the NixOS manual.

- Nixpkgs now uses [IEEE-standard floating point arithmetic](https://github.com/NixOS/nixpkgs/pull/170215) on `powerpc64le-linux`.

- Deprecated `xlibsWrapper` transitional package has been removed in favour of direct use of its constituents: `xorg.libX11`, `freetype` and others.

## Detailed migration information {#sec-release-23.05-migration}

### Pipewire configuration overrides {#sec-release-23.05-migration-pipewire}

#### Why this change? {#sec-release-23.05-migration-pipewire-why}

The Pipewire config semantics don't really match the NixOS module semantics, so it's extremely awkward to override the default config, especially when lists are involved. Vendoring the configuration files in nixpkgs also creates unnecessary maintenance overhead.

Also, upstream added a lot of accommodations to allow doing most of the things you'd want to do with a config edit in better ways.

#### Migrating your configuration {#sec-release-23.05-migration-pipewire-how}

Compare your settings to [the defaults](https://gitlab.freedesktop.org/pipewire/pipewire/-/tree/master/src/daemon) and where your configuration differs from them.

Then, create a drop-in JSON file in `/etc/pipewire/<config file name>.d/99-custom.conf` (the actual filename can be anything) and migrate your changes to it according to the following sections.

Repeat for every file you've modified, changing the directory name accordingly.

#### Things you can just copy over {#sec-release-23.05-migration-pipewire-simple}

If you are:

- setting properties via `*.properties`
- loading a new module to `context.modules`
- creating new objects with `context.objects`
- declaring SPA libraries with `context.spa-libs`
- running custom commands with `context.exec`
- adding new rules with `*.rules`
- running custom PulseAudio commands with `pulse.cmd`

Move the definitions into the drop-in.

Note that the use of `context.exec` is not recommended and other methods of running your thing are likely a better option.

```json
{
  "context.properties": {
    "your.property.name": "your.property.value"
  },
  "context.modules": [
    { "name": "libpipewire-module-my-cool-thing" }
  ],
  "context.objects": [
    { "factory": { ... } }
  ],
  "alsa.rules": [
    { "matches: { ... }, "actions": { ... } }
  ]
}
```

#### Removing a module from `context.modules` {#sec-release-23.05-migration-pipewire-removing-modules}

Look for an option to disable it via `context.properties` (`"module.x11.bell": "false"` is likely the most common use case here).
If one is not available, proceed to [Nuclear option](#sec-release-23.05-migration-pipewire).

#### Modifying a module's parameters in `context.modules` {#sec-release-23.05-migration-pipewire-modifying-modules}

For most modules (e.g. `libpipewire-module-rt`) it's enough to load the module again with the new arguments, e.g.:

```json
{
  "context.modules": [
    {
      "name": "libpipewire-module-rt",
      "args": {
        "rt.prio": 90
      }
    }
  ]
}
```

Note that `module-rt` specifically will generally use the highest values available by default, so setting limits on the `pipewire` systemd service is preferable to reloading.

If reloading the module is not an option, proceed to [Nuclear option](#sec-release-23.05-migration-pipewire).

#### Nuclear option {#sec-release-23.05-migration-pipewire-nuclear}
If all else fails, you can still manually copy the contents of the default configuration file
from `${pkgs.pipewire}/share/pipewire` to `/etc/pipewire` and edit it to fully override the default.
However, this should be done only as a last resort. Please talk to the Pipewire maintainers if you ever need to do this.
