# generated by pkgs/applications/editors/vim/plugins/nvim-treesitter/update.py

{ buildGrammar, fetchCrate, fetchFromBitbucket, fetchFromGitHub, fetchFromGitLab, fetchFromGitea, fetchFromGitiles, fetchFromRepoOrCz, fetchFromSourcehut, fetchHex, fetchPypi, fetchgit, fetchhg, fetchsvn }:

{
  ada = buildGrammar {
    language = "ada";
    version = "0.0.0+rev=e8e2515";
    src = fetchFromGitHub {
      owner = "briot";
      repo = "tree-sitter-ada";
      rev = "e8e2515465cc2d7c444498e68bdb9f1d86767f95";
      hash = "sha256-qfuVoh3R418F1FMN6CTXNnCaAk5gQj5lI/NoaJgnkW8=";
    };
    meta.homepage = "https://github.com/briot/tree-sitter-ada";
  };
  agda = buildGrammar {
    language = "agda";
    version = "0.0.0+rev=b9b32fa";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-agda";
      rev = "b9b32fa042c2952a7bfca86847ea325e44ccc897";
      hash = "sha256-Goll4J6xrHO8YEuYoLR2rqy6lCMsr4JJbEs5C1jiX5Q=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-agda";
  };
  angular = buildGrammar {
    language = "angular";
    version = "0.0.0+rev=745d3c6";
    src = fetchFromGitHub {
      owner = "dlvandenberg";
      repo = "tree-sitter-angular";
      rev = "745d3c65c2294aca1110b6b6ad6805124be605c9";
      hash = "sha256-4i1B4r+V5QgBIPVJepQ7V2pJDQfafLxRG1sk4XZVrco=";
    };
    meta.homepage = "https://github.com/dlvandenberg/tree-sitter-angular";
  };
  apex = buildGrammar {
    language = "apex";
    version = "0.0.0+rev=46d4a12";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "46d4a12e4e90b10a575b7b16ea3b6ead50322074";
      hash = "sha256-vPSdx//9PZXDV9wzkMobaSVl88+iVGi/E+t7EA2yyCY=";
    };
    location = "apex";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  arduino = buildGrammar {
    language = "arduino";
    version = "0.0.0+rev=415ebc8";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-arduino";
      rev = "415ebc8f75eb02a748faa03f5af199f08ced120f";
      hash = "sha256-cgmlrAeuCnocdjI/zvafMxmXPmOE7GnrC+HlNJcT1Y0=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-arduino";
  };
  asm = buildGrammar {
    language = "asm";
    version = "0.0.0+rev=55b2b91";
    src = fetchFromGitHub {
      owner = "RubixDev";
      repo = "tree-sitter-asm";
      rev = "55b2b913f1e71136027d6fce8212e760c64f3532";
      hash = "sha256-DJhnC+kbKK6ibmg7DgkSCbZoTBnH7q7yYfSxI/flsHE=";
    };
    meta.homepage = "https://github.com/RubixDev/tree-sitter-asm";
  };
  astro = buildGrammar {
    language = "astro";
    version = "0.0.0+rev=4be1807";
    src = fetchFromGitHub {
      owner = "virchau13";
      repo = "tree-sitter-astro";
      rev = "4be180759ec13651f72bacee65fa477c64222a1a";
      hash = "sha256-qc9InFEQgeFfFReJuQd8WjTNK4fFMEaWcqQUcGxxuBI=";
    };
    meta.homepage = "https://github.com/virchau13/tree-sitter-astro";
  };
  authzed = buildGrammar {
    language = "authzed";
    version = "0.0.0+rev=1dec7e1";
    src = fetchFromGitHub {
      owner = "mleonidas";
      repo = "tree-sitter-authzed";
      rev = "1dec7e1af96c56924e3322cd85fdce15d0a31d00";
      hash = "sha256-qPSQF95DO7WByVy9YXEOus3q3U4QfWuUFbJGVXd4EtQ=";
    };
    meta.homepage = "https://github.com/mleonidas/tree-sitter-authzed";
  };
  awk = buildGrammar {
    language = "awk";
    version = "0.0.0+rev=34bbdc7";
    src = fetchFromGitHub {
      owner = "Beaglefoot";
      repo = "tree-sitter-awk";
      rev = "34bbdc7cce8e803096f47b625979e34c1be38127";
      hash = "sha256-MDfAtG6ZC0KttJ5bdW71Jgts+SAJitRnwu8xQ26N9K0=";
    };
    meta.homepage = "https://github.com/Beaglefoot/tree-sitter-awk";
  };
  bash = buildGrammar {
    language = "bash";
    version = "0.0.0+rev=49c3100";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-bash";
      rev = "49c31006d8307dcb12bc5770f35b6d5b9e2be68e";
      hash = "sha256-JW+30zIyq8Xc7NG9V+YoFqC+57BjZXIbAvWPD2lqvIE=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-bash";
  };
  bass = buildGrammar {
    language = "bass";
    version = "0.0.0+rev=28dc705";
    src = fetchFromGitHub {
      owner = "vito";
      repo = "tree-sitter-bass";
      rev = "28dc7059722be090d04cd751aed915b2fee2f89a";
      hash = "sha256-NKu60BbTKLsYQRtfEoqGQUKERJFnmZNVJE6HBz/BRIM=";
    };
    meta.homepage = "https://github.com/vito/tree-sitter-bass";
  };
  beancount = buildGrammar {
    language = "beancount";
    version = "0.0.0+rev=9bc460a";
    src = fetchFromGitHub {
      owner = "polarmutex";
      repo = "tree-sitter-beancount";
      rev = "9bc460a05b5f096d69568b5fb36105032ff4ff97";
      hash = "sha256-MSLM7Or1SZeqj0WzJ26o5cmYa5vWcSbMhDzMkqWRJgE=";
    };
    meta.homepage = "https://github.com/polarmutex/tree-sitter-beancount";
  };
  bibtex = buildGrammar {
    language = "bibtex";
    version = "0.0.0+rev=ccfd77d";
    src = fetchFromGitHub {
      owner = "latex-lsp";
      repo = "tree-sitter-bibtex";
      rev = "ccfd77db0ed799b6c22c214fe9d2937f47bc8b34";
      hash = "sha256-wgduSxlpbJy/ITenBLfj5lhziUM1BApX6MjXhWcb7lQ=";
    };
    meta.homepage = "https://github.com/latex-lsp/tree-sitter-bibtex";
  };
  bicep = buildGrammar {
    language = "bicep";
    version = "0.0.0+rev=0092c7d";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-bicep";
      rev = "0092c7d1bd6bb22ce0a6f78497d50ea2b87f19c0";
      hash = "sha256-jj1ccJQOX8oBx1XVKzI53B1sveq5kNADc2DB8bJhsf4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-bicep";
  };
  bitbake = buildGrammar {
    language = "bitbake";
    version = "0.0.0+rev=a5d04fd";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-bitbake";
      rev = "a5d04fdb5a69a02b8fa8eb5525a60dfb5309b73b";
      hash = "sha256-SzHFNIeR6ukWXKkLd2Trg9zuKLMwNAolXGPIDBDaFRg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-bitbake";
  };
  blueprint = buildGrammar {
    language = "blueprint";
    version = "0.0.0+rev=60ba737";
    src = fetchFromGitLab {
      owner = "gabmus";
      repo = "tree-sitter-blueprint";
      rev = "60ba73739c6083c693d86a1a7cf039c07eb4ed59";
      hash = "sha256-ojm6OKgriKUqUcRBf8WgHv+BvPjUuYOaabC8VXE+Kwk=";
    };
    meta.homepage = "https://gitlab.com/gabmus/tree-sitter-blueprint.git";
  };
  bp = buildGrammar {
    language = "bp";
    version = "0.0.0+rev=4e60cf3";
    src = fetchFromGitHub {
      owner = "ambroisie";
      repo = "tree-sitter-bp";
      rev = "4e60cf3c2e613625c06f6f85540b3631e2d06cd3";
      hash = "sha256-E8xL93rZx5I1RWXduBZdfVnogmha6TFQz4KerNWrpTI=";
    };
    meta.homepage = "https://github.com/ambroisie/tree-sitter-bp";
  };
  c = buildGrammar {
    language = "c";
    version = "0.0.0+rev=e8841a6";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-c";
      rev = "e8841a6a9431b7365ac9055688429e1deb8db90f";
      hash = "sha256-fFrIqiOgW+Aq4SbmevjLwooYeDOh0Odp0OJ/LkGDS04=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-c";
  };
  c_sharp = buildGrammar {
    language = "c_sharp";
    version = "0.0.0+rev=362a8a4";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-c-sharp";
      rev = "362a8a41b265056592a0c3771664a21d23a71392";
      hash = "sha256-weH0nyLpvVK/OpgvOjTuJdH2Hm4a1wVshHmhUdFq3XA=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-c-sharp";
  };
  cairo = buildGrammar {
    language = "cairo";
    version = "0.0.0+rev=6238f60";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-cairo";
      rev = "6238f609bea233040fe927858156dee5515a0745";
      hash = "sha256-QjCt3sRINrNbaxtNwj43+g7D3xYmuh0BIAo6wWQ/54g=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-cairo";
  };
  capnp = buildGrammar {
    language = "capnp";
    version = "0.0.0+rev=7b0883c";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-capnp";
      rev = "7b0883c03e5edd34ef7bcf703194204299d7099f";
      hash = "sha256-WKrZuOMxmdGlvUI9y8JgwCNMdJ8MULucMhkmW8JCiXM=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-capnp";
  };
  chatito = buildGrammar {
    language = "chatito";
    version = "0.0.0+rev=a461f20";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-chatito";
      rev = "a461f20dedb43905febb12c1635bc7d2e43e96f0";
      hash = "sha256-nAdyG068usqGr9OI/bZXiNfSkIg/+L6KTcylZVNNc+o=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-chatito";
  };
  clojure = buildGrammar {
    language = "clojure";
    version = "0.0.0+rev=f4236d4";
    src = fetchFromGitHub {
      owner = "sogaiu";
      repo = "tree-sitter-clojure";
      rev = "f4236d4da8aa92bc105d9c118746474c608e6af7";
      hash = "sha256-UlK6D/xnuPFL/Cu5W7hBMQ/zbodFwrS1CeJDjVpZFpo=";
    };
    meta.homepage = "https://github.com/sogaiu/tree-sitter-clojure";
  };
  cmake = buildGrammar {
    language = "cmake";
    version = "0.0.0+rev=e409ae3";
    src = fetchFromGitHub {
      owner = "uyha";
      repo = "tree-sitter-cmake";
      rev = "e409ae33f00e04cde30f2bcffb979caf1a33562a";
      hash = "sha256-+DiM/deIBx4AyJOF86S5tbKkg93+1fg4r8kDnlyfU+w=";
    };
    meta.homepage = "https://github.com/uyha/tree-sitter-cmake";
  };
  comment = buildGrammar {
    language = "comment";
    version = "0.0.0+rev=3555706";
    src = fetchFromGitHub {
      owner = "stsewd";
      repo = "tree-sitter-comment";
      rev = "3555706cef8b98d3e4c7379d7260548ff03ad363";
      hash = "sha256-7iY7D7wz+rYRWhi+429a2pcF0mUMBCnnecIssxlqvt0=";
    };
    meta.homepage = "https://github.com/stsewd/tree-sitter-comment";
  };
  commonlisp = buildGrammar {
    language = "commonlisp";
    version = "0.0.0+rev=bf2a65b";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-commonlisp";
      rev = "bf2a65b1c119898a1a17389e07f2a399c05cdc0c";
      hash = "sha256-dCrHrNfJoHfOt3sS2fUqbrw4snHMu+MoPumLYTGfoho=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-commonlisp";
  };
  cooklang = buildGrammar {
    language = "cooklang";
    version = "0.0.0+rev=4ebe237";
    src = fetchFromGitHub {
      owner = "addcninblue";
      repo = "tree-sitter-cooklang";
      rev = "4ebe237c1cf64cf3826fc249e9ec0988fe07e58e";
      hash = "sha256-VB3BxSrhIbD8TytfOJx7IhTwl/aWasB8t3xnrO34rQE=";
    };
    meta.homepage = "https://github.com/addcninblue/tree-sitter-cooklang";
  };
  corn = buildGrammar {
    language = "corn";
    version = "0.0.0+rev=4646547";
    src = fetchFromGitHub {
      owner = "jakestanger";
      repo = "tree-sitter-corn";
      rev = "464654742cbfd3a3de560aba120998f1d5dfa844";
      hash = "sha256-fI7S+TkI2ofQ/Hal4CJ2HAaeQrjOju1rgJvyc6P3t9k=";
    };
    meta.homepage = "https://github.com/jakestanger/tree-sitter-corn";
  };
  cpon = buildGrammar {
    language = "cpon";
    version = "0.0.0+rev=594289e";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-cpon";
      rev = "594289eadfec719198e560f9d7fd243c4db678d5";
      hash = "sha256-Nr+98yrDkOS5Yh/EFmBWV9Yhv2tPfHGb4pPlLUwc+k8=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-cpon";
  };
  cpp = buildGrammar {
    language = "cpp";
    version = "0.0.0+rev=f41b4f6";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-cpp";
      rev = "f41b4f66a42100be405f96bdc4ebc4a61095d3e8";
      hash = "sha256-NRcyXjijLdoa5fdA+MKZyt7mnM5B37zCsqZh4QvuOtA=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-cpp";
  };
  css = buildGrammar {
    language = "css";
    version = "0.0.0+rev=6a442a3";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-css";
      rev = "6a442a3cf461b0ce275339e5afa178693484c927";
      hash = "sha256-+ZtJpxR+KlfrNHjpoCC5Il4aeYYvcB4Dtbs/BKxV60s=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-css";
  };
  csv = buildGrammar {
    language = "csv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "csv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  cuda = buildGrammar {
    language = "cuda";
    version = "0.0.0+rev=635e8aa";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-cuda";
      rev = "635e8aa3747823a0c4e9660c07cef76fe8d3ef93";
      hash = "sha256-+KHenEgo9wMncjEIJZoqS0x089hjdR3J1t+x663qy1M=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-cuda";
  };
  cue = buildGrammar {
    language = "cue";
    version = "0.0.0+rev=8a5f273";
    src = fetchFromGitHub {
      owner = "eonpatapon";
      repo = "tree-sitter-cue";
      rev = "8a5f273bfa281c66354da562f2307c2d394b6c81";
      hash = "sha256-uV7Tl41PCU+8uJa693km5xvysvbptbT7LvGyYIelspk=";
    };
    meta.homepage = "https://github.com/eonpatapon/tree-sitter-cue";
  };
  cylc = buildGrammar {
    language = "cylc";
    version = "0.0.0+rev=8b895c2";
    src = fetchFromGitHub {
      owner = "elliotfontaine";
      repo = "tree-sitter-cylc";
      rev = "8b895c278f98d05e67997f5e3a43fb5531933023";
      hash = "sha256-+Afoxp+1hJZfRsekpz9WAEw/i/7uoXb0wl7/b6tlPro=";
    };
    meta.homepage = "https://github.com/elliotfontaine/tree-sitter-cylc";
  };
  d = buildGrammar {
    language = "d";
    version = "0.0.0+rev=45e5f1e";
    src = fetchFromGitHub {
      owner = "gdamore";
      repo = "tree-sitter-d";
      rev = "45e5f1e9d6de2c68591bc8e5ec662cf18e950b4a";
      hash = "sha256-q96RgJWrMop2HBBsQloVTspe3EaMtUL3wmVuT9xnE/g=";
    };
    meta.homepage = "https://github.com/gdamore/tree-sitter-d";
  };
  dart = buildGrammar {
    language = "dart";
    version = "0.0.0+rev=a7496b9";
    src = fetchFromGitHub {
      owner = "UserNobody14";
      repo = "tree-sitter-dart";
      rev = "a7496b9d562be91e6588eecd5d7045832f575cd0";
      hash = "sha256-HEeg1Jovvg65NLyjICd4Gi/+e1QapxuEF2tqhh4B0dA=";
    };
    meta.homepage = "https://github.com/UserNobody14/tree-sitter-dart";
  };
  desktop = buildGrammar {
    language = "desktop";
    version = "0.0.0+rev=d52964c";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-desktop";
      rev = "d52964c67d98eaedabca6ed1ec21ae54a522e8f8";
      hash = "sha256-JF6xSMKj0tZ53t+65pk4P+Mn3ubbVczJGVDGGfqDiO4=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-desktop";
  };
  devicetree = buildGrammar {
    language = "devicetree";
    version = "0.0.0+rev=16f640f";
    src = fetchFromGitHub {
      owner = "joelspadin";
      repo = "tree-sitter-devicetree";
      rev = "16f640f3c59117c9e749d581634afdb00e004f4c";
      hash = "sha256-0J1Q25JEWVAlBHAgWRtHAwIIDNoSLYrEdMC45/jf7Uc=";
    };
    meta.homepage = "https://github.com/joelspadin/tree-sitter-devicetree";
  };
  dhall = buildGrammar {
    language = "dhall";
    version = "0.0.0+rev=4a6c08a";
    src = fetchFromGitHub {
      owner = "jbellerb";
      repo = "tree-sitter-dhall";
      rev = "4a6c08abfb54827db4e722d6cdca81b093898988";
      hash = "sha256-EP6eL04ltnnP2ypNsq6rLrG3F4bVg7QtnK3k0KP2/MY=";
    };
    meta.homepage = "https://github.com/jbellerb/tree-sitter-dhall";
  };
  diff = buildGrammar {
    language = "diff";
    version = "0.0.0+rev=63439b5";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-diff";
      rev = "63439b5e6e35750aff1e53d9eecc663d369c54bc";
      hash = "sha256-dMEeSOb4DlSPs5eq6tmFhrvkp9Imy3xS85hGoPFeH24=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-diff";
  };
  disassembly = buildGrammar {
    language = "disassembly";
    version = "0.0.0+rev=0229c02";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-disassembly";
      rev = "0229c0211dba909c5d45129ac784a3f4d49c243a";
      hash = "sha256-IM3HzOhJmbb334PZ8q+r2EMi5Bv/rLoy+llPN0aghr8=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-disassembly";
  };
  djot = buildGrammar {
    language = "djot";
    version = "0.0.0+rev=886601b";
    src = fetchFromGitHub {
      owner = "treeman";
      repo = "tree-sitter-djot";
      rev = "886601b67d1f4690173a4925c214343c30704d32";
      hash = "sha256-uh41umECO8mIgML4JV5yz2iaNy6h5uLQWodcXvhI/MM=";
    };
    meta.homepage = "https://github.com/treeman/tree-sitter-djot";
  };
  dockerfile = buildGrammar {
    language = "dockerfile";
    version = "0.0.0+rev=087daa2";
    src = fetchFromGitHub {
      owner = "camdencheek";
      repo = "tree-sitter-dockerfile";
      rev = "087daa20438a6cc01fa5e6fe6906d77c869d19fe";
      hash = "sha256-uDRDq6MYYV8nh6FDsQN3tdyZywEg8A224bfWrgFGvFs=";
    };
    meta.homepage = "https://github.com/camdencheek/tree-sitter-dockerfile";
  };
  dot = buildGrammar {
    language = "dot";
    version = "0.0.0+rev=9ab8555";
    src = fetchFromGitHub {
      owner = "rydesun";
      repo = "tree-sitter-dot";
      rev = "9ab85550c896d8b294d9b9ca1e30698736f08cea";
      hash = "sha256-w4DInIT7mkTvQ6Hmi8yaAww6ktyNgRz0tPfBLGnOawQ=";
    };
    meta.homepage = "https://github.com/rydesun/tree-sitter-dot";
  };
  doxygen = buildGrammar {
    language = "doxygen";
    version = "0.0.0+rev=ccd998f";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-doxygen";
      rev = "ccd998f378c3f9345ea4eeb223f56d7b84d16687";
      hash = "sha256-Yh6FaRvWmeqnSnBgOojWbs1wJaeEoNJlvSEqgzjGh7o=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-doxygen";
  };
  dtd = buildGrammar {
    language = "dtd";
    version = "0.0.0+rev=4b64dd3";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-xml";
      rev = "4b64dd3a03ec002258d6268d712fd93716d6ab57";
      hash = "sha256-/0IQsTkvFQOWnkLc2srjg2bn1sB1sNA6Sm3nwKGUDj4=";
    };
    location = "dtd";
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-xml";
  };
  earthfile = buildGrammar {
    language = "earthfile";
    version = "0.0.0+rev=059fb08";
    src = fetchFromGitHub {
      owner = "glehmann";
      repo = "tree-sitter-earthfile";
      rev = "059fb087247bef8789e938629388c3e7af32c986";
      hash = "sha256-W3nGFisHK8V7F65cm7eyEgWa+qnjr75adFNz7GHfpPs=";
    };
    meta.homepage = "https://github.com/glehmann/tree-sitter-earthfile";
  };
  ebnf = buildGrammar {
    language = "ebnf";
    version = "0.0.0+rev=8e635b0";
    src = fetchFromGitHub {
      owner = "RubixDev";
      repo = "ebnf";
      rev = "8e635b0b723c620774dfb8abf382a7f531894b40";
      hash = "sha256-Cch6WCYq9bsWGypzDGapxBLJ0ZB432uAl6YjEjBJ5yg=";
    };
    location = "crates/tree-sitter-ebnf";
    meta.homepage = "https://github.com/RubixDev/ebnf";
  };
  editorconfig = buildGrammar {
    language = "editorconfig";
    version = "0.0.0+rev=cfdc59c";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-editorconfig";
      rev = "cfdc59ccdc13c324962a02e104743e0e23ca1010";
      hash = "sha256-u62DJcDj3LJRklcj8zkfd/6goJItf0eIAdz1ekbM76E=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-editorconfig";
  };
  eds = buildGrammar {
    language = "eds";
    version = "0.0.0+rev=26d529e";
    src = fetchFromGitHub {
      owner = "uyha";
      repo = "tree-sitter-eds";
      rev = "26d529e6cfecde391a03c21d1474eb51e0285805";
      hash = "sha256-+3BO4JxUrSc8OWHVZvd1lxjrNYkhN35q2YhcrUrFgMk=";
    };
    meta.homepage = "https://github.com/uyha/tree-sitter-eds";
  };
  eex = buildGrammar {
    language = "eex";
    version = "0.0.0+rev=f742f2f";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-eex";
      rev = "f742f2fe327463335e8671a87c0b9b396905d1d1";
      hash = "sha256-UPq62MkfGFh9m/UskoB9uBDIYOcotITCJXDyrbg/wKY=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-eex";
  };
  elixir = buildGrammar {
    language = "elixir";
    version = "0.0.0+rev=5345854";
    src = fetchFromGitHub {
      owner = "elixir-lang";
      repo = "tree-sitter-elixir";
      rev = "53458546e3bb717beee1d15df30724c81eb41d1c";
      hash = "sha256-Zuqjv4QEeCiHYCxGT9HYAXlqrRFTi8V88wAsot6O5TI=";
    };
    meta.homepage = "https://github.com/elixir-lang/tree-sitter-elixir";
  };
  elm = buildGrammar {
    language = "elm";
    version = "0.0.0+rev=27f502e";
    src = fetchFromGitHub {
      owner = "elm-tooling";
      repo = "tree-sitter-elm";
      rev = "27f502ed0a1cbd3c5912d284cc7934ee0d4cdddc";
      hash = "sha256-o5ou/9/TCzc9HuGzvSSZE2iyWCOwYk0c28KEgGrOiiI=";
    };
    meta.homepage = "https://github.com/elm-tooling/tree-sitter-elm";
  };
  elsa = buildGrammar {
    language = "elsa";
    version = "0.0.0+rev=0a66b2b";
    src = fetchFromGitHub {
      owner = "glapa-grossklag";
      repo = "tree-sitter-elsa";
      rev = "0a66b2b3f3c1915e67ad2ef9f7dbd2a84820d9d7";
      hash = "sha256-zahi5hOXzad6R1+mqmYBFfn2X+SejQUIQzbabgCIJ8w=";
    };
    meta.homepage = "https://github.com/glapa-grossklag/tree-sitter-elsa";
  };
  elvish = buildGrammar {
    language = "elvish";
    version = "0.0.0+rev=5e7210d";
    src = fetchFromGitHub {
      owner = "elves";
      repo = "tree-sitter-elvish";
      rev = "5e7210d945425b77f82cbaebc5af4dd3e1ad40f5";
      hash = "sha256-POuQA2Ihi+qDYQ5Pv7hBAzHpPu/FcnuYscW4ItDOCZg=";
    };
    meta.homepage = "https://github.com/elves/tree-sitter-elvish";
  };
  embedded_template = buildGrammar {
    language = "embedded_template";
    version = "0.0.0+rev=3322625";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-embedded-template";
      rev = "332262529bc51abf5746317b2255ccc2fff778f8";
      hash = "sha256-C2Lo3tT2363O++ycXiR6x0y+jy2zlmhcKp7t1LhvCe8=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-embedded-template";
  };
  erlang = buildGrammar {
    language = "erlang";
    version = "0.0.0+rev=4095e99";
    src = fetchFromGitHub {
      owner = "WhatsApp";
      repo = "tree-sitter-erlang";
      rev = "4095e9993acc89cb311ab1be8614c21b1cf768a4";
      hash = "sha256-+mp0h7qaJN30eqNIDJem5iOnnWATR1X4D6dB4gyGlfM=";
    };
    meta.homepage = "https://github.com/WhatsApp/tree-sitter-erlang";
  };
  facility = buildGrammar {
    language = "facility";
    version = "0.0.0+rev=2d037f2";
    src = fetchFromGitHub {
      owner = "FacilityApi";
      repo = "tree-sitter-facility";
      rev = "2d037f2f2bf668737f72e6be6eda4b7918b68d86";
      hash = "sha256-NyYymlCPqbi4GA+FI/M5MiQUr6tkJTNPO8Pvcy02lqI=";
    };
    meta.homepage = "https://github.com/FacilityApi/tree-sitter-facility";
  };
  faust = buildGrammar {
    language = "faust";
    version = "0.0.0+rev=f3b9274";
    src = fetchFromGitHub {
      owner = "khiner";
      repo = "tree-sitter-faust";
      rev = "f3b9274514b5f9bf6b0dd4a01c30f9cc15c58bc4";
      hash = "sha256-JwR8LCEptgQmEG/ruK5ukIGCNtvKJw5bobZ0WXF1ulY=";
    };
    meta.homepage = "https://github.com/khiner/tree-sitter-faust";
  };
  fennel = buildGrammar {
    language = "fennel";
    version = "0.0.0+rev=cfbfa47";
    src = fetchFromGitHub {
      owner = "alexmozaidze";
      repo = "tree-sitter-fennel";
      rev = "cfbfa478dc2dbef267ee94ae4323d9c886f45e94";
      hash = "sha256-0LusII7BPGFQTyEkxZi6h9HUDF0eHvGwA4fiQE2h3YQ=";
    };
    meta.homepage = "https://github.com/alexmozaidze/tree-sitter-fennel";
  };
  fidl = buildGrammar {
    language = "fidl";
    version = "0.0.0+rev=0a8910f";
    src = fetchFromGitHub {
      owner = "google";
      repo = "tree-sitter-fidl";
      rev = "0a8910f293268e27ff554357c229ba172b0eaed2";
      hash = "sha256-QFAkxQo2w/+OR7nZn9ldBk2yHOd23kzciAcQvIZ5hrY=";
    };
    meta.homepage = "https://github.com/google/tree-sitter-fidl";
  };
  firrtl = buildGrammar {
    language = "firrtl";
    version = "0.0.0+rev=8503d3a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-firrtl";
      rev = "8503d3a0fe0f9e427863cb0055699ff2d29ae5f5";
      hash = "sha256-I2EMcm6bTMRODmxOOOiv+U0fhm6yoNhjCyuINfTUtlY=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-firrtl";
  };
  fish = buildGrammar {
    language = "fish";
    version = "0.0.0+rev=a78aef9";
    src = fetchFromGitHub {
      owner = "ram02z";
      repo = "tree-sitter-fish";
      rev = "a78aef9abc395c600c38a037ac779afc7e3cc9e0";
      hash = "sha256-D7s3ZsHQeGf+pYdbXvi5GMFqbkgajBuqTQwvjnjnrVo=";
    };
    meta.homepage = "https://github.com/ram02z/tree-sitter-fish";
  };
  foam = buildGrammar {
    language = "foam";
    version = "0.0.0+rev=f08bb76";
    src = fetchFromGitHub {
      owner = "FoamScience";
      repo = "tree-sitter-foam";
      rev = "f08bb76892b93e5b23c45ac3bd6b1eea5df323cc";
      hash = "sha256-boH5WJNwJmZKN4JCcFvVdAU06ZRj6Zdsq3NibSWjAr8=";
    };
    meta.homepage = "https://github.com/FoamScience/tree-sitter-foam";
  };
  forth = buildGrammar {
    language = "forth";
    version = "0.0.0+rev=9018923";
    src = fetchFromGitHub {
      owner = "AlexanderBrevig";
      repo = "tree-sitter-forth";
      rev = "90189238385cf636b9ee99ce548b9e5b5e569d48";
      hash = "sha256-vySBDu9cMnubu4+7/sBttNxg1S4/MxWUKpjwEa14Rws=";
    };
    meta.homepage = "https://github.com/AlexanderBrevig/tree-sitter-forth";
  };
  fortran = buildGrammar {
    language = "fortran";
    version = "0.0.0+rev=e9fbb3a";
    src = fetchFromGitHub {
      owner = "stadelmanma";
      repo = "tree-sitter-fortran";
      rev = "e9fbb3acbfc62b051616e53b17ab97b9823e8617";
      hash = "sha256-G7tsnI22k7Ndur3fLnfr2xk4fUaJ4kIy3Dw0GuqHSqg=";
    };
    meta.homepage = "https://github.com/stadelmanma/tree-sitter-fortran";
  };
  fsh = buildGrammar {
    language = "fsh";
    version = "0.0.0+rev=fad2e17";
    src = fetchFromGitHub {
      owner = "mgramigna";
      repo = "tree-sitter-fsh";
      rev = "fad2e175099a45efbc98f000cc196d3674cc45e0";
      hash = "sha256-91r1FCQTocDkhS5Tx0vnFliitMStVzNTpf6BwPyaqVM=";
    };
    meta.homepage = "https://github.com/mgramigna/tree-sitter-fsh";
  };
  fsharp = buildGrammar {
    language = "fsharp";
    version = "0.0.0+rev=971da5f";
    src = fetchFromGitHub {
      owner = "ionide";
      repo = "tree-sitter-fsharp";
      rev = "971da5ff0266bfe4a6ecfb94616548032d6d1ba0";
      hash = "sha256-0jrbznAXcjXrbJ5jnxWMzPKxRopxKCtoQXGl80R1M0M=";
    };
    location = "fsharp";
    meta.homepage = "https://github.com/ionide/tree-sitter-fsharp";
  };
  func = buildGrammar {
    language = "func";
    version = "0.0.0+rev=f780ca5";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-func";
      rev = "f780ca55e65e7d7360d0229331763e16c452fc98";
      hash = "sha256-jM0VJZlfhenAZbhabpgsoRIGny3WSDoimZtwogcvaSI=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-func";
  };
  fusion = buildGrammar {
    language = "fusion";
    version = "0.0.0+rev=19db2f4";
    src = fetchFromGitLab {
      owner = "jirgn";
      repo = "tree-sitter-fusion";
      rev = "19db2f47ba4c3a0f6238d4ae0e2abfca16e61dd6";
      hash = "sha256-195q39pZYipT0G08kQlwnDE28ODjAz2/Sq1tzpEGFmU=";
    };
    meta.homepage = "https://gitlab.com/jirgn/tree-sitter-fusion.git";
  };
  gap = buildGrammar {
    language = "gap";
    version = "0.0.0+rev=141b063";
    src = fetchFromGitHub {
      owner = "gap-system";
      repo = "tree-sitter-gap";
      rev = "141b063335e85299bde3f61b4888d02d674a1abc";
      hash = "sha256-vl0bqJXTxpAfaMOIgQpX60I4dfPOJF6wpt10GiftuR0=";
    };
    meta.homepage = "https://github.com/gap-system/tree-sitter-gap";
  };
  gaptst = buildGrammar {
    language = "gaptst";
    version = "0.0.0+rev=e0723dc";
    src = fetchFromGitHub {
      owner = "gap-system";
      repo = "tree-sitter-gaptst";
      rev = "e0723dc6136309b3d5904dad2c73ef71267428c1";
      hash = "sha256-m8lxSM/c99KLnu5hbxaTol645DFqFwjTSzdaRUtHDAI=";
    };
    meta.homepage = "https://github.com/gap-system/tree-sitter-gaptst";
  };
  gdscript = buildGrammar {
    language = "gdscript";
    version = "0.0.0+rev=1f1e782";
    src = fetchFromGitHub {
      owner = "PrestonKnopp";
      repo = "tree-sitter-gdscript";
      rev = "1f1e782fe2600f50ae57b53876505b8282388d77";
      hash = "sha256-HikAZVoOqKRNnEBv/CCqqyt94HbXg2dBq+4GsmUFSIA=";
    };
    meta.homepage = "https://github.com/PrestonKnopp/tree-sitter-gdscript";
  };
  gdshader = buildGrammar {
    language = "gdshader";
    version = "0.0.0+rev=ffd9f95";
    src = fetchFromGitHub {
      owner = "GodOfAvacyn";
      repo = "tree-sitter-gdshader";
      rev = "ffd9f958df13cae04593781d7d2562295a872455";
      hash = "sha256-JWlDs0w10TqsPYgZvvaJwAueOciCYaws1Nr8rb0UKy4=";
    };
    meta.homepage = "https://github.com/GodOfAvacyn/tree-sitter-gdshader";
  };
  git_config = buildGrammar {
    language = "git_config";
    version = "0.0.0+rev=9c2a1b7";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-git-config";
      rev = "9c2a1b7894e6d9eedfe99805b829b4ecd871375e";
      hash = "sha256-O0w0BhhPPwhnKfniAFSPMWfBsZUTrijifAsmFiAncWg=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-git-config";
  };
  git_rebase = buildGrammar {
    language = "git_rebase";
    version = "0.0.0+rev=bff4b66";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-git-rebase";
      rev = "bff4b66b44b020d918d67e2828eada1974a966aa";
      hash = "sha256-k4C7dJUkvQxIxcaoVmG2cBs/CeYzVqrip2+2mRvHtZc=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-git-rebase";
  };
  gitattributes = buildGrammar {
    language = "gitattributes";
    version = "0.0.0+rev=5425944";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-gitattributes";
      rev = "5425944fd61bf2b3bad2c17c2dc9f53172b0f01d";
      hash = "sha256-X6M9/41xISnkDnXNgQAWexs68h8A0dwOz+aQa86H0pc=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-gitattributes";
  };
  gitcommit = buildGrammar {
    language = "gitcommit";
    version = "0.0.0+rev=db0e0c4";
    src = fetchFromGitHub {
      owner = "gbprod";
      repo = "tree-sitter-gitcommit";
      rev = "db0e0c4fb9095fdc42a7af34019c0616c071e9eb";
      hash = "sha256-rMLYEU4WdCInfNNAOuESCceavgWTy9NS8kgkTRaK1OE=";
    };
    meta.homepage = "https://github.com/gbprod/tree-sitter-gitcommit";
  };
  gitignore = buildGrammar {
    language = "gitignore";
    version = "0.0.0+rev=f4685bf";
    src = fetchFromGitHub {
      owner = "shunsambongi";
      repo = "tree-sitter-gitignore";
      rev = "f4685bf11ac466dd278449bcfe5fd014e94aa504";
      hash = "sha256-MjoY1tlVZgN6JqoTjhhg0zSdHzc8yplMr8824sfIKp8=";
    };
    meta.homepage = "https://github.com/shunsambongi/tree-sitter-gitignore";
  };
  gleam = buildGrammar {
    language = "gleam";
    version = "0.0.0+rev=2702fe8";
    src = fetchFromGitHub {
      owner = "gleam-lang";
      repo = "tree-sitter-gleam";
      rev = "2702fe84b986e4403a071bcb112d48e3dcde0ca4";
      hash = "sha256-DY79MOnZqb145DtmUyhma0WZ5PksDeqVvhwGuvFXGjM=";
    };
    meta.homepage = "https://github.com/gleam-lang/tree-sitter-gleam";
  };
  glimmer = buildGrammar {
    language = "glimmer";
    version = "0.0.0+rev=da605af";
    src = fetchFromGitHub {
      owner = "ember-tooling";
      repo = "tree-sitter-glimmer";
      rev = "da605af8c5999b43e6839b575eae5e6cafabb06f";
      hash = "sha256-2ofCBhp/Trj5ivZpMGFm6dvAGic+w8Tl0osRk+IRLL4=";
    };
    meta.homepage = "https://github.com/ember-tooling/tree-sitter-glimmer";
  };
  glimmer_javascript = buildGrammar {
    language = "glimmer_javascript";
    version = "0.0.0+rev=7e8ea8c";
    src = fetchFromGitHub {
      owner = "NullVoxPopuli";
      repo = "tree-sitter-glimmer-javascript";
      rev = "7e8ea8cf39fc360cb97bd253442cd48e4f7a9ce3";
      hash = "sha256-gqadIB5tB7aIOl3g6pxDeOsuENAwzb5RLVFn4d0G9MY=";
    };
    meta.homepage = "https://github.com/NullVoxPopuli/tree-sitter-glimmer-javascript";
  };
  glimmer_typescript = buildGrammar {
    language = "glimmer_typescript";
    version = "0.0.0+rev=4006128";
    src = fetchFromGitHub {
      owner = "NullVoxPopuli";
      repo = "tree-sitter-glimmer-typescript";
      rev = "4006128790efb58ca82a4492d8ef0983b260fc6a";
      hash = "sha256-oOF36q09hcOCdFWrFQlhDX79tS9xBNVgcp1vmxjRdGM=";
    };
    meta.homepage = "https://github.com/NullVoxPopuli/tree-sitter-glimmer-typescript";
  };
  glsl = buildGrammar {
    language = "glsl";
    version = "0.0.0+rev=66aec57";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-glsl";
      rev = "66aec57f7119c7e8e40665b723cd7af5594f15ee";
      hash = "sha256-EO8p3BhoyemCXlWq4BI5Y1KqU04F9KpEwbn8HoZd4z4=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-glsl";
  };
  gn = buildGrammar {
    language = "gn";
    version = "0.0.0+rev=bc06955";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-gn";
      rev = "bc06955bc1e3c9ff8e9b2b2a55b38b94da923c05";
      hash = "sha256-Sn6He4YRrKJe4QvGiaauquYBVQol0lWeIuOwkdUEzkQ=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-gn";
  };
  gnuplot = buildGrammar {
    language = "gnuplot";
    version = "0.0.0+rev=3c895f5";
    src = fetchFromGitHub {
      owner = "dpezto";
      repo = "tree-sitter-gnuplot";
      rev = "3c895f5d9c0b3a3c7e02383766b462c21913c000";
      hash = "sha256-szpXAHOcQjdk9mN87V69Jjdgj0aP/q7uRVza0yaK/uw=";
    };
    meta.homepage = "https://github.com/dpezto/tree-sitter-gnuplot";
  };
  go = buildGrammar {
    language = "go";
    version = "0.0.0+rev=0942d76";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-go";
      rev = "0942d76fc517739b5d29a0e420b5e602d19c724d";
      hash = "sha256-2j5cYuIn2gMFzNixijUcA9Ax2US8PEb/5VK44rjnZs4=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-go";
  };
  goctl = buildGrammar {
    language = "goctl";
    version = "0.0.0+rev=49c4353";
    src = fetchFromGitHub {
      owner = "chaozwn";
      repo = "tree-sitter-goctl";
      rev = "49c43532689fe1f53e8b9e009d0521cab02c432b";
      hash = "sha256-HYPj95Kg+C5Ax++Z83yUnhrf2iIVTuwOBhVVLlYQaGs=";
    };
    meta.homepage = "https://github.com/chaozwn/tree-sitter-goctl";
  };
  godot_resource = buildGrammar {
    language = "godot_resource";
    version = "0.0.0+rev=2ffb90d";
    src = fetchFromGitHub {
      owner = "PrestonKnopp";
      repo = "tree-sitter-godot-resource";
      rev = "2ffb90de47417018651fc3b970e5f6b67214dc9d";
      hash = "sha256-wdxCfG48fzswUg4q2pgI4q7jK7ZimpKo4+dRnZsZJ6U=";
    };
    meta.homepage = "https://github.com/PrestonKnopp/tree-sitter-godot-resource";
  };
  gomod = buildGrammar {
    language = "gomod";
    version = "0.0.0+rev=3b01edc";
    src = fetchFromGitHub {
      owner = "camdencheek";
      repo = "tree-sitter-go-mod";
      rev = "3b01edce2b9ea6766ca19328d1850e456fde3103";
      hash = "sha256-C3pPBgm68mmaPmstyIpIvvDHsx29yZ0ZX/QoUqwjb+0=";
    };
    meta.homepage = "https://github.com/camdencheek/tree-sitter-go-mod";
  };
  gosum = buildGrammar {
    language = "gosum";
    version = "0.0.0+rev=e2ac513";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-go-sum";
      rev = "e2ac513b2240c7ff1069ae33b2df29ce90777c11";
      hash = "sha256-2foA2sd5PQpmeX8OhXrW/dxoJaEyxDXzPWh+UD0dgzQ=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-go-sum";
  };
  gotmpl = buildGrammar {
    language = "gotmpl";
    version = "0.0.0+rev=ca52fbf";
    src = fetchFromGitHub {
      owner = "ngalaiko";
      repo = "tree-sitter-go-template";
      rev = "ca52fbfc98366c585b84f4cb3745df49f33cd140";
      hash = "sha256-ZWpzqKD3ceBzlsRjehXZgu+NZMbWyyK+/R1Ymg7DVkM=";
    };
    meta.homepage = "https://github.com/ngalaiko/tree-sitter-go-template";
  };
  gowork = buildGrammar {
    language = "gowork";
    version = "0.0.0+rev=949a8a4";
    src = fetchFromGitHub {
      owner = "omertuc";
      repo = "tree-sitter-go-work";
      rev = "949a8a470559543857a62102c84700d291fc984c";
      hash = "sha256-Tode7W05xaOKKD5QOp3rayFgLEOiMJUeGpVsIrizxto=";
    };
    meta.homepage = "https://github.com/omertuc/tree-sitter-go-work";
  };
  gpg = buildGrammar {
    language = "gpg";
    version = "0.0.0+rev=f99323f";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-gpg-config";
      rev = "f99323fb8f3f10b6c69db0c2f6d0a14bd7330675";
      hash = "sha256-VJXXpHVMKUNaslsjoKR6XsaUJ8C+0MyidXtRPRywnpg=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-gpg-config";
  };
  graphql = buildGrammar {
    language = "graphql";
    version = "0.0.0+rev=5e66e96";
    src = fetchFromGitHub {
      owner = "bkegley";
      repo = "tree-sitter-graphql";
      rev = "5e66e961eee421786bdda8495ed1db045e06b5fe";
      hash = "sha256-NvE9Rpdp4sALqKSRWJpqxwl6obmqnIIdvrL1nK5peXc=";
    };
    meta.homepage = "https://github.com/bkegley/tree-sitter-graphql";
  };
  gren = buildGrammar {
    language = "gren";
    version = "0.0.0+rev=c06e272";
    src = fetchFromGitHub {
      owner = "MaeBrooks";
      repo = "tree-sitter-gren";
      rev = "c06e272341363c5d8e19ac34bc7c56258a37e71b";
      hash = "sha256-Zxa/5hTFrkVRzswKion1tzrwp//ASuZKQjw7g/znBsI=";
    };
    meta.homepage = "https://github.com/MaeBrooks/tree-sitter-gren";
  };
  groovy = buildGrammar {
    language = "groovy";
    version = "0.0.0+rev=b53a8cc";
    src = fetchFromGitHub {
      owner = "murtaza64";
      repo = "tree-sitter-groovy";
      rev = "b53a8cc1075e056b8223b86f3bb392e0d57ae101";
      hash = "sha256-yLl3/4qla45tsjCd2EFutcNqVrDjyMUjnSpUUHwaIyE=";
    };
    meta.homepage = "https://github.com/murtaza64/tree-sitter-groovy";
  };
  gstlaunch = buildGrammar {
    language = "gstlaunch";
    version = "0.0.0+rev=549aef2";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-gstlaunch";
      rev = "549aef253fd38a53995cda1bf55c501174372bf7";
      hash = "sha256-zNUx/9dxEqyqTXCxEiNnYPzplnR7l9b2L4frYpPOA9M=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-gstlaunch";
  };
  hack = buildGrammar {
    language = "hack";
    version = "0.0.0+rev=fca1e29";
    src = fetchFromGitHub {
      owner = "slackhq";
      repo = "tree-sitter-hack";
      rev = "fca1e294f6dce8ec5659233a6a21f5bd0ed5b4f2";
      hash = "sha256-XTcsqCvlwbAAi7/TXrYX8wT56Ie+0OW5+eNRMH7XNyk=";
    };
    meta.homepage = "https://github.com/slackhq/tree-sitter-hack";
  };
  hare = buildGrammar {
    language = "hare";
    version = "0.0.0+rev=4af5d82";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-hare";
      rev = "4af5d82cf9ec39f67cb1db5b7a9269d337406592";
      hash = "sha256-QEnE5IQJ60PXb6QjgEE5L4p7Fjy0p+N+dyDTMh3YsRg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-hare";
  };
  haskell = buildGrammar {
    language = "haskell";
    version = "0.0.0+rev=2c2fcb2";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-haskell";
      rev = "2c2fcb22e3b939ed59ae8d6f10500c3213c68670";
      hash = "sha256-9yerJ3Cxfr1dU0GmWN9LiLjmdBpP8+fE1hDmP1oQHLI=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-haskell";
  };
  haskell_persistent = buildGrammar {
    language = "haskell_persistent";
    version = "0.0.0+rev=577259b";
    src = fetchFromGitHub {
      owner = "MercuryTechnologies";
      repo = "tree-sitter-haskell-persistent";
      rev = "577259b4068b2c281c9ebf94c109bd50a74d5857";
      hash = "sha256-ASdkBQ57GfpLF8NXgDzJMB/Marz9p1q03TZkwMgF/eQ=";
    };
    meta.homepage = "https://github.com/MercuryTechnologies/tree-sitter-haskell-persistent";
  };
  hcl = buildGrammar {
    language = "hcl";
    version = "0.0.0+rev=9e3ec98";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-hcl";
      rev = "9e3ec9848f28d26845ba300fd73c740459b83e9b";
      hash = "sha256-HM77BXavgP+H3XwHSqRdLlylmkH+idtuZqLeOV2VUiM=";
    };
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-hcl";
  };
  heex = buildGrammar {
    language = "heex";
    version = "0.0.0+rev=9359017";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-heex";
      rev = "9359017bd0dc6b023044713aa215544885663637";
      hash = "sha256-4DEfL/RxZk7cvP5qUHNohJlfAIW+ks34rdMd/uCvsvA=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-heex";
  };
  helm = buildGrammar {
    language = "helm";
    version = "0.0.0+rev=ca52fbf";
    src = fetchFromGitHub {
      owner = "ngalaiko";
      repo = "tree-sitter-go-template";
      rev = "ca52fbfc98366c585b84f4cb3745df49f33cd140";
      hash = "sha256-ZWpzqKD3ceBzlsRjehXZgu+NZMbWyyK+/R1Ymg7DVkM=";
    };
    location = "dialects/helm";
    meta.homepage = "https://github.com/ngalaiko/tree-sitter-go-template";
  };
  hjson = buildGrammar {
    language = "hjson";
    version = "0.0.0+rev=02fa3b7";
    src = fetchFromGitHub {
      owner = "winston0410";
      repo = "tree-sitter-hjson";
      rev = "02fa3b79b3ff9a296066da6277adfc3f26cbc9e0";
      hash = "sha256-NsTf3DR3gHVMYZDmTNvThB5bJcDwTcJ1+3eJhvsiDn8=";
    };
    meta.homepage = "https://github.com/winston0410/tree-sitter-hjson";
  };
  hlsl = buildGrammar {
    language = "hlsl";
    version = "0.0.0+rev=b309425";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-hlsl";
      rev = "b309425a7ab4456605cfe78774b80f7e275ca87d";
      hash = "sha256-o8y2jZUn15kLQ9k1rftxepeyRfx4dP6Vk2Vv4MUxcOQ=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-hlsl";
  };
  hlsplaylist = buildGrammar {
    language = "hlsplaylist";
    version = "0.0.0+rev=3bfda92";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-hlsplaylist";
      rev = "3bfda9271e3adb08d35f47a2102fe957009e1c55";
      hash = "sha256-BvLT+BbnJgM14a896p39dywYy/4S45xOBtBukYTbW6E=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-hlsplaylist";
  };
  hocon = buildGrammar {
    language = "hocon";
    version = "0.0.0+rev=c390f10";
    src = fetchFromGitHub {
      owner = "antosha417";
      repo = "tree-sitter-hocon";
      rev = "c390f10519ae69fdb03b3e5764f5592fb6924bcc";
      hash = "sha256-9Zo3YYoo9mJ4Buyj7ofSrlZURrwstBo0vgzeTq1jMGw=";
    };
    meta.homepage = "https://github.com/antosha417/tree-sitter-hocon";
  };
  hoon = buildGrammar {
    language = "hoon";
    version = "0.0.0+rev=a24c5a3";
    src = fetchFromGitHub {
      owner = "urbit-pilled";
      repo = "tree-sitter-hoon";
      rev = "a24c5a39d1d7e993a8bee913c8e8b6a652ca5ae8";
      hash = "sha256-jBKgZaZpm81ufN32sRNsCRtZhI5m057J+UY1uQdZK3E=";
    };
    meta.homepage = "https://github.com/urbit-pilled/tree-sitter-hoon";
  };
  html = buildGrammar {
    language = "html";
    version = "0.0.0+rev=d9219ad";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-html";
      rev = "d9219ada6e1a2c8f0ab0304a8bd9ca4285ae0468";
      hash = "sha256-0aLNG4eB2I0Qn0r1oF4YwUDLek78S5fbklFI/bMmxOQ=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-html";
  };
  htmldjango = buildGrammar {
    language = "htmldjango";
    version = "0.0.0+rev=ea71012";
    src = fetchFromGitHub {
      owner = "interdependence";
      repo = "tree-sitter-htmldjango";
      rev = "ea71012d3fe14dd0b69f36be4f96bdfe9155ebae";
      hash = "sha256-z4PqUbUXOtqOyPYl2h+bWA0maZJqZd5aZB75og+Ye6A=";
    };
    meta.homepage = "https://github.com/interdependence/tree-sitter-htmldjango";
  };
  http = buildGrammar {
    language = "http";
    version = "0.0.0+rev=231f1b1";
    src = fetchFromGitHub {
      owner = "rest-nvim";
      repo = "tree-sitter-http";
      rev = "231f1b1bafd12e46c8ed8c21dbbdd940d9f15e94";
      hash = "sha256-q8g7u3ctpfl0vq+RVBw7g7js/4SwAIkHg4CCRCuQ28w=";
    };
    meta.homepage = "https://github.com/rest-nvim/tree-sitter-http";
  };
  hurl = buildGrammar {
    language = "hurl";
    version = "0.0.0+rev=ff07a42";
    src = fetchFromGitHub {
      owner = "pfeiferj";
      repo = "tree-sitter-hurl";
      rev = "ff07a42d9ec95443b5c1b57ed793414bf7b79be5";
      hash = "sha256-9uRRlJWT0knZ3vvzGEq9CjyffQnYF53rnoBnsQ68zyE=";
    };
    meta.homepage = "https://github.com/pfeiferj/tree-sitter-hurl";
  };
  hyprlang = buildGrammar {
    language = "hyprlang";
    version = "0.0.0+rev=6858695";
    src = fetchFromGitHub {
      owner = "luckasRanarison";
      repo = "tree-sitter-hyprlang";
      rev = "6858695eba0e63b9e0fceef081d291eb352abce8";
      hash = "sha256-5csAj7k03QEEfkZE/EBmGjqUHPlFss3EWvExT4kaiQg=";
    };
    meta.homepage = "https://github.com/luckasRanarison/tree-sitter-hyprlang";
  };
  idl = buildGrammar {
    language = "idl";
    version = "0.0.0+rev=86ff7f1";
    src = fetchFromGitHub {
      owner = "cathaysia";
      repo = "tree-sitter-idl";
      rev = "86ff7f19747a761dc8ba72f4045fd64aed94ba4c";
      hash = "sha256-8al6Tn27T6gj4FnBODsORJ4UGm+1aJD6Y09GmWfoP6Y=";
    };
    meta.homepage = "https://github.com/cathaysia/tree-sitter-idl";
  };
  ini = buildGrammar {
    language = "ini";
    version = "0.0.0+rev=962568c";
    src = fetchFromGitHub {
      owner = "justinmk";
      repo = "tree-sitter-ini";
      rev = "962568c9efa71d25720ab42c5d36e222626ef3a6";
      hash = "sha256-G11Aynq2rnkRwdkhspjYqtBD/h5k4aD+NvuE0QfploU=";
    };
    meta.homepage = "https://github.com/justinmk/tree-sitter-ini";
  };
  inko = buildGrammar {
    language = "inko";
    version = "0.0.0+rev=aecabed";
    src = fetchFromGitHub {
      owner = "inko-lang";
      repo = "tree-sitter-inko";
      rev = "aecabede39b0db05678e2d4686258d4f71b00a51";
      hash = "sha256-29vt7zf/prmbjPBJoItzJz2sOp40ySqiqtwlaBobjoQ=";
    };
    meta.homepage = "https://github.com/inko-lang/tree-sitter-inko";
  };
  ispc = buildGrammar {
    language = "ispc";
    version = "0.0.0+rev=9b2f9ae";
    src = fetchFromGitHub {
      owner = "fab4100";
      repo = "tree-sitter-ispc";
      rev = "9b2f9aec2106b94b4e099fe75e73ebd8ae707c04";
      hash = "sha256-vxe+g7o0gXgB4GjhjkxqLqcLL2+8wqMB3tm1xQFSitI=";
    };
    meta.homepage = "https://github.com/fab4100/tree-sitter-ispc";
  };
  janet_simple = buildGrammar {
    language = "janet_simple";
    version = "0.0.0+rev=12bfab7";
    src = fetchFromGitHub {
      owner = "sogaiu";
      repo = "tree-sitter-janet-simple";
      rev = "12bfab7db8a5f5b1d774ef84b5831acd34936071";
      hash = "sha256-ndxhGmfz0wYxsOeBJv/OJndj3pORQoWpRTfBuMcprhU=";
    };
    meta.homepage = "https://github.com/sogaiu/tree-sitter-janet-simple";
  };
  java = buildGrammar {
    language = "java";
    version = "0.0.0+rev=a1bbe92";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-java";
      rev = "a1bbe92a6370bb4c15386735fbda12f2b812a923";
      hash = "sha256-AmGyKe7/zxzQTLSIQwiSuAJsYEcZVgW3RzfsRqyFNgE=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-java";
  };
  javascript = buildGrammar {
    language = "javascript";
    version = "0.0.0+rev=108b2d4";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-javascript";
      rev = "108b2d4d17a04356a340aea809e4dd5b801eb40d";
      hash = "sha256-0x6DbmRTlxUP4vbWVsLoj+k1YOk2Dr+LAPClFsWi7r8=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-javascript";
  };
  jq = buildGrammar {
    language = "jq";
    version = "0.0.0+rev=13990f5";
    src = fetchFromGitHub {
      owner = "flurie";
      repo = "tree-sitter-jq";
      rev = "13990f530e8e6709b7978503da9bc8701d366791";
      hash = "sha256-pek2Vg1osMYAdx6DfVdZhuIDb26op3i2cfvMrf5v3xY=";
    };
    meta.homepage = "https://github.com/flurie/tree-sitter-jq";
  };
  jsdoc = buildGrammar {
    language = "jsdoc";
    version = "0.0.0+rev=b253abf";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-jsdoc";
      rev = "b253abf68a73217b7a52c0ec254f4b6a7bb86665";
      hash = "sha256-Azzb2zBjAfwbEmAEO1YqhpaxtzbXmRjfIzRla2Hx+24=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-jsdoc";
  };
  json = buildGrammar {
    language = "json";
    version = "0.0.0+rev=ee35a6e";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-json";
      rev = "ee35a6ebefcef0c5c416c0d1ccec7370cfca5a24";
      hash = "sha256-DNZC2cTy1C8OaMOpEHM6NoRtOIbLaBf0CLXXWCKODlw=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-json";
  };
  json5 = buildGrammar {
    language = "json5";
    version = "0.0.0+rev=ab0ba82";
    src = fetchFromGitHub {
      owner = "Joakker";
      repo = "tree-sitter-json5";
      rev = "ab0ba8229d639ec4f3fa5f674c9133477f4b77bd";
      hash = "sha256-LaCCjvYnmofOVQ2Nqlzfh3KP3fNG0HBxkOng0gjYY1g=";
    };
    meta.homepage = "https://github.com/Joakker/tree-sitter-json5";
  };
  jsonc = buildGrammar {
    language = "jsonc";
    version = "0.0.0+rev=02b0165";
    src = fetchFromGitLab {
      owner = "WhyNotHugo";
      repo = "tree-sitter-jsonc";
      rev = "02b01653c8a1c198ae7287d566efa86a135b30d5";
      hash = "sha256-iWc2ePRiQnZ0FEdMAaAwa3iYt/SY0bEjQrZyqE9EhlU=";
    };
    meta.homepage = "https://gitlab.com/WhyNotHugo/tree-sitter-jsonc.git";
  };
  jsonnet = buildGrammar {
    language = "jsonnet";
    version = "0.0.0+rev=ddd075f";
    src = fetchFromGitHub {
      owner = "sourcegraph";
      repo = "tree-sitter-jsonnet";
      rev = "ddd075f1939aed8147b7aa67f042eda3fce22790";
      hash = "sha256-ODGRkirfUG8DqV6ZcGRjKeCyEtsU0r+ICK0kCG6Xza0=";
    };
    meta.homepage = "https://github.com/sourcegraph/tree-sitter-jsonnet";
  };
  julia = buildGrammar {
    language = "julia";
    version = "0.0.0+rev=a8e1262";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-julia";
      rev = "a8e1262997d5a45520a06cbe1b86c0737d507054";
      hash = "sha256-jwtMgHYSa9/kcsqyEUBrxC+U955zFZHVQ4N4iogiIHY=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-julia";
  };
  just = buildGrammar {
    language = "just";
    version = "0.0.0+rev=1014d2f";
    src = fetchFromGitHub {
      owner = "IndianBoy42";
      repo = "tree-sitter-just";
      rev = "1014d2fd6396856c312054d6c30df4d78b62966c";
      hash = "sha256-8vr55zhJOJxZhc8bXZpvO6a/eEYUJQ+HBWC4xRYbrgk=";
    };
    meta.homepage = "https://github.com/IndianBoy42/tree-sitter-just";
  };
  kconfig = buildGrammar {
    language = "kconfig";
    version = "0.0.0+rev=486fea7";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-kconfig";
      rev = "486fea71f61ad9f3fd4072a118402e97fe88d26c";
      hash = "sha256-a3uTjtA4KQ8KxEmpva2oHcqp8EwbI5+h9U+qoPSgDd4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-kconfig";
  };
  kdl = buildGrammar {
    language = "kdl";
    version = "0.0.0+rev=b37e3d5";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-kdl";
      rev = "b37e3d58e5c5cf8d739b315d6114e02d42e66664";
      hash = "sha256-irx8aMEdZG2WcQVE2c7ahwLjqEoUAOOjvhDDk69a6lE=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-kdl";
  };
  kotlin = buildGrammar {
    language = "kotlin";
    version = "0.0.0+rev=76f53c4";
    src = fetchFromGitHub {
      owner = "fwcd";
      repo = "tree-sitter-kotlin";
      rev = "76f53c48d29e8588934fb55b0240d7bdfe00bfe5";
      hash = "sha256-EBySJmzXH0FoWcslHNs70N9e9K9O/4/RcpbcdWYmgI4=";
    };
    meta.homepage = "https://github.com/fwcd/tree-sitter-kotlin";
  };
  koto = buildGrammar {
    language = "koto";
    version = "0.0.0+rev=0017388";
    src = fetchFromGitHub {
      owner = "koto-lang";
      repo = "tree-sitter-koto";
      rev = "0017388765b8b9d89febfe08b5f82805b4e173a5";
      hash = "sha256-L8IK4dvejZ1yfEkPGufkNArxm3hTStpk15HFNkSQdv0=";
    };
    meta.homepage = "https://github.com/koto-lang/tree-sitter-koto";
  };
  kusto = buildGrammar {
    language = "kusto";
    version = "0.0.0+rev=8353a12";
    src = fetchFromGitHub {
      owner = "Willem-J-an";
      repo = "tree-sitter-kusto";
      rev = "8353a1296607d6ba33db7c7e312226e5fc83e8ce";
      hash = "sha256-CZCvgOtHjCgyzKFdys+ZvSWCj1I1/b2MnaJcdAtm2aY=";
    };
    meta.homepage = "https://github.com/Willem-J-an/tree-sitter-kusto";
  };
  lalrpop = buildGrammar {
    language = "lalrpop";
    version = "0.0.0+rev=194c255";
    src = fetchFromGitHub {
      owner = "traxys";
      repo = "tree-sitter-lalrpop";
      rev = "194c25539f435de415ee0551a5f07058833da915";
      hash = "sha256-I2Kozd0N8R0CCOVl4xTAL4fhZ5BIzSzW+MRQOfZ3cMY=";
    };
    meta.homepage = "https://github.com/traxys/tree-sitter-lalrpop";
  };
  latex = buildGrammar {
    language = "latex";
    version = "0.0.0+rev=7b06f6e";
    src = fetchFromGitHub {
      owner = "latex-lsp";
      repo = "tree-sitter-latex";
      rev = "7b06f6ed394308e7407a1703d2724128c45fc9d7";
      hash = "sha256-HbRjblLBExpBkBBjHyEHfnK0oootjAsqkwjmGH3/UYI=";
    };
    generate = true;
    meta.homepage = "https://github.com/latex-lsp/tree-sitter-latex";
  };
  ledger = buildGrammar {
    language = "ledger";
    version = "0.0.0+rev=a2eff7f";
    src = fetchFromGitHub {
      owner = "cbarrete";
      repo = "tree-sitter-ledger";
      rev = "a2eff7fee59ee6adfc4a3646e2f41ba3b340a97d";
      hash = "sha256-7TM+Y2lDt53mxfeE5XepcdnoUtzv9FzH0klEEl4BOWU=";
    };
    meta.homepage = "https://github.com/cbarrete/tree-sitter-ledger";
  };
  leo = buildGrammar {
    language = "leo";
    version = "0.0.0+rev=6ca11a9";
    src = fetchFromGitHub {
      owner = "r001";
      repo = "tree-sitter-leo";
      rev = "6ca11a96fc2cab51217e0cf4a2f9ed3ea63e28fb";
      hash = "sha256-ye2zzLNZC2ZJqnXtBl7fdSC78kph3rs7j4whIdfDYAE=";
    };
    meta.homepage = "https://github.com/r001/tree-sitter-leo";
  };
  linkerscript = buildGrammar {
    language = "linkerscript";
    version = "0.0.0+rev=f99011a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-linkerscript";
      rev = "f99011a3554213b654985a4b0a65b3b032ec4621";
      hash = "sha256-Do8MIcl5DJo00V4wqIbdVC0to+2YYwfy08QWqSLMkQA=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-linkerscript";
  };
  liquid = buildGrammar {
    language = "liquid";
    version = "0.0.0+rev=23ac814";
    src = fetchFromGitHub {
      owner = "hankthetank27";
      repo = "tree-sitter-liquid";
      rev = "23ac814111e2b4b4b083e2c92219af2d5b74d13d";
      hash = "sha256-WZSvUiX1bKEfzXHVHC0AvzHpgyPD9JL+NgsoBx9mktQ=";
    };
    meta.homepage = "https://github.com/hankthetank27/tree-sitter-liquid";
  };
  liquidsoap = buildGrammar {
    language = "liquidsoap";
    version = "0.0.0+rev=14feafa";
    src = fetchFromGitHub {
      owner = "savonet";
      repo = "tree-sitter-liquidsoap";
      rev = "14feafa91630afb1ab9988cf9b738b7ea29f3f89";
      hash = "sha256-FERYGF9D163b6S/YBwHwkrUM2qRkEKOViSDRa61OjtQ=";
    };
    meta.homepage = "https://github.com/savonet/tree-sitter-liquidsoap";
  };
  llvm = buildGrammar {
    language = "llvm";
    version = "0.0.0+rev=c14cb83";
    src = fetchFromGitHub {
      owner = "benwilliamgraham";
      repo = "tree-sitter-llvm";
      rev = "c14cb839003348692158b845db9edda201374548";
      hash = "sha256-L3XwPhvwIR/mUbugMbaHS9dXyhO7bApv/gdlxQ+2Bbo=";
    };
    meta.homepage = "https://github.com/benwilliamgraham/tree-sitter-llvm";
  };
  lua = buildGrammar {
    language = "lua";
    version = "0.0.0+rev=34e60e7";
    src = fetchFromGitHub {
      owner = "MunifTanjim";
      repo = "tree-sitter-lua";
      rev = "34e60e7f45fc313463c68090d88d742a55d1bd7a";
      hash = "sha256-v+fFcIOv+bu+2IGI/Lh/Xbqd5BzbBjaa51ECd0hG7Ow=";
    };
    meta.homepage = "https://github.com/MunifTanjim/tree-sitter-lua";
  };
  luadoc = buildGrammar {
    language = "luadoc";
    version = "0.0.0+rev=873612a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luadoc";
      rev = "873612aadd3f684dd4e631bdf42ea8990c57634e";
      hash = "sha256-ttGBB9sn+xd9jWzjNAzpo/lwYVYZGSUGEip4K3PfBP0=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luadoc";
  };
  luap = buildGrammar {
    language = "luap";
    version = "0.0.0+rev=c134aae";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luap";
      rev = "c134aaec6acf4fa95fe4aa0dc9aba3eacdbbe55a";
      hash = "sha256-4mMUHBsdK4U4uhh8GpKlG3p/s3ZCcLX1qATPyTD4Xhg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luap";
  };
  luau = buildGrammar {
    language = "luau";
    version = "0.0.0+rev=fbadc96";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luau";
      rev = "fbadc96272f718dba267628ba7b0e694c368cef3";
      hash = "sha256-qoKLG9hPyvcpDEssSrsUnr+w6B8qvXXIXLdvoCZhjic=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luau";
  };
  m68k = buildGrammar {
    language = "m68k";
    version = "0.0.0+rev=e128454";
    src = fetchFromGitHub {
      owner = "grahambates";
      repo = "tree-sitter-m68k";
      rev = "e128454c2210c0e0c10b68fe45ddb8fee80182a3";
      hash = "sha256-g7SZ/TrTaaeGDNOqId4eom9R/5gOyXcmmhWY4WW0fF4=";
    };
    meta.homepage = "https://github.com/grahambates/tree-sitter-m68k";
  };
  make = buildGrammar {
    language = "make";
    version = "0.0.0+rev=a4b9187";
    src = fetchFromGitHub {
      owner = "alemuller";
      repo = "tree-sitter-make";
      rev = "a4b9187417d6be349ee5fd4b6e77b4172c6827dd";
      hash = "sha256-qQqapnKKH5X8rkxbZG5PjnyxvnpyZHpFVi/CLkIn/x0=";
    };
    meta.homepage = "https://github.com/alemuller/tree-sitter-make";
  };
  markdown = buildGrammar {
    language = "markdown";
    version = "0.0.0+rev=5cdc549";
    src = fetchFromGitHub {
      owner = "MDeiml";
      repo = "tree-sitter-markdown";
      rev = "5cdc549ab8f461aff876c5be9741027189299cec";
      hash = "sha256-dLj233xHPCJbawUVqkxxhHXbu/CrJIHcCyLXTgsWMFo=";
    };
    location = "tree-sitter-markdown";
    meta.homepage = "https://github.com/MDeiml/tree-sitter-markdown";
  };
  markdown_inline = buildGrammar {
    language = "markdown_inline";
    version = "0.0.0+rev=5cdc549";
    src = fetchFromGitHub {
      owner = "MDeiml";
      repo = "tree-sitter-markdown";
      rev = "5cdc549ab8f461aff876c5be9741027189299cec";
      hash = "sha256-dLj233xHPCJbawUVqkxxhHXbu/CrJIHcCyLXTgsWMFo=";
    };
    location = "tree-sitter-markdown-inline";
    meta.homepage = "https://github.com/MDeiml/tree-sitter-markdown";
  };
  matlab = buildGrammar {
    language = "matlab";
    version = "0.0.0+rev=306c43a";
    src = fetchFromGitHub {
      owner = "acristoffers";
      repo = "tree-sitter-matlab";
      rev = "306c43ab28b7b8a4976e40ff0a7c26b019ad52df";
      hash = "sha256-hueZg7hoZb11+ukrZgK1+da0w9J22jsj1BexlF4USXY=";
    };
    meta.homepage = "https://github.com/acristoffers/tree-sitter-matlab";
  };
  menhir = buildGrammar {
    language = "menhir";
    version = "0.0.0+rev=be8866a";
    src = fetchFromGitHub {
      owner = "Kerl13";
      repo = "tree-sitter-menhir";
      rev = "be8866a6bcc2b563ab0de895af69daeffa88fe70";
      hash = "sha256-CQVEQurf8Ur5xnz+g7e1nck0a32o4oeMOT78thjx8MQ=";
    };
    meta.homepage = "https://github.com/Kerl13/tree-sitter-menhir";
  };
  mermaid = buildGrammar {
    language = "mermaid";
    version = "0.0.0+rev=90ae195";
    src = fetchFromGitHub {
      owner = "monaqa";
      repo = "tree-sitter-mermaid";
      rev = "90ae195b31933ceb9d079abfa8a3ad0a36fee4cc";
      hash = "sha256-Tt1bPqpL59FQzuI8CPljBmQoAfJPUkVC9Xe1GcfXzfE=";
    };
    meta.homepage = "https://github.com/monaqa/tree-sitter-mermaid";
  };
  meson = buildGrammar {
    language = "meson";
    version = "0.0.0+rev=c5fffb8";
    src = fetchFromGitHub {
      owner = "Decodetalkers";
      repo = "tree-sitter-meson";
      rev = "c5fffb8edd39f22644084ab3f73a924a75721ee3";
      hash = "sha256-Q+5sCO+1CAbnaE7nq7vl/CxUpydxEHVtmPXIAUGJiOE=";
    };
    meta.homepage = "https://github.com/Decodetalkers/tree-sitter-meson";
  };
  mlir = buildGrammar {
    language = "mlir";
    version = "0.0.0+rev=5b8867f";
    src = fetchFromGitHub {
      owner = "artagnon";
      repo = "tree-sitter-mlir";
      rev = "5b8867f59954c9cae76f2aa1ac88ae513de412bd";
      hash = "sha256-gbqXyIGlj7XnafqlGUaG0iPHRBabcni3pJxlehO70jg=";
    };
    generate = true;
    meta.homepage = "https://github.com/artagnon/tree-sitter-mlir";
  };
  muttrc = buildGrammar {
    language = "muttrc";
    version = "0.0.0+rev=173b0ab";
    src = fetchFromGitHub {
      owner = "neomutt";
      repo = "tree-sitter-muttrc";
      rev = "173b0ab53a9c07962c9777189c4c70e90f1c1837";
      hash = "sha256-zma/oyMFI+r+/616yXV9b4ptC1FNYpHlpqY/Fez++n0=";
    };
    meta.homepage = "https://github.com/neomutt/tree-sitter-muttrc";
  };
  nasm = buildGrammar {
    language = "nasm";
    version = "0.0.0+rev=570f3d7";
    src = fetchFromGitHub {
      owner = "naclsn";
      repo = "tree-sitter-nasm";
      rev = "570f3d7be01fffc751237f4cfcf52d04e20532d1";
      hash = "sha256-205joaeq4ZSyfgxagPQTsx0zpZwSEpq1VCQoHJ77OL8=";
    };
    meta.homepage = "https://github.com/naclsn/tree-sitter-nasm";
  };
  nginx = buildGrammar {
    language = "nginx";
    version = "0.0.0+rev=281d184";
    src = fetchFromGitHub {
      owner = "opa-oz";
      repo = "tree-sitter-nginx";
      rev = "281d184b8240b2b22670b8907b57b6d6842db6f3";
      hash = "sha256-OsUCCtkaCwiKWKBduk9Ktc65LP1udKcKRmU4TAy8ayE=";
    };
    meta.homepage = "https://github.com/opa-oz/tree-sitter-nginx";
  };
  nickel = buildGrammar {
    language = "nickel";
    version = "0.0.0+rev=ddaa2bc";
    src = fetchFromGitHub {
      owner = "nickel-lang";
      repo = "tree-sitter-nickel";
      rev = "ddaa2bc22355effd97c0d6b09ff5962705c6368d";
      hash = "sha256-jL054OJj+1eXksNYOTTTFzZjwPqTFp06syC3TInN8rc=";
    };
    meta.homepage = "https://github.com/nickel-lang/tree-sitter-nickel";
  };
  nim = buildGrammar {
    language = "nim";
    version = "0.0.0+rev=897e5d3";
    src = fetchFromGitHub {
      owner = "alaviss";
      repo = "tree-sitter-nim";
      rev = "897e5d346f0b59ed62b517cfb0f1a845ad8f0ab7";
      hash = "sha256-JwR5Og1pGDTHI49rFsnfStrTcZ7hOseK6YyFIVlQ1o4=";
    };
    meta.homepage = "https://github.com/alaviss/tree-sitter-nim";
  };
  nim_format_string = buildGrammar {
    language = "nim_format_string";
    version = "0.0.0+rev=d45f750";
    src = fetchFromGitHub {
      owner = "aMOPel";
      repo = "tree-sitter-nim-format-string";
      rev = "d45f75022d147cda056e98bfba68222c9c8eca3a";
      hash = "sha256-hbM0JIxtZ3e2JUV4jXYO4RIO6r63nf2csvsLeIxkMn0=";
    };
    meta.homepage = "https://github.com/aMOPel/tree-sitter-nim-format-string";
  };
  ninja = buildGrammar {
    language = "ninja";
    version = "0.0.0+rev=0a95cfd";
    src = fetchFromGitHub {
      owner = "alemuller";
      repo = "tree-sitter-ninja";
      rev = "0a95cfdc0745b6ae82f60d3a339b37f19b7b9267";
      hash = "sha256-e/LpQUL3UHHko4QvMeT40LCvPZRT7xTGZ9z1Zaboru4=";
    };
    meta.homepage = "https://github.com/alemuller/tree-sitter-ninja";
  };
  nix = buildGrammar {
    language = "nix";
    version = "0.0.0+rev=0240bbf";
    src = fetchFromGitHub {
      owner = "cstrahan";
      repo = "tree-sitter-nix";
      rev = "0240bbfce72d155823c3b7edec622dedd580bf02";
      hash = "sha256-Z2h5YLdE6kGnYgX2QF3MQtOHC7sl/0ItJCucuXZRJCA=";
    };
    meta.homepage = "https://github.com/cstrahan/tree-sitter-nix";
  };
  norg = buildGrammar {
    language = "norg";
    version = "0.0.0+rev=d89d95a";
    src = fetchFromGitHub {
      owner = "nvim-neorg";
      repo = "tree-sitter-norg";
      rev = "d89d95af13d409f30a6c7676387bde311ec4a2c8";
      hash = "sha256-z3h5qMuNKnpQgV62xZ02F5vWEq4VEnm5lxwEnIFu+Rw=";
    };
    meta.homepage = "https://github.com/nvim-neorg/tree-sitter-norg";
  };
  nqc = buildGrammar {
    language = "nqc";
    version = "0.0.0+rev=14e6da1";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-nqc";
      rev = "14e6da1627aaef21d2b2aa0c37d04269766dcc1d";
      hash = "sha256-Gf6410cWLENCgI1uIBVBl4RnRuVCHkWkn6sxusmI6j4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-nqc";
  };
  nu = buildGrammar {
    language = "nu";
    version = "0.0.0+rev=7e0f16f";
    src = fetchFromGitHub {
      owner = "nushell";
      repo = "tree-sitter-nu";
      rev = "7e0f16f608a9e804fae61430ade734f9f849fb80";
      hash = "sha256-BXG1kc76mkAkV6BLuCzshb+MQ/AxRrhEKcY/1utxmH4=";
    };
    meta.homepage = "https://github.com/nushell/tree-sitter-nu";
  };
  objc = buildGrammar {
    language = "objc";
    version = "0.0.0+rev=62e61b6";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-objc";
      rev = "62e61b6f5c0289c376d61a8c91faf6435cde9012";
      hash = "sha256-Q1qAUgoYfpxmhn5XpnCwLBdu2BL2YF2We9bjumR8dNk=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-objc";
  };
  objdump = buildGrammar {
    language = "objdump";
    version = "0.0.0+rev=28d3b2e";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-objdump";
      rev = "28d3b2e25a0b1881d1b47ed1924ca276c7003d45";
      hash = "sha256-OPqIhgItghXplQ78Vlwd0G6KtDWTVkaG17RPqx1b5JY=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-objdump";
  };
  ocaml = buildGrammar {
    language = "ocaml";
    version = "0.0.0+rev=26bc61c";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ocaml";
      rev = "26bc61c206e7820f9f804b206f7765ffc55cd039";
      hash = "sha256-8pPgfvwp6h1tXo9fDwHtA7A8O6rjFzLb5eZfrkPxm+U=";
    };
    location = "grammars/ocaml";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ocaml";
  };
  ocaml_interface = buildGrammar {
    language = "ocaml_interface";
    version = "0.0.0+rev=26bc61c";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ocaml";
      rev = "26bc61c206e7820f9f804b206f7765ffc55cd039";
      hash = "sha256-8pPgfvwp6h1tXo9fDwHtA7A8O6rjFzLb5eZfrkPxm+U=";
    };
    location = "grammars/interface";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ocaml";
  };
  ocamllex = buildGrammar {
    language = "ocamllex";
    version = "0.0.0+rev=4b9898c";
    src = fetchFromGitHub {
      owner = "atom-ocaml";
      repo = "tree-sitter-ocamllex";
      rev = "4b9898ccbf198602bb0dec9cd67cc1d2c0a4fad2";
      hash = "sha256-YhmEE7I7UF83qMuldHqc/fD/no/7YuZd6CaAIaZ1now=";
    };
    generate = true;
    meta.homepage = "https://github.com/atom-ocaml/tree-sitter-ocamllex";
  };
  odin = buildGrammar {
    language = "odin";
    version = "0.0.0+rev=3fee796";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-odin";
      rev = "3fee7964bbfb2554deef12c224344f3870d15375";
      hash = "sha256-skMbtAjulJXGpaAfi1Q/WgeiimWE/qlwsWmq6lWXaU8=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-odin";
  };
  org = buildGrammar {
    language = "org";
    version = "0.0.0+rev=64cfbc2";
    src = fetchFromGitHub {
      owner = "milisims";
      repo = "tree-sitter-org";
      rev = "64cfbc213f5a83da17632c95382a5a0a2f3357c1";
      hash = "sha256-/03eZBbv23W5s/GbDgPgaJV5TyK+/lrWUVeINRS5wtA=";
    };
    meta.homepage = "https://github.com/milisims/tree-sitter-org";
  };
  pascal = buildGrammar {
    language = "pascal";
    version = "0.0.0+rev=d0ebabe";
    src = fetchFromGitHub {
      owner = "Isopod";
      repo = "tree-sitter-pascal";
      rev = "d0ebabefaea9ac3f6fc3004cf08cd121b66da9e4";
      hash = "sha256-T47xDjEbcDLg1IOu2HsIGA7j/CFMCagfV4xKdFYYoec=";
    };
    meta.homepage = "https://github.com/Isopod/tree-sitter-pascal";
  };
  passwd = buildGrammar {
    language = "passwd";
    version = "0.0.0+rev=2023939";
    src = fetchFromGitHub {
      owner = "ath3";
      repo = "tree-sitter-passwd";
      rev = "20239395eacdc2e0923a7e5683ad3605aee7b716";
      hash = "sha256-3UfuyJeblQBKjqZvLYyO3GoCvYJp+DvBwQGkR3pFQQ4=";
    };
    meta.homepage = "https://github.com/ath3/tree-sitter-passwd";
  };
  pem = buildGrammar {
    language = "pem";
    version = "0.0.0+rev=217ff2a";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-pem";
      rev = "217ff2af3f2db15a79ab7e3d21ea1e0c17e71a1a";
      hash = "sha256-KGJ9ulGi3gKUJxNXil5Zai4v5/5ImUSMVP3/19ra3A0=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-pem";
  };
  perl = buildGrammar {
    language = "perl";
    version = "0.0.0+rev=76ab9a5";
    src = fetchFromGitHub {
      owner = "tree-sitter-perl";
      repo = "tree-sitter-perl";
      rev = "76ab9a52b9dd2a1758aae3da8286519d995037e9";
      hash = "sha256-w45JH2sFLgnzk7ECfWTFvz2QIpkhFKxvZ/LiZT0HzzQ=";
    };
    meta.homepage = "https://github.com/tree-sitter-perl/tree-sitter-perl";
  };
  php = buildGrammar {
    language = "php";
    version = "0.0.0+rev=6918e69";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-php";
      rev = "6918e6908d78780ddd996b9fcbaa835b42782d5b";
      hash = "sha256-U9OQNyjTKQVMLeiB/tNNA2hl7wug4q/pK22X4QRskk0=";
    };
    location = "php";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-php";
  };
  php_only = buildGrammar {
    language = "php_only";
    version = "0.0.0+rev=6918e69";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-php";
      rev = "6918e6908d78780ddd996b9fcbaa835b42782d5b";
      hash = "sha256-U9OQNyjTKQVMLeiB/tNNA2hl7wug4q/pK22X4QRskk0=";
    };
    location = "php_only";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-php";
  };
  phpdoc = buildGrammar {
    language = "phpdoc";
    version = "0.0.0+rev=fe3202e";
    src = fetchFromGitHub {
      owner = "claytonrcarter";
      repo = "tree-sitter-phpdoc";
      rev = "fe3202e468bc17332bec8969f2b50ff1f1da3a46";
      hash = "sha256-sQ8jmVvZD0fIc9qlfyl6MaXvP/2ljzViKIl9RgVOJqw=";
    };
    meta.homepage = "https://github.com/claytonrcarter/tree-sitter-phpdoc";
  };
  pioasm = buildGrammar {
    language = "pioasm";
    version = "0.0.0+rev=afece58";
    src = fetchFromGitHub {
      owner = "leo60228";
      repo = "tree-sitter-pioasm";
      rev = "afece58efdb30440bddd151ef1347fa8d6f744a9";
      hash = "sha256-rUuolF/jPJGiqunD6SLUJ0x/MTIJ+mJ1QSBCasUw5T8=";
    };
    meta.homepage = "https://github.com/leo60228/tree-sitter-pioasm";
  };
  po = buildGrammar {
    language = "po";
    version = "0.0.0+rev=bd860a0";
    src = fetchFromGitHub {
      owner = "erasin";
      repo = "tree-sitter-po";
      rev = "bd860a0f57f697162bf28e576674be9c1500db5e";
      hash = "sha256-/St0VxDTAF872ZlBph1TukRoO0PBIOMT0D11DZ6nSLQ=";
    };
    meta.homepage = "https://github.com/erasin/tree-sitter-po";
  };
  pod = buildGrammar {
    language = "pod";
    version = "0.0.0+rev=0bf8387";
    src = fetchFromGitHub {
      owner = "tree-sitter-perl";
      repo = "tree-sitter-pod";
      rev = "0bf8387987c21bf2f8ed41d2575a8f22b139687f";
      hash = "sha256-yV2kVAxWxdyIJ3g2oivDc01SAQF0lc7UMT2sfv9lKzI=";
    };
    meta.homepage = "https://github.com/tree-sitter-perl/tree-sitter-pod";
  };
  poe_filter = buildGrammar {
    language = "poe_filter";
    version = "0.0.0+rev=592476d";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-poe-filter";
      rev = "592476d81f95d2451f2ca107dc872224c76fecdf";
      hash = "sha256-dmo/t8gCT7UTlhBvxH4xmliR3Evazv3qsz9EWz7h/gU=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-poe-filter";
  };
  pony = buildGrammar {
    language = "pony";
    version = "0.0.0+rev=73ff874";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-pony";
      rev = "73ff874ae4c9e9b45462673cbc0a1e350e2522a7";
      hash = "sha256-/9bTbep2AXLoiijeft9amMeFQ6fHXzItjH+bD/w6pDo=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-pony";
  };
  powershell = buildGrammar {
    language = "powershell";
    version = "0.0.0+rev=ebe2ab2";
    src = fetchFromGitHub {
      owner = "airbus-cert";
      repo = "tree-sitter-powershell";
      rev = "ebe2ab2f642eda2072c68c8de02e83973c26f33c";
      hash = "sha256-zWJUB0lbjJGGhi3ko4fSzay9n9P8nYhVOkKLrkyr0G0=";
    };
    meta.homepage = "https://github.com/airbus-cert/tree-sitter-powershell";
  };
  printf = buildGrammar {
    language = "printf";
    version = "0.0.0+rev=60d50a2";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-printf";
      rev = "60d50a2247b0c1fb72b967562c64711d65c6a060";
      hash = "sha256-Uf7HHHPIMpEFZdDF07tIwGeibxtzuDjLLFozKjawTEc=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-printf";
  };
  prisma = buildGrammar {
    language = "prisma";
    version = "0.0.0+rev=eca2596";
    src = fetchFromGitHub {
      owner = "victorhqc";
      repo = "tree-sitter-prisma";
      rev = "eca2596a355b1a9952b4f80f8f9caed300a272b5";
      hash = "sha256-MOqkM7DCQl1L8Jn9nyw89EoAr0ez4+d39HeKy2cb66c=";
    };
    meta.homepage = "https://github.com/victorhqc/tree-sitter-prisma";
  };
  problog = buildGrammar {
    language = "problog";
    version = "0.0.0+rev=93c69d2";
    src = fetchFromGitHub {
      owner = "foxyseta";
      repo = "tree-sitter-prolog";
      rev = "93c69d2f84d8a167c0a3f4a8d51ccefe365a4dc8";
      hash = "sha256-NWB4PvnVE+L1A7QDKcQtc15YIf8Ik7hKIOUW8XT/pFY=";
    };
    location = "grammars/problog";
    meta.homepage = "https://github.com/foxyseta/tree-sitter-prolog";
  };
  prolog = buildGrammar {
    language = "prolog";
    version = "0.0.0+rev=93c69d2";
    src = fetchFromGitHub {
      owner = "foxyseta";
      repo = "tree-sitter-prolog";
      rev = "93c69d2f84d8a167c0a3f4a8d51ccefe365a4dc8";
      hash = "sha256-NWB4PvnVE+L1A7QDKcQtc15YIf8Ik7hKIOUW8XT/pFY=";
    };
    location = "grammars/prolog";
    meta.homepage = "https://github.com/foxyseta/tree-sitter-prolog";
  };
  promql = buildGrammar {
    language = "promql";
    version = "0.0.0+rev=77625d7";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-promql";
      rev = "77625d78eebc3ffc44d114a07b2f348dff3061b0";
      hash = "sha256-IJbnC03pDfcSAF//Ux+LqqfjtagGSD5Nu46yUo0vT5Q=";
    };
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-promql";
  };
  properties = buildGrammar {
    language = "properties";
    version = "0.0.0+rev=f93f673";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-properties";
      rev = "f93f673990deffbfa548826eebade93af81887b4";
      hash = "sha256-XATT9i8lYcdTDtNHChtbUux9E6pg7jFPKnWR6tMEBew=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-properties";
  };
  proto = buildGrammar {
    language = "proto";
    version = "0.0.0+rev=e9f6b43";
    src = fetchFromGitHub {
      owner = "treywood";
      repo = "tree-sitter-proto";
      rev = "e9f6b43f6844bd2189b50a422d4e2094313f6aa3";
      hash = "sha256-Ue6w6HWy+NTJt+AKTFfJIUf3HXHTwkUkDk4UdDMSD+U=";
    };
    meta.homepage = "https://github.com/treywood/tree-sitter-proto";
  };
  prql = buildGrammar {
    language = "prql";
    version = "0.0.0+rev=09e158c";
    src = fetchFromGitHub {
      owner = "PRQL";
      repo = "tree-sitter-prql";
      rev = "09e158cd3650581c0af4c49c2e5b10c4834c8646";
      hash = "sha256-bdT7LZ2x7BdUqLJRq4ENJTaIFnciac7l2dCxOSB09CI=";
    };
    meta.homepage = "https://github.com/PRQL/tree-sitter-prql";
  };
  psv = buildGrammar {
    language = "psv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "psv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  pug = buildGrammar {
    language = "pug";
    version = "0.0.0+rev=a7ff31a";
    src = fetchFromGitHub {
      owner = "zealot128";
      repo = "tree-sitter-pug";
      rev = "a7ff31a38908df9b9f34828d21d6ca5e12413e18";
      hash = "sha256-WDx2Y1LxuJJuAaeTxfqQrxRXxVd4Cn3niQeherh+5Uc=";
    };
    meta.homepage = "https://github.com/zealot128/tree-sitter-pug";
  };
  puppet = buildGrammar {
    language = "puppet";
    version = "0.0.0+rev=584522f";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-puppet";
      rev = "584522f32495d648b18a53ccb52d988e60de127d";
      hash = "sha256-+zMgzyuGerJ8l+i5ZtWnmGr3i4fFiSLD5FssyKESsmI=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-puppet";
  };
  purescript = buildGrammar {
    language = "purescript";
    version = "0.0.0+rev=daf9b3e";
    src = fetchFromGitHub {
      owner = "postsolar";
      repo = "tree-sitter-purescript";
      rev = "daf9b3e2be18b0b2996a1281f7783e0d041d8b80";
      hash = "sha256-eY2WF2n0fZUl1zxZZHJVYR8b1FwaAjkCeSeOdSf67m4=";
    };
    meta.homepage = "https://github.com/postsolar/tree-sitter-purescript";
  };
  pymanifest = buildGrammar {
    language = "pymanifest";
    version = "0.0.0+rev=be06258";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-pymanifest";
      rev = "be062582956165019d3253794b4d712f66dfeaaa";
      hash = "sha256-Kud/E67Sh9F4nc8nzW5UXFHW5+kGftLyFzwLOKLcpL8=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-pymanifest";
  };
  python = buildGrammar {
    language = "python";
    version = "0.0.0+rev=6d14e44";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-python";
      rev = "6d14e44ea217bc5bb1c1804180e9818d7d1b8d91";
      hash = "sha256-/jYGi2yksifMGPitlS8oM/g3YrR7RJ57imBhEyow/jc=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-python";
  };
  ql = buildGrammar {
    language = "ql";
    version = "0.0.0+rev=1fd627a";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ql";
      rev = "1fd627a4e8bff8c24c11987474bd33112bead857";
      hash = "sha256-mJ/bj09mT1WTaiKoXiRXDM7dkenf5hv2ArXieeTVe6I=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ql";
  };
  qmldir = buildGrammar {
    language = "qmldir";
    version = "0.0.0+rev=6b2b5e4";
    src = fetchFromGitHub {
      owner = "Decodetalkers";
      repo = "tree-sitter-qmldir";
      rev = "6b2b5e41734bd6f07ea4c36ac20fb6f14061c841";
      hash = "sha256-7ic9Xd+1G0JM25bY0f8N5r6YZx5NV5HrJXXHp6pXvo4=";
    };
    meta.homepage = "https://github.com/Decodetalkers/tree-sitter-qmldir";
  };
  qmljs = buildGrammar {
    language = "qmljs";
    version = "0.0.0+rev=6d4db24";
    src = fetchFromGitHub {
      owner = "yuja";
      repo = "tree-sitter-qmljs";
      rev = "6d4db242185721e1f5ef21fde613ca90c743ec47";
      hash = "sha256-S6rBQRecJvPgyWq1iydFZgDyXbm9CZBw8kxzNI0cqdw=";
    };
    meta.homepage = "https://github.com/yuja/tree-sitter-qmljs";
  };
  query = buildGrammar {
    language = "query";
    version = "0.0.0+rev=a6674e2";
    src = fetchFromGitHub {
      owner = "nvim-treesitter";
      repo = "tree-sitter-query";
      rev = "a6674e279b14958625d7a530cabe06119c7a1532";
      hash = "sha256-xtr2IVI+3h/u9f84ye7szHR/U2E8Bm5NN7vhqaCkiyI=";
    };
    meta.homepage = "https://github.com/nvim-treesitter/tree-sitter-query";
  };
  r = buildGrammar {
    language = "r";
    version = "0.0.0+rev=2097fa5";
    src = fetchFromGitHub {
      owner = "r-lib";
      repo = "tree-sitter-r";
      rev = "2097fa502efa21349d26af0ffee55d773015e481";
      hash = "sha256-a7vgmOY9K8w8vwMlOLBmUnXpWpVP+YlOilGODaI07y4=";
    };
    meta.homepage = "https://github.com/r-lib/tree-sitter-r";
  };
  racket = buildGrammar {
    language = "racket";
    version = "0.0.0+rev=5b211bf";
    src = fetchFromGitHub {
      owner = "6cdh";
      repo = "tree-sitter-racket";
      rev = "5b211bf93021d1c45f39aa96898be9f794f087e4";
      hash = "sha256-ry9j5nEcXiSD+xJYzT0mY37hGeDlVRYq7egUeuw1PfU=";
    };
    meta.homepage = "https://github.com/6cdh/tree-sitter-racket";
  };
  ralph = buildGrammar {
    language = "ralph";
    version = "0.0.0+rev=f6d81bf";
    src = fetchFromGitHub {
      owner = "alephium";
      repo = "tree-sitter-ralph";
      rev = "f6d81bf7a4599c77388035439cf5801cd461ff77";
      hash = "sha256-o+h43yMws4utPjqEQCt5swks3KfM3hb4mguclALsUsA=";
    };
    meta.homepage = "https://github.com/alephium/tree-sitter-ralph";
  };
  rasi = buildGrammar {
    language = "rasi";
    version = "0.0.0+rev=6c9bbcf";
    src = fetchFromGitHub {
      owner = "Fymyte";
      repo = "tree-sitter-rasi";
      rev = "6c9bbcfdf5f0f553d9ebc01750a3aa247a37b8aa";
      hash = "sha256-sPrIVgGGaBaXeqHNxjcdJ/S2FvxyV6rD9UPKU/tpspw=";
    };
    meta.homepage = "https://github.com/Fymyte/tree-sitter-rasi";
  };
  rbs = buildGrammar {
    language = "rbs";
    version = "0.0.0+rev=8d8e65a";
    src = fetchFromGitHub {
      owner = "joker1007";
      repo = "tree-sitter-rbs";
      rev = "8d8e65ac3f77fbc9e15b1cdb9f980a3e0ac3ab99";
      hash = "sha256-M72rShapD813gpBbWUIil6UgcnoF1DVTffMSnTpejgg=";
    };
    meta.homepage = "https://github.com/joker1007/tree-sitter-rbs";
  };
  re2c = buildGrammar {
    language = "re2c";
    version = "0.0.0+rev=c18a3c2";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-re2c";
      rev = "c18a3c2f4b6665e35b7e50d6048ea3cff770c572";
      hash = "sha256-2htX4730fNAO2NKEurDOXH1OIXFd0OfuIbH1ou3a20A=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-re2c";
  };
  readline = buildGrammar {
    language = "readline";
    version = "0.0.0+rev=74addc9";
    src = fetchFromGitHub {
      owner = "ribru17";
      repo = "tree-sitter-readline";
      rev = "74addc90fc539d31d413c0c7cf7581997a7fa46e";
      hash = "sha256-cbQnAPtgMnA41CTI9OyY8WYvdlJOC9g0ZMbitNSvtmI=";
    };
    meta.homepage = "https://github.com/ribru17/tree-sitter-readline";
  };
  regex = buildGrammar {
    language = "regex";
    version = "0.0.0+rev=4470c59";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-regex";
      rev = "4470c59041416e8a2a9fa343595ca28ed91f38b8";
      hash = "sha256-GNWntm8sgqVt6a+yFVncjkoMOe7CnXX9Qmpwy6KcFyU=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-regex";
  };
  rego = buildGrammar {
    language = "rego";
    version = "0.0.0+rev=20b5a59";
    src = fetchFromGitHub {
      owner = "FallenAngel97";
      repo = "tree-sitter-rego";
      rev = "20b5a5958c837bc9f74b231022a68a594a313f6d";
      hash = "sha256-XwlVsOlxYzB0x+T05iuIp7nFAoQkMByKiHXZ0t5QsjI=";
    };
    meta.homepage = "https://github.com/FallenAngel97/tree-sitter-rego";
  };
  requirements = buildGrammar {
    language = "requirements";
    version = "0.0.0+rev=5ad9b75";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-requirements";
      rev = "5ad9b7581b3334f6ad492847d007f2fac6e6e5f2";
      hash = "sha256-L3PF6B+d+v/pjAQGVwkc7hCKrhbAB7u/BdXOpEum08w=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-requirements";
  };
  rescript = buildGrammar {
    language = "rescript";
    version = "0.0.0+rev=4606cd8";
    src = fetchFromGitHub {
      owner = "rescript-lang";
      repo = "tree-sitter-rescript";
      rev = "4606cd81c4c31d1d02390fee530858323410a74c";
      hash = "sha256-md3fgW+h99va2Rwxzub7nrsEe64fC52g6NPCaXGAaxg=";
    };
    meta.homepage = "https://github.com/rescript-lang/tree-sitter-rescript";
  };
  rnoweb = buildGrammar {
    language = "rnoweb";
    version = "0.0.0+rev=1a74dc0";
    src = fetchFromGitHub {
      owner = "bamonroe";
      repo = "tree-sitter-rnoweb";
      rev = "1a74dc0ed731ad07db39f063e2c5a6fe528cae7f";
      hash = "sha256-sCjSS6iunij2SXHNzQcTq0HKawH9i5h/vQ6yl77opXw=";
    };
    meta.homepage = "https://github.com/bamonroe/tree-sitter-rnoweb";
  };
  robot = buildGrammar {
    language = "robot";
    version = "0.0.0+rev=322e4cc";
    src = fetchFromGitHub {
      owner = "Hubro";
      repo = "tree-sitter-robot";
      rev = "322e4cc65754d2b3fdef4f2f8a71e0762e3d13af";
      hash = "sha256-VxWZWFPYkD3odM3TpEgLKsFnN8wB6xoIiXUYqBbpDqw=";
    };
    meta.homepage = "https://github.com/Hubro/tree-sitter-robot";
  };
  robots = buildGrammar {
    language = "robots";
    version = "0.0.0+rev=8e3a420";
    src = fetchFromGitHub {
      owner = "opa-oz";
      repo = "tree-sitter-robots-txt";
      rev = "8e3a4205b76236bb6dbebdbee5afc262ce38bb62";
      hash = "sha256-OePLE85CWbl0hnre4Apq5Ix2GA8juGV2TE891Py4AME=";
    };
    meta.homepage = "https://github.com/opa-oz/tree-sitter-robots-txt";
  };
  roc = buildGrammar {
    language = "roc";
    version = "0.0.0+rev=ef46edd";
    src = fetchFromGitHub {
      owner = "faldor20";
      repo = "tree-sitter-roc";
      rev = "ef46edd0c03ea30a22f7e92bc68628fb7231dc8a";
      hash = "sha256-H76cnMlBT1Z/9WXAdoVslImkyy38uCqum9qEnH+Ics8=";
    };
    meta.homepage = "https://github.com/faldor20/tree-sitter-roc";
  };
  ron = buildGrammar {
    language = "ron";
    version = "0.0.0+rev=7893855";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-ron";
      rev = "78938553b93075e638035f624973083451b29055";
      hash = "sha256-Sp0g6AWKHNjyUmL5k3RIU+5KtfICfg3o/DH77XRRyI0=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-ron";
  };
  rst = buildGrammar {
    language = "rst";
    version = "0.0.0+rev=5120f6e";
    src = fetchFromGitHub {
      owner = "stsewd";
      repo = "tree-sitter-rst";
      rev = "5120f6e59284cb8b85b450bd2db0bd352635ba9f";
      hash = "sha256-PI1C0W8fiuIQ2fgHXDelkCa0ng1a32x/9hrA33KoefM=";
    };
    meta.homepage = "https://github.com/stsewd/tree-sitter-rst";
  };
  ruby = buildGrammar {
    language = "ruby";
    version = "0.0.0+rev=71bd32f";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ruby";
      rev = "71bd32fb7607035768799732addba884a37a6210";
      hash = "sha256-iu3MVJl0Qr/Ba+aOttmEzMiVY6EouGi5wGOx5ofROzA=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ruby";
  };
  runescript = buildGrammar {
    language = "runescript";
    version = "0.0.0+rev=cf85bbd";
    src = fetchFromGitHub {
      owner = "2004Scape";
      repo = "tree-sitter-runescript";
      rev = "cf85bbd5da0c5ad243301d889c7f84d790a4cae4";
      hash = "sha256-LRHTy5XMU2FOru7YrFlwuDU7brtnI/8RhAdQnY7Fkpk=";
    };
    meta.homepage = "https://github.com/2004Scape/tree-sitter-runescript";
  };
  rust = buildGrammar {
    language = "rust";
    version = "0.0.0+rev=32c17ce";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-rust";
      rev = "32c17ce5463818032a9c252a849b910315b6e485";
      hash = "sha256-ThsMUVCql0Z9ztMQDeLXR7gTWYY+uMGWuPvr3P8A/Hk=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-rust";
  };
  scala = buildGrammar {
    language = "scala";
    version = "0.0.0+rev=28c3be0";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-scala";
      rev = "28c3be045afe1e293b5ba1a74e759601e74050c3";
      hash = "sha256-xJeimj4OJ2Fdqu2rA+FnCVvBo56qC9vreo7EOY4w3kc=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-scala";
  };
  scfg = buildGrammar {
    language = "scfg";
    version = "0.0.0+rev=a551280";
    src = fetchFromGitHub {
      owner = "rockorager";
      repo = "tree-sitter-scfg";
      rev = "a5512800ea0220da4abbae61b8aea8423d1549aa";
      hash = "sha256-Je6taNzniyd1c+2NRCF7TOvnpeW4qhYYhdAEcgpDOAA=";
    };
    generate = true;
    meta.homepage = "https://github.com/rockorager/tree-sitter-scfg";
  };
  scheme = buildGrammar {
    language = "scheme";
    version = "0.0.0+rev=63e25a4";
    src = fetchFromGitHub {
      owner = "6cdh";
      repo = "tree-sitter-scheme";
      rev = "63e25a4a84142ae7ee0ee01fe3a32c985ca16745";
      hash = "sha256-FK3F7v2LqAtXZM/CKCijWfXTF6TUhLmiVXScZqt46Io=";
    };
    meta.homepage = "https://github.com/6cdh/tree-sitter-scheme";
  };
  scss = buildGrammar {
    language = "scss";
    version = "0.0.0+rev=c478c68";
    src = fetchFromGitHub {
      owner = "serenadeai";
      repo = "tree-sitter-scss";
      rev = "c478c6868648eff49eb04a4df90d703dc45b312a";
      hash = "sha256-BFtMT6eccBWUyq6b8UXRAbB1R1XD3CrrFf1DM3aUI5c=";
    };
    meta.homepage = "https://github.com/serenadeai/tree-sitter-scss";
  };
  sflog = buildGrammar {
    language = "sflog";
    version = "0.0.0+rev=46d4a12";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "46d4a12e4e90b10a575b7b16ea3b6ead50322074";
      hash = "sha256-vPSdx//9PZXDV9wzkMobaSVl88+iVGi/E+t7EA2yyCY=";
    };
    location = "sflog";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  slang = buildGrammar {
    language = "slang";
    version = "0.0.0+rev=3ed23c0";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-slang";
      rev = "3ed23c04a412a0559162d9cadf96dfff7cb36079";
      hash = "sha256-X/QoG1Gl9zDzA3++FznypgeBuWElMaN4BFFuBKPXohk=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-slang";
  };
  slint = buildGrammar {
    language = "slint";
    version = "0.0.0+rev=4e2765d";
    src = fetchFromGitHub {
      owner = "slint-ui";
      repo = "tree-sitter-slint";
      rev = "4e2765d4cac1f03ada6f635eeb6008d1d0aff5a3";
      hash = "sha256-cEitYvrK9P5McbqQAH/PmbD5W0pYULwj3eP9lKXSOTE=";
    };
    meta.homepage = "https://github.com/slint-ui/tree-sitter-slint";
  };
  smali = buildGrammar {
    language = "smali";
    version = "0.0.0+rev=fdfa6a1";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-smali";
      rev = "fdfa6a1febc43c7467aa7e937b87b607956f2346";
      hash = "sha256-S0U6Xuntz16DrpYwSqMQu8Cu7UuD/JufHUxIHv826yw=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-smali";
  };
  smithy = buildGrammar {
    language = "smithy";
    version = "0.0.0+rev=fa898ac";
    src = fetchFromGitHub {
      owner = "indoorvivants";
      repo = "tree-sitter-smithy";
      rev = "fa898ac0885d1da9a253695c3e0e91f5efc587cd";
      hash = "sha256-tB+q4RNru4Zi3jU9fBLKdzsXT0uP1PECLfeCCNTyaIo=";
    };
    meta.homepage = "https://github.com/indoorvivants/tree-sitter-smithy";
  };
  snakemake = buildGrammar {
    language = "snakemake";
    version = "0.0.0+rev=e909815";
    src = fetchFromGitHub {
      owner = "osthomas";
      repo = "tree-sitter-snakemake";
      rev = "e909815acdbe37e69440261ebb1091ed52e1dec6";
      hash = "sha256-d2n1fsdt4+1hv4In+o6GpGyfeyVHpn39Njm7tQ2zyYQ=";
    };
    meta.homepage = "https://github.com/osthomas/tree-sitter-snakemake";
  };
  solidity = buildGrammar {
    language = "solidity";
    version = "0.0.0+rev=ee5a2d2";
    src = fetchFromGitHub {
      owner = "JoranHonig";
      repo = "tree-sitter-solidity";
      rev = "ee5a2d2ba30b487c4bbf613d2ef310a454c09c7c";
      hash = "sha256-q9SFHnxBUDet65WuxxYFS3N8xDHuQz7K2LWED7uSaWA=";
    };
    meta.homepage = "https://github.com/JoranHonig/tree-sitter-solidity";
  };
  soql = buildGrammar {
    language = "soql";
    version = "0.0.0+rev=46d4a12";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "46d4a12e4e90b10a575b7b16ea3b6ead50322074";
      hash = "sha256-vPSdx//9PZXDV9wzkMobaSVl88+iVGi/E+t7EA2yyCY=";
    };
    location = "soql";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  sosl = buildGrammar {
    language = "sosl";
    version = "0.0.0+rev=46d4a12";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "46d4a12e4e90b10a575b7b16ea3b6ead50322074";
      hash = "sha256-vPSdx//9PZXDV9wzkMobaSVl88+iVGi/E+t7EA2yyCY=";
    };
    location = "sosl";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  sourcepawn = buildGrammar {
    language = "sourcepawn";
    version = "0.0.0+rev=6b9bf9c";
    src = fetchFromGitHub {
      owner = "nilshelmig";
      repo = "tree-sitter-sourcepawn";
      rev = "6b9bf9cbab91443380d2ca8a2f6c491cc7fac5bf";
      hash = "sha256-2DjGCZ701c2rMxQZM4YF61rZokZUov4ECb0gwAmyuVk=";
    };
    meta.homepage = "https://github.com/nilshelmig/tree-sitter-sourcepawn";
  };
  sparql = buildGrammar {
    language = "sparql";
    version = "0.0.0+rev=d853661";
    src = fetchFromGitHub {
      owner = "GordianDziwis";
      repo = "tree-sitter-sparql";
      rev = "d853661ca680d8ff7f8d800182d5782b61d0dd58";
      hash = "sha256-0BV0y8IyeIPpuxTixlJL1PsDCuhXbGaImu8JU8WFoPU=";
    };
    meta.homepage = "https://github.com/GordianDziwis/tree-sitter-sparql";
  };
  sql = buildGrammar {
    language = "sql";
    version = "0.0.0+rev=f551a8f";
    src = fetchFromGitHub {
      owner = "derekstride";
      repo = "tree-sitter-sql";
      rev = "f551a8fa69dc9aea479b93fae34c3ea7be15f931";
      hash = "sha256-U+PnjYITbHOT+EtoF0lI8LNhcc811ZEqFjRTsSMtprA=";
    };
    meta.homepage = "https://github.com/derekstride/tree-sitter-sql";
  };
  squirrel = buildGrammar {
    language = "squirrel";
    version = "0.0.0+rev=072c969";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-squirrel";
      rev = "072c969749e66f000dba35a33c387650e203e96e";
      hash = "sha256-tJBmxTD4hi9zxXMEuAX+uslo45zEawh09+tgv56s/AU=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-squirrel";
  };
  ssh_config = buildGrammar {
    language = "ssh_config";
    version = "0.0.0+rev=dd32616";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-ssh-config";
      rev = "dd32616275c6e9d7800c58f40c16a09ad1c7c238";
      hash = "sha256-BOvCOnt76f00+hqjEmJ8VLiwqSPd3p/yScTXsuNdexY=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-ssh-config";
  };
  starlark = buildGrammar {
    language = "starlark";
    version = "0.0.0+rev=018d0e0";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-starlark";
      rev = "018d0e09d9d0f0dd6740a37682b8ee4512e8b2ac";
      hash = "sha256-Qp7FvREjO+FP7ovj6UE8JA3Se8W46iGxNrmmSsruOdA=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-starlark";
  };
  strace = buildGrammar {
    language = "strace";
    version = "0.0.0+rev=d819cdd";
    src = fetchFromGitHub {
      owner = "sigmaSd";
      repo = "tree-sitter-strace";
      rev = "d819cdd5dbe455bd3c859193633c8d91c0df7c36";
      hash = "sha256-u2LznohljEq7WEoVbwr1ZyV+qbchDuoktJFCeh4iePg=";
    };
    meta.homepage = "https://github.com/sigmaSd/tree-sitter-strace";
  };
  styled = buildGrammar {
    language = "styled";
    version = "0.0.0+rev=2e0e623";
    src = fetchFromGitHub {
      owner = "mskelton";
      repo = "tree-sitter-styled";
      rev = "2e0e6231348d8cb0a82406490771825b8ac80422";
      hash = "sha256-RwhHCWK1ckXdPgIVZ4NC5zCBna91NBYub2MlrIwHeGk=";
    };
    meta.homepage = "https://github.com/mskelton/tree-sitter-styled";
  };
  supercollider = buildGrammar {
    language = "supercollider";
    version = "0.0.0+rev=1a8ee0d";
    src = fetchFromGitHub {
      owner = "madskjeldgaard";
      repo = "tree-sitter-supercollider";
      rev = "1a8ee0da9a4f2df5a8a22f4d637ac863623a78a7";
      hash = "sha256-G23AZO1zvTvRE9ciV7qMuSoaCYulhyOkwiRwgK06NRQ=";
    };
    meta.homepage = "https://github.com/madskjeldgaard/tree-sitter-supercollider";
  };
  superhtml = buildGrammar {
    language = "superhtml";
    version = "0.0.0+rev=dbb0d1f";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "superhtml";
      rev = "dbb0d1fc54f8525f41289a413ea6c0722e92bf9c";
      hash = "sha256-c0JjQ3RZyKtP4ayDT9M+riYhK6JlMF/oVJfkfY17/7k=";
    };
    location = "tree-sitter-superhtml";
    meta.homepage = "https://github.com/kristoff-it/superhtml";
  };
  surface = buildGrammar {
    language = "surface";
    version = "0.0.0+rev=f4586b3";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-surface";
      rev = "f4586b35ac8548667a9aaa4eae44456c1f43d032";
      hash = "sha256-Fn/pF8yvU+Ll7WmoMHnEcNxb3dsfNhuKhXA1UgXeviA=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-surface";
  };
  svelte = buildGrammar {
    language = "svelte";
    version = "0.0.0+rev=ae5199d";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-svelte";
      rev = "ae5199db47757f785e43a14b332118a5474de1a2";
      hash = "sha256-cH9h7i6MImw7KlcuVQ6XVKNjd9dFjo93J1JdTWmEpV4=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-svelte";
  };
  sway = buildGrammar {
    language = "sway";
    version = "0.0.0+rev=3950067";
    src = fetchFromGitHub {
      owner = "FuelLabs";
      repo = "tree-sitter-sway";
      rev = "395006713db3bbb90d267ebdfcbf1881b399b05c";
      hash = "sha256-5Js5WbpQAln6cfdjEd0emMtkC6uFGWA2LXQZkiXbap4=";
    };
    meta.homepage = "https://github.com/FuelLabs/tree-sitter-sway.git";
  };
  swift = buildGrammar {
    language = "swift";
    version = "0.0.0+rev=6accc2f";
    src = fetchFromGitHub {
      owner = "alex-pinkus";
      repo = "tree-sitter-swift";
      rev = "6accc2f720c7ff8573f6956a34ea22f50c44d839";
      hash = "sha256-SFzOo7Nx7kjQ69KUIH9raGj4zYYI0HPeagECAZJGfww=";
    };
    generate = true;
    meta.homepage = "https://github.com/alex-pinkus/tree-sitter-swift";
  };
  sxhkdrc = buildGrammar {
    language = "sxhkdrc";
    version = "0.0.0+rev=440d5f9";
    src = fetchFromGitHub {
      owner = "RaafatTurki";
      repo = "tree-sitter-sxhkdrc";
      rev = "440d5f913d9465c9c776a1bd92334d32febcf065";
      hash = "sha256-AGhGYomrMe6Wj+EHLQT4v0BiU4jxhxXpVQkU2xU/1ZI=";
    };
    meta.homepage = "https://github.com/RaafatTurki/tree-sitter-sxhkdrc";
  };
  systemtap = buildGrammar {
    language = "systemtap";
    version = "0.0.0+rev=f2b378a";
    src = fetchFromGitHub {
      owner = "ok-ryoko";
      repo = "tree-sitter-systemtap";
      rev = "f2b378a9af0b7e1192cff67a5fb45508c927205d";
      hash = "sha256-HzV6RZMTSa41Q5hMiM1FwiHLbho62fuywtKzqrwjNDQ=";
    };
    meta.homepage = "https://github.com/ok-ryoko/tree-sitter-systemtap";
  };
  t32 = buildGrammar {
    language = "t32";
    version = "0.0.0+rev=476f0d8";
    src = fetchFromGitLab {
      owner = "xasc";
      repo = "tree-sitter-t32";
      rev = "476f0d8ab4b012d3b6f9598890217ada70f1a8ba";
      hash = "sha256-zyMThhLjjiL/wtz5DGmjbfGTfcIj4JNSVCKfBIEw/0w=";
    };
    meta.homepage = "https://gitlab.com/xasc/tree-sitter-t32.git";
  };
  tablegen = buildGrammar {
    language = "tablegen";
    version = "0.0.0+rev=b117088";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-tablegen";
      rev = "b1170880c61355aaf38fc06f4af7d3c55abdabc4";
      hash = "sha256-uJCn2RdTnOf/guBUhfodgQ8pMshNh+xUJZunoLwNgrM=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-tablegen";
  };
  tact = buildGrammar {
    language = "tact";
    version = "0.0.0+rev=83e2649";
    src = fetchFromGitHub {
      owner = "tact-lang";
      repo = "tree-sitter-tact";
      rev = "83e264928fa194b7283428527259e88e54205264";
      hash = "sha256-gSLVUjn8MBRDQhZoEsPGao2lZI1gcxJsg6d8suA4D50=";
    };
    meta.homepage = "https://github.com/tact-lang/tree-sitter-tact";
  };
  tcl = buildGrammar {
    language = "tcl";
    version = "0.0.0+rev=98015eb";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-tcl";
      rev = "98015ebe182d94e5a4439e32ffd91beaac32fcb9";
      hash = "sha256-zpswRch3xYjymQhc69noDTCsPrFzVRm1RN3jjIrUeDE=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-tcl";
  };
  teal = buildGrammar {
    language = "teal";
    version = "0.0.0+rev=485fbdc";
    src = fetchFromGitHub {
      owner = "euclidianAce";
      repo = "tree-sitter-teal";
      rev = "485fbdc00d811b01b2090dff4d0469fd1d0350f5";
      hash = "sha256-Py825x38vkRgHqqEg/btFVQMgalSdonEgtFKSLPlZdw=";
    };
    generate = true;
    meta.homepage = "https://github.com/euclidianAce/tree-sitter-teal";
  };
  templ = buildGrammar {
    language = "templ";
    version = "0.0.0+rev=73a5587";
    src = fetchFromGitHub {
      owner = "vrischmann";
      repo = "tree-sitter-templ";
      rev = "73a558744fff7c4560f4801e14a467811f608556";
      hash = "sha256-Wdu3CtjITuRUFmq3FfDZKIKE9t9vYMFv+CG5J0BBYGU=";
    };
    meta.homepage = "https://github.com/vrischmann/tree-sitter-templ";
  };
  terraform = buildGrammar {
    language = "terraform";
    version = "0.0.0+rev=9e3ec98";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-hcl";
      rev = "9e3ec9848f28d26845ba300fd73c740459b83e9b";
      hash = "sha256-HM77BXavgP+H3XwHSqRdLlylmkH+idtuZqLeOV2VUiM=";
    };
    location = "dialects/terraform";
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-hcl";
  };
  textproto = buildGrammar {
    language = "textproto";
    version = "0.0.0+rev=568471b";
    src = fetchFromGitHub {
      owner = "PorterAtGoogle";
      repo = "tree-sitter-textproto";
      rev = "568471b80fd8793d37ed01865d8c2208a9fefd1b";
      hash = "sha256-VAj8qSxbkFqNp0X8BOZNvGTggSXZvzDjODedY11J0BQ=";
    };
    meta.homepage = "https://github.com/PorterAtGoogle/tree-sitter-textproto";
  };
  thrift = buildGrammar {
    language = "thrift";
    version = "0.0.0+rev=68fd0d8";
    src = fetchFromGitHub {
      owner = "duskmoon314";
      repo = "tree-sitter-thrift";
      rev = "68fd0d80943a828d9e6f49c58a74be1e9ca142cf";
      hash = "sha256-owZbs8ttjKrqTA8fQ/NmBGyIUUItSUvvW4hRv0NPV8Y=";
    };
    meta.homepage = "https://github.com/duskmoon314/tree-sitter-thrift";
  };
  tiger = buildGrammar {
    language = "tiger";
    version = "0.0.0+rev=a7f11d9";
    src = fetchFromGitHub {
      owner = "ambroisie";
      repo = "tree-sitter-tiger";
      rev = "a7f11d946b44244f71df41d2a78af0665d618dae";
      hash = "sha256-zGrbf5cCkgKGw+dQiEqUyHqj8Fu42MfAhEEADoC8DIA=";
    };
    meta.homepage = "https://github.com/ambroisie/tree-sitter-tiger";
  };
  tlaplus = buildGrammar {
    language = "tlaplus";
    version = "0.0.0+rev=d711f24";
    src = fetchFromGitHub {
      owner = "tlaplus-community";
      repo = "tree-sitter-tlaplus";
      rev = "d711f24c93221cdfc9a9b4dbb0998f528fc982ac";
      hash = "sha256-CHoqOY990/30GqLkxee/xexQ9uni7VTdW0iZ+inunoc=";
    };
    meta.homepage = "https://github.com/tlaplus-community/tree-sitter-tlaplus";
  };
  tmux = buildGrammar {
    language = "tmux";
    version = "0.0.0+rev=0252ecd";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-tmux";
      rev = "0252ecd080016e45e6305ef1a943388f5ae2f4b4";
      hash = "sha256-8f78qYxqoiOAnl3HzEbF4Rci3rFy0SnELoU+QP7pUlk=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-tmux";
  };
  todotxt = buildGrammar {
    language = "todotxt";
    version = "0.0.0+rev=3937c5c";
    src = fetchFromGitHub {
      owner = "arnarg";
      repo = "tree-sitter-todotxt";
      rev = "3937c5cd105ec4127448651a21aef45f52d19609";
      hash = "sha256-OeAh51rcFTiexAraRzIZUR/A8h9RPwKY7rmtc3ZzoRQ=";
    };
    meta.homepage = "https://github.com/arnarg/tree-sitter-todotxt";
  };
  toml = buildGrammar {
    language = "toml";
    version = "0.0.0+rev=16a30c8";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-toml";
      rev = "16a30c83ce427385b8d14939c45c137fcfca6c42";
      hash = "sha256-VYsPM0NVxegfanVaaKkSkEzJ502xkKSjZWrsJpDmack=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-toml";
  };
  tsv = buildGrammar {
    language = "tsv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "tsv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  tsx = buildGrammar {
    language = "tsx";
    version = "0.0.0+rev=45af495";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-typescript";
      rev = "45af49560396d67a710b21a3ce315fcaa09006ff";
      hash = "sha256-15TAkZeoHTQvPqswlP8dFMyt8F/ztozaJtZys49rzeM=";
    };
    location = "tsx";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-typescript";
  };
  turtle = buildGrammar {
    language = "turtle";
    version = "0.0.0+rev=7f789ea";
    src = fetchFromGitHub {
      owner = "GordianDziwis";
      repo = "tree-sitter-turtle";
      rev = "7f789ea7ef765080f71a298fc96b7c957fa24422";
      hash = "sha256-z6f73euFAG9du5owz7V9WLbWK81Jg0DwxN1metKPbTA=";
    };
    meta.homepage = "https://github.com/GordianDziwis/tree-sitter-turtle";
  };
  twig = buildGrammar {
    language = "twig";
    version = "0.0.0+rev=085648e";
    src = fetchFromGitHub {
      owner = "gbprod";
      repo = "tree-sitter-twig";
      rev = "085648e01d1422163a1702a44e72303b4e2a0bd1";
      hash = "sha256-87jFYAAnblTeEdlXqTjyiiNee/OgasPam1b2xyKQIHY=";
    };
    meta.homepage = "https://github.com/gbprod/tree-sitter-twig";
  };
  typescript = buildGrammar {
    language = "typescript";
    version = "0.0.0+rev=45af495";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-typescript";
      rev = "45af49560396d67a710b21a3ce315fcaa09006ff";
      hash = "sha256-15TAkZeoHTQvPqswlP8dFMyt8F/ztozaJtZys49rzeM=";
    };
    location = "typescript";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-typescript";
  };
  typespec = buildGrammar {
    language = "typespec";
    version = "0.0.0+rev=0ee0554";
    src = fetchFromGitHub {
      owner = "happenslol";
      repo = "tree-sitter-typespec";
      rev = "0ee05546d73d8eb64635ed8125de6f35c77759fe";
      hash = "sha256-qXA87soeEdlpzj8svEao8L0F5V14NSZc1WsX9z0PVB0=";
    };
    meta.homepage = "https://github.com/happenslol/tree-sitter-typespec";
  };
  typoscript = buildGrammar {
    language = "typoscript";
    version = "0.0.0+rev=43b221c";
    src = fetchFromGitHub {
      owner = "Teddytrombone";
      repo = "tree-sitter-typoscript";
      rev = "43b221c0b76e77244efdaa9963e402a17c930fbc";
      hash = "sha256-7ottrupSWC83rDP59yceDG/TuikNHoyCBnAlns/x6Tc=";
    };
    meta.homepage = "https://github.com/Teddytrombone/tree-sitter-typoscript";
  };
  typst = buildGrammar {
    language = "typst";
    version = "0.0.0+rev=8b8b16e";
    src = fetchFromGitHub {
      owner = "uben0";
      repo = "tree-sitter-typst";
      rev = "8b8b16ef1b40cbecbe3f754b1c1c966b5a0904fe";
      hash = "sha256-eoaIt5yy0mIodjYq1sy6X7uq4ZhQXlbndMThAlCAifs=";
    };
    meta.homepage = "https://github.com/uben0/tree-sitter-typst";
  };
  udev = buildGrammar {
    language = "udev";
    version = "0.0.0+rev=18a1d18";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-udev";
      rev = "18a1d183c4c0cc40438bae2ebf8191aaf2dee8dc";
      hash = "sha256-ySo+vS+il1tmTPZ6OJMduyJxsjjI3eIkYSMYs10Bcnk=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-udev";
  };
  ungrammar = buildGrammar {
    language = "ungrammar";
    version = "0.0.0+rev=debd26f";
    src = fetchFromGitHub {
      owner = "Philipp-M";
      repo = "tree-sitter-ungrammar";
      rev = "debd26fed283d80456ebafa33a06957b0c52e451";
      hash = "sha256-ftvcD8I+hYqH3EGxaRZ0w8FHjBA34OSTTsrUsAOtayU=";
    };
    meta.homepage = "https://github.com/Philipp-M/tree-sitter-ungrammar";
  };
  unison = buildGrammar {
    language = "unison";
    version = "0.0.0+rev=3c97db7";
    src = fetchFromGitHub {
      owner = "kylegoetz";
      repo = "tree-sitter-unison";
      rev = "3c97db76d3cdbd002dfba493620c2d5df2fd6fa9";
      hash = "sha256-xveOQpCCkYdeiPkRbFlPNfXOpWW0lzCxfQbxXz+eurM=";
    };
    generate = true;
    meta.homepage = "https://github.com/kylegoetz/tree-sitter-unison";
  };
  usd = buildGrammar {
    language = "usd";
    version = "0.0.0+rev=4e0875f";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-usd";
      rev = "4e0875f724d94d0c2ff36f9b8cb0b12f8b20d216";
      hash = "sha256-r6Sm8FiTgxdYc5cAG5JXVtA5/2jID5H/xmKbjSYn/zI=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-usd";
  };
  uxntal = buildGrammar {
    language = "uxntal";
    version = "0.0.0+rev=ad9b638";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-uxntal";
      rev = "ad9b638b914095320de85d59c49ab271603af048";
      hash = "sha256-hR0EaYv1++MJ0pdBl3ZtyEljitnp5hgFWQa9F6b1KE4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-uxntal";
  };
  v = buildGrammar {
    language = "v";
    version = "0.0.0+rev=8f1a06b";
    src = fetchFromGitHub {
      owner = "vlang";
      repo = "v-analyzer";
      rev = "8f1a06b488e65aeeb340d5e2ae3e703a104bd5c4";
      hash = "sha256-ZpwEA9lH5IiqBjlEXY7fMGHWwhq428la1CdqkcJRTeQ=";
    };
    location = "tree_sitter_v";
    meta.homepage = "https://github.com/vlang/v-analyzer";
  };
  vala = buildGrammar {
    language = "vala";
    version = "0.0.0+rev=97e6db3";
    src = fetchFromGitHub {
      owner = "vala-lang";
      repo = "tree-sitter-vala";
      rev = "97e6db3c8c73b15a9541a458d8e797a07f588ef4";
      hash = "sha256-hAekweZGDHVrWVd04RrN+9Jz0D2kode+DpceTlUXii0=";
    };
    meta.homepage = "https://github.com/vala-lang/tree-sitter-vala";
  };
  vento = buildGrammar {
    language = "vento";
    version = "0.0.0+rev=3321077";
    src = fetchFromGitHub {
      owner = "ventojs";
      repo = "tree-sitter-vento";
      rev = "3321077d7446c1b3b017c294fd56ce028ed817fe";
      hash = "sha256-/U8hZiYC9/pWscAYDIFgttLDMTq6RLNuHKNTZ/Q4bAc=";
    };
    meta.homepage = "https://github.com/ventojs/tree-sitter-vento";
  };
  verilog = buildGrammar {
    language = "verilog";
    version = "0.0.0+rev=0dacb91";
    src = fetchFromGitHub {
      owner = "gmlarumbe";
      repo = "tree-sitter-systemverilog";
      rev = "0dacb911daa9614a7c7e79a594d4cb9f478e6554";
      hash = "sha256-WATrVeP3c//tWLG8VibXZrYrChBs7d4V6LCcEGcofdg=";
    };
    meta.homepage = "https://github.com/gmlarumbe/tree-sitter-systemverilog";
  };
  vhdl = buildGrammar {
    language = "vhdl";
    version = "0.0.0+rev=b4e73e0";
    src = fetchFromGitHub {
      owner = "jpt13653903";
      repo = "tree-sitter-vhdl";
      rev = "b4e73e0c0a09af83e10145953cfbd3652c2833dc";
      hash = "sha256-R6XPzqNkACKEMSz9Ni2Ic5aHyZ7bcp69z2cmOQCah/s=";
    };
    meta.homepage = "https://github.com/jpt13653903/tree-sitter-vhdl";
  };
  vhs = buildGrammar {
    language = "vhs";
    version = "0.0.0+rev=09f8fbf";
    src = fetchFromGitHub {
      owner = "charmbracelet";
      repo = "tree-sitter-vhs";
      rev = "09f8fbfe40a3a699b200daca7d92e65fbbe9f9e6";
      hash = "sha256-TUA94sJVWGK0KdvMueyQDmU+AlhdCOg0mlwcfL0XG8E=";
    };
    meta.homepage = "https://github.com/charmbracelet/tree-sitter-vhs";
  };
  vim = buildGrammar {
    language = "vim";
    version = "0.0.0+rev=f3cd62d";
    src = fetchFromGitHub {
      owner = "neovim";
      repo = "tree-sitter-vim";
      rev = "f3cd62d8bd043ef20507e84bb6b4b53731ccf3a7";
      hash = "sha256-KVaTJKU7r7zk57Fn9zl5s34oq8tsLkSRV3VHM6Q6F+s=";
    };
    meta.homepage = "https://github.com/neovim/tree-sitter-vim";
  };
  vimdoc = buildGrammar {
    language = "vimdoc";
    version = "0.0.0+rev=d2e4b5c";
    src = fetchFromGitHub {
      owner = "neovim";
      repo = "tree-sitter-vimdoc";
      rev = "d2e4b5c172a109966c2ce0378f73df6cede39400";
      hash = "sha256-Vrl4/cZL+TWlUMEeWZoHCAWhvlefcl3ajGcwyTNKOhI=";
    };
    meta.homepage = "https://github.com/neovim/tree-sitter-vimdoc";
  };
  vrl = buildGrammar {
    language = "vrl";
    version = "0.0.0+rev=274b3ce";
    src = fetchFromGitHub {
      owner = "belltoy";
      repo = "tree-sitter-vrl";
      rev = "274b3ce63f72aa8ffea18e7fc280d3062d28f0ba";
      hash = "sha256-R+wuG8UkvGA11uTiiUAdzzgjRv1ik4W+qh3YwIREUd4=";
    };
    meta.homepage = "https://github.com/belltoy/tree-sitter-vrl";
  };
  vue = buildGrammar {
    language = "vue";
    version = "0.0.0+rev=22bdfa6";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-vue";
      rev = "22bdfa6c9fc0f5ffa44c6e938ec46869ac8a99ff";
      hash = "sha256-LnmUtJJpBIZPTJqrQQ7WI8V44hPw3yxR+j2jR0pHIdY=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-vue";
  };
  wgsl = buildGrammar {
    language = "wgsl";
    version = "0.0.0+rev=40259f3";
    src = fetchFromGitHub {
      owner = "szebniok";
      repo = "tree-sitter-wgsl";
      rev = "40259f3c77ea856841a4e0c4c807705f3e4a2b65";
      hash = "sha256-voLkcJ/062hzipb3Ak/mgQvFbrLUJdnXq1IupzjMJXA=";
    };
    meta.homepage = "https://github.com/szebniok/tree-sitter-wgsl";
  };
  wgsl_bevy = buildGrammar {
    language = "wgsl_bevy";
    version = "0.0.0+rev=47c1818";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-wgsl-bevy";
      rev = "47c1818d245a6156a488c4c4d06e9336714bae9b";
      hash = "sha256-oL9HDMDl6MgDLZw4NWtdX7W775JZKwD2BweAO+9iI/k=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-wgsl-bevy";
  };
  wing = buildGrammar {
    language = "wing";
    version = "0.0.0+rev=76e0c25";
    src = fetchFromGitHub {
      owner = "winglang";
      repo = "tree-sitter-wing";
      rev = "76e0c25844a66ebc6e866d690fcc5f4e90698947";
      hash = "sha256-N16cZK1dERqFd1FR35AfrsBy5EeeOPSp0FaZ83pMt7I=";
    };
    meta.homepage = "https://github.com/winglang/tree-sitter-wing";
  };
  wit = buildGrammar {
    language = "wit";
    version = "0.0.0+rev=81490b4";
    src = fetchFromGitHub {
      owner = "liamwh";
      repo = "tree-sitter-wit";
      rev = "81490b4e74c792369e005f72b0d46fe082d3fed2";
      hash = "sha256-L8dIOVJ3L2TXg1l4BXMOQeOsNxVkGPZimG619n3kHZE=";
    };
    meta.homepage = "https://github.com/liamwh/tree-sitter-wit";
  };
  xcompose = buildGrammar {
    language = "xcompose";
    version = "0.0.0+rev=fff3e72";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-xcompose";
      rev = "fff3e72242aa110ebba6441946ea4d12d200fa68";
      hash = "sha256-PNg1z+7CuvpQdksKJOCQ59dZrv4PORdYo6CSw3GrBtk=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-xcompose";
  };
  xml = buildGrammar {
    language = "xml";
    version = "0.0.0+rev=4b64dd3";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-xml";
      rev = "4b64dd3a03ec002258d6268d712fd93716d6ab57";
      hash = "sha256-/0IQsTkvFQOWnkLc2srjg2bn1sB1sNA6Sm3nwKGUDj4=";
    };
    location = "xml";
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-xml";
  };
  xresources = buildGrammar {
    language = "xresources";
    version = "0.0.0+rev=a75056c";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-xresources";
      rev = "a75056c2e1bed83c338ff394dbb7c653db210432";
      hash = "sha256-lGQYY0hlOc7qp2MgNfCKPizDl8XOTbWraEw02xJVMcg=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-xresources";
  };
  yaml = buildGrammar {
    language = "yaml";
    version = "0.0.0+rev=7b03fee";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-yaml";
      rev = "7b03feefd36b5f155465ca736c6304aca983b267";
      hash = "sha256-hjZQv8kMpjJ29Rl6CEBwb090rFNWP1HPkSECbmTr0zQ=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-yaml";
  };
  yang = buildGrammar {
    language = "yang";
    version = "0.0.0+rev=2c0e6be";
    src = fetchFromGitHub {
      owner = "Hubro";
      repo = "tree-sitter-yang";
      rev = "2c0e6be8dd4dcb961c345fa35c309ad4f5bd3502";
      hash = "sha256-6EIK1EStHrUHBLZBsZqd1LL05ZAJ6PKUyIzBBsTVjO8=";
    };
    meta.homepage = "https://github.com/Hubro/tree-sitter-yang";
  };
  yuck = buildGrammar {
    language = "yuck";
    version = "0.0.0+rev=e877f6a";
    src = fetchFromGitHub {
      owner = "Philipp-M";
      repo = "tree-sitter-yuck";
      rev = "e877f6ade4b77d5ef8787075141053631ba12318";
      hash = "sha256-l8c1/7q8S78jGyl+VAVVgs8wq58PrrjycyJfWXsCgAI=";
    };
    meta.homepage = "https://github.com/Philipp-M/tree-sitter-yuck";
  };
  zathurarc = buildGrammar {
    language = "zathurarc";
    version = "0.0.0+rev=0554b4a";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-zathurarc";
      rev = "0554b4a5d313244b7fc000cbb41c04afae4f4e31";
      hash = "sha256-edwLcz1WlcRJOoV2Unpho8wmi7TmcpwysBOAdRKprNw=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-zathurarc";
  };
  zig = buildGrammar {
    language = "zig";
    version = "0.0.0+rev=eb7d58c";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-zig";
      rev = "eb7d58c2dc4fbeea4745019dee8df013034ae66b";
      hash = "sha256-iyb79SiMsV94RrWH/1Oi2aKBiX5io0Dp+zZf8qWZHwg=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-zig";
  };
  ziggy = buildGrammar {
    language = "ziggy";
    version = "0.0.0+rev=fe73bee";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "ziggy";
      rev = "fe73beef9f52f04048d8b19016fc4fbc66b4596f";
      hash = "sha256-GSiVrl3GMp5Y8DF/gxdl1ToUoN5s3RQxNKxmab5tSHs=";
    };
    location = "tree-sitter-ziggy";
    meta.homepage = "https://github.com/kristoff-it/ziggy";
  };
  ziggy_schema = buildGrammar {
    language = "ziggy_schema";
    version = "0.0.0+rev=fe73bee";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "ziggy";
      rev = "fe73beef9f52f04048d8b19016fc4fbc66b4596f";
      hash = "sha256-GSiVrl3GMp5Y8DF/gxdl1ToUoN5s3RQxNKxmab5tSHs=";
    };
    location = "tree-sitter-ziggy-schema";
    meta.homepage = "https://github.com/kristoff-it/ziggy";
  };
}
