{
  lib,
  stdenv,
  fetchFromGitLab,
  makeWrapper,
}:

stdenv.mkDerivation rec {
  pname = "exploitdb";
  version = "2024-11-16";

  src = fetchFromGitLab {
    owner = "exploit-database";
    repo = "exploitdb";
    rev = "refs/tags/${version}";
    hash = "sha256-49xG3mVh5M9MfK4WuU3rc9Q+QlZo7IyV3jwAdBUEmu0=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall
    mkdir -p $out/bin $out/share
    cp --recursive . $out/share/exploitdb
    makeWrapper $out/share/exploitdb/searchsploit $out/bin/searchsploit
    runHook postInstall
  '';

  meta = with lib; {
    description = "Archive of public exploits and corresponding vulnerable software";
    homepage = "https://gitlab.com/exploit-database/exploitdb";
    license = with licenses; [
      gpl2Plus
      gpl3Plus
      mit
    ];
    maintainers = with maintainers; [
      applePrincess
      fab
    ];
    mainProgram = "searchsploit";
    platforms = platforms.unix;
  };
}
