{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "go-cve-search";
  version = "0.1.4";

  src = fetchFromGitHub {
    owner = "s-index";
    repo = pname;
    rev = "refs/tags/v${version}";
    hash = "sha256-ofa6lfA3XKj70YM6AVNKRgGI53teK7OB09luAom8HpQ=";
  };

  vendorHash = "sha256-QXYjLPrfIPcZE8UTcE1kR9QQIusR/rAJG+e/IQ4P0PU=";

  # Tests requires network access
  doCheck = false;

  meta = with lib; {
    description = "Lightweight CVE search tool";
    mainProgram = "go-cve-search";
    longDescription = ''
      go-cve-search is a lightweight tool to search CVE (Common Vulnerabilities
      and Exposures).
    '';
    homepage = "https://github.com/s-index/go-cve-search";
    changelog = "https://github.com/s-index/go-cve-search/releases/tag/v${version}";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
  };
}
