{
  lib,
  stdenv,
  fetchFromGitHub,
  perl,
}:

stdenv.mkDerivation rec {
  pname = "libx86emu";
  version = "3.5";

  src = fetchFromGitHub {
    owner = "wfeldt";
    repo = "libx86emu";
    rev = version;
    sha256 = "sha256-dKT/Ey+vardXu/+coaC69TTUXjJLsLBKgCx9VY8f0oY=";
  };

  nativeBuildInputs = [ perl ];

  postUnpack = "rm $sourceRoot/git2log";
  patchPhase = ''
    # VERSION is usually generated using Git
    echo "${version}" > VERSION
    substituteInPlace Makefile --replace "/usr" "/"
  '';

  buildFlags = [
    "shared"
    "CC=${stdenv.cc.targetPrefix}cc"
  ];
  enableParallelBuilding = true;

  installFlags = [
    "DESTDIR=$(out)"
    "LIBDIR=/lib"
  ];

  meta = with lib; {
    description = "x86 emulation library";
    license = licenses.bsd2;
    homepage = "https://github.com/wfeldt/libx86emu";
    maintainers = with maintainers; [ bobvanderlinden ];
    platforms = platforms.linux;
  };
}
