{
  stdenv,
  lib,
  fetchurl,
  autoPatchelfHook,
  dpkg,
  qt5,
  libjack2,
  alsa-lib,
  bzip2,
  libpulseaudio,
  xz,
}:

stdenv.mkDerivation rec {
  pname = "ocenaudio";
  version = "3.13.8";

  src = fetchurl {
    url = "https://www.ocenaudio.com/downloads/index.php/ocenaudio_debian9_64.deb?version=v${version}";
    hash = "sha256-GKNho2xV6Lc4U5Ys4j+ZiGxE8irolcrTttN3PG1S2Ug=";
  };

  nativeBuildInputs = [
    alsa-lib
    autoPatchelfHook
    bzip2
    libjack2
    libpulseaudio
    qt5.qtbase
    qt5.wrapQtAppsHook
    xz
  ];

  buildInputs = [ dpkg ];

  dontUnpack = true;
  dontBuild = true;
  dontStrip = true;

  installPhase = ''
    mkdir -p $out
    dpkg -x $src $out
    cp -av $out/opt/ocenaudio/* $out
    rm -rf $out/opt
    mv $out/usr/share $out/share
    rm -rf $out/usr
    substituteInPlace $out/share/applications/ocenaudio.desktop \
      --replace-fail "/opt/ocenaudio/bin/ocenaudio" "ocenaudio"
    mkdir -p $out/share/licenses/ocenaudio
    mv $out/bin/ocenaudio_license.txt $out/share/licenses/ocenaudio/LICENSE

    # Create symlink bzip2 library
    ln -s ${bzip2.out}/lib/libbz2.so.1 $out/lib/libbz2.so.1.0
  '';

  meta = with lib; {
    description = "Cross-platform, easy to use, fast and functional audio editor";
    homepage = "https://www.ocenaudio.com";
    sourceProvenance = with sourceTypes; [ binaryNativeCode ];
    license = licenses.unfree;
    platforms = [ "x86_64-linux" ];
    maintainers = with maintainers; [ onny ];
  };
}
