{
  lib,
  stdenv,
  fetchurl,
  fetchpatch,
  xmlto,
  docbook_xml_dtd_412,
  docbook_xsl,
  autoconf,
  automake,
  libtool,
  autoreconfHook,
}:

stdenv.mkDerivation rec {
  pname = "opensp";
  version = "1.5.2";

  src = fetchurl {
    url = "mirror://sourceforge/openjade/OpenSP-${version}.tar.gz";
    sha256 = "1khpasr6l0a8nfz6kcf3s81vgdab8fm2dj291n5r2s53k228kx2p";
  };

  postPatch = ''
    sed -i s,/usr/share/sgml/docbook/xml-dtd-4.1.2/,${docbook_xml_dtd_412}/xml/dtd/docbook/, \
      docsrc/*.xml
  '';

  patches = [
    (fetchpatch {
      url = "https://gitweb.gentoo.org/repo/gentoo.git/plain/app-text/opensp/files/opensp-1.5.2-c11-using.patch?id=688d9675782dfc162d4e6cff04c668f7516118d0";
      sha256 = "04q14s8qsad0bkjmj067dn831i0r6v7742rafdlnbfm5y249m2q6";
    })
    # Clang 16 defaults to C++17, which does not allow `register` as a storage class specifier.
    ./fix-register-storage-class.patch
  ];

  setupHook = ./setup-hook.sh;

  postFixup = ''
    # Remove random ids in the release notes
    sed -i -e 's/href="#idm.*"//g' $out/share/doc/OpenSP/releasenotes.html
    sed -i -e 's/name="idm.*"//g' $out/share/doc/OpenSP/releasenotes.html
  '';

  preConfigure = lib.optionalString stdenv.hostPlatform.isCygwin ''
    autoreconf -fi
  '';

  strictDeps = true;

  nativeBuildInputs =
    [
      xmlto
      docbook_xml_dtd_412
      docbook_xsl
    ]
    # Clang 16 fails to build due to inappropriate definitions in the `config.h` generated by the
    # existing configure scripts. Regenerate them to make sure they detect its features correctly.
    ++ lib.optional stdenv.cc.isClang autoreconfHook
    ++ lib.optionals stdenv.hostPlatform.isCygwin [
      autoconf
      automake
      libtool
    ];

  env = lib.optionalAttrs stdenv.cc.isGNU {
    NIX_CFLAGS_COMPILE = "-fpermissive";
  };

  doCheck = false; # fails

  meta = with lib; {
    description = "Suite of SGML/XML processing tools";
    license = licenses.mit;
    homepage = "https://openjade.sourceforge.net/";
    platforms = platforms.unix;
    maintainers = [ ];
  };
}
