{
  aseprite,
  clangStdenv,
  expat,
  fetchFromGitHub,
  fetchgit,
  fontconfig,
  gn,
  harfbuzzFull,
  icu,
  lib,
  libglvnd,
  libjpeg,
  libpng,
  libwebp,
  libX11,
  mesa,
  ninja,
  python3,
  zlib,
}:

let
  # deps.nix is generated by ./update.sh
  depSrcs = import ./deps.nix { inherit fetchgit; };
in
clangStdenv.mkDerivation (finalAttrs: {
  pname = "skia-aseprite";
  version = "m102-861e4743af";

  src = fetchFromGitHub {
    owner = "aseprite";
    repo = "skia";
    rev = finalAttrs.version;
    hash = "sha256-IlZbalmHl549uDUfPG8hlzub8TLWhG0EsV6HVAPdsl0=";
  };

  nativeBuildInputs = [
    gn
    ninja
    python3
  ];

  preConfigure = with depSrcs; ''
    mkdir -p third_party/externals
    ln -s ${angle2} third_party/externals/angle2
    ln -s ${dng_sdk} third_party/externals/dng_sdk
    ln -s ${piex} third_party/externals/piex
    ln -s ${sfntly} third_party/externals/sfntly
  '';

  configurePhase = ''
    runHook preConfigure
    gn gen lib --args="is_debug=false is_official_build=true extra_cflags=[\"-I${harfbuzzFull.dev}/include/harfbuzz\"]"
    runHook postConfigure
  '';

  buildInputs = [
    expat
    fontconfig
    harfbuzzFull
    icu
    libglvnd
    libjpeg
    libpng
    libwebp
    libX11
    mesa
    zlib
  ];

  buildPhase = ''
    runHook preBuild
    ninja -C lib skia modules
    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall
    mkdir -p $out

    # Glob will match all subdirs.
    shopt -s globstar

    # All these paths are used in some way when building Aseprite.
    cp -r --parents -t $out/ \
      include/codec \
      include/config \
      include/core \
      include/effects \
      include/gpu \
      include/private \
      include/utils \
      include/third_party/skcms/*.h \
      lib/*.a \
      modules/skshaper/include/*.h \
      src/core/*.h \
      src/gpu/**/*.h \
      third_party/externals/angle2/include \
      third_party/skcms/**/*.h

    runHook postInstall
  '';

  passthru.updateScript = [ ./update.sh ] ++ builtins.attrNames depSrcs;

  meta = {
    description = "Complete 2D graphic library for drawing Text, Geometries, and Images (Aseprite's fork)";
    homepage = "https://skia.org/";
    downloadPage = "https://github.com/aseprite/skia";
    license = lib.licenses.bsd3;
    inherit (aseprite.meta) maintainers;
    platforms = lib.platforms.all;
  };
})
