{
  lib,
  fetchFromGitHub,
  ocamlPackages,
  pkg-config,
  libdrm,
  unstableGitUpdater,
}:

ocamlPackages.buildDunePackage rec {
  pname = "wayland-proxy-virtwl";
  version = "0-unstable-2024-06-17";

  src = fetchFromGitHub {
    owner = "talex5";
    repo = pname;
    rev = "1c0cd6d4f13454f0c72148b4c4a1c1e3b728205e";
    sha256 = "sha256-E9UTq9sNBdg+ANO8b9Nga/JBD+Tt9O5QV5NQmbY6GLE=";
  };

  minimalOCamlVersion = "5.0";

  nativeBuildInputs = [
    pkg-config
  ];

  buildInputs =
    [ libdrm ]
    ++ (with ocamlPackages; [
      dune-configurator
      eio_main
      ppx_cstruct
      wayland
      cmdliner
      logs
      ppx_cstruct
    ]);

  doCheck = true;

  passthru.updateScript = unstableGitUpdater { };

  meta = with lib; {
    homepage = "https://github.com/talex5/wayland-virtwl-proxy";
    description = "Proxy Wayland connections across a VM boundary";
    license = licenses.asl20;
    mainProgram = "wayland-proxy-virtwl";
    maintainers = [
      maintainers.qyliss
      maintainers.sternenseemann
    ];
    platforms = platforms.linux;
  };
}
