# GNOME Shell extensions

All extensions are packaged automatically. They can be found in the `pkgs.gnomeXYExtensions` for XY being a GNOME version. The package names are the extension’s UUID, which can be a bit unwieldy to use. `pkgs.gnomeExtensions` is a set of manually curated extensions that match the current `gnome.gnome-shell` versions. Their name is human-friendly, compared to the other extensions sets. Some of its extensions are manually packaged.

## Automatically packaged extensions

The actual packages are created by `buildGnomeExtension.nix`, provided the correct arguments are fed into it. The important extension data is stored in `extensions.json`, one line/item per extension. That file is generated by running `update-extensions.py`. Furthermore, the automatic generated names are dumped in `collisions.json` for manual inspection. `extensionRenames.nix` contains new names for all extensions that collide.

### Extensions updates

For everyday updates,

1. Run `update-extensions.py`.
2. Update `extensionRenames.nix` according to the comment at the top.

For GNOME updates,

1. Add a new `gnomeXYExtensions` set
2. Remove old ones for GNOME versions we don’t want to support any more
3. Update `supported_versions` in `./update-extensions.py` and re-run it
4. Change `gnomeExtensions` to the new version
5. Update `./extensionsRenames.nix` accordingly
6. Update `all-packages.nix` accordingly (grep for `gnomeExtensions`)

## Manually packaged extensions

Manually packaged extensions overwrite some of the automatically packaged ones in `pkgs.gnomeExtensions`. They are listed in `manuallyPackaged.nix`, every extension has its own sub-folder.
