{
  lib,
  mkCoqDerivation,
  which,
  coq,
  metacoq,
  version ? null,
}:

with lib;
mkCoqDerivation {
  pname = "ElmExtraction";
  repo = "coq-elm-extraction";
  owner = "AU-COBRA";
  domain = "github.com";

  inherit version;
  defaultVersion =
    with versions;
    switch
      [
        coq.coq-version
        metacoq.version
      ]
      [
        {
          cases = [
            (range "8.17" "8.20")
            (range "1.3.1" "1.3.2")
          ];
          out = "0.1.0";
        }
      ]
      null;

  release."0.1.0".sha256 = "EWjubBHsxAl2HuRAfJI3B9qzP2mj89eh0CUc8y7/7Ds=";

  releaseRev = v: "v${v}";

  propagatedBuildInputs = [
    coq.ocamlPackages.findlib
    metacoq
  ];

  postPatch = ''patchShebangs ./tests/process-extraction-examples.sh'';

  meta = {
    description = "A framework for extracting Coq programs to Elm";
    maintainers = with maintainers; [ _4ever2 ];
    license = licenses.mit;
  };
}
